/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.parser;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.dbaccess.ViewReportTablesUpdater;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.DiscoveryActivator;
import org.eclipse.aperi.discovery.interfaces.DiscoveryException;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.AlertProcessor;
import org.eclipse.aperi.discovery.parser.EntityPersistWrapper;
import org.eclipse.aperi.discovery.parser.PersistWrapper;
import org.eclipse.aperi.discovery.parser.RelationshipPersistWrapper;
import org.eclipse.aperi.discovery.parser.TSANMLegacyParser;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.database.objects.Scanner;
import org.eclipse.aperi.infrastructure.history.detectability.ChangeDetection;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityResult;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityService;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response;
import org.sblim.wbem.cim.CIMValue;

public class Processor {
    private static int numOperationsPerTransaction;
    private static final int DEFAULT_NUM_OPERATIONS_PER_TRANSACTION = 1;
    private static final String PROPERTY_NUM_OPS_PER_TRANSACTION = "NumOperationsPerTransaction";
    private static final String PROPERTY_GROUP = "DiscoverService";
    private static final int MaxNumRetries = 20;
    private static IConfigService configServiceProxy;
    static ILogger msgLogger;
    static ILogger traceLogger;
    static final String className;
    protected static String discoverEventPrefix;
    private static boolean timeToShutdown;
    protected DBConnection connection = null;
    private String sourceType = null;
    private MapperRouter mapperRouter = MapperRouter.getMapperRouter();
    private ViewReportTablesUpdater vrtu = null;
    private static IEventMonitorService eventMonitor;
    protected Hashtable newEntities = new Hashtable();
    protected Hashtable modifiedEntities = new Hashtable();
    private ChangeDetection changeDetection = null;
    private List history = new ArrayList();

    static {
        Class<?> clazz;
        numOperationsPerTransaction = 0;
        configServiceProxy = null;
        msgLogger = TSANMLegacyParser.msgLogger;
        traceLogger = TSANMLegacyParser.traceLogger;
        try {
            clazz = Class.forName("org.eclipse.aperi.discovery.parser.Processor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        discoverEventPrefix = "D";
        timeToShutdown = false;
        eventMonitor = null;
    }

    public Processor(String string) {
        this.sourceType = string;
        try {
            DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
            this.connection = (DBConnection)dBConnPoolDataSource.getPooledConnection();
            this.changeDetection = new ChangeDetection(this.connection);
            this.vrtu = new ViewReportTablesUpdater();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void shutdown() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.connection = null;
        }
    }

    public boolean start(int n) {
        block4: {
            String string = "start";
            Request request = Router.getRouter().getRequest(new Integer(n).toString());
            if (request != null) {
                Request request2 = request.getParentRequest();
                if (!(request.getScannerId() == null || request2 != null && request2.getScannerId() != null && request2.getScannerId().equals(request.getScannerId()))) {
                    try {
                        DetectabilityService.startDiscovery((String)request.getScannerId(), (int)request.getAuthoritativeReferenceType(), (int)request.getAuthoritativeReferenceId(), (String)(String.valueOf(discoverEventPrefix) + request.getId()));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, string, (Throwable)exception);
                        if (!traceLogger.isLogging()) break block4;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                    }
                }
            }
        }
        return true;
    }

    public boolean start(JobInfo jobInfo) {
        if (!this.checkLevel(jobInfo)) {
            return false;
        }
        this.start(Integer.parseInt(jobInfo.getDiscoverRequest()));
        return this.isReturnCodeOK(jobInfo);
    }

    public void finish() {
        try {
            this.connection.commit();
            this.history.clear();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void end(int n) {
        String string = "end";
        try {
            this.connection.commit();
            this.history.clear();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        Request request = Router.getRouter().getRequest(new Integer(n).toString());
        if (request != null) {
            block16: {
                Request request2 = request.getParentRequest();
                if (!(request.getScannerId() == null || request2 != null && request2.getScannerId() != null && request2.getScannerId().equals(request.getScannerId()))) {
                    try {
                        DetectabilityResult detectabilityResult = DetectabilityService.stopDiscovery((String)request.getScannerId());
                        if (detectabilityResult.modifiedEntities != null) {
                            Iterator iterator = detectabilityResult.modifiedEntities.keySet().iterator();
                            while (iterator.hasNext()) {
                                String string2 = (String)iterator.next();
                                List list = (List)detectabilityResult.modifiedEntities.get(string2);
                                if (list == null) continue;
                                List list2 = (List)this.modifiedEntities.get(string2);
                                if (list2 == null) {
                                    this.modifiedEntities.put(string2, list);
                                    continue;
                                }
                                list2.addAll(list);
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, string, (Throwable)exception);
                        if (!traceLogger.isLogging()) break block16;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                    }
                }
            }
            try {
                this.connection.commit();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            this.changeDetection.startNew(this.connection, (Map)this.newEntities);
            this.newEntities.clear();
            try {
                this.changeDetection.complete(this.connection, (Map)this.modifiedEntities, String.valueOf(discoverEventPrefix) + new Integer(n).toString());
                this.modifiedEntities.clear();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            try {
                this.connection.commit();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            Processor.getEventMonitorProxy().handleModelUpdate(String.valueOf(discoverEventPrefix) + new Integer(n).toString());
            this.vrtu.processEntityView(request.getAuthoritativeReferenceId(), request.getAuthoritativeReferenceType());
        } else {
            System.out.println("Process.end - unable to find request for " + n);
        }
    }

    public void updateLevel(JobInfo jobInfo) {
        this.updateLevel(jobInfo, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateLevel(JobInfo var1_1, boolean var2_2) {
        block23: {
            var3_3 = true;
            var4_4 = "updateLevel";
            var5_5 = ServiceUtils.getConnection();
            var6_6 = new Scanner();
            var6_6.setScannerId(this.getScanID(var1_1));
            if (var1_1.isSuccessful() && !var2_2) {
                var6_6.setBenchmark(this.getLevel(var1_1));
            } else {
                var6_6.setBenchmark(-1);
            }
            try {
                try {
                    var6_6.update(var5_5);
                }
                catch (Exception var7_7) {
                    Processor.msgLogger.exception(IRecordType.TYPE_ERR, (Object)Processor.className, var4_4, (Throwable)var7_7);
                    if (Processor.traceLogger.isLogging()) {
                        Processor.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)Processor.className, var4_4, (Throwable)var7_7);
                    }
                    var3_3 = false;
                }
            }
            catch (Throwable var9_8) {
                block22: {
                    var8_9 = null;
                    try {
                        if (var5_5 == null) break block22;
                        if (var3_3) {
                            var5_5.commit();
                        } else {
                            var5_5.rollback();
                        }
                    }
                    catch (Exception var10_11) {
                        Processor.msgLogger.exception(IRecordType.TYPE_ERR, (Object)Processor.className, var4_4, (Throwable)var10_11);
                        if (Processor.traceLogger.isLogging()) {
                            Processor.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)Processor.className, var4_4, (Throwable)var10_11);
                        }
                        var3_3 = false;
                    }
                }
                try {
                    if (var5_5 == null) throw var9_8;
                    var5_5.close();
                    throw var9_8;
                }
                catch (Exception var10_11) {
                    Processor.msgLogger.exception(IRecordType.TYPE_ERR, (Object)Processor.className, var4_4, (Throwable)var10_11);
                    if (Processor.traceLogger.isLogging()) {
                        Processor.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)Processor.className, var4_4, (Throwable)var10_11);
                    }
                    var3_3 = false;
                }
                throw var9_8;
            }
            {
                var8_10 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 136->161)] { 
lbl49:
            // 1 sources

            if (var5_5 != null) {
                if (var3_3) {
                    var5_5.commit();
                    break block23;
                } else {
                    var5_5.rollback();
                }
            }
            break block23;
lbl56:
            // 1 sources

            catch (Exception var10_12) {
                Processor.msgLogger.exception(IRecordType.TYPE_ERR, (Object)Processor.className, var4_4, (Throwable)var10_12);
                if (Processor.traceLogger.isLogging()) {
                    Processor.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)Processor.className, var4_4, (Throwable)var10_12);
                }
                var3_3 = false;
            }
        }
        try {}
        catch (Exception var10_12) {
            Processor.msgLogger.exception(IRecordType.TYPE_ERR, (Object)Processor.className, var4_4, (Throwable)var10_12);
            if (Processor.traceLogger.isLogging() == false) return;
            Processor.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)Processor.className, var4_4, (Throwable)var10_12);
            return;
        }
        if (var5_5 == null) return;
        var5_5.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setInactiveProcessed(JobInfo var1_1, int var2_2) {
        block21: {
            var3_3 = true;
            var4_4 = "setInactiveProcessed";
            var5_5 = ServiceUtils.getConnection();
            var6_6 = new Scanner();
            var6_6.setScannerId(this.getScanID(var1_1));
            var6_6.setInactiveProcessed(var2_2);
            try {
                try {
                    var6_6.update(var5_5);
                }
                catch (Exception var7_7) {
                    Processor.msgLogger.exception(IRecordType.TYPE_ERR, (Object)Processor.className, var4_4, (Throwable)var7_7);
                    if (Processor.traceLogger.isLogging()) {
                        Processor.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)Processor.className, var4_4, (Throwable)var7_7);
                    }
                    var3_3 = false;
                }
            }
            catch (Throwable var9_8) {
                block20: {
                    var8_9 = null;
                    try {
                        if (var5_5 == null) break block20;
                        if (var3_3) {
                            var5_5.commit();
                        } else {
                            var5_5.rollback();
                        }
                    }
                    catch (Exception var10_11) {
                        Processor.msgLogger.exception(IRecordType.TYPE_ERR, (Object)Processor.className, var4_4, (Throwable)var10_11);
                        if (Processor.traceLogger.isLogging()) {
                            Processor.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)Processor.className, var4_4, (Throwable)var10_11);
                        }
                        var3_3 = false;
                    }
                }
                try {
                    if (var5_5 == null) throw var9_8;
                    var5_5.close();
                    throw var9_8;
                }
                catch (Exception var10_11) {
                    Processor.msgLogger.exception(IRecordType.TYPE_ERR, (Object)Processor.className, var4_4, (Throwable)var10_11);
                    if (Processor.traceLogger.isLogging()) {
                        Processor.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)Processor.className, var4_4, (Throwable)var10_11);
                    }
                    var3_3 = false;
                }
                throw var9_8;
            }
            {
                var8_10 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 112->137)] { 
lbl46:
            // 1 sources

            if (var5_5 != null) {
                if (var3_3) {
                    var5_5.commit();
                    break block21;
                } else {
                    var5_5.rollback();
                }
            }
            break block21;
lbl53:
            // 1 sources

            catch (Exception var10_12) {
                Processor.msgLogger.exception(IRecordType.TYPE_ERR, (Object)Processor.className, var4_4, (Throwable)var10_12);
                if (Processor.traceLogger.isLogging()) {
                    Processor.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)Processor.className, var4_4, (Throwable)var10_12);
                }
                var3_3 = false;
            }
        }
        try {}
        catch (Exception var10_12) {
            Processor.msgLogger.exception(IRecordType.TYPE_ERR, (Object)Processor.className, var4_4, (Throwable)var10_12);
            if (Processor.traceLogger.isLogging() == false) return;
            Processor.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)Processor.className, var4_4, (Throwable)var10_12);
            return;
        }
        if (var5_5 == null) return;
        var5_5.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkLevel(JobInfo var1_1) {
        block14: {
            var2_2 = null;
            var3_3 = -1;
            if (!this.isReturnCodeOK(var1_1)) {
                return true;
            }
            if (this.getBenchmarkLevel(var1_1) == -1) {
                return true;
            }
            var4_4 = ServiceUtils.getConnection();
            try {
                try {
                    var5_5 = new Hashtable<ColumnInfo, String>();
                    var5_5.put(Scanner.getColumnInfo((String)"SCANNER_ID"), this.getScanID(var1_1));
                    var2_2 = Scanner.retrieve((DBConnection)var4_4, var5_5);
                    if (var2_2 != null) {
                        var3_3 = var2_2.getBenchmark();
                    }
                }
                catch (Exception var5_6) {
                    var5_6.printStackTrace();
                    var6_7 = null;
                    try {
                        if (var4_4 == null) return true;
                        var4_4.close();
                        return true;
                    }
                    catch (Exception var8_10) {
                        var8_10.printStackTrace();
                    }
                    return true;
                }
            }
            catch (Throwable var7_13) {
                var6_8 = null;
                ** try [egrp 2[TRYBLOCK] [3 : 98->111)] { 
lbl32:
                // 1 sources

                if (var4_4 == null) throw var7_13;
                var4_4.close();
                throw var7_13;
lbl35:
                // 1 sources

                catch (Exception var8_11) {
                    var8_11.printStackTrace();
                }
                throw var7_13;
            }
            {
                var6_9 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 98->111)] { 
lbl40:
            // 1 sources

            if (var4_4 != null) {
                var4_4.close();
            }
            break block14;
lbl43:
            // 1 sources

            catch (Exception var8_12) {
                var8_12.printStackTrace();
            }
        }
        if (var3_3 == -1) {
            return true;
        }
        if (var3_3 != this.getLevel(var1_1)) return true;
        return false;
    }

    public static boolean isTimeToShutdown() {
        return timeToShutdown;
    }

    public static void setTimeToShutdown(boolean bl) {
        timeToShutdown = bl;
    }

    public void handleAssociation(JobInfo jobInfo, String string, String string2, Hashtable hashtable, String string3, Hashtable hashtable2, Hashtable hashtable3) throws DiscoveryException {
        if (Configuration.debug) {
            Processor.printAssociation(string, string2, hashtable, string3, hashtable2, hashtable3);
        }
        try {
            String string4 = null;
            try {
                string4 = (String)hashtable3.get("dedicated");
            }
            catch (Exception exception) {}
            IDBAttributeMapper iDBAttributeMapper = this.mapperRouter.findMapper(string, null, null, null, string4);
            if (iDBAttributeMapper == null) {
                System.out.println("DB Mapper does not exist for " + string + " " + hashtable3);
                return;
            }
            string4 = null;
            try {
                string4 = (String)hashtable.get("dedicated");
            }
            catch (Exception exception) {}
            IDBAttributeMapper iDBAttributeMapper2 = this.mapperRouter.findMapper(string2, null, null, null, string4);
            if (iDBAttributeMapper2 == null) {
                System.out.println("DB Mapper does not exist for " + string2 + " " + hashtable);
                return;
            }
            string4 = null;
            try {
                string4 = (String)hashtable2.get("dedicated");
            }
            catch (Exception exception) {}
            IDBAttributeMapper iDBAttributeMapper3 = this.mapperRouter.findMapper(string3, null, null, null, string4);
            if (iDBAttributeMapper3 == null) {
                System.out.println("DB Mapper does not exist for " + string3 + " " + hashtable2);
                return;
            }
            Processor.persist(this.connection, iDBAttributeMapper, hashtable3, iDBAttributeMapper2, hashtable, iDBAttributeMapper3, hashtable2, this.getScanID(jobInfo), this.history, String.valueOf(discoverEventPrefix) + jobInfo.getDiscoverRequest(), this.newEntities, this.modifiedEntities);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            try {
                this.connection.rollback();
                this.history.clear();
            }
            catch (SQLException sQLException2) {}
            throw new DiscoveryException(sQLException);
        }
        catch (Exception exception) {
            throw new DiscoveryException(exception);
        }
    }

    public void handleEntity(JobInfo jobInfo, String string, Hashtable hashtable) throws DiscoveryException {
        String string2 = "handleEntity";
        if (Configuration.debug) {
            Processor.printEntity(string, hashtable);
        }
        try {
            String string3 = null;
            String string4 = null;
            IDBAttributeMapper iDBAttributeMapper = null;
            try {
                string3 = (String)hashtable.get("dedicated");
                string4 = (String)hashtable.get("originalcimclassname");
            }
            catch (Exception exception) {}
            if (string4 == null || string4 == "") {
                iDBAttributeMapper = this.mapperRouter.findMapper(string, null, null, null, string3);
                if (iDBAttributeMapper == null) {
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string2, "DB Mapper does not exist for instance " + string + " " + hashtable);
                    }
                    return;
                }
            } else {
                iDBAttributeMapper = this.mapperRouter.findMapper(string, null, null, null, string3, string4);
                if (iDBAttributeMapper == null) {
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string2, "DB Mapper does not exist for instance " + string + " originalcimclassname " + string4 + " " + hashtable);
                    }
                    return;
                }
            }
            Processor.persist(this.connection, iDBAttributeMapper, hashtable, this.getScanID(jobInfo), this.history, String.valueOf(discoverEventPrefix) + jobInfo.getDiscoverRequest(), this.newEntities, this.modifiedEntities);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            try {
                this.connection.rollback();
                this.history.clear();
            }
            catch (SQLException sQLException2) {
                throw new DiscoveryException(sQLException);
            }
        }
        catch (Throwable throwable) {
            throw new DiscoveryException(throwable);
        }
    }

    public static void printHashtable(Hashtable hashtable) {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object object;
                String string = (String)enumeration.nextElement();
                Object v = hashtable.get(string);
                if (v instanceof CIMValue) {
                    System.out.println("    Property = " + string + ", Value = " + v.toString());
                    continue;
                }
                if (v instanceof ArrayList) {
                    System.out.print("    Property = " + string + ", ValueArray = ");
                    object = (ArrayList)v;
                    if (((ArrayList)object).isEmpty()) {
                        System.out.print("null");
                    } else {
                        int n = 0;
                        while (n < ((ArrayList)object).size()) {
                            System.out.print(String.valueOf((String)((ArrayList)object).get(n)) + " : ");
                            ++n;
                        }
                    }
                    System.out.println();
                    continue;
                }
                object = v.toString();
                if ("".equals(object)) {
                    object = "null";
                }
                System.out.println("    Property = " + string + ", Value = " + (String)object);
            }
        } else {
            System.out.println("    Property hashtable is null");
        }
    }

    public static void printEntity(String string, Hashtable hashtable) {
        System.out.println("Instance = " + string);
        Processor.printHashtable(hashtable);
    }

    public static void printAssociation(String string, String string2, Hashtable hashtable, String string3, Hashtable hashtable2, Hashtable hashtable3) {
        System.out.println("Association = " + string);
        System.out.println("Entity1 = " + string2);
        Processor.printHashtable(hashtable);
        System.out.println("Entity2 = " + string3);
        Processor.printHashtable(hashtable2);
        System.out.println("Properties:");
        Processor.printHashtable(hashtable3);
    }

    private int getLevel(JobInfo jobInfo) {
        int n = -1;
        if (jobInfo.getRequest() != null && jobInfo.getRequest().getData() instanceof Response && ((Response)jobInfo.getRequest().getData()).getReturnCode() == Response.RETURN_CODE_OK) {
            n = ((Response)jobInfo.getRequest().getData()).getLevel();
        }
        return n;
    }

    private int getBenchmarkLevel(JobInfo jobInfo) {
        int n = -1;
        if (jobInfo.getRequest() != null && jobInfo.getRequest().getData() instanceof Response && ((Response)jobInfo.getRequest().getData()).getReturnCode() == Response.RETURN_CODE_OK) {
            n = ((Response)jobInfo.getRequest().getData()).getBenchmarkLevel();
        }
        return n;
    }

    private boolean isReturnCodeOK(JobInfo jobInfo) {
        if (jobInfo.getRequest() != null && jobInfo.getRequest().getData() != null && jobInfo.getRequest().getData() instanceof Response) {
            return ((Response)jobInfo.getRequest().getData()).getReturnCode() == Response.RETURN_CODE_OK;
        }
        return true;
    }

    protected String getScanID(JobInfo jobInfo) {
        Request request = Router.getRouter().getRequest(jobInfo.getDiscoverRequest());
        if (request != null) {
            return request.getScannerId();
        }
        return null;
    }

    public static IEventMonitorService getEventMonitorProxy() {
        if (eventMonitor == null) {
            eventMonitor = (IEventMonitorService)DiscoveryActivator._serviceHelper.bindLocal("SANEventCorrelatorFactory");
        }
        return eventMonitor;
    }

    public static IConfigService getConfigServiceProxy() {
        if (configServiceProxy == null) {
            configServiceProxy = (IConfigService)DiscoveryActivator._serviceHelper.bindLocal("ConfigService");
        }
        return configServiceProxy;
    }

    public static int getNumberOfOperationsPerTransaction() {
        String string = "getNumberOfOperationsPerTransaction";
        if (numOperationsPerTransaction <= 0) {
            try {
                numOperationsPerTransaction = Integer.parseInt(Processor.getConfigServiceProxy().getProperty(PROPERTY_NUM_OPS_PER_TRANSACTION, PROPERTY_GROUP));
            }
            catch (Exception exception) {}
            if (numOperationsPerTransaction <= 0) {
                numOperationsPerTransaction = 1;
            }
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, "Number of Operations per Transaction is " + numOperationsPerTransaction);
            }
        }
        return numOperationsPerTransaction;
    }

    public static MapperResult persist(DBConnection dBConnection, IDBAttributeMapper iDBAttributeMapper, Hashtable hashtable, IDBAttributeMapper iDBAttributeMapper2, Hashtable hashtable2, IDBAttributeMapper iDBAttributeMapper3, Hashtable hashtable3, String string, List list, String string2, Hashtable hashtable4, Hashtable hashtable5) throws SQLException {
        MapperResult mapperResult = null;
        try {
            list.add(new RelationshipPersistWrapper(iDBAttributeMapper, (Hashtable)hashtable.clone(), iDBAttributeMapper2, (Hashtable)hashtable2.clone(), iDBAttributeMapper3, (Hashtable)hashtable3.clone(), string));
            mapperResult = iDBAttributeMapper.persist(dBConnection, iDBAttributeMapper2, (Hashtable)hashtable2.clone(), iDBAttributeMapper3, (Hashtable)hashtable3.clone(), string);
            AlertProcessor.processAlerts(string2, mapperResult, hashtable4, hashtable5);
            if (list.size() > Processor.getNumberOfOperationsPerTransaction()) {
                dBConnection.commit();
                list.clear();
            }
        }
        catch (SQLException sQLException) {
            if (SQLExceptionHelper.isDeadlock((DBConnection)dBConnection, (SQLException)sQLException)) {
                mapperResult = Processor.retryPersist(dBConnection, list);
                AlertProcessor.processAlerts(string2, mapperResult, hashtable4, hashtable5);
                dBConnection.commit();
                list.clear();
            }
            throw sQLException;
        }
        return mapperResult;
    }

    public static MapperResult persist(DBConnection dBConnection, IDBAttributeMapper iDBAttributeMapper, Hashtable hashtable, String string, List list, String string2, Hashtable hashtable2, Hashtable hashtable3) throws SQLException {
        MapperResult mapperResult = null;
        try {
            list.add(new EntityPersistWrapper(iDBAttributeMapper, (Hashtable)hashtable.clone(), string));
            mapperResult = iDBAttributeMapper.persist(dBConnection, (Hashtable)hashtable.clone(), string);
            AlertProcessor.processAlerts(string2, mapperResult, hashtable2, hashtable3);
            if (list.size() > Processor.getNumberOfOperationsPerTransaction()) {
                dBConnection.commit();
                list.clear();
            }
        }
        catch (SQLException sQLException) {
            if (SQLExceptionHelper.isDeadlock((DBConnection)dBConnection, (SQLException)sQLException)) {
                mapperResult = Processor.retryPersist(dBConnection, list);
                AlertProcessor.processAlerts(string2, mapperResult, hashtable2, hashtable3);
                dBConnection.commit();
                list.clear();
            }
            throw sQLException;
        }
        return mapperResult;
    }

    protected static MapperResult retryPersist(DBConnection dBConnection, List list) throws SQLException {
        String string = "persist";
        boolean bl = false;
        int n = 0;
        Random random = new Random();
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string, "Deadlock encountered - retrying " + list.size() + " operations.");
        }
        while (true) {
            try {
                MapperResult mapperResult = null;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    PersistWrapper persistWrapper;
                    Object e = iterator.next();
                    if (e instanceof RelationshipPersistWrapper) {
                        persistWrapper = (RelationshipPersistWrapper)e;
                        mapperResult = ((RelationshipPersistWrapper)persistWrapper).getInvoker().persist(dBConnection, ((RelationshipPersistWrapper)persistWrapper).getEntity1(), (Hashtable)((RelationshipPersistWrapper)persistWrapper).getEntity1_htValues().clone(), ((RelationshipPersistWrapper)persistWrapper).getEntity2(), (Hashtable)((RelationshipPersistWrapper)persistWrapper).getEntity2_htValues().clone(), ((RelationshipPersistWrapper)persistWrapper).getScanID());
                        continue;
                    }
                    if (e instanceof EntityPersistWrapper) {
                        persistWrapper = (EntityPersistWrapper)e;
                        mapperResult = ((EntityPersistWrapper)persistWrapper).getEntity().persist(dBConnection, (Hashtable)((EntityPersistWrapper)persistWrapper).getEntity_htValues().clone(), ((EntityPersistWrapper)persistWrapper).getScanID());
                        continue;
                    }
                    System.out.println("Unrecognized PersistWrapper type");
                }
                bl = false;
                return mapperResult;
            }
            catch (SQLException sQLException) {
                if (SQLExceptionHelper.isDeadlock((DBConnection)dBConnection, (SQLException)sQLException)) {
                    dBConnection.rollback();
                    if (++n <= 20) {
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string, "Deadlock within Retry of Operations - Retry " + n + " after deadlock");
                        } else {
                            System.out.println(String.valueOf(className) + " " + string + " Retry " + n + "after deadlock");
                        }
                        bl = true;
                        long l = (long)(15000.0 * random.nextDouble() * (double)n);
                        if (l < 100L) {
                            l = 100L;
                        }
                        try {
                            Thread.sleep(l);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        continue;
                    }
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string, "Number of Retries exceeded; aborting with SQLException");
                    }
                    throw sQLException;
                }
                throw sQLException;
                if (bl) continue;
                return null;
            }
            break;
        }
    }

    public DBConnection getConnection() {
        return this.connection;
    }
}

