/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.parser;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.discovery.parser.AlertProcessor;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.util.queue.DefaultJobQueue;
import org.eclipse.aperi.util.queue.IJobQueue;
import org.eclipse.aperi.util.queue.QueueController;
import org.sblim.slp.ServiceLocationAttribute;

public class SLPObjectParser
extends Thread {
    public static String queueName;
    private DBConnection connection = null;
    private boolean shutdown = false;
    private Thread thread = null;
    public static final String MESSAGE_NAME = "aperi.logger.message.SLPObjectParser";
    public static final String TRACE_NAME = "aperi.logger.trace.SLPObjectParser";
    public static String MSG_FILE;
    private static final String PROCESSID_PREFIX = "S";
    private static String className;
    public static ILogger msgLogger;
    public static ILogger traceLogger;

    static {
        Class<?> clazz;
        queueName = "SLPObjectParser";
        MSG_FILE = "org.eclipse.aperi.discovery.parser.resources.MsgLoggingTMS";
        try {
            clazz = Class.forName("org.eclipse.aperi.discovery.parser.SLPObjectParser");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        msgLogger = null;
        traceLogger = null;
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }

    public SLPObjectParser() {
        this.setName(String.valueOf(queueName) + " (" + this.getName() + ")");
        QueueController.getInstance().addQueue(queueName, (IJobQueue)new DefaultJobQueue());
        this.start();
    }

    private DBConnection getConnection() {
        String string = "getConnection";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        try {
            DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
            DBConnection dBConnection = (DBConnection)dBConnPoolDataSource.getPooledConnection();
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            }
            return dBConnection;
        }
        catch (Exception exception) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            }
            return null;
        }
    }

    public Hashtable parse(Vector vector) {
        String string = "parse";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object e = iterator.next();
            if (e instanceof ServiceLocationAttribute) {
                object = (ServiceLocationAttribute)e;
                String string2 = object.getId();
                Vector vector2 = object.getValues();
                if (vector2 == null || vector2.size() == 0) {
                    if (!traceLogger.isLogging()) continue;
                    String string3 = "Parsing warning: " + object.toString() + " does not have a value.";
                    traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, string, string3);
                    continue;
                }
                if (vector2.size() == 1) {
                    hashtable.put(string2, vector2.elementAt(0).toString());
                    continue;
                }
                hashtable.put(string2, vector2.toString());
                continue;
            }
            if (!traceLogger.isLogging()) continue;
            object = String.valueOf(queueName) + ": Invalid object type (ServiceLocationAttribute expected): " + e.getClass();
            traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, string, (String)object);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return hashtable;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        var1_1 = "run";
        if (SLPObjectParser.traceLogger.isLogging()) {
            SLPObjectParser.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)SLPObjectParser.className, var1_1);
        }
        SLPObjectParser.msgLogger.message(IRecordType.TYPE_INFO, (Object)SLPObjectParser.className, var1_1, "SLPObjectParser_Started");
        this.thread = Thread.currentThread();
        new RegisteredCimom();
        while (true) {
            block50: {
                block49: {
                    block48: {
                        block45: {
                            if (this.shutdown) {
                                if (!SLPObjectParser.traceLogger.isLogging()) return;
                                SLPObjectParser.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)SLPObjectParser.className, var1_1);
                                return;
                            }
                            if (SLPObjectParser.traceLogger.isLogging()) {
                                var2_2 /* !! */  = String.valueOf(SLPObjectParser.queueName) + ": waiting for a job";
                                SLPObjectParser.traceLogger.text(IRecordType.TYPE_INFO, (Object)SLPObjectParser.className, var1_1, (String)var2_2 /* !! */ );
                            }
                            var2_2 /* !! */  = QueueController.getInstance().getNextJob(SLPObjectParser.queueName);
                            if (this.shutdown) continue;
                            if (var2_2 /* !! */  == null) {
                                if (!SLPObjectParser.traceLogger.isLogging()) continue;
                                var3_3 = String.valueOf(SLPObjectParser.queueName) + ":Error - got a NULL job from the queue";
                                SLPObjectParser.traceLogger.text(IRecordType.TYPE_ERROR, (Object)SLPObjectParser.className, var1_1, var3_3);
                                continue;
                            }
                            var3_3 = null;
                            var4_4 = Router.getRouter().getRequest(var2_2 /* !! */ .getDiscoverRequest());
                            if (var4_4 != null) {
                                var3_3 = var4_4.getJobLogger();
                            }
                            if (var3_3 != null) {
                                var3_3.message(IRecordType.TYPE_INFORMATION, (Object)SLPObjectParser.className, var1_1, "SLPObjectParserJob_Run", (Object[])new String[]{var4_4.getDeviceServerRunNumber(), String.valueOf(var4_4.getId())});
                            }
                            if (!((var5_5 = var2_2 /* !! */ .getRequest()) instanceof ObjectResponse)) break block50;
                            if (SLPObjectParser.traceLogger.isLogging()) {
                                var6_6 = String.valueOf(SLPObjectParser.queueName) + ": Received an Object response";
                                SLPObjectParser.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)SLPObjectParser.className, var1_1, (String)var6_6);
                            }
                            try {
                                try {
                                    block46: {
                                        block43: {
                                            this.connection = this.getConnection();
                                            var6_6 = (Vector)var5_5.getData();
                                            SLPObjectParser.msgLogger.message(IRecordType.TYPE_INFO, (Object)SLPObjectParser.className, var1_1, "SLPObjectParser_NumCIMOMsFound", (Object)String.valueOf(var6_6.size()));
                                            if (var3_3 != null) {
                                                var3_3.message(IRecordType.TYPE_INFORMATION, (Object)SLPObjectParser.className, var1_1, "SLPObjectParser_NumCIMOMsFound", (Object)String.valueOf(var6_6.size()));
                                            }
                                            var7_8 = new Vector<MapperResult>();
                                            var8_9 = var6_6.iterator();
lbl42:
                                            // 3 sources

                                            while (true) {
                                                block44: {
                                                    if (!var8_9.hasNext()) break block43;
                                                    var9_10 = (CIMOM[])var8_9.next();
                                                    var10_11 = this.parse((Vector)var9_10);
                                                    if (SLPObjectParser.traceLogger.isLogging()) {
                                                        var11_12 /* !! */  = "Found Cimom. Properties are: " + var10_11;
                                                        SLPObjectParser.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)SLPObjectParser.className, var1_1, (String)var11_12 /* !! */ );
                                                    }
                                                    try {
                                                        var11_12 /* !! */  = MapperRouter.getMapperRouter();
                                                        var12_15 = var11_12 /* !! */ .findMapper("SLP", null, null, null);
                                                        if (var12_15 == null) {
                                                            if (!SLPObjectParser.traceLogger.isLogging()) break block44;
                                                            var13_18 = "DB Mapper does not exist for CIMOM " + var10_11;
                                                            SLPObjectParser.traceLogger.text(IRecordType.TYPE_ERROR, (Object)SLPObjectParser.className, var1_1, var13_18);
                                                            SLPObjectParser.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)SLPObjectParser.className, var1_1);
                                                        }
                                                        break;
                                                    }
                                                    catch (Exception var11_13) {
                                                        if (SLPObjectParser.traceLogger.isLogging()) {
                                                            SLPObjectParser.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, var1_1, (Throwable)var11_13);
                                                        }
                                                        SLPObjectParser.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, var1_1, (Throwable)var11_13);
                                                        if (var3_3 != null) {
                                                            var3_3.message(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, var1_1, "SLPObjectParserJob_Error", (Object[])new String[]{var4_4.getDeviceServerRunNumber(), String.valueOf(var4_4.getId()), var11_13.getMessage()});
                                                        }
                                                        try {
                                                            this.connection.rollback();
                                                        }
                                                        catch (SQLException v0) {}
                                                        continue;
                                                    }
                                                }
                                                var14_16 = null;
                                                break block45;
                                                break;
                                            }
                                            {
                                                if (var10_11.isEmpty() || var10_11.get("template-url-syntax") == null) ** GOTO lbl42
                                                var7_8.add(var12_15.persist(this.connection, (Hashtable)var10_11, null));
                                                ** continue;
                                            }
                                        }
                                        this.connection.commit();
                                        this.connection.close();
                                        this.connection = null;
                                        var8_9 = CIMOMManager.getCIMOMManager();
                                        var9_10 = var8_9.getCIMOMs();
                                        var10_11 = var7_8.elements();
                                        while (true) {
                                            if (!var10_11.hasMoreElements()) {
                                                ** try [egrp 5[TRYBLOCK] [3 : 840->851)] { 
lbl87:
                                                // 1 sources

                                                break;
                                            }
                                            var11_12 /* !! */  = (MapperResult)var10_11.nextElement();
                                            AlertProcessor.processAlerts("S" + CIMOMManager.getUniqueNumberString(), (MapperResult)var11_12 /* !! */ , new Hashtable<K, V>(), new Hashtable<K, V>());
                                        }
                                        {
                                            var8_9.testCIMOMConnection(var9_10);
                                        }
lbl94:
                                        // 1 sources

                                        catch (ServerException var11_14) {
                                            if (SLPObjectParser.traceLogger.isLogging()) {
                                                SLPObjectParser.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, var1_1, (Throwable)var11_14);
                                            }
                                            SLPObjectParser.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, var1_1, (Throwable)var11_14);
                                            if (var3_3 == null) break block46;
                                            var3_3.message(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, var1_1, "SLPObjectParserJob_Error", (Object[])new String[]{var4_4.getDeviceServerRunNumber(), String.valueOf(var4_4.getId()), var11_14.getMessage()});
                                        }
                                    }
                                    var2_2 /* !! */ .setReturnCode(0);
                                    var2_2 /* !! */ .complete(true);
                                }
                                catch (Throwable var6_7) {
                                    if (SLPObjectParser.traceLogger.isLogging()) {
                                        SLPObjectParser.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, var1_1, var6_7);
                                    }
                                    SLPObjectParser.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, var1_1, var6_7);
                                    if (var3_3 != null) {
                                        var3_3.message(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, var1_1, "SLPObjectParserJob_Error", (Object[])new String[]{var4_4.getDeviceServerRunNumber(), String.valueOf(var4_4.getId()), var6_7.getMessage()});
                                    }
                                    var2_2 /* !! */ .setReturnCode(99);
                                    var2_2 /* !! */ .complete(false);
                                }
                                ** GOTO lbl-1000
                            }
                            catch (Throwable var15_19) {
                                block47: {
                                    var14_16 = null;
                                    try {
                                        if (this.connection != null) {
                                            this.connection.close();
                                            this.connection = null;
                                        }
                                    }
                                    catch (Exception var16_17) {
                                        if (SLPObjectParser.traceLogger.isLogging()) {
                                            SLPObjectParser.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, var1_1, (Throwable)var16_17);
                                        }
                                        SLPObjectParser.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, var1_1, (Throwable)var16_17);
                                        if (var3_3 == null) break block47;
                                        var3_3.message(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, var1_1, "SLPObjectParserJob_Error", (Object[])new String[]{var4_4.getDeviceServerRunNumber(), String.valueOf(var4_4.getId()), var16_17.getMessage()});
                                    }
                                }
                                var5_5.close();
                                throw var15_19;
                            }
                        }
                        ** try [egrp 6[TRYBLOCK] [9 : 1084->1106)] { 
lbl132:
                        // 1 sources

                        if (this.connection != null) {
                            this.connection.close();
                            this.connection = null;
                        }
                        break block48;
lbl136:
                        // 1 sources

                        catch (Exception var16_17) {
                            if (SLPObjectParser.traceLogger.isLogging()) {
                                SLPObjectParser.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, var1_1, (Throwable)var16_17);
                            }
                            SLPObjectParser.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, var1_1, (Throwable)var16_17);
                            if (var3_3 == null) break block48;
                            var3_3.message(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, var1_1, "SLPObjectParserJob_Error", (Object[])new String[]{var4_4.getDeviceServerRunNumber(), String.valueOf(var4_4.getId()), var16_17.getMessage()});
                        }
                    }
                    var5_5.close();
                    return;
lbl-1000:
                    // 2 sources

                    {
                        var14_16 = null;
                    }
                    ** try [egrp 6[TRYBLOCK] [9 : 1084->1106)] { 
lbl147:
                    // 1 sources

                    if (this.connection != null) {
                        this.connection.close();
                        this.connection = null;
                    }
                    break block49;
lbl151:
                    // 1 sources

                    catch (Exception var16_17) {
                        if (SLPObjectParser.traceLogger.isLogging()) {
                            SLPObjectParser.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, var1_1, (Throwable)var16_17);
                        }
                        SLPObjectParser.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, var1_1, (Throwable)var16_17);
                        if (var3_3 == null) break block49;
                        var3_3.message(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, var1_1, "SLPObjectParserJob_Error", (Object[])new String[]{var4_4.getDeviceServerRunNumber(), String.valueOf(var4_4.getId()), var16_17.getMessage()});
                    }
                }
                var5_5.close();
            }
            if (!SLPObjectParser.traceLogger.isLogging()) continue;
            var6_6 = String.valueOf(SLPObjectParser.queueName) + ": Finishing job";
            SLPObjectParser.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)SLPObjectParser.className, var1_1, (String)var6_6);
        }
    }

    public void shutdown() {
        String string = "shutdown";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        this.shutdown = true;
        if (this.thread != null) {
            msgLogger.message(IRecordType.TYPE_INFO, (Object)className, string, "SLPObjectParser_Shutdown");
            try {
                this.thread.interrupt();
                this.thread.join(30000L);
                this.thread = null;
            }
            catch (Exception exception) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                }
                msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }
}

