/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.configure;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import java.util.Vector;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.soap.encoding.soapenc.Base64;
import org.eclipse.aperi.configure.SearchAndReplace;
import org.eclipse.aperi.download.DownloadConfig;
import org.eclipse.aperi.download.interfaces.IDownload;
import org.eclipse.aperi.download.interfaces.IMirror;
import org.eclipse.aperi.guid.impl.GUIDImpl;
import org.eclipse.aperi.install.SilentDatabaseInstall;
import org.eclipse.aperi.report.bulk.BulkLoader;
import org.eclipse.aperi.repository.Transform;
import org.eclipse.aperi.util.SRMCrypto;

public class ConfigureAperi {
    public static final String lockDirectory = "/etc/Tivoli/TSRM/lock";
    public static final String CONFIG_DEFAULTS = "../configure/default.properties";
    public static final String SEARCH_REPLACE = "../configure/searchReplace.config";
    public static final String CANNED_REPORTS = "../reporting/configuration/canned-reports.zip";
    public static final String YES = "Yes";
    public static final String NO = "No";
    public static final String EASY = "easy";
    public static final String DB2 = "db2";
    public static final String DERBY = "derby";
    public static final String DB2_DRIVER = "com.ibm.db2.jcc.DB2Driver";
    public static final String DERBY_DRIVER = "org.apache.derby.jdbc.ClientDriver";
    private DownloadConfig downloadConfig = null;
    private boolean isWindows = System.getProperty("os.name").startsWith("Windows");

    public static void main(String[] stringArray) {
        String string = null;
        boolean bl = false;
        if (stringArray.length == 1) {
            if (stringArray[0].trim().equalsIgnoreCase(EASY)) {
                bl = true;
            } else {
                string = stringArray[0];
            }
        } else if (stringArray.length > 0) {
            System.out.println("usage: cfgaperi [easy | <properties-file-name>]");
            System.exit(1);
        }
        ConfigureAperi configureAperi = new ConfigureAperi();
        configureAperi.configureAperi(bl, string);
    }

    public void configureAperi(boolean bl, String string) {
        Properties properties = new Properties();
        this.load3rdPartyConfiguration();
        this.collectInput(bl, properties, string, this.isWindows);
        this.configure(properties, this.isWindows);
    }

    private void collectInput(boolean bl, Properties properties, String string, boolean bl2) {
        try {
            this.updateConfigProgrammatically(properties, bl, bl2);
            this.updateConfigFromPropertiesFile(properties, CONFIG_DEFAULTS);
            if (string != null) {
                if (!string.startsWith(".")) {
                    string = "../configure/" + string;
                }
                this.updateConfigFromPropertiesFile(properties, string);
            }
            if (bl) {
                this.automaticMirrorSelection();
                ConfigureAperi.println("This program will configure Aperi using default values.");
                ConfigureAperi.println("");
            } else {
                this.updateConfigFromUserInput(properties, bl2);
            }
            this.finalizeConfig(properties);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    private void configure(Properties properties, boolean bl) {
        ConfigureAperi.println("");
        ConfigureAperi.println("Ready to configure.");
        ConfigureAperi.println("");
        boolean bl2 = this.yesTest(properties.getProperty("configureAgent"));
        boolean bl3 = this.yesTest(properties.getProperty("configureServer"));
        boolean bl4 = this.yesTest(properties.getProperty("configureGUI"));
        String string = properties.getProperty("installDir");
        String string2 = properties.getProperty("serverHostname");
        String string3 = properties.getProperty("agentPort");
        String string4 = properties.getProperty("authPasswordEncrypted");
        String string5 = properties.getProperty("deviceServerPort");
        String string6 = properties.getProperty("dataServerPort");
        String string7 = properties.getProperty("jvmHeapSizeFlag");
        String string8 = properties.getProperty("dataAgentHeapSize");
        String string9 = properties.getProperty("script");
        String string10 = properties.getProperty("slash");
        String string11 = properties.getProperty("comment");
        String string12 = properties.getProperty("javaHome");
        String string13 = properties.getProperty("rdbms");
        String string14 = properties.getProperty("export");
        String string15 = properties.getProperty("colon");
        String string16 = properties.getProperty("derbyHeapSize");
        String string17 = properties.getProperty("dbPort");
        String string18 = properties.getProperty("dbUsername");
        String string19 = properties.getProperty("dbPassword");
        String string20 = properties.getProperty("dbPasswordDeviceEncrypted");
        String string21 = properties.getProperty("deviceServerHeapSize");
        String string22 = properties.getProperty("dbDriver");
        String string23 = properties.getProperty("dbType");
        String string24 = properties.getProperty("dataServerHTTPPort");
        String string25 = properties.getProperty("dataServerHeapSize");
        String string26 = properties.getProperty("guiHeapSize");
        String string27 = properties.getProperty("db2cmdPath");
        String string28 = properties.getProperty("reportServerPort");
        String string29 = properties.getProperty("reportServerHeapSize");
        String string30 = properties.getProperty("reportRepository");
        boolean bl5 = this.yesTest(properties.getProperty("download3rdParty"));
        String string31 = properties.getProperty("jdbcUrl");
        try {
            if (bl5) {
                this.download3rdPartySoftware(properties);
            }
            if (bl2) {
                this.agent(string2, string5, string3, string, string4, string6, string7, string8, string9, string10, string11, string12, bl);
            }
            if (bl3) {
                this.configureDatabase(string13, string9, string10, string14, string12, string15, string, bl, string7, string16, string2, string17, string18, string20, string30);
                this.deviceserver(bl, string5, string3, string, string4, string22, string18, string12, string7, string21, string31, string2, string20, string11, string9, string10);
                this.dataserver(string2, string6, string22, string23, string17, string18, string19, string, string12, string7, string25, string28, string24, string9, string11, string10, bl);
            }
            if (bl4) {
                this.gui(string2, string6, string9, bl, string11, string, string12, string10, string7, string26);
            }
            if (bl2 || bl3) {
                this.startScript(string9, string11, string, string13, string10, bl);
            }
            if (bl2 || bl3) {
                this.guid(string, string10);
            }
            if (bl3) {
                this.schema(string13, string, string10, string2, string27, string9, string18, string19, string20, string2, string17, string22, string31, string30, bl);
                this.reportServer(string28, string, string12, string7, string29, string9, string11, string10, bl, string30, properties);
            }
            ConfigureAperi.println("");
            if (bl3 && bl2) {
                ConfigureAperi.println("To bring up the Aperi server and agent, run aperi" + string9);
            } else if (bl3) {
                ConfigureAperi.println("To bring up the Aperi server, run aperi" + string9);
                ConfigureAperi.println("Or you can bring up individual components with the");
                ConfigureAperi.println("startup scripts in the derby, datasvr, and devsvr");
                ConfigureAperi.println("directories.");
            } else if (bl2) {
                ConfigureAperi.println("To bring up the Aperi server, run aperi" + string9);
                ConfigureAperi.println("Or you can bring it up with agent/agent" + string9);
            }
            if (bl4) {
                ConfigureAperi.println("To start the GUI, run gui/gui" + string9);
            }
            ConfigureAperi.println("Aperi configuration is complete.");
            ConfigureAperi.println("");
        }
        catch (Exception exception) {
            System.out.println("Error occurred while performing the configuration updates.");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    protected void updateConfigProgrammatically(Properties properties, boolean bl, boolean bl2) {
        properties.setProperty("export", bl2 ? "set" : "export");
        properties.setProperty("colon", bl2 ? ";" : ":");
        properties.setProperty("comment", bl2 ? "REM " : "# ");
        properties.setProperty("script", bl2 ? ".bat" : "");
        properties.setProperty("slash", System.getProperty("file.separator"));
        String string = System.getProperty("user.dir");
        int n = string.lastIndexOf(properties.getProperty("slash").charAt(0));
        if (n < 0) {
            ConfigureAperi.println("Unexpected install directory path");
            System.exit(1);
        }
        properties.setProperty("installDir", string.substring(0, n));
        properties.setProperty("javaHome", System.getProperty("java.home"));
        this.checkJava();
        ConfigureAperi.println("");
        if (bl) {
            properties.setProperty("configureAgent", "yes");
            properties.setProperty("configureServer", "yes");
            properties.setProperty("configureGUI", "yes");
            try {
                String string2 = InetAddress.getLocalHost().getHostName();
                properties.setProperty("serverHostname", string2);
            }
            catch (UnknownHostException unknownHostException) {
                unknownHostException.printStackTrace();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void updateConfigFromPropertiesFile(Properties var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 77->81)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateConfigFromUserInput(Properties properties, boolean bl) throws IOException {
        ConfigureAperi.println("");
        ConfigureAperi.println("Aperi Storage Manager Configuration");
        ConfigureAperi.println("");
        ConfigureAperi.println("This program will ask you a series of questions, then configure Aperi ");
        ConfigureAperi.println("Default values are displayed in [square brackets].");
        ConfigureAperi.println("");
        ConfigureAperi.println("");
        ConfigureAperi.println("The Aperi Storage Manager consists of three major components:");
        ConfigureAperi.println("The host-based agent, the server, the GUI, and the report server.");
        ConfigureAperi.println("You can configure any or all of these to run on this computer.");
        ConfigureAperi.println("");
        ConfigureAperi.println("Which components do you want to configure? Answer with Yes or No. ");
        ConfigureAperi.println("");
        boolean bl2 = this.shouldConfigure("Agent", "configureAgent", properties);
        boolean bl3 = this.shouldConfigure("Server", "configureServer", properties);
        boolean bl4 = this.shouldConfigure("GUI", "configureGUI", properties);
        if (!(bl2 || bl3 || bl4)) {
            ConfigureAperi.println("Nothing to configure.");
            System.exit(-1);
        }
        this.collectInputFromUser(bl2, bl4, bl3, properties, bl);
    }

    private void finalizeConfig(Properties properties) throws Exception {
        this.setDB(properties);
        this.encryptPasswords(properties);
        this.replaceBackslash(properties, "installDir");
        this.replaceBackslash(properties, "reportRepository");
        properties.setProperty("reportRepository", this.relativePath(properties.getProperty("installDir"), properties.getProperty("reportRepository")));
        String string = properties.getProperty("dbType");
        String string2 = properties.getProperty("serverHostname");
        String string3 = properties.getProperty("dbPort");
        String string4 = "jdbc:" + string + "://" + string2 + ":" + string3 + "/Aperi";
        properties.setProperty("jdbcUrl", string4);
    }

    private String relativePath(String string, String string2) {
        if (this.isAbsolute(string2)) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("/").append(string2);
        return stringBuffer.toString();
    }

    private boolean isAbsolute(String string) {
        return this.isWindows && string.matches("(([a-zA-Z]:(/|\\\\))|(//|\\\\\\\\)).*") || string.startsWith("/");
    }

    private void encryptPasswords(Properties properties) throws Exception {
        String string = null;
        String string2 = null;
        string = properties.getProperty("dbPassword");
        if (string != null) {
            string2 = Transform.transformString((String)string);
            properties.setProperty("dbPasswordDataEncrypted", string2);
            string2 = SRMCrypto.encrypt((String)string);
            properties.setProperty("dbPasswordDeviceEncrypted", string2);
            string2 = Base64.encode((byte[])string.getBytes());
            properties.setProperty("dbPasswordBirtEncrypted", string2);
        }
        if ((string = properties.getProperty("authPassword")) != null) {
            string2 = SRMCrypto.encrypt((String)string);
            properties.setProperty("authPasswordEncrypted", string2);
        }
    }

    private void checkJava() {
        String string = System.getProperty("java.version");
        ConfigureAperi.println("");
        ConfigureAperi.print("Checking Java installation...");
        try {
            String[] stringArray = string.split("\\.");
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            if (string2.equals("1") && string3.equals("5")) {
                ConfigureAperi.println("passed: " + string);
                ConfigureAperi.println("");
            } else {
                ConfigureAperi.println("WARNING");
                ConfigureAperi.println("Java " + string + " was unexpected. Continuing may have unpredictable results.");
                ConfigureAperi.println("");
            }
        }
        catch (Exception exception) {
            ConfigureAperi.println("Java " + string + " was unexpected. Continuing may have unpredictable results.");
        }
    }

    private void collectInputFromUser(boolean bl, boolean bl2, boolean bl3, Properties properties, boolean bl4) throws IOException {
        String string;
        if (bl) {
            ConfigureAperi.println("");
            ConfigureAperi.println("Enter values to configure the agent.");
            ConfigureAperi.println("");
            this.getIntegerFromUser("Agent port", "agentPort", 0, 65535, properties);
        }
        if (bl2 || bl) {
            ConfigureAperi.println("");
            if (bl2) {
                ConfigureAperi.println("Enter values to configure the device server.");
            } else {
                ConfigureAperi.println("Enter values to configure how the agent communicates with the device server.");
                ConfigureAperi.println("These must match how the device server is configured.");
            }
            ConfigureAperi.println("");
            this.getStringFromUser("Hostname ", "serverHostname", properties);
            this.getIntegerFromUser("Port ", "deviceServerPort", 0, 65535, properties);
            this.getStringFromUser("Password ", "authPassword", properties);
        }
        if (bl2 || bl3 || bl) {
            ConfigureAperi.println("");
            if (bl2) {
                ConfigureAperi.println("Enter values to configure the data server.");
            } else {
                ConfigureAperi.println("Enter values to configure how the GUI and agents communicate with the data server.");
                ConfigureAperi.println("These must match how the data server is configured.");
            }
            ConfigureAperi.println("");
            if (!bl2) {
                this.getStringFromUser("Hostname", "serverHostname", properties);
            }
            this.getIntegerFromUser("Port ", "dataServerPort", 0, 65535, properties);
            this.getIntegerFromUser("Port ", "dataServerHTTPPort", 0, 65535, properties);
        }
        if (bl2) {
            boolean bl5 = false;
            ConfigureAperi.println("");
            ConfigureAperi.println("Enter values to configure the report server.");
            ConfigureAperi.println("");
            this.getReportRepository(properties);
            while (!bl5) {
                String string2 = NO;
                string2 = this.shouldConfigure("Do you want to use Derby as the Aperi repository", YES);
                if (this.yesTest(string2)) {
                    properties.setProperty("rdbms", DERBY);
                    bl5 = true;
                    continue;
                }
                string2 = this.shouldConfigure("Do you want to use IBM DB2 as the Aperi repository", YES);
                if (this.yesTest(string2)) {
                    ConfigureAperi.println("DB2 should installed and running with database created named 'Aperi'.");
                    ConfigureAperi.println("You also need to have installed the com.ibm.db2 plugin.");
                    string2 = this.shouldConfigure("Is DB2 ready", YES);
                    if (this.yesTest(string2)) {
                        properties.setProperty("rdbms", DB2);
                        bl5 = true;
                        continue;
                    }
                    ConfigureAperi.println("You'll have to install DB2 and rerun cfgaperi.");
                    System.exit(-1);
                    continue;
                }
                ConfigureAperi.println("You have to pick one or the other.");
            }
            if (properties.getProperty("rdbms").equals(DERBY)) {
                this.collectDerbyInput(properties);
            } else {
                this.collectDB2Input(properties, bl4);
            }
        }
        if (this.yesTest(string = this.getStringFromUser("Download third party software", "download3rdParty", properties))) {
            this.manualMirrorSelection();
        }
    }

    private void collectDerbyInput(Properties properties) throws IOException {
        ConfigureAperi.println("Enter values to configure Derby.");
        ConfigureAperi.println("");
        this.getIntegerFromUser("Port ", "dbPort", 0, 65535, properties);
    }

    private void collectDB2Input(Properties properties, boolean bl) throws IOException {
        ConfigureAperi.println("Enter values to configure DB2.");
        ConfigureAperi.println("");
        properties.setProperty("dbPort", "50000");
        properties.setProperty("dbUsername", "db2admin");
        this.getIntegerFromUser("Port", "dbPort", 0, 65535, properties);
        this.getStringFromUser("DB2 username", "dbUsername", properties);
        this.getStringFromUser("Password", "dbPassword", properties);
        this.getStringFromUser("DB2 Command Line Processor Path", "db2cmdPath", properties);
    }

    private String getJavaPath(String string, String string2) {
        return "\"" + string + string2 + "bin" + string2 + "java\" ";
    }

    private void agent(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, boolean bl) throws Exception {
        ConfigureAperi.println("");
        ConfigureAperi.println("Configuring the agent...");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("manager.loc", string);
        hashtable.put("manager.port", string2);
        hashtable.put("agent.port", string3);
        hashtable.put("installLocation", string4);
        hashtable.put("tsnm.type", "agent");
        hashtable.put("installationPass", string5);
        String string13 = "../agent/configuration/setup.properties";
        ConfigureAperi.println(" " + string13);
        this.configureProperties(string13, hashtable);
        hashtable.clear();
        hashtable.put("installLocation", "\"" + string4 + "\"");
        hashtable.put("serverHost", string);
        hashtable.put("serverPort", string6);
        hashtable.put("agent.port", string3);
        string13 = "../agent/configuration/agent.config";
        ConfigureAperi.println(" " + string13);
        this.configureProperties(string13, hashtable);
        String string14 = "../agent/agent" + string9;
        ConfigureAperi.println(" " + string14);
        PrintWriter printWriter = new PrintWriter(new FileWriter(string14));
        this.prologue(printWriter, bl);
        printWriter.println(String.valueOf(string11) + "launch script for Aperi Agent");
        this.fixLibPath(printWriter, bl, string4);
        printWriter.println("cd " + string4 + string10 + "agent");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getJavaPath(string12, string10));
        stringBuffer.append(this.getAgentHeapSize(string7, string8));
        stringBuffer.append(" -Dosgi.install.area=.. ");
        stringBuffer.append("-Dosgi.configuration.area=./configuration ");
        stringBuffer.append("-Declipse.application.noDefault=true ");
        stringBuffer.append("-Dconnector.ssl.enabled=true ");
        stringBuffer.append("-Dorg.osgi.service.http.port=");
        stringBuffer.append(string3);
        stringBuffer.append(" -cp startup.jar ");
        stringBuffer.append("org.eclipse.core.launcher.Main");
        if (bl) {
            stringBuffer.append(" -console");
        }
        printWriter.println(stringBuffer.toString());
        printWriter.close();
        this.chmodx(string14, bl);
        this.chmodx("../agent/bin/linux-ix86/Attribute", bl);
        this.chmodx("../agent/bin/linux-ix86/Event", bl);
        this.chmodx("../agent/bin/linux-ix86/EventScanner", bl);
        this.chmodx("../agent/bin/linux-ix86/gethostname", bl);
        this.chmodx("../agent/bin/linux-ix86/Topology", bl);
        this.createLockDirectory(bl);
    }

    private void reportServer(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, String string9, Properties properties) throws Exception {
        ConfigureAperi.println("");
        ConfigureAperi.println("Configuring the report server...");
        ConfigureAperi.println("Creating report repository: " + string9);
        File file = new File(string9);
        file.mkdirs();
        if (!file.exists()) {
            throw new RuntimeException("Could not create: " + string9);
        }
        String string10 = this.locateReportingBundleDir().getCanonicalPath();
        String string11 = String.valueOf(string10) + File.separator + "web";
        String string12 = "../reporting/reporting" + string6;
        ConfigureAperi.println(" " + string12);
        PrintWriter printWriter = new PrintWriter(new FileWriter(string12));
        this.prologue(printWriter, bl);
        printWriter.println(String.valueOf(string7) + "launch script for Aperi report server");
        this.fixLibPath(printWriter, bl, string2);
        printWriter.println("cd " + string2 + string8 + "reporting");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getJavaPath(string3, string8));
        stringBuffer.append(this.getReportServerHeapSize(string4, string5));
        stringBuffer.append(" -Dosgi.install.area=.. ");
        stringBuffer.append("-Dosgi.configuration.area=./configuration ");
        stringBuffer.append("-Declipse.application.noDefault=true ");
        stringBuffer.append("-Dorg.eclipse.aperi.reporting.web=\"");
        stringBuffer.append(string11);
        stringBuffer.append("\" ");
        stringBuffer.append("-Dorg.eclipse.aperi.reporting.port=");
        stringBuffer.append(string);
        stringBuffer.append(" -Djava.security.auth.login.config=configuration/login.config");
        stringBuffer.append(" -cp startup.jar org.eclipse.core.launcher.Main");
        if (bl) {
            stringBuffer.append(" -console");
        }
        printWriter.println(stringBuffer.toString());
        printWriter.close();
        String string13 = "../reporting/configuration";
        FileReader fileReader = new FileReader(SEARCH_REPLACE);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String string14 = null;
        while ((string14 = bufferedReader.readLine()) != null) {
            string14.trim();
            if (string14.startsWith("#")) continue;
            String[] stringArray = string14.split(",");
            String string15 = stringArray[0].trim();
            String string16 = stringArray[1].trim();
            String string17 = stringArray[2].trim();
            int n = Integer.parseInt(stringArray[3].trim());
            String string18 = properties.getProperty(stringArray[4].trim());
            SearchAndReplace.replace(string11, string15, string16, string17, n, string18);
            SearchAndReplace.replace(string13, string15, string16, string17, n, string18);
            SearchAndReplace.replace(string9, string15, string16, string17, n, string18);
        }
        this.chmodx("../reporting/reporting", bl);
    }

    private String getGuiHeapSize(String string, String string2) {
        return " " + string + string2 + " ";
    }

    private String getDataServerHeapSize(String string, String string2) {
        return " " + string + string2 + " ";
    }

    private String getDeviceServerHeapSize(String string, String string2) {
        return " " + string + string2 + " ";
    }

    private String getAgentHeapSize(String string, String string2) {
        return " " + string + string2 + " ";
    }

    private String getReportServerHeapSize(String string, String string2) {
        return " " + string + string2 + " ";
    }

    private String getDerbyHeapSize(String string, String string2) {
        return " " + string + string2 + " ";
    }

    private void configureDatabase(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, String string8, String string9, String string10, String string11, String string12, String string13, String string14) throws Exception {
        if (string.equals(DERBY)) {
            this.derby(string2, string3, string4, string5, string6, string7, bl, string8, string9, string10, string11, string12, string13, string14);
        }
    }

    private void derby(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, String string7, String string8, String string9, String string10, String string11, String string12, String string13) throws Exception {
        ConfigureAperi.println("");
        ConfigureAperi.println("Configuring derby...");
        String string14 = "../db/derby" + string;
        ConfigureAperi.println(" " + string14);
        PrintWriter printWriter = new PrintWriter(new FileWriter(string14));
        this.prologue(printWriter, bl);
        printWriter.println(String.valueOf(string3) + " JAVA_HOME=" + string4);
        printWriter.println(String.valueOf(string3) + " DERBY_INSTALL=" + string6 + string2 + "db");
        printWriter.println(String.valueOf(string3) + " CLASSPATH=" + this.value("CLASSPATH", bl) + string5 + ".." + string2 + "plugins" + string2 + "org.eclipse.aperi.db_1.0.0" + string2 + "derby.jar" + string5 + ".." + string2 + "plugins" + string2 + "org.eclipse.aperi.db_1.0.0" + string2 + "derbynet.jar" + string5 + ".." + string2 + "plugins" + string2 + "org.eclipse.aperi.db_1.0.0" + string2 + "derbyclient.jar" + string5 + ".." + string2 + "plugins" + string2 + "org.eclipse.aperi.db_1.0.0" + string2 + "derbytools.jar" + string5);
        printWriter.println("cd " + this.value("DERBY_INSTALL", bl));
        printWriter.println("\"" + this.value("JAVA_HOME", bl) + string2 + "bin" + string2 + "java\" " + "-Dorg.eclipse.aperi.sanmgmt.logging.disable=true " + this.getDerbyHeapSize(string7, string8) + "org.apache.derby.drda.NetworkServerControl start -h " + string9 + " -p " + string10);
        printWriter.close();
        this.chmodx(string14, bl);
        String string15 = "../db/derbystop" + string;
        ConfigureAperi.println(" " + string15);
        printWriter = new PrintWriter(new FileWriter(string15));
        this.prologue(printWriter, bl);
        printWriter.println(String.valueOf(string3) + " JAVA_HOME=" + string4);
        printWriter.println(String.valueOf(string3) + " DERBY_INSTALL=" + string6 + string2 + "db");
        printWriter.println(String.valueOf(string3) + " CLASSPATH=" + this.value("CLASSPATH", bl) + string5 + ".." + string2 + "plugins" + string2 + "org.eclipse.aperi.db_1.0.0" + string2 + "derby.jar" + string5 + ".." + string2 + "plugins" + string2 + "org.eclipse.aperi.db_1.0.0" + string2 + "derbynet.jar" + string5 + ".." + string2 + "plugins" + string2 + "org.eclipse.aperi.db_1.0.0" + string2 + "derbyclient.jar" + string5 + ".." + string2 + "plugins" + string2 + "org.eclipse.aperi.db_1.0.0" + string2 + "derbytools.jar" + string5);
        printWriter.println("cd " + this.value("DERBY_INSTALL", bl));
        printWriter.println("\"" + this.value("JAVA_HOME", bl) + string2 + "bin" + string2 + "java\" " + "org.apache.derby.drda.NetworkServerControl shutdown -h " + string9 + " -p " + string10);
        printWriter.close();
        this.chmodx(string15, bl);
        String string16 = "../db/aperi-ij" + string;
        ConfigureAperi.println(" " + string16);
        printWriter = new PrintWriter(new FileWriter(string16));
        this.prologue(printWriter, bl);
        printWriter.println(String.valueOf(string3) + " JAVA_HOME=" + string4);
        printWriter.println(String.valueOf(string3) + " DERBY_INSTALL=" + string6 + string2 + "db");
        printWriter.println(String.valueOf(string3) + " CLASSPATH=" + this.value("CLASSPATH", bl) + string5 + ".." + string2 + "plugins" + string2 + "org.eclipse.aperi.db_1.0.0" + string2 + "derby.jar" + string5 + ".." + string2 + "plugins" + string2 + "org.eclipse.aperi.db_1.0.0" + string2 + "derbynet.jar" + string5 + ".." + string2 + "plugins" + string2 + "org.eclipse.aperi.db_1.0.0" + string2 + "derbyclient.jar" + string5 + ".." + string2 + "plugins" + string2 + "org.eclipse.aperi.db_1.0.0" + string2 + "derbytools.jar" + string5);
        printWriter.println("cd " + this.value("DERBY_INSTALL", bl));
        printWriter.println("\"" + this.value("JAVA_HOME", bl) + string2 + "bin" + string2 + "java\" " + "-Dij.driver=org.apache.derby.jdbc.ClientDriver " + "-Dij.protocol=jdbc:derby://" + string9 + ":" + string10 + "/ -Dij.user=" + string11 + " -Dij.password=" + string12 + " org.apache.derby.tools.ij");
        printWriter.close();
        this.chmodx(string16, bl);
    }

    private void dataserver(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, boolean bl) throws Exception {
        ConfigureAperi.println("");
        ConfigureAperi.println("Configuring the data server... ");
        String string17 = "datasvr/configuration/server.config";
        ConfigureAperi.println(" " + string17);
        PrintWriter printWriter = new PrintWriter(new FileWriter("../" + string17));
        BufferedReader bufferedReader = new BufferedReader(new FileReader("../" + string17 + ".in"));
        String string18 = "";
        while ((string18 = bufferedReader.readLine()) != null) {
            if (string18.startsWith("name") && string18.indexOf("SERVERHOST") > 0) {
                printWriter.println("name=\"" + string + "\"");
                continue;
            }
            if (string18.startsWith("port")) {
                printWriter.println("port=" + string2);
                continue;
            }
            if (string18.startsWith("driver")) {
                printWriter.println("driver=" + string3);
                continue;
            }
            if (string18.startsWith("url")) {
                printWriter.println("url=\"jdbc:" + string4 + "://" + string + ":" + string5 + "/Aperi\"");
                continue;
            }
            if (string18.startsWith("user")) {
                printWriter.println("user=" + string6);
                continue;
            }
            if (string18.startsWith("schema")) {
                printWriter.println("schema=Aperi");
                continue;
            }
            if (string18.startsWith("reportServerPort")) {
                printWriter.println("reportServerPort=" + string12);
                continue;
            }
            printWriter.println(string18);
        }
        printWriter.close();
        string17 = "../datasvr/configuration/repository.config";
        if (!Transform.putTransformed((String)string7, (String)string17)) {
            System.out.println("can't write repository.config");
            System.exit(-1);
        }
        String string19 = "../datasvr/datasvr" + string14;
        ConfigureAperi.println(" " + string19);
        printWriter = new PrintWriter(new FileWriter(string19));
        this.prologue(printWriter, bl);
        printWriter.println(String.valueOf(string15) + "launch script for Aperi Data Server");
        this.fixLibPath(printWriter, bl, string8);
        printWriter.println("cd " + string8 + string16 + "datasvr");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getJavaPath(string9, string16));
        stringBuffer.append(this.getDataServerHeapSize(string10, string11));
        stringBuffer.append(" -Dosgi.install.area=.. ");
        stringBuffer.append("-Dosgi.configuration.area=./configuration ");
        stringBuffer.append("-Declipse.application.noDefault=true ");
        stringBuffer.append("-Dconnector.ssl.enabled=true ");
        stringBuffer.append("-Dorg.osgi.service.http.port=");
        stringBuffer.append(string13);
        stringBuffer.append(" -cp startup.jar ");
        stringBuffer.append("org.eclipse.core.launcher.Main");
        if (bl) {
            stringBuffer.append(" -console");
        }
        printWriter.println(stringBuffer.toString());
        printWriter.close();
        this.chmodx(string19, bl);
    }

    private void deviceserver(boolean bl, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15) throws Exception {
        ConfigureAperi.println("");
        ConfigureAperi.println("Configuring the device server...");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("manager.loc", "localhost");
        hashtable.put("manager.port", string);
        hashtable.put("agent.port", string2);
        hashtable.put("installLocation", string3);
        hashtable.put("tsnm.type", "manager");
        hashtable.put("installationPass", string4);
        String string16 = "devsvr/configuration/setup.properties";
        ConfigureAperi.println(" " + string16);
        this.configureProperties("../" + string16, hashtable);
        hashtable.clear();
        hashtable.put("tivoli.sanmgmt.jdbc.dbURL", string10);
        hashtable.put("tivoli.sanmgmt.jdbc.dbDriver", string5);
        hashtable.put("tivoli.sanmgmt.jdbc.dbUser", string6);
        hashtable.put("tivoli.sanmgmt.jdbc.dbPassword", string12);
        hashtable.put("tivoli.sanmgmt.jdbc.dbAdmin", string6);
        hashtable.put("tivoli.sanmgmt.jdbc.database", "Aperi");
        hashtable.put("tivoli.sanmgmt.jdbc.dbSchema", "Aperi");
        string16 = "devsvr/configuration/tsnmdbparms.properties";
        ConfigureAperi.println(" " + string16);
        this.configureProperties("../" + string16, hashtable);
        String string17 = "../devsvr/devsvr" + string14;
        ConfigureAperi.println(" " + string17);
        PrintWriter printWriter = new PrintWriter(new FileWriter(string17));
        this.prologue(printWriter, bl);
        printWriter.println(String.valueOf(string13) + "launch script for Aperi Device Server");
        this.fixLibPath(printWriter, bl, string3);
        printWriter.println("cd " + string3 + string15 + "devsvr");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getJavaPath(string7, string15));
        stringBuffer.append(this.getDeviceServerHeapSize(string8, string9));
        stringBuffer.append(" -Dosgi.install.area=.. ");
        stringBuffer.append("-Dosgi.configuration.area=./configuration ");
        stringBuffer.append("-Declipse.application.noDefault=true");
        stringBuffer.append(" -Dconnector.ssl.enabled=true ");
        stringBuffer.append(" -Dorg.osgi.service.http.port=");
        stringBuffer.append(string);
        stringBuffer.append(" -cp startup.jar ");
        stringBuffer.append("org.eclipse.core.launcher.Main");
        if (bl) {
            stringBuffer.append(" -console");
        }
        printWriter.println(stringBuffer.toString());
        printWriter.close();
        this.chmodx(string17, bl);
    }

    private void gui(String string, String string2, String string3, boolean bl, String string4, String string5, String string6, String string7, String string8, String string9) throws Exception {
        ConfigureAperi.println("");
        ConfigureAperi.println("Configuring the gui...");
        PrintWriter printWriter = new PrintWriter(new FileWriter("../gui/gui.properties"));
        printWriter.println("server = " + string + ":" + string2);
        printWriter.close();
        String string10 = "../gui/gui" + string3;
        ConfigureAperi.println(" " + string10);
        printWriter = new PrintWriter(new FileWriter(string10));
        this.prologue(printWriter, bl);
        printWriter.println(String.valueOf(string4) + "launch script for Aperi GUI");
        printWriter.println("cd " + string5 + string7 + "gui");
        printWriter.println(String.valueOf(this.getJavaPath(string6, string7)) + this.getGuiHeapSize(string8, string9) + " -Dosgi.install.area=.. " + "-Dosgi.configuration.area=./configuration " + "-Declipse.application.noDefault=true " + "-cp startup.jar " + "org.eclipse.core.launcher.Main");
        printWriter.close();
        this.chmodx(string10, bl);
        this.chmodx("../rcpgui/AperiRcpGui", bl);
    }

    private void startScript(String string, String string2, String string3, String string4, String string5, boolean bl) throws Exception {
        ConfigureAperi.println("");
        ConfigureAperi.println("Generating start script...");
        String string6 = "../aperi" + string;
        ConfigureAperi.println(" " + string6);
        PrintWriter printWriter = new PrintWriter(new FileWriter(string6));
        this.prologue(printWriter, bl);
        printWriter.println(String.valueOf(string2) + "launch script for Aperi server and agent");
        printWriter.println("cd " + string3);
        String[] stringArray = new String[]{"db", "datasvr", "devsvr", "agent", "reporting"};
        int n = 0;
        while (n < stringArray.length) {
            if (string4 != DB2 || !stringArray[n].equals("db")) {
                String string7 = "";
                String string8 = "";
                string7 = stringArray[n].equals("db") ? DERBY : stringArray[n];
                string8 = String.valueOf(stringArray[n]) + string5 + string7 + string;
                if (bl) {
                    printWriter.println("if exist " + string8 + " ( start " + string8 + " )");
                    if (n < stringArray.length - 1) {
                        printWriter.println("pause");
                    }
                } else {
                    printWriter.println("if [ -x " + string8 + " ]; then");
                    printWriter.println("  " + string8 + " &");
                    if (n < stringArray.length - 1) {
                        printWriter.println("  sleep 10");
                    }
                    printWriter.println("fi");
                }
            }
            ++n;
        }
        printWriter.close();
        this.chmodx(string6, bl);
    }

    private void guid(String string, String string2) throws Exception {
        ConfigureAperi.println("");
        ConfigureAperi.println("Generating GUID for this host...");
        UUID uUID = UUID.randomUUID();
        GUIDImpl gUIDImpl = new GUIDImpl(uUID);
        ConfigureAperi.println("GUID is " + uUID);
        String string3 = String.valueOf(string) + string2 + "guid.txt";
        ConfigureAperi.println("Storing in " + string3);
        PrintWriter printWriter = new PrintWriter(new FileWriter(string3));
        printWriter.println(gUIDImpl);
        printWriter.close();
    }

    private void schema(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, boolean bl) throws Exception {
        Object object;
        ConfigureAperi.println("");
        if (string.equals(DERBY)) {
            ConfigureAperi.println("Next, the Derby RDBMS will be started");
            ConfigureAperi.println("and the Aperi schema created.");
        } else {
            ConfigureAperi.println("Next, the Aperi schema will be created.");
        }
        NetworkServerControl networkServerControl = null;
        if (string.equals(DERBY)) {
            object = String.valueOf(string2) + string3 + "db" + string3 + "Aperi";
            File file = new File((String)object);
            if (file.exists()) {
                ConfigureAperi.println("");
                ConfigureAperi.println("The schema already exists. This configure script must exit.");
                ConfigureAperi.println("You may wish to delete the schema directory (" + (String)object + ")");
                ConfigureAperi.println("and re-run this script.");
                System.exit(-1);
            }
            DerbyThread derbyThread = new DerbyThread(string10, string11);
            derbyThread.start();
            networkServerControl = new NetworkServerControl(InetAddress.getByName(string4), Integer.parseInt(string11));
            int n = 1;
            while (n <= 10) {
                try {
                    ConfigureAperi.print(".");
                    Thread.sleep(500L);
                    networkServerControl.ping();
                    break;
                }
                catch (Exception exception) {
                    if (n == 10) {
                        ConfigureAperi.println("");
                        ConfigureAperi.println("Derby did not come up. Consult the installation");
                        ConfigureAperi.println("documentation for more information.");
                        return;
                    }
                    ++n;
                }
            }
            ConfigureAperi.println("");
            ConfigureAperi.println("Now the schema will be loaded.");
        } else if (string.equals(DB2)) {
            object = String.valueOf(bl ? "\"" + string5 + string3 + "db2cmd\" /c " : "") + "scripts/db2config" + string6 + " " + string7 + " " + string8 + " Aperi Create 2500 -1 65537 1000 10240 1024 40000 4096 10240 50 10000 150 8 16";
            try {
                this.runCmd((String)object);
                String string15 = String.valueOf(bl ? System.getenv("TEMP") : "/tmp") + string3 + "done";
                ConfigureAperi.println("Waiting for the configuration to be updated in " + string15);
                File file = new File(string15);
                while (!file.exists()) {
                    Thread.sleep(5000L);
                }
                ConfigureAperi.println("Configurationhas been updated.");
                file.delete();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ConfigureAperi.println("Exception occured in configuring DB2. Please change to the directory db and run:" + (String)object);
            }
        }
        this.runSilentDatabaseInstall(string, string6, string4, string11, string7, string9, string2, string3);
        object = new ArrayList();
        object.add(string14);
        object.add(CANNED_REPORTS);
        object.add(string12);
        object.add(string13);
        object.add(string7);
        object.add(string9);
        BulkLoader.main((String[])object.toArray(new String[object.size()]));
        ConfigureAperi.println("The output above should indicate that the schema was created");
        ConfigureAperi.println("successfully on your system. If there was an error,");
        ConfigureAperi.println("Aperi will not function correctly. Consult the installation");
        ConfigureAperi.println("documentation for more information.");
        ConfigureAperi.println("");
        if (string.equals(DERBY)) {
            ConfigureAperi.println("Shutting Derby down.");
            networkServerControl.shutdown();
        }
    }

    protected int runSilentDatabaseInstall(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws Exception {
        String string9 = null;
        String string10 = null;
        if (string.equals(DERBY)) {
            string9 = DERBY;
            string10 = DERBY_DRIVER;
        } else {
            string9 = DB2;
            string10 = DB2_DRIVER;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-mode");
        arrayList.add("install");
        arrayList.add("-jdbcdriver");
        arrayList.add(string10);
        arrayList.add("-schema");
        arrayList.add("Aperi");
        arrayList.add("-database");
        arrayList.add("Aperi");
        arrayList.add("-dbmstype");
        arrayList.add(string9);
        arrayList.add("-dbhost");
        arrayList.add(string3);
        arrayList.add("-dbport");
        arrayList.add(string4);
        arrayList.add("-dbuser");
        arrayList.add(string5);
        arrayList.add("-dbpassword");
        String string11 = string6;
        arrayList.add(string11);
        arrayList.add("-path");
        arrayList.add(String.valueOf(string7) + string8 + "db" + string8 + "schema");
        SilentDatabaseInstall.exitOnComplete = false;
        SilentDatabaseInstall.main(arrayList.toArray(new String[arrayList.size()]));
        ConfigureAperi.println("");
        return 0;
    }

    String getServerHostName(String string, String string2) throws Exception {
        String string3 = "";
        boolean bl = true;
        while (bl) {
            ConfigureAperi.print(String.valueOf(string) + " [" + string2 + "]: ");
            string3 = this.getLine();
            if (string3.equals("")) {
                string3 = string2;
            }
            try {
                InetAddress.getByName(string3);
                bl = false;
            }
            catch (UnknownHostException unknownHostException) {
                ConfigureAperi.println("Unknown host.");
            }
        }
        return string3;
    }

    private String getStringFromUser(String string, String string2, Properties properties) throws IOException {
        String string3 = properties.getProperty(string2);
        if (string3 == null) {
            string3 = "";
        }
        String string4 = "";
        boolean bl = true;
        while (bl) {
            ConfigureAperi.print(string);
            if (string3 == null || !string3.equals("")) {
                ConfigureAperi.print(" [" + string3 + "]");
            }
            ConfigureAperi.print(": ");
            string4 = this.getLine();
            if (string4.equals("")) {
                string4 = string3;
            }
            if (string4.equals("")) {
                ConfigureAperi.println("Value must not be blank.");
                continue;
            }
            bl = false;
        }
        properties.setProperty(string2, string4);
        return string4;
    }

    private boolean shouldConfigure(String string, String string2, Properties properties) throws IOException {
        String string3 = properties.getProperty(string2);
        if (string3 == null) {
            string3 = "";
        }
        String string4 = this.yorn(String.valueOf(string) + " [" + string3 + "]", string3);
        properties.setProperty(string2, string4);
        return this.yesTest(string4);
    }

    private String shouldConfigure(String string, String string2) throws IOException {
        return this.yorn(String.valueOf(string) + " [" + string2 + "]", string2);
    }

    private String getLine() throws IOException {
        return new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    private String yorn(String string, String string2) throws IOException {
        String string3 = NO;
        boolean bl = true;
        while (bl) {
            ConfigureAperi.print(string);
            String string4 = this.getLine();
            string4 = string4.toUpperCase();
            if (string4.startsWith("Y")) {
                string3 = YES;
                bl = false;
            }
            if (string4.startsWith("N")) {
                string3 = NO;
                bl = false;
            }
            if (!string4.equals("")) continue;
            string3 = string2;
            bl = false;
        }
        return string3;
    }

    private void configureProperties(String string, Hashtable hashtable) throws Exception {
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(string);
        properties.load(fileInputStream);
        fileInputStream.close();
        Object object = hashtable.keys();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            String string3 = (String)hashtable.get(string2);
            properties.setProperty(string2, string3);
        }
        object = new FileOutputStream(string);
        properties.store((OutputStream)object, null);
        ((FileOutputStream)object).close();
    }

    static void print(String string) {
        System.out.print(string);
    }

    static void println(String string) {
        System.out.println(string);
    }

    private void prologue(PrintWriter printWriter, boolean bl) {
        if (bl) {
            printWriter.println("@echo off");
        } else {
            printWriter.println("#!/bin/sh");
        }
    }

    private String value(String string, boolean bl) {
        string = bl ? "%" + string + "%" : "$" + string;
        return string;
    }

    private int runCmd(String string) throws Exception {
        ConfigureAperi.println("Running " + string);
        ConfigureAperi.println("----");
        Process process = Runtime.getRuntime().exec(string);
        ReaderThread readerThread = new ReaderThread(process);
        readerThread.run();
        int n = process.waitFor();
        ConfigureAperi.println("----");
        return n;
    }

    private int chmodx(String string, boolean bl) throws Exception {
        int n = 0;
        if (!bl) {
            Process process = Runtime.getRuntime().exec("chmod +x " + string);
            n = process.waitFor();
        }
        return n;
    }

    private void fixLibPath(PrintWriter printWriter, boolean bl, String string) {
        if (bl) {
            printWriter.println("set PATH=" + string + "\\lib\\w32-ix86;%PATH%");
        } else {
            printWriter.println("export LD_LIBRARY_PATH=" + string + "/lib/linux-ix86:$LD_LIBRARY_PATH");
        }
    }

    private void createLockDirectory(boolean bl) {
        File file;
        if (!(bl || (file = new File(lockDirectory)).exists() && file.isDirectory())) {
            ConfigureAperi.println("Creating the lock directory /etc/Tivoli/TSRM/lock");
            if (!file.mkdirs()) {
                ConfigureAperi.println("Failed to create the lock direcgtory");
            }
        }
    }

    private void setDB(Properties properties) {
        String string = properties.getProperty("rdbms");
        if (string.equals(DERBY)) {
            properties.setProperty("dbDriver", DERBY_DRIVER);
            properties.setProperty("dbType", DERBY);
        } else if (string.equals(DB2)) {
            properties.setProperty("dbDriver", DB2_DRIVER);
            properties.setProperty("dbType", DB2);
        } else {
            System.out.println("Unknown RDBMS value");
            System.exit(-1);
        }
    }

    private void manualMirrorSelection() {
        Vector<IDownload> vector = this.downloadConfig.getMirroredDownloads();
        Iterator<IDownload> iterator = vector.iterator();
        while (iterator.hasNext()) {
            IDownload iDownload = iterator.next();
            ConfigureAperi.println("");
            ConfigureAperi.println("Please select a mirror for " + iDownload.getDescription() + ":");
            try {
                Vector<IMirror> vector2 = iDownload.getMirrors();
                int n = 0;
                while (n < vector2.size()) {
                    ConfigureAperi.println(String.valueOf(n) + ". " + vector2.elementAt(n).getDescription());
                    ++n;
                }
                n = Integer.parseInt(this.getIntegerFromUser("Mirror", "0", 0, vector2.size()));
                iDownload.setFileUrl(vector2.elementAt(n).getFileUrl());
            }
            catch (Exception exception) {
                ConfigureAperi.println("Failed to retrieve the list of mirrors.");
                exception.printStackTrace();
                System.exit(-1);
            }
        }
    }

    private void automaticMirrorSelection() {
        Vector<IDownload> vector = this.downloadConfig.getMirroredDownloads();
        Iterator<IDownload> iterator = vector.iterator();
        while (iterator.hasNext()) {
            ConfigureAperi.println("");
            IDownload iDownload = iterator.next();
            try {
                Vector<IMirror> vector2 = iDownload.getMirrors();
                iDownload.setFileUrl(vector2.elementAt(0).getFileUrl());
                ConfigureAperi.println("Selected mirror " + vector2.elementAt(0).getDescription() + "\n" + "for " + iDownload.getDescription());
            }
            catch (Exception exception) {
                ConfigureAperi.println("Failed to retrieve the list of mirrors for " + iDownload.getDescription());
                exception.printStackTrace();
                System.exit(-1);
            }
        }
    }

    void printDownloads(String[] stringArray, int n) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(n++);
            stringBuffer.append(". ");
            stringBuffer.append(stringArray[n2]);
            ConfigureAperi.print(stringBuffer.toString());
            ++n2;
        }
    }

    private void download3rdPartySoftware(Properties properties) {
        ConfigureAperi.println("");
        ConfigureAperi.println("Downloading the third party software.");
        String string = properties.getProperty("installDir");
        File file = new File(String.valueOf(string) + File.separator + "download");
        if (!file.exists()) {
            file.mkdir();
        }
        Vector<IDownload> vector = this.downloadConfig.getDownloads();
        Iterator<IDownload> iterator = vector.iterator();
        while (iterator.hasNext()) {
            IDownload iDownload = iterator.next();
            try {
                iDownload.downloadFile(file.getAbsolutePath(), string);
            }
            catch (Exception exception) {
                ConfigureAperi.println("Download failed: " + iDownload.getDescription());
                exception.printStackTrace();
                System.exit(-1);
            }
        }
        ConfigureAperi.println("Downloads complete.");
    }

    private String getIntegerFromUser(String string, String string2, int n, int n2, Properties properties) throws IOException {
        String string3 = "";
        boolean bl = true;
        String string4 = properties.getProperty(string2);
        if (string4 == null) {
            string4 = "";
        }
        while (bl) {
            ConfigureAperi.print(String.valueOf(string) + " [" + string4 + "]: ");
            string3 = this.getLine();
            if (string3.equals("")) {
                string3 = string4;
            }
            try {
                int n3 = Integer.parseInt(string3);
                if (n3 < n || n3 > n2) {
                    ConfigureAperi.println(String.valueOf(string) + " must be a number from " + n + " to " + n2 + ".");
                    continue;
                }
                bl = false;
            }
            catch (NumberFormatException numberFormatException) {
                ConfigureAperi.println("Port must be a number from 0 to 65535.");
            }
        }
        properties.setProperty(string2, string3);
        return string3;
    }

    private String getIntegerFromUser(String string, String string2, int n, int n2) throws IOException {
        String string3 = "";
        boolean bl = true;
        while (bl) {
            ConfigureAperi.print(String.valueOf(string) + " [" + string2 + "]: ");
            string3 = this.getLine();
            if (string3.equals("")) {
                string3 = string2;
            }
            try {
                int n3 = Integer.parseInt(string3);
                if (n3 < n || n3 > n2) {
                    ConfigureAperi.println(String.valueOf(string) + " must be a number from " + n + " to " + n2 + ".");
                    continue;
                }
                bl = false;
            }
            catch (NumberFormatException numberFormatException) {
                ConfigureAperi.println("Port must be a number from 0 to 65535.");
            }
        }
        return string3;
    }

    private boolean yesTest(String string) {
        return string.equalsIgnoreCase(YES);
    }

    private void load3rdPartyConfiguration() {
        try {
            this.downloadConfig = new DownloadConfig("../configure/download.xml");
        }
        catch (Exception exception) {
            ConfigureAperi.println("Error while loading the third party software configuration.");
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    private void replaceBackslash(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            string2.replace('\\', '/');
            properties.setProperty(string, string2);
        }
    }

    private File locateReportingBundleDir() throws Exception {
        File[] fileArray;
        File file = null;
        String string = System.getProperty("pluginDir", "../plugins");
        File file2 = new File(string);
        if (file2.exists() && file2.isDirectory()) {
            fileArray = file2.listFiles(new ReportingBundleFilenameFilter());
            if (fileArray.length != 1) {
                throw new Exception("Failed to locate the plugin org.eclipse.aperi.reporting");
            }
        } else {
            throw new Exception("Directory not found: " + string);
        }
        file = fileArray[0];
        return file;
    }

    private void getReportRepository(Properties properties) throws IOException {
        boolean bl = false;
        while (!bl) {
            String string = this.getStringFromUser("Report server repository path", "reportRepository", properties);
            File file = new File(string);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    ConfigureAperi.println(String.valueOf(string) + " is not a directory.");
                    continue;
                }
                bl = true;
                continue;
            }
            ConfigureAperi.println(String.valueOf(string) + " Does not exist. Will be created.");
            bl = true;
        }
    }

    class DerbyThread
    extends Thread {
        private String serverHostName = null;
        private String dbPort = null;

        public DerbyThread(String string, String string2) {
            this.serverHostName = string;
            this.dbPort = string2;
        }

        public void run() {
            try {
                NetworkServerControl networkServerControl = new NetworkServerControl(InetAddress.getByName(this.serverHostName), Integer.parseInt(this.dbPort));
                networkServerControl.start(null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class ReaderThread
    extends Thread {
        Process proc;

        ReaderThread(Process process) {
            this.proc = process;
        }

        public void run() {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
                Object object = bufferedReader.readLine();
                while (object != null) {
                    ConfigureAperi.print("   ");
                    ConfigureAperi.println((String)object);
                    object = bufferedReader.readLine();
                }
                object = new BufferedReader(new InputStreamReader(this.proc.getErrorStream()));
                String string = ((BufferedReader)object).readLine();
                while (string != null) {
                    ConfigureAperi.print("   ");
                    ConfigureAperi.println(string);
                    string = ((BufferedReader)object).readLine();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private class ReportingBundleFilenameFilter
    implements FilenameFilter {
        private ReportingBundleFilenameFilter() {
        }

        public boolean accept(File file, String string) {
            boolean bl = false;
            if (string.startsWith("org.eclipse.aperi.reporting") && !string.contains(new StringBuffer("jaas"))) {
                bl = true;
            }
            return bl;
        }
    }
}

