/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class RepositoryAccessor {
    protected PreparedStatement selectStmt;
    protected PreparedStatement deleteStmt;
    protected PreparedStatement insertStmt;
    protected PreparedStatement updateStmt;
    protected Statement staticStmt;
    protected Connection dbc;
    protected ResultSet resultSet;
    protected String tableName;
    protected boolean inCleanUp;
    protected int stmtType;
    protected int stmtPhase;
    protected int colIndex;
    protected Timestamp timestamp = new Timestamp(0L);
    protected boolean logSQLErrors = true;
    private Statement commitStmt;
    private String selectSQL;
    private String deleteSQL;
    private String insertSQL;
    private String updateSQL;
    protected static final int SELECT_STMT = 0;
    protected static final int INSERT_STMT = 1;
    protected static final int UPDATE_STMT = 2;
    protected static final int DELETE_STMT = 3;
    protected static final int SET_PHASE = 0;
    protected static final int GET_PHASE = 1;
    protected static final int FETCH_PHASE = 2;
    protected static final int EXECUTE_PHASE = 3;
    protected static final int COMMIT_PHASE = 4;
    protected static final String[] STMT_TYPE = new String[]{"SELECT", "INSERT", "UPDATE", "DELETE"};
    protected static final String[] PHASE_TYPE = new String[]{"SET", "GET", "FETCH", "EXECUTE", "COMMIT"};

    protected RepositoryAccessor(Connection connection) {
        this.dbc = connection;
    }

    protected Statement createStatement() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"createStatement", (String)"");
        }
        try {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"createStatement");
            }
            return this.dbc.createStatement();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"createStatement", (Throwable)sQLException);
            }
            this.cleanup();
            throw SQLUtil.getGeneralException("SRV0155E", sQLException, null);
        }
    }

    protected PreparedStatement prepareStmt(String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepareStmt", (String)"sqlText");
        }
        try {
            if (string.length() == 0) {
                string = "_EMPTY_";
                throw new SQLException();
            }
            this.setSQLText(string);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"prepareStmt");
            }
            return this.dbc.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"prepareStmt", (Throwable)sQLException);
            }
            Object[] objectArray = new Object[]{string.substring(0, 7), this.tableName};
            this.cleanup();
            throw SQLUtil.getGeneralException("SRV0078E", sQLException, objectArray);
        }
    }

    protected void setSQLText(String string) {
        if (string.length() != 0) {
            switch (string.charAt(0)) {
                case 'S': 
                case 's': {
                    this.selectSQL = string;
                    this.stmtType = 0;
                    break;
                }
                case 'I': 
                case 'i': {
                    this.insertSQL = string;
                    this.stmtType = 1;
                    break;
                }
                case 'U': 
                case 'u': {
                    this.updateSQL = string;
                    this.stmtType = 2;
                    break;
                }
                case 'D': 
                case 'd': {
                    this.deleteSQL = string;
                    this.stmtType = 3;
                }
            }
        } else {
            this.selectSQL = "_EMPTY_";
            this.stmtType = 0;
        }
    }

    public void execQueryByID(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"execQueryByID", (String)"id");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"execQueryByID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"execQueryByID");
        }
    }

    protected int executeUpdate(PreparedStatement preparedStatement) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"executeUpdate", (String)"stmt");
        }
        this.stmtPhase = 3;
        int n = preparedStatement.executeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"executeUpdate", (int)n);
        }
        return n;
    }

    protected boolean nextResult() throws GeneralException {
        return this.nextResult(this.resultSet);
    }

    protected boolean nextResult(ResultSet resultSet) throws GeneralException {
        try {
            return resultSet.next();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"nextResult", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.stmtPhase = 2;
            this.sqlError(sQLException);
            return false;
        }
    }

    protected void setPhase() {
        this.stmtPhase = 0;
        this.colIndex = 1;
    }

    protected void getPhase() {
        this.stmtPhase = 1;
        this.colIndex = 1;
    }

    protected void setBoolean(PreparedStatement preparedStatement, boolean bl) throws SQLException {
        if (SQLUtil.isCloudscape()) {
            SQLUtil.setBoolean(preparedStatement, this.colIndex++, bl);
        } else {
            preparedStatement.setBoolean(this.colIndex++, bl);
        }
    }

    protected void setByte(PreparedStatement preparedStatement, byte by) throws SQLException {
        if (SQLUtil.isSybase()) {
            byte by2 = by;
            String string = String.valueOf(by2);
            preparedStatement.setString(this.colIndex++, string);
            return;
        }
        preparedStatement.setByte(this.colIndex++, by);
    }

    protected void setBytes(PreparedStatement preparedStatement, byte[] byArray) throws SQLException {
        preparedStatement.setBytes(this.colIndex++, byArray);
    }

    protected void setShort(PreparedStatement preparedStatement, short s) throws SQLException {
        preparedStatement.setShort(this.colIndex++, s);
    }

    protected void setInt(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setInt(this.colIndex++, n);
    }

    protected void setLong(PreparedStatement preparedStatement, long l) throws SQLException {
        preparedStatement.setLong(this.colIndex++, l);
    }

    protected void setDouble(PreparedStatement preparedStatement, double d) throws SQLException {
        preparedStatement.setDouble(this.colIndex++, d);
    }

    private static long discardMillis(long l) {
        long l2 = l % 1000L;
        return l - l2;
    }

    protected void setTimestamp(PreparedStatement preparedStatement, long l) throws SQLException {
        this.timestamp.setTime(RepositoryAccessor.discardMillis(l));
        preparedStatement.setTimestamp(this.colIndex++, this.timestamp);
    }

    protected void setTimestamp(PreparedStatement preparedStatement, long l, Timestamp timestamp) throws SQLException {
        timestamp.setTime(RepositoryAccessor.discardMillis(l));
        preparedStatement.setTimestamp(this.colIndex++, timestamp);
    }

    protected void setString(PreparedStatement preparedStatement, String string) throws SQLException {
        if (string == null || string.length() == 0) {
            string = " ";
        }
        preparedStatement.setString(this.colIndex++, string);
    }

    protected boolean getBoolean(ResultSet resultSet) throws SQLException {
        return SQLUtil.getBoolean(resultSet, this.colIndex++);
    }

    protected byte getByte(ResultSet resultSet) throws SQLException {
        if (SQLUtil.isSybase()) {
            String string = this.getString(resultSet);
            return (byte)Integer.parseInt(string);
        }
        return resultSet.getByte(this.colIndex++);
    }

    protected byte[] getBytes(ResultSet resultSet) throws SQLException {
        return resultSet.getBytes(this.colIndex++);
    }

    protected short getShort(ResultSet resultSet) throws SQLException {
        return resultSet.getShort(this.colIndex++);
    }

    protected int getInt(ResultSet resultSet) throws SQLException {
        return resultSet.getInt(this.colIndex++);
    }

    protected long getLong(ResultSet resultSet) throws SQLException {
        return resultSet.getLong(this.colIndex++);
    }

    protected double getDouble(ResultSet resultSet) throws SQLException {
        return resultSet.getDouble(this.colIndex++);
    }

    protected long getTimestamp(ResultSet resultSet) throws SQLException {
        Timestamp timestamp;
        return (timestamp = resultSet.getTimestamp(this.colIndex++)) == null ? 0L : timestamp.getTime();
    }

    protected String getString(ResultSet resultSet) throws SQLException {
        return resultSet.getString(this.colIndex++);
    }

    protected String getTypeString(ResultSet resultSet) {
        String string = FabricGuiUtil.getString((String)"FabricDetails_Unknown");
        try {
            switch (this.getInt(resultSet)) {
                case 0: {
                    this.getInt(resultSet);
                    string = FabricGuiUtil.getString((String)"FabricDetails_switch");
                    break;
                }
                case 1: {
                    string = FabricGuiUtil.getPortTypeString((int)this.getInt(resultSet));
                    break;
                }
                case 2: {
                    string = FabricGuiUtil.getNodeTypeString((int)this.getInt(resultSet));
                    break;
                }
                case 3: {
                    string = FabricGuiUtil.getPeTypeString((int)this.getInt(resultSet));
                    break;
                }
                case 4: {
                    this.getInt(resultSet);
                    string = FabricGuiUtil.getString((String)"FabricDetails_Blade");
                    break;
                }
                case 5: {
                    this.getInt(resultSet);
                    string = FabricGuiUtil.getString((String)"FabricDetails_tape");
                    break;
                }
                case 6: {
                    this.getInt(resultSet);
                    string = FabricGuiUtil.getString((String)"FabricDetails_MediaChangers");
                    break;
                }
                case 7: {
                    this.getInt(resultSet);
                    string = FabricGuiUtil.getString((String)"FabricDetails_HBA");
                    break;
                }
                case 8: {
                    this.getInt(resultSet);
                    string = FabricGuiUtil.getString((String)"FabricDetails_host");
                    break;
                }
                case 9: {
                    this.getInt(resultSet);
                    string = FabricGuiUtil.getString((String)"FabricDetails_StorageSubsystem");
                }
            }
            return string;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getTypeString", (Throwable)sQLException);
            }
            return string;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeResultSet() throws GeneralException {
        if (this.resultSet == null) return;
        try {
            this.closeResultSet(this.resultSet);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.resultSet = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.resultSet = null;
            return;
        }
    }

    public void closeResultSet(ResultSet resultSet) throws GeneralException {
        block8: {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"closeResultSet", (Throwable)sQLException);
                }
                if (this.inCleanUp) break block8;
                Object[] objectArray = new Object[]{this.tableName};
                this.cleanup();
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"closeResultSet");
                }
                throw SQLUtil.getGeneralException("SRV0079E", sQLException, objectArray);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeSelect() throws GeneralException {
        this.selectSQL = null;
        if (this.selectStmt == null) return;
        try {
            this.closeStmt(this.selectStmt, STMT_TYPE[0]);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.selectStmt = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.selectStmt = null;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeDelete() throws GeneralException {
        this.deleteSQL = null;
        if (this.deleteStmt == null) return;
        try {
            this.closeStmt(this.deleteStmt, STMT_TYPE[3]);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.deleteStmt = null;
            this.closeCommit();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.deleteStmt = null;
        }
        this.closeCommit();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeUpdate() throws GeneralException {
        this.updateSQL = null;
        if (this.updateStmt == null) return;
        try {
            this.closeStmt(this.updateStmt, STMT_TYPE[2]);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.updateStmt = null;
            this.closeCommit();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.updateStmt = null;
        }
        this.closeCommit();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeInsert() throws GeneralException {
        this.insertSQL = null;
        if (this.insertStmt == null) return;
        try {
            this.closeStmt(this.insertStmt, STMT_TYPE[1]);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.insertStmt = null;
            this.closeCommit();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.insertStmt = null;
        }
        this.closeCommit();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeStaticStmt() throws GeneralException {
        if (this.staticStmt == null) return;
        try {
            this.closeStmt(this.staticStmt, STMT_TYPE[0]);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.staticStmt = null;
            this.closeCommit();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.staticStmt = null;
        }
        this.closeCommit();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeCommit() throws GeneralException {
        if (this.commitStmt == null) return;
        try {
            this.closeStmt(this.commitStmt, PHASE_TYPE[4]);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.commitStmt = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.commitStmt = null;
            return;
        }
    }

    protected void closeStmt(Statement statement, String string) throws GeneralException {
        block8: {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"closeStmt", (Throwable)sQLException);
                }
                if (this.inCleanUp) break block8;
                Object[] objectArray = new Object[]{this.tableName, string};
                this.cleanup();
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"closeStmt");
                }
                throw SQLUtil.getGeneralException("SRV0080E", sQLException, objectArray);
            }
        }
    }

    public void commit() throws GeneralException {
        try {
            this.dbc.commit();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"commit");
            }
            return;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"commit", (Throwable)sQLException);
            }
            this.stmtPhase = 4;
            this.sqlError(sQLException);
            return;
        }
    }

    public void cleanup() {
        block9: {
            block8: {
                this.inCleanUp = true;
                try {
                    this.dbc.rollback();
                }
                catch (SQLException sQLException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block8;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"cleanup", (Throwable)sQLException);
                }
            }
            try {
                this.closeSelect();
                this.closeUpdate();
                this.closeDelete();
                this.closeInsert();
                this.closeStaticStmt();
            }
            catch (GeneralException generalException) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) break block9;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"cleanup", (Throwable)generalException);
            }
        }
        this.inCleanUp = false;
    }

    protected void sqlError(SQLException sQLException) throws GeneralException {
        Object[] objectArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"sqlError", (String)"e");
        }
        if (this.logSQLErrors) {
            objectArray = MessageLog.getThreadLog();
            String string = null;
            switch (this.stmtType) {
                case 0: {
                    string = this.selectSQL;
                    break;
                }
                case 1: {
                    string = this.insertSQL;
                    break;
                }
                case 2: {
                    string = this.updateSQL;
                    break;
                }
                case 3: {
                    string = this.deleteSQL;
                }
            }
            if (string != null) {
                StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
                int n = 0;
                while (n < string.length()) {
                    stringBuffer.append(string.charAt(n));
                    if (n > 0 && n % 78 == 0) {
                        stringBuffer.append("\\\n");
                    }
                    ++n;
                }
                MessageLog.logMessage((String)"STS0146E", (Object)STMT_TYPE[this.stmtType], (Object)stringBuffer.toString());
            }
            sQLException.printStackTrace((PrintWriter)objectArray);
        }
        this.cleanup();
        objectArray = new Object[]{this.tableName, STMT_TYPE[this.stmtType], PHASE_TYPE[this.stmtPhase]};
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"sqlError");
        }
        throw SQLUtil.getGeneralException("SRV0081E", sQLException, objectArray);
    }

    protected void selectError(SQLException sQLException) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectError", (String)"e");
        }
        this.cleanup();
        Object[] objectArray = new Object[]{this.tableName};
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectError");
        }
        throw SQLUtil.getGeneralException("SRV0082E", sQLException, objectArray);
    }

    protected void insertError(SQLException sQLException) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insertError", (String)"e");
        }
        this.cleanup();
        Object[] objectArray = new Object[]{this.tableName};
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insertError");
        }
        throw SQLUtil.getGeneralException("SRV0083E", sQLException, objectArray);
    }

    protected void updateError(SQLException sQLException) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateError", (String)"e");
        }
        this.cleanup();
        Object[] objectArray = new Object[]{this.tableName};
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateError");
        }
        throw SQLUtil.getGeneralException("SRV0084E", sQLException, objectArray);
    }

    protected void deleteError(SQLException sQLException) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteError", (String)"e");
        }
        this.cleanup();
        Object[] objectArray = new Object[]{this.tableName};
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteError");
        }
        throw SQLUtil.getGeneralException("SRV0085E", sQLException, objectArray);
    }

    public static RepositoryAccessor newAccessor(String string, Connection connection) {
        try {
            Class<?> clazz;
            Class<?> clazz2 = Class.forName(string);
            Class[] classArray = new Class[1];
            try {
                clazz = Class.forName("java.sql.Connection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            classArray[0] = clazz;
            Class[] classArray2 = classArray;
            Constructor<?> constructor = clazz2.getConstructor(classArray2);
            Object[] objectArray = new Object[]{connection};
            return (RepositoryAccessor)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.RepositoryAccessor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"newAccessor", (Throwable)exception);
            }
            exception.printStackTrace();
            MessageLog.logException((String)"STS0161E", (Exception)exception, (Object)string);
            return null;
        }
    }
}

