/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.sql.Connection;
import java.util.HashMap;
import org.eclipse.aperi.TStorm.common.FoundComputer;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StatDeleter;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.repository.table.TFoundComputer;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.alerts.StormAlerter;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.xmsg.MessageLog;

public class UnmanagedSaver {
    private int[][] varBindOIDs;
    private String[] tecSlotNames;
    private Connection dbc;
    protected static final int RESOURCE_NAME = 1;
    protected static final int RESOURCE_TYPE = 2;
    protected static final int ALERT_NAME = 3;
    protected static final int ALERT_TYPE = 4;

    public UnmanagedSaver(Connection connection) {
        this.dbc = connection;
    }

    private static boolean differ(FoundComputer foundComputer, FoundComputer foundComputer2) {
        return !foundComputer.fcIPAddress.equals(foundComputer2.fcIPAddress) || foundComputer.fcOSType != foundComputer2.fcOSType || foundComputer.fcNameIsLocal != foundComputer2.fcNameIsLocal || foundComputer.fcTimesMissing != foundComputer2.fcTimesMissing;
    }

    private void genAlert(FoundComputer foundComputer, AlertDefinition alertDefinition) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.UnmanagedSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"genAlert", (String)"fc, alertDef");
        }
        String[] stringArray = new String[]{TFoundComputer.canonicalName(foundComputer), MessageLog.getMessageNoID((String)"ALR1022W")};
        Alert alert = new Alert(foundComputer.fcID, -1, 32, alertDefinition, stringArray, 17, this.varBindOIDs, this.tecSlotNames);
        Alerter.queueAlert(alert);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.UnmanagedSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"genAlert");
        }
    }

    private AlertDefinition retrievePredefinedAlert() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.UnmanagedSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"retrievePredefinedAlert", (String)"");
        }
        TAlertDefinition tAlertDefinition = new TAlertDefinition(this.dbc);
        tAlertDefinition.prepSelectByID(false, false);
        AlertDefinition alertDefinition = tAlertDefinition.getByID(100);
        if (alertDefinition == null) {
            Object[] objectArray = new Object[]{new Integer(100)};
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.UnmanagedSaver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"retrievePredefinedAlert");
            }
            throw new GeneralException(MessageLog.getMessage((String)"SRV0105E", (Object[])objectArray));
        }
        tAlertDefinition.closeSelect();
        this.varBindOIDs = new int[2][];
        this.varBindOIDs[0] = StormAlerter.COMPUTER_OID;
        this.varBindOIDs[1] = Alerter.ALERT_TYPE_OID;
        this.tecSlotNames = new String[2];
        this.tecSlotNames[0] = "hostname";
        this.tecSlotNames[1] = "alertType";
        AlertDefinition alertDefinition2 = alertDefinition;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.UnmanagedSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"retrievePredefinedAlert", (Object)alertDefinition2);
        }
        return alertDefinition2;
    }

    public void save(String string, FoundComputer foundComputer) throws GeneralException {
        GeneralException generalException;
        block48: {
            Object object;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.UnmanagedSaver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"save", (String)"domain, discovered");
            }
            FoundComputer foundComputer2 = null;
            int n = 0;
            Object object2 = new TFoundComputer(this.dbc);
            FoundComputer foundComputer3 = ((TFoundComputer)object2).selectByDomain(string);
            boolean bl = foundComputer3 == null;
            HashMap<String, FoundComputer> hashMap = new HashMap<String, FoundComputer>();
            while (foundComputer3 != null) {
                hashMap.put(foundComputer3.fcName, foundComputer3);
                foundComputer3 = foundComputer3.fcNext;
            }
            FoundComputer foundComputer4 = null;
            foundComputer3 = foundComputer;
            while (foundComputer3 != null) {
                FoundComputer foundComputer5 = (FoundComputer)hashMap.remove(foundComputer3.fcName);
                if (foundComputer5 != null) {
                    FoundComputer foundComputer6 = foundComputer3;
                    foundComputer3 = foundComputer3.fcNext;
                    if (foundComputer4 != null) {
                        foundComputer4.fcNext = foundComputer3;
                    } else {
                        foundComputer = foundComputer3;
                    }
                    if (!UnmanagedSaver.differ(foundComputer5, foundComputer6)) continue;
                    foundComputer6.fcID = foundComputer5.fcID;
                    foundComputer6.fcNext = foundComputer2;
                    foundComputer2 = foundComputer6;
                    continue;
                }
                foundComputer4 = foundComputer3;
                foundComputer3 = foundComputer3.fcNext;
                ++n;
            }
            if (!hashMap.isEmpty()) {
                StatDeleter statDeleter;
                Object object3 = null;
                object = hashMap.values().iterator();
                while (object.hasNext()) {
                    foundComputer3 = (FoundComputer)object.next();
                    foundComputer3.fcTimesMissing = (short)(foundComputer3.fcTimesMissing + 1);
                    if (foundComputer3.fcTimesMissing < 3) {
                        foundComputer3.fcNext = foundComputer2;
                        foundComputer2 = foundComputer3;
                        continue;
                    }
                    statDeleter = new LinkedInteger(foundComputer3.fcID);
                    ((LinkedInteger)statDeleter).next = object3;
                    object3 = statDeleter;
                }
                if (object3 != null) {
                    statDeleter = new StatDeleter(this.dbc);
                    statDeleter.prepDeleteByID("t_found_computer", "found_computer_id");
                    while (object3 != null) {
                        object3 = statDeleter.deleteByID((LinkedInteger)object3);
                    }
                }
            }
            hashMap = null;
            if (foundComputer != null) {
                long l = 0L;
                try {
                    l = SQLUtil.getTimestamp(this.dbc).getTime();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.UnmanagedSaver");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"save", (Throwable)exception);
                    }
                    return;
                }
                int n2 = StorageRepositoryAccessor.getIdentifier(1, n, this.dbc);
                foundComputer3 = foundComputer;
                while (foundComputer3 != null) {
                    foundComputer3.fcID = n2++;
                    foundComputer3.fcWhenDiscovered = l;
                    foundComputer3 = foundComputer3.fcNext;
                }
                ((TFoundComputer)object2).insert(foundComputer);
            }
            ((RepositoryAccessor)object2).commit();
            if (foundComputer2 != null) {
                ((TFoundComputer)object2).update(foundComputer2);
            }
            if (bl || foundComputer == null) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.UnmanagedSaver");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"save");
                }
                return;
            }
            TFoundComputer tFoundComputer = object2;
            object2 = null;
            object = new TFoundComputer(this.dbc);
            AlertDefinition alertDefinition = null;
            generalException = null;
            try {
                tFoundComputer.prepNetworkMatch();
                object2 = object;
                ((TFoundComputer)object2).prepWindowsMatch();
                while (foundComputer != null) {
                    object2 = foundComputer.fcNameIsLocal ? object : tFoundComputer;
                    if (!((TFoundComputer)object2).selectMatch(foundComputer.fcID)) {
                        if (foundComputer.fcNameIsLocal) {
                            object2 = tFoundComputer;
                            if (!((TFoundComputer)object2).selectMatch(foundComputer.fcID)) {
                                if (alertDefinition == null) {
                                    alertDefinition = this.retrievePredefinedAlert();
                                }
                                this.genAlert(foundComputer, alertDefinition);
                            }
                        } else {
                            if (alertDefinition == null) {
                                alertDefinition = this.retrievePredefinedAlert();
                            }
                            this.genAlert(foundComputer, alertDefinition);
                        }
                    }
                    foundComputer = foundComputer.fcNext;
                }
            }
            catch (GeneralException generalException2) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.UnmanagedSaver");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"save", (Throwable)generalException2);
                }
                generalException = generalException2;
                if (object2 == null) break block48;
                try {
                    if (object != null) {
                        ((RepositoryAccessor)object).closeSelect();
                    }
                    if (tFoundComputer != null) {
                        tFoundComputer.closeSelect();
                    }
                }
                catch (GeneralException generalException3) {}
            }
        }
        if (generalException != null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.UnmanagedSaver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"save");
            }
            throw generalException;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.UnmanagedSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"save");
        }
    }
}

