/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Iterator;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespAgent;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.SoftwareVersion;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.report.filter.ReportFilter;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;

public class RptAgent
implements GuiDataProvider {
    public RptAgent(Connection connection) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"RptAgent", (String)"dbc");
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"RptAgent");
        }
    }

    public Serializable getReportData(GuiReportReq guiReportReq) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getReportData", (String)"grr");
        }
        int n = 0;
        boolean bl = true;
        String string = null;
        RespAgent respAgent = new RespAgent();
        RespAgent respAgent2 = null;
        ReportFilter reportFilter = null;
        if (guiReportReq.columnFilters != null) {
            reportFilter = new ReportFilter(guiReportReq, respAgent);
        }
        AgentManager.AgentAddress agentAddress = new AgentManager.AgentAddress();
        Iterator iterator = Server.agentMgr.listAgents(agentAddress);
        while (iterator.hasNext()) {
            agentAddress = (AgentManager.AgentAddress)iterator.next();
            if (agentAddress.computerID <= 0 || agentAddress.state == 2) continue;
            if (respAgent == null) {
                respAgent = new RespAgent();
            }
            respAgent.raComputerID = agentAddress.computerID;
            respAgent.raProductVersions = SoftwareVersion.decode((int)agentAddress.softwareVersion);
            respAgent.raPortNumber = agentAddress.listenerPort;
            respAgent.raConnectionErrors = agentAddress.connectionErrors;
            respAgent.raConsecutiveErrors = agentAddress.consecutiveErrors;
            respAgent.raState = agentAddress.state;
            if (agentAddress.state == 1) {
                if (agentAddress.consecutiveErrors > 0) {
                    respAgent.raState = (byte)4;
                } else if (agentAddress.upgradeRequired > 0) {
                    respAgent.raState = (byte)5;
                }
            }
            respAgent.raHostAddress = agentAddress.hostAddress;
            respAgent.raTimestamp = agentAddress.timestamp;
            respAgent.raCpuArchitecture = agentAddress.cpuArchitecture;
            string = agentAddress.timezone.getID();
            respAgent.raTimezone = string.equals("Custom") ? agentAddress.timezone.getDisplayName(agentAddress.timezone.useDaylightTime(), 0) : Util.formatTimeZone((String)string);
            respAgent.raOsType = agentAddress.osType;
            respAgent.raTsName = agentAddress.tsName;
            if (reportFilter != null) {
                bl = reportFilter.isSelected(respAgent);
            }
            if (!bl) continue;
            respAgent.raNext = respAgent2;
            respAgent2 = respAgent;
            respAgent = null;
            ++n;
        }
        RespAgent[] respAgentArray = this.packItUp(respAgent2, n);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getReportData", (Object)respAgentArray);
        }
        return respAgentArray;
    }

    private RespAgent[] packItUp(RespAgent respAgent, int n) {
        RespAgent respAgent2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"packItUp", (String)"listHdr, totalRows");
        }
        RespAgent respAgent3 = null;
        if (n > 0) {
            respAgent2 = null;
            respAgent3 = new RespAgent[n];
            int n2 = 0;
            while (respAgent != null) {
                respAgent2 = respAgent.raNext;
                respAgent.raNext = null;
                respAgent3[n2] = respAgent;
                respAgent = respAgent2;
                ++n2;
            }
        }
        respAgent2 = respAgent3;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"packItUp", (Object)respAgent2);
        }
        return respAgent2;
    }
}

