/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespFSspace;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.Group2ResSqlUtil;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.RptDiskHist;
import org.eclipse.aperi.repository.report.RptFilesystemSpc;
import org.eclipse.aperi.repository.report.filter.ReportFilter;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResVendorModel;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.xmsg.MessageLog;

public class RptDiskCapacity
extends StorageRepositoryAccessor
implements GuiDataProvider {
    private StringBuffer buf = new StringBuffer(2000);
    private GuiReportReq grr;
    private PreparedStatement subsysUseable;
    private PreparedStatement subsysSRM;
    private static final String NETWORK = MessageLog.getMessageNoID((String)"STG5048L");
    private TResVendorModel vmAccessor = null;
    private static final String MOST_RECENT = "'" + Integer.toString(3) + "'";
    private static final String LOGICAL_DISK = Integer.toString(11);
    private static final String DISK_SELECT = " c.computer_id, d.disk_id, a.path, d.capacity, h.free_space, h.primary_defects, h.grown_defects, dev.vendor_id, dev.model_id, dev.serial_number, dev.flags, r.os_type from t_stat_disk d, t_res_dev_access a, t_res_controller c, t_stat_disk_hist h, t_res_physical_volume dev, t_res_host r where d.disk_id = a.device_id and d.disk_id = h.disk_id and d.disk_id = dev.physical_volume_id and h.statistic_type = " + MOST_RECENT + " and a.controller_id = c.controller_id" + " and r.computer_id = c.computer_id" + " and dev.device_type = " + 0;
    private static final String SS_DISK_SELECT = " dev.subsystem_id, d.disk_id, dev.device_id, d.capacity, h.free_space, h.primary_defects, h.grown_defects, dev.vendor_id, dev.model_id, dev.serial_number, dev.flags, r.os_type from t_stat_disk d,  t_stat_disk_hist h,  t_res_physical_volume dev, t_res_storage_subsystem r where d.disk_id = h.disk_id and d.disk_id = dev.physical_volume_id and h.statistic_type = " + MOST_RECENT;
    private static final String SVC_DISK_SELECT = " dev.subsystem_id, d.disk_id, dev.element_name, d.capacity, h.free_space, h.primary_defects, h.grown_defects, -1, -1, '', -1, r.os_type from t_stat_disk d,  t_stat_disk_hist h,  t_res_storage_extent dev, t_res_storage_subsystem r where d.disk_id = h.disk_id and d.disk_id = dev.storage_extent_id and h.statistic_type = " + MOST_RECENT;
    private static final String SUBSYSTEM_PROBED_SELECT = " d.subsystem_id,  case when d.user_provided_name is not null  and d.user_provided_name <> ''  then d.user_provided_name else d.display_name end display_name, d.os_type,  v.n_disks, v.disk_capacity, v.disk_freespace, v.n_luns, v.lun_capacity, v.overhead, d.vg_capacity, d.vg_freespace, d.dg_freespace, d.cache, vendor.vendor_name, model.model_name, d.name, d.code_level, v.lgldisk_assigned_capacity, v.lun_capacity_zos from t_res_storage_subsystem d, t_view_ss_aggrinfo v,  t_res_vendor vendor, t_res_model model  where d.subsystem_id = v.subsystem_id and d.last_probe_time is not null and d.vendor_id = vendor.vendor_id and d.model_id = model.model_id ";
    private static final String SUBSYS_USABLE = " select sum(l.capacity) from t_res_storage_volume l where l.snap_source_id < 0  and l.is_vcmdb = '0' and l.replication_mode <> '" + Integer.toString(2) + "'" + " and l.subsystem_id = ?";
    private static final String SUBSYS_SRM = " select sum(l.capacity) from t_res_storage_volume l, t_res_view_ssluncmp corr where l.svid = corr.svid and l.subsystem_id = ?";
    private static final String COMPUTER_LIST = " s.computer_id, ' ', '2'";
    private static final String COMPUTER_GROUP_LIST = " g.group_id, g.creator, g.name";
    private static final String DOMAIN_LIST = " o.domain_id, ' ', o.name";
    private static final String NETWORK_LIST = " -3, ' ', 'network wide'";
    private static final String SELECT_COMPSUM_FROM = " , c.disk_capacity, c.disk_free_space, c.owned_disk_cap, c.owned_disk_free_sp,  scsi.capacity, scsi.freespace, fc.capacity, fc.freespace  from  t_stat_disk d,  (t_stat_computer c left outer join t_view_comp_SCSI_disksum scsi on c.computer_id = scsi.computer_id )  left outer join t_view_comp_FC_disksum fc on c.computer_id = fc.computer_id ";
    private static final String SELECT_COMPGROUPSUM_FROM = ", sum(c.disk_capacity), sum(c.disk_free_space), sum(c.owned_disk_cap), sum(c.owned_disk_free_sp),   sum(scsi.capacity), sum(scsi.freespace), sum(fc.capacity), sum(fc.freespace )  from t_group g,  (t_stat_computer c left outer join t_view_comp_SCSI_disksum scsi on c.computer_id = scsi.computer_id )  left outer join t_view_comp_FC_disksum fc on c.computer_id = fc.computer_id ";
    private static final String SELECT_SUM_FROM = ",sum(d.capacity), sum(h.free_space)  from t_stat_disk d, t_stat_disk_hist h ";
    private static final String COMPUTER_WHERE = ", t_res_share s where d.disk_id = s.resource_id and s.computer_id = c.computer_id ";
    private static final String COMPUTER_GROUP_WHERE = " where c.computer_id = gr.resource_id and gr.group_id = g.group_id ";
    private static final String DOMAIN_WHERE = ", t_res_domain o where  d.disk_id = h.disk_id and h.statistic_type = " + MOST_RECENT + " and h.disk_id in" + " (select distinct(resource_id) from t_res_share s, t_stat_computer c" + " where s.resource_type = " + 10 + " and s.computer_id = c.computer_id and c.domain_id = o.domain_id)";
    private static final String NETWORK_WHERE = " where d.disk_id = h.disk_id and h.statistic_type = " + MOST_RECENT;
    private static final String NET_SPACE_SELECT = "select sum(f.capacity), sum(f.used_space) from  t_res_filesystem f, t_res_logical_disk l where f.logical_disk_id = l.logical_disk_id and   l.logical_disk_type not in ('4', '7')";
    private static final String NET_KNOWN_SELECT = "select sum(f.capacity), sum(f.used_space) from  t_res_filesystem f, t_res_logical_disk l, t_stat_computer c where f.logical_disk_id   = l.logical_disk_id and   l.logical_disk_type = '7' and   c.computer_id       = f.computer_id and   c.os_type <> 9";
    private static final String NET_CAPACITY_SELECT = "select sum(capacity) from t_res_logical_disk where logical_disk_type not in ('4', '7') and   logical_disk_id in (select s.resource_id from  t_res_share s, t_stat_computer c where s.resource_type = " + LOGICAL_DISK + " and   s.computer_id = c.computer_id)";
    private static final String NET_SS_CAPACITY_SELECT = "select sum(capacity) from t_res_storage_volume";
    private static final String NET_OVERHEAD_SELECT = "select sum(overhead) from t_res_logical_disk union  select sum(overhead) from t_res_storage_volume";
    private static final String NET_REPLICATION_SELECT = "select sum(capacity) from  t_res_storage_volume where replication_mode = '2' and   is_assigned = 0";
    private static final String NET_SURFACED_SELECT = "select sum(l.capacity) from  t_res_storage_volume l  where l.is_assigned = 0  and   l.replication_mode <> '2'";
    private static final String NET_DISK_SELECT = "select sum(d.capacity) from  t_stat_disk d, t_res_physical_volume v where v.physical_volume_id        = d.disk_id and   d.logical_disk_id <= 0 and   v.device_type      = 0 and   d.disk_id in (select device_id from t_res_dev_access)";
    private static final String NET_SS_DISK_SELECT = "select  sum(capacity) from t_res_physical_volume where subsystem_id <> -1 and physical_volume_id not in (select device_id from t_res_dev_access)";

    public RptDiskCapacity(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"RptDiskCapacity", (String)"dbc");
        }
        this.tableName = "t_stat_disk+";
        this.vmAccessor = new TResVendorModel(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"RptDiskCapacity");
        }
    }

    public Serializable getReportData(GuiReportReq guiReportReq) throws GeneralException {
        RespFSspace[] respFSspaceArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getReportData", (String)"grr");
        }
        this.grr = guiReportReq;
        if (guiReportReq.reportSubtype == 28) {
            RptDiskHist rptDiskHist = new RptDiskHist(this.dbc);
            Serializable serializable = rptDiskHist.getReportData(guiReportReq);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getReportData", (Object)serializable);
            }
            return serializable;
        }
        RespFSspace respFSspace = new RespFSspace();
        RespFSspace respFSspace2 = null;
        RespFSspace respFSspace3 = respFSspace;
        int n = 0;
        boolean bl = true;
        ReportFilter reportFilter = null;
        if (guiReportReq.columnFilters != null && guiReportReq.reportSubtype != 15) {
            reportFilter = new ReportFilter(guiReportReq, respFSspace);
        }
        try {
            if (guiReportReq.reportType == 72) {
                this.buf.append("select");
                this.buf.append(SUBSYSTEM_PROBED_SELECT);
                SQLUtil.appendInClause(this.buf, "d.subsystem_id", guiReportReq.selectedResources, guiReportReq.isResourceInList, true);
                this.subsysUseable = this.prepareStmt(SUBSYS_USABLE);
                this.subsysSRM = this.prepareStmt(SUBSYS_SRM);
            } else {
                switch (guiReportReq.reportSubtype) {
                    case 27: {
                        this.buf.append("select");
                        if (guiReportReq.idSubtype <= 0) {
                            this.buf.append(DISK_SELECT);
                            this.buf.append(" and d.logical_disk_id <= 0");
                            SQLUtil.appendInClause(this.buf, "d.disk_id", guiReportReq.selectedResources, guiReportReq.isResourceInList, true);
                            this.buf.append(" union select ");
                            this.buf.append(SS_DISK_SELECT);
                            this.buf.append(" and dev.subsystem_id = r.subsystem_id");
                            SQLUtil.appendInClause(this.buf, "d.disk_id", guiReportReq.selectedResources, guiReportReq.isResourceInList, true);
                            this.buf.append(" union select ");
                            this.buf.append(SVC_DISK_SELECT);
                            this.buf.append(" and dev.subsystem_id = r.subsystem_id");
                            this.buf.append(" and d.logical_disk_id <= 0");
                            SQLUtil.appendInClause(this.buf, "d.disk_id", guiReportReq.selectedResources, guiReportReq.isResourceInList, true);
                            break;
                        }
                        respFSspaceArray = new TResComputer(this.dbc);
                        short s = respFSspaceArray.getStorageSubsystemType(guiReportReq.grrID1);
                        if (s > 0) {
                            if (s != 21) {
                                this.buf.append(SS_DISK_SELECT);
                            } else {
                                this.buf.append(SVC_DISK_SELECT);
                            }
                            this.buf.append(" and dev.subsystem_id = ");
                        } else {
                            this.buf.append(DISK_SELECT);
                            this.buf.append(" and c.computer_id = ");
                        }
                        this.buf.append(guiReportReq.grrID1);
                        break;
                    }
                    case 77: {
                        this.buf.append("select");
                        this.buf.append(SUBSYSTEM_PROBED_SELECT);
                        SQLUtil.appendInClause(this.buf, "d.subsystem_id", guiReportReq.selectedResources, guiReportReq.isResourceInList, true);
                        this.subsysUseable = this.prepareStmt(SUBSYS_USABLE);
                        this.subsysSRM = this.prepareStmt(SUBSYS_SRM);
                        break;
                    }
                    case 12: {
                        this.buf.append("select distinct");
                        this.buf.append(COMPUTER_LIST);
                        this.buf.append(SELECT_COMPSUM_FROM);
                        this.buf.append(COMPUTER_WHERE);
                        SQLUtil.appendInClause(this.buf, "s.computer_id", guiReportReq.selectedResources, guiReportReq.isResourceInList, true);
                        this.buf.append(" order by s.computer_id");
                        break;
                    }
                    case 13: 
                    case 82: {
                        this.buf.append("select distinct");
                        this.buf.append(COMPUTER_GROUP_LIST);
                        this.buf.append(SELECT_COMPGROUPSUM_FROM);
                        this.buf.append(", t_view_group2res gr ");
                        this.buf.append(COMPUTER_GROUP_WHERE);
                        if (guiReportReq.reportSubtype == 13) {
                            this.buf.append(" and g.group_type <> 99");
                        } else {
                            this.buf.append(" and g.group_type = 99");
                        }
                        Group2ResSqlUtil.appendG2RWhere(this.buf, guiReportReq.selectedResources, guiReportReq.isResourceInList, true, guiReportReq.reportSubtype, "gr");
                        this.buf.append(" group by ");
                        this.buf.append(" g.name, g.creator, g.group_id ");
                        break;
                    }
                    case 14: {
                        this.buf.append("select");
                        this.buf.append(DOMAIN_LIST);
                        this.buf.append(SELECT_SUM_FROM);
                        this.buf.append(DOMAIN_WHERE);
                        SQLUtil.appendInClause(this.buf, "o.domain_id", guiReportReq.selectedResources, guiReportReq.isResourceInList, true);
                        this.buf.append(" group by o.domain_id, o.name");
                        break;
                    }
                    case 15: {
                        this.buf.append("select");
                        this.buf.append(NETWORK_LIST);
                        this.buf.append(SELECT_SUM_FROM);
                        this.buf.append(NETWORK_WHERE);
                        break;
                    }
                    default: {
                        Object[] objectArray = new Object[]{new Integer(guiReportReq.reportType), new Integer(guiReportReq.reportSubtype)};
                        String string = MessageLog.getMessage((String)"GEN0125E", (Object[])objectArray);
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exit((String)clazz.getName(), (String)"getReportData");
                        }
                        throw new GeneralException(string);
                    }
                }
            }
            respFSspaceArray = this.buf.toString();
            this.selectStmt = this.prepareStmt((String)respFSspaceArray);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                if (respFSspace2 == null) {
                    respFSspace2 = new RespFSspace();
                }
                this.colIndex = 1;
                if (guiReportReq.reportSubtype == 77 || guiReportReq.reportType == 72) {
                    respFSspace2.id = this.getInt(this.resultSet);
                    respFSspace2.setName(this.getString(this.resultSet));
                    respFSspace2.osType = this.getShort(this.resultSet);
                    respFSspace2.disks = this.getInt(this.resultSet);
                    respFSspace2.capacity = this.getLong(this.resultSet);
                    respFSspace2.freeSpace = this.getLong(this.resultSet);
                    respFSspace2.luns = this.getInt(this.resultSet);
                    respFSspace2.lun_capacity = this.getLong(this.resultSet);
                    respFSspace2.overhead = this.getLong(this.resultSet);
                    respFSspace2.vs_capacity = this.getLong(this.resultSet);
                    respFSspace2.vs_freespace = this.getLong(this.resultSet);
                    respFSspace2.dg_freecap = this.getLong(this.resultSet);
                    long l = this.getLong(this.resultSet);
                    respFSspace2.cache = l > 0L ? (l /= 0x100000L) : -1L;
                    respFSspace2.manufacturer = this.getString(this.resultSet);
                    respFSspace2.model = this.getString(this.resultSet);
                    respFSspace2.serialNumber = this.getString(this.resultSet);
                    respFSspace2.firmware = this.getString(this.resultSet);
                    respFSspace2.disk_assigned_capacity = this.getLong(this.resultSet);
                    respFSspace2.disk_unassigned_capacity = respFSspace2.lun_capacity - respFSspace2.disk_assigned_capacity;
                    respFSspace2.disk_total_formatted_free_space = respFSspace2.disk_unassigned_capacity + respFSspace2.vs_freespace;
                    respFSspace2.zos_lun_capacity = this.getLong(this.resultSet);
                    if (respFSspace2.zos_lun_capacity == -1L && (respFSspace2.osType == 12 || respFSspace2.osType == 25 || respFSspace2.osType == 27)) {
                        respFSspace2.zos_lun_capacity = 0L;
                    }
                    respFSspace2.open_sys_lun_capacity = respFSspace2.lun_capacity - respFSspace2.zos_lun_capacity;
                    this.getUseable(respFSspace2);
                    this.getSRMKnown(respFSspace2);
                } else {
                    respFSspace2.id = this.getInt(this.resultSet);
                    if (guiReportReq.reportSubtype == 27) {
                        respFSspace2.fs_id = this.getInt(this.resultSet);
                    } else {
                        respFSspace2.creator = this.getString(this.resultSet);
                    }
                    if (guiReportReq.reportSubtype == 27) {
                        RespFSspace respFSspace4 = respFSspace;
                        while (respFSspace4 != null) {
                            if (respFSspace2.fs_id == respFSspace4.fs_id) break;
                            respFSspace4 = respFSspace4.next;
                        }
                        if (respFSspace4 != null && respFSspace2.fs_id == respFSspace4.fs_id) continue;
                    }
                    respFSspace2.setName(this.getString(this.resultSet));
                    respFSspace2.capacity = this.getLong(this.resultSet);
                    respFSspace2.freeSpace = this.getLong(this.resultSet);
                    if (guiReportReq.reportSubtype == 12 || guiReportReq.reportSubtype == 82 || guiReportReq.reportSubtype == 13) {
                        respFSspace2.owned_capacity = this.getLong(this.resultSet);
                        respFSspace2.owned_freeSp = this.getLong(this.resultSet);
                        respFSspace2.SCSI_capacity = this.getLong(this.resultSet);
                        respFSspace2.SCSI_freespace = this.getLong(this.resultSet);
                        respFSspace2.FC_capacity = this.getLong(this.resultSet);
                        respFSspace2.FC_freespace = this.getLong(this.resultSet);
                    }
                    if (guiReportReq.reportSubtype == 27) {
                        String string;
                        String string2;
                        respFSspace2.primaryDefects = this.getInt(this.resultSet);
                        respFSspace2.grownDefects = this.getInt(this.resultSet);
                        short s = this.getShort(this.resultSet);
                        respFSspace2.manufacturer = string2 = this.vmAccessor.getVendorName(s);
                        respFSspace2.model = string = this.vmAccessor.getModelName(this.getShort(this.resultSet));
                        respFSspace2.serialNumber = this.getString(this.resultSet);
                        respFSspace2.flags = this.getShort(this.resultSet);
                        short s2 = this.getShort(this.resultSet);
                        respFSspace2.directoryCount = Constants.isDiskArray((short)s2) ? 1L : 0L;
                        if ((respFSspace2.flags & 1) != 0) {
                            respFSspace2.manufacturer = MessageLog.getMessageNoID((String)"GUI0129T");
                        }
                        if ((respFSspace2.flags & 2) != 0) {
                            respFSspace2.serialNumber = MessageLog.getMessageNoID((String)"GUI0129T");
                        }
                    }
                }
                if (reportFilter != null) {
                    RespFSspace respFSspace5 = (RespFSspace)respFSspace2.clone();
                    if (guiReportReq.reportSubtype != 77 && guiReportReq.reportType != 72) {
                        this.getComputerNames(respFSspace5);
                    }
                    bl = reportFilter.isSelected(respFSspace5);
                }
                if (!bl) continue;
                respFSspace3.next = respFSspace2;
                respFSspace3 = respFSspace2;
                respFSspace2 = null;
                ++n;
            }
            this.closeSelect();
            if (guiReportReq.reportSubtype == 77 || guiReportReq.reportType == 72) {
                if (this.subsysUseable != null) {
                    this.subsysUseable.close();
                }
                if (this.subsysSRM != null) {
                    this.subsysSRM.close();
                }
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getReportData", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (guiReportReq.reportSubtype == 15 && respFSspace.next != null) {
            this.getNetworkValues(respFSspace.next);
            if (guiReportReq.columnFilters != null) {
                reportFilter = new ReportFilter(guiReportReq, respFSspace);
                respFSspaceArray = (RespFSspace[])respFSspace.next.clone();
                this.getComputerNames((RespFSspace)respFSspaceArray);
                if (!reportFilter.isSelected(respFSspaceArray)) {
                    respFSspace.next = null;
                    n = 0;
                }
            }
        }
        if (guiReportReq.reportSubtype != 77 && guiReportReq.reportType != 72 && guiReportReq.isBatchReport) {
            this.getComputerNames(respFSspace.next);
        }
        respFSspaceArray = RptFilesystemSpc.packItUp(respFSspace.next, n);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getReportData", (Object)respFSspaceArray);
        }
        return respFSspaceArray;
    }

    private void getUseable(RespFSspace respFSspace) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getUseable", (String)"curr");
        }
        ResultSet resultSet = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.subsysUseable, respFSspace.id);
            this.stmtPhase = 3;
            resultSet = this.subsysUseable.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getUseable", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getUseable");
            }
            return;
        }
        try {
            if (resultSet.next()) {
                this.getPhase();
                respFSspace.fs_capacity = this.getLong(resultSet);
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getUseable", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getUseable");
        }
    }

    private void getSRMKnown(RespFSspace respFSspace) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getSRMKnown", (String)"curr");
        }
        ResultSet resultSet = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.subsysSRM, respFSspace.id);
            this.stmtPhase = 3;
            resultSet = this.subsysSRM.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getSRMKnown", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getSRMKnown");
            }
            return;
        }
        try {
            if (resultSet.next()) {
                this.getPhase();
                respFSspace.fsFreeSpace = this.getLong(resultSet);
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getSRMKnown", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getSRMKnown");
        }
    }

    public void getNetworkValues(RespFSspace respFSspace) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getNetworkValues", (String)"node");
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        try {
            this.staticStmt = this.createStatement();
            this.resultSet = this.staticStmt.executeQuery(NET_SPACE_SELECT);
            if (this.nextResult()) {
                this.getPhase();
                l = this.getLong(this.resultSet);
                l2 = this.getLong(this.resultSet);
            }
            this.closeResultSet();
            this.resultSet = this.staticStmt.executeQuery(NET_KNOWN_SELECT);
            if (this.nextResult()) {
                this.getPhase();
                l3 = this.getLong(this.resultSet);
                l4 = this.getLong(this.resultSet);
            }
            this.closeResultSet();
            this.resultSet = this.staticStmt.executeQuery(NET_CAPACITY_SELECT);
            long l10 = 0L;
            if (this.nextResult()) {
                this.getPhase();
                l10 = this.getLong(this.resultSet);
            }
            this.closeResultSet();
            this.resultSet = this.staticStmt.executeQuery(NET_SS_CAPACITY_SELECT);
            if (this.nextResult()) {
                this.getPhase();
                l10 = this.getLong(this.resultSet);
            }
            this.closeResultSet();
            l5 = l10;
            this.resultSet = this.staticStmt.executeQuery(NET_OVERHEAD_SELECT);
            if (this.nextResult()) {
                this.getPhase();
                l6 = this.getLong(this.resultSet);
            }
            this.closeResultSet();
            this.resultSet = this.staticStmt.executeQuery(NET_REPLICATION_SELECT);
            if (this.nextResult()) {
                this.getPhase();
                l7 = this.getLong(this.resultSet);
            }
            this.closeResultSet();
            this.resultSet = this.staticStmt.executeQuery(NET_SURFACED_SELECT);
            if (this.nextResult()) {
                this.getPhase();
                l8 = this.getLong(this.resultSet);
            }
            this.closeResultSet();
            this.resultSet = this.staticStmt.executeQuery(NET_DISK_SELECT);
            long l11 = 0L;
            if (this.nextResult()) {
                this.getPhase();
                l11 = this.getLong(this.resultSet);
            }
            this.closeResultSet();
            this.resultSet = this.staticStmt.executeQuery(NET_SS_DISK_SELECT);
            long l12 = 0L;
            if (this.nextResult()) {
                this.getPhase();
                l12 = this.getLong(this.resultSet);
            }
            this.closeResultSet();
            l9 = l11 + l12;
            this.closeStaticStmt();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getNetworkValues", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        respFSspace.capacity = l9;
        respFSspace.usedSpace = l2 + l4;
        respFSspace.fsFreeSpace = l + l3 - respFSspace.usedSpace;
        respFSspace.fs_capacity = l5 - (l + l3);
        respFSspace.overhead = l6 + l7;
        respFSspace.unknown = l8;
        respFSspace.unallocated = l9 - (l5 + respFSspace.overhead + l8);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getNetworkValues");
        }
    }

    private void getComputerNames(RespFSspace respFSspace) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getComputerNames", (String)"node");
        }
        AgentManager agentManager = Server.getAgentManager();
        while (respFSspace != null) {
            switch (this.grr.reportSubtype) {
                case 27: {
                    respFSspace.creator = agentManager.getAgentName(respFSspace.id);
                    break;
                }
                case 12: {
                    respFSspace.setName(agentManager.getAgentName(respFSspace.id));
                }
                case 14: {
                    respFSspace.creator = " ";
                    break;
                }
                case 15: {
                    respFSspace.creator = " ";
                    respFSspace.setName(NETWORK);
                }
            }
            respFSspace = respFSspace.next;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskCapacity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getComputerNames");
        }
    }
}

