/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.RptDisk;
import org.eclipse.aperi.repository.report.RptFsHist;
import org.eclipse.aperi.repository.report.filter.ReportFilter;
import org.eclipse.aperi.repository.table.TResShare;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.xmsg.MessageLog;

public class RptLogicalVolume
extends StorageRepositoryAccessor
implements GuiDataProvider {
    PreparedStatement selectMirrorsStmt;
    private int rowCount;
    private Share share = new Share();
    private ReportFilter filter;
    private static final String LV_SELECT_ALL = "select s.computer_id, s.resource_id, s.resource_type, s.scan_time, s.removed_time, s.path, l.logical_disk_id, l.parent_logdisk_id, l.logical_disk_type, l.capacity, l.use_count, l.mirror_count, l.is_swap, l.overhead from t_res_logical_disk l , t_res_share s, t_stat_computer c where s.resource_type = 11 and s.resource_id = l.logical_disk_id and l.parent_logdisk_id = -1 and s.computer_id = c.computer_id";
    private static final String ORDER_BY_LD = " order by l.logical_disk_id desc";
    private static final String WITHOUT_FS = " and l.logical_disk_id not in (select f.logical_disk_id from t_res_filesystem f)";
    private static final String FS_SELECT_ALL = "select f.filesystem_id, f.computer_id, f.group_id, f.logical_disk_id, f.log_disk_id, f.maxfiles, f.used_inodes, f.free_inodes, f.physical_size, f.capacity, f.used_space, f.free_space, f.last_scan_time, f.filesystem_type, f.use_count, f.mount_point, f.discovered_time from  t_res_filesystem f order by logical_disk_id";
    private static final String SELECT_SOME_BY_FS_PART1 = "select f.filesystem_id, f.computer_id, f.group_id, f.logical_disk_id, f.log_disk_id, f.maxfiles, f.used_inodes, f.free_inodes, f.physical_size, f.capacity, f.used_space, f.free_space, f.last_scan_time, f.filesystem_type, f.use_count, f.mount_point, f.discovered_time, s.computer_id, s.resource_id, s.resource_type, s.scan_time, s.removed_time, s.path, l.logical_disk_id, l.parent_logdisk_id, l.logical_disk_type, l.capacity, l.use_count, l.mirror_count, l.is_swap, l.overhead from  t_res_filesystem f, t_res_logical_disk l , t_res_share s where f.logical_disk_id = l.logical_disk_id and f.logical_disk_id = s.resource_id and f.computer_id  = s.computer_id";
    private static final String UNION_ALL = " union all ";
    private static final String SELECT_SOME_BY_FS_PART2 = "select ff.filesystem_id, ff.computer_id, ff.group_id, ff.logical_disk_id, ff.log_disk_id, ff.maxfiles, ff.used_inodes, ff.free_inodes, ff.physical_size, ff.capacity, ff.used_space, ff.free_space, ff.last_scan_time, ff.filesystem_type, ff.use_count, ff.mount_point, ff.discovered_time, ss.computer_id, ss.resource_id, ss.resource_type, ss.scan_time, ss.removed_time,";
    private static final String SELECT_SOME_BY_FS_PART3_NORMAL = " 'N/A', -1, -1, '0', -1, 0, 0, '0', 0";
    private static final String SELECT_SOME_BY_FS_PART4 = " from  t_res_filesystem ff, t_res_share ss  where ff.logical_disk_id <= 0 and ff.filesystem_id = ss.resource_id and ff.computer_id  = ss.computer_id";
    private static final String SELECT_SOME_BY_FS_PART4_REMOVED_FSLV = " from  t_res_filesystem ff, t_res_share ss  where ff.filesystem_id = ss.resource_id and ff.computer_id  = ss.computer_id and (logical_disk_id < 0 OR (removed_time > " + Constants.INITIAL_DB_REMOVED_TIME + ")) order by 22 ";
    private static String selectSomeByFSPart2;
    private static String selectSomeByFSPart2_removedFSLV;
    private static final String FREESPACE_WHERE = " and free_space >= 0";
    private static final String FREESPACE_ORDERBY = " order by 12 ";
    private static final String PROBE_TIME = " order by 21 ";
    private static final String SCAN_TIME = " order by 13 ";
    private static final String DISCOVERED_TIME = " order by 17 ";

    static {
        StringBuffer stringBuffer = new StringBuffer(600);
        stringBuffer.append(SELECT_SOME_BY_FS_PART2);
        stringBuffer.append(SELECT_SOME_BY_FS_PART3_NORMAL);
        stringBuffer.append(SELECT_SOME_BY_FS_PART4);
        selectSomeByFSPart2 = stringBuffer.toString();
        stringBuffer = new StringBuffer(600);
        stringBuffer.append(SELECT_SOME_BY_FS_PART2);
        stringBuffer.append(SELECT_SOME_BY_FS_PART3_NORMAL);
        stringBuffer.append(SELECT_SOME_BY_FS_PART4_REMOVED_FSLV);
        selectSomeByFSPart2_removedFSLV = stringBuffer.toString();
    }

    public RptLogicalVolume(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"RptLogicalVolume", (String)"dbc");
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"RptLogicalVolume");
        }
    }

    public Serializable getReportData(GuiReportReq guiReportReq) throws GeneralException {
        Share[] shareArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getReportData", (String)"grr");
        }
        if (guiReportReq.reportSubtype == 28) {
            guiReportReq.productCode = 1;
            RptFsHist rptFsHist = new RptFsHist(this.dbc);
            Serializable serializable = rptFsHist.getReportData(guiReportReq);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getReportData", (Object)serializable);
            }
            return serializable;
        }
        this.rowCount = 0;
        Share share = null;
        this.tableName = "t_res_filesystem";
        StringBuffer stringBuffer = new StringBuffer(2000);
        this.filter = null;
        if (guiReportReq.columnFilters != null) {
            this.filter = new ReportFilter(guiReportReq, this.share);
        }
        switch (guiReportReq.reportSubtype) {
            case 2: {
                shareArray = this.filter;
                this.filter = null;
                stringBuffer.append(LV_SELECT_ALL);
                stringBuffer.append(ORDER_BY_LD);
                this.selectStmt = this.prepareStmt(stringBuffer.toString());
                share = this.getLV(guiReportReq);
                if (share == null) break;
                this.selectStmt = this.prepareStmt(FS_SELECT_ALL);
                share = this.matchFS(share);
                if (shareArray == null) break;
                share = this.applyFilter(share, (ReportFilter)shareArray);
                break;
            }
            case 17: {
                stringBuffer.append(SELECT_SOME_BY_FS_PART1);
                stringBuffer.append(FREESPACE_WHERE);
                stringBuffer.append(UNION_ALL);
                stringBuffer.append(selectSomeByFSPart2);
                stringBuffer.append(FREESPACE_WHERE);
                stringBuffer.append(FREESPACE_ORDERBY);
                share = this.getSelectedLV(guiReportReq, stringBuffer);
                break;
            }
            case 18: {
                stringBuffer.append(SELECT_SOME_BY_FS_PART1);
                stringBuffer.append(UNION_ALL);
                stringBuffer.append(selectSomeByFSPart2);
                stringBuffer.append(PROBE_TIME);
                share = this.getSelectedLV(guiReportReq, stringBuffer);
                break;
            }
            case 19: {
                stringBuffer.append(SELECT_SOME_BY_FS_PART1);
                stringBuffer.append(UNION_ALL);
                stringBuffer.append(selectSomeByFSPart2);
                stringBuffer.append(SCAN_TIME);
                share = this.getSelectedLV(guiReportReq, stringBuffer);
                break;
            }
            case 37: {
                stringBuffer.append(SELECT_SOME_BY_FS_PART1);
                stringBuffer.append(UNION_ALL);
                stringBuffer.append(selectSomeByFSPart2);
                stringBuffer.append(DISCOVERED_TIME);
                share = this.getSelectedLV(guiReportReq, stringBuffer);
                break;
            }
            case 20: {
                stringBuffer.append(selectSomeByFSPart2_removedFSLV);
                share = this.getSelectedLV(guiReportReq, stringBuffer);
                break;
            }
            case 21: {
                stringBuffer.append(LV_SELECT_ALL);
                stringBuffer.append(WITHOUT_FS);
                stringBuffer.append(ORDER_BY_LD);
                this.selectStmt = this.prepareStmt(stringBuffer.toString());
                share = this.getLV(guiReportReq);
                break;
            }
            default: {
                Object[] objectArray = new Object[]{new Integer(guiReportReq.reportType), new Integer(guiReportReq.reportSubtype)};
                String string = MessageLog.getMessage((String)"GEN0125E", (Object[])objectArray);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getReportData");
                }
                throw new GeneralException(string);
            }
        }
        stringBuffer = null;
        if (guiReportReq.isBatchReport) {
            this.getComputerNames(share);
        }
        shareArray = RptDisk.packUpShares(share, this.rowCount);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getReportData", (Object)shareArray);
        }
        return shareArray;
    }

    public Share getLV(GuiReportReq guiReportReq) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getLV", (String)"grr");
        }
        Share share = null;
        this.share.shResource = new LogicalDisk();
        boolean bl = true;
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                this.fetchShare(this.share);
                this.fetchLogicalDisk((LogicalDisk)this.share.shResource);
                if (this.filter != null) {
                    this.getComputerNames(this.share);
                    bl = this.filter.isSelected(this.share);
                }
                if (!bl) continue;
                this.share.shNext = share;
                share = this.share;
                ++this.rowCount;
                this.share = new Share();
                this.share.shResource = new LogicalDisk();
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getLV", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        Share share2 = share;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getLV", share2);
        }
        return share2;
    }

    public Share matchFS(Share share) throws GeneralException {
        Share share2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"matchFS", (String)"share");
        }
        Share share3 = share;
        Share share4 = null;
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            share2 = (LogicalDisk)share.shResource;
            TResShare tResShare = new TResShare(this.dbc);
            tResShare.prepGetUniqueShare();
            while (this.nextResult()) {
                Filesystem filesystem = new Filesystem();
                this.colIndex = 1;
                this.fetchFilesystem(filesystem);
                while (share != null && (share2.ldID < filesystem.fsLogicalDiskID || share2.ldID == filesystem.fsLogicalDiskID && share.shComputerID != filesystem.fsComputerID)) {
                    share4 = share;
                    share = share.shNext;
                    if (share == null) continue;
                    share2 = (LogicalDisk)share.shResource;
                }
                if (share == null || share2.ldID != filesystem.fsLogicalDiskID) {
                    Share share5 = new Share();
                    share2 = this.getBlankLogicalDisk();
                    share5.shResource = share2;
                    share5.shComputerID = filesystem.fsComputerID;
                    share5.shResourceID = filesystem.fsID;
                    tResShare.getUniqueShare(share5);
                    share5.shPath = filesystem.fsLogicalDiskID == -1 ? "--- NOT MOUNTED ---" : " ";
                    share5.shNext = share;
                    share = share5;
                    if (share4 != null) {
                        share4.shNext = share5;
                    } else {
                        share3 = share5;
                    }
                    ++this.rowCount;
                }
                share2.ldFilesystem = filesystem;
                share4 = share;
                share = share.shNext;
                if (share == null) continue;
                share2 = (LogicalDisk)share.shResource;
            }
            this.closeSelect();
            tResShare.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"matchFS", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        share2 = share3;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"matchFS", (Object)share2);
        }
        return share2;
    }

    public Share applyFilter(Share share, ReportFilter reportFilter) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"applyFilter", (String)"shareList, filter");
        }
        this.getComputerNames(share);
        Share share2 = null;
        Share share3 = null;
        this.rowCount = 0;
        while (share != null) {
            this.share = share;
            share = this.share.shNext;
            if (!reportFilter.isSelected(this.share)) continue;
            this.share.shNext = null;
            if (share3 == null) {
                share2 = this.share;
            } else {
                share3.shNext = this.share;
            }
            share3 = this.share;
            ++this.rowCount;
        }
        Share share4 = share2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"applyFilter", share4);
        }
        return share4;
    }

    public Share getSelectedLV(GuiReportReq guiReportReq, StringBuffer stringBuffer) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getSelectedLV", (String)"grr, buf");
        }
        Share share = new Share();
        share.shNext = null;
        Share share2 = this.share;
        LogicalDisk logicalDisk = new LogicalDisk();
        Filesystem filesystem = new Filesystem();
        this.share = share;
        boolean bl = true;
        try {
            this.selectStmt = this.prepareStmt(stringBuffer.toString());
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                this.fetchFilesystem(filesystem);
                this.fetchShare(share2);
                this.fetchLogicalDisk(logicalDisk);
                logicalDisk.ldFilesystem = filesystem;
                share2.shResource = logicalDisk;
                if (this.filter != null) {
                    this.getComputerNames(share2);
                    bl = this.filter.isSelected(share2);
                }
                if (!bl) continue;
                this.share.shNext = share2;
                this.share = share2;
                ++this.rowCount;
                share2 = new Share();
                logicalDisk = new LogicalDisk();
                filesystem = new Filesystem();
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getSelectedLV", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        Share share3 = share.shNext;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getSelectedLV", (Object)share3);
        }
        return share3;
    }

    private void fetchFilesystem(Filesystem filesystem) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchFilesystem", (String)"fs");
        }
        filesystem.fsID = this.getInt(this.resultSet);
        filesystem.fsComputerID = this.getInt(this.resultSet);
        filesystem.fsGroupID = this.getInt(this.resultSet);
        filesystem.fsLogicalDiskID = this.getInt(this.resultSet);
        filesystem.fsLogDiskID = this.getInt(this.resultSet);
        filesystem.fsMaxFiles = this.getInt(this.resultSet);
        filesystem.fsUsedInodes = this.getInt(this.resultSet);
        filesystem.fsFreeInodes = this.getInt(this.resultSet);
        filesystem.fsPhysicalSize = this.getLong(this.resultSet);
        filesystem.fsCapacity = this.getLong(this.resultSet);
        filesystem.fsUsedSpace = this.getLong(this.resultSet);
        filesystem.fsFreeSpace = this.getLong(this.resultSet);
        filesystem.fsScanTime = this.getTimestamp(this.resultSet);
        filesystem.fsType = this.getShort(this.resultSet);
        filesystem.fsUseCount = this.getShort(this.resultSet);
        filesystem.fsMountPoint = this.getString(this.resultSet);
        filesystem.fsDiscoveredTime = this.getTimestamp(this.resultSet);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchFilesystem");
        }
    }

    private void fetchShare(Share share) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchShare", (String)"share");
        }
        share.shComputerID = this.getInt(this.resultSet);
        share.shResourceID = this.getInt(this.resultSet);
        share.shResourceType = this.getShort(this.resultSet);
        share.shScanTime = this.getTimestamp(this.resultSet);
        share.shRemovedTime = this.getTimestamp(this.resultSet);
        share.shPath = this.getString(this.resultSet);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchShare");
        }
    }

    private void fetchLogicalDisk(LogicalDisk logicalDisk) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchLogicalDisk", (String)"ld");
        }
        String string = "";
        logicalDisk.ldID = this.getInt(this.resultSet);
        logicalDisk.ldParentLogicalDiskID = this.getInt(this.resultSet);
        string = this.getString(this.resultSet);
        logicalDisk.ldType = string == null ? (byte)0 : ((string = string.trim()).compareTo("T") == 0 ? (byte)11 : (string.compareTo("F") == 0 ? (byte)12 : (byte)Integer.parseInt(string)));
        logicalDisk.ldCapacity = this.getLong(this.resultSet);
        logicalDisk.ldUseCount = this.getShort(this.resultSet);
        logicalDisk.ldMirrorCount = this.getByte(this.resultSet);
        logicalDisk.ldIsSwap = this.getBoolean(this.resultSet);
        logicalDisk.ldOverhead = this.getLong(this.resultSet);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchLogicalDisk");
        }
    }

    private LogicalDisk getBlankLogicalDisk() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getBlankLogicalDisk", (String)"");
        }
        LogicalDisk logicalDisk = new LogicalDisk();
        logicalDisk.ldID = -1;
        logicalDisk.ldParentLogicalDiskID = -1;
        logicalDisk.ldType = 0;
        logicalDisk.ldCapacity = -1L;
        logicalDisk.ldUseCount = 0;
        logicalDisk.ldMirrorCount = 0;
        logicalDisk.ldIsSwap = false;
        LogicalDisk logicalDisk2 = logicalDisk;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getBlankLogicalDisk", (Object)logicalDisk2);
        }
        return logicalDisk2;
    }

    private void getComputerNames(Share share) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getComputerNames", (String)"node");
        }
        AgentManager agentManager = Server.getAgentManager();
        while (share != null) {
            share.shComputerName = agentManager.getAgentName(share.shComputerID);
            share = share.shNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptLogicalVolume");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getComputerNames");
        }
    }
}

