/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.AlertConditionManager;
import org.eclipse.aperi.constants.metadata.AlertProductManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TConfigSettings;
import org.eclipse.aperi.repository.table.TResAttr;
import org.eclipse.aperi.server.guireq.AlertLog;
import org.eclipse.aperi.server.guireq.AlertNameList;
import org.eclipse.aperi.server.guireq.ConfigSettings;
import org.eclipse.aperi.server.guireq.ExtAlertLog;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAlertLog
extends RepositoryAccessor {
    AlertLog buffer;
    private static final String ACTIVE = new StringBuffer("'").append(Integer.toString(0)).append("'").toString();
    private static final String CLEAR = new StringBuffer("'").append(Integer.toString(2)).append("'").toString();
    private static final String LOGICALLY_DELETED = new StringBuffer("'").append(Integer.toString(3)).append("'").toString();
    private static final String INSERT = new StringBuffer("insert into t_alert_log (alert_log_id, alert_id, computer_id,  resource_id, resource_type, alert_condition, violator_id, violator_type, notify_user, product_id, threshold_type, threshold_value, violating_value, previous_value, first_alert_time, last_alert_time, alert_count, state, script_computer_id, script_log_file, script_name, msg, dbms_type, parent_id, job_log_file) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?, 1, ").append(ACTIVE).append(",?,?,?,?,?,?,' ')").toString();
    private static final String UPDATE = new StringBuffer("update t_alert_log set violating_value = ?, notify_user = ?, last_alert_time = ?, script_computer_id = ?, script_log_file = ?, script_name = ?, msg = ?, threshold_value = ?, alert_count = alert_count + 1 where alert_id = ? and computer_id = ? and resource_id = ? and resource_type = ? and alert_condition = ? and violator_id = ? and violator_type = ? and state = ").append(ACTIVE).toString();
    private static final String DEACTIVATE = new StringBuffer("update t_alert_log set state = ").append(CLEAR).append(" where alert_id = ? and").append(" computer_id = ? and resource_id = ? and resource_type = ? and").append(" alert_condition = ? and violator_id = ? and violator_type = ?").append(" and state <> ").append(LOGICALLY_DELETED).toString();
    private static final String DEACTIVATE_BY_ALERT_ID = new StringBuffer("update t_alert_log set state = ").append(CLEAR).append(" where alert_id = ? and").append(" state not in (").append(LOGICALLY_DELETED).append(",").append(CLEAR).append(")").toString();
    private static final String DEACTIVATE_BY_ID = new StringBuffer("update t_alert_log set state = ? where alert_log_id = ? and state <> ").append(LOGICALLY_DELETED).toString();
    private static final String DELETE = "delete from t_alert_log where alert_log_id = ?";
    private static final String DELETE_BY_FS = new StringBuffer("delete from t_alert_log where resource_type = ").append(Short.toString((short)3)).append(" and resource_id = ?").toString();
    private static final String DELETE_BY_DISK = new StringBuffer("delete from t_alert_log where resource_type = ").append(Short.toString((short)10)).append(" and resource_id = ?").toString();
    private static final String DELETE_BY_COMPUTER = new StringBuffer("delete from t_alert_log where resource_type = ").append(Short.toString((short)1)).append(" and resource_id = ?").toString();
    private static final String DELETE_BY_DISKARRAY = new StringBuffer("delete from t_alert_log where resource_type = ").append(Short.toString((short)78)).append(" and resource_id = ?").toString();
    private static final String LOGICALLY_DELETE = new StringBuffer("update t_alert_log set state = ").append(LOGICALLY_DELETED).append(" where alert_log_id = ? and state <> ").append(CLEAR).toString();
    private static final String DELETE_LOGICALLY_DELETED = new StringBuffer("delete from t_alert_log where alert_id = ? and state = ").append(LOGICALLY_DELETED).toString();
    private static final String SELECT_ACTIVE_IDS = new StringBuffer("select alert_condition, resource_id, computer_id, violator_id, dbms_type, violator_type, notify_user, product_id from t_alert_log where state = ").append(ACTIVE).toString();
    private static final String SELECT_FOR_DELETE = "select count(*)  from t_alert_log  where alert_id    = ?  and   resource_id = ?  and   violator_id = ?  and   last_alert_time > ? ";
    private static final String FULL_SELECT_CLAUSE = "select l.alert_log_id, l.alert_id, l.alert_condition, l.notify_user, l.threshold_type, l.threshold_value, l.violating_value, l.previous_value, l.first_alert_time, l.last_alert_time, l.alert_count, l.state, l.resource_type, l.resource_id, l.violator_type, l.violator_id, d.creator, d.name, l.computer_id, l.script_computer_id, l.script_log_file, l.script_name, l.product_id, l.dbms_type, l.parent_id, l.job_log_file";
    private static final String GUI_TABLE_SELECT = new StringBuffer("select l.alert_log_id, l.alert_id, l.alert_condition, l.notify_user, l.threshold_type, l.threshold_value, l.violating_value, l.previous_value, l.first_alert_time, l.last_alert_time, l.alert_count, l.state, l.resource_type, l.resource_id, l.violator_type, l.violator_id, d.creator, d.name, l.computer_id, l.script_computer_id, l.script_log_file, l.script_name, l.product_id, l.dbms_type, l.parent_id, l.job_log_file from t_alert_log l, t_alert_definition d where d.alert_id = l.alert_id and l.state <> ").append(LOGICALLY_DELETED).toString();
    private static final String SELECT_FOR_CLEANUP = "select l.alert_log_id, l.alert_id, l.alert_condition, l.notify_user, l.threshold_type, l.threshold_value, l.violating_value, l.previous_value, l.first_alert_time, l.last_alert_time, l.alert_count, l.state, l.resource_type, l.resource_id, l.violator_type, l.violator_id, d.creator, d.name, l.computer_id, l.script_computer_id, l.script_log_file, l.script_name, l.product_id, l.dbms_type, l.parent_id, l.job_log_file from t_alert_log l, t_alert_definition d where d.alert_id = l.alert_id  and   l.last_alert_time < ? ";
    private static final String INVALIDATE_SCRIPT_LOGS = "update t_alert_log set script_computer_id = -1, script_log_file = ' ' where script_computer_id = ?";
    private static final int N_PLACES = 10;
    private static final String GET_TEXT = "SELECT msg, alert_condition FROM t_alert_log WHERE alert_log_id = ?";
    private static final short[] computerConditions = new short[]{1, 2, 3, 4, 15, 31, 55, 66, 5, 7, 8, 24, 6, 12, 73, 74, 172, 173, 174, 175, 176, 75};
    private static final short[] diskConditions = new short[]{5, 7, 8, 24, 6};
    private static final short[] filesystemConditions = new short[]{9, 10, 13, 14, 12};
    private static final short[] diskArrayConditions = new short[]{67, 68, 64, 65, 5, 7, 8, 24, 6, 123, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 111, 112, 135, 136, 137, 138, 185, 186};
    private static final short[] fabricConditions = new short[]{91, 92, 93, 94, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 103, 104, 105};
    private static final short[] switchConditions = new short[]{95, 96, 97, 98, 99, 100, 124, 125, 126, 127, 128, 129, 130, 131, 132, 107};
    private static final short[] endpointConditions = new short[]{101, 133, 134, 139, 106, 101, 102, 177, 102};
    private static final short[] tapeConditions = new short[]{157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 109};
    private static final short[] externalConditions = new short[]{178};

    public TAlertLog(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TAlertLog", (String)"dbc");
        }
        this.tableName = "t_alert_log";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TAlertLog");
        }
    }

    public void prepSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSave", (String)"");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        this.updateStmt = this.prepareStmt(UPDATE);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSave");
        }
    }

    public void closeSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"closeSave", (String)"");
        }
        this.closeInsert();
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"closeSave");
        }
    }

    public void save(AlertLog alertLog, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"save", (String)"alertLog, cumulativeLogEntry");
        }
        try {
            int n = 0;
            if (bl) {
                n = this.update(alertLog);
            }
            if (n == 0) {
                this.insert(alertLog);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"save", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"save");
        }
    }

    private int update(AlertLog alertLog) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"update", (String)"alertLog");
        }
        this.stmtType = 2;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setInt(this.updateStmt, alertLog.alViolatingValue);
        this.setString(this.updateStmt, alertLog.alNotifyUser);
        this.setTimestamp(this.updateStmt, alertLog.alLastAlertTime);
        this.setInt(this.updateStmt, alertLog.alScriptComputerID);
        this.setString(this.updateStmt, alertLog.alScriptLogFile);
        this.setString(this.updateStmt, alertLog.alScriptName);
        this.setString(this.updateStmt, alertLog.alMessage);
        this.setInt(this.updateStmt, alertLog.alThresholdValue);
        this.setKey(this.updateStmt, alertLog);
        int n = this.executeUpdate(this.updateStmt);
        this.dbc.commit();
        int n2 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"update", (int)n2);
        }
        return n2;
    }

    private void setKey(PreparedStatement preparedStatement, AlertLog alertLog) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setKey", (String)"pStmt, alertLog");
        }
        this.setInt(preparedStatement, alertLog.alAlertID);
        this.setInt(preparedStatement, alertLog.alComputerID);
        this.setInt(preparedStatement, alertLog.alResourceID);
        this.setShort(preparedStatement, alertLog.alResourceType);
        this.setShort(preparedStatement, alertLog.alAlertCondition);
        this.setInt(preparedStatement, alertLog.alViolatorID);
        this.setShort(preparedStatement, alertLog.alViolatorType);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setKey");
        }
    }

    private void insert(AlertLog alertLog) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insert", (String)"alertLog");
        }
        this.stmtType = 1;
        this.stmtPhase = 0;
        this.colIndex = 1;
        if (alertLog.alNotifyUser == null) {
            alertLog.alNotifyUser = " ";
        }
        this.setInt(this.insertStmt, alertLog.alAlertLogID);
        this.setKey(this.insertStmt, alertLog);
        this.setString(this.insertStmt, alertLog.alNotifyUser);
        this.setInt(this.insertStmt, alertLog.alProductID);
        this.setString(this.insertStmt, Character.toString((char)(alertLog.alThresholdType + 48)));
        this.setInt(this.insertStmt, alertLog.alThresholdValue);
        this.setInt(this.insertStmt, alertLog.alViolatingValue);
        this.setInt(this.insertStmt, alertLog.alPreviousValue);
        this.setTimestamp(this.insertStmt, alertLog.alLastAlertTime);
        this.setTimestamp(this.insertStmt, alertLog.alLastAlertTime);
        this.setInt(this.insertStmt, alertLog.alScriptComputerID);
        this.setString(this.insertStmt, alertLog.alScriptLogFile);
        this.setString(this.insertStmt, alertLog.alScriptName);
        this.setString(this.insertStmt, alertLog.alMessage);
        this.setByte(this.insertStmt, alertLog.alDbmsType);
        this.setInt(this.insertStmt, alertLog.alParentID);
        this.executeUpdate(this.insertStmt);
        this.dbc.commit();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insert");
        }
    }

    public void prepDeactivate() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepDeactivate", (String)"");
        }
        this.updateStmt = this.prepareStmt(DEACTIVATE);
        if (this.buffer == null) {
            this.buffer = new AlertLog();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepDeactivate");
        }
    }

    public void prepDeactivateByID() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepDeactivateByID", (String)"");
        }
        this.updateStmt = this.prepareStmt(DEACTIVATE_BY_ID);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepDeactivateByID");
        }
    }

    public void deactivate(int n, int n2, int n3, short s, short s2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deactivate", (String)"alertID, computerID, resourceID, resourceType, alertCondition");
        }
        this.deactivate(n, n2, n3, s, s2, -1, (short)-1);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deactivate");
        }
    }

    public void deactivate(int n, int n2, int n3, short s, short s2, int n4, short s3) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deactivate", (String)"alertID, computerID, resourceID, resourceType, alertCondition, violatorID, violatorType");
        }
        this.buffer.alAlertID = n;
        this.buffer.alComputerID = n2;
        this.buffer.alResourceID = n3;
        this.buffer.alResourceType = s;
        this.buffer.alAlertCondition = s2;
        this.buffer.alViolatorID = n4;
        this.buffer.alViolatorType = s3;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setKey(this.updateStmt, this.buffer);
            this.executeUpdate(this.updateStmt);
            this.commit();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deactivate", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deactivate");
        }
    }

    public void deactivate(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deactivate", (String)"alertLogID");
        }
        byte by = 1;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setByte(this.updateStmt, by);
            this.setInt(this.updateStmt, n);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deactivate", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        this.commit();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deactivate");
        }
    }

    public void deactivateByResource(int n, int[] nArray) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deactivateByResource", (String)"alertID, resourceArray");
        }
        this.deactivate(n, nArray, "resource_id");
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deactivateByResource");
        }
    }

    public void deactivateByViolator(int n, int[] nArray) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deactivateByViolator", (String)"alertID, violatorArray");
        }
        this.deactivate(n, nArray, "violator_id");
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deactivateByViolator");
        }
    }

    private void deactivate(int n, int[] nArray, String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deactivate", (String)"alertID, idArray, idColumnName");
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(DEACTIVATE_BY_ALERT_ID);
        stringBuffer.append(" and ");
        stringBuffer.append(string);
        stringBuffer.append(" in (?,?,?,?,?,?,?,?,?,?)");
        this.updateStmt = this.prepareStmt(stringBuffer.toString());
        int n2 = nArray.length - 1;
        while (n2 >= 0) {
            this.stmtPhase = 0;
            this.colIndex = 1;
            try {
                this.setInt(this.updateStmt, n);
                int n3 = 0;
                while (n3 < 10) {
                    if (n2 >= 0) {
                        this.setInt(this.updateStmt, nArray[n2--]);
                    } else {
                        this.setInt(this.updateStmt, -2147483647);
                    }
                    ++n3;
                }
                this.executeUpdate(this.updateStmt);
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"deactivate", (Throwable)sQLException);
                }
                this.stmtType = 2;
                this.sqlError(sQLException);
            }
            this.commit();
        }
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deactivate");
        }
    }

    public void deleteByFilesystem(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteByFilesystem", (String)"filesystemID");
        }
        this.deleteStmt = this.prepareStmt(DELETE_BY_FS);
        this.stmtType = 3;
        this.execUpdateByID(this.deleteStmt, n);
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteByFilesystem");
        }
    }

    public void deleteByDisk(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteByDisk", (String)"diskID");
        }
        this.deleteStmt = this.prepareStmt(DELETE_BY_DISK);
        this.stmtType = 3;
        this.execUpdateByID(this.deleteStmt, n);
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteByDisk");
        }
    }

    public void deleteByComputer(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteByComputer", (String)"computerID");
        }
        this.deleteStmt = this.prepareStmt(DELETE_BY_COMPUTER);
        this.stmtType = 3;
        this.execUpdateByID(this.deleteStmt, n);
        this.closeDelete();
        this.updateStmt = this.prepareStmt(INVALIDATE_SCRIPT_LOGS);
        this.stmtType = 2;
        this.execUpdateByID(this.updateStmt, n);
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteByComputer");
        }
    }

    public void deleteByDiskArray(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteByDiskArray", (String)"computerID");
        }
        this.deleteStmt = this.prepareStmt(DELETE_BY_DISKARRAY);
        this.stmtType = 3;
        this.execUpdateByID(this.deleteStmt, n);
        this.closeDelete();
        this.updateStmt = this.prepareStmt(INVALIDATE_SCRIPT_LOGS);
        this.stmtType = 2;
        this.execUpdateByID(this.updateStmt, n);
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteByDiskArray");
        }
    }

    public void prepLogicalDelete() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepLogicalDelete", (String)"");
        }
        this.deleteStmt = this.prepareStmt(DELETE);
        this.updateStmt = this.prepareStmt(LOGICALLY_DELETE);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepLogicalDelete");
        }
    }

    public void deleteByID(ExtAlertLog extAlertLog) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteByID", (String)"record");
        }
        TResAttr tResAttr = new TResAttr(this.dbc);
        tResAttr.deleteByAttribute(extAlertLog.alAlertLogID, (short)140);
        this.deleteStmt = this.prepareStmt(DELETE);
        this.stmtType = 3;
        this.execUpdateByID(this.deleteStmt, extAlertLog.alAlertLogID);
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteByID");
        }
    }

    public void logicalDelete(ExtAlertLog extAlertLog) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"logicalDelete", (String)"record");
        }
        TResAttr tResAttr = new TResAttr(this.dbc);
        tResAttr.deleteByAttribute(extAlertLog.alAlertLogID, (short)140);
        this.stmtType = 3;
        this.execUpdateByID(this.deleteStmt, extAlertLog.alAlertLogID);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"logicalDelete");
        }
    }

    public void closeLogicalDelete() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"closeLogicalDelete", (String)"");
        }
        this.closeDelete();
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"closeLogicalDelete");
        }
    }

    private int execUpdateByID(PreparedStatement preparedStatement, int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"execUpdateByID", (String)"stmt, id");
        }
        int n2 = 0;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(preparedStatement, n);
            n2 = this.executeUpdate(preparedStatement);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"execUpdateByID", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        this.commit();
        int n3 = n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"execUpdateByID", (int)n3);
        }
        return n3;
    }

    public void deleteLogicallyDeleted(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteLogicallyDeleted", (String)"alertID");
        }
        this.deleteStmt = this.prepareStmt(DELETE_LOGICALLY_DELETED);
        this.stmtType = 3;
        this.execUpdateByID(this.deleteStmt, n);
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteLogicallyDeleted");
        }
    }

    public NameList[] selectActiveIDs(String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectActiveIDs", (String)"userName");
        }
        this.selectStmt = this.prepareStmt(SELECT_ACTIVE_IDS);
        AlertNameList alertNameList = null;
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                AlertNameList alertNameList2 = new AlertNameList();
                this.colIndex = 1;
                alertNameList2.nlInfo = this.getShort(this.resultSet);
                alertNameList2.nlID = this.getInt(this.resultSet);
                alertNameList2.nlID2 = this.getInt(this.resultSet);
                alertNameList2.nlID3 = this.getInt(this.resultSet);
                alertNameList2.nlSubProductID = this.getByte(this.resultSet);
                this.getShort(this.resultSet);
                String string2 = this.getString(this.resultSet);
                if (string.equals(string2)) {
                    alertNameList2.nlName = string;
                }
                alertNameList2.nlProductID = this.getShort(this.resultSet);
                if (alertNameList2.nlProductID == 1) {
                    alertNameList2.nlProductID = 0;
                }
                alertNameList2.nlNext = alertNameList;
                alertNameList = alertNameList2;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"selectActiveIDs", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeSelect();
        NameList[] nameListArray = NameList.packList(alertNameList);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectActiveIDs", (Object)nameListArray);
        }
        return nameListArray;
    }

    public String getText(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getText", (String)"alertLogID");
        }
        String string = null;
        this.selectStmt = this.prepareStmt(GET_TEXT);
        this.colIndex = 1;
        this.stmtPhase = 0;
        try {
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.colIndex = 1;
            if (this.nextResult()) {
                string = this.getString(this.resultSet);
                this.getShort(this.resultSet);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getText", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeSelect();
        TResAttr tResAttr = new TResAttr(this.dbc);
        string = new StringBuffer(String.valueOf(string)).append(tResAttr.getAffectedHosts(n)).toString();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getText", (Object)string);
        }
        return string;
    }

    private void fetch(Map<Short, ExtAlertLog> map) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetch", (String)"array");
        }
        ExtAlertLog extAlertLog = new ExtAlertLog();
        this.colIndex = 1;
        extAlertLog.alAlertLogID = this.getInt(this.resultSet);
        extAlertLog.alAlertID = this.getInt(this.resultSet);
        extAlertLog.alAlertCondition = this.getShort(this.resultSet);
        short s = AlertConditionManager.getClassId((short)extAlertLog.alAlertCondition);
        if (s < 0) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"fetch");
            }
            return;
        }
        extAlertLog.alNotifyUser = this.getString(this.resultSet);
        extAlertLog.alThresholdType = (byte)(this.getString(this.resultSet).charAt(0) - 48);
        extAlertLog.alThresholdValue = this.getInt(this.resultSet);
        extAlertLog.alViolatingValue = this.getInt(this.resultSet);
        extAlertLog.alPreviousValue = this.getInt(this.resultSet);
        extAlertLog.alFirstAlertTime = this.getTimestamp(this.resultSet);
        extAlertLog.alLastAlertTime = this.getTimestamp(this.resultSet);
        extAlertLog.alAlertCount = this.getInt(this.resultSet);
        extAlertLog.alState = this.getByte(this.resultSet);
        short s2 = this.getShort(this.resultSet);
        int n = this.getInt(this.resultSet);
        short s3 = this.getShort(this.resultSet);
        int n2 = this.getInt(this.resultSet);
        if (extAlertLog.alAlertCondition == 66) {
            extAlertLog.alResourceType = s3;
            extAlertLog.alResourceID = n2;
            extAlertLog.alViolatorType = s2;
            extAlertLog.alViolatorID = n;
        } else {
            extAlertLog.alResourceType = s2;
            extAlertLog.alResourceID = n;
            extAlertLog.alViolatorType = s3;
            extAlertLog.alViolatorID = n2;
        }
        extAlertLog.alCreator = this.getString(this.resultSet);
        extAlertLog.setAlName(this.getString(this.resultSet));
        extAlertLog.alComputerID = this.getInt(this.resultSet);
        extAlertLog.alScriptComputerID = this.getInt(this.resultSet);
        extAlertLog.alScriptLogFile = this.getString(this.resultSet);
        extAlertLog.alScriptName = this.getString(this.resultSet);
        extAlertLog.alProductID = this.getShort(this.resultSet);
        extAlertLog.alDbmsType = this.getByte(this.resultSet);
        extAlertLog.alParentID = this.getInt(this.resultSet);
        extAlertLog.alJobLogFile = this.getString(this.resultSet);
        extAlertLog.alnExt = map.get(s);
        map.put(s, extAlertLog);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetch");
        }
    }

    private Map<Short, ExtAlertLog> doSelect(String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"doSelect", (String)"sqlText");
        }
        this.selectStmt = this.prepareStmt(string);
        HashMap<Short, ExtAlertLog> hashMap = new HashMap<Short, ExtAlertLog>();
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.fetch(hashMap);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"doSelect", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"doSelect", hashMap);
        }
        return hashMap;
    }

    public Map<Short, ExtAlertLog> select(short s, byte by) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"select", (String)"productCode, subProduct");
        }
        StringBuffer stringBuffer = new StringBuffer(450);
        stringBuffer.append(GUI_TABLE_SELECT);
        TAlertLog.appendSubProduct(stringBuffer, s, by);
        Map<Short, ExtAlertLog> map = this.doSelect(stringBuffer.toString());
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"select", map);
        }
        return map;
    }

    public Map<Short, ExtAlertLog> select(short s) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"select", (String)"productCode");
        }
        Map<Short, ExtAlertLog> map = this.select(s, (byte)-1);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"select", map);
        }
        return map;
    }

    private static void appendProduct(StringBuffer stringBuffer, short s) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"appendProduct", (String)"buf, productCode");
        }
        if (s >= 0) {
            stringBuffer.append(" AND l.product_id = ");
            stringBuffer.append(s);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"appendProduct");
        }
    }

    private static void appendSubProduct(StringBuffer stringBuffer, short s, byte by) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"appendSubProduct", (String)"buf, productCode, subProduct");
        }
        TAlertLog.appendProduct(stringBuffer, s);
        if (AlertProductManager.getSubproductCount((short)s) > 0 && AlertProductManager.isValidSubproduct((byte)by)) {
            stringBuffer.append(" AND l.dbms_type = '");
            stringBuffer.append(by);
            stringBuffer.append("'");
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"appendSubProduct");
        }
    }

    public Map<Short, ExtAlertLog> select(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"select", (String)"alertID");
        }
        StringBuffer stringBuffer = new StringBuffer(450);
        stringBuffer.append(GUI_TABLE_SELECT);
        stringBuffer.append(" AND l.alert_id = ");
        stringBuffer.append(Integer.toString(n));
        String string = stringBuffer.toString();
        stringBuffer = null;
        Map<Short, ExtAlertLog> map = this.doSelect(string);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"select", map);
        }
        return map;
    }

    public Map<Short, ExtAlertLog> selectforcleanup() throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectforcleanup", (String)"");
        }
        TConfigSettings tConfigSettings = new TConfigSettings(this.dbc);
        ConfigSettings configSettings = tConfigSettings.getConfigSettings();
        long l = configSettings.csDellogDays;
        long l2 = 0L;
        try {
            l2 = SQLUtil.getTimestamp(this.dbc).getTime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"selectforcleanup", (Throwable)exception);
            }
            return null;
        }
        this.selectStmt = this.prepareStmt(SELECT_FOR_CLEANUP);
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setTimestamp(this.selectStmt, l2 -= (l *= 86400000L));
        HashMap<Short, ExtAlertLog> hashMap = new HashMap<Short, ExtAlertLog>();
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.fetch(hashMap);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"selectforcleanup", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectforcleanup", hashMap);
        }
        return hashMap;
    }

    private static void appendInList(StringBuffer stringBuffer, short[] sArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"appendInList", (String)"buf, conditions");
        }
        if (sArray != null) {
            stringBuffer.append(" AND l.alert_condition IN (");
            boolean bl = false;
            int n = sArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                bl = true;
                stringBuffer.append(Short.toString(sArray[n2]));
                ++n2;
            }
            stringBuffer.append(')');
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"appendInList");
        }
    }

    public Map<Short, ExtAlertLog> select(short s, int n, short s2, byte by) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"select", (String)"objectType, objectID, productID, subProduct");
        }
        short[] sArray = null;
        boolean bl = false;
        switch (s) {
            case 1: 
            case 99: 
            case 100: 
            case 101: {
                sArray = computerConditions;
                break;
            }
            case 78: {
                sArray = diskArrayConditions;
                break;
            }
            case 10: {
                sArray = diskConditions;
                break;
            }
            case 3: {
                sArray = filesystemConditions;
                break;
            }
            case 121: {
                sArray = switchConditions;
                break;
            }
            case 114: {
                sArray = fabricConditions;
                break;
            }
            case 129: {
                sArray = endpointConditions;
                break;
            }
            case 134: {
                sArray = tapeConditions;
                break;
            }
            case 128: {
                sArray = externalConditions;
            }
        }
        StringBuffer stringBuffer = new StringBuffer(550);
        stringBuffer.append(GUI_TABLE_SELECT);
        TAlertLog.appendInList(stringBuffer, sArray);
        if (n > 0) {
            stringBuffer.append(" AND l.");
            if (bl) {
                stringBuffer.append("violator_id = ");
            } else if (s == 1) {
                stringBuffer.append("computer_id = ");
            } else {
                stringBuffer.append("resource_id = ");
            }
            stringBuffer.append(Integer.toString(n));
        } else if (bl) {
            stringBuffer.append(" AND l.violator_type = ");
            stringBuffer.append(Short.toString(s));
        }
        TAlertLog.appendSubProduct(stringBuffer, s2, by);
        String string = stringBuffer.toString();
        stringBuffer = null;
        Map<Short, ExtAlertLog> map = this.doSelect(string);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"select", map);
        }
        return map;
    }

    public Map<Short, ExtAlertLog> selectActive(short s, String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectActive", (String)"productCode, userName");
        }
        StringBuffer stringBuffer = new StringBuffer(450);
        stringBuffer.append(GUI_TABLE_SELECT);
        stringBuffer.append(" AND l.state = ");
        stringBuffer.append(ACTIVE);
        if (string != null) {
            stringBuffer.append(" AND l.notify_user = '");
            stringBuffer.append(string);
            stringBuffer.append('\'');
        }
        if (s >= 0) {
            TAlertLog.appendProduct(stringBuffer, s);
        }
        String string2 = stringBuffer.toString();
        stringBuffer = null;
        Map<Short, ExtAlertLog> map = this.doSelect(string2);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectActive", map);
        }
        return map;
    }

    public void updateJobLogFile(int n, String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateJobLogFile", (String)"alertLogID, jobLogFile");
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("update t_alert_log set job_log_file = '");
        stringBuffer.append(string);
        stringBuffer.append("' where alert_log_id = ");
        stringBuffer.append(n);
        String string2 = stringBuffer.toString();
        stringBuffer = null;
        this.setSQLText(string2);
        this.staticStmt = this.createStatement();
        try {
            this.staticStmt.executeUpdate(string2);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateJobLogFile", (Throwable)sQLException);
            }
            this.stmtPhase = 3;
            this.sqlError(sQLException);
        }
        this.commit();
        this.closeStaticStmt();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateJobLogFile");
        }
    }
}

