/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.CimomConfig;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;

public class TResCimom
extends StorageRepositoryAccessor {
    public static final String DEFAULT_NAME_SPACE = "root/cimv2";
    private static final String ID_COLUMN = "cimom_id";
    private static final String GET_CIMOM = "select cimom_id, port, access_protocol, host, user_id, password, interop_schema_namespace from t_res_registered_cimom order  by host desc, port desc";
    private static final String GET_ID = "select cimom_id from t_res_registered_cimom where UPPER(host) = ?  and port = ?";
    private static final String INSERT = "insert into t_res_registered_cimom  (reg_cimom_id, cimom_id, port, access_protocol, host, user_id,  password, interop_schema_namespace) values (?, ?,?,?,?,?,?,?)";
    private static final String UPDATE_ALL = "update t_res_registered_cimom set port = ?, host = ?, user_id = ?, password = ?, access_protocol = ?, interop_schema_namespace = ?  where cimom_id = ?";
    private static final String UPDATE_PROTOCOL = "update t_res_registered_cimom set access_protocol = ? where cimom_id = ?";
    private static final String SELECT_BY_ID = "select host, port from t_res_registered_cimom where cimom_id = ?";

    public TResCimom(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TResCimom", (String)"dbc");
        }
        this.tableName = "t_res_registered_cimom";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TResCimom");
        }
    }

    public CimomConfig getCimoms() throws StorageException, GeneralException {
        CimomConfig cimomConfig;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getCimoms", (String)"");
        }
        CimomConfig cimomConfig2 = null;
        try {
            this.selectStmt = this.prepareStmt(GET_CIMOM);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.resultSet.next()) {
                cimomConfig = new CimomConfig();
                cimomConfig.ciNext = cimomConfig2;
                cimomConfig2 = cimomConfig;
                this.fetchRow(cimomConfig);
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getCimoms", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        cimomConfig = cimomConfig2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getCimoms", (Object)cimomConfig);
        }
        return cimomConfig;
    }

    private void fetchRow(CimomConfig cimomConfig) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchRow", (String)"cimom");
        }
        this.getPhase();
        cimomConfig.ciID = this.getInt(this.resultSet);
        cimomConfig.ciPort = this.getInt(this.resultSet);
        cimomConfig.ciProtocol = this.getByte(this.resultSet);
        cimomConfig.ciHost = this.getString(this.resultSet);
        cimomConfig.ciUserName = this.getString(this.resultSet);
        cimomConfig.setPassword(this.getString(this.resultSet));
        cimomConfig.ciINamespace = this.getString(this.resultSet);
        if (cimomConfig.ciINamespace.startsWith(" ")) {
            cimomConfig.ciINamespace = null;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchRow");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(CimomConfig cimomConfig) throws StorageException, GeneralException {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"delete", (String)"cimomList");
        }
        try {
            clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Class<?> clazz3 = clazz;
        synchronized (clazz) {
            this.prepDeleteByID(this.tableName, ID_COLUMN);
            CimomConfig cimomConfig2 = cimomConfig;
            while (cimomConfig2 != null) {
                this.deleteByID(cimomConfig2.ciID, true);
                cimomConfig2 = cimomConfig2.ciNext;
            }
            this.closeDelete();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (TraceLogger.enableTrace) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz4.getName(), (String)"delete");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(CimomConfig cimomConfig) throws StorageException, GeneralException {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"save", (String)"cimomList");
        }
        int n = 0;
        try {
            clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Class<?> clazz3 = clazz;
        synchronized (clazz) {
            CimomConfig cimomConfig2 = cimomConfig;
            while (cimomConfig2 != null) {
                if (cimomConfig2.ciID > 0) {
                    this.update(cimomConfig2);
                } else if (!this.fetchID(cimomConfig2)) {
                    ++n;
                } else {
                    this.update(cimomConfig2);
                }
                cimomConfig2 = cimomConfig2.ciNext;
            }
            this.closeSelect();
            this.closeUpdate();
            if (n > 0) {
                int n2 = TResCimom.getIdentifier(1, n, this.dbc);
                cimomConfig2 = cimomConfig;
                while (cimomConfig2 != null) {
                    if (cimomConfig2.ciID <= 0) {
                        cimomConfig2.ciID = n2++;
                        this.insert(cimomConfig2);
                    }
                    cimomConfig2 = cimomConfig2.ciNext;
                }
            }
            this.closeInsert();
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (TraceLogger.enableTrace) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz4.getName(), (String)"save");
            }
            return;
        }
    }

    public boolean fetchID(CimomConfig cimomConfig) throws StorageException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchID", (String)"cimom");
        }
        if (this.selectStmt == null) {
            this.selectStmt = this.prepareStmt(GET_ID);
        }
        boolean bl = false;
        try {
            this.setPhase();
            this.setString(this.selectStmt, cimomConfig.ciHost.toUpperCase());
            this.setInt(this.selectStmt, cimomConfig.ciPort);
            this.resultSet = this.selectStmt.executeQuery();
            bl = this.nextResult();
            if (bl) {
                this.getPhase();
                cimomConfig.ciID = this.getInt(this.resultSet);
            }
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"fetchID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchID", (boolean)bl2);
        }
        return bl2;
    }

    private void update(CimomConfig cimomConfig) throws StorageException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"update", (String)"cimom");
        }
        if (this.updateStmt == null) {
            this.updateStmt = cimomConfig.ciUserName == null ? this.prepareStmt(UPDATE_PROTOCOL) : this.prepareStmt(UPDATE_ALL);
        }
        try {
            this.setPhase();
            if (cimomConfig.ciUserName != null) {
                this.setInt(this.updateStmt, cimomConfig.ciPort);
                this.setString(this.updateStmt, cimomConfig.ciHost);
                this.setLoginData(this.updateStmt, cimomConfig);
            }
            this.setByte(this.updateStmt, cimomConfig.ciProtocol);
            if (cimomConfig.ciUserName != null) {
                this.setString(this.updateStmt, cimomConfig.ciINamespace);
            }
            this.setInt(this.updateStmt, cimomConfig.ciID);
            this.executeUpdate(this.updateStmt);
            this.dbc.commit();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"update", (Throwable)sQLException);
            }
            if (!SQLUtil.isDuplicateKeyViolation(sQLException)) {
                this.stmtType = 2;
                this.sqlError(sQLException);
            }
            Object[] objectArray = new Object[]{cimomConfig.ciHost, new Integer(cimomConfig.ciPort)};
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"update");
            }
            throw new StorageException("STS0303E", objectArray);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"update");
        }
    }

    private void setLoginData(PreparedStatement preparedStatement, CimomConfig cimomConfig) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setLoginData", (String)"pStmt, cimom");
        }
        if (cimomConfig.ciUserName == null) {
            preparedStatement.setNull(this.colIndex++, 12);
            preparedStatement.setNull(this.colIndex++, 12);
        } else {
            this.setString(preparedStatement, cimomConfig.ciUserName);
            this.setString(preparedStatement, cimomConfig.getPassword());
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setLoginData");
        }
    }

    private void insert(CimomConfig cimomConfig) throws StorageException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insert", (String)"cimom");
        }
        if (this.insertStmt == null) {
            this.insertStmt = this.prepareStmt(INSERT);
        }
        try {
            this.setPhase();
            this.setInt(this.insertStmt, cimomConfig.ciID);
            this.setInt(this.insertStmt, cimomConfig.ciID);
            this.setInt(this.insertStmt, cimomConfig.ciPort);
            this.setByte(this.insertStmt, cimomConfig.ciProtocol);
            this.setString(this.insertStmt, cimomConfig.ciHost);
            this.setLoginData(this.insertStmt, cimomConfig);
            this.setString(this.insertStmt, cimomConfig.ciINamespace);
            this.executeUpdate(this.insertStmt);
            this.dbc.commit();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insert", (Throwable)sQLException);
            }
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insert");
        }
    }

    public void prepGetCimomByID() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_BY_ID);
    }

    public String fetchCimomName(int n, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchCimomName", (String)"cimomID, failFriendly");
        }
        String string = null;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                string = String.valueOf(this.getString(this.resultSet)) + ":" + this.getString(this.resultSet);
            } else if (bl) {
                string = "? (" + Integer.toString(n) + ')';
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"fetchCimomName", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeResultSet();
        String string2 = string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchCimomName", string2);
        }
        return string2;
    }

    public String fetchCimomName(int n) throws GeneralException {
        return this.fetchCimomName(n, true);
    }
}

