/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.Cluster;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.NameListQueryable;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TGroup;
import org.eclipse.aperi.repository.table.TGroup2Res;
import org.eclipse.aperi.repository.table.TResAttr;
import org.eclipse.aperi.repository.table.TResDomain;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.xmsg.MessageLog;

public class TResCluster
extends RepositoryAccessor
implements NameListQueryable {
    private static final String SELECT_CLUSTER = "select cluster_id, cluster_name, domain_name from t_res_cluster";
    private static final String SELECT_CLUSTER_ID = "select cluster_id from t_res_cluster where cluster_name = ? and domain_name = ?";
    private static final String SELECT_BY_ID = "select cluster_id, cluster_name, domain_name, ip_address, domain_id, cluster_type, discovered_time from t_res_cluster where cluster_id = ?";
    private static final String SELECT_CLUSTER_BY_NAME_AND_DOMAIN = "select cluster_id, cluster_name, domain_name, ip_address, domain_id, cluster_type, discovered_time from t_res_cluster where cluster_name = ? and domain_name = ?";
    private static final String SELECT_CLUSTER_DETAILS = "select r.cluster_name, r.domain_name, c.host_name, s.os_type from t_res_cluster r,  t_res_host c, t_stat_computer s where s.computer_id = ? and  r.cluster_id = s.cluster_id and  (c.computer_id = s.node_hosted_id or  c.computer_id = s.computer_id ) ";
    private static final String SELECT_CLUSTER_DETAILS_GC = "select r.cluster_id, r.cluster_name, r.domain_name, c.host_name from t_res_cluster r,  t_res_host c, t_stat_computer s where s.computer_id = ? and  r.cluster_id = s.cluster_id and  (c.computer_id = s.node_hosted_id or  c.computer_id = s.computer_id ) ";
    private static final String INSERT = "insert into t_res_cluster (cluster_id, cluster_name, domain_name, ip_address, domain_id, cluster_type, discovered_time) values (?,?,?,?,?,?,?)";
    private static final String UPDATE = "update t_res_cluster set ip_address = ?, domain_id = ?, cluster_type = ? where cluster_id = ?";
    private static final String DELETE_BY_ID = "delete from t_res_cluster where cluster_id = ?";
    public static final String CLUSTER_LOCK = "CLUSTER";

    public TResCluster(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TResCluster", (String)"dbc");
        }
        this.tableName = "t_res_cluster";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TResCluster");
        }
    }

    public Cluster insert(Cluster cluster) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insert", (String)"c");
        }
        Cluster cluster2 = null;
        int n = 0;
        String string = String.valueOf(cluster.clusterName) + "-" + cluster.domain_name;
        try {
            try {
                this.lockCluster(string);
                Cluster cluster3 = this.getClusterByName(cluster.clusterName, cluster.domain_name);
                if (cluster3 != null) {
                    cluster.clusterID = cluster3.clusterID;
                    this.update(cluster, true);
                } else {
                    cluster.clusterID = SQLUtil.getIdentifier(1, 1, this.dbc);
                    this.insertStmt = this.prepareStmt(INSERT);
                    this.setCluster(cluster, this.insertStmt);
                    n = this.insertStmt.executeUpdate();
                    this.dbc.commit();
                }
                if (n > 0) {
                    cluster2 = cluster;
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"insert", (Throwable)sQLException);
                }
                this.stmtType = 1;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {}
        this.closeInsert();
        this.unlockCluster(string);
        Cluster cluster4 = cluster2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insert", cluster4);
        }
        return cluster4;
    }

    private boolean setCluster(Cluster cluster, PreparedStatement preparedStatement) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setCluster", (String)"c, stmt");
        }
        try {
            this.setPhase();
            this.setInt(preparedStatement, cluster.clusterID);
            this.setString(preparedStatement, cluster.clusterName);
            if (cluster.domain_name == null) {
                cluster.domain_name = cluster.windows_domain;
            }
            this.setString(preparedStatement, cluster.domain_name);
            this.setString(preparedStatement, cluster.IPAddress);
            TResDomain tResDomain = new TResDomain(this.dbc);
            Domain domain = new Domain();
            domain.domName = cluster.windows_domain;
            domain.domNext = null;
            if (cluster.windows_domain != null) {
                tResDomain.getIDs(domain);
                this.setInt(preparedStatement, domain.domID);
            } else {
                this.setInt(preparedStatement, -1);
            }
            this.setInt(preparedStatement, cluster.cluster_type);
            cluster.discovered_time = SQLUtil.getTimestamp(this.dbc).getTime();
            this.setTimestamp(preparedStatement, cluster.discovered_time);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"setCluster", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        boolean bl = true;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setCluster", (boolean)bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean update(Cluster cluster, boolean bl) throws GeneralException {
        boolean bl2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"update", (String)"c, locked");
        }
        int n = 0;
        this.updateStmt = this.prepareStmt(UPDATE);
        String string = String.valueOf(cluster.clusterName) + "-" + cluster.domain_name;
        try {
            try {
                if (!bl) {
                    this.lockCluster(string);
                }
                this.setPhase();
                this.setString(this.updateStmt, cluster.IPAddress);
                TResDomain tResDomain = new TResDomain(this.dbc);
                Domain domain = new Domain();
                domain.domName = cluster.windows_domain;
                domain.domNext = null;
                if (cluster.windows_domain != null) {
                    tResDomain.getIDs(domain);
                    this.setInt(this.updateStmt, domain.domID);
                } else {
                    this.setInt(this.updateStmt, -1);
                }
                this.setInt(this.updateStmt, cluster.cluster_type);
                this.setInt(this.updateStmt, cluster.clusterID);
                n = this.executeUpdate(this.updateStmt);
                this.dbc.commit();
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"update", (Throwable)sQLException);
                }
                this.stmtType = 2;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.closeUpdate();
            if (!bl) {
                this.unlockCluster(string);
            }
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        this.closeUpdate();
        if (!bl) {
            this.unlockCluster(string);
        }
        boolean bl3 = bl2 = n > 0;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"update", (boolean)bl2);
        }
        return bl2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deleteByID(int n) throws GeneralException {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteByID", (String)"cluster_id");
        }
        int n2 = 0;
        try {
            try {
                this.lockCluster(Integer.toString(n));
                this.deleteStmt = this.prepareStmt(DELETE_BY_ID);
                this.setPhase();
                this.setInt(this.deleteStmt, n);
                n2 = this.executeUpdate(this.deleteStmt);
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"deleteByID", (Throwable)sQLException);
                }
                this.stmtType = 3;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeDelete();
            this.unlockCluster(Integer.toString(n));
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        this.closeDelete();
        this.unlockCluster(Integer.toString(n));
        boolean bl2 = bl = n2 > 0;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteByID", (boolean)bl);
        }
        return bl;
    }

    private Cluster getCluster() throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getCluster", (String)"");
        }
        Cluster cluster = new Cluster();
        this.getPhase();
        if (!this.nextResult()) {
            Cluster cluster2 = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getCluster", cluster2);
            }
            return cluster2;
        }
        cluster.clusterID = this.getInt(this.resultSet);
        cluster.clusterName = this.getString(this.resultSet);
        cluster.domain_name = this.getString(this.resultSet);
        cluster.IPAddress = this.getString(this.resultSet);
        cluster.domain_id = this.getInt(this.resultSet);
        Domain domain = new Domain();
        domain.domID = cluster.domain_id;
        TResDomain tResDomain = new TResDomain(this.dbc);
        tResDomain.getName(domain);
        cluster.windows_domain = domain.domName;
        cluster.cluster_type = this.getShort(this.resultSet);
        cluster.discovered_time = this.getTimestamp(this.resultSet);
        Cluster cluster3 = cluster;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getCluster", (Object)cluster3);
        }
        return cluster3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Cluster getClusterByID(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getClusterByID", (String)"cluster_id");
        }
        Cluster cluster = null;
        try {
            try {
                this.selectStmt = this.prepareStmt(SELECT_BY_ID);
                this.setPhase();
                this.setInt(this.selectStmt, n);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                cluster = this.getCluster();
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getClusterByID", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeResultSet();
            this.closeSelect();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        this.closeResultSet();
        this.closeSelect();
        Cluster cluster2 = cluster;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getClusterByID", (Object)cluster2);
        }
        return cluster2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Cluster getClusterByName(String string, String string2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getClusterByName", (String)"name, domain");
        }
        Cluster cluster = null;
        try {
            try {
                this.selectStmt = this.prepareStmt(SELECT_CLUSTER_BY_NAME_AND_DOMAIN);
                this.setPhase();
                this.setString(this.selectStmt, string);
                this.setString(this.selectStmt, string2);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                cluster = this.getCluster();
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getClusterByName", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.closeResultSet();
            this.closeSelect();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        this.closeResultSet();
        this.closeSelect();
        Cluster cluster2 = cluster;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getClusterByName", (Object)cluster2);
        }
        return cluster2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getClusterID(String string, String string2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getClusterID", (String)"name, domain");
        }
        int n = -1;
        try {
            try {
                this.selectStmt = this.prepareStmt(SELECT_CLUSTER_ID);
                this.setPhase();
                this.setString(this.selectStmt, string);
                this.setString(this.selectStmt, string2);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.getPhase();
                if (this.nextResult()) {
                    n = this.getInt(this.resultSet);
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getClusterID", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.closeResultSet();
            this.closeSelect();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        this.closeResultSet();
        this.closeSelect();
        int n2 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getClusterID", (int)n2);
        }
        return n2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NameList selectNames(GuiListReq guiListReq) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectNames", (String)"requestData");
        }
        NameList nameList = null;
        NameList nameList2 = null;
        try {
            try {
                this.selectStmt = this.prepareStmt("select cluster_id, cluster_name, domain_name from t_res_cluster order by cluster_name");
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                while (this.nextResult()) {
                    this.getPhase();
                    NameList nameList3 = new NameList();
                    nameList3.nlID = nameList3.nlClusterID = this.getInt(this.resultSet);
                    nameList3.nlName = this.getString(this.resultSet);
                    nameList3.nlInfo = (short)99;
                    nameList3.nlID2 = 22;
                    nameList3.nlClusterName = nameList3.nlName;
                    nameList3.nlClusterDomain = this.getString(this.resultSet);
                    nameList3.nlName = String.valueOf(nameList3.nlName) + "-" + nameList3.nlClusterDomain;
                    if (nameList2 == null) {
                        nameList = nameList3;
                    } else {
                        nameList2.nlNext = nameList3;
                    }
                    nameList2 = nameList3;
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"selectNames", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.closeResultSet();
            this.closeSelect();
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        this.closeResultSet();
        this.closeSelect();
        NameList nameList4 = nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectNames", nameList4);
        }
        return nameList4;
    }

    public void prepGetClusterDetailsGC() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_CLUSTER_DETAILS_GC);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getClusterDetailsGC(GComputer gComputer) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getClusterDetailsGC", (String)"gc");
        }
        try {
            try {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.selectStmt, gComputer.gcComputerID);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.stmtPhase = 1;
                this.colIndex = 1;
                if (this.nextResult()) {
                    gComputer.gcClusterID = this.getInt(this.resultSet);
                    gComputer.gcClusterName = this.getString(this.resultSet);
                    gComputer.gcDomainName = this.getString(this.resultSet);
                    gComputer.gcHostedNodeName = this.getString(this.resultSet);
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getClusterDetailsGC", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.closeResultSet();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.closeResultSet();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getClusterDetailsGC");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fillInClusterDetails(NameList nameList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fillInClusterDetails", (String)"nlComp");
        }
        String string = SELECT_CLUSTER_DETAILS;
        try {
            try {
                this.selectStmt = this.prepareStmt(string);
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.selectStmt, nameList.nlID);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.stmtPhase = 1;
                this.colIndex = 1;
                if (this.nextResult()) {
                    nameList.nlClusterName = this.getString(this.resultSet);
                    nameList.nlClusterDomain = this.getString(this.resultSet);
                    nameList.nlHostName = this.getString(this.resultSet);
                    nameList.nlID2 = this.getShort(this.resultSet);
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"fillInClusterDetails", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.closeResultSet();
            this.closeSelect();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.closeResultSet();
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fillInClusterDetails");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean cleanupCluster(int n) throws GeneralException {
        boolean bl;
        block17: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"cleanupCluster", (String)"cluster_id");
            }
            bl = false;
            TStatComputer tStatComputer = new TStatComputer(this.dbc);
            NameList nameList = tStatComputer.getClusterMembers(n);
            if (nameList != null) break block17;
            try {
                try {
                    bl = this.deleteByID(n);
                    TResAttr tResAttr = new TResAttr(this.dbc);
                    tResAttr.deleteByID(n);
                    LockManager.lock((short)0, (String)"GLOBAL", (String)"DELETE", (byte)2, (boolean)true);
                    TGroup2Res tGroup2Res = new TGroup2Res(this.dbc);
                    tGroup2Res.deleteResources(n, (short)99, true);
                    TGroup tGroup = new TGroup(this.dbc);
                    String string = MessageLog.getMessageNoID((String)"STS0812L");
                    tGroup.deleteByID(n, string);
                    tGroup.commit();
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"cleanupCluster", (Throwable)generalException);
                    }
                    Object[] objectArray = new Object[]{new Integer(n)};
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"cleanupCluster");
                    }
                    throw new GeneralException(MessageLog.getMessage((String)"SRV0906E", (Object[])objectArray));
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                LockManager.unLock((short)0, (String)"GLOBAL", (String)"DELETE");
                throw throwable;
            }
            {
                Object var9_14 = null;
            }
            LockManager.unLock((short)0, (String)"GLOBAL", (String)"DELETE");
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"cleanupCluster", (boolean)bl2);
        }
        return bl2;
    }

    public int cleanupClusters() throws GeneralException {
        NameList nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"cleanupClusters", (String)"");
        }
        int n = 0;
        NameList nameList2 = nameList = this.selectNames(null);
        while (nameList2 != null) {
            if (this.cleanupCluster(nameList2.nlID)) {
                ++n;
            }
            nameList2 = nameList2.nlNext;
        }
        int n2 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCluster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"cleanupClusters", (int)n2);
        }
        return n2;
    }

    private boolean lockCluster(String string) {
        return LockManager.lock((short)0, (String)CLUSTER_LOCK, (String)string, (byte)1, (boolean)true);
    }

    private void unlockCluster(String string) {
        if (string != null) {
            LockManager.unLock((short)0, (String)CLUSTER_LOCK, (String)string);
        }
    }
}

