/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.aperi.TStorm.common.CompHist;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TStormSettings;

public class TStatCompHist
extends StorageRepositoryAccessor {
    private Timestamp tsStart = new Timestamp(0L);
    private Timestamp tsEnd = new Timestamp(0L);
    Settings settings;
    CompHist accumulator;
    GregorianCalendar calendar;
    Date currentTime;
    private static final String SELECT_UNIQUE_ACCUMULATOR = "select computer_id, statistic_type, monitor_start, monitor_end, down_time, power_cycles from t_stat_comp_hist where computer_id = ? and statistic_type = ?";
    private static final String SELECT_ACCUMULATOR = "select computer_id, statistic_type, monitor_start, monitor_end, down_time, power_cycles from t_stat_comp_hist where statistic_type = ?";
    private static final String INSERT = "insert into t_stat_comp_hist (computer_id, statistic_type, monitor_start, monitor_end, down_time, power_cycles) values (?,?,?,?,?,?)";
    private static final String UPDATE_ACCUMULATOR = "update t_stat_comp_hist set monitor_start = ?, monitor_end = ?, down_time = ?, power_cycles = ? where computer_id = ? and statistic_type = ?";
    private static final String AGE_OFF_HIST = "delete from t_stat_comp_hist where monitor_end < ? and computer_id = ? and statistic_type = ?";

    public TStatCompHist(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TStatCompHist", (String)"dbc");
        }
        this.tableName = "t_stat_comp_hist";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TStatCompHist");
        }
    }

    public void save(CompHist compHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"save", (String)"compHist");
        }
        if (this.accumulator == null) {
            this.accumulator = new CompHist();
        }
        if (this.calendar == null) {
            this.calendar = new GregorianCalendar();
            this.currentTime = new Date();
        }
        TStormSettings tStormSettings = new TStormSettings(this.dbc);
        this.settings = tStormSettings.getSettings();
        tStormSettings.closeSelect();
        this.insertStmt = this.prepareStmt(INSERT);
        this.updateStmt = this.prepareStmt(UPDATE_ACCUMULATOR);
        this.selectStmt = this.prepareStmt(SELECT_UNIQUE_ACCUMULATOR);
        if (this.settings.seCompDailyHist > 0) {
            compHist.chStatisticType = 0;
            this.insert(compHist);
            this.commit();
        }
        if (this.settings.seCompWeeklyHist > 0) {
            compHist.chStatisticType = (byte)3;
            this.updateAccumulator(compHist);
            this.commit();
        }
        if (this.settings.seCompMonthlyHist > 0) {
            compHist.chStatisticType = (byte)4;
            this.updateAccumulator(compHist);
            this.commit();
        }
        this.closeInsert();
        this.closeUpdate();
        this.closeSelect();
        this.deleteStmt = this.prepareStmt(AGE_OFF_HIST);
        this.ageHist(compHist);
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"save");
        }
    }

    public void insert(CompHist compHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insert", (String)"compHist");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setKey(compHist, this.insertStmt);
            this.setStats(compHist, this.insertStmt);
            this.executeUpdate(this.insertStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insert", (Throwable)sQLException);
            }
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insert");
        }
    }

    private void setStats(CompHist compHist, PreparedStatement preparedStatement) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setStats", (String)"compHist, stmt");
        }
        this.setTimestamp(preparedStatement, compHist.chMonitorStart, this.tsStart);
        this.setTimestamp(preparedStatement, compHist.chMonitorEnd, this.tsEnd);
        this.setInt(preparedStatement, compHist.chDownTime);
        this.setInt(preparedStatement, compHist.chPowerCycles);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setStats");
        }
    }

    private void updateAccumulator(CompHist compHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateAccumulator", (String)"compHist");
        }
        boolean bl = false;
        try {
            this.stmtType = 0;
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setKey(compHist, this.selectStmt);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            bl = this.fetch(this.accumulator);
            this.closeResultSet(this.resultSet);
            if (bl) {
                this.accumulator.chDownTime += compHist.chDownTime;
                this.accumulator.chPowerCycles += compHist.chPowerCycles;
                if (this.accumulator.chMonitorStart <= 86400000L) {
                    this.accumulator.chMonitorStart = compHist.chMonitorStart;
                }
                this.accumulator.chMonitorEnd = compHist.chMonitorEnd;
                this.update(this.accumulator);
            } else {
                this.insert(compHist);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateAccumulator", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateAccumulator");
        }
    }

    public void update(CompHist compHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"update", (String)"accumulator");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setStats(compHist, this.updateStmt);
            this.setKey(compHist, this.updateStmt);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"update", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"update");
        }
    }

    private void setKey(CompHist compHist, PreparedStatement preparedStatement) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setKey", (String)"compHist, stmt");
        }
        this.setInt(preparedStatement, compHist.chComputerID);
        this.setByte(preparedStatement, compHist.chStatisticType);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setKey");
        }
    }

    public boolean fetch(CompHist compHist) throws GeneralException {
        block14: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"fetch", (String)"compHist");
            }
            try {
                if (!this.nextResult(this.resultSet)) break block14;
                this.stmtPhase = 1;
                this.colIndex = 1;
                compHist.chComputerID = this.getInt(this.resultSet);
                compHist.chStatisticType = this.getByte(this.resultSet);
                compHist.chMonitorStart = this.getTimestamp(this.resultSet);
                compHist.chMonitorEnd = this.getTimestamp(this.resultSet);
                compHist.chDownTime = this.getInt(this.resultSet);
                compHist.chPowerCycles = this.getInt(this.resultSet);
                boolean bl = true;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"fetch", (boolean)bl);
                }
                return bl;
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"fetch", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        boolean bl = false;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetch", (boolean)bl);
        }
        return bl;
    }

    private void ageHist(CompHist compHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"ageHist", (String)"compHist");
        }
        long l = 0L;
        try {
            l = SQLUtil.getTimestamp(this.dbc).getTime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"ageHist", (Throwable)exception);
            }
            return;
        }
        this.currentTime.setTime(l);
        try {
            if (this.settings.seCompDailyHist != 0) {
                compHist.chStatisticType = 0;
                this.ageOff(compHist, this.settings.seCompDailyHist, 5);
            }
            if (this.settings.seCompWeeklyHist != 0) {
                compHist.chStatisticType = 1;
                this.ageOff(compHist, this.settings.seCompWeeklyHist * 7, 5);
            }
            if (this.settings.seCompMonthlyHist != 0) {
                compHist.chStatisticType = (byte)2;
                this.ageOff(compHist, this.settings.seCompMonthlyHist, 2);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"ageHist", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"ageHist");
        }
    }

    private void ageOff(CompHist compHist, int n, int n2) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"ageOff", (String)"compHist, retention, calendarUnit");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.calendar.setTime(this.currentTime);
        this.calendar.add(n2, -n);
        this.setTimestamp(this.deleteStmt, this.calendar.getTime().getTime());
        this.setKey(compHist, this.deleteStmt);
        this.executeUpdate(this.deleteStmt);
        this.dbc.commit();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"ageOff");
        }
    }

    public void prepAverages(byte by) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepAverages", (String)"statisticType");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        this.updateStmt = this.prepareStmt(UPDATE_ACCUMULATOR);
        this.selectStmt = this.prepareStmt(SELECT_ACCUMULATOR);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setByte(this.selectStmt, by);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"prepAverages", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepAverages");
        }
    }

    public void closeAverages() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"closeAverages", (String)"");
        }
        this.closeInsert();
        this.closeUpdate();
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatCompHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"closeAverages");
        }
    }
}

