/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import org.eclipse.aperi.TStorm.server.guireq.RespFSspace;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.UnmanagedCompHndlr;
import org.eclipse.aperi.repository.report.RptDiskCapacity;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.guireq.DashTotalsRow;

public class TStatTotals
extends RepositoryAccessor {
    private static final String TOTALS_LOCK = "TOTALLER";
    private static String SELECT_FILESYSTEM_STATS = "select sum(capacity), sum(used_space), sum(free_space), sum(directory_count), sum(file_count) from t_res_filesystem";
    private static String SELECT_FILESYSTEM_COUNT = "select count(*) from t_res_filesystem";
    private static String SELECT_MANAGED_COMPUTER_COUNT = "select count(*) from t_stat_computer s where " + TStatComputer.EXCLUDE_UNMANAGED_OSTYPES;
    private static String SELECT_DISK_COUNT = "select count(*) from t_stat_disk";
    private static String SELECT_SS_COUNT = "select count(distinct (ss.subsystem_id))  from t_res_storage_subsystem ss, t_res_storage_volume sv  where ss.subsystem_id = sv.subsystem_id";
    private static String SELECT_SS_STATS = " select count(svid), sum(distinct(allocated_capacity)) from  t_res_storage_subsystem ss, t_res_storage_volume sv  where sv.subsystem_id = ss.subsystem_id ";
    private static String SELECT_SS_USABLE_LUN_CAP = " select sum(capacity)  from  t_res_storage_volume sv, t_res_storage_subsystem ss  where   sv.subsystem_id = ss.subsystem_id  and snap_source_id < 0  and is_vcmdb = '0'  and replication_mode <> '" + Integer.toString(2) + "'";
    private static String ACTIVE_ALERT = "'0'";
    private static String SELECT_ALL_ALERT_COUNT = "select count(*) from t_alert_log where (state = " + ACTIVE_ALERT + " and product_id = " + 0 + ") or (product_id = " + 3 + " and state = " + ACTIVE_ALERT + ")";
    private static String SELECT_COMPUTER_ALERT_COUNT = "select count(*) from t_alert_log where state = " + ACTIVE_ALERT + " and product_id = " + 0 + " and resource_type = " + 1;
    private static String SELECT_HARD_DISK_ALERT_COUNT = "select count(*) from t_alert_log where state = " + ACTIVE_ALERT + " and product_id = " + 0 + " and resource_type = " + 10;
    private static String SELECT_FILESYSTEM_ALERT_COUNT = "select count(*) from t_alert_log where state = " + ACTIVE_ALERT + " and product_id = " + 0 + " and resource_type = " + 3;
    private static String SELECT_STORAGE_SUBSYTEM_ALERT_COUNT = "select count(*) from t_alert_log where state = " + ACTIVE_ALERT + " and product_id = " + 3 + " and resource_type = " + 78;
    private static String SELECT_SWITCH_ALERT_COUNT = "select count(*) from t_alert_log where state = " + ACTIVE_ALERT + " and product_id = " + 0 + " and resource_type = " + 121;
    private static String SELECT_FABRIC_ALERT_COUNT = "select count(*) from t_alert_log where state = " + ACTIVE_ALERT + " and product_id = " + 0 + " and resource_type = " + 114;
    private static String SELECT_TAPE_LIBRARY_ALERT_COUNT = "select count(*) from t_alert_log where state = " + ACTIVE_ALERT + " and product_id = " + 0 + " and resource_type = " + 134;
    private static String SELECT_ENDPOINT_DEVICE_ALERT_COUNT = "select count(*) from t_alert_log where state = " + ACTIVE_ALERT + " and product_id = " + 0 + " and (resource_type = " + 129 + " or resource_type = " + 138 + " or resource_type = " + 137 + " or resource_type = " + 139 + ")";
    private static String SELECT_EXTERNAL_ALERT_COUNT = "select count(*) from t_alert_log where state = " + ACTIVE_ALERT + " and product_id = " + 0 + " and resource_type = " + 128;
    private static String SELECT_USER_ALERT_COUNT = "select notify_user, count(*) from t_alert_log where state = " + ACTIVE_ALERT + " and product_id = " + 0 + " group by notify_user";
    private static String SELECT_COMPUTER_TYPES = "select os_type, count(*) from t_stat_computer group by os_type";
    private static String SELECT_FS_CAPACITY_BY_OSTYPE = "select c.os_type, sum(f.capacity) from t_res_share s, t_stat_computer c, t_res_filesystem f where s.resource_type = 3 and s.computer_id = c.computer_id and s.resource_id = f.filesystem_id group by c.os_type";
    private static String SELECT_DISK_CAPACITY_BY_OSTYPE = "select c.os_type, d.disk_id, d.capacity, s.removed_time from t_res_share s, t_stat_computer c, t_stat_disk d where s.resource_type = 10 and s.computer_id = c.computer_id and s.resource_id = d.disk_id order by c.os_type, d.disk_id";
    private static String SELECT_FILESYSTEM_PERCENTS = "select (f.free_space * 100) / (f.free_space + f.used_space), f.capacity, c.host_name, f.mount_point from t_res_filesystem f, t_res_host c where (f.free_space > 0 or f.used_space > 0) and f.computer_id = c.computer_id order by 1";
    private static String DELETE = "delete from t_stat_totals";
    private static String INSERT = "insert into t_stat_totals (statistic_type, update_time, fs_capacity, used_space, free_space, disk_capacity, disk_unallocated, total_directories, total_files, total_filesystems, total_agents, total_computers, total_users, total_disks, all_alerts, computer_alerts, hard_disk_alerts, filesystem_alerts, directory_alerts, user_quota_alerts, grp_quota_alerts, user_alerts, computer_type, user_name, filesystem_name, total_ss, total_luns, lun_capacity, usable_lun_cap, ss_alerts, switch_alerts, fabric_alerts, endpt_alerts, tape_lib_alerts, external_alerts) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static String SELECT = "select statistic_type, user_name, user_alerts, filesystem_name, used_space, fs_capacity, free_space, computer_type, total_computers, disk_capacity, update_time, disk_unallocated, total_directories, total_files, total_filesystems, total_agents, total_users, total_disks, all_alerts, computer_alerts, hard_disk_alerts, filesystem_alerts, directory_alerts, user_quota_alerts, grp_quota_alerts, total_ss, total_luns, lun_capacity, usable_lun_cap, ss_alerts, switch_alerts, fabric_alerts, endpt_alerts, tape_lib_alerts, external_alerts from t_stat_totals";
    private static String DECOMMSELECT = "SELECT host_name, host_url, network_name, os_type from t_res_host";
    private int deComAgents = 0;
    private int agentCount = 0;
    private int decomTemp = 0;

    public TStatTotals(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatTotals");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TStatTotals", (String)"dbc");
        }
        this.tableName = "t_stat_totals";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatTotals");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TStatTotals");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DashTotalsRow aggregate(String var1_1) throws GeneralException {
        block54: {
            if (TraceLogger.enableTrace) {
                try {
                    v0 = Class.forName("org.eclipse.aperi.repository.table.TStatTotals");
                }
                catch (ClassNotFoundException v1) {
                    throw new NoClassDefFoundError(v1.getMessage());
                }
                TraceLogger.entry((String)v0.getName(), (String)"aggregate", (String)"userID");
            }
            var2_2 = new DashTotalsRow();
            var2_2.dtrNext = null;
            var2_2.dtrStatisticType = 1;
            try {
                var2_2.dtrUpdateTime = SQLUtil.getTimestamp(this.dbc).getTime();
            }
            catch (Exception var4_3) {
                var4_3.printStackTrace();
                if (TraceLogger.enableTrace) {
                    try {
                        v2 = Class.forName("org.eclipse.aperi.repository.table.TStatTotals");
                    }
                    catch (ClassNotFoundException v3) {
                        throw new NoClassDefFoundError(v3.getMessage());
                    }
                    TraceLogger.exception((String)v2.getName(), (String)"aggregator", (Throwable)var4_3);
                }
                return null;
            }
            var4_4 = false;
            try {
                this.staticStmt = this.createStatement();
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_FILESYSTEM_STATS);
                if (this.nextResult()) {
                    this.getPhase();
                    var2_2.dtrFilesystemCapacity = this.getLong(this.resultSet);
                    var2_2.dtrUsedSpace = this.getLong(this.resultSet);
                    var2_2.dtrFreeSpace = this.getLong(this.resultSet);
                    var2_2.dtrTotalDirectories = this.getInt(this.resultSet);
                    var2_2.dtrTotalFiles = this.getInt(this.resultSet);
                }
                var5_5 = new RespFSspace();
                var6_9 = new RptDiskCapacity(this.dbc);
                var6_9.getNetworkValues((RespFSspace)var5_5);
                var2_2.dtrDiskCapacity = var5_5.capacity;
                var2_2.dtrDiskUnallocated = var5_5.unallocated;
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_FILESYSTEM_COUNT);
                if (this.nextResult()) {
                    this.getPhase();
                    var2_2.dtrTotalFilesystems = this.getInt(this.resultSet);
                }
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_MANAGED_COMPUTER_COUNT);
                if (this.nextResult()) {
                    this.getPhase();
                    var2_2.dtrTotalAgents = this.getInt(this.resultSet);
                }
                var2_2.dtrTotalAgents -= this.getDecommAgentCount();
                var7_10 = new UnmanagedCompHndlr(this.dbc);
                var8_12 = var7_10.getUnmanaged();
                var2_2.dtrTotalComputers = var8_12.length;
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_SS_COUNT);
                if (this.nextResult()) {
                    this.getPhase();
                    var2_2.dtrTotalStorageSubsystems = this.getInt(this.resultSet);
                }
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_SS_STATS);
                if (this.nextResult()) {
                    this.getPhase();
                    var2_2.dtrTotalLUNs = this.getInt(this.resultSet);
                    var2_2.dtrLunCapacity = this.getLong(this.resultSet);
                }
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_SS_USABLE_LUN_CAP);
                if (this.nextResult()) {
                    this.getPhase();
                    var2_2.dtrUsableLunCap = this.getLong(this.resultSet);
                }
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_DISK_COUNT);
                if (this.nextResult()) {
                    this.getPhase();
                    var2_2.dtrTotalDisks = this.getInt(this.resultSet);
                }
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_ALL_ALERT_COUNT);
                if (this.nextResult()) {
                    this.getPhase();
                    var2_2.dtrAllAlerts = this.getInt(this.resultSet);
                }
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_COMPUTER_ALERT_COUNT);
                if (this.nextResult()) {
                    this.getPhase();
                    var2_2.dtrComputerAlerts = this.getInt(this.resultSet);
                }
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_HARD_DISK_ALERT_COUNT);
                if (this.nextResult()) {
                    this.getPhase();
                    var2_2.dtrHardDiskAlerts = this.getInt(this.resultSet);
                }
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_STORAGE_SUBSYTEM_ALERT_COUNT);
                if (this.nextResult()) {
                    this.getPhase();
                    var2_2.dtrStorageSubsystemAlerts = this.getInt(this.resultSet);
                }
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_SWITCH_ALERT_COUNT);
                if (this.nextResult()) {
                    this.getPhase();
                    var2_2.dtrSwitchAlerts = this.getInt(this.resultSet);
                }
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_FABRIC_ALERT_COUNT);
                if (this.nextResult()) {
                    this.getPhase();
                    var2_2.dtrFabricAlerts = this.getInt(this.resultSet);
                }
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_ENDPOINT_DEVICE_ALERT_COUNT);
                if (this.nextResult()) {
                    this.getPhase();
                    var2_2.dtrEndpointDeviceAlerts = this.getInt(this.resultSet);
                }
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_TAPE_LIBRARY_ALERT_COUNT);
                if (this.nextResult()) {
                    this.getPhase();
                    var2_2.dtrTapeLibraryAlerts = this.getInt(this.resultSet);
                }
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_EXTERNAL_ALERT_COUNT);
                if (this.nextResult()) {
                    this.getPhase();
                    var2_2.dtrExternalAlerts = this.getInt(this.resultSet);
                }
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_FILESYSTEM_ALERT_COUNT);
                if (this.nextResult()) {
                    this.getPhase();
                    var2_2.dtrFilesystemAlerts = this.getInt(this.resultSet);
                }
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_USER_ALERT_COUNT);
                while (true) {
                    if (!this.nextResult()) break;
                    var3_13 = new DashTotalsRow();
                    var3_13.dtrStatisticType = (short)2;
                    this.getPhase();
                    var3_13.dtrUserName = this.getString(this.resultSet);
                    var3_13.dtrUserAlerts = this.getInt(this.resultSet);
                    if (var3_13.dtrUserName.equals(var1_1)) {
                        var2_2.dtrUserAlerts = var3_13.dtrUserAlerts;
                    }
                    var3_13.dtrNext = var2_2.dtrNext;
                    var2_2.dtrNext = var3_13;
                }
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_COMPUTER_TYPES);
                while (true) {
                    if (!this.nextResult()) break;
                    var3_13 = new DashTotalsRow();
                    var3_13.dtrStatisticType = (short)5;
                    this.getPhase();
                    var3_13.dtrComputerType = this.getShort(this.resultSet);
                    var3_13.dtrTotalComputers = this.getInt(this.resultSet);
                    var3_13.dtrNext = var2_2.dtrNext;
                    var2_2.dtrNext = var3_13;
                }
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_FS_CAPACITY_BY_OSTYPE);
                block21: while (true) {
                    if (!this.nextResult()) break;
                    this.getPhase();
                    var9_14 = this.getShort(this.resultSet);
                    var10_15 = this.getLong(this.resultSet);
                    var3_13 = var2_2.dtrNext;
                    while (true) {
                        if (var3_13 == null) continue block21;
                        if (var3_13.dtrStatisticType == 5 && var3_13.dtrComputerType == var9_14) {
                            var3_13.dtrFilesystemCapacity = var10_15;
                            continue block21;
                        }
                        var3_13 = var3_13.dtrNext;
                    }
                    break;
                }
                var13_16 = -777;
                var14_17 = -777;
                var15_18 = 0L;
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_DISK_CAPACITY_BY_OSTYPE);
                while (true) {
                    if (!this.nextResult()) break;
                    this.getPhase();
                    var9_14 = this.getShort(this.resultSet);
                    var12_19 = this.getInt(this.resultSet);
                    var10_15 = this.getLong(this.resultSet);
                    var17_20 = this.getTimestamp(this.resultSet);
                    if (var9_14 != var13_16) {
                        this.updateDiskCapacity(var2_2.dtrNext, var13_16, var15_18);
                        var13_16 = var9_14;
                        var14_17 = -777;
                        var15_18 = 0L;
                    }
                    if (var12_19 == var14_17) continue;
                    if (var17_20 < 86400000L) {
                        var15_18 += var10_15;
                    }
                    var14_17 = var12_19;
                }
                this.updateDiskCapacity(var2_2.dtrNext, var13_16, var15_18);
                var19_21 = 0;
                this.resultSet = this.staticStmt.executeQuery(TStatTotals.SELECT_FILESYSTEM_PERCENTS);
                while (true) {
                    if (!this.nextResult() || var19_21 >= 10) {
                        var4_4 = true;
                        this.closeStaticStmt();
                        break;
                    }
                    var3_13 = new DashTotalsRow();
                    var3_13.dtrStatisticType = (short)4;
                    this.getPhase();
                    var3_13.dtrFreeSpace = this.getLong(this.resultSet);
                    var3_13.dtrFilesystemCapacity = this.getLong(this.resultSet);
                    var3_13.dtrFilesystemName = String.valueOf(this.getString(this.resultSet)) + "." + this.getString(this.resultSet);
                    var3_13.dtrNext = var2_2.dtrNext;
                    var2_2.dtrNext = var3_13;
                    ++var19_21;
                }
            }
            catch (SQLException var5_6) {
                if (TraceLogger.enableTrace) {
                    try {
                        v4 = Class.forName("org.eclipse.aperi.repository.table.TStatTotals");
                    }
                    catch (ClassNotFoundException v5) {
                        throw new NoClassDefFoundError(v5.getMessage());
                    }
                    TraceLogger.exception((String)v4.getName(), (String)"aggregate", (Throwable)var5_6);
                }
                this.stmtType = 0;
                this.sqlError(var5_6);
            }
            if (!var4_4) break block54;
            try {
                try {
                    block55: {
                        var5_7 = LockManager.lock((short)0, (String)"TOTALLER", (String)"TOTALLER", (byte)1, (boolean)false);
                        if (!var5_7) break block55;
                        this.staticStmt = this.createStatement();
                        this.staticStmt.executeUpdate(TStatTotals.DELETE);
                        this.closeStaticStmt();
                        this.insertStmt = this.prepareStmt(TStatTotals.INSERT);
                        var3_13 = var2_2;
                        while (true) {
                            block56: {
                                if (var3_13 != null) break block56;
                                this.insertStmt.close();
                                this.dbc.commit();
                                ** GOTO lbl-1000
                            }
                            this.insert(var3_13);
                            var3_13 = var3_13.dtrNext;
                        }
                    }
                    LockManager.lock((short)0, (String)"TOTALLER", (String)"TOTALLER", (byte)1, (boolean)true);
                    var2_2 = this.select(var1_1);
                }
                catch (SQLException var5_8) {
                    if (TraceLogger.enableTrace) {
                        try {
                            v6 = Class.forName("org.eclipse.aperi.repository.table.TStatTotals");
                        }
                        catch (ClassNotFoundException v7) {
                            throw new NoClassDefFoundError(v7.getMessage());
                        }
                        TraceLogger.exception((String)v6.getName(), (String)"aggregate", (Throwable)var5_8);
                    }
                    this.sqlError(var5_8);
                }
            }
            catch (Throwable var7_11) {
                var6_9 = null;
                LockManager.unLock((short)0, (String)"TOTALLER", (String)"TOTALLER");
                throw var7_11;
            }
lbl-1000:
            // 3 sources

            {
                var6_9 = null;
            }
            LockManager.unLock((short)0, (String)"TOTALLER", (String)"TOTALLER");
            this.getAgentsDown(var2_2);
        }
        var5_5 = var2_2;
        if (TraceLogger.enableTrace) {
            try {
                v8 = Class.forName("org.eclipse.aperi.repository.table.TStatTotals");
            }
            catch (ClassNotFoundException v9) {
                throw new NoClassDefFoundError(v9.getMessage());
            }
            TraceLogger.exit((String)v8.getName(), (String)"aggregate", (Object)var5_5);
        }
        return var5_5;
    }

    private void updateDiskCapacity(DashTotalsRow dashTotalsRow, int n, long l) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatTotals");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateDiskCapacity", (String)"node, osType, capacity");
        }
        while (dashTotalsRow != null) {
            if (dashTotalsRow.dtrStatisticType == 5 && dashTotalsRow.dtrComputerType == n) {
                dashTotalsRow.dtrDiskCapacity = l;
                break;
            }
            dashTotalsRow = dashTotalsRow.dtrNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatTotals");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateDiskCapacity");
        }
    }

    private void insert(DashTotalsRow dashTotalsRow) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatTotals");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insert", (String)"totalsRow");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setShort(this.insertStmt, dashTotalsRow.dtrStatisticType);
            this.setTimestamp(this.insertStmt, dashTotalsRow.dtrUpdateTime);
            this.setLong(this.insertStmt, dashTotalsRow.dtrFilesystemCapacity);
            this.setLong(this.insertStmt, dashTotalsRow.dtrUsedSpace);
            this.setLong(this.insertStmt, dashTotalsRow.dtrFreeSpace);
            this.setLong(this.insertStmt, dashTotalsRow.dtrDiskCapacity);
            this.setLong(this.insertStmt, dashTotalsRow.dtrDiskUnallocated);
            this.setInt(this.insertStmt, dashTotalsRow.dtrTotalDirectories);
            this.setInt(this.insertStmt, dashTotalsRow.dtrTotalFiles);
            this.setInt(this.insertStmt, dashTotalsRow.dtrTotalFilesystems);
            this.setInt(this.insertStmt, dashTotalsRow.dtrTotalAgents);
            this.setInt(this.insertStmt, dashTotalsRow.dtrTotalComputers);
            this.setInt(this.insertStmt, dashTotalsRow.dtrTotalUsers);
            this.setInt(this.insertStmt, dashTotalsRow.dtrTotalDisks);
            this.setInt(this.insertStmt, dashTotalsRow.dtrAllAlerts);
            this.setInt(this.insertStmt, dashTotalsRow.dtrComputerAlerts);
            this.setInt(this.insertStmt, dashTotalsRow.dtrHardDiskAlerts);
            this.setInt(this.insertStmt, dashTotalsRow.dtrFilesystemAlerts);
            this.setInt(this.insertStmt, dashTotalsRow.dtrDirectoryAlerts);
            this.setInt(this.insertStmt, dashTotalsRow.dtrUserQuotaAlerts);
            this.setInt(this.insertStmt, dashTotalsRow.dtrGroupQuotaAlerts);
            this.setInt(this.insertStmt, dashTotalsRow.dtrUserAlerts);
            this.setShort(this.insertStmt, dashTotalsRow.dtrComputerType);
            this.setString(this.insertStmt, dashTotalsRow.dtrUserName);
            this.setString(this.insertStmt, dashTotalsRow.dtrFilesystemName);
            this.setInt(this.insertStmt, dashTotalsRow.dtrTotalStorageSubsystems);
            this.setInt(this.insertStmt, dashTotalsRow.dtrTotalLUNs);
            this.setLong(this.insertStmt, dashTotalsRow.dtrLunCapacity);
            this.setLong(this.insertStmt, dashTotalsRow.dtrUsableLunCap);
            this.setInt(this.insertStmt, dashTotalsRow.dtrStorageSubsystemAlerts);
            this.setInt(this.insertStmt, dashTotalsRow.dtrSwitchAlerts);
            this.setInt(this.insertStmt, dashTotalsRow.dtrFabricAlerts);
            this.setInt(this.insertStmt, dashTotalsRow.dtrEndpointDeviceAlerts);
            this.setInt(this.insertStmt, dashTotalsRow.dtrTapeLibraryAlerts);
            this.setInt(this.insertStmt, dashTotalsRow.dtrExternalAlerts);
            this.executeUpdate(this.insertStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatTotals");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insert", (Throwable)sQLException);
            }
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatTotals");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insert");
        }
    }

    public DashTotalsRow select(String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatTotals");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"select", (String)"userID");
        }
        int n = 0;
        DashTotalsRow dashTotalsRow = null;
        DashTotalsRow dashTotalsRow2 = null;
        try {
            this.staticStmt = this.createStatement();
            this.resultSet = this.staticStmt.executeQuery(SELECT);
            while (this.nextResult()) {
                this.getPhase();
                short s = this.getShort(this.resultSet);
                String string2 = this.getString(this.resultSet);
                int n2 = this.getInt(this.resultSet);
                if (s == 2) {
                    if (string2 != string) continue;
                    n = n2;
                    continue;
                }
                DashTotalsRow dashTotalsRow3 = new DashTotalsRow();
                dashTotalsRow3.dtrStatisticType = s;
                dashTotalsRow3.dtrUserName = string2;
                dashTotalsRow3.dtrFilesystemName = this.getString(this.resultSet);
                dashTotalsRow3.dtrUsedSpace = this.getLong(this.resultSet);
                dashTotalsRow3.dtrFilesystemCapacity = this.getLong(this.resultSet);
                dashTotalsRow3.dtrFreeSpace = this.getLong(this.resultSet);
                dashTotalsRow3.dtrComputerType = this.getShort(this.resultSet);
                dashTotalsRow3.dtrTotalComputers = this.getInt(this.resultSet);
                dashTotalsRow3.dtrDiskCapacity = this.getLong(this.resultSet);
                if (s != 1) {
                    dashTotalsRow3.dtrNext = dashTotalsRow2;
                    dashTotalsRow2 = dashTotalsRow3;
                    continue;
                }
                dashTotalsRow = dashTotalsRow3;
                dashTotalsRow.dtrUpdateTime = this.getTimestamp(this.resultSet);
                dashTotalsRow.dtrDiskUnallocated = this.getLong(this.resultSet);
                dashTotalsRow.dtrTotalDirectories = this.getInt(this.resultSet);
                dashTotalsRow.dtrTotalFiles = this.getInt(this.resultSet);
                dashTotalsRow.dtrTotalFilesystems = this.getInt(this.resultSet);
                dashTotalsRow.dtrTotalAgents = this.getInt(this.resultSet);
                dashTotalsRow.dtrTotalUsers = this.getInt(this.resultSet);
                dashTotalsRow.dtrTotalDisks = this.getInt(this.resultSet);
                dashTotalsRow.dtrAllAlerts = this.getInt(this.resultSet);
                dashTotalsRow.dtrComputerAlerts = this.getInt(this.resultSet);
                dashTotalsRow.dtrHardDiskAlerts = this.getInt(this.resultSet);
                dashTotalsRow.dtrFilesystemAlerts = this.getInt(this.resultSet);
                dashTotalsRow.dtrDirectoryAlerts = this.getInt(this.resultSet);
                dashTotalsRow.dtrUserQuotaAlerts = this.getInt(this.resultSet);
                dashTotalsRow.dtrGroupQuotaAlerts = this.getInt(this.resultSet);
                dashTotalsRow.dtrTotalStorageSubsystems = this.getInt(this.resultSet);
                dashTotalsRow.dtrTotalLUNs = this.getInt(this.resultSet);
                dashTotalsRow.dtrLunCapacity = this.getLong(this.resultSet);
                dashTotalsRow.dtrUsableLunCap = this.getLong(this.resultSet);
                dashTotalsRow.dtrStorageSubsystemAlerts = this.getInt(this.resultSet);
                dashTotalsRow.dtrSwitchAlerts = this.getInt(this.resultSet);
                dashTotalsRow.dtrFabricAlerts = this.getInt(this.resultSet);
                dashTotalsRow.dtrEndpointDeviceAlerts = this.getInt(this.resultSet);
                dashTotalsRow.dtrTapeLibraryAlerts = this.getInt(this.resultSet);
                dashTotalsRow.dtrExternalAlerts = this.getInt(this.resultSet);
            }
            this.closeStaticStmt();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatTotals");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"select", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (dashTotalsRow != null) {
            dashTotalsRow.dtrNext = dashTotalsRow2;
            dashTotalsRow.dtrUserAlerts = n;
            this.decomTemp = this.getDecommAgentCount();
            if (this.decomTemp > 0) {
                dashTotalsRow.dtrTotalAgents = this.agentCount == dashTotalsRow.dtrTotalAgents ? (dashTotalsRow.dtrTotalAgents -= this.decomTemp) : this.agentCount - this.decomTemp;
            }
            this.getAgentsDown(dashTotalsRow);
        }
        DashTotalsRow dashTotalsRow4 = dashTotalsRow;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatTotals");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"select", dashTotalsRow4);
        }
        return dashTotalsRow4;
    }

    private void getAgentsDown(DashTotalsRow dashTotalsRow) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatTotals");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getAgentsDown", (String)"totalsRow");
        }
        dashTotalsRow.dtrTotalAgentsDown = 0;
        Iterator iterator = Server.agentMgr.listAgents();
        while (iterator.hasNext()) {
            AgentManager.AgentAddress agentAddress = (AgentManager.AgentAddress)iterator.next();
            if (agentAddress.computerID <= 0 || agentAddress.state != 0 && agentAddress.state != 2 && (agentAddress.state != 1 || agentAddress.consecutiveErrors <= 0)) continue;
            ++dashTotalsRow.dtrTotalAgentsDown;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatTotals");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getAgentsDown");
        }
    }

    public int getDecommAgentCount() {
        block12: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatTotals");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"getDecommAgentCount", (String)"");
            }
            try {
                this.staticStmt = this.createStatement();
                this.resultSet = this.staticStmt.executeQuery(DECOMMSELECT);
                while (this.nextResult()) {
                    this.getPhase();
                    String string = this.getString(this.resultSet);
                    String string2 = this.getString(this.resultSet);
                    String string3 = this.getString(this.resultSet);
                    int n = this.getInt(this.resultSet);
                    if (string.startsWith("DECOMM-") && string2.startsWith("DECOMM-") && string3.startsWith("DECOMM-")) {
                        ++this.deComAgents;
                    }
                    if (n > 7) continue;
                    ++this.agentCount;
                }
            }
            catch (SQLException sQLException) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) break block12;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatTotals");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getDecommAgentCount", (Throwable)sQLException);
            }
            catch (GeneralException generalException) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) break block12;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatTotals");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getDecommAgentCount", (Throwable)generalException);
            }
        }
        return this.deComAgents;
    }
}

