/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.Service;
import org.eclipse.aperi.server.ServiceProvider;
import org.eclipse.aperi.server.ServiceQueue;
import org.eclipse.aperi.server.ServiceRequest;
import org.eclipse.aperi.server.VMJobResults;
import org.eclipse.aperi.server.VMTransceiver;
import org.eclipse.aperi.server.handler.scheduler.JobHndlr;
import org.eclipse.aperi.util.extensions.AbstractExtensionMgr;
import org.eclipse.aperi.util.extensions.ExtensionException;
import org.eclipse.aperi.util.osgi.IDisposable;
import org.eclipse.aperi.xmsg.MessageLog;

public class ServiceManager
implements IDisposable {
    private static final String CLASSNAME;
    private ServiceExtensionManager extensionManager;
    private Map<String, Service> serviceCache;
    private ReadWriteLock cacheLock;
    private boolean isInitialized;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.server.ServiceManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CLASSNAME = clazz.getName();
    }

    public ServiceManager() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"ServiceManager", (String)"");
        }
        this.extensionManager = new ServiceExtensionManager();
        this.serviceCache = new HashMap<String, Service>();
        this.cacheLock = new ReentrantReadWriteLock(true);
        this.isInitialized = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"ServiceManager");
        }
    }

    public synchronized boolean initialize() {
        String[] stringArray;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"initialize", (String)"");
        }
        if ((stringArray = this.extensionManager.getAllExtensionIds()) != null) {
            int n = 0;
            while (n < stringArray.length) {
                block6: {
                    try {
                        this.addService(stringArray[n]);
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block6;
                        TraceLogger.exception((String)CLASSNAME, (String)"initialize", (Throwable)exception);
                    }
                }
                ++n;
            }
        }
        this.isInitialized = true;
        this.notifyAll();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"initialize", (boolean)this.isInitialized);
        }
        return this.isInitialized;
    }

    public synchronized void awaitInitialization() {
        while (!this.isInitialized) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
    }

    public void dispose() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"dispose", (String)"");
        }
        this.terminate((byte)1);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"dispose");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void terminate(byte by) {
        int n;
        Service[] serviceArray;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"terminate", (String)"stopOption");
        }
        this.extensionManager.dispose();
        this.cacheLock.writeLock().lock();
        try {
            serviceArray = this.serviceCache.values().toArray(new Service[0]);
            this.serviceCache.clear();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.cacheLock.writeLock().unlock();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.cacheLock.writeLock().unlock();
            n = 0;
        }
        while (true) {
            if (n >= serviceArray.length) {
                this.isInitialized = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)CLASSNAME, (String)"terminate");
                }
                return;
            }
            this.stopService(serviceArray[n], by);
            ++n;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addService(String string) throws Exception {
        block7: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)CLASSNAME, (String)"addService", (String)"serviceProvider");
            }
            Service service = null;
            ServiceProvider serviceProvider = null;
            this.cacheLock.writeLock().lock();
            try {
                if (this.serviceCache.containsKey(string)) {
                    throw new GeneralException("Failed to register service. Service ID " + string + " is not available.");
                }
                serviceProvider = (ServiceProvider)this.extensionManager.getExtensionImpl(string);
                if (serviceProvider != null) {
                    String string2 = RequestTypeManager.getInternalName((String)string);
                    service = new Service(string, string2, serviceProvider.getClass());
                    this.serviceCache.put(string, service);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.cacheLock.writeLock().unlock();
                throw throwable;
            }
            {
                Object var5_7 = null;
                this.cacheLock.writeLock().unlock();
                if (service == null || this.startService(service, serviceProvider) || !TraceLogger.enableTrace) break block7;
            }
            TraceLogger.traceMessage((int)1, (String)CLASSNAME, (String)"addService", (String)("Failed to start service (" + service.serviceClass.getName() + ")."));
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"addService");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeService(String string) throws Exception {
        block5: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)CLASSNAME, (String)"removeService", (String)"serviceProvider");
            }
            Service service = null;
            this.cacheLock.writeLock().lock();
            try {
                service = this.serviceCache.remove(string);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.cacheLock.writeLock().unlock();
                throw throwable;
            }
            {
                Object var3_5 = null;
                this.cacheLock.writeLock().unlock();
                if (service == null) break block5;
                this.stopService(service, (byte)1);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"removeService");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean startService(String string) {
        boolean bl;
        block5: {
            Service service;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)CLASSNAME, (String)"startService", (String)"typeCode");
            }
            bl = false;
            this.cacheLock.readLock().lock();
            try {
                service = this.serviceCache.get(string);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.cacheLock.readLock().unlock();
                throw throwable;
            }
            {
                Object var4_6 = null;
                this.cacheLock.readLock().unlock();
                if (service != null) {
                    bl = this.startService(service, null);
                }
                if (!TraceLogger.enableTrace) break block5;
            }
            TraceLogger.exit((String)CLASSNAME, (String)"startService", (boolean)bl);
        }
        return bl;
    }

    public boolean startService(Service service) {
        return this.startService(service, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean startService(Service service, ServiceProvider serviceProvider) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"startService", (String)"s");
        }
        boolean bl = true;
        Service service2 = service;
        synchronized (service2) {
            PrintWriter printWriter = MessageLog.getThreadLog();
            String string = TSThread.getServiceID();
            try {
                try {
                    if (service.instance == null) {
                        MessageLog.logMessage((String)"SRV0020I", (Object)service.serviceName);
                        service.instance = serviceProvider != null ? serviceProvider : (ServiceProvider)service.serviceClass.newInstance();
                        TSThread.setServiceID((String)service.instance.getTypeCode());
                        service.queue.setActive(true);
                        service.instance.startup(service.queue);
                        service.logWriter = MessageLog.getThreadLog();
                    }
                }
                catch (Exception exception) {
                    bl = false;
                    exception.printStackTrace();
                    MessageLog.logException((String)"SRV0018E", (Exception)exception, (Object)service.serviceClass.getName());
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)CLASSNAME, (String)"startService", (Throwable)exception);
                    }
                    service.instance = null;
                    service.queue.setActive(false);
                    this.drainQueue(service.queue);
                }
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                MessageLog.setThreadLog((PrintWriter)printWriter);
                TSThread.setServiceID((String)string);
                throw throwable;
            }
            MessageLog.setThreadLog((PrintWriter)printWriter);
            TSThread.setServiceID((String)string);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"startService", (boolean)bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean stopService(String string, byte by) {
        boolean bl;
        block5: {
            Service service;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)CLASSNAME, (String)"stopService", (String)"typeCode, stopOption");
            }
            bl = false;
            this.cacheLock.readLock().lock();
            try {
                service = this.serviceCache.get(string);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.cacheLock.readLock().unlock();
                throw throwable;
            }
            {
                Object var5_7 = null;
                this.cacheLock.readLock().unlock();
                if (service != null) {
                    bl = this.stopService(service, by);
                }
                if (!TraceLogger.enableTrace) break block5;
            }
            TraceLogger.exit((String)CLASSNAME, (String)"stopService", (boolean)bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean stopService(Service service, byte by) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"stopService", (String)"s, stopOption");
        }
        boolean bl = true;
        PrintWriter printWriter = MessageLog.getThreadLog();
        try {
            try {
                Service service2 = service;
                synchronized (service2) {
                    if (service.instance != null) {
                        MessageLog.logMessage((String)"SRV0021I", (Object)service.serviceName);
                        ServiceProvider serviceProvider = service.instance;
                        service.instance = null;
                        service.queue.setActive(false);
                        this.drainQueue(service.queue);
                        MessageLog.setThreadLog((PrintWriter)service.logWriter);
                        serviceProvider.shutdown(by);
                    }
                }
            }
            catch (Exception exception) {
                bl = false;
                exception.printStackTrace();
                MessageLog.logException((String)"SRV0019E", (Exception)exception, (Object)service.serviceClass.getName());
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)CLASSNAME, (String)"stopService", (Throwable)exception);
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            MessageLog.setThreadLog((PrintWriter)printWriter);
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        MessageLog.setThreadLog((PrintWriter)printWriter);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"stopService", (boolean)bl);
        }
        return bl;
    }

    private void drainQueue(ServiceQueue serviceQueue) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"drainQueue", (String)"queue");
        }
        ServiceRequest serviceRequest = (ServiceRequest)serviceQueue.getHead();
        while (serviceRequest != null) {
            try {
                VMTransceiver vMTransceiver = (VMTransceiver)serviceRequest.comm;
                VMJobResults vMJobResults = vMTransceiver.getJobData(serviceRequest.request);
                if (vMJobResults != null) {
                    JobRun jobRun = vMJobResults.getJobRun();
                    JobHndlr.removeFromJobTable(jobRun);
                }
            }
            catch (ClassCastException classCastException) {}
            serviceRequest.comm.close();
            serviceRequest.returnServiceRequest();
            serviceRequest = (ServiceRequest)serviceRequest.nextElement;
        }
        serviceQueue.empty();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"drainQueue");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Service getService(String string) {
        Service service;
        block4: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)CLASSNAME, (String)"getService", (String)"typeCode");
            }
            this.cacheLock.readLock().lock();
            try {
                service = this.serviceCache.get(string);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.cacheLock.readLock().unlock();
                throw throwable;
            }
            {
                Object var3_5 = null;
                this.cacheLock.readLock().unlock();
                if (!TraceLogger.enableTrace) break block4;
            }
            TraceLogger.exit((String)CLASSNAME, (String)"getService", (Object)service);
        }
        return service;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Service[] listServices() {
        Service[] serviceArray;
        block4: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)CLASSNAME, (String)"listServices", (String)"");
            }
            this.cacheLock.readLock().lock();
            try {
                serviceArray = this.serviceCache.values().toArray(new Service[0]);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.cacheLock.readLock().unlock();
                throw throwable;
            }
            {
                Object var2_4 = null;
                this.cacheLock.readLock().unlock();
                if (!TraceLogger.enableTrace) break block4;
            }
            TraceLogger.exit((String)CLASSNAME, (String)"listServices", Arrays.asList(serviceArray));
        }
        return serviceArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean routeRequest(Request request, Transceiver transceiver) {
        boolean bl;
        block7: {
            block6: {
                ServiceQueue serviceQueue;
                if (TraceLogger.enableTrace) {
                    TraceLogger.entry((String)CLASSNAME, (String)"routeRequest", (String)"request, comm");
                }
                bl = false;
                this.cacheLock.readLock().lock();
                try {
                    Service service = this.serviceCache.get(request.typeCode);
                    Object var5_7 = null;
                    this.cacheLock.readLock().unlock();
                    if (service == null) break block6;
                    serviceQueue = service.queue;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.cacheLock.readLock().unlock();
                    throw throwable;
                }
                bl = serviceQueue.add(ServiceRequest.getServiceRequest(request, transceiver), (request.flags & 1) != 0);
                if (!bl) {
                    ServiceManager.routingError(request, transceiver, "SRV0024E", (short)24);
                }
                break block7;
            }
            ServiceManager.routingError(request, transceiver, "SRV0023E");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"routeRequest", (boolean)bl);
        }
        return bl;
    }

    public static void routingError(Request request, Transceiver transceiver, String string) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"routingError", (String)"request, comm, msgID");
        }
        ServiceManager.routingError(request, transceiver, string, (short)12);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"routingError");
        }
    }

    public static void routingError(Request request, Transceiver transceiver, String string, short s) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"routingError", (String)"request, comm, msgID, status");
        }
        Response response = Response.getResponse((short)s, null);
        response.errorMessage = MessageLog.getMessage((String)string, null);
        transceiver.transmitResponse(request, response);
        transceiver.close();
        transceiver.returnTransceiver();
        response.returnResponse();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"routingError");
        }
    }

    private class ServiceExtensionManager
    extends AbstractExtensionMgr {
        private ServiceExtensionManager() {
        }

        public String getExtensionPointId() {
            return "org.eclipse.aperi.server.data.serviceProvider";
        }

        public Object getExtensionImpl(String string) throws ExtensionException {
            return super.getExtensionImpl(string, false);
        }

        public Object getExtensionImpl(String string, boolean bl) throws ExtensionException {
            throw new UnsupportedOperationException();
        }

        protected void extensionAdded(String string) {
            block4: {
                try {
                    ServiceManager.this.addService(string);
                }
                catch (Exception exception) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block4;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.ServiceManager$ServiceExtensionManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"extensionAdded", (Throwable)exception);
                }
            }
        }

        protected void extensionRemoved(String string) {
            block4: {
                try {
                    ServiceManager.this.removeService(string);
                }
                catch (Exception exception) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block4;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.ServiceManager$ServiceExtensionManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"extensionRemoved", (Throwable)exception);
                }
            }
        }
    }
}

