/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import org.eclipse.aperi.agent.req.RunReq;
import org.eclipse.aperi.backend.JobUtil;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.jobs.JobUtils;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.VMTransceiver;
import org.eclipse.aperi.xmsg.MessageLog;

public class VMJobResults
implements Serializable {
    static final long serialVersionUID = 8572900396994943117L;
    private StartedJob startedJob;
    private JobRun jobRun;
    private String logFileName;
    private PrintWriter myLogWriter;
    public PrintWriter jobLogWriter;
    private static final String homeDir = System.getProperty("user.dir");
    private static final String logDir = String.valueOf(homeDir) + File.separator + "log";

    public VMJobResults(JobRun jobRun) {
        this.jobRun = jobRun;
        this.startedJob = new StartedJob(jobRun);
        try {
            this.startedJob.setStarted(CurrentTime.getTimestamp().getTime());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.VMJobResults");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"VMJobResults", (Throwable)exception);
            }
            return;
        }
    }

    public JobRun getJobRun() {
        return this.jobRun;
    }

    public String setJobLog() {
        this.createJobLog();
        this.setThreadLog();
        return this.logFileName;
    }

    public String createJobLog() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMJobResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"createJobLog", (String)"");
        }
        if (homeDir == null) {
            MessageLog.logMessage((String)"GEN0126W");
            MessageLog.logMessage((String)"GEN0127W", (Object)this.jobRun.getSchedCreator(), (Object)this.jobRun.getSchedName());
            String string = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.VMJobResults");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"createJobLog", string);
            }
            return string;
        }
        this.logFileName = JobUtils.generateLogFileName((RunReq)this.jobRun, (String)logDir);
        this.makeJobLogWriter(false);
        this.startedJob.setLogFileName(this.logFileName);
        String string = this.logFileName;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMJobResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"createJobLog", (Object)string);
        }
        return string;
    }

    public void setThreadLog() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMJobResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setThreadLog", (String)"");
        }
        if (this.logFileName != null) {
            if (this.jobLogWriter == null) {
                this.makeJobLogWriter(true);
            }
            if (this.jobLogWriter != null) {
                this.myLogWriter = MessageLog.getThreadLog();
                MessageLog.setThreadLog((PrintWriter)this.jobLogWriter);
            }
            JobUtil.purgeLogFiles((RunReq)this.jobRun, (String)logDir);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMJobResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setThreadLog");
        }
    }

    public void restoreThreadLog() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMJobResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"restoreThreadLog", (String)"");
        }
        if (this.myLogWriter != null) {
            MessageLog.setThreadLog((PrintWriter)this.myLogWriter);
            this.myLogWriter = null;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMJobResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"restoreThreadLog");
        }
    }

    public Response jobCompleted(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMJobResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"jobCompleted", (String)"completionCode");
        }
        this.logFileName = null;
        if (this.startedJob.getLogFileName() == null) {
            this.startedJob.setLogFileName(" ");
        }
        this.closeJobLog();
        try {
            this.startedJob.setFinished(CurrentTime.getTimestamp().getTime());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.VMJobResults");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"jobCompleted", (Throwable)exception);
            }
            return null;
        }
        this.startedJob.setExitCode(n);
        this.startedJob.setJobStatus((byte)67);
        JobRun jobRun = this.startedJob.getJobRun();
        this.startedJob.setJobRun(null);
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.SchedulerSvp";
        request.subType = "org.eclipse.aperi.server.handler.scheduler.ScheduleHandler";
        request.serviceName = RequestTypeManager.getInternalName((String)request.typeCode);
        request.flags = (byte)2;
        VMTransceiver vMTransceiver = new VMTransceiver();
        Response response = vMTransceiver.transmitRequest(request, this.startedJob);
        vMTransceiver.close();
        if (response == null || response.status > 4) {
            MessageLog.logMessage((String)"GEN0105E", (Object)jobRun.getSchedName(), (Object)jobRun.getJobName(), (Object)new Integer(jobRun.getRunNumber()));
        }
        Response response2 = response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMJobResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"jobCompleted", (Object)response2);
        }
        return response2;
    }

    void closeJobLog() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMJobResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"closeJobLog", (String)"");
        }
        if (this.jobLogWriter != null) {
            this.jobLogWriter.close();
            this.jobLogWriter = null;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMJobResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"closeJobLog");
        }
    }

    public void logMessage(String string, Object[] objectArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMJobResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"logMessage", (String)"msgID, args");
        }
        if (this.jobLogWriter != null) {
            this.jobLogWriter.println(MessageLog.getMessage((String)string, (Object[])objectArray));
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMJobResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"logMessage");
        }
    }

    private void makeJobLogWriter(boolean bl) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMJobResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"makeJobLogWriter", (String)"append");
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.logFileName, bl);
        }
        catch (IOException iOException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.VMJobResults");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"makeJobLogWriter", (Throwable)iOException);
            }
            MessageLog.logException((String)"GEN0036E", (Exception)iOException);
            MessageLog.logMessage((String)"GEN0127W", (Object)this.jobRun.getSchedCreator(), (Object)this.jobRun.getSchedName());
            this.logFileName = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.VMJobResults");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"makeJobLogWriter");
            }
            return;
        }
        this.jobLogWriter = new PrintWriter(fileOutputStream, true);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMJobResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"makeJobLogWriter");
        }
    }
}

