/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.disk;

import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.gui.common.model.GUIRequestData;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.handler.gui.disk.GUIEntityFactory;

public class FabricInfoHandler
implements RequestHandler,
ThrowAway {
    GUIEntityFactory entityFactory = null;

    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.FabricInfoHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"handle", (String)"request, transceiver");
        }
        GUIRequestData gUIRequestData = (GUIRequestData)request.requestData;
        Response response = Response.getResponse((short)0, null);
        this.entityFactory = GUIEntityFactory.getInstance();
        try {
            if (gUIRequestData.getActionId() == 71) {
                this.getFabrics(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 72) {
                this.getActiveZoneSet(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 73) {
                this.getZones(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 74) {
                this.getPortsByZone(gUIRequestData, response);
            }
        }
        catch (Exception exception) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.FabricInfoHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"handle", (Throwable)exception);
            }
            response.status = (short)12;
            if (exception instanceof SRMRuntimeException) {
                response.errorMessage = ((SRMRuntimeException)exception).getLocalizedMessage();
            } else {
                String[] stringArray = new String[]{};
                String string = exception.getMessage();
                if (string != null) {
                    stringArray = new String[]{string};
                }
                response.errorMessage = new SRMMessage("HWN021503E", stringArray).getLocalizedMessage();
            }
            response.responseData = null;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.FabricInfoHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handle", (Object)response);
        }
        return response;
    }

    private void getFabrics(GUIRequestData gUIRequestData, Response response) throws Exception {
        response.responseData = this.entityFactory.getFabrics();
    }

    private void getActiveZoneSet(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("fabric.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.FabricInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getActiveZoneSet", (String)("fabricId: " + string));
        response.responseData = this.entityFactory.getActiveZoneSet(string);
    }

    private void getZones(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        String string = (String)((Object)gUIRequestData.getParameter("fabric.id"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.disk.FabricInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"getZones", (String)("fabricId: " + string));
        String string2 = (String)((Object)gUIRequestData.getParameter("zoneset.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.FabricInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getZones", (String)("zoneSetId: " + string2));
        response.responseData = this.entityFactory.getZones(string, string2);
    }

    private void getPortsByZone(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        String string = (String)((Object)gUIRequestData.getParameter("fabric.id"));
        try {
            clazz3 = Class.forName("org.eclipse.aperi.server.handler.gui.disk.FabricInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz3.getName(), (String)"getPortsByZone", (String)("fabricId: " + string));
        String string2 = (String)((Object)gUIRequestData.getParameter("zoneset.id"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.disk.FabricInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"getPortsByZone", (String)("zoneSetId: " + string2));
        String string3 = (String)((Object)gUIRequestData.getParameter("zone.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.FabricInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getPortsByZone", (String)("zoneId: " + string3));
        response.responseData = this.entityFactory.getPortsByZone(string, string2, string3);
    }
}

