/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.scheduler;

import java.util.HashMap;
import java.util.Vector;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.IJobMgmtService;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.disk.api.IDiskManagerService;
import org.eclipse.aperi.disk.api.VolumeID;
import org.eclipse.aperi.gui.common.model.GUIRequestData;
import org.eclipse.aperi.gui.disk.common.model.DiskDataControllerConstants;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr;

public class SubsystemActionHandler
extends DeviceJobHndlr {
    private IDiskManagerService dmService = null;
    private String userName = null;
    private IJobMgmtService jobService = null;

    public int deviceAPI(DeviceRequest deviceRequest, Response response) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deviceAPI", (String)"request, response");
        }
        GUIRequestData gUIRequestData = (GUIRequestData)deviceRequest.requestData;
        this.userName = deviceRequest.userName;
        int n = DiskDataControllerConstants.INVALID_JOBID;
        try {
            Class<?> clazz;
            Class<?> clazz2;
            DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
            try {
                clazz2 = Class.forName("org.eclipse.aperi.disk.api.IDiskManagerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.dmService = (IDiskManagerService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz2, (String)"DiskManagerService");
            try {
                clazz = Class.forName("org.eclipse.aperi.common.api.IJobMgmtService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.jobService = (IJobMgmtService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"FabricManagerService");
            AsyncResult asyncResult = null;
            if (gUIRequestData.getActionId() == 0) {
                asyncResult = this.createVolumes(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 6) {
                asyncResult = this.createVolumesExt(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 1) {
                asyncResult = this.createVDisks(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 2) {
                asyncResult = this.addMDisks(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 3) {
                asyncResult = this.deleteVolumes(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 4) {
                asyncResult = this.assignPorts(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 5) {
                asyncResult = this.unassignPorts(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 7) {
                asyncResult = this.createVolumesAndAssignPorts(gUIRequestData, deviceRequest, response);
            } else if (gUIRequestData.getActionId() == 8) {
                asyncResult = this.createVolumesExtAndAssignPorts(gUIRequestData, deviceRequest, response);
            } else if (gUIRequestData.getActionId() == 9) {
                asyncResult = this.createVDisksAndAssignPorts(gUIRequestData, deviceRequest, response);
            }
            if (asyncResult != null) {
                if (asyncResult.getReturnException() != null) {
                    throw asyncResult.getReturnException();
                }
                n = Integer.parseInt(asyncResult.getJobId());
                if (n >= 1 && !gUIRequestData.isWillWaitForComplete()) {
                    deviceRequest.deviceRunNbr = n;
                    DeviceJobHndlr.setDeviceJobID(deviceRequest);
                    new JobResultThread(n, response).start();
                }
            }
        }
        catch (Exception exception) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deviceAPI", (Throwable)exception);
            }
            response.status = (short)12;
            if (exception instanceof SRMRuntimeException) {
                response.errorMessage = ((SRMRuntimeException)exception).getLocalizedMessage();
            } else {
                String[] stringArray = new String[]{};
                String string = exception.getMessage();
                if (string != null) {
                    stringArray = new String[]{string};
                }
                response.errorMessage = new SRMMessage("HWN021503E", stringArray).getLocalizedMessage();
            }
            response.responseData = null;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deviceAPI", (int)n);
        }
        return n;
    }

    private AsyncResult createVolumes(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Long l = (Long)gUIRequestData.getParameter("volume.size");
        try {
            clazz3 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz3.getName(), (String)"createVolumes", (String)("volSize: " + l));
        StringBuffer stringBuffer = new StringBuffer("Username = " + this.userName);
        stringBuffer.append("\n Create Volumes ");
        String string = (String)((Object)gUIRequestData.getParameter("storagepool.id"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"createVolumes", (String)("stgpoolId: " + string));
        Long l2 = (Long)gUIRequestData.getParameter("num.of.volumes");
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"createVolumes", (String)("numVols: " + l2));
        stringBuffer.append("\n Number of volume(s) = ");
        stringBuffer.append(l2);
        String[] stringArray = (String[])gUIRequestData.getParameter("volume.names");
        if (stringArray != null) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.traceMessage((int)1, (String)clazz4.getName(), (String)"createVolumes", (String)("volNames: " + String.valueOf(stringArray)));
        }
        long[] lArray = new long[l2.intValue()];
        stringBuffer.append("\n Size of volume(s) = ");
        stringBuffer.append(String.valueOf(l));
        if (TraceLogger.enableAudit) {
            Class<?> clazz5;
            try {
                clazz5 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.auditMessage((String)clazz5.getName(), (String)"createVolumes()", (String)String.valueOf(stringBuffer));
        }
        String[] stringArray2 = new String[l2.intValue()];
        int n = 0;
        while (n < l2.intValue()) {
            lArray[n] = l;
            stringArray2[n] = string;
            ++n;
        }
        return this.dmService.createStorageVolumes(lArray, stringArray2, stringArray, null);
    }

    private AsyncResult createVolumesExt(GUIRequestData gUIRequestData, Response response) throws Exception {
        HashMap hashMap;
        Class<?> clazz;
        Class<?> clazz2;
        long[] lArray = (long[])gUIRequestData.getParameter("volume.sizes");
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"createVolumesExt", (String)("volSizes: " + String.valueOf(lArray)));
        StringBuffer stringBuffer = new StringBuffer("Username = " + this.userName);
        stringBuffer.append("\n Create Volume Extent ");
        String[] stringArray = (String[])gUIRequestData.getParameter("storagepool.ids");
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"createVolumesExt", (String)("stgpoolIds: " + String.valueOf(stringArray)));
        String[] stringArray2 = (String[])gUIRequestData.getParameter("volume.names");
        if (stringArray2 != null) {
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.traceMessage((int)1, (String)clazz3.getName(), (String)"createVolumesExt", (String)("volNames: " + String.valueOf(stringArray2)));
            stringBuffer.append("\n volume names = ");
            int n = 0;
            while (n < stringArray2.length) {
                stringBuffer.append(stringArray2[n]);
                stringBuffer.append(" ");
                ++n;
            }
            stringBuffer.append("\n");
        }
        if (TraceLogger.enableAudit) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.auditMessage((String)clazz4.getName(), (String)"createVolumesExt()", (String)String.valueOf(stringBuffer));
        }
        if ((hashMap = (HashMap)gUIRequestData.getParameter("volume.crgoal")) != null) {
            Class<?> clazz5;
            try {
                clazz5 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.traceMessage((int)1, (String)clazz5.getName(), (String)"createVolumesExt", (String)("goal: " + hashMap));
        }
        return this.dmService.createStorageVolumes(lArray, stringArray, stringArray2, hashMap);
    }

    private AsyncResult createVDisks(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        Class<?> clazz7;
        Class<?> clazz8;
        StringBuffer stringBuffer = new StringBuffer("Username = " + this.userName);
        stringBuffer.append("\n Create VDisks");
        Long l = (Long)gUIRequestData.getParameter("vdisk.size");
        try {
            clazz8 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz8.getName(), (String)"createVDisks", (String)("vdiskSize: " + l));
        String string = (String)((Object)gUIRequestData.getParameter("mdiskgroup.id"));
        try {
            clazz7 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz7.getName(), (String)"createVDisks", (String)("mdiskGroupId: " + string));
        String[] stringArray = (String[])gUIRequestData.getParameter("vdisk.names");
        try {
            clazz6 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz6.getName(), (String)"createVDisks", (String)("vdiskNames: " + stringArray));
        Boolean bl = (Boolean)gUIRequestData.getParameter("vdisk.format.oncreate");
        try {
            clazz5 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz5.getName(), (String)"createVDisks", (String)("formatOnCreate: " + bl));
        Integer n = (Integer)gUIRequestData.getParameter("vdisk.type");
        try {
            clazz4 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz4.getName(), (String)"createVDisks", (String)("vdiskType: " + n));
        Integer n2 = (Integer)gUIRequestData.getParameter("iogroup.id");
        try {
            clazz3 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz3.getName(), (String)"createVDisks", (String)("ioGroupId: " + n2));
        String[] stringArray2 = (String[])gUIRequestData.getParameter("mdisk.ids");
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"createVDisks", (String)("mdiskIds: " + stringArray2));
        Integer n3 = (Integer)gUIRequestData.getParameter("num.of.vdisks");
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"createVDisks", (String)("numOfVDisks: " + n3));
        long[] lArray = new long[n3.intValue()];
        String[] stringArray3 = new String[n3.intValue()];
        int n4 = 0;
        while (n4 < n3) {
            lArray[n4] = l;
            stringArray3[n4] = string;
            ++n4;
        }
        stringBuffer.append("\n Number of vdisks = ");
        stringBuffer.append(n3);
        stringBuffer.append("\n Size = ");
        stringBuffer.append(l);
        if (TraceLogger.enableAudit) {
            Class<?> clazz9;
            try {
                clazz9 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.auditMessage((String)clazz9.getName(), (String)"createVDisks()", (String)stringBuffer.toString());
        }
        return this.dmService.createSVCVDisks(lArray, stringArray3, stringArray, bl.booleanValue(), n.intValue(), n2.intValue(), stringArray2);
    }

    private AsyncResult addMDisks(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        StringBuffer stringBuffer = new StringBuffer("Username = " + this.userName);
        stringBuffer.append("\n Add Mdisks");
        String string = (String)((Object)gUIRequestData.getParameter("mdiskgroup.id"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"addMDisks", (String)("mdiskGroupId: " + string));
        String[] stringArray = (String[])gUIRequestData.getParameter("mdisk.ids");
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"addMDisks", (String)("mdiskIds: " + String.valueOf(stringArray)));
        stringBuffer.append("\n mdisk Group ID = ");
        stringBuffer.append(string);
        stringBuffer.append("\n mdisk ID(s) = ");
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                stringBuffer.append(" ");
                ++n;
            }
        }
        stringBuffer.append("\n");
        if (TraceLogger.enableAudit) {
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.auditMessage((String)clazz3.getName(), (String)"addMDisks()", (String)stringBuffer.toString());
        }
        return this.dmService.modifyStoragePoolSize(string, stringArray, null);
    }

    private AsyncResult deleteVolumes(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        StringBuffer stringBuffer = new StringBuffer("Username = " + this.userName);
        stringBuffer.append("\n Delete Volumes");
        String[] stringArray = (String[])gUIRequestData.getParameter("volume.ids");
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"deleteVolumes", (String)("volumeIds: " + String.valueOf(stringArray)));
        stringBuffer.append("Volume ID(s) = ");
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                stringBuffer.append(" ");
                ++n;
            }
            stringBuffer.append("\n");
        }
        if (TraceLogger.enableAudit) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.auditMessage((String)clazz2.getName(), (String)"deleteVolumes()", (String)stringBuffer.toString());
        }
        return this.dmService.deleteStorageVolumes(stringArray);
    }

    private AsyncResult assignPorts(GUIRequestData gUIRequestData, Response response) throws Exception {
        int n;
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        StringBuffer stringBuffer = new StringBuffer("Username = " + this.userName);
        stringBuffer.append("\n Assign Ports");
        String[] stringArray = (String[])gUIRequestData.getParameter("volume.ids");
        try {
            clazz6 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz6.getName(), (String)"assignPorts", (String)("volumeIds: " + String.valueOf(stringArray)));
        String[] stringArray2 = (String[])gUIRequestData.getParameter("system.ports");
        try {
            clazz5 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz5.getName(), (String)"assignPorts", (String)("systemPortWwpns: " + String.valueOf(stringArray2)));
        String[] stringArray3 = (String[])gUIRequestData.getParameter("host.ports");
        try {
            clazz4 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz4.getName(), (String)"assignPorts", (String)("hostPortWwpns: " + String.valueOf(stringArray3)));
        Integer n2 = (Integer)gUIRequestData.getParameter("host.type");
        try {
            clazz3 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz3.getName(), (String)"assignPorts", (String)("hosttype: " + n2));
        String string = (String)((Object)gUIRequestData.getParameter("host.type_desc"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"assignPorts", (String)("hosttype description: " + string));
        String[] stringArray4 = (String[])gUIRequestData.getParameter("host.names");
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"assignPorts", (String)("hostNames: " + String.valueOf(stringArray4)));
        stringBuffer.append("\nVolume ID(s) = ");
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                stringBuffer.append(" ");
                ++n;
            }
        }
        stringBuffer.append("\nSubsystem port WWN(s) = ");
        if (stringArray2 != null) {
            n = 0;
            while (n < stringArray2.length) {
                stringBuffer.append(stringArray2[n]);
                stringBuffer.append(" ");
                ++n;
            }
        }
        stringBuffer.append("\n Host port WWN(s) = ");
        if (stringArray3 != null) {
            n = 0;
            while (n < stringArray3.length) {
                stringBuffer.append(stringArray3[n]);
                stringBuffer.append(" ");
                ++n;
            }
        }
        stringBuffer.append("\n Host Type = ");
        if (n2 != null) {
            stringBuffer.append(n2);
            stringBuffer.append(" ");
        }
        stringBuffer.append("\n Host Type Desc = ");
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        stringBuffer.append("\n Host Names = ");
        if (stringArray4 != null) {
            n = 0;
            while (n < stringArray4.length) {
                stringBuffer.append(stringArray4[n]);
                stringBuffer.append(" ");
                ++n;
            }
        }
        stringBuffer.append("\n");
        if (TraceLogger.enableAudit) {
            Class<?> clazz7;
            try {
                clazz7 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.auditMessage((String)clazz7.getName(), (String)"assignPorts()", (String)stringBuffer.toString());
        }
        return this.dmService.assignStorageVolumesToWWPNs(stringArray, stringArray2, null, stringArray3, n2.intValue(), string, stringArray4, null, true);
    }

    private AsyncResult createVolumesAndAssignPorts(GUIRequestData gUIRequestData, DeviceRequest deviceRequest, Response response) throws Exception {
        int n;
        AsyncResult asyncResult;
        int n2;
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        Class<?> clazz7;
        Class<?> clazz8;
        StringBuffer stringBuffer = new StringBuffer("Username = " + this.userName);
        stringBuffer.append("\n Create Volume and Assign Port");
        Long l = (Long)gUIRequestData.getParameter("volume.size");
        try {
            clazz8 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz8.getName(), (String)"createVolumes", (String)("volSize: " + l));
        String string = (String)((Object)gUIRequestData.getParameter("storagepool.id"));
        try {
            clazz7 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz7.getName(), (String)"createVolumes", (String)("stgpoolId: " + string));
        Long l2 = (Long)gUIRequestData.getParameter("num.of.volumes");
        try {
            clazz6 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz6.getName(), (String)"createVolumes", (String)("numVols: " + l2));
        String[] stringArray = (String[])gUIRequestData.getParameter("volume.names");
        if (stringArray != null) {
            Class<?> clazz9;
            try {
                clazz9 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.traceMessage((int)1, (String)clazz9.getName(), (String)"createVolumes", (String)("volNames: " + String.valueOf(stringArray)));
        }
        long[] lArray = new long[l2.intValue()];
        String[] stringArray2 = new String[l2.intValue()];
        int n3 = 0;
        while (n3 < l2.intValue()) {
            lArray[n3] = l;
            stringArray2[n3] = string;
            ++n3;
        }
        stringBuffer.append("\n Number of volume(s) = ");
        stringBuffer.append(l2);
        stringBuffer.append("\n Volume size(s) = ");
        stringBuffer.append(l);
        String[] stringArray3 = (String[])gUIRequestData.getParameter("system.ports");
        try {
            clazz5 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz5.getName(), (String)"assignPorts", (String)("systemPortWwpns: " + String.valueOf(stringArray3)));
        String[] stringArray4 = (String[])gUIRequestData.getParameter("host.ports");
        try {
            clazz4 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz4.getName(), (String)"assignPorts", (String)("hostPortWwpns: " + String.valueOf(stringArray4)));
        Integer n4 = (Integer)gUIRequestData.getParameter("host.type");
        try {
            clazz3 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz3.getName(), (String)"assignPorts", (String)("hosttype: " + n4));
        String string2 = (String)((Object)gUIRequestData.getParameter("host.type_desc"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"assignPorts", (String)("hosttype description: " + string2));
        String[] stringArray5 = (String[])gUIRequestData.getParameter("host.names");
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"assignPorts", (String)("hostNames: " + String.valueOf(stringArray5)));
        stringBuffer.append("\n Subsystem port WWN(s) = ");
        if (stringArray3 != null) {
            n2 = 0;
            while (n2 < stringArray3.length) {
                stringBuffer.append(stringArray3[n2]);
                stringBuffer.append(" ");
                ++n2;
            }
        }
        stringBuffer.append("\n Host port WWN(s) = ");
        if (stringArray4 != null) {
            n2 = 0;
            while (n2 < stringArray4.length) {
                stringBuffer.append(stringArray4[n2]);
                stringBuffer.append(" ");
                ++n2;
            }
        }
        stringBuffer.append("\n Host Type = ");
        if (n4 != null) {
            stringBuffer.append(n4);
            stringBuffer.append(" ");
        }
        stringBuffer.append("\n Host Type Desc = ");
        if (string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append(" ");
        }
        stringBuffer.append("\n Host Names = ");
        if (stringArray4 != null) {
            n2 = 0;
            while (n2 < stringArray5.length) {
                stringBuffer.append(stringArray5[n2]);
                stringBuffer.append(" ");
                ++n2;
            }
        }
        stringBuffer.append("\n");
        if (TraceLogger.enableAudit) {
            Class<?> clazz10;
            try {
                clazz10 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.auditMessage((String)clazz10.getName(), (String)"createVolumesAndAssignPorts()", (String)stringBuffer.toString());
        }
        if ((asyncResult = this.dmService.createStorageVolumes(lArray, stringArray2, stringArray, null)) != null && asyncResult.getReturnException() == null && (n = Integer.parseInt(asyncResult.getJobId())) >= 1) {
            deviceRequest.deviceRunNbr = n;
            DeviceJobHndlr.setDeviceJobID(deviceRequest);
            new PortAssignmentThread(n, response, deviceRequest, stringArray4, stringArray3, n4, string2, stringArray5).start();
        }
        return asyncResult;
    }

    private AsyncResult createVolumesExtAndAssignPorts(GUIRequestData gUIRequestData, DeviceRequest deviceRequest, Response response) throws Exception {
        int n;
        AsyncResult asyncResult;
        int n2;
        Class<?> clazz;
        Class<?> clazz2;
        HashMap hashMap;
        Class<?> clazz3;
        Class<?> clazz4;
        StringBuffer stringBuffer = new StringBuffer("Username = " + this.userName);
        stringBuffer.append("\n Create Volume Extent and Assign Ports");
        long[] lArray = (long[])gUIRequestData.getParameter("volume.sizes");
        try {
            clazz4 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz4.getName(), (String)"createVolumesExt", (String)("volSizes: " + String.valueOf(lArray)));
        String[] stringArray = (String[])gUIRequestData.getParameter("storagepool.ids");
        try {
            clazz3 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz3.getName(), (String)"createVolumesExt", (String)("stgpoolIds: " + String.valueOf(stringArray)));
        String[] stringArray2 = (String[])gUIRequestData.getParameter("volume.names");
        if (stringArray2 != null) {
            Class<?> clazz5;
            try {
                clazz5 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.traceMessage((int)1, (String)clazz5.getName(), (String)"createVolumesExt", (String)("volNames: " + String.valueOf(stringArray2)));
        }
        if ((hashMap = (HashMap)gUIRequestData.getParameter("volume.crgoal")) != null) {
            Class<?> clazz6;
            try {
                clazz6 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.traceMessage((int)1, (String)clazz6.getName(), (String)"createVolumesExt", (String)("goal: " + hashMap));
        }
        String[] stringArray3 = (String[])gUIRequestData.getParameter("system.ports");
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"assignPorts", (String)("systemPortWwpns: " + String.valueOf(stringArray3)));
        String[] stringArray4 = (String[])gUIRequestData.getParameter("host.ports");
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"assignPorts", (String)("hostPortWwpns: " + String.valueOf(stringArray4)));
        stringBuffer.append("\n volume names = ");
        if (stringArray2 != null) {
            n2 = 0;
            while (n2 < stringArray2.length) {
                stringBuffer.append(stringArray2[n2]);
                stringBuffer.append(" ");
                ++n2;
            }
        }
        stringBuffer.append("\nSubsystem port WWN(s) = ");
        if (stringArray3 != null) {
            n2 = 0;
            while (n2 < stringArray3.length) {
                stringBuffer.append(stringArray3[n2]);
                stringBuffer.append(" ");
                ++n2;
            }
        }
        stringBuffer.append("\n Host port WWN(s) = ");
        if (stringArray4 != null) {
            n2 = 0;
            while (n2 < stringArray4.length) {
                stringBuffer.append(stringArray4[n2]);
                stringBuffer.append(" ");
                ++n2;
            }
        }
        stringBuffer.append("\n");
        if (TraceLogger.enableAudit) {
            Class<?> clazz7;
            try {
                clazz7 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.auditMessage((String)clazz7.getName(), (String)"createVolumesExtAndAssignPorts()", (String)stringBuffer.toString());
        }
        if ((asyncResult = this.dmService.createStorageVolumes(lArray, stringArray, stringArray2, hashMap)) != null && asyncResult.getReturnException() == null && (n = Integer.parseInt(asyncResult.getJobId())) >= 1) {
            deviceRequest.deviceRunNbr = n;
            DeviceJobHndlr.setDeviceJobID(deviceRequest);
            new PortAssignmentThread(n, response, deviceRequest, stringArray4, stringArray3, null).start();
        }
        return asyncResult;
    }

    private AsyncResult createVDisksAndAssignPorts(GUIRequestData gUIRequestData, DeviceRequest deviceRequest, Response response) throws Exception {
        int n;
        AsyncResult asyncResult;
        int n2;
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        Class<?> clazz7;
        Class<?> clazz8;
        Class<?> clazz9;
        Class<?> clazz10;
        Class<?> clazz11;
        Class<?> clazz12;
        Class<?> clazz13;
        StringBuffer stringBuffer = new StringBuffer("Username = " + this.userName);
        stringBuffer.append("\n Create Vdisks and Assign Ports");
        Long l = (Long)gUIRequestData.getParameter("vdisk.size");
        try {
            clazz13 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz13.getName(), (String)"createVDisks", (String)("vdiskSize: " + l));
        String string = (String)((Object)gUIRequestData.getParameter("mdiskgroup.id"));
        try {
            clazz12 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz12.getName(), (String)"createVDisks", (String)("mdiskGroupId: " + string));
        String[] stringArray = (String[])gUIRequestData.getParameter("vdisk.names");
        try {
            clazz11 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz11.getName(), (String)"createVDisks", (String)("vdiskNames: " + stringArray));
        Boolean bl = (Boolean)gUIRequestData.getParameter("vdisk.format.oncreate");
        try {
            clazz10 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz10.getName(), (String)"createVDisks", (String)("formatOnCreate: " + bl));
        Integer n3 = (Integer)gUIRequestData.getParameter("vdisk.type");
        try {
            clazz9 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz9.getName(), (String)"createVDisks", (String)("vdiskType: " + n3));
        Integer n4 = (Integer)gUIRequestData.getParameter("iogroup.id");
        try {
            clazz8 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz8.getName(), (String)"createVDisks", (String)("ioGroupId: " + n4));
        String[] stringArray2 = (String[])gUIRequestData.getParameter("mdisk.ids");
        try {
            clazz7 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz7.getName(), (String)"createVDisks", (String)("mdiskIds: " + stringArray2));
        Integer n5 = (Integer)gUIRequestData.getParameter("num.of.vdisks");
        try {
            clazz6 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz6.getName(), (String)"createVDisks", (String)("numOfVDisks: " + n5));
        long[] lArray = new long[n5.intValue()];
        String[] stringArray3 = new String[n5.intValue()];
        int n6 = 0;
        while (n6 < n5) {
            lArray[n6] = l;
            stringArray3[n6] = string;
            ++n6;
        }
        String[] stringArray4 = (String[])gUIRequestData.getParameter("system.ports");
        try {
            clazz5 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz5.getName(), (String)"createVDisksAndassignPorts", (String)("systemPortWwpns: " + String.valueOf(stringArray4)));
        String[] stringArray5 = (String[])gUIRequestData.getParameter("host.ports");
        try {
            clazz4 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz4.getName(), (String)"createVDisksAndassignPorts", (String)("hostPortWwpns: " + String.valueOf(stringArray5)));
        Integer n7 = (Integer)gUIRequestData.getParameter("host.type");
        try {
            clazz3 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz3.getName(), (String)"createVDisksAndassignPorts", (String)("hosttype: " + n7));
        String string2 = (String)((Object)gUIRequestData.getParameter("host.type_desc"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"createVDisksAndassignPorts", (String)("hosttype description: " + string2));
        String[] stringArray6 = (String[])gUIRequestData.getParameter("host.names");
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"assignPorts", (String)("hostNames: " + String.valueOf(stringArray6)));
        stringBuffer.append("\n Number of vdisks = ");
        stringBuffer.append(n5);
        stringBuffer.append("\n Size = ");
        stringBuffer.append(l);
        stringBuffer.append("\n Subsystem port WWN(s) = ");
        if (stringArray4 != null) {
            n2 = 0;
            while (n2 < stringArray4.length) {
                stringBuffer.append(stringArray4[n2]);
                stringBuffer.append(" ");
                ++n2;
            }
        }
        stringBuffer.append("\n Host port WWN(s) = ");
        if (stringArray5 != null) {
            n2 = 0;
            while (n2 < stringArray5.length) {
                stringBuffer.append(stringArray5[n2]);
                stringBuffer.append(" ");
                ++n2;
            }
        }
        stringBuffer.append("\n Host Type = ");
        if (n7 != null) {
            stringBuffer.append(n7);
            stringBuffer.append(" ");
        }
        stringBuffer.append("\n Host Type Desc = ");
        if (string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append(" ");
        }
        stringBuffer.append("\n Host Names = ");
        if (stringArray6 != null) {
            n2 = 0;
            while (n2 < stringArray6.length) {
                stringBuffer.append(stringArray6[n2]);
                stringBuffer.append(" ");
                ++n2;
            }
        }
        stringBuffer.append("\n");
        if (TraceLogger.enableAudit) {
            Class<?> clazz14;
            try {
                clazz14 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.auditMessage((String)clazz14.getName(), (String)"createVDisksAndAssignPorts()", (String)stringBuffer.toString());
        }
        if ((asyncResult = this.dmService.createSVCVDisks(lArray, stringArray3, stringArray, bl.booleanValue(), n3.intValue(), n4.intValue(), stringArray2)) != null && asyncResult.getReturnException() == null && (n = Integer.parseInt(asyncResult.getJobId())) >= 1) {
            deviceRequest.deviceRunNbr = n;
            DeviceJobHndlr.setDeviceJobID(deviceRequest);
            new PortAssignmentThread(n, response, deviceRequest, stringArray5, stringArray4, n7, string2, stringArray6).start();
        }
        return asyncResult;
    }

    private AsyncResult unassignPorts(GUIRequestData gUIRequestData, Response response) throws Exception {
        int n;
        Class<?> clazz;
        Class<?> clazz2;
        StringBuffer stringBuffer = new StringBuffer("Username = " + this.userName);
        stringBuffer.append("\n Unassign Ports");
        String[] stringArray = (String[])gUIRequestData.getParameter("volume.ids");
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"unassignPorts", (String)("volumeIds: " + String.valueOf(stringArray)));
        String[] stringArray2 = (String[])gUIRequestData.getParameter("host.ports");
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"unassignPorts", (String)("hostPortWwpns: " + String.valueOf(stringArray2)));
        stringBuffer.append("\n Volumd ID(s) = ");
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                stringBuffer.append(" ");
                ++n;
            }
        }
        stringBuffer.append("\n Host port WWN(s) = ");
        if (stringArray2 != null) {
            n = 0;
            while (n < stringArray2.length) {
                stringBuffer.append(stringArray2[n]);
                stringBuffer.append(" ");
                ++n;
            }
        }
        stringBuffer.append("\n");
        if (TraceLogger.enableAudit) {
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.auditMessage((String)clazz3.getName(), (String)"unassignPorts()", (String)stringBuffer.toString());
        }
        return this.dmService.unassignStorageVolumesFromWWPNs(stringArray, stringArray2, true);
    }

    public class JobResultThread
    extends Thread {
        protected int jobID = 0;
        protected Response response = null;

        public JobResultThread(int n, Response response) {
            this.jobID = n;
            this.response = response;
        }

        public void run() {
            AsyncResult asyncResult;
            DeviceJobHndlr.waitForDeviceJob(this.response, this.jobID, SubsystemActionHandler.this.jobService);
            if (this.response != null && (asyncResult = (AsyncResult)this.response.responseData) != null) {
                AsyncResult[] asyncResultArray = asyncResult.getSubJobResults();
                int n = 0;
                while (n < asyncResultArray.length) {
                    Exception exception = asyncResultArray[n].getReturnException();
                    if (exception != null) {
                        String string = exception.getMessage();
                        if (exception instanceof SRMRuntimeException) {
                            string = ((SRMRuntimeException)exception).getLocalizedMessage();
                        }
                    }
                    if (asyncResultArray[n] != null && asyncResultArray[n].getResults() != null && asyncResultArray[n].getRc() <= 0) {
                        asyncResultArray[n].getResults();
                    }
                    ++n;
                }
            }
        }
    }

    public class PortAssignmentThread
    extends Thread {
        protected int jobID = 0;
        protected String[] hostPortWwpns = null;
        protected String[] systemPortWwpns = null;
        protected int hosttype = -1;
        protected String hostTypeDesc = null;
        protected String[] hostNames = null;
        protected Response response = null;
        protected DeviceRequest request = null;
        private Vector<String> volumeVector = new Vector();
        private String[] volumeIDs = null;

        public PortAssignmentThread(int n, Response response, DeviceRequest deviceRequest, String[] stringArray, String[] stringArray2, int n2, String string, String[] stringArray3) {
            this.jobID = n;
            this.response = response;
            this.request = deviceRequest;
            this.hostPortWwpns = stringArray;
            this.systemPortWwpns = stringArray2;
            this.hosttype = n2;
            this.hostTypeDesc = string;
            this.hostNames = stringArray3;
        }

        public PortAssignmentThread(int n, Response response, DeviceRequest deviceRequest, String[] stringArray, String[] stringArray2, String[] stringArray3) {
            this.jobID = n;
            this.response = response;
            this.request = deviceRequest;
            this.hostPortWwpns = stringArray;
            this.systemPortWwpns = stringArray2;
            this.hosttype = -1;
            this.hostTypeDesc = null;
            this.hostNames = stringArray3;
        }

        public void run() {
            block11: {
                AsyncResult asyncResult;
                DeviceJobHndlr.waitForDeviceJob(this.response, this.jobID, SubsystemActionHandler.this.jobService);
                if (this.response != null && (asyncResult = (AsyncResult)this.response.responseData) != null) {
                    AsyncResult[] asyncResultArray = asyncResult.getSubJobResults();
                    int n = 0;
                    while (n < asyncResultArray.length) {
                        VolumeID[] volumeIDArray;
                        Exception exception = asyncResultArray[n].getReturnException();
                        if (exception != null) {
                            volumeIDArray = exception.getMessage();
                            if (exception instanceof SRMRuntimeException) {
                                volumeIDArray = ((SRMRuntimeException)exception).getLocalizedMessage();
                            }
                        }
                        if (asyncResultArray[n] != null && asyncResultArray[n].getResults() != null && asyncResultArray[n].getRc() <= 0) {
                            volumeIDArray = (VolumeID[])asyncResultArray[n].getResults();
                            this.volumeVector.add(volumeIDArray[0].getStorageVolumeID());
                        }
                        this.volumeIDs = this.volumeVector.toArray(new String[0]);
                        ++n;
                    }
                    if (this.hostPortWwpns != null && this.hostPortWwpns.length > 0 && this.volumeIDs.length > 0) {
                        try {
                            int n2;
                            AsyncResult asyncResult2 = SubsystemActionHandler.this.dmService.assignStorageVolumesToWWPNs(this.volumeIDs, this.systemPortWwpns, null, this.hostPortWwpns, this.hosttype, this.hostTypeDesc, this.hostNames, null, true);
                            if (asyncResult2 == null || asyncResult2.getReturnException() != null || (n2 = Integer.parseInt(asyncResult2.getJobId())) < 1) break block11;
                            this.request.deviceRunNbr = n2;
                            boolean bl = DeviceJobHndlr.createNewScheduledJob(this.request, this.response);
                            if (!bl) {
                                Class<?> clazz;
                                if (!TraceLogger.enableTrace) break block11;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.exit((String)clazz.getName(), (String)"PortAssignmentThread::run()");
                                break block11;
                            }
                            DeviceJobHndlr.setDeviceJobID(this.request);
                            new JobResultThread(n2, this.response).start();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }
}

