/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TAlertLog;
import org.eclipse.aperi.repository.table.TReportPrefs;
import org.eclipse.aperi.repository.table.TStatTotals;
import org.eclipse.aperi.repository.table.TUserPrefs;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.sanmgmt.middleware.data.Roles;
import org.eclipse.aperi.server.DeviceServerManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.guireq.SignonResp;
import org.eclipse.aperi.server.guireq.UserPreferences;
import org.eclipse.aperi.server.guireq.UserPreferencesSM;
import org.eclipse.aperi.server.req.SignonReq;
import org.eclipse.aperi.xmsg.LocalizableException;

public class SignonHndlr
implements RequestHandler,
ThrowAway {
    private native boolean validate(String var1, String var2) throws LocalizableException;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response handle(Request request, Transceiver transceiver) {
        UserPreferences userPreferences;
        boolean bl;
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.server.SignonHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"handle", (String)"request, comm");
        }
        Response response = Response.getResponse((short)0, null);
        try {
            clazz = Class.forName("org.eclipse.aperi.server.req.SignonReq");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)response)) {
            Response response2 = response;
            if (TraceLogger.enableTrace) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.server.handler.server.SignonHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz3.getName(), (String)"handle", (Object)response2);
            }
            return response2;
        }
        SignonReq signonReq = (SignonReq)request.requestData;
        try {
            bl = this.validateUser(signonReq.id, signonReq.pwd);
        }
        catch (LocalizableException localizableException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.aperi.server.handler.server.SignonHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz4.getName(), (String)"handle", (Throwable)localizableException);
            }
            Server.setResponseError(response, (Exception)((Object)localizableException));
            Response response3 = response;
            if (TraceLogger.enableTrace) {
                Class<?> clazz5;
                try {
                    clazz5 = Class.forName("org.eclipse.aperi.server.handler.server.SignonHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz5.getName(), (String)"handle", (Object)response3);
            }
            return response3;
        }
        Connection connection = Server.getConnection();
        if (connection == null) {
            Server.setResponseError(response, "GEN0050E");
            Response response4 = response;
            if (TraceLogger.enableTrace) {
                Class<?> clazz6;
                try {
                    clazz6 = Class.forName("org.eclipse.aperi.server.handler.server.SignonHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz6.getName(), (String)"handle", (Object)response4);
            }
            return response4;
        }
        try {
            try {
                userPreferences = new TUserPrefs(connection).getUserPref(signonReq.id);
                userPreferences.administrator = bl;
                userPreferences.sm = new UserPreferencesSM();
                userPreferences.sm.reportPrefs = new TReportPrefs(connection).getPrefs(signonReq.id);
                SignonResp signonResp = new SignonResp();
                signonResp.prefs = userPreferences;
                TAlertLog tAlertLog = new TAlertLog(connection);
                signonResp.activeAlerts = tAlertLog.selectActiveIDs(signonReq.id);
                signonResp.adminGroup = Server.adminGroup;
                signonResp.sortOrderNotASCII = SQLUtil.sortOrderNotASCII;
                TStatTotals tStatTotals = new TStatTotals(connection);
                signonResp.dashTotalsRow = tStatTotals.select(signonReq.id);
                Roles roles = Roles.getInstance();
                signonResp.userRoles = roles.getUserRoles(signonReq.id);
                signonResp.deviceServerInstalled = false;
                DeviceServerManager deviceServerManager = Server.getDeviceServerManager();
                if (deviceServerManager != null) {
                    signonResp.deviceServerInstalled = deviceServerManager.getServerCount() > 0;
                }
                response.responseData = signonResp;
            }
            catch (GeneralException generalException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz7;
                    try {
                        clazz7 = Class.forName("org.eclipse.aperi.server.handler.server.SignonHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz7.getName(), (String)"handle", (Throwable)generalException);
                }
                Server.setResponseError(response, (Exception)((Object)generalException));
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz8;
                    try {
                        clazz8 = Class.forName("org.eclipse.aperi.server.handler.server.SignonHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz8.getName(), (String)"handle", (Throwable)sQLException);
                }
                Server.setResponseError(response, sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var13_20 = null;
            Server.returnConnection(connection);
            throw throwable;
        }
        {
            Object var13_21 = null;
        }
        Server.returnConnection(connection);
        userPreferences = response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz9;
            try {
                clazz9 = Class.forName("org.eclipse.aperi.server.handler.server.SignonHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz9.getName(), (String)"handle", (Object)userPreferences);
        }
        return userPreferences;
    }

    public boolean validateUser(String string, String string2) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.SignonHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"validateUser", (String)"user, password");
        }
        boolean bl = this.validate(string, string2);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.SignonHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"validateUser", (boolean)bl);
        }
        return bl;
    }
}

