/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.util.smtp;

import java.util.Vector;
import org.eclipse.aperi.logging.TraceLogger;

public class Email {
    public String text;
    public String subject;
    protected String from;
    protected String replyTo;
    protected String returnPath;
    protected String defaultDomain;
    protected Vector<String> recipientList;

    public Email(String string, String string2, String string3, String string4, String string5, String string6, String[] stringArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.Email");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"Email", (String)"subject, text, from, replyTo, returnPath, defaultDomain, recipientList");
        }
        this.subject = string;
        this.text = string2;
        this.from = string3;
        this.replyTo = string4;
        this.returnPath = string5;
        this.defaultDomain = string6;
        this.recipientList = new Vector();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.addRecipient(stringArray[n]);
                ++n;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.Email");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"Email");
        }
    }

    public Email(String string, String string2, String string3, String string4, String string5, String string6) {
        this(string, string2, string3, string4, string5, string6, null);
    }

    public void addRecipient(String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.Email");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addRecipient", (String)"recipient");
        }
        if (this.defaultDomain != null && string.indexOf(64) == -1) {
            string = String.valueOf(string) + '@' + this.defaultDomain;
        }
        this.recipientList.addElement(string);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.Email");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addRecipient");
        }
    }

    public void addEscapeRecipient(String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.Email");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addEscapeRecipient", (String)"recipient");
        }
        string = this.parseRecipient(string);
        if (this.defaultDomain != null) {
            string = String.valueOf(string) + '@' + this.defaultDomain;
        }
        this.recipientList.addElement(string);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.Email");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addEscapeRecipient");
        }
    }

    private String parseRecipient(String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.Email");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"parseRecipient", (String)"path");
        }
        int n = 0;
        while (n < string.length()) {
            if (this.isSpecial(string.charAt(n))) {
                String string2 = this.escapeRecipient(string, n);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.util.smtp.Email");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"parseRecipient", (Object)string2);
                }
                return string2;
            }
            ++n;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.Email");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"parseRecipient", (Object)string);
        }
        return string;
    }

    private boolean isSpecial(char c) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.Email");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"isSpecial", (String)"c");
        }
        if (c >= '\u0000' && c <= ' ' || c == '\u007f') {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.util.smtp.Email");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"isSpecial", (boolean)true);
            }
            return true;
        }
        switch (c) {
            case '\"': 
            case '(': 
            case ')': 
            case ',': 
            case ':': 
            case ';': 
            case '<': 
            case '>': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.util.smtp.Email");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"isSpecial", (boolean)true);
                }
                return true;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.Email");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"isSpecial", (boolean)false);
        }
        return false;
    }

    private String escapeRecipient(String string, int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.Email");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"escapeRecipient", (String)"path, firstSpecial");
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append('\"');
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(string.charAt(n2));
            ++n2;
        }
        stringBuffer.append('\\');
        stringBuffer.append(string.charAt(n2++));
        while (n2 < string.length()) {
            if (this.isSpecial(string.charAt(n2))) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(string.charAt(n2));
            ++n2;
        }
        while (n2 < string.length()) {
            stringBuffer.append(string.charAt(n2));
            ++n2;
        }
        stringBuffer.append('\"');
        String string2 = stringBuffer.toString();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.Email");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"escapeRecipient", (Object)string2);
        }
        return string2;
    }
}

