/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.io.File;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.equinox.http.servlet.internal.HttpServletRequestAdaptor;
import org.osgi.service.http.HttpContext;

public class ProxyContext {
    private static final String JAVAX_SERVLET_CONTEXT_TEMPDIR = "javax.servlet.context.tempdir";
    private String servletPath;
    private HashMap attributesMap = new HashMap();
    File proxyContextTempDir;

    public ProxyContext(ServletContext servletContext) {
        File file = (File)servletContext.getAttribute(JAVAX_SERVLET_CONTEXT_TEMPDIR);
        if (file != null) {
            this.proxyContextTempDir = new File(file, "proxytemp");
            ProxyContext.deleteDirectory(this.proxyContextTempDir);
            this.proxyContextTempDir.mkdirs();
        }
    }

    public void destroy() {
        if (this.proxyContextTempDir != null) {
            ProxyContext.deleteDirectory(this.proxyContextTempDir);
        }
    }

    synchronized void initializeServletPath(HttpServletRequest httpServletRequest) {
        if (this.servletPath == null) {
            this.servletPath = HttpServletRequestAdaptor.getDispatchServletPath(httpServletRequest);
        }
    }

    synchronized String getServletPath() {
        return this.servletPath;
    }

    synchronized void createContextAttributes(HttpContext httpContext) {
        ContextAttributes contextAttributes = (ContextAttributes)this.attributesMap.get(httpContext);
        if (contextAttributes == null) {
            contextAttributes = new ContextAttributes(httpContext);
            this.attributesMap.put(httpContext, contextAttributes);
        }
        contextAttributes.addReference();
    }

    synchronized void destroyContextAttributes(HttpContext httpContext) {
        ContextAttributes contextAttributes = (ContextAttributes)this.attributesMap.get(httpContext);
        contextAttributes.removeReference();
        if (contextAttributes.referenceCount() == 0) {
            this.attributesMap.remove(httpContext);
            contextAttributes.destroy();
        }
    }

    synchronized Dictionary getContextAttributes(HttpContext httpContext) {
        return (Dictionary)this.attributesMap.get(httpContext);
    }

    protected static boolean deleteDirectory(File file) {
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    ProxyContext.deleteDirectory(fileArray[n]);
                } else {
                    fileArray[n].delete();
                }
                ++n;
            }
        }
        return file.delete();
    }

    public class ContextAttributes
    extends Hashtable {
        private static final long serialVersionUID = 1916670423277243587L;
        private int referenceCount;

        public ContextAttributes(HttpContext httpContext) {
            if (ProxyContext.this.proxyContextTempDir != null) {
                File file = new File(ProxyContext.this.proxyContextTempDir, "hc_" + httpContext.hashCode());
                file.mkdirs();
                this.put(ProxyContext.JAVAX_SERVLET_CONTEXT_TEMPDIR, file);
            }
        }

        public void destroy() {
            File file = (File)this.get(ProxyContext.JAVAX_SERVLET_CONTEXT_TEMPDIR);
            if (file != null) {
                ProxyContext.deleteDirectory(file);
            }
        }

        public void addReference() {
            ++this.referenceCount;
        }

        public void removeReference() {
            --this.referenceCount;
        }

        public int referenceCount() {
            return this.referenceCount;
        }
    }
}

