/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.io.IOException;
import java.security.AccessController;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.Activator;
import org.eclipse.equinox.http.servlet.internal.HttpServletRequestAdaptor;
import org.eclipse.equinox.http.servlet.internal.ProxyContext;
import org.eclipse.equinox.http.servlet.internal.Registration;
import org.eclipse.equinox.http.servlet.internal.ResourceRegistration;
import org.eclipse.equinox.http.servlet.internal.ServletConfigImpl;
import org.eclipse.equinox.http.servlet.internal.ServletContextAdaptor;
import org.eclipse.equinox.http.servlet.internal.ServletRegistration;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;

public class ProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 4117456123807468871L;
    private Map registrations = new HashMap();
    private Set servlets = new HashSet();
    private ProxyContext proxyContext;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.proxyContext = new ProxyContext(servletConfig.getServletContext());
        Activator.addProxyServlet(this);
    }

    public void destroy() {
        Activator.removeProxyServlet(this);
        this.proxyContext.destroy();
        this.proxyContext = null;
        super.destroy();
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.proxyContext.initializeServletPath(httpServletRequest);
        String string = HttpServletRequestAdaptor.getDispatchPathInfo(httpServletRequest);
        if (string == null) {
            string = "/";
        }
        if (this.processAlias(httpServletRequest, httpServletResponse, string, null)) {
            return;
        }
        String string2 = this.findExtensionAlias(string);
        string = string.substring(0, string.lastIndexOf(47));
        while (string.length() != 0) {
            if (this.processAlias(httpServletRequest, httpServletResponse, string, string2)) {
                return;
            }
            string = string.substring(0, string.lastIndexOf(47));
        }
        if (string2 != null) {
            string2 = string2.substring(1);
        }
        if (this.processAlias(httpServletRequest, httpServletResponse, "/", string2)) {
            return;
        }
        httpServletResponse.sendError(404, "ProxyServlet: " + httpServletRequest.getRequestURI());
    }

    private String findExtensionAlias(String string) {
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        int n = string2.indexOf(46);
        if (n == -1) {
            return null;
        }
        String string3 = string2.substring(n + 1);
        if (string3.length() == 0) {
            return null;
        }
        return "/*." + string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processAlias(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws ServletException, IOException {
        Registration registration = null;
        ProxyServlet proxyServlet = this;
        synchronized (proxyServlet) {
            if (string2 == null) {
                registration = (Registration)this.registrations.get(string);
            } else {
                registration = (Registration)this.registrations.get(String.valueOf(string) + string2);
                if (registration != null) {
                    string = HttpServletRequestAdaptor.getDispatchPathInfo(httpServletRequest);
                } else {
                    registration = (Registration)this.registrations.get(string);
                }
            }
            if (registration != null) {
                registration.addReference();
            }
        }
        if (registration != null) {
            try {
                if (registration.handleRequest(httpServletRequest, httpServletResponse, string)) {
                    return true;
                }
            }
            finally {
                registration.removeReference();
            }
        }
        return false;
    }

    synchronized void unregister(String string, boolean bl) {
        Registration registration = (Registration)this.registrations.remove(string);
        if (registration != null) {
            if (bl) {
                registration.destroy();
            }
            registration.close();
        }
    }

    synchronized void registerServlet(String string, Servlet servlet, Dictionary dictionary, HttpContext httpContext, Bundle bundle) throws ServletException, NamespaceException {
        this.checkAlias(string);
        if (servlet == null) {
            throw new IllegalArgumentException("Servlet cannot be null");
        }
        ServletRegistration servletRegistration = new ServletRegistration(servlet, this.proxyContext, httpContext, bundle, this.servlets);
        servletRegistration.checkServletRegistration();
        ServletContextAdaptor servletContextAdaptor = new ServletContextAdaptor(this.proxyContext, this.getServletContext(), httpContext, AccessController.getContext());
        ServletConfigImpl servletConfigImpl = new ServletConfigImpl(servlet, dictionary, servletContextAdaptor);
        servletRegistration.init(servletConfigImpl);
        this.registrations.put(string, servletRegistration);
    }

    synchronized void registerResources(String string, String string2, HttpContext httpContext) throws NamespaceException {
        this.checkAlias(string);
        this.checkName(string2);
        this.registrations.put(string, new ResourceRegistration(string2, httpContext, this.getServletContext(), AccessController.getContext()));
    }

    private void checkName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (string.endsWith("/") && !string.equals("/")) {
            throw new IllegalArgumentException("Invalid Name '" + string + "'");
        }
    }

    private void checkAlias(String string) throws NamespaceException {
        if (string == null) {
            throw new IllegalArgumentException("Alias cannot be null");
        }
        if (!string.startsWith("/") || string.endsWith("/") && !string.equals("/")) {
            throw new IllegalArgumentException("Invalid alias '" + string + "'");
        }
        if (this.registrations.containsKey(string)) {
            throw new NamespaceException("The alias '" + string + "' is already in use.");
        }
    }
}

