/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMValue;

public abstract class CIMIndicationHandler
implements ICIMIndicationHandler {
    public final String ROLLBACK_MSG = "Database update failed, calling rollback()";
    private static final String PROCESSID_PREFIX = "I";
    public static final String DEDICATED_BLOCK_SERVER = "15";
    private String cIndicationClassname = null;
    private String cCIMClassname = null;
    private CIMIndicationEvent cEvent = null;

    public CIMIndicationHandler(String string, String string2, CIMIndicationEvent cIMIndicationEvent) {
        this.cIndicationClassname = string;
        this.cCIMClassname = string2;
        this.cEvent = cIMIndicationEvent;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final HandlingResult handleCIMIndication() {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"handleCIMIndication", null);
        HandlingResult handlingResult = HandlingResult.FAILURE;
        try {
            try {
                String string = PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString();
                handlingResult = this.handle(logTraceHelper, string);
            }
            catch (Exception exception) {
                logTraceHelper.traceError("handler failed", (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.cEvent.close();
            logTraceHelper.exit((Object)handlingResult);
            throw throwable;
        }
        {
            Object var4_7 = null;
            this.cEvent.close();
        }
        logTraceHelper.exit((Object)handlingResult);
        return handlingResult;
    }

    public abstract HandlingResult handle(LogTraceHelper var1, String var2);

    public String getCIMClassname() {
        return this.cCIMClassname;
    }

    public String getIndicationClassname() {
        return this.cIndicationClassname;
    }

    public CIMIndicationEvent getEvent() {
        return this.cEvent;
    }

    protected CIMInstance getAttachedTopLevelSystem(CIMObjectPath cIMObjectPath) throws CIMException, DiskManagerTimeoutException {
        LogTraceHelper logTraceHelper;
        block4: {
            Enumeration enumeration;
            CIMInstance cIMInstance;
            block5: {
                CIMInstance cIMInstance2;
                logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getAttachedTopLevelSystem", (Object[])new Object[]{cIMObjectPath});
                cIMInstance = null;
                try {
                    enumeration = this.getEvent().getCIMClient().associators(cIMObjectPath, "CIM_SystemDevice", "CIM_ComputerSystem", "PartComponent", "GroupComponent", true, false, null, logTraceHelper);
                    if (!enumeration.hasMoreElements()) break block4;
                    cIMInstance = (CIMInstance)enumeration.nextElement();
                    if (!this.isTopLevelSystem(cIMInstance)) break block5;
                    cIMInstance2 = cIMInstance;
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    logTraceHelper.exit(cIMInstance);
                    throw throwable;
                }
                logTraceHelper.exit((Object)cIMInstance);
                return cIMInstance2;
            }
            enumeration = this.getEvent().getCIMClient().associators(cIMInstance.getObjectPath(), "CIM_ComponentCS", "CIM_ComputerSystem", "PartComponent", "GroupComponent", true, false, null, logTraceHelper);
            if (!enumeration.hasMoreElements() || !this.isTopLevelSystem(cIMInstance = (CIMInstance)enumeration.nextElement())) break block4;
            CIMInstance cIMInstance3 = cIMInstance;
            Object var5_8 = null;
            logTraceHelper.exit((Object)cIMInstance);
            return cIMInstance3;
        }
        logTraceHelper.traceWarning("Failed to determine TopLevelComputerSystem");
        throw new RuntimeException("Failed to determine TopLevelComputerSystem");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isTopLevelSystem(CIMInstance cIMInstance) throws DiskManagerTimeoutException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"isTopLevelSystem", (Object[])new Object[]{cIMInstance});
        Enumeration enumeration = null;
        try {
            enumeration = this.getEvent().getCIMClient().associatorNames(cIMInstance.getObjectPath(), "CIM_ElementConformsToProfile", "CIM_RegisteredProfile", "ManagedElement", "ConformantStandard", logTraceHelper);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            logTraceHelper.exit((Object)(enumeration.hasMoreElements() ? Boolean.TRUE : Boolean.FALSE));
            throw throwable;
        }
        {
            Object var4_6 = null;
            logTraceHelper.exit((Object)(enumeration.hasMoreElements() ? Boolean.TRUE : Boolean.FALSE));
        }
        return enumeration.hasMoreElements();
    }

    protected StorageSubsystem getSubsystemFromCimInstance(DBConnection dBConnection, CIMInstance cIMInstance) {
        String string = (String)cIMInstance.getProperty("Name").getValue().getValue();
        String string2 = (String)cIMInstance.getProperty("NameFormat").getValue().getValue();
        try {
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            hashtable.put(TResStorageSubsystemTable.getColumnInfo((String)"NAME"), string);
            hashtable.put(TResStorageSubsystemTable.getColumnInfo((String)"NAME_FORMAT"), DBConstants.getValueFromKey((String)"SMISName_Format", (String)string2));
            return StorageSubsystem.retrieve((DBConnection)dBConnection, hashtable);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    protected String getSMISVersion(CIMInstance cIMInstance) throws CIMException, DiskManagerTimeoutException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getSMISVersion", (Object[])new Object[]{cIMInstance});
        String string = null;
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        CIMInstance cIMInstance2 = null;
        Enumeration enumeration = this.getEvent().getCIMClient().associators(cIMInstance.getObjectPath(), "CIM_ElementConformsToProfile", "CIM_RegisteredProfile", "ManagedElement", "ConformantStandard", false, false, null, logTraceHelper);
        while (enumeration.hasMoreElements()) {
            cIMInstance2 = (CIMInstance)enumeration.nextElement();
            vector.add(cIMInstance2);
        }
        CIMInstance cIMInstance3 = (CIMInstance)vector.get(0);
        CIMProperty cIMProperty = cIMInstance3.getProperty("RegisteredVersion");
        CIMValue cIMValue = cIMProperty.getValue();
        string = (String)cIMValue.getValue();
        logTraceHelper.exit((Object)string);
        return string;
    }

    public boolean isChangeDetectionSupported() {
        return this.cIndicationClassname.equalsIgnoreCase("CIM_InstModification");
    }

    public static class RegistrationData {
        private String mCIMClassName;
        private String mIndicationClassname;

        public RegistrationData(String string, String string2) {
            if (string == null || string.trim().length() == 0) {
                throw new NullPointerException("Name must be neither null nor whitespace only.");
            }
            this.mCIMClassName = string;
            this.mIndicationClassname = string2;
        }

        public boolean equals(Object object) {
            if (object instanceof RegistrationData) {
                RegistrationData registrationData = (RegistrationData)object;
                return this.mCIMClassName.equals(registrationData.mCIMClassName) && this.mIndicationClassname.equals(registrationData.mIndicationClassname);
            }
            return false;
        }

        public String getCIMClassName() {
            return this.mCIMClassName;
        }

        public String getIndicationType() {
            return this.mIndicationClassname;
        }
    }
}

