/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.util.Comparator;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.monitor.DiskEventQueue;
import org.eclipse.aperi.disk.monitor.DiskExpiringEventQueue;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;

public class DiskFilterThread
extends Thread {
    private volatile boolean cShutdown = false;
    private Thread cThread = null;
    private DiskEventQueue cEntryQueue = null;
    private DiskExpiringEventQueue cCreationBufferQueue = null;
    private DiskExpiringEventQueue cDeletionBufferQueue = null;
    private DiskEventQueue cWorkerQueue = null;
    Comparator cComparator = new EventComparator();

    public DiskFilterThread(DiskEventQueue diskEventQueue, DiskEventQueue diskEventQueue2, DiskExpiringEventQueue diskExpiringEventQueue, DiskExpiringEventQueue diskExpiringEventQueue2) {
        this.cEntryQueue = diskEventQueue;
        this.cWorkerQueue = diskEventQueue2;
        this.cCreationBufferQueue = diskExpiringEventQueue;
        this.cDeletionBufferQueue = diskExpiringEventQueue2;
        this.start();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"run", null);
        try {
            this.cThread = Thread.currentThread();
            while (!this.cShutdown) {
                try {
                    CIMIndicationEvent cIMIndicationEvent = this.cEntryQueue.remove();
                    String string = cIMIndicationEvent.getCIMEvent().getIndication().getClassName();
                    if (string.equalsIgnoreCase("CIM_InstCreation")) {
                        this.processInstanceCreation(cIMIndicationEvent);
                        continue;
                    }
                    if (string.equalsIgnoreCase("CIM_InstDeletion")) {
                        this.processInstanceDeletion(cIMIndicationEvent);
                        continue;
                    }
                    this.processInstanceModification(cIMIndicationEvent);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        logTraceHelper.exit(null);
    }

    private void processInstanceModification(CIMIndicationEvent cIMIndicationEvent) {
        if (!this.cWorkerQueue.contains(cIMIndicationEvent, this.cComparator)) {
            this.cWorkerQueue.add(cIMIndicationEvent);
        }
    }

    private void processInstanceDeletion(CIMIndicationEvent cIMIndicationEvent) {
        if (!this.cDeletionBufferQueue.contains(cIMIndicationEvent, this.cComparator)) {
            this.cWorkerQueue.add(cIMIndicationEvent);
        }
        this.cDeletionBufferQueue.add(cIMIndicationEvent);
    }

    private void processInstanceCreation(CIMIndicationEvent cIMIndicationEvent) {
        if (!this.cCreationBufferQueue.contains(cIMIndicationEvent, this.cComparator)) {
            this.cWorkerQueue.add(cIMIndicationEvent);
        }
        this.cCreationBufferQueue.add(cIMIndicationEvent);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"shutdown", null);
        this.cShutdown = true;
        try {
            if (this.cThread != null) {
                try {
                    this.cThread.interrupt();
                    this.cThread.join(30000L);
                    this.cThread = null;
                }
                catch (Exception exception) {
                    logTraceHelper.traceError("HWN099993E", (Throwable)exception);
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        logTraceHelper.exit(null);
    }

    public static class EventComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            CIMIndicationEvent cIMIndicationEvent = (CIMIndicationEvent)((Object)object);
            CIMIndicationEvent cIMIndicationEvent2 = (CIMIndicationEvent)((Object)object2);
            int n = cIMIndicationEvent.getCIMInstance().getClassName().compareTo(cIMIndicationEvent2.getCIMInstance().getClassName());
            return n != 0 ? n : cIMIndicationEvent.getSourceCop().toString().compareTo(cIMIndicationEvent2.getSourceCop().toString());
        }
    }
}

