/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator;

import java.io.Serializable;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TopicPublisher;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.control.data.JobInfo;
import org.eclipse.aperi.discovery.RemoveMissingProcessor;
import org.eclipse.aperi.infrastructure.database.objects.Agent;
import org.eclipse.aperi.infrastructure.database.objects.Alias;
import org.eclipse.aperi.infrastructure.database.objects.Alias2member;
import org.eclipse.aperi.infrastructure.database.objects.BackendController;
import org.eclipse.aperi.infrastructure.database.objects.DataPath;
import org.eclipse.aperi.infrastructure.database.objects.DeviceAgent;
import org.eclipse.aperi.infrastructure.database.objects.Disk;
import org.eclipse.aperi.infrastructure.database.objects.DiskGroup;
import org.eclipse.aperi.infrastructure.database.objects.Fabric;
import org.eclipse.aperi.infrastructure.database.objects.Fabric2switch;
import org.eclipse.aperi.infrastructure.database.objects.Hba;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.infrastructure.database.objects.IpTarget;
import org.eclipse.aperi.infrastructure.database.objects.Node;
import org.eclipse.aperi.infrastructure.database.objects.Node2hba;
import org.eclipse.aperi.infrastructure.database.objects.Pe2node;
import org.eclipse.aperi.infrastructure.database.objects.PhyPe;
import org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.Port2port;
import org.eclipse.aperi.infrastructure.database.objects.Redundancy;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.Server;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.database.objects.Switch2port;
import org.eclipse.aperi.infrastructure.database.objects.SwitchBlade;
import org.eclipse.aperi.infrastructure.database.objects.TapeDrive;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.TapeMediaChanger;
import org.eclipse.aperi.infrastructure.database.objects.Zone;
import org.eclipse.aperi.infrastructure.database.objects.Zone2alias;
import org.eclipse.aperi.infrastructure.database.objects.Zone2member;
import org.eclipse.aperi.infrastructure.database.objects.ZoneMember;
import org.eclipse.aperi.infrastructure.database.objects.Zset;
import org.eclipse.aperi.infrastructure.database.objects.Zset2zone;
import org.eclipse.aperi.monitor.CIMOMEventProcessor;
import org.eclipse.aperi.monitor.CIMOMRegistrator;
import org.eclipse.aperi.monitor.DataSource;
import org.eclipse.aperi.monitor.MonitorActivator;
import org.eclipse.aperi.monitor.eventcorrelator.DelayPostEventThread;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorDBHelper;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.EventHandler;
import org.eclipse.aperi.monitor.eventcorrelator.EventProcessor;
import org.eclipse.aperi.monitor.eventcorrelator.SnapshotProcessor;
import org.eclipse.aperi.monitor.eventcorrelator.data.AgentEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMOMEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.DataPathAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.DeviceOperationalStatusChangeEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.DeviceStateChangeEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.DiskDriveAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.DiskGroupAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.DiskMgrAgentEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.EntityEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.ExtentAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.ExternalEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.Fabric2SwitchAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.FabricAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.FabricPortAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.FifoQueue;
import org.eclipse.aperi.monitor.eventcorrelator.data.Hba2NodeAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.HbaAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.HostAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.IPTargetEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.InbandEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.JobEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.monitor.eventcorrelator.data.NewDeviceEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.NewRelationshipEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.NodeAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.Pe2NodeAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.PerEntAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.PoolAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.Port2PortAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.PropertyChangeEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.RelationshipStateChangeEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.SNMPTrapEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.SRMEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.SVCNodeAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.StorageSystemAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.Switch2PortAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.SwitchAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.SwitchBladeAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.VolumeAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.Zone2AliasAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.Zone2MemberAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.ZoneAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.ZoneAliasAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.ZoneMemberAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.ZonesetAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.Zset2ZoneAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.DataManager;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.ExtractEventFailedException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.InbandChangeEventExtractor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.SanDataManager;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.SmartEvent;
import org.eclipse.aperi.monitor.snmp.EventFilter;
import org.eclipse.aperi.monitor.snmp.SnmpMonitor;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.ICallback;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.event.data.SANEventUtil;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.sanmgmt.middleware.messaging.Factory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.FactoryFactory;
import org.eclipse.aperi.sanmgmt.sanmgr.eventcorrelator.interfaces.IEventCorrelatorFactory;
import org.eclipse.aperi.sanmgmt.sanmgr.eventcorrelator.interfaces.InstantiationFailedException;
import org.eclipse.aperi.sanmgmt.sanmgr.eventcorrelator.interfaces.PostEventFailedException;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.client.indications.CIMEvent;

public class EventCorrelatorFactory
implements IEventCorrelatorFactory,
IEventMonitorService,
IService,
ICliDispatcher,
ICallback {
    public static ILogger msgLogger;
    public static ILogger traceLogger;
    static final String className;
    static ResourceBundle rb;
    private Status status = null;
    private final String SERVICE_NAME = "SANEventCorrelatorFactory";
    private Factory tesFactory = null;
    private TopicPublisher tesPublisher = null;
    private DataManager dataManager = null;
    boolean shutdownRequested = false;
    private SnmpMonitor snmpMonitor = null;
    private CIMOMEventProcessor cimMonitor = null;
    Hashtable publisherList = new Hashtable();
    private Message template = null;
    private Hashtable events = new Hashtable();
    private Hashtable devices = new Hashtable();
    private Map indicationSources = new HashMap();
    private SnapshotProcessor snapshotPro = null;
    private EventProcessor eventPro = null;
    static Hashtable devAlertPopulators;
    static Hashtable tableToEntityTypeMapping;
    private HashSet cimomRegers = new HashSet();
    public static final Integer IS_SUBSYSTEM;
    public static final Integer IS_TAPELIBRARY;
    public static final Integer IS_NOTHING;
    public static final Integer IS_SWITCH;
    public static String DEFAULT_PROC_ID;
    public static boolean oldAPIUsed;
    public static final String PROPERTY_GROUP = "MonitorService";
    public static final String PROPERTY_NUM_CIMOM_REGISTRATORS = "NumCIMOMRegistrators";
    public static final int DEFAULT_NUM_RESOURCES = 5;

    static {
        Class<?> clazz;
        msgLogger = null;
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        rb = ResourceBundle.getBundle("org.eclipse.aperi.monitor.eventcorrelator.resources.EventFilterResources", Locale.getDefault());
        devAlertPopulators = new Hashtable();
        tableToEntityTypeMapping = new Hashtable();
        IS_SUBSYSTEM = new Integer(2);
        IS_TAPELIBRARY = new Integer(3);
        IS_NOTHING = new Integer(-1);
        IS_SWITCH = new Integer(1);
        DEFAULT_PROC_ID = "DEVICE_DISCOVERY";
        oldAPIUsed = false;
    }

    public synchronized void registerAlertPopulator(String string, IPopulator iPopulator) {
        devAlertPopulators.put(string, iPopulator);
    }

    public synchronized void deregisterAlertPopulator(String string) {
        devAlertPopulators.remove(string);
    }

    public EventCorrelatorFactory() {
        this.status = new Status(5, 3);
        LogConstants.msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.SanEventCorrelatorFactory");
        LogConstants.traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.SanEventCorrelatorFactory");
        LogConstants.msgLogger.setMessageFile(LogConstants.MSG_FILE);
        msgLogger = LogConstants.msgLogger;
        traceLogger = LogConstants.traceLogger;
        EventCorrelatorFactory.initTableNameToDeviceTypeMap();
        EventCorrelatorFactory.initDeviceTypeToAlertPopulatorMap();
    }

    public void postSnmpEvent(SnmpTrap snmpTrap) {
        String string = "postSnmpEvent";
        String string2 = "SNMPTrap";
        String string3 = null;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string, (Object)string2);
        }
        if (!this.shutdownRequested) {
            if (snmpTrap.agentAddr != null) {
                string3 = snmpTrap.agentAddr.toString();
            }
            if (string3 == null) {
                string3 = "UnknownSNMPTrapSource";
                traceLogger.text(IRecordType.TYPE_WARN, (Object)this, string, "Received " + string2 + " from " + string3);
            }
            SNMPTrapEvent sNMPTrapEvent = new SNMPTrapEvent(string3, string2, snmpTrap);
            this.addExternalEvent(sNMPTrapEvent);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public void postEvent(String string) throws PostEventFailedException {
        String string2 = "postEvent";
        String string3 = "InbandNotification";
        String string4 = null;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, (Object)string);
        }
        if (!this.shutdownRequested) {
            SmartEvent[] smartEventArray = null;
            try {
                InbandChangeEventExtractor inbandChangeEventExtractor = new InbandChangeEventExtractor();
                smartEventArray = inbandChangeEventExtractor.extractEvent(this.dataManager, string);
            }
            catch (ExtractEventFailedException extractEventFailedException) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string2, (Throwable)extractEventFailedException);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)extractEventFailedException);
                }
                throw new PostEventFailedException();
            }
            int n = 0;
            while (n < smartEventArray.length) {
                string4 = smartEventArray[n].getSourceAddress();
                if (string4 == null) {
                    string4 = "UnknownInbandSource";
                    traceLogger.text(IRecordType.TYPE_WARN, (Object)this, string2, "Received " + string3 + " from " + string4);
                }
                InbandEvent inbandEvent = new InbandEvent(string4, string3);
                this.addExternalEvent((ExternalEvent)inbandEvent);
                ++n;
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    public void postIndicationEvent(CIMEvent cIMEvent) {
        String string;
        block7: {
            string = "postIndicationEvent";
            String string2 = "CIMIndication";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string, (Object)string2);
            }
            if (!this.shutdownRequested) {
                try {
                    String string3 = null;
                    InetAddress inetAddress = cIMEvent.getInetAddress();
                    if (inetAddress != null) {
                        string3 = inetAddress.getHostAddress();
                    }
                    if (string3 == null) {
                        string3 = "UnknownCIMIndicationSource";
                        traceLogger.text(IRecordType.TYPE_WARN, (Object)this, string, "Received " + string2 + " from " + string3);
                    }
                    CIMIndicationEvent cIMIndicationEvent = new CIMIndicationEvent(string3, string2, cIMEvent);
                    this.addExternalEvent(cIMIndicationEvent);
                }
                catch (Exception exception) {
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                    if (!traceLogger.isLogging()) break block7;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public synchronized void addExternalEvent(ExternalEvent externalEvent) {
        String string = externalEvent.getSource();
        String string2 = externalEvent.getType();
        DelayPostEventThread.addEvent(String.valueOf(string) + string2, (SRMEvent)externalEvent, this);
    }

    public synchronized void addEntityEventToEventList(String string, EntityEvent entityEvent) {
        Vector<EntityEvent> vector;
        String string2 = "addEntityEventToEventList";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, new Object[]{string, entityEvent});
        }
        if ((vector = (Vector<EntityEvent>)this.events.get(string)) == null) {
            vector = new Vector<EntityEvent>();
        }
        vector.add(entityEvent);
        this.events.put(string, vector);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    public synchronized void addDeviceToSnapshotList(String string, String string2, String string3) {
        String string4 = "addDeviceToSnapshotList";
        new Hashtable();
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string4, new Object[]{string, String.valueOf(string2) + ":" + string3});
        }
        if (this.isSnapshotDeviceType(string2)) {
            Vector<String> vector = (Vector<String>)this.devices.get(string);
            if (vector == null) {
                vector = new Vector<String>();
            }
            vector.add(String.valueOf(string2) + ':' + string3);
            this.devices.put(string, vector);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
    }

    private boolean isSnapshotDeviceType(String string) {
        boolean bl = false;
        if (string.equals("switch") || string.equals("subsystem") || string.equals("host")) {
            bl = true;
        }
        return bl;
    }

    public boolean startup() {
        boolean bl;
        String string;
        block16: {
            block14: {
                string = "startup";
                bl = false;
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
                }
                this.status.setRunStatus(9);
                this.snmpMonitor = new SnmpMonitor(this);
                this.snmpMonitor.initialize();
                try {
                    this.cimMonitor = new CIMOMEventProcessor(this);
                    this.createCIMOMRegers(this.cimMonitor);
                    RegisteredCimom[] registeredCimomArray = EventDBAccessor.getAllRegisteredCimoms();
                    if (registeredCimomArray == null || registeredCimomArray.length <= 0) break block14;
                    int n = 0;
                    while (n < registeredCimomArray.length) {
                        block15: {
                            try {
                                DataSource dataSource = new DataSource(1, registeredCimomArray[n]);
                                this.cimMonitor.addDataSource(dataSource);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                if (!traceLogger.isLogging()) break block15;
                                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                            }
                        }
                        ++n;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (!traceLogger.isLogging()) break block14;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                }
            }
            try {
                this.snapshotPro = SnapshotProcessor.shareInstance();
                this.snapshotPro.start(this);
                this.eventPro = EventProcessor.shareInstance();
                this.eventPro.start(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            FifoQueue.getQueue(10);
            try {
                this.dataManager = SanDataManager.createDataManager();
            }
            catch (InstantiationFailedException instantiationFailedException) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)instantiationFailedException);
                if (!traceLogger.isLogging()) break block16;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)instantiationFailedException);
            }
        }
        try {
            this.tesFactory = FactoryFactory.createFactory((int)2, null);
            this.template = this.tesFactory.createMessage(null);
            this.template.setStringProperty("SANDomainID", SANEventUtil.getDomainName());
            this.template.setStringProperty("publisherID", "org.eclipse.aperi.sanmgmt.sanmgr.eventcorrelator.EventCorrelator");
        }
        catch (JMSException jMSException) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)jMSException);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)jMSException);
            }
            return bl;
        }
        this.status.setRunStatus(8);
        bl = true;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return bl;
    }

    private void createCIMOMRegers(CIMOMEventProcessor cIMOMEventProcessor) {
        String string;
        int n = 5;
        IConfigService iConfigService = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService");
        if (iConfigService != null && (string = iConfigService.getProperty(PROPERTY_NUM_CIMOM_REGISTRATORS, PROPERTY_GROUP)) != null) {
            n = Integer.parseInt(string);
        }
        int n2 = 0;
        while (n2 < n) {
            this.cimomRegers.add(new CIMOMRegistrator(cIMOMEventProcessor));
            ++n2;
        }
    }

    public boolean shutdown() {
        boolean bl;
        String string;
        block20: {
            block19: {
                string = "shutdown";
                this.shutdownRequested = true;
                bl = false;
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
                }
                this.status.setRunStatus(11);
                this.snmpMonitor.shutdown();
                this.snmpMonitor = null;
                this.closeAllPublishers();
                if (this.cimMonitor != null) {
                    try {
                        RegisteredCimom[] registeredCimomArray = EventDBAccessor.getAllRegisteredCimoms();
                        if (registeredCimomArray != null && registeredCimomArray.length > 0) {
                            int n = 0;
                            while (n < registeredCimomArray.length) {
                                block18: {
                                    try {
                                        DataSource dataSource = new DataSource(1, registeredCimomArray[n]);
                                        this.cimMonitor.removeDataSource(dataSource);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        if (!traceLogger.isLogging()) break block18;
                                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                                    }
                                }
                                ++n;
                            }
                        }
                        if (registeredCimomArray != null && registeredCimomArray.length > 0) {
                            try {
                                Thread.sleep(30000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (this.cimomRegers != null) {
                            Iterator iterator = this.cimomRegers.iterator();
                            while (iterator.hasNext()) {
                                ((CIMOMRegistrator)iterator.next()).shutdown();
                            }
                            this.cimomRegers = null;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (!traceLogger.isLogging()) break block19;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                    }
                }
            }
            this.cimMonitor.exit();
            this.cimMonitor = null;
            if (this.snapshotPro != null) {
                this.snapshotPro.stop();
            }
            if (this.eventPro != null) {
                this.eventPro.stop();
            }
            try {
                this.tesFactory.close();
            }
            catch (JMSException jMSException) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "EvcEventGenerato_tesFactoryCloseFailed");
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)jMSException);
                if (!traceLogger.isLogging()) break block20;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)jMSException);
            }
        }
        bl = true;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return bl;
    }

    public String getName() {
        return "SANEventCorrelatorFactory";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("SANEventCorrelatorFactory_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("SANEventCorrelatorFactory_Description");
    }

    public Status getStatus() {
        return new Status(5, 8);
    }

    public String getVersion() {
        return "5.0.0";
    }

    public String getDescription() {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "getDescription");
        }
        String string = "Processes SNMP traps from the SAN and events received from the managed hosts";
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "getDescription");
        }
        return string;
    }

    public Hashtable getRoleMap() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("dispatch", new Integer(RoleChecker.FABRIC_ADMIN));
        return hashtable;
    }

    public synchronized void publish(SRMEvent sRMEvent) {
        String string;
        block9: {
            string = "publish";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string, (Object)sRMEvent);
            }
            sRMEvent.toString();
            try {
                TopicPublisher topicPublisher = null;
                String string2 = sRMEvent.getClass().getName();
                if (this.publisherList.containsKey(string2)) {
                    topicPublisher = (TopicPublisher)this.publisherList.get(string2);
                } else {
                    topicPublisher = this.tesFactory.createPublisher(sRMEvent.getClass().getName(), this.template);
                    this.publisherList.put(string2, topicPublisher);
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string, "Created a new publisher for key = " + string2);
                    }
                }
                ObjectMessage objectMessage = this.tesFactory.createMessage((Serializable)sRMEvent);
                topicPublisher.publish((Message)objectMessage);
            }
            catch (JMSException jMSException) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)jMSException);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)jMSException);
                }
            }
            catch (Exception exception) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                if (!traceLogger.isLogging()) break block9;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string, "Published TPC Event: " + sRMEvent.toString());
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public void closeAllPublishers() {
        String string = "closeAllPublishers";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        Enumeration enumeration = this.publisherList.keys();
        while (enumeration.hasMoreElements()) {
            TopicPublisher topicPublisher = (TopicPublisher)this.publisherList.get(enumeration.nextElement());
            try {
                topicPublisher.close();
                if (!traceLogger.isLogging()) continue;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Closed publisher: " + topicPublisher.toString());
            }
            catch (JMSException jMSException) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "EvcEventGenerator_tesPublisherCloseFailed", (Object)topicPublisher.toString());
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)jMSException);
                if (!traceLogger.isLogging()) continue;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)jMSException);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public void handleNewDevice(String string, String string2) {
        String string3 = "handleNewDevice";
        String string4 = DEFAULT_PROC_ID;
        oldAPIUsed = true;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3);
        }
        this.addDeviceToSnapshotList(string4, string, string2);
        if (string.equals("cimom")) {
            try {
                RegisteredCimom registeredCimom = EventDBAccessor.getCIMOMByID(string2);
                DataSource dataSource = new DataSource(1, registeredCimom);
                this.cimMonitor.addDataSource(dataSource);
                String string5 = registeredCimom.getServiceUrl();
                int n = this.getPortNumber(string5);
                String string6 = "New CIMOM discovered";
                CIMOMEvent cIMOMEvent = new CIMOMEvent(string5, n, string6);
                this.publish((SRMEvent)cIMOMEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (string.equals("iptarget")) {
            String string7 = string;
            String string8 = string2;
            String string9 = "New IP target discovered";
            IPTargetEvent iPTargetEvent = new IPTargetEvent(string7, string8, string9);
            this.publish((SRMEvent)iPTargetEvent);
        } else if (string.equals("agent")) {
            String string10 = string2;
            int n = 999;
            String string11 = "New agent discovered";
            DiskMgrAgentEvent diskMgrAgentEvent = new DiskMgrAgentEvent(string10, n, string11);
            this.publish((SRMEvent)diskMgrAgentEvent);
        } else {
            NewDeviceEvent newDeviceEvent = new NewDeviceEvent(string, string2);
            this.addEntityEventToEventList(string4, (EntityEvent)newDeviceEvent);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
    }

    public void handleDeviceStateChange(String string, String string2, int n, int n2) {
        String string3;
        block15: {
            string3 = "handleDeviceStateChange";
            String string4 = DEFAULT_PROC_ID;
            oldAPIUsed = true;
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3);
            }
            Integer.toString(n2);
            this.addDeviceToSnapshotList(string4, string, string2);
            if (string.equals("cimom")) {
                try {
                    RegisteredCimom registeredCimom = EventDBAccessor.getCIMOMByID(string2);
                    DataSource dataSource = new DataSource(1, registeredCimom);
                    if (n2 == 1) {
                        this.cimMonitor.addDataSource(dataSource);
                        String string5 = registeredCimom.getServiceUrl();
                        int n3 = this.getPortNumber(string5);
                        String string6 = "Missing CIMOM changed to normal";
                        CIMOMEvent cIMOMEvent = new CIMOMEvent(string5, n3, string6);
                        this.publish((SRMEvent)cIMOMEvent);
                        break block15;
                    }
                    this.cimMonitor.removeDataSource(dataSource);
                    this.deleteIndicationSource(dataSource);
                    String string7 = registeredCimom.getServiceUrl();
                    int n4 = this.getPortNumber(string7);
                    String string8 = "Normal CIMOM changed to missing";
                    CIMOMEvent cIMOMEvent = new CIMOMEvent(string7, n4, string8);
                    this.publish((SRMEvent)cIMOMEvent);
                }
                catch (Exception exception) {}
            } else if (string.equals("iptarget")) {
                if (n2 == 1) {
                    String string9 = string;
                    String string10 = string2;
                    String string11 = "Missing IP target changed to normal.";
                    IPTargetEvent iPTargetEvent = new IPTargetEvent(string9, string10, string11);
                    this.publish((SRMEvent)iPTargetEvent);
                } else {
                    String string12 = string;
                    String string13 = string2;
                    String string14 = "Normal IP target changed to missing.";
                    IPTargetEvent iPTargetEvent = new IPTargetEvent(string12, string13, string14);
                    this.publish((SRMEvent)iPTargetEvent);
                }
            } else if (string.equals("agent")) {
                if (n2 == 1) {
                    String string15 = string2;
                    String string16 = null;
                    int n5 = this.getPortNumber(string16);
                    String string17 = "Missing agent changed to normal";
                    DiskMgrAgentEvent diskMgrAgentEvent = new DiskMgrAgentEvent(string15, n5, string17);
                    this.publish((SRMEvent)diskMgrAgentEvent);
                } else {
                    String string18 = string2;
                    String string19 = null;
                    int n6 = this.getPortNumber(string19);
                    String string20 = "Normal agent changed to missing";
                    DiskMgrAgentEvent diskMgrAgentEvent = new DiskMgrAgentEvent(string18, n6, string20);
                    this.publish((SRMEvent)diskMgrAgentEvent);
                }
            } else {
                DeviceStateChangeEvent deviceStateChangeEvent = new DeviceStateChangeEvent(string, string2, n, n2);
                this.addEntityEventToEventList(string4, (EntityEvent)deviceStateChangeEvent);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
    }

    public void handleDevicePropertyChange(String string, String string2, Hashtable hashtable, Hashtable hashtable2) {
        String string3 = "handleDevicePropertyChange";
        String string4 = DEFAULT_PROC_ID;
        oldAPIUsed = true;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3);
        }
        this.addDeviceToSnapshotList(string4, string, string2);
        if (string.equals("cimom")) {
            try {
                RegisteredCimom registeredCimom = EventDBAccessor.getCIMOMByID(string2);
                String string5 = registeredCimom.getServiceUrl();
                int n = this.getPortNumber(string5);
                String string6 = "CIMOM Property changed.";
                CIMOMEvent cIMOMEvent = new CIMOMEvent(string5, n, string6);
                this.publish((SRMEvent)cIMOMEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (string.equals("iptarget")) {
            String string7 = string;
            String string8 = string2;
            String string9 = "IP target property changed.";
            IPTargetEvent iPTargetEvent = new IPTargetEvent(string7, string8, string9);
            this.publish((SRMEvent)iPTargetEvent);
        } else {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(string, string2, hashtable, hashtable2);
            this.addEntityEventToEventList(string4, (EntityEvent)propertyChangeEvent);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
    }

    public void handleNewLink(String string, String string2) {
        String string3 = "handleNewLink";
        String string4 = DEFAULT_PROC_ID;
        oldAPIUsed = true;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3);
        }
        String string5 = "fromDev";
        String string6 = "toDev";
        NewRelationshipEvent newRelationshipEvent = new NewRelationshipEvent(string, string2, string5, string6);
        this.addEntityEventToEventList(string4, (EntityEvent)newRelationshipEvent);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
    }

    public void handleLinkStateChange(String string, String string2, int n, int n2) {
        String string3 = "handleLinkStateChange";
        String string4 = DEFAULT_PROC_ID;
        oldAPIUsed = true;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3);
        }
        RelationshipStateChangeEvent relationshipStateChangeEvent = new RelationshipStateChangeEvent(string, string2, n, n2);
        this.addEntityEventToEventList(string4, (EntityEvent)relationshipStateChangeEvent);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void handleModelUpdate(String string) {
        Vector vector;
        Hashtable hashtable;
        Vector vector2;
        String string2 = "handleModelUpdate";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)string);
        }
        String string3 = string;
        if (oldAPIUsed) {
            traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string2, "OLD APIs USED!!!!!! NEED CHANGE");
        }
        if (!this.events.isEmpty() && this.eventPro != null) {
            vector2 = new Vector();
            hashtable = this.events;
            synchronized (hashtable) {
                vector = (Vector)this.events.get(string3);
                if (vector != null) {
                    vector2.addAll(vector);
                    this.events.remove(string3);
                }
                this.eventPro.addEventsToProcess(string3, vector2);
            }
        }
        if (!this.devices.isEmpty() && this.snapshotPro != null) {
            vector2 = new Vector();
            hashtable = this.devices;
            synchronized (hashtable) {
                vector = (Vector)this.devices.get(string3);
                if (vector != null) {
                    vector2.addAll(vector);
                    this.devices.remove(string3);
                }
                this.snapshotPro.addDevicesToProcess(vector2);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    public void handleJobStatus(JobInfo jobInfo) {
        String string = jobInfo.getJobId();
        jobInfo.getJobStatus();
        JobEvent jobEvent = new JobEvent(string, "status");
        this.publish((SRMEvent)jobEvent);
        EventHandler.handleEventAlert((SRMEvent)jobEvent);
    }

    public String dispatch(String string, String[] stringArray) {
        String string2 = "dispatch";
        StringBuffer stringBuffer = new StringBuffer();
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, string2);
        }
        boolean bl = false;
        if (string.equalsIgnoreCase("help")) {
            bl = true;
        } else if (string.equalsIgnoreCase("list")) {
            stringBuffer.append(EventFilter.list());
        } else if (string.equalsIgnoreCase("add")) {
            if (stringArray.length == 0) {
                stringBuffer.append(rb.getString("OutbandChangeAgent.InvalidNumParms"));
                bl = true;
            } else if (stringArray[0].equalsIgnoreCase("filter")) {
                stringBuffer.append(EventFilter.addFilter(stringArray));
            } else if (stringArray[0].equalsIgnoreCase("address")) {
                if (stringArray.length > 2 && Integer.parseInt(stringArray[1]) != 0) {
                    stringBuffer.append(EventFilter.addAddress(stringArray));
                } else {
                    stringBuffer.append(rb.getString("OutbandChangeAgent.InvalidNumParms"));
                    bl = true;
                }
            } else {
                stringBuffer.append(rb.getString("OutbandChangeAgent.InvalidCommand"));
                bl = true;
            }
        } else if (string.equalsIgnoreCase("remove")) {
            if (stringArray.length == 0) {
                stringBuffer.append(rb.getString("OutbandChangeAgent.InvalidNumParms"));
                bl = true;
            } else if (stringArray[0].equalsIgnoreCase("filter")) {
                if (stringArray.length == 2 && Integer.parseInt(stringArray[1]) != 0) {
                    stringBuffer.append(EventFilter.removeFilter(stringArray));
                } else {
                    stringBuffer.append(rb.getString("OutbandChangeAgent.InvalidNumParms"));
                    bl = true;
                }
            } else if (stringArray[0].equalsIgnoreCase("address")) {
                if (stringArray.length > 2 && Integer.parseInt(stringArray[1]) != 0) {
                    stringBuffer.append(EventFilter.removeAddress(stringArray));
                } else {
                    stringBuffer.append(rb.getString("OutbandChangeAgent.InvalidNumParms"));
                    bl = true;
                }
            } else {
                stringBuffer.append(rb.getString("OutbandChangeAgent.InvalidCommand"));
                bl = true;
            }
        } else {
            stringBuffer.append(rb.getString("OutbandChangeAgent.InvalidCommand"));
            bl = true;
        }
        if (bl) {
            stringBuffer.append(String.valueOf(rb.getString("OutbandChangeAgent.help")) + "\n" + "list\n" + "add filter [enterprise=<enterprise>] [genericTrap=<number>] [specificTrap=<number>] [<OID>=<value>]*\n" + "add address <ID> <ipAddress>*\n" + "remove filter <ID>\n" + "remove address <ID> <ipAddress>*\n" + "\n");
        }
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, string2);
        }
        return stringBuffer.toString();
    }

    private void testAlerts() {
        String string = "DISCOVERY";
        String string2 = "1000006069101555";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        new HashMap();
        new HashMap();
        new HashMap();
        new HashMap();
        hashMap.put("ACTIVE", "true");
        hashMap.put("ZONE_ID", "1000");
        hashMap.put("ZONE_NAME", "Zone1000");
        hashMap.put("FABRIC_WWN", string2);
        hashMap2.put("ACTIVE", "true");
        hashMap2.put("ZSET_ID", "2000");
        hashMap2.put("ZSET_NAME", "Zoneset2000");
        hashMap2.put("FABRIC_WWN", string2);
        hashMap3.put("ZSET_ID", "2000");
        hashMap3.put("ZONE_ID", "1000");
        hashMap3.put("ZSET2ZONE_ID", "3000");
        this.handleDeviceStateChange(string, Zone.getTablename(), "1000", 1, 0, hashMap);
        this.handleDeviceStateChange(string, Zset.getTablename(), "2000", 1, 0, hashMap2);
        this.handleDeviceStateChange(string, Zset2zone.getTablename(), "3000", 1, 0, hashMap3);
        this.handleNewDevice(string, Fabric2switch.getTablename(), "8400");
        this.handleModelUpdate(string);
    }

    private void testAllSRMEvents(boolean bl) {
        String string = "selfTest";
        String string2 = "test not enabled";
        if (bl) {
            string2 = "test enabled";
        }
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string, (Object)string2);
        }
        if (bl) {
            CIMEvent cIMEvent;
            String[] stringArray;
            JobInfo jobInfo = new JobInfo("1", "JobId123", true);
            this.handleJobStatus(jobInfo);
            String string3 = "CONTROL";
            String string4 = "DISCOVERY";
            this.handleNewDevice(string4, Switch.getTablename(), "5");
            this.handleDeviceStateChange(string3, Switch.getTablename(), "5", 0, 1);
            this.handleNewDevice(string4, Fabric.getTablename(), "5");
            this.handleModelUpdate(string4);
            this.handleDeviceStateChange(string3, StorageSubsystem.getTablename(), "1000", 0, 1);
            this.handleDeviceStateChange(string4, Host.getTablename(), "56", 1, 0);
            this.handleDeviceStateChange(string3, PhyPe.getTablename(), "5100", 0, 1);
            this.handleDevicePropertyChange(string4, Hba.getTablename(), "123", new Hashtable(), new Hashtable());
            this.handleNewDevice(string4, Port2port.getTablename(), "25");
            this.handleDeviceStateChange(string3, Port2port.getTablename(), "30", 0, 1);
            this.handleOperationalStatusChange(string3, Port2port.getTablename(), "30", 0, 1);
            this.handleModelUpdate(string3);
            this.handleOperationalStatusChange(string4, Switch.getTablename(), "30", 1, 0);
            this.handleModelUpdate(string4);
            try {
                stringArray = new SnmpTrap();
                this.postSnmpEvent((SnmpTrap)stringArray);
                cIMEvent = new CIMEvent(new CIMInstance());
                this.postIndicationEvent(cIMEvent);
                InbandEvent inbandEvent = new InbandEvent("inbandAddress", "InbandEvent");
                this.addExternalEvent((ExternalEvent)inbandEvent);
            }
            catch (Exception exception) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
            stringArray = new String[]{"fabric:2", "switch:6", "subsystem:5"};
            cIMEvent = new RemoveMissingProcessor();
            cIMEvent.performDeletionForSelectedMissingEntities(stringArray);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public synchronized void propCallback(String string, String string2, String string3) {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "propCallback", (Object)("name=" + string + ", group=" + string2 + ", value=" + string3));
        }
        if (string2.equals("user") && string.equals("SnmpTrapPort")) {
            this.snmpMonitor.shutdown();
            this.snmpMonitor.initialize();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "propCallback");
        }
    }

    public static void main(String[] stringArray) {
        EventCorrelatorFactory eventCorrelatorFactory = new EventCorrelatorFactory();
        eventCorrelatorFactory.startup();
        System.out.println("Waiting for events");
        while (true) {
            // Infinite loop
        }
    }

    public synchronized void handleNewDevice(String string, String string2, String string3) {
        String string4 = "handleNewDevice";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string4, new Object[]{string, String.valueOf(string2) + string3});
        }
        String string5 = this.getDeviceTypeByTableName(string2);
        String string6 = string3;
        if (string5 == null) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string4, "No deviceType mapping for table " + string2);
            }
        } else if (this.isLinkType(string5)) {
            NewRelationshipEvent newRelationshipEvent = new NewRelationshipEvent(string5, string6);
            this.addEntityEventToEventList(string, (EntityEvent)newRelationshipEvent);
        } else {
            this.addDeviceToSnapshotList(string, string5, string6);
            if (string5.equals("cimom")) {
                try {
                    RegisteredCimom registeredCimom = EventDBAccessor.getCIMOMByID(string6);
                    DataSource dataSource = new DataSource(1, registeredCimom);
                    this.cimMonitor.addDataSource(dataSource);
                    String string7 = registeredCimom.getServiceUrl();
                    int n = this.getPortNumber(string7);
                    String string8 = "New CIMOM discovered";
                    CIMOMEvent cIMOMEvent = new CIMOMEvent(string7, n, string8);
                    this.publish((SRMEvent)cIMOMEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (string5.equals("iptarget")) {
                String string9 = string5;
                String string10 = string6;
                String string11 = AgentEvent.ADDED;
                IPTargetEvent iPTargetEvent = new IPTargetEvent(string9, string10, string11);
                this.publish((SRMEvent)iPTargetEvent);
            } else if (string5.equals("agent")) {
                String string12 = string6;
                String string13 = null;
                int n = this.getPortNumber(string13);
                String string14 = AgentEvent.ADDED;
                DiskMgrAgentEvent diskMgrAgentEvent = new DiskMgrAgentEvent(string12, n, string14);
                this.publish((SRMEvent)diskMgrAgentEvent);
            } else {
                NewDeviceEvent newDeviceEvent = new NewDeviceEvent(string5, string6);
                this.addEntityEventToEventList(string, (EntityEvent)newDeviceEvent);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
    }

    public synchronized void handleDeviceStateChange(String string, String string2, String string3, int n, int n2) {
        String string4;
        block17: {
            string4 = "handleDeviceStateChange";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string4, new Object[]{string, String.valueOf(string2) + string3});
            }
            String string5 = this.getDeviceTypeByTableName(string2);
            String string6 = string3;
            if (this.isLinkType(string5)) {
                RelationshipStateChangeEvent relationshipStateChangeEvent = new RelationshipStateChangeEvent(string5, string6, n, n2);
                this.addEntityEventToEventList(string, (EntityEvent)relationshipStateChangeEvent);
            } else {
                this.addDeviceToSnapshotList(string, string5, string6);
                if (string5.equals("cimom")) {
                    try {
                        RegisteredCimom registeredCimom = EventDBAccessor.getCIMOMByID(string6);
                        DataSource dataSource = new DataSource(1, registeredCimom);
                        if (n2 == 1) {
                            this.cimMonitor.addDataSource(dataSource);
                            String string7 = registeredCimom.getServiceUrl();
                            int n3 = this.getPortNumber(string7);
                            String string8 = "Missing CIMOM changed to normal";
                            CIMOMEvent cIMOMEvent = new CIMOMEvent(string7, n3, string8);
                            this.publish((SRMEvent)cIMOMEvent);
                            break block17;
                        }
                        this.cimMonitor.removeDataSource(dataSource);
                        this.deleteIndicationSource(dataSource);
                        String string9 = registeredCimom.getServiceUrl();
                        int n4 = this.getPortNumber(string9);
                        String string10 = "Normal CIMOM changed to missing";
                        CIMOMEvent cIMOMEvent = new CIMOMEvent(string9, n4, string10);
                        this.publish((SRMEvent)cIMOMEvent);
                    }
                    catch (Exception exception) {}
                } else if (string5.equals("iptarget")) {
                    if (n2 == 1) {
                        String string11 = string5;
                        String string12 = string6;
                        String string13 = AgentEvent.ACTIVE;
                        IPTargetEvent iPTargetEvent = new IPTargetEvent(string11, string12, string13);
                        this.publish((SRMEvent)iPTargetEvent);
                    } else {
                        String string14 = string5;
                        String string15 = string6;
                        String string16 = AgentEvent.REMOVED;
                        IPTargetEvent iPTargetEvent = new IPTargetEvent(string14, string15, string16);
                        this.publish((SRMEvent)iPTargetEvent);
                    }
                } else if (string5.equals("agent")) {
                    if (n2 == 1) {
                        String string17 = string6;
                        String string18 = null;
                        int n5 = this.getPortNumber(string18);
                        String string19 = AgentEvent.ACTIVE;
                        DiskMgrAgentEvent diskMgrAgentEvent = new DiskMgrAgentEvent(string17, n5, string19);
                        this.publish((SRMEvent)diskMgrAgentEvent);
                    } else {
                        String string20 = string6;
                        String string21 = null;
                        int n6 = this.getPortNumber(string21);
                        String string22 = AgentEvent.INACTIVE;
                        DiskMgrAgentEvent diskMgrAgentEvent = new DiskMgrAgentEvent(string20, n6, string22);
                        this.publish((SRMEvent)diskMgrAgentEvent);
                    }
                } else {
                    DeviceStateChangeEvent deviceStateChangeEvent = new DeviceStateChangeEvent(string5, string6, n, n2);
                    this.addEntityEventToEventList(string, (EntityEvent)deviceStateChangeEvent);
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
    }

    public synchronized void handleDevicePropertyChange(String string, String string2, String string3, Hashtable hashtable, Hashtable hashtable2) {
        String string4 = "handleDevicePropertyChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string4, new Object[]{string, String.valueOf(string2) + string3});
        }
        String string5 = this.getDeviceTypeByTableName(string2);
        String string6 = string3;
        this.addDeviceToSnapshotList(string, string5, string6);
        if (string5.equals("cimom")) {
            try {
                RegisteredCimom registeredCimom = EventDBAccessor.getCIMOMByID(string6);
                DataSource dataSource = new DataSource(1, registeredCimom);
                this.cimMonitor.addDataSource(dataSource);
                String string7 = registeredCimom.getServiceUrl();
                int n = this.getPortNumber(string7);
                String string8 = "CIMOM Property changed.";
                CIMOMEvent cIMOMEvent = new CIMOMEvent(string7, n, string8);
                this.publish((SRMEvent)cIMOMEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (string5.equals("iptarget")) {
            String string9 = string5;
            String string10 = string6;
            String string11 = AgentEvent.MODIFIED;
            IPTargetEvent iPTargetEvent = new IPTargetEvent(string9, string10, string11);
            this.publish((SRMEvent)iPTargetEvent);
        } else if (string5.equals("agent")) {
            String string12 = string6;
            String string13 = null;
            int n = this.getPortNumber(string13);
            String string14 = AgentEvent.MODIFIED;
            DiskMgrAgentEvent diskMgrAgentEvent = new DiskMgrAgentEvent(string12, n, string14);
            this.publish((SRMEvent)diskMgrAgentEvent);
        } else {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(string5, string6, hashtable, hashtable2);
            this.addEntityEventToEventList(string, (EntityEvent)propertyChangeEvent);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
    }

    public synchronized void handleOperationalStatusChange(String string, String string2, String string3, int n, int n2) {
        String string4 = "handleOperationalStatusChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string4, new Object[]{string, String.valueOf(string2) + string3});
        }
        String string5 = this.getDeviceTypeByTableName(string2);
        String string6 = string3;
        DeviceOperationalStatusChangeEvent deviceOperationalStatusChangeEvent = new DeviceOperationalStatusChangeEvent(string5, string6, n, n2);
        this.addEntityEventToEventList(string, (EntityEvent)deviceOperationalStatusChangeEvent);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
    }

    private int getPortNumber(String string) {
        int n = 9999;
        if (string != null) {
            try {
                int n2 = string.lastIndexOf(":");
                String string2 = string.substring(n2 + 1);
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    private String getDeviceTypeByTableName(String string) {
        return (String)tableToEntityTypeMapping.get(string);
    }

    private boolean isLinkType(String string) {
        boolean bl = false;
        if (string.equals("fabric2switch") || string.equals("switch2port") || string.equals("pe2node") || string.equals("node2hba") || string.equals("port2port") || string.equals("zset2zone") || string.equals("zone2member") || string.equals("zone2alias") || string.equals("alias2member")) {
            bl = true;
        }
        return bl;
    }

    static void initTableNameToDeviceTypeMap() {
        tableToEntityTypeMapping.put(Fabric.getTablename(), "fabric");
        tableToEntityTypeMapping.put(Host.getTablename(), "host");
        tableToEntityTypeMapping.put(Server.getTablename(), "server");
        tableToEntityTypeMapping.put(Switch.getTablename(), "switch");
        tableToEntityTypeMapping.put(Node.getTablename(), "node");
        tableToEntityTypeMapping.put(Port.getTablename(), "port");
        tableToEntityTypeMapping.put(SwitchBlade.getTablename(), "blade");
        tableToEntityTypeMapping.put(PhyPe.getTablename(), "pe");
        tableToEntityTypeMapping.put(Hba.getTablename(), "hba");
        tableToEntityTypeMapping.put(Zone.getTablename(), "zone");
        tableToEntityTypeMapping.put(Zset.getTablename(), "zset");
        tableToEntityTypeMapping.put(ZoneMember.getTablename(), "zonemember");
        tableToEntityTypeMapping.put(Alias.getTablename(), "zonealias");
        tableToEntityTypeMapping.put(StorageSubsystem.getTablename(), "subsystem");
        tableToEntityTypeMapping.put(DataPath.getTablename(), "datapath");
        tableToEntityTypeMapping.put(StoragePool.getTablename(), "storagepool");
        tableToEntityTypeMapping.put(StorageVolume.getTablename(), "storagevolume");
        tableToEntityTypeMapping.put(RegisteredCimom.getTablename(), "cimom");
        tableToEntityTypeMapping.put(Disk.getTablename(), "disk");
        tableToEntityTypeMapping.put(BackendController.getTablename(), "tape");
        tableToEntityTypeMapping.put(TapeDrive.getTablename(), "tapedrive");
        tableToEntityTypeMapping.put(TapeLibrary.getTablename(), "tapelibrary");
        tableToEntityTypeMapping.put(TapeMediaChanger.getTablename(), "tapemediachanger");
        tableToEntityTypeMapping.put(Fabric2switch.getTablename(), "fabric2switch");
        tableToEntityTypeMapping.put(Switch2port.getTablename(), "switch2port");
        tableToEntityTypeMapping.put(Node2hba.getTablename(), "node2hba");
        tableToEntityTypeMapping.put(Pe2node.getTablename(), "pe2node");
        tableToEntityTypeMapping.put(Port2port.getTablename(), "port2port");
        tableToEntityTypeMapping.put(Zset2zone.getTablename(), "zset2zone");
        tableToEntityTypeMapping.put(Zone2member.getTablename(), "zone2member");
        tableToEntityTypeMapping.put(Alias2member.getTablename(), "alias2member");
        tableToEntityTypeMapping.put(Zone2alias.getTablename(), "zone2alias");
        tableToEntityTypeMapping.put(PhysicalVolume.getTablename(), "physicalvolume");
        tableToEntityTypeMapping.put(DiskGroup.getTablename(), "diskgroup");
        tableToEntityTypeMapping.put(StorageExtent.getTablename(), "storageextent");
        tableToEntityTypeMapping.put(Redundancy.getTablename(), "svcnode");
        tableToEntityTypeMapping.put(IpTarget.getTablename(), "iptarget");
        tableToEntityTypeMapping.put(Agent.getTablename(), "agent");
        tableToEntityTypeMapping.put(DeviceAgent.getTablename(), "agent");
    }

    static void initDeviceTypeToAlertPopulatorMap() {
        devAlertPopulators.put("switch", new SwitchAlertPopulator());
        devAlertPopulators.put("blade", new SwitchBladeAlertPopulator());
        devAlertPopulators.put("host", new HostAlertPopulator());
        devAlertPopulators.put("hba", new HbaAlertPopulator());
        devAlertPopulators.put("pe", new PerEntAlertPopulator());
        devAlertPopulators.put("node", new NodeAlertPopulator());
        devAlertPopulators.put("port", new FabricPortAlertPopulator());
        devAlertPopulators.put("fabric2switch", new Fabric2SwitchAlertPopulator());
        devAlertPopulators.put("switch2port", new Switch2PortAlertPopulator());
        devAlertPopulators.put("pe2node", new Pe2NodeAlertPopulator());
        devAlertPopulators.put("node2hba", new Hba2NodeAlertPopulator());
        devAlertPopulators.put("port2port", new Port2PortAlertPopulator());
        devAlertPopulators.put("fabric", new FabricAlertPopulator());
        devAlertPopulators.put("zone", new ZoneAlertPopulator());
        devAlertPopulators.put("zset", new ZonesetAlertPopulator());
        devAlertPopulators.put("zonemember", new ZoneMemberAlertPopulator());
        devAlertPopulators.put("zonealias", new ZoneAliasAlertPopulator());
        devAlertPopulators.put("zone2member", new Zone2MemberAlertPopulator());
        devAlertPopulators.put("zone2alias", new Zone2AliasAlertPopulator());
        devAlertPopulators.put("zset2zone", new Zset2ZoneAlertPopulator());
        devAlertPopulators.put("physicalvolume", new DiskDriveAlertPopulator());
        devAlertPopulators.put("diskgroup", new DiskGroupAlertPopulator());
        devAlertPopulators.put("storageextent", new ExtentAlertPopulator());
        devAlertPopulators.put("storagepool", new PoolAlertPopulator());
        devAlertPopulators.put("subsystem", new StorageSystemAlertPopulator());
        devAlertPopulators.put("storagevolume", new VolumeAlertPopulator());
        devAlertPopulators.put("datapath", new DataPathAlertPopulator());
        devAlertPopulators.put("svcnode", new SVCNodeAlertPopulator());
    }

    private boolean isAutoDeletedType(String string) {
        boolean bl = false;
        if (string.equals("zone") || string.equals("zset") || string.equals("zonemember") || string.equals("zonealias") || string.equals("zset2zone") || string.equals("zone2member") || string.equals("zone2alias") || string.equals("alias2member") || string.equals("datapath")) {
            bl = true;
        }
        return bl;
    }

    public synchronized void handleDeviceStateChange(String string, String string2, String string3, int n, int n2, HashMap hashMap) {
        String string4;
        block19: {
            string4 = "handleDeviceStateChange";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string4, new Object[]{string, String.valueOf(string2) + string3});
            }
            String string5 = this.getDeviceTypeByTableName(string2);
            String string6 = string3;
            if (this.isLinkType(string5)) {
                RelationshipStateChangeEvent relationshipStateChangeEvent = new RelationshipStateChangeEvent(string5, string6, n, n2);
                if (this.isAutoDeletedType(string5)) {
                    relationshipStateChangeEvent.setAttributeMap(hashMap);
                }
                this.addEntityEventToEventList(string, (EntityEvent)relationshipStateChangeEvent);
            } else {
                this.addDeviceToSnapshotList(string, string5, string6);
                if (string5.equals("cimom")) {
                    try {
                        RegisteredCimom registeredCimom = EventDBAccessor.getCIMOMByID(string6);
                        DataSource dataSource = new DataSource(1, registeredCimom);
                        if (n2 == 1) {
                            this.cimMonitor.addDataSource(dataSource);
                            String string7 = registeredCimom.getServiceUrl();
                            int n3 = this.getPortNumber(string7);
                            String string8 = "Missing CIMOM changed to normal";
                            CIMOMEvent cIMOMEvent = new CIMOMEvent(string7, n3, string8);
                            this.publish((SRMEvent)cIMOMEvent);
                            break block19;
                        }
                        this.cimMonitor.removeDataSource(dataSource);
                        this.deleteIndicationSource(dataSource);
                        String string9 = registeredCimom.getServiceUrl();
                        int n4 = this.getPortNumber(string9);
                        String string10 = "Normal CIMOM changed to missing";
                        CIMOMEvent cIMOMEvent = new CIMOMEvent(string9, n4, string10);
                        this.publish((SRMEvent)cIMOMEvent);
                    }
                    catch (Exception exception) {}
                } else if (string5.equals("iptarget")) {
                    if (n2 == 1) {
                        String string11 = string5;
                        String string12 = string6;
                        String string13 = AgentEvent.ACTIVE;
                        IPTargetEvent iPTargetEvent = new IPTargetEvent(string11, string12, string13);
                        this.publish((SRMEvent)iPTargetEvent);
                    } else {
                        String string14 = string5;
                        String string15 = string6;
                        String string16 = AgentEvent.REMOVED;
                        IPTargetEvent iPTargetEvent = new IPTargetEvent(string14, string15, string16);
                        this.publish((SRMEvent)iPTargetEvent);
                    }
                } else if (string5.equals("agent")) {
                    if (n2 == 1) {
                        String string17 = string6;
                        String string18 = null;
                        int n5 = this.getPortNumber(string18);
                        String string19 = AgentEvent.ACTIVE;
                        DiskMgrAgentEvent diskMgrAgentEvent = new DiskMgrAgentEvent(string17, n5, string19);
                        this.publish((SRMEvent)diskMgrAgentEvent);
                    } else {
                        String string20 = string6;
                        String string21 = null;
                        int n6 = this.getPortNumber(string21);
                        String string22 = AgentEvent.INACTIVE;
                        DiskMgrAgentEvent diskMgrAgentEvent = new DiskMgrAgentEvent(string20, n6, string22);
                        this.publish((SRMEvent)diskMgrAgentEvent);
                    }
                } else {
                    DeviceStateChangeEvent deviceStateChangeEvent = new DeviceStateChangeEvent(string5, string6, n, n2);
                    if (this.isAutoDeletedType(string5)) {
                        deviceStateChangeEvent.setAttributeMap(hashMap);
                    }
                    this.addEntityEventToEventList(string, (EntityEvent)deviceStateChangeEvent);
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
    }

    public synchronized void handleDeletedDevice(String string, String string2, HashMap hashMap) {
        String string3 = "handleDeletedDevice";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3, new Object[]{string, string2});
        }
        String string4 = EventCorrelatorFactory.determineIdName(string2);
        String string5 = "-1";
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        if (string4 != null) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string6 = (String)iterator.next();
                String string7 = "";
                Object v = hashMap.get(string6);
                if (v != null) {
                    string7 = v.toString();
                }
                if (string6.equals(string4)) {
                    string5 = string7;
                }
                hashMap2.put(string6, string7);
            }
            int n = 1;
            int n2 = 0;
            this.handleDeviceStateChange(string, string2, string5, n, n2, hashMap2);
        } else {
            traceLogger.text(IRecordType.TYPE_WARN, (Object)this, string3, "Alerts process not supported for " + string2);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3, (Object)string5);
        }
    }

    private static String determineIdName(String string) {
        String string2 = null;
        if (string.equals(Zone.getTablename())) {
            string2 = "ZONE_ID";
        } else if (string.equals(Zset.getTablename())) {
            string2 = "ZSET_ID";
        } else if (string.equals(Zset2zone.getTablename())) {
            string2 = "ZSET2ZONE_ID";
        } else if (string.equals(Zone2alias.getTablename())) {
            string2 = "ZONE2ALIAS_ID";
        } else if (string.equals(Zone2member.getTablename())) {
            string2 = "ZONE2MEMBER_ID";
        } else if (string.equals(Alias.getTablename())) {
            string2 = "ALIAS_ID";
        } else if (string.equals(ZoneMember.getTablename())) {
            string2 = "ZONE_MEMBER_ID";
        } else if (string.equals(DataPath.getTablename())) {
            string2 = "DATA_PATH_ID";
        } else if (string.equals(Redundancy.getTablename())) {
            string2 = "REDUNDANCY_ID";
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndicationSource(CIMOM cIMOM, Integer n) {
        Map map = this.indicationSources;
        synchronized (map) {
            this.indicationSources.put(cIMOM.getServiceUrl(), n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getIndicationSourceType(CIMOM cIMOM) {
        Object object = this.indicationSources;
        synchronized (object) {
            if (this.indicationSources.containsKey(cIMOM.getServiceUrl())) {
                return (Integer)this.indicationSources.get(cIMOM.getServiceUrl());
            }
        }
        try {
            object = EventCorrelatorDBHelper.determineCimomType(cIMOM);
            if (object != IS_NOTHING) {
                this.addIndicationSource(cIMOM, (Integer)object);
            }
            return object;
        }
        catch (SQLException sQLException) {
            return IS_NOTHING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteIndicationSource(DataSource dataSource) {
        if (dataSource.getType() == 1) {
            RegisteredCimom registeredCimom = (RegisteredCimom)dataSource.getIdentifier();
            Map map = this.indicationSources;
            synchronized (map) {
                this.indicationSources.remove(registeredCimom.getServiceUrl());
            }
        }
    }
}

