/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager;

import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.TopicSubscriber;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.monitor.MonitorActivator;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.ICallback;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.Messages;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.ActiveAgentListImpl;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentBuilder;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentHeartbeatMonitor;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentListImpl;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentRegistrationListener;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableReader;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableUpdater;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.HostManager;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.TdmAgentBuilder;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.TdmAgentListImpl;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.Agent;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.TdmAgent;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.interfaces.AgentConstants;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.interfaces.ISANDiskMgrHostService;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.AuthorizationException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.Event;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.LogTrace;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.LogWrapper;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.RemoveActiveAgentException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.TdmException;
import org.eclipse.aperi.sanmgmt.event.data.SANEventExceptionHandler;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.middleware.data.CliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.sanmgmt.middleware.messaging.Factory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.FactoryFactory;
import org.eclipse.aperi.sanmgmt.subagent.common.HostQueryInfo;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.data.OID;

public final class SANDiskMgrHostService
implements ISANDiskMgrHostService,
IService,
ICliDispatcher,
ICallback {
    static final String className;
    static final String MESSAGE_NAME = "aperi.logger.message.HostMgr";
    static final String TRACE_NAME = "aperi.logger.trace.HostMgr";
    static final String BUNDLENAME = "org.eclipse.aperi.sanmgmt.diskmgr.hostservice.Messages";
    static final String TEXT_BUNDLENAME = "org.eclipse.aperi.sanmgmt.diskmgr.hostservice.Texts";
    private ResourceBundle rb = null;
    protected static Factory factory;
    private AgentHeartbeatMonitor _agentHeartbeatThread = null;
    private Map hostMap = null;
    private AgentRegistrationListener agent_reg = null;
    public static long sysUpTime;
    static LogTrace logs;
    static LogWrapper trace;
    static LogWrapper messages;
    static final String MINIMUM_HOSTQUERY_VERSION = "1.1.0";
    static final String MINIMUM_HOSTSERVICE_VERSION = "1.1.0";
    static final String MINIMUM_SANMANAGER_VERSION = "1.1.0";
    static final String MINIMUM_SANDBPARMS_VERSION = "1.1.0";
    private Status status = new Status(5, 3);
    private OID oid = null;
    private SnmpTrap myTrap = null;
    private String message = null;
    private String sev = null;
    private String description = null;
    private String messageID = null;
    private boolean _healthy = true;
    private static ResourceBundle resources;
    private TopicSubscriber _agentRegistrationSubscriber = null;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.SANDiskMgrHostService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        factory = null;
        sysUpTime = System.currentTimeMillis();
        logs = null;
        trace = null;
        messages = null;
        resources = null;
        try {
            logs = new LogTrace(MESSAGE_NAME, BUNDLENAME, TRACE_NAME);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        messages = SANDiskMgrHostService.logs.messages;
        trace = SANDiskMgrHostService.logs.trace;
    }

    public String dispatch(String string, String[] stringArray) {
        return CliDispatcher.dispatch((Object)this, (String)string, (String[])stringArray);
    }

    public SANDiskMgrHostService() {
        Locale locale = Locale.getDefault();
        this.rb = ResourceBundle.getBundle(TEXT_BUNDLENAME, locale);
    }

    public boolean startup() {
        block7: {
            if (trace.isLogging()) {
                trace.entry((Object)this, "startup");
            }
            try {
                this.status.setRunStatus(9);
                IConfigService iConfigService = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService");
                String string = iConfigService.getProperty("hostPollingInterval", "user");
                factory = FactoryFactory.createFactory((int)2, null);
                factory.setExceptionListener((ExceptionListener)new SANEventExceptionHandler());
                this.hostMap = TdmAgentListImpl.bldTdmHostMap();
                this.agent_reg = new AgentRegistrationListener(this.hostMap);
                this._agentHeartbeatThread = new AgentHeartbeatMonitor(string, this.hostMap);
                this._agentHeartbeatThread.setDaemon(true);
                this._agentHeartbeatThread.start();
                String string2 = iConfigService.getProperty("manager.loc", "setup");
                String string3 = iConfigService.getProperty("manager.port", "setup");
                iConfigService.register("hostPollingInterval", "user", String.valueOf(string2) + ":" + string3, "SANHostMgr");
                trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "startup", "Registered with " + string2 + "  " + string3 + "  " + "hostPollingInterval" + "  " + "user" + "  " + "SANHostMgr");
                this.description = "Fabric Manager SAN Disk Manager Host Service has started.";
                this.messageID = SANDiskMgrHostService.getMessageId("BTSserviceStartup");
                this.oid = new OID("1.3.6.1.4.1.2.6.173.5.1");
                this.myTrap = Event.createServiceSnmpTrap(sysUpTime, this.oid, 1, this.description, this.messageID, "Common", logs);
                if (this.myTrap != null) {
                    Event.fireSNMPEvent("publisherID", "org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.uniquename", this.myTrap, logs);
                }
                this.message = this.rb.getString("startup");
                this.sev = "HARMLESS";
                if (trace.isLogging()) {
                    trace.text(IRecordType.TYPE_MISC_DATA, (Object)className, "startup", "TEC Message: " + this.message);
                }
                Event.fireTECEvent("publisherID", "org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.uniquename", "Common", this.getName(), this.messageID, this.message, this.sev, logs);
                this.fireDiskMgrHostServiceEvent("STARTED");
                messages.message(IRecordType.TYPE_INFO, (Object)this, "startup", "BTSserviceStartup", (Object)this.getName());
                this.getMonitorThreadStatus();
                if (trace.isLogging()) {
                    trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "startup", String.valueOf(this.getName()) + " started ...");
                }
            }
            catch (Exception exception) {
                if (!trace.isLogging()) break block7;
                trace.exception((Object)this, "startup", (Throwable)exception);
            }
        }
        this.status.setRunStatus(8);
        if (trace.isLogging()) {
            trace.exit((Object)this, "startup");
        }
        return true;
    }

    public boolean shutdown() {
        block10: {
            block9: {
                if (trace.isLogging()) {
                    trace.entry((Object)this, "shutdown");
                }
                IConfigService iConfigService = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService");
                String string = iConfigService.getProperty("manager.loc", "setup");
                String string2 = iConfigService.getProperty("manager.port", "setup");
                iConfigService.deRegister("hostPollingInterval", "user", String.valueOf(string) + ":" + string2, "SANHostMgr");
                trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "shutdown", "Deregistered hostPollingInterval property change");
                this.status.setRunStatus(11);
                this.getMonitorThreadStatus();
                this._agentHeartbeatThread.safeStop();
                try {
                    this._agentHeartbeatThread.join();
                }
                catch (InterruptedException interruptedException) {
                    messages.exception((Object)this, "shutdown", (Throwable)interruptedException);
                    if (!trace.isLogging()) break block9;
                    trace.exception((Object)this, "shutdown", (Throwable)interruptedException);
                }
            }
            this.description = "Fabric Manager SAN Disk Manager Host Service is shutting down.";
            this.messageID = SANDiskMgrHostService.getMessageId("BTSserviceShutdown");
            this.oid = new OID("1.3.6.1.4.1.2.6.173.5.2");
            this.myTrap = Event.createServiceSnmpTrap(sysUpTime, this.oid, 2, this.description, this.messageID, "Common", logs);
            if (this.myTrap != null) {
                Event.fireSNMPEvent("publisherID", "org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.uniquename", this.myTrap, logs);
            }
            this.message = this.rb.getString("shutdown");
            if (trace.isLogging()) {
                trace.text(IRecordType.TYPE_MISC_DATA, (Object)className, "shutdown", "TEC Message: " + this.message);
            }
            this.sev = "HARMLESS";
            Event.fireTECEvent("publisherID", "org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.uniquename", "Common", this.getName(), this.messageID, this.message, this.sev, logs);
            this.fireDiskMgrHostServiceEvent("SHUTDOWN");
            try {
                if (factory != null) {
                    factory.close();
                }
            }
            catch (JMSException jMSException) {
                messages.exception((Object)className, "shutdown", (Throwable)jMSException);
                if (!trace.isLogging()) break block10;
                trace.exception((Object)className, "shutdown", (Throwable)jMSException);
            }
        }
        messages.message(IRecordType.TYPE_INFO, (Object)this, "shutdown", "BTSserviceShutdown", (Object)this.getName());
        this.status.setRunStatus(10);
        if (trace.isLogging()) {
            trace.exit((Object)this, "shutdown");
        }
        return true;
    }

    public String getName() {
        String string = "SANHostMgr";
        return string;
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("SANHostMgr_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("SANHostMgr_Description");
    }

    public Status getStatus() {
        return this.status;
    }

    public String getVersion() {
        return "5.0.0";
    }

    public String getDescription() {
        return "Maintains the list of managed hosts";
    }

    public boolean isCompatibleVersion(String string) {
        return true;
    }

    public boolean isAlive() {
        return this._healthy;
    }

    public void setPrimary(Object object) {
    }

    static ISANDiskMgrHostService getSANDiskMgrHostService() {
        return (ISANDiskMgrHostService)MonitorActivator._serviceHelper.bindLocal("SANHostMgr");
    }

    static Factory getFactory() {
        return factory;
    }

    protected static String getMessageId(String string) {
        Messages messages = new Messages();
        String string2 = String.valueOf((String)messages.handleGetObject(string)) + ' ';
        return string2.substring(0, string2.indexOf(32));
    }

    static String getString(String string, Object[] objectArray) {
        Object object;
        if (resources == null) {
            object = Locale.getDefault();
            resources = ResourceBundle.getBundle(BUNDLENAME, (Locale)object);
        }
        object = resources.getString(string);
        MessageFormat messageFormat = new MessageFormat((String)object);
        String string2 = messageFormat.format(objectArray);
        return string2;
    }

    public synchronized void propCallback(String string, String string2, String string3) {
        if (trace.isLogging()) {
            trace.entry((Object)IRecordType.TYPE_ENTRY, className, (Object)"propCallback", (Object)("name=" + string + ", group=" + string2 + ", value=" + string3));
        }
        if (string2.equals("user") && string.equals("hostPollingInterval")) {
            this._agentHeartbeatThread.setHeartbeatInterval(string3);
        }
        if (trace.isLogging()) {
            trace.exit((Object)this, "propCallback");
        }
    }

    public void agentHeartbeat(HostQueryInfo hostQueryInfo) {
        this.agent_reg.agentRegistrationHeartbeat(hostQueryInfo);
    }

    public String getMonitorThreadStatus() {
        String string = " ";
        try {
            boolean bl = false;
            boolean bl2 = false;
            string = String.valueOf(string) + this._agentHeartbeatThread.toString();
            bl = this._agentHeartbeatThread.isAlive();
            string = bl ? String.valueOf(string) + " alive = true " : String.valueOf(string) + " alive = false ";
            bl2 = AgentHeartbeatMonitor.interrupted();
            string = bl2 ? String.valueOf(string) + " interrupted = true " : String.valueOf(string) + " interrupted = false ";
        }
        catch (Exception exception) {
            messages.exception((Object)this, "monitorThreadStatus", (Throwable)exception);
            if (trace.isLogging()) {
                trace.exception((Object)this, "monitorThreadStatus", (Throwable)exception);
            }
            string = String.valueOf(string) + " Error: " + exception.toString();
        }
        trace.text(IRecordType.TYPE_ERROR, (Object)this, "monitorThreadStatus", string);
        return string;
    }

    public String GetAgent(GUID gUID, int n) {
        try {
            Agent agent = this.getAgent(gUID, n);
            return agent.toString();
        }
        catch (TdmException tdmException) {
            return tdmException.toString();
        }
    }

    public Agent getAgent(GUID gUID, int n) throws TdmException {
        try {
            return AgentBuilder.getHost(gUID, n);
        }
        catch (TdmException tdmException) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getAgent", "Agent_Error", (Object)tdmException.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getAgent", (Throwable)tdmException);
            }
            throw tdmException;
        }
        catch (RuntimeException runtimeException) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getAgent", "Agent_Error", (Object)runtimeException.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getAgent", (Throwable)runtimeException);
            }
            throw runtimeException;
        }
    }

    public String GetAgentList() {
        try {
            Agent[] agentArray = this.getAgentList();
            String string = "";
            int n = 0;
            while (n < agentArray.length) {
                string = String.valueOf(string) + agentArray[n].agentName + agentArray[n].getUniqueAgentName() + "\n";
                ++n;
            }
            return string;
        }
        catch (TdmException tdmException) {
            return tdmException.toString();
        }
    }

    public Agent[] getAgentList() throws TdmException {
        try {
            return AgentListImpl.getHostList();
        }
        catch (TdmException tdmException) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getAgentList", "Agent_Error", (Object)tdmException.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getAgentList", (Throwable)tdmException);
            }
            throw tdmException;
        }
        catch (RuntimeException runtimeException) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getAgentList", "Agent_Error", (Object)runtimeException.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getAgentList", (Throwable)runtimeException);
            }
            throw runtimeException;
        }
    }

    public String GetActiveAgentList() {
        try {
            Agent[] agentArray = this.getActiveAgentList();
            String string = "";
            int n = 0;
            while (n < agentArray.length) {
                string = String.valueOf(string) + agentArray[n].toString() + "\n";
                ++n;
            }
            return string;
        }
        catch (TdmException tdmException) {
            return tdmException.toString();
        }
    }

    public Agent[] getActiveAgentList() throws TdmException {
        try {
            return ActiveAgentListImpl.getActiveHostList();
        }
        catch (TdmException tdmException) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getActiveAgentList", "Agent_Error", (Object)tdmException.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getActiveAgentList", (Throwable)tdmException);
            }
            throw tdmException;
        }
        catch (RuntimeException runtimeException) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getActiveAgentList", "Agent_Error", (Object)runtimeException.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getActiveAgentList", (Throwable)runtimeException);
            }
            throw runtimeException;
        }
    }

    public String GetTdmAgent(GUID gUID, int n) {
        try {
            TdmAgent tdmAgent = this.getTdmAgent(gUID, n);
            return tdmAgent.toString();
        }
        catch (TdmException tdmException) {
            return tdmException.toString();
        }
    }

    public TdmAgent getTdmAgent(GUID gUID, int n) throws TdmException {
        try {
            return TdmAgentBuilder.getTdmHost(gUID, n);
        }
        catch (TdmException tdmException) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getTdmAgent", "Agent_Error", (Object)tdmException.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getTdmAgent", (Throwable)tdmException);
            }
            throw tdmException;
        }
        catch (RuntimeException runtimeException) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getTdmAgent", "Agent_Error", (Object)runtimeException.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getTdmAgent", (Throwable)runtimeException);
            }
            throw runtimeException;
        }
    }

    public String GetTdmAgentList() {
        try {
            TdmAgent[] tdmAgentArray = this.getTdmAgentList();
            String string = "";
            int n = 0;
            while (n < tdmAgentArray.length) {
                string = String.valueOf(string) + "\n" + tdmAgentArray[n].agentName + " " + tdmAgentArray[n].getUniqueAgentName() + " " + tdmAgentArray[n].status + "\n";
                ++n;
            }
            return string;
        }
        catch (TdmException tdmException) {
            return tdmException.toString();
        }
    }

    public TdmAgent[] getTdmAgentList() throws TdmException {
        try {
            return TdmAgentListImpl.getTdmHostList();
        }
        catch (TdmException tdmException) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getTdmAgentList", "Agent_Error", (Object)tdmException.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getTdmAgentList", (Throwable)tdmException);
            }
            throw tdmException;
        }
        catch (RuntimeException runtimeException) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getTdmAgentList", "Agent_Error", (Object)runtimeException.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getTdmAgentList", (Throwable)runtimeException);
            }
            throw runtimeException;
        }
    }

    public String RemoveInactiveAgent(GUID gUID, int n) {
        try {
            this.removeInactiveAgent(gUID, n);
            return "Removed " + gUID + ":" + n;
        }
        catch (TdmException tdmException) {
            return tdmException.toString();
        }
    }

    public void removeInactiveAgent(GUID gUID, int n) throws TdmException {
        this.hostMap.remove(gUID + ":" + n);
        try {
            HostManager.removeInactiveHost(gUID, n);
        }
        catch (RemoveActiveAgentException removeActiveAgentException) {
            if (trace.isLogging()) {
                trace.exception((Object)this, "SANDiskMgrHostService:removeInactiveAgent", (Throwable)((Object)removeActiveAgentException));
            }
            throw removeActiveAgentException;
        }
        catch (TdmException tdmException) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "SANDiskMgrHostService:removeInactiveAgent", "Agent_Error", (Object)tdmException.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "SANDiskMgrHostService:removeInactiveAgent", (Throwable)tdmException);
            }
            throw tdmException;
        }
        catch (RuntimeException runtimeException) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "SANDiskMgrHostService:removeInactiveAgent", "Agent_Error", (Object)runtimeException.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "SANDiskMgrHostService:removeInactiveAgent", (Throwable)runtimeException);
            }
            throw runtimeException;
        }
    }

    public String GetPolicyDomainIDFromAgent(GUID gUID, int n) throws TdmException {
        try {
            return new Integer(this.getPolicyDomainIDFromAgent(gUID, n)).toString();
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }

    public int getPolicyDomainIDFromAgent(GUID gUID, int n) throws TdmException {
        try {
            return HostManager.getPolicyDomainIDFromAgent(gUID, n);
        }
        catch (TdmException tdmException) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getPolicyDomainIDFromAgent", "Agent_Error", (Object)tdmException.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getPolicyDomainIDFromAgent", (Throwable)tdmException);
            }
            throw tdmException;
        }
        catch (RuntimeException runtimeException) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getPolicyDomainIDFromAgent", "Agent_Error", (Object)runtimeException.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getPolicyDomainIDFromAgent", (Throwable)runtimeException);
            }
            throw runtimeException;
        }
    }

    public String GetTdmAgentListInDomain(int n) {
        try {
            TdmAgent[] tdmAgentArray = this.getTdmAgentListInDomain(n);
            String string = "";
            int n2 = 0;
            while (n2 < tdmAgentArray.length) {
                string = String.valueOf(string) + tdmAgentArray[n2].agentName + " " + tdmAgentArray[n2].getUniqueAgentName() + "\n";
                ++n2;
            }
            return string;
        }
        catch (TdmException tdmException) {
            return tdmException.toString();
        }
    }

    public TdmAgent[] getTdmAgentListInDomain(int n) throws TdmException {
        try {
            return TdmAgentListImpl.getTdmAgentListInDomain(n);
        }
        catch (TdmException tdmException) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "SANDiskMgrHostService.getTdmAgentListInDomain", "Agent_Error", (Object)tdmException.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "SANDiskMgrHostService.getTdmAgentListInDomain", (Throwable)tdmException);
            }
            throw tdmException;
        }
        catch (RuntimeException runtimeException) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "SANDiskMgrHostService.getTdmAgentListInDomain", "Agent_Error", (Object)runtimeException.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "SANDiskMgrHostService.getTdmAgentListInDomain", (Throwable)runtimeException);
            }
            throw runtimeException;
        }
    }

    public void moveAgentToDomain(GUID gUID, int n, int n2) throws TdmException {
        try {
            HostManager.moveAgentToDomain(gUID, n, n2);
        }
        catch (TdmException tdmException) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "SANDiskMgrHostService:moveAgentToDomain", "Agent_Error", (Object)tdmException.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "SANDiskMgrHostService:moveAgentToDomain", (Throwable)tdmException);
            }
            throw tdmException;
        }
        catch (RuntimeException runtimeException) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "SANDiskMgrHostService:moveAgentToDomain", "Agent_Error", (Object)runtimeException.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "SANDiskMgrHostService:moveAgentToDomain", (Throwable)runtimeException);
            }
            throw runtimeException;
        }
    }

    public String Die() {
        this.die();
        return "OK";
    }

    void die() {
        this._healthy = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listAgentMap() throws Exception {
        try {
            String string = "";
            Set set = this.hostMap.keySet();
            Map map = this.hostMap;
            synchronized (map) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    TdmAgent tdmAgent = (TdmAgent)this.hostMap.get(k);
                    string = String.valueOf(string) + "\n" + tdmAgent.agentName + " " + tdmAgent.getUniqueAgentName() + " " + tdmAgent.status + "\n";
                }
            }
            return string;
        }
        catch (Exception exception) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "listHostMap", "Agent_Error", (Object)exception.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "listHostMap", (Throwable)exception);
            }
            throw exception;
        }
    }

    public String SetHeartbeatMonitorInterval(String string) {
        try {
            IConfigService iConfigService = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService");
            int n = iConfigService.setProperty("hostPollingInterval", "user", string);
            this._agentHeartbeatThread.setHeartbeatInterval(string);
            if (n == 0) {
                return "OK";
            }
            return "Property NOT saved\n";
        }
        catch (Exception exception) {
            messages.exception((Object)this, "SetHeartbeatMonitorInterval", (Throwable)exception);
            if (trace.isLogging()) {
                trace.exception((Object)this, "SetHeartbeatMonitorInterval", (Throwable)exception);
            }
            return exception.toString();
        }
    }

    public String SetAgentHeartbeatInterval(String string) {
        try {
            IConfigService iConfigService = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService");
            int n = iConfigService.setProperty("hostQueryPollingInterval", "user", string);
            if (n == 0) {
                return "OK";
            }
            return "Property NOT saved\n";
        }
        catch (Exception exception) {
            messages.exception((Object)this, "SetAgentHeartbeatInterval", (Throwable)exception);
            if (trace.isLogging()) {
                trace.exception((Object)this, "SetAgentHeartbeatInterval", (Throwable)exception);
            }
            return exception.toString();
        }
    }

    static AgentTableReader getHostTableReader() throws AuthorizationException, InterruptedException, SQLException {
        return new AgentTableReader((DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection(), AgentConstants.HOST_TABLE_NAME);
    }

    static AgentTableUpdater getHostTableUpdater() throws AuthorizationException, InterruptedException, SQLException {
        return new AgentTableUpdater((DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection(), AgentConstants.HOST_TABLE_NAME);
    }

    void fireDiskMgrHostServiceEvent(String string) {
    }

    public Hashtable getRoleMap() {
        Hashtable hashtable = new Hashtable();
        return hashtable;
    }
}

