/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.event.data;

import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class SANEventExceptionHandler
implements ExceptionListener {
    final long serialVersionUID = 20001130L;
    protected transient ILogger msgLogger = null;
    protected transient ILogger traceLogger = null;
    static final String TRACE_NAME = "aperi.logger.trace.event";
    static final String MESSAGE_NAME = "aperi.logger.message.event";
    static final String BUNDLENAME = "org.eclipse.aperi.sanmgmt.event.resources.SANEventService";
    public String className;

    public SANEventExceptionHandler() {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.event.data.SANEventExceptionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.className = clazz.getName();
        this.traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        this.msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        if (this.msgLogger != null) {
            this.msgLogger.setMessageFile(BUNDLENAME);
        }
    }

    public void onException(JMSException jMSException) {
        if (this.msgLogger != null) {
            this.msgLogger.message(IRecordType.TYPE_ERR, (Object)this.className, "onException", "SANEventException_JMSException", (Object)jMSException);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this.className, "onException", (Throwable)jMSException);
        }
    }
}

