/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;
import org.eclipse.aperi.snmp.GenericFilter;
import org.eclipse.aperi.snmp.GenericListener;
import org.eclipse.aperi.snmp.SnmpAsn1;
import org.eclipse.aperi.snmp.SnmpBERlength;
import org.eclipse.aperi.snmp.SnmpDecodeException;
import org.eclipse.aperi.snmp.SnmpMetaPDU;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.SnmpV2PDU;
import org.eclipse.aperi.snmp.SnmpV2Trap;
import org.eclipse.aperi.snmp.TrapFilter;
import org.eclipse.aperi.snmp.TrapListener;
import org.eclipse.aperi.snmp.V2TrapFilter;
import org.eclipse.aperi.snmp.V2TrapListener;
import org.eclipse.aperi.snmp.data.IPAddress;

public class TrapReceiver
implements Runnable {
    private DatagramSocket sock;
    private final byte[] buffer = new byte[1500];
    private DatagramPacket packet;
    private Vector V1listeners = new Vector();
    private Vector V2listeners = new Vector();
    private Vector genericListeners = new Vector();
    private boolean receiverRunning = false;

    public TrapReceiver() throws SocketException {
        this.initialize(162, 2099);
    }

    public TrapReceiver(int n) throws SocketException {
        this.initialize(n, 2099);
    }

    public TrapReceiver(int n, int n2) throws SocketException {
        this.initialize(n, n2);
    }

    private void initialize(int n, int n2) throws SocketException {
        final int n3 = n;
        try {
            this.sock = (DatagramSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new DatagramSocket(n3);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof SocketException) {
                throw (SocketException)exception;
            }
            exception.printStackTrace();
        }
    }

    public synchronized void subscribe(TrapListener trapListener, TrapFilter trapFilter) {
        SingleListener singleListener = new SingleListener(trapListener, trapFilter);
        this.V1listeners.addElement(singleListener);
    }

    public synchronized void subscribeV2(V2TrapListener v2TrapListener, V2TrapFilter v2TrapFilter) {
        SingleListener singleListener = new SingleListener(v2TrapListener, v2TrapFilter);
        this.V2listeners.addElement(singleListener);
    }

    public synchronized void subscribeGeneric(GenericListener genericListener, GenericFilter genericFilter) {
        SingleListener singleListener = new SingleListener(genericListener, genericFilter);
        this.genericListeners.addElement(singleListener);
    }

    public synchronized void changeFilter(TrapListener trapListener, TrapFilter trapFilter, TrapFilter trapFilter2) {
        this.changeFilter(trapListener, trapFilter, trapFilter2, true);
    }

    public synchronized void changeFilter(V2TrapListener v2TrapListener, V2TrapFilter v2TrapFilter, TrapFilter trapFilter) {
        this.changeFilter(v2TrapListener, v2TrapFilter, trapFilter, false);
    }

    public synchronized void changeFilter(Object object, Object object2, Object object3, boolean bl) {
        if (object != null) {
            Vector vector = bl ? this.V1listeners : this.V2listeners;
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                SingleListener singleListener = (SingleListener)vector.elementAt(n2);
                if (object.equals(singleListener.listener) && object2.equals(singleListener.filter)) {
                    singleListener.filter = object3;
                    break;
                }
                ++n2;
            }
        }
    }

    public void unsubscribe(TrapListener trapListener, TrapFilter trapFilter) {
        this.unsubscribe(trapListener, trapFilter, true);
    }

    public void unsubscribe(V2TrapListener v2TrapListener, V2TrapFilter v2TrapFilter) {
        this.unsubscribe(v2TrapListener, v2TrapFilter, false);
    }

    synchronized void unsubscribe(Object object, Object object2, boolean bl) {
        if (object != null) {
            Vector vector = bl ? this.V1listeners : this.V2listeners;
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                SingleListener singleListener = (SingleListener)vector.elementAt(n2);
                if (object.equals(singleListener.listener) && object2.equals(singleListener.filter)) {
                    vector.removeElementAt(n2);
                    break;
                }
                ++n2;
            }
        }
    }

    public void terminate() {
        block2: {
            byte[] byArray = new byte[1];
            try {
                final DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getLocalHost(), this.sock.getLocalPort());
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        TrapReceiver.this.sock.send(datagramPacket);
                        return null;
                    }
                });
            }
            catch (Throwable throwable) {
                if (!this.receiverRunning) break block2;
                System.out.println("TrapReceiver: not terminated:" + throwable.toString());
            }
        }
    }

    public void run() {
        this.receiverRunning = true;
        Thread.currentThread().setName("TrapReceiver");
        block11: while (true) {
            block38: {
                try {
                    this.packet = (DatagramPacket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            DatagramPacket datagramPacket = new DatagramPacket(TrapReceiver.this.buffer, TrapReceiver.this.buffer.length);
                            TrapReceiver.this.sock.receive(datagramPacket);
                            return datagramPacket;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (!SnmpV1API.isTracing()) break block38;
                    SnmpV1API.trace("TrapReceiver - error on receive - " + privilegedActionException.getException().toString());
                }
            }
            try {
                SingleListener singleListener;
                int n;
                if (SnmpV1API.isTracing()) {
                    SnmpV1API.trace("TrapReceiver - received packet");
                }
                if (this.packet.getLength() == 1) {
                    this.receiverRunning = false;
                    this.sock.close();
                    return;
                }
                byte[] byArray = this.packet.getData();
                int n2 = 1;
                n2 += SnmpBERlength.size(byArray, n2);
                byte by = byArray[n2 += 2];
                if (SnmpV1API.isTracing()) {
                    SnmpV1API.trace(" version of trap is " + by);
                }
                SnmpMetaPDU snmpMetaPDU = null;
                if (by == 0) {
                    SnmpTrap snmpTrap = SnmpAsn1.decodeTrap(byArray);
                    if (SnmpV1API.isTracing()) {
                        SnmpV1API.trace("Received Trap - " + snmpTrap.toString());
                    }
                    if ((snmpMetaPDU = snmpTrap) == null) continue;
                    snmpTrap.senderAddr = new IPAddress(this.packet.getAddress().getAddress(), 0);
                    snmpTrap.senderPort = this.packet.getPort();
                    n = this.V1listeners.size();
                    int n3 = 0;
                    while (n3 < n) {
                        try {
                            singleListener = (SingleListener)this.V1listeners.elementAt(n3);
                            if (((TrapFilter)singleListener.filter).filter(snmpTrap)) {
                                if (SnmpV1API.isTracing()) {
                                    SnmpV1API.trace("passing trap to listener");
                                }
                                ((TrapListener)singleListener.listener).handle(snmpTrap);
                            } else if (SnmpV1API.isTracing()) {
                                SnmpV1API.trace("filter failed, skipping listener");
                            }
                        }
                        catch (Throwable throwable) {
                            if (SnmpV1API.isTracing()) {
                                SnmpV1API.trace("TrapListener threw an error - removing it." + throwable.toString());
                            }
                            this.V1listeners.removeElementAt(n3);
                            --n3;
                            --n;
                        }
                        ++n3;
                    }
                } else if (by == 1) {
                    SnmpV2Trap snmpV2Trap = null;
                    snmpV2Trap = (SnmpV2Trap)SnmpAsn1.decodeV2PDU(byArray, this.packet.getLength(), false);
                    snmpV2Trap.senderAddr = new IPAddress(this.packet.getAddress().getAddress(), 0);
                    snmpV2Trap.senderPort = this.packet.getPort();
                    snmpMetaPDU = snmpV2Trap;
                    if (snmpMetaPDU == null) continue;
                    if (SnmpV1API.isTracing()) {
                        SnmpV1API.trace("Received Trap - " + snmpV2Trap.toString());
                    }
                    n = this.V2listeners.size();
                    int n4 = 0;
                    while (n4 < n) {
                        try {
                            singleListener = (SingleListener)this.V2listeners.elementAt(n4);
                            if (((V2TrapFilter)singleListener.filter).filter(snmpV2Trap)) {
                                ((V2TrapListener)singleListener.listener).handle(snmpV2Trap);
                            }
                        }
                        catch (Throwable throwable) {
                            if (SnmpV1API.isTracing()) {
                                SnmpV1API.trace("V2TrapListener threw an error - removing it." + throwable.toString());
                            }
                            this.V2listeners.removeElementAt(n4);
                            --n4;
                            --n;
                        }
                        ++n4;
                    }
                } else if (by == 3) {
                    if (SnmpV1API.isTracing()) {
                        SnmpV1API.trace("Received V3 message - discarding");
                    }
                } else if (SnmpV1API.isTracing()) {
                    SnmpV1API.trace("Received Trap with version " + by);
                }
                if (snmpMetaPDU == null) continue;
                int n5 = this.genericListeners.size();
                n = 0;
                while (true) {
                    if (n >= n5) continue block11;
                    try {
                        SingleListener singleListener2 = (SingleListener)this.genericListeners.elementAt(n);
                        if (((GenericFilter)singleListener2.filter).filter(snmpMetaPDU)) {
                            if (SnmpV1API.isTracing()) {
                                SnmpV1API.trace("passing trap to genericListener");
                            }
                            ((GenericListener)singleListener2.listener).handle(snmpMetaPDU);
                        }
                    }
                    catch (Throwable throwable) {
                        if (SnmpV1API.isTracing()) {
                            SnmpV1API.trace("Generic Listener threw an error - removing it." + throwable.toString());
                        }
                        this.genericListeners.removeElementAt(n);
                        --n;
                        --n5;
                        System.out.println("error in handling listener:" + throwable.toString());
                        throwable.printStackTrace();
                    }
                    ++n;
                }
            }
            catch (SnmpDecodeException snmpDecodeException) {
                if (!SnmpV1API.isTracing()) continue;
                SnmpV1API.trace(snmpDecodeException.toString());
                continue;
            }
            catch (Throwable throwable) {
                if (!SnmpV1API.isTracing()) continue;
                SnmpV1API.trace("error in handling Trap:" + throwable.toString());
                continue;
            }
            break;
        }
    }

    class SingleListener
    implements TrapFilter,
    V2TrapFilter,
    GenericFilter {
        protected Object listener;
        protected Object filter;

        protected SingleListener(Object object, Object object2) {
            this.listener = object;
            this.filter = object2 != null ? object2 : this;
        }

        public boolean filter(SnmpTrap snmpTrap) {
            return true;
        }

        public boolean filter(SnmpV2PDU snmpV2PDU) {
            return true;
        }

        public boolean filter(SnmpMetaPDU snmpMetaPDU) {
            return true;
        }
    }
}

