/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.common;

import java.util.Date;
import java.util.HashMap;
import org.eclipse.aperi.San.common.Lun;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.ComputerList;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class LunWWNAdjuster
extends CustomReportDataAdjuster {
    static final String SUBSYSTEM = MessageLog.getMessageNoID("SAG0001L");
    static final String LUN_NAME = MessageLog.getMessageNoID("SAG0645L");
    static final String LUN_WWN = MessageLog.getMessageNoID("SAG0646L");
    static final String HBA_WWN = MessageLog.getMessageNoID("STG3902L");
    static final String HBA_HOST = MessageLog.getMessageNoID("STG3903L");
    static final String CAPACITY = MessageLog.getMessageNoID("SAG0644L");
    static final String SRM_AGENT = MessageLog.getMessageNoID("STG3904L");
    static final String SRM_NETWORK = MessageLog.getMessageNoID("STG3912L");
    static final String SRM_OSTYPE = MessageLog.getMessageNoID("STG3905L");
    static final String DISK_PATH = MessageLog.getMessageNoID("STG3906L");
    static final String DISK_CAP = MessageLog.getMessageNoID("STG3907L");
    static final String DISK_FREE = MessageLog.getMessageNoID("STG3908L");
    static final String WWN_MATCH = MessageLog.getMessageNoID("STG3911L");
    static final String FORMAT = MessageLog.getMessageNoID("SAG0643L");
    static final String MANUFACTURER = MessageLog.getMessageNoID("STG1105L");
    static final String MODEL = MessageLog.getMessageNoID("STG1106L");
    static final String PROBE_TIME = MessageLog.getMessageNoID("STG1182L");
    private static final String UNKNOWN = MessageLog.getMessageNoID("GUI0129T");
    public static final String YES = MessageLog.getMessageNoID("GUI0121T");
    public static final String NO = MessageLog.getMessageNoID("GUI0122T");
    public static final String NA = MessageLog.getMessageNoID("STG0019T");
    public static final String FIXBLK = MessageLog.getMessageNoID("SAG0034L");
    public static final String ZSERIES = MessageLog.getMessageNoID("SAG0035L");
    private static final int SUBSYSTEM_COL = 0;
    private static final int LUN_NAME_COL = 1;
    private static final int LUN_WWN_COL = 2;
    private static final int HBA_WWN_COL = 3;
    private static final int HBA_HOST_COL = 4;
    private static final int CAPACITY_COL = 5;
    private int SRM_HOST_COL = 6;
    private int SRM_NETWORK_COL = 7;
    private int SRM_OSTYPE_COL = 8;
    private int DISK_PATH_COL = 9;
    private int DISK_CAP_COL = 10;
    private int DISK_FREE_COL = 11;
    private int WWN_MATCH_COL = 12;
    private int FORMAT_COL = 13;
    private int MANUFACTURER_COL = 14;
    private int MODEL_COL = 15;
    private int PROBE_TIME_COL = 16;
    public String[] colNames;
    public String[] colNames1 = new String[]{SUBSYSTEM, LUN_NAME, LUN_WWN, HBA_WWN, HBA_HOST, CAPACITY, SRM_AGENT, SRM_NETWORK, SRM_OSTYPE, DISK_PATH, DISK_CAP, DISK_FREE, WWN_MATCH, FORMAT, MANUFACTURER, MODEL, PROBE_TIME};
    public String[] colNames2 = new String[]{SUBSYSTEM, LUN_NAME, LUN_WWN, HBA_WWN, HBA_HOST, CAPACITY, FORMAT, MANUFACTURER, MODEL, PROBE_TIME};
    public String[] colNames3 = new String[]{SUBSYSTEM, LUN_NAME, LUN_WWN, HBA_WWN, HBA_HOST, CAPACITY, SRM_AGENT, SRM_NETWORK, SRM_OSTYPE, FORMAT, MANUFACTURER, MODEL, PROBE_TIME};
    private GuiReportReq grr;
    private Lun[] lunArray;
    private Date[] mDate;
    private MutableInteger[] mInt;
    private MutableLong[] mLong;
    private int[] rendererArray;
    private ComputerList computerList;
    private int rowCount;
    public int frozenRows;
    public int totalRow;
    private boolean bHasTotalRow = false;
    private boolean batch;
    private String helpID;
    private String[] osTypeNames = new String[28];

    public LunWWNAdjuster(GuiReportReq guiReportReq) {
        super(guiReportReq);
        this.grr = guiReportReq;
        this.frozenColumns = 2;
        this.helpID = "ress35";
        if (guiReportReq.reportSubtype == 89) {
            this.colNames = this.colNames2;
            this.SRM_HOST_COL = -777;
            this.SRM_NETWORK_COL = -777;
            this.SRM_OSTYPE_COL = -777;
            this.DISK_PATH_COL = -777;
            this.DISK_CAP_COL = -777;
            this.DISK_FREE_COL = -777;
            this.WWN_MATCH_COL = -777;
            this.FORMAT_COL = 6;
            this.MANUFACTURER_COL = 7;
            this.MODEL_COL = 8;
            this.PROBE_TIME_COL = 9;
            this.helpID = "ress45";
        } else if (guiReportReq.reportSubtype == 90) {
            this.colNames = this.colNames3;
            this.SRM_HOST_COL = 6;
            this.SRM_NETWORK_COL = 7;
            this.SRM_OSTYPE_COL = 8;
            this.DISK_PATH_COL = -777;
            this.DISK_CAP_COL = -777;
            this.DISK_FREE_COL = -777;
            this.WWN_MATCH_COL = -777;
            this.FORMAT_COL = 9;
            this.MANUFACTURER_COL = 10;
            this.MODEL_COL = 11;
            this.PROBE_TIME_COL = 12;
            this.helpID = "ress50";
        } else {
            this.colNames = this.colNames1;
            this.SRM_HOST_COL = 6;
            this.SRM_NETWORK_COL = 7;
            this.SRM_OSTYPE_COL = 8;
            this.DISK_PATH_COL = 9;
            this.DISK_CAP_COL = 10;
            this.DISK_FREE_COL = 11;
            this.WWN_MATCH_COL = 12;
            this.FORMAT_COL = 13;
            this.MANUFACTURER_COL = 14;
            this.MODEL_COL = 15;
            this.PROBE_TIME_COL = 16;
            this.helpID = "ress35";
        }
        if (guiReportReq.reportSubtype == 18) {
            this.firstColumn = this.PROBE_TIME_COL;
        } else if (guiReportReq.reportSubtype == 78) {
            this.helpID = "ress40";
            this.firstColumn = 5;
        } else {
            this.firstColumn = 0;
        }
        this.rendererArray = new int[this.colNames.length];
        this.rendererArray[this.PROBE_TIME_COL] = 1;
        this.rendererArray[5] = 7;
        if (this.DISK_CAP_COL > 0) {
            this.rendererArray[this.DISK_CAP_COL] = 7;
        }
        if (this.DISK_FREE_COL > 0) {
            this.rendererArray[this.DISK_FREE_COL] = 7;
        }
        this.colNames = this.getCustomizedColNames(this.colNames);
        int n = 0;
        while (n < 28) {
            this.osTypeNames[n] = MessageLog.getMessageNoID(Constants.OSTYPES[n]);
            n = (short)(n + 1);
        }
        if (guiReportReq.reportType == 76) {
            this.helpID = this.getLunHbaReportHelpId(guiReportReq.reportSubtype);
        }
    }

    public void adjust(Object[] objectArray, boolean bl) {
        this.adjustInit(objectArray, bl);
        this.adjustData();
    }

    public void adjustInit(Object[] objectArray, boolean bl) {
        this.lunArray = (Lun[])objectArray;
        this.rowCount = this.lunArray.length;
        this.batch = bl;
        if (bl) {
            this.computerList = new ComputerList();
        }
        if (this.rowCount > 1) {
            this.addTotal();
        }
        this.mDate = new Date[this.rowCount];
        this.mLong = new MutableLong[this.rowCount];
        this.mInt = new MutableInteger[this.rowCount];
        int n = 0;
        while (n < this.rowCount) {
            this.mDate[n] = new Date();
            this.mLong[n] = new MutableLong();
            this.mInt[n] = new MutableInteger();
            ++n;
        }
    }

    public void adjustData() {
        int n = 0;
        while (n < this.rowCount) {
            Lun lun = this.lunArray[n];
            lun.lunDiskCapacity *= 512L;
            lun.lunDiskFreespace *= 512L;
            LogicalDisk logicalDisk = lun.lunLogicalDisk;
            logicalDisk.ldCapacity *= 512L;
            if (lun.lunAgentID > 0) {
                lun.lunGComputer = this.batch ? this.computerList.getComputer(lun.lunAgentID) : GuiUtil.getComputer(lun.lunAgentID);
            }
            ++n;
        }
    }

    public void undo() {
        Lun lun = this.lunArray[0];
        lun.lunDiskCapacity /= 512L;
        lun.lunDiskFreespace /= 512L;
        LogicalDisk logicalDisk = lun.lunLogicalDisk;
        logicalDisk.ldCapacity /= 512L;
    }

    protected void addValidValues(ColumnDescriptor[] columnDescriptorArray) {
        int[] nArray = new int[]{7, 8, 58, 9};
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        int[] nArray3 = nArray2;
        columnDescriptorArray[this.FORMAT_COL].cdValidValue = nArray;
        if (this.SRM_OSTYPE_COL > -1) {
            columnDescriptorArray[this.SRM_OSTYPE_COL].cdValidValue = ColumnDescriptor.OS_TYPES_PLUS_UNKNOWN;
        }
        if (this.WWN_MATCH_COL > -1) {
            columnDescriptorArray[this.WWN_MATCH_COL].cdValidValue = nArray3;
        }
    }

    public int getNumberRows() {
        return this.lunArray.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int getFirstColumn() {
        return this.firstColumn;
    }

    public int getFrozenColumns() {
        return this.frozenColumns;
    }

    public Object getArray() {
        return this.lunArray;
    }

    public Object getCellData(int n, int n2) {
        if (n == 0 && this.bHasTotalRow && n2 != 0 && n2 != 5 && n2 != this.DISK_CAP_COL && n2 != this.DISK_FREE_COL) {
            return " ";
        }
        if (n2 == 0) {
            return this.lunArray[n].lunDaAlias;
        }
        if (n2 == 1) {
            int n3;
            String string = this.lunArray[n].lunName;
            if (this.lunArray[n].lunOSType == 21 && (n3 = string.indexOf(":")) > 0) {
                string = string.substring(0, n3);
            }
            return string;
        }
        if (n2 == 2) {
            String string = this.lunArray[n].lunWWN;
            if (Util.isEmpty(string)) {
                return UNKNOWN;
            }
            return string;
        }
        if (n2 == 3) {
            return this.lunArray[n].lunHBAWWN;
        }
        if (n2 == 4) {
            return this.lunArray[n].lunSSHost;
        }
        if (n2 == this.SRM_HOST_COL) {
            if (this.lunArray[n].lunAgentID < 1) {
                return " ";
            }
            return this.lunArray[n].lunGComputer.gcTSName;
        }
        if (n2 == this.SRM_NETWORK_COL) {
            if (this.lunArray[n].lunGComputer == null) {
                return " ";
            }
            return Util.getDotName(this.lunArray[n].lunGComputer.gcNetworkName, this.lunArray[n].lunGComputer.gcDomainName);
        }
        if (n2 == this.SRM_OSTYPE_COL) {
            return this.osTypeNames[this.lunArray[n].lunAgentOSType];
        }
        if (n2 == 5) {
            this.mLong[n].value = this.lunArray[n].lunLogicalDisk.ldCapacity;
            return this.mLong[n];
        }
        if (n2 == this.DISK_PATH_COL) {
            if (this.lunArray[n].lunDiskPath == null) {
                return " ";
            }
            return this.lunArray[n].lunDiskPath;
        }
        if (n2 == this.DISK_CAP_COL) {
            this.mLong[n].value = this.lunArray[n].lunDiskCapacity;
            return this.mLong[n];
        }
        if (n2 == this.DISK_FREE_COL) {
            this.mLong[n].value = this.lunArray[n].lunDiskFreespace;
            return this.mLong[n];
        }
        if (n2 == this.WWN_MATCH_COL) {
            return this.lunArray[n].lunLogicalDisk.ldIsSwap ? YES : NO;
        }
        if (n2 == this.FORMAT_COL) {
            if (this.lunArray[n].lunOSType != 12 && this.lunArray[n].lunOSType != 25 && this.lunArray[n].lunOSType != 27) {
                return UNKNOWN;
            }
            if (this.lunArray[n].lunOSType == 12) {
                if (this.lunArray[n].lunName.startsWith("1")) {
                    return FIXBLK;
                }
                return ZSERIES;
            }
            return LogicalDisk.FORMATS[this.lunArray[n].lunLogicalDisk.ldStorageType];
        }
        if (n2 == this.MANUFACTURER_COL) {
            if (this.lunArray[n].lunDaManufacturer.toLowerCase().equals("unknown")) {
                return MessageLog.getMessageNoID("STG1020L");
            }
            return this.lunArray[n].lunDaManufacturer;
        }
        if (n2 == this.MODEL_COL) {
            if (this.lunArray[n].lunOSType == 21) {
                return "2145";
            }
            return this.lunArray[n].lunDaModel;
        }
        if (n2 == this.PROBE_TIME_COL) {
            this.mDate[n].setTime(this.lunArray[n].lunProbeTime);
            return this.mDate[n];
        }
        return null;
    }

    private void addTotal() {
        Lun lun;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        HashMap<MutableInteger, Lun> hashMap = new HashMap<MutableInteger, Lun>(100);
        MutableInteger mutableInteger = new MutableInteger();
        Lun[] lunArray = new Lun[this.rowCount + 1];
        lunArray[0] = lun = new Lun();
        lun.lunLogicalDisk = new LogicalDisk();
        lun.lunDaAlias = MessageLog.getMessageNoID("STG4136L");
        int n = 0;
        while (n < this.rowCount) {
            mutableInteger.value = this.lunArray[n].lunID;
            if (hashMap.get(mutableInteger) == null) {
                hashMap.put(mutableInteger, this.lunArray[n]);
                if (this.lunArray[n].lunLogicalDisk.ldCapacity > -1L) {
                    l += this.lunArray[n].lunLogicalDisk.ldCapacity;
                }
                if (this.lunArray[n].lunDiskCapacity > -1L) {
                    l2 += this.lunArray[n].lunDiskCapacity;
                }
                if (this.lunArray[n].lunDiskFreespace > -1L) {
                    l3 += this.lunArray[n].lunDiskFreespace;
                }
            }
            lunArray[n + 1] = this.lunArray[n];
            ++n;
        }
        lun.lunLogicalDisk.ldCapacity = l;
        lun.lunDiskCapacity = l2;
        lun.lunDiskFreespace = l3;
        this.lunArray = lunArray;
        this.bHasTotalRow = true;
        this.totalRow = 1;
        ++this.frozenRows;
        ++this.rowCount;
    }

    public String getHelpID() {
        return this.helpID;
    }

    private String getLunHbaReportHelpId(int n) {
        String string = "fqz0_r_LUN_to_HBA_assignment_1";
        switch (n) {
            case 77: {
                string = "fqz0_r_LUN_to_HBA_assignment_2";
                break;
            }
            case 78: {
                string = "fqz0_r_LUN_to_HBA_assignment_3";
                break;
            }
            case 89: {
                string = "fqz0_r_LUN_to_HBA_assignment_4";
                break;
            }
            case 90: {
                string = "fqz0_r_LUN_to_HBA_assignment_5";
            }
        }
        return string;
    }
}

