/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import org.eclipse.aperi.San.gui.ArraySiteTreeLabel;
import org.eclipse.aperi.San.gui.DiskArrayDDI;
import org.eclipse.aperi.San.gui.DiskGroupTreeLabel;
import org.eclipse.aperi.San.gui.LUNTreeLabel;
import org.eclipse.aperi.San.gui.LocalControllerTreeLabel;
import org.eclipse.aperi.San.gui.LocalDiskTreeLabel;
import org.eclipse.aperi.San.gui.RankTreeLabel;
import org.eclipse.aperi.San.gui.RemoteControllerTreeLabel;
import org.eclipse.aperi.San.gui.RemoteDiskTreeLabel;
import org.eclipse.aperi.San.gui.VolumeSpaceTreeLabel;
import org.eclipse.aperi.TStorm.gui.VolumeGroupTreeLabel;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.AlertableTreeNode;

public class DiskArrayTreeNode
extends AlertableTreeNode {
    public DiskArrayTreeNode(NameList nameList) {
        super(nameList.nlID);
        this.setUserObject(nameList);
        this.reset();
    }

    protected NameList getNameList() {
        return (NameList)this.getUserObject();
    }

    public void expand(TreeExpansionEvent treeExpansionEvent) {
        if (this.getChildCount() > 0) {
            return;
        }
        NameList nameList = this.getNameList();
        if (Constants.hasDiskGroupInfo((short)nameList.nlID2)) {
            this.add(new DiskGroupTreeLabel(nameList));
        }
        if (Constants.hasArraySiteInfo((short)nameList.nlID2)) {
            this.add(new ArraySiteTreeLabel(nameList));
        }
        if (Constants.hasRankInfo((short)nameList.nlID2)) {
            this.add(new RankTreeLabel(nameList, -1));
        }
        if (Constants.hasStoragePoolInfo((short)nameList.nlID2)) {
            if (nameList.nlID2 == 21) {
                this.add(new VolumeGroupTreeLabel(nameList));
            } else {
                this.add(new VolumeSpaceTreeLabel(nameList, -1));
            }
        }
        if (nameList.nlID2 == 11) {
            this.add(new LocalControllerTreeLabel(nameList));
        }
        if (Constants.hasDiskInfo((short)nameList.nlID2)) {
            this.add(new LocalDiskTreeLabel(nameList, -1));
        }
        this.add(new LUNTreeLabel(nameList, -1, -1));
        if (nameList.nlID2 == 11) {
            this.add(new RemoteControllerTreeLabel(nameList));
            this.add(new RemoteDiskTreeLabel(nameList, -1));
        }
    }

    public void select(TreeSelectionEvent treeSelectionEvent) {
        new DiskArrayDDI(this, this.getNameList());
    }
}

