/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.control.ControlEngine;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.RunJobs;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.RPCSecureJavaProvider;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IDeviceServiceManager;

public class ServiceUtils {
    public static final int FAILED = 8;
    public static final int WARNING = 4;
    private static IDeviceServiceManager serviceManagerProxy = null;
    private static IDiscover discoveryServiceProxy = null;
    private static IEventMonitorService eventMonitor = null;
    private static int nextNumber = 0;
    public static Hashtable activeJobs = new Hashtable();
    public static Hashtable completedJobResults = new Hashtable();
    public static Hashtable jobResults = new Hashtable();
    public static Hashtable jobExceptions = new Hashtable();
    public static final String TRACE_NAME = "aperi.logger.trace.DiscoverRouter";
    public static ILogger traceLogger = null;
    public static String className = ServiceUtils.class.getName();
    public static ILogger auditLogger = null;
    private static final String BUNDLE_NAME = "org.eclipse.aperi.sanmgmt.middleware.resources.TSNMServiceManager";

    static {
        auditLogger = LogManagerFactory.getMessageLogger("aperi.logger.message.audit");
        auditLogger.setMessageFile(BUNDLE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
    }

    public static boolean populateResults(AsyncResult asyncResult, boolean bl) {
        AsyncResult[] asyncResultArray;
        Exception exception;
        boolean bl2 = false;
        String string = asyncResult.getJobId();
        Result result = (Result)jobResults.get(string);
        if (result != null) {
            if (result.getSRMMessage() != null) {
                bl2 = true;
                asyncResult.setSRMMessage(result.getSRMMessage());
            }
            if (bl) {
                jobResults.remove(string);
            }
        }
        if ((exception = (Exception)jobExceptions.get(string)) != null) {
            bl2 = true;
            asyncResult.setReturnException(exception);
            if (bl) {
                jobExceptions.remove(string);
            }
        }
        if ((asyncResultArray = asyncResult.getSubJobResults()) != null) {
            int n = 0;
            while (n < asyncResultArray.length) {
                bl2 |= ServiceUtils.populateResults(asyncResultArray[n], bl);
                ++n;
            }
        }
        return bl2;
    }

    public static String getDiscoverRequestInfo(String string, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        long l = 0L;
        stringBuffer.append(String.valueOf(string) + "Request:" + objectArray[0] + '\n');
        String string2 = String.valueOf(string) + "   ";
        for (Object object : (ArrayList)objectArray[1]) {
            stringBuffer.append(ServiceUtils.getDiscoverRequestInfo(string2, (Object[])object));
        }
        for (Object object : (ArrayList)objectArray[2]) {
            l += ((JobInfo)object).getEndTime() - ((JobInfo)object).getStartTime();
            stringBuffer.append(String.valueOf(string2) + "Job ID=" + ((JobInfo)object).getId() + (((JobInfo)object).getStatus() == 4 ? " replaced by job " + ((JobInfo)object).getReplacementJob().getId() : " QueueName=" + ((JobInfo)object).getResourceQueue() + " Request=" + ((JobInfo)object).getRequest() + " Duration=" + (((JobInfo)object).getEndTime() - ((JobInfo)object).getStartTime()) / 1000L + " seconds\n"));
        }
        stringBuffer.append(String.valueOf(string) + "total duration = " + l / 1000L + " seconds\n\n");
        return stringBuffer.toString();
    }

    public static AsyncResult getJobStatus(String string) {
        AsyncResult asyncResult = null;
        Object v = activeJobs.get(string);
        if (v != null) {
            if (v instanceof org.eclipse.aperi.control.data.JobInfo) {
                ControlEngine controlEngine = ControlEngine.getInstance();
                asyncResult = controlEngine.getActiveJobResults(string);
            } else if (v instanceof AsyncResult) {
                asyncResult = (AsyncResult)v;
            }
        } else {
            v = completedJobResults.get(string);
            if (v != null && v instanceof AsyncResult) {
                completedJobResults.remove(string);
                JobEngine.getInstance().cleanupRequestInformation(string);
                asyncResult = (AsyncResult)v;
            } else {
                asyncResult = ServiceUtils.getJobRecord(Integer.parseInt(string));
            }
        }
        return asyncResult;
    }

    public static DBConnection getConnection() {
        try {
            DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
            return (DBConnection)dBConnPoolDataSource.getPooledConnection();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static boolean createJobRecord(int n, int n2, String string, String string2) {
        DBConnection dBConnection = null;
        try {
            dBConnection = ServiceUtils.getConnection();
            Timestamp timestamp = CurrentTime.getTimestamp(dBConnection);
            RunJobs runJobs = new RunJobs();
            runJobs.setTimeStamp(timestamp.getTime());
            runJobs.setStartTime(timestamp.getTime());
            runJobs.setScheduleId(0);
            runJobs.setSidRunNumber(0);
            runJobs.setDeviceServerRunId(n);
            runJobs.setJobRunNumber(n2);
            runJobs.setComputerId(ServiceUtils.getDeviceServerId());
            runJobs.setLogFileName(string2);
            runJobs.setProcessId(1);
            runJobs.setReturnCode(-1);
            runJobs.setSubmitStatus(2);
            runJobs.insert(dBConnection);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                    dBConnection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return false;
    }

    public static boolean updateJobRecord(int n, int n2, int n3, int n4) {
        DBConnection dBConnection = null;
        try {
            dBConnection = ServiceUtils.getConnection();
            Timestamp timestamp = CurrentTime.getTimestamp(dBConnection);
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            hashtable.put(RunJobs.getColumnInfo("SCHEDULE_ID"), "0");
            hashtable.put(RunJobs.getColumnInfo("SID_RUN_NUMBER"), "0");
            hashtable.put(RunJobs.getColumnInfo("JOB_RUN_NUMBER"), new Integer(n2).toString());
            hashtable.put(RunJobs.getColumnInfo("DEVICE_SERVER_RUN_ID"), new Integer(n).toString());
            Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
            if (n4 != 0) {
                n4 = n4 > 0 ? 8 : 4;
            }
            hashtable2.put(RunJobs.getColumnInfo("RETURN_CODE"), new Integer(n4).toString());
            hashtable2.put(RunJobs.getColumnInfo("SUBMIT_STATUS"), new Integer(n3).toString());
            hashtable2.put(RunJobs.getColumnInfo("TIME_STAMP"), new Long(timestamp.getTime()).toString());
            hashtable2.put(RunJobs.getColumnInfo("FINISH_TIME"), new Long(timestamp.getTime()).toString());
            boolean bl = RunJobs.update(dBConnection, hashtable2, hashtable) == 1;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                    dBConnection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return false;
    }

    public static AsyncResult[] getJobRecords() {
        DBConnection dBConnection = null;
        ArrayList<AsyncResult> arrayList = new ArrayList<AsyncResult>();
        try {
            try {
                dBConnection = ServiceUtils.getConnection();
                String string = "select distinct DEVICE_SERVER_RUN_ID from " + dBConnection.getSchema() + ".T_RUN_JOBS " + "order by DEVICE_SERVER_RUN_ID asc";
                DBResultSet dBResultSet = null;
                try {
                    try {
                        dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, new Hashtable());
                        new ArrayList();
                        while (dBResultSet.next()) {
                            int n = dBResultSet.getInt("DEVICE_SERVER_RUN_ID");
                            arrayList.add(ServiceUtils.getJobRecord(n));
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                finally {
                    try {
                        if (dBResultSet != null) {
                            dBResultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                    dBConnection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return arrayList.toArray(new AsyncResult[0]);
    }

    public static AsyncResult getJobRecord(int n) {
        DBConnection dBConnection = null;
        AsyncResult asyncResult = null;
        try {
            try {
                dBConnection = ServiceUtils.getConnection();
                String string = "select * from " + dBConnection.getSchema() + ".T_RUN_JOBS " + "WHERE " + "\t\tSCHEDULE_ID=0 " + " and\tSID_RUN_NUMBER=0 " + " and\tDEVICE_SERVER_RUN_ID=" + n + " " + "ORDER BY JOB_RUN_NUMBER ASC";
                DBResultSet dBResultSet = null;
                try {
                    try {
                        dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, new Hashtable());
                        ArrayList<AsyncResult> arrayList = new ArrayList<AsyncResult>();
                        while (dBResultSet.next()) {
                            AsyncResult asyncResult2 = new AsyncResult();
                            asyncResult2.setRc(dBResultSet.getInt("RETURN_CODE"));
                            asyncResult2.setStatus(dBResultSet.getInt("SUBMIT_STATUS"));
                            if (asyncResult == null) {
                                asyncResult2.setJobId(dBResultSet.getString("DEVICE_SERVER_RUN_ID"));
                                asyncResult = asyncResult2;
                            } else {
                                asyncResult2.setJobId(String.valueOf(dBResultSet.getString("DEVICE_SERVER_RUN_ID")) + ":" + dBResultSet.getString("JOB_RUN_NUMBER"));
                                arrayList.add(asyncResult2);
                                if (asyncResult.getStatus() == 1 && asyncResult2.getStatus() != 1) {
                                    asyncResult.setStatus(4);
                                }
                            }
                            Object v = activeJobs.get(asyncResult2.getJobId());
                            if (v != null) {
                                asyncResult2.setResults(new Object[]{v});
                                continue;
                            }
                            v = completedJobResults.get(asyncResult2.getJobId());
                            if (v == null) continue;
                            completedJobResults.remove(asyncResult2.getJobId());
                            JobEngine.getInstance().cleanupRequestInformation(asyncResult2.getJobId());
                            asyncResult2.setResults(new Object[]{v});
                        }
                        if (!arrayList.isEmpty()) {
                            asyncResult.setSubJobResults(arrayList.toArray(new AsyncResult[0]));
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (asyncResult == null) {
                            asyncResult = new AsyncResult(8, 0);
                            asyncResult.setJobId(new Integer(n).toString());
                        }
                    }
                }
                finally {
                    try {
                        if (dBResultSet != null) {
                            dBResultSet.getStatement().close();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (asyncResult == null) {
                    asyncResult = new AsyncResult(8, 0);
                    asyncResult.setJobId(new Integer(n).toString());
                }
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                    dBConnection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return asyncResult;
    }

    public static synchronized int getJobIdentifier(boolean bl, int n) {
        if (bl) {
            try {
                return AutoIdentifier.getIdentifier(n, 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            if (--nextNumber >= 0) {
                nextNumber = -1;
            }
            return nextNumber;
        }
        return 0;
    }

    /*
     * Loose catch block
     */
    public static int getDeviceServerId() {
        block21: {
            DBConnection dBConnection;
            block19: {
                block17: {
                    int n;
                    block18: {
                        int n2;
                        dBConnection = ServiceUtils.getConnection();
                        String string = "Select * from T_RES_SERVER server where server.server_type= ";
                        string = String.valueOf(string) + Integer.toString(1);
                        DBResultSet dBResultSet = null;
                        dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, null);
                        if (!dBResultSet.next()) break block17;
                        n = n2 = dBResultSet.getInt("SERVER_ID");
                        if (dBConnection == null) break block18;
                        try {
                            dBConnection.commit();
                            dBConnection.close();
                        }
                        catch (Exception exception) {
                            if (!traceLogger.isLogging()) break block18;
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, "getDeviceServerComputerId", exception);
                        }
                    }
                    return n;
                    {
                        catch (Exception exception) {
                            if (!traceLogger.isLogging()) break block19;
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, "getDeviceServerComputerId", exception);
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        block20: {
                            if (dBConnection != null) {
                                try {
                                    dBConnection.commit();
                                    dBConnection.close();
                                }
                                catch (Exception exception) {
                                    if (!traceLogger.isLogging()) break block20;
                                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, "getDeviceServerComputerId", exception);
                                }
                            }
                        }
                        throw throwable;
                    }
                }
                if (dBConnection != null) {
                    try {
                        dBConnection.commit();
                        dBConnection.close();
                    }
                    catch (Exception exception) {
                        if (traceLogger.isLogging()) {
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, "getDeviceServerComputerId", exception);
                        }
                    }
                }
                break block21;
            }
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                    dBConnection.close();
                }
                catch (Exception exception) {
                    if (!traceLogger.isLogging()) break block21;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, "getDeviceServerComputerId", exception);
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_ERROR, className, "getDeviceServerComputerId", "Invalid device server Id");
        }
        return -999;
    }

    public static void recordInAuditLog(String string, String string2, String string3, int n) {
        ServiceUtils.recordInAuditLog(string, string2, string3, new Integer(n).toString());
    }

    public static void recordInAuditLog(String string, String string2, String string3, AsyncResult asyncResult) {
        if (asyncResult.getStatus() == 2) {
            ServiceUtils.recordInAuditLog(string, string2, string3, "JobID=" + asyncResult.getJobId());
        } else {
            ServiceUtils.recordInAuditLog(string, string2, string3, asyncResult.toString());
        }
    }

    public static void recordInAuditLog(String string, String string2, String string3, String string4) {
        String string5 = "recordInAuditLog";
        Map map = ServiceUtils.getUserProperties();
        if (map != null) {
            String string6 = null;
            String string7 = null;
            try {
                string6 = (String)map.get("USER");
            }
            catch (Exception exception) {}
            if (string6 != null) {
                try {
                    Integer cfr_ignored_0 = (Integer)map.get("ROLE");
                }
                catch (Exception exception) {}
                try {
                    string7 = (String)map.get("HOST");
                }
                catch (Exception exception) {}
                Object[] objectArray = new String[]{String.valueOf(string) + "." + string2, string6, string7, string3, string4};
                auditLogger.message(IRecordType.TYPE_INFORMATION, (Object)className, string5, "TSNMServiceManager_AuthorizedRequest", objectArray);
            }
        }
    }

    public static Map getUserProperties() {
        return RPCSecureJavaProvider.getUserProperties();
    }

    public static IDeviceServiceManager getServiceManagerProxy() {
        if (serviceManagerProxy == null) {
            serviceManagerProxy = (IDeviceServiceManager)Activator._serviceHelper.bindLocal("DeviceServiceManager");
        }
        return serviceManagerProxy;
    }

    public static IDiscover getDiscoveryServiceProxy() {
        if (discoveryServiceProxy == null) {
            discoveryServiceProxy = (IDiscover)Activator._serviceHelper.bindLocal("DiscoverService");
        }
        return discoveryServiceProxy;
    }

    public static IEventMonitorService getEventMonitorProxy() {
        if (eventMonitor == null) {
            eventMonitor = (IEventMonitorService)Activator._serviceHelper.bindLocal("SANEventCorrelatorFactory");
        }
        return eventMonitor;
    }
}

