/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import org.eclipse.aperi.TStorm.common.Grapher;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.VolGroupAdjuster;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.SpaceHistChart;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespVolGroup;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.gui.charting.AperiCustomizableChart;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class VolGroupGrapher
extends Grapher {
    String title;
    public static final byte CHART_SIZE = 101;
    public static final byte CHART_SIZE_X = 102;
    public static final String CHART_SELECTED = "STG5556T";
    public static final String CHART_ALL = "STG1294T";
    public static final String FREE_HIST = "STG5105L";
    public static final String FREE_PERCENT_HIST = "STG5106L";
    public static final String CAPACITY_HIST = "STG5109L";
    public static final String NUM_LVFS_HIST = "STG6207L";
    public static final String FREE_HISTORY = "STG7530L";
    public static final String FREE_PCT_HISTORY = "STG7531L";
    public static final String CAPACITY_HISTORY = "STG7539L";
    static final String USED_SPACE = MessageLog.getMessageNoID("STG1237L");
    static final String FREE_SPACE = MessageLog.getMessageNoID("STG1184L");

    public String getChartType(GuiReportReq guiReportReq, ReportDataAdjuster reportDataAdjuster) {
        if (guiReportReq.chartSubtype > 0) {
            return null;
        }
        this.title = guiReportReq.histSubtype == 1 ? FREE_HIST : (guiReportReq.histSubtype == 2 ? FREE_PERCENT_HIST : (guiReportReq.histSubtype == 5 ? CAPACITY_HIST : NUM_LVFS_HIST));
        return MessageLog.getMessageNoID(this.title);
    }

    public int graphsPerPage(GuiReportReq guiReportReq) {
        return 2;
    }

    public AperiChart processBatch(GuiReportReq guiReportReq, Object[] objectArray, int[] nArray, ReportDataAdjuster reportDataAdjuster, GuiChartSettingsReq guiChartSettingsReq) {
        VolGroupAdjuster volGroupAdjuster = (VolGroupAdjuster)reportDataAdjuster;
        AperiChart aperiChart = null;
        if (guiReportReq.chartSubtype > 0) {
            aperiChart = this.createChart(guiReportReq, objectArray, nArray, reportDataAdjuster, null, guiChartSettingsReq);
        } else {
            GuiReportReq guiReportReq2 = this.createHistory(guiReportReq, objectArray, nArray, this.title, volGroupAdjuster);
            aperiChart = (AperiChart)new SpaceHistChart().batch(guiReportReq2, guiChartSettingsReq);
        }
        return aperiChart;
    }

    public AperiCustomizableChart createChart(GuiReportReq guiReportReq, Object[] objectArray, int[] nArray, ReportDataAdjuster reportDataAdjuster, ReportingDDI reportingDDI, GuiChartSettingsReq guiChartSettingsReq) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(VolGroupGrapher.class.getName(), "createChart", "grr, pData, rows, pAdjuster, ddi, gcsr");
        }
        RespVolGroup[] respVolGroupArray = (RespVolGroup[])objectArray;
        VolGroupAdjuster cfr_ignored_0 = (VolGroupAdjuster)reportDataAdjuster;
        int n = nArray.length;
        Number[][] numberArray = new Number[2][n];
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[]{USED_SPACE, FREE_SPACE};
        int n2 = n - 1;
        while (n2 >= 0) {
            RespVolGroup respVolGroup = respVolGroupArray[nArray[n2]];
            numberArray[0][n2] = new Long(respVolGroup.vgTotalSpace - respVolGroup.vgFreeSpace);
            numberArray[1][n2] = new Long(respVolGroup.vgFreeSpace);
            stringArray[n2] = String.valueOf(respVolGroup.rvgComputerName) + "." + respVolGroup.vgName;
            --n2;
        }
        AperiCustomizableChart aperiCustomizableChart = new AperiCustomizableChart(1, 7, numberArray, stringArray2, stringArray, new ChartOptions(), guiReportReq);
        if (reportingDDI != null) {
            reportingDDI.addChart(guiReportReq, aperiCustomizableChart, "");
        }
        AperiCustomizableChart aperiCustomizableChart2 = aperiCustomizableChart;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(VolGroupGrapher.class.getName(), "createChart", aperiCustomizableChart2);
        }
        return aperiCustomizableChart2;
    }

    public GuiReportReq createHistory(GuiReportReq guiReportReq, Object[] objectArray, int[] nArray, String string, VolGroupAdjuster volGroupAdjuster) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(VolGroupGrapher.class.getName(), "createHistory", "grr, pData, rows, actionCommand, adjuster");
        }
        RespVolGroup[] respVolGroupArray = (RespVolGroup[])objectArray;
        GuiReportReq guiReportReq2 = guiReportReq.explode(-1);
        guiReportReq2.reportSubtype = guiReportReq.reportSubtype;
        guiReportReq2.idSubtype = -1;
        SpaceHistChart.initLegend(guiReportReq2);
        guiReportReq2.selectedResources = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            RespVolGroup respVolGroup = respVolGroupArray[nArray[n]];
            guiReportReq2.selectedResources[n] = respVolGroup.vgID;
            SpaceHistChart.addLegend(guiReportReq2, respVolGroup.rvgComputerName, respVolGroup.vgName, respVolGroup.vgID);
            ++n;
        }
        if (string == FREE_HIST) {
            guiReportReq2.chartLabelType = 1;
            guiReportReq2.histSubtype = 1;
            guiReportReq2.historyTitle = "STG6203L";
        } else if (string == FREE_PERCENT_HIST) {
            guiReportReq2.chartLabelType = (byte)8;
            guiReportReq2.histSubtype = (byte)2;
            guiReportReq2.historyTitle = "STG6204L";
        } else if (string == CAPACITY_HIST) {
            guiReportReq2.chartLabelType = 1;
            guiReportReq2.histSubtype = (byte)5;
            guiReportReq2.historyTitle = "STG6205L";
        } else {
            guiReportReq2.chartLabelType = (byte)6;
            guiReportReq2.histSubtype = 0;
            guiReportReq2.historyTitle = "STG6206L";
        }
        guiReportReq2.reportSubtypeOrig = guiReportReq.reportSubtype;
        guiReportReq2.reportSubtype = 28;
        GuiReportReq guiReportReq3 = guiReportReq2;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(VolGroupGrapher.class.getName(), "createHistory", guiReportReq3);
        }
        return guiReportReq3;
    }
}

