/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.border.EmptyBorder;
import org.eclipse.aperi.TStorm.common.AgentAdjuster;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.TStorm.server.guireq.RespAgent;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.LogViewer;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.admin.AdminTreeLabel;
import org.eclipse.aperi.gui.admin.AgentTreeNode;
import org.eclipse.aperi.gui.admin.LogConfigDialog;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public class AgentTable
extends JPanel
implements GuiRequestor {
    private MegaTable table = new MegaTable();
    private RespAgent[] dataArray;
    private RespAgent[] processAgents;
    private RespAgent respAgent;
    private GuiReportReq grr;
    private ReportingDDI ddi;
    private AgentAdjuster adjuster;
    private Request agentRequest;
    private LogConfigDialog lConfigDialog = null;
    private String actionCommand;
    private int[] rows;
    private int[] processIDs;
    private Response saveResponse;
    private TJCTableMouseAdapter myMouseListener = new SelectListener();
    private AgentModel agentModel;
    private static final String L_LOG = "ADG0017L";
    private static final String L_TRACING = "ADG0304L";
    private static final String L_CONFIG = "ADG0255L";
    private static final String L_SHUTDOWN = "ADG0006L";
    private static final String L_NORMAL = "ADG0007L";
    private static final String L_IMMEDIATE = "ADG0009L";
    private static final String L_ABORT = "ADG0011L";
    private static final String L_UNINSTALL = "ADG0262L";
    private static final String L_CHECK = "ADG0288L";
    private static final String L_ENABLE = "ADG0289L";
    private static final String L_DISABLE = "ADG0290L";
    private static final String L_SET_STATE = "xxx";
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public AgentTable(GuiReportReq guiReportReq, ReportingDDI reportingDDI) {
        this.grr = guiReportReq;
        this.ddi = reportingDDI;
        GuiReportRequest guiReportRequest = new GuiReportRequest(guiReportReq);
        GuiClient.doRequest(this, guiReportRequest);
        this.adjuster = new AgentAdjuster(guiReportReq);
    }

    public void handleResponse(short s, Response response) {
        this.setLayout(new BorderLayout());
        this.dataArray = s <= 4 ? (RespAgent[])response.responseData : null;
        if (this.dataArray == null) {
            this.add((Component)this.ddi.getNoDataMessage_instance(this.grr), "Center");
            return;
        }
        int cfr_ignored_0 = this.dataArray.length;
        this.adjuster.adjust(this.dataArray, false);
        this.dataArray = (RespAgent[])this.adjuster.getArray();
        this.table.setMouseListener(this.myMouseListener);
        this.agentModel = new AgentModel();
        this.table.setFrozenColumns(this.adjuster.frozenColumns);
        this.table.setCellRenderer(MutableInteger.class, TableCellRenderers.number);
        this.table.setRowIcon(10, true);
        this.table.setBaseTableModel(this.agentModel);
        this.ddi.addRowCount(this.adjuster);
        this.add((Component)this.table, "Center");
    }

    private class AgentModel
    extends BaseTableModel {
        public AgentModel() {
            this.columnNames = ((AgentTable)AgentTable.this).adjuster.colNames;
            this.rowCount = AgentTable.this.dataArray.length;
            this.commonAdjuster = AgentTable.this.adjuster;
        }

        public Object getTableDataItem(int n, int n2) {
            return AgentTable.this.adjuster.getCellData(n, AgentTable.this.adjuster.translateColumn(n2));
        }

        public void changeTable() {
            this.fireTableDataChanged();
        }
    }

    public class SelectListener
    extends TJCTableMouseAdapter
    implements ActionListener,
    GuiRequestor {
        int[] rows;
        int rowCount;

        public void doubleClick(int n, int n2) {
            AgentTable.this.respAgent = AgentTable.this.dataArray[n];
            AgentTreeNode agentTreeNode = new AgentTreeNode(((AgentTable)AgentTable.this).respAgent.raTsName, ((AgentTable)AgentTable.this).respAgent.raComputerID, ((AgentTable)AgentTable.this).respAgent.raState);
            agentTreeNode.select(null);
        }

        public void showPopup(int n, int n2, Component component, int n3, int n4) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            boolean bl10 = false;
            boolean bl11 = false;
            boolean bl12 = AgentTable.this.table.rowsSelected();
            if (bl12) {
                bl9 = true;
                this.rows = AgentTable.this.table.getSelectedRows();
                this.rowCount = this.rows.length;
                int n5 = 0;
                while (n5 < this.rowCount) {
                    AgentTable.this.respAgent = AgentTable.this.dataArray[this.rows[n5]];
                    if (((AgentTable)AgentTable.this).respAgent.raState == 1) {
                        bl = true;
                        bl2 = true;
                        bl3 = true;
                        bl4 = true;
                        bl5 = true;
                        bl6 = true;
                        bl7 = true;
                        bl8 = true;
                        bl11 = true;
                    } else if (((AgentTable)AgentTable.this).respAgent.raState == 5) {
                        bl = true;
                        bl3 = true;
                        bl4 = true;
                        bl5 = true;
                        bl6 = true;
                        bl7 = true;
                        bl8 = true;
                        bl11 = true;
                    } else if (((AgentTable)AgentTable.this).respAgent.raState == 0) {
                        bl8 = true;
                        bl10 = true;
                    } else if (((AgentTable)AgentTable.this).respAgent.raState == 4) {
                        bl8 = true;
                        bl11 = true;
                    }
                    ++n5;
                }
                if (this.rowCount > 1) {
                    bl = false;
                    bl2 = false;
                    bl8 = false;
                }
            }
            if (!((AgentTable)AgentTable.this).guiMain.getUserPrefs().administrator) {
                bl2 = false;
                bl3 = false;
                bl4 = false;
                bl5 = false;
                bl6 = false;
                bl7 = false;
                bl8 = false;
                bl10 = false;
                bl11 = false;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID(AgentTable.L_LOG));
            jMenuItem.setActionCommand(AgentTable.L_LOG);
            jMenuItem.addActionListener(this);
            jMenuItem.setEnabled(bl);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID(AgentTable.L_TRACING));
            jMenuItem.setActionCommand(AgentTable.L_TRACING);
            jMenuItem.addActionListener(this);
            jMenuItem.setEnabled(bl2);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID(AgentTable.L_CONFIG));
            jMenuItem.setActionCommand(AgentTable.L_CONFIG);
            jMenuItem.addActionListener(this);
            jMenuItem.setEnabled(bl3);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID(AgentTable.L_CHECK));
            jMenuItem.setActionCommand(AgentTable.L_CHECK);
            jMenuItem.addActionListener(this);
            jMenuItem.setEnabled(bl9);
            JMenu jMenu = new JMenu(MessageLog.getMessageNoID(AgentTable.L_SHUTDOWN));
            jPopupMenu.add(jMenu);
            jMenu.setEnabled(bl4);
            jMenuItem = jMenu.add(MessageLog.getMessageNoID(AgentTable.L_NORMAL));
            jMenuItem.setActionCommand(AgentTable.L_NORMAL);
            jMenuItem.addActionListener(this);
            jMenuItem.setEnabled(bl5);
            jMenuItem = jMenu.add(MessageLog.getMessageNoID(AgentTable.L_IMMEDIATE));
            jMenuItem.setActionCommand(AgentTable.L_IMMEDIATE);
            jMenuItem.addActionListener(this);
            jMenuItem.setEnabled(bl6);
            jMenuItem = jMenu.add(MessageLog.getMessageNoID(AgentTable.L_ABORT));
            jMenuItem.setActionCommand(AgentTable.L_ABORT);
            jMenuItem.addActionListener(this);
            jMenuItem.setEnabled(bl7);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID(AgentTable.L_ENABLE));
            jMenuItem.setActionCommand(AgentTable.L_ENABLE);
            jMenuItem.addActionListener(this);
            jMenuItem.setEnabled(bl10);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID(AgentTable.L_DISABLE));
            jMenuItem.setActionCommand(AgentTable.L_DISABLE);
            jMenuItem.addActionListener(this);
            jMenuItem.setEnabled(bl11);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID(AgentTable.L_UNINSTALL));
            jMenuItem.setActionCommand(AgentTable.L_UNINSTALL);
            jMenuItem.addActionListener(this);
            jMenuItem.setEnabled(bl8);
            jPopupMenu.show(component, n3, n4);
            jPopupMenu.requestFocus();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgentTable.this.actionCommand = actionEvent.getActionCommand();
            this.rows = AgentTable.this.table.getSelectedRows();
            AgentTable.this.respAgent = AgentTable.this.dataArray[this.rows[0]];
            AgentTable.this.processAgents = new RespAgent[this.rows.length];
            int n = 0;
            while (n < AgentTable.this.processAgents.length) {
                ((AgentTable)AgentTable.this).processAgents[n] = AgentTable.this.dataArray[this.rows[n]];
                ++n;
            }
            AgentTable.this.processIDs = new int[AgentTable.this.processAgents.length];
            n = 0;
            while (n < AgentTable.this.processIDs.length) {
                ((AgentTable)AgentTable.this).processIDs[n] = ((AgentTable)AgentTable.this).processAgents[n].raComputerID;
                ++n;
            }
            if (AgentTable.this.actionCommand == AgentTable.L_LOG) {
                this.log();
            } else if (AgentTable.this.actionCommand == AgentTable.L_TRACING) {
                this.tracingConfig();
            } else if (AgentTable.this.actionCommand == AgentTable.L_CONFIG) {
                this.config();
            } else if (AgentTable.this.actionCommand == AgentTable.L_CHECK) {
                this.checkAgent();
            } else if (AgentTable.this.actionCommand == AgentTable.L_NORMAL) {
                this.stopAgent((byte)1);
            } else if (AgentTable.this.actionCommand == AgentTable.L_IMMEDIATE) {
                this.stopAgent((byte)2);
            } else if (AgentTable.this.actionCommand == AgentTable.L_ABORT) {
                this.stopAgent((byte)3);
            } else if (AgentTable.this.actionCommand == AgentTable.L_ENABLE) {
                this.enableAgent();
            } else if (AgentTable.this.actionCommand == AgentTable.L_DISABLE) {
                this.disableAgent();
            } else {
                this.uninstallAgent();
            }
        }

        private void log() {
            new LogViewer(((AgentTable)AgentTable.this).respAgent.raComputerID, ((AgentTable)AgentTable.this).ddi.treeNode, ((AgentTable)AgentTable.this).respAgent.raTsName, 0);
        }

        private void tracingConfig() {
            AgentTable.this.agentRequest = new Request();
            ServerRequest.agentGetTracingConfig(AgentTable.this.agentRequest, ((AgentTable)AgentTable.this).respAgent.raComputerID, "org.eclipse.aperi.agent.svp.AgentSvp");
            GuiClient.doRequest(this, AgentTable.this.agentRequest);
        }

        private void config() {
            AgentTable.this.agentRequest = new Request();
            ServerRequest.agentReadConfig(AgentTable.this.agentRequest, ((AgentTable)AgentTable.this).respAgent.raComputerID);
            this.processRequest(true);
        }

        private void checkAgent() {
            AgentTable.this.agentRequest = new Request();
            ServerRequest.agentStatus(AgentTable.this.agentRequest, ((AgentTable)AgentTable.this).respAgent.raComputerID);
            this.processRequest(true);
        }

        private void stopAgent(byte by) {
            String string;
            String string2;
            String string3;
            String string4;
            if (AgentTable.this.processAgents.length == 1) {
                string4 = MessageLog.getMessageNoID("ADG0251T", ((AgentTable)AgentTable.this).respAgent.raTsName);
                string3 = MessageLog.getMessageNoID("ADG0252T", ((AgentTable)AgentTable.this).respAgent.raTsName);
                string2 = MessageLog.getMessageNoID("ADG0253L");
                string = MessageLog.getMessageNoID("ADG0254L");
            } else {
                string4 = MessageLog.getMessageNoID("STG5577T");
                string3 = MessageLog.getMessageNoID("STG5578T");
                string2 = MessageLog.getMessageNoID("STG5579L");
                string = MessageLog.getMessageNoID("STG5580L");
            }
            Object[] objectArray = new String[]{string2, string};
            int n = JOptionPane.showOptionDialog(AgentTable.this.guiMain.getFrame(), string3, string4, 0, 2, null, objectArray, objectArray[0]);
            if (n == 1) {
                AgentTable.this.agentRequest = new Request();
                ServerRequest.agentStop(AgentTable.this.agentRequest, ((AgentTable)AgentTable.this).respAgent.raComputerID, by);
                this.processRhetoricalRequest(true);
            }
        }

        private void enableAgent() {
            AgentTable.this.agentRequest = new Request();
            ServerRequest.agentState(AgentTable.this.agentRequest, new ComputerID(((AgentTable)AgentTable.this).respAgent.raComputerID), (byte)1);
            this.processRequest(false);
        }

        private void disableAgent() {
            AgentTable.this.agentRequest = new Request();
            ServerRequest.agentState(AgentTable.this.agentRequest, new ComputerID(((AgentTable)AgentTable.this).respAgent.raComputerID), (byte)0);
            this.processRequest(false);
        }

        private void uninstallAgent() {
            String string = MessageLog.getMessageNoID("ADG0264T", ((AgentTable)AgentTable.this).respAgent.raTsName);
            String string2 = MessageLog.getMessageNoID("ADG0265T", ((AgentTable)AgentTable.this).respAgent.raTsName);
            String string3 = MessageLog.getMessageNoID("ADG0266L");
            String string4 = MessageLog.getMessageNoID("ADG0267L");
            Object[] objectArray = new String[]{string3, string4};
            int n = JOptionPane.showOptionDialog(AgentTable.this.guiMain.getFrame(), string2, string, 0, 2, null, objectArray, objectArray[0]);
            if (n == 1) {
                AgentTable.this.agentRequest = new Request();
                byte by = 0;
                ServerRequest.uninstallAgent(AgentTable.this.agentRequest, ((AgentTable)AgentTable.this).respAgent.raComputerID, by);
                GuiClient.doRequest(this, AgentTable.this.agentRequest);
                ((AgentTable)AgentTable.this).respAgent.raState = (byte)77;
                AgentTable.this.adjuster.adjustData();
                AgentTable.this.agentModel.changeTable();
                if (AdminTreeLabel.agentTreeLabel != null) {
                    AdminTreeLabel.agentTreeLabel.refreshAgents();
                }
            }
        }

        private void processRhetoricalRequest(boolean bl) {
            if (this.promptUser(bl) == 1) {
                GuiClient.doRhetoricalRequest(AgentTable.this.agentRequest);
            }
        }

        private void processRequest(boolean bl) {
            if (this.promptUser(bl) == 1) {
                GuiClient.doRequest(this, AgentTable.this.agentRequest);
            }
        }

        private int promptUser(boolean bl) {
            Object object;
            int n = 1;
            if (bl && AgentTable.this.processIDs.length > 4) {
                object = MessageLog.getMessageNoID("STG5573T");
                String string = MessageLog.getMessageNoID("STG5574T");
                String string2 = MessageLog.getMessageNoID("STG5575L");
                String string3 = MessageLog.getMessageNoID("STG5576L");
                Object[] objectArray = new String[]{string2, string3};
                n = JOptionPane.showOptionDialog(AgentTable.this.guiMain.getFrame(), string, (String)object, 0, 2, null, objectArray, objectArray[0]);
            }
            if (n == 1) {
                object = AgentTable.this.agentRequest;
                AgentTable.this.agentRequest = new Request();
                ServerRequest.agentCommand(AgentTable.this.agentRequest, (Request)object, AgentTable.this.processIDs);
            }
            return n;
        }

        public void handleResponse(short s, Response response) {
            if (AgentTable.this.actionCommand == AgentTable.L_CHECK) {
                this.fixTable(response);
                this.showMessages(response, true);
            } else if (AgentTable.this.actionCommand == AgentTable.L_ENABLE || AgentTable.this.actionCommand == AgentTable.L_DISABLE) {
                this.fixTable(response);
                this.showMessages(response, false);
            } else if (AgentTable.this.actionCommand == AgentTable.L_TRACING) {
                if (s != 0) {
                    JOptionPane.showMessageDialog(AgentTable.this.guiMain.getFrame(), MessageLog.getMessage("ADG0308E", ((AgentTable)AgentTable.this).respAgent.raTsName), MessageLog.getMessageNoID("ADG0307L"), 0);
                } else {
                    HashMap hashMap = (HashMap)response.responseData;
                    if (AgentTable.this.lConfigDialog == null) {
                        String string = MessageLog.getMessageNoID("ADG0310L", ((AgentTable)AgentTable.this).respAgent.raTsName);
                        AgentTable.this.lConfigDialog = new LogConfigDialog(string, ((AgentTable)AgentTable.this).respAgent.raComputerID, ((AgentTable)AgentTable.this).respAgent.raTsName, "org.eclipse.aperi.agent.svp.AgentSvp");
                    }
                    AgentTable.this.lConfigDialog.setLocationRelativeTo(null);
                    AgentTable.this.lConfigDialog.show(hashMap, "org.eclipse.aperi.agent.svp.AgentSvp");
                }
            } else if (AgentTable.this.actionCommand == AgentTable.L_NORMAL || AgentTable.this.actionCommand == AgentTable.L_SET_STATE) {
                int n = 0;
                while (n < AgentTable.this.processAgents.length) {
                    ((AgentTable)AgentTable.this).processAgents[n].raState = 0;
                    ++n;
                }
                AgentTable.this.adjuster.adjustData();
                AgentTable.this.agentModel.changeTable();
                if (AdminTreeLabel.agentTreeLabel != null) {
                    AdminTreeLabel.agentTreeLabel.refreshAgents();
                }
                if (AgentTable.this.actionCommand == AgentTable.L_NORMAL) {
                    this.showMessages(response, false);
                } else {
                    this.showMessages(AgentTable.this.saveResponse, false);
                }
            } else if (AgentTable.this.actionCommand == AgentTable.L_IMMEDIATE || AgentTable.this.actionCommand == AgentTable.L_ABORT) {
                AgentTable.this.actionCommand = AgentTable.L_SET_STATE;
                AgentTable.this.saveResponse = response;
                AgentTable.this.agentRequest = new Request();
                ServerRequest.agentState(AgentTable.this.agentRequest, new ComputerID(((AgentTable)AgentTable.this).respAgent.raComputerID), (byte)0);
                this.processRequest(false);
            }
        }

        private void fixTable(Response response) {
            Object[] objectArray = (Object[])response.responseData;
            byte[] byArray = (byte[])objectArray[0];
            int n = 0;
            while (n < AgentTable.this.processAgents.length) {
                ((AgentTable)AgentTable.this).processAgents[n].raState = byArray[n];
                ++n;
            }
            AgentTable.this.adjuster.adjustData();
            AgentTable.this.agentModel.changeTable();
            if (AdminTreeLabel.agentTreeLabel != null) {
                AdminTreeLabel.agentTreeLabel.refreshAgents();
            }
        }

        private void showMessages(Response response, boolean bl) {
            Object[] objectArray = (Object[])response.responseData;
            String[] stringArray = (String[])objectArray[1];
            int n = stringArray.length;
            StringBuffer stringBuffer = new StringBuffer(n * 240);
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < n) {
                if (stringArray[n2] != null) {
                    bl2 = true;
                    if (bl) {
                        stringBuffer.append(MessageLog.getMessageNoID("ADG0201L"));
                        stringBuffer.append(" ");
                        stringBuffer.append(((AgentTable)AgentTable.this).processAgents[n2].raTsName);
                        stringBuffer.append(": ");
                    }
                    stringBuffer.append(stringArray[n2]);
                    stringBuffer.append("\n\n");
                } else if (bl) {
                    bl2 = true;
                    stringBuffer.append(MessageLog.getMessageNoID("ADG0294M", ((AgentTable)AgentTable.this).processAgents[n2].raTsName));
                    stringBuffer.append("\n\n");
                }
                ++n2;
            }
            if (bl2) {
                String string = MessageLog.getMessageNoID("ADG0295T");
                MultiLineLabel multiLineLabel = new MultiLineLabel(stringBuffer.toString());
                JScrollPane jScrollPane = new JScrollPane(multiLineLabel);
                Dimension dimension = multiLineLabel.getPreferredSize();
                int n3 = dimension.width + 8 + jScrollPane.getVerticalScrollBar().getPreferredSize().width;
                int n4 = dimension.height > 200 ? 200 : dimension.height + 8;
                jScrollPane.setPreferredSize(new Dimension(n3, n4));
                jScrollPane.setViewportBorder(new EmptyBorder(2, 2, 2, 2));
                JOptionPane.showMessageDialog(AgentTable.this.guiMain.getFrame(), jScrollPane, string, 1);
            }
        }
    }

    private class MultiLineLabel
    extends JTextArea {
        public MultiLineLabel(String string) {
            super(string);
        }

        public void updateUI() {
            super.updateUI();
            this.setHighlighter(null);
            this.setEditable(false);
            LookAndFeel.installBorder(this, "Label.border");
            LookAndFeel.installColorsAndFont(this, "Label.background", "Label.foregroung", "Label.font");
        }
    }
}

