/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.event.MouseEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.TStorm.gui.ClusterDDI;
import org.eclipse.aperi.TStorm.gui.ComputerDDI;
import org.eclipse.aperi.TStorm.gui.ComputerTreeLabel;
import org.eclipse.aperi.TStorm.gui.ControllerTreeLabel;
import org.eclipse.aperi.TStorm.gui.DiskTreeLabel;
import org.eclipse.aperi.TStorm.gui.ExportsTreeLabel;
import org.eclipse.aperi.TStorm.gui.LogicalVolumeTreeLabel;
import org.eclipse.aperi.TStorm.gui.VolumeGroupTreeLabel;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.AlertableTreeNode;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.IconFactory;

public class ComputerTreeNode
extends AlertableTreeNode {
    NameList computer;

    public ComputerTreeNode(NameList nameList) {
        super(nameList.nlID);
        this.computer = nameList;
        this.setUserObject(this.computer);
        this.reset();
    }

    public void render(DefaultTreeCellRenderer defaultTreeCellRenderer, BaseTree baseTree, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.render(defaultTreeCellRenderer, baseTree, bl, bl2, bl3, n, bl4);
        if (Constants.isVirtualServer(this.computer.nlID2) && this.computer.nlInfo != 99) {
            defaultTreeCellRenderer.setIcon(IconFactory.getVirtualServerIcon());
        } else if (this.computer.nlInfo == 99) {
            defaultTreeCellRenderer.setIcon(IconFactory.getClusterIcon());
        } else {
            defaultTreeCellRenderer.setIcon(IconFactory.getComputerIcon());
        }
    }

    public void expand(TreeExpansionEvent treeExpansionEvent) {
        if (this.getChildCount() == 0) {
            if ((!Constants.isNasBox((short)this.computer.nlID2) || Constants.supportsFullProbe((short)this.computer.nlID2)) && this.computer.nlID2 != 22) {
                this.add(new ControllerTreeLabel(this.computer));
                this.add(new DiskTreeLabel(this.computer, -1));
            }
            if (this.computer.nlID2 == 22) {
                this.add(new ComputerTreeLabel("STG1033L", -1, this.computer.nlClusterID));
                this.add(new ComputerTreeLabel("STG1032L", 20, this.computer.nlClusterID));
            }
            if (this.computer.nlID2 == 2 || this.computer.nlID2 == 6 || this.computer.nlID2 == 3 || this.computer.nlID2 == 7 || this.computer.nlID2 == 8) {
                this.add(new VolumeGroupTreeLabel(this.computer));
            }
            if (this.computer.nlID2 != 22) {
                this.add(new LogicalVolumeTreeLabel(this.computer, -1));
            }
            if (this.computer.nlID2 != 8 && this.computer.nlID2 != 22 && this.computer.nlID2 != 23) {
                this.add(new ExportsTreeLabel(this.computer.nlID));
            }
        }
    }

    public void select(TreeSelectionEvent treeSelectionEvent) {
        if (this.computer.nlID2 == 22) {
            new ClusterDDI(this, this.computer.nlClusterID, this.computer.nlName);
        } else {
            new ComputerDDI(this, this.computer.nlID, this.computer.nlName);
        }
    }

    protected NameList getNameList() {
        return this.computer;
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        if (this.computer.nlID2 == 22 && mouseEvent != null) {
            this.menu = this.getPopupMenu();
            this.showPopupMenu(this.menu, mouseEvent);
        } else {
            super.showPopupMenu(mouseEvent);
        }
    }
}

