/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.TStorm.common.ComputerUpTimeAdjuster;
import org.eclipse.aperi.TStorm.common.ComputerUpTimeGrapher;
import org.eclipse.aperi.TStorm.common.UpTimeReport;
import org.eclipse.aperi.TStorm.gui.DisplaysChartPopupInterface;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.MutableLongExt;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.HistoryChoiceInterface;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ComputerUpTimeTable
extends JPanel
implements GuiRequestor,
TJCTableMouseInterface,
ActionListener,
DisplaysChartPopupInterface,
HistoryChoiceInterface {
    private GuiReportReq grr;
    private ReportingDDI ddi;
    private ComputerUpTimeAdjuster adjuster;
    private ComputerUpTimeGrapher grapher;
    private MegaTable table = new MegaTable();
    private UpTimeReport[] tableData;
    private static final int MILLIS_PER_SECOND = 1000;

    public ComputerUpTimeTable(GuiReportReq guiReportReq, ReportingDDI reportingDDI) {
        this.grr = guiReportReq;
        this.ddi = reportingDDI;
        GuiReportRequest guiReportRequest = new GuiReportRequest(guiReportReq);
        GuiClient.doRequest(this, guiReportRequest);
        this.adjuster = new ComputerUpTimeAdjuster(guiReportReq);
        this.grapher = new ComputerUpTimeGrapher();
        this.grapher.setIcon(guiReportReq);
    }

    public void handleResponse(short s, Response response) {
        this.setLayout(new BorderLayout());
        this.tableData = s <= 4 ? (UpTimeReport[])response.responseData : null;
        int n = this.tableData != null ? this.tableData.length : 0;
        if (n == 0) {
            this.add((Component)this.ddi.getNoDataMessage_instance(this.grr), "Center");
            this.ddi.jumpToChart = false;
            return;
        }
        this.adjuster.adjust(this.tableData, false);
        this.table.setMouseListener(this);
        this.table.setCellRenderer(Date.class, TableCellRenderers.date);
        this.table.setCellRenderer(MutableLongExt.class, TableCellRenderers.duration);
        this.table.setCellRenderer(MutableInteger.class, new TableCellRenderers.DecimalRenderer(3, " %"));
        this.table.setCellRenderer(MutableLong.class, TableCellRenderers.number);
        this.table.setRowIcon(this.grapher.rowChartIcon, this.grr.reportSubtype != 28);
        this.table.setFrozenColumns(this.adjuster.frozenColumns);
        this.table.setBaseTableModel(new UpTimeModel());
        this.ddi.addRowCount(this.adjuster);
        this.add((Component)this.table, "Center");
        if (this.ddi.jumpToChart) {
            this.ddi.jumpToChart = false;
            this.showJumpChart();
        }
    }

    public TJCTableMouseInterface getShowsPopup() {
        return this.grr.reportSubtype == 28 ? null : this;
    }

    public boolean select(int n, int n2) {
        return this.grr.reportSubtype != 28;
    }

    public void selectionChanged(boolean bl) {
    }

    public void showDefaultChart(int n) {
        int[] nArray = new int[]{n};
        int[] nArray2 = this.getGraphID("STG4121L");
        this.grr.chartSubtype = (byte)nArray2[0];
        this.grapher.createChart(this.grr, this.tableData, nArray, this.adjuster, this.ddi, null);
    }

    public void doubleClick(int n, int n2) {
        if (this.grr.reportSubtype != 28) {
            GuiReportReq guiReportReq = this.grr.explode(this.tableData[n].crID);
            this.ddi.addReport(this.grr, guiReportReq, this.grapher.getRowName(this.tableData, n, this.adjuster, this.grr));
        }
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
        if (this.grr.reportSubtype != 28) {
            int[] nArray = this.table.getSelectedRows();
            boolean bl = this.adjuster.getArray() != null;
            boolean bl2 = bl && nArray.length > 0;
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG4121L"));
            jMenuItem.setEnabled(bl2);
            jMenuItem.setActionCommand("STG4121L");
            jMenuItem.addActionListener(this);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG4122L"));
            jMenuItem.setEnabled(bl);
            jMenuItem.setActionCommand("STG4122L");
            jMenuItem.addActionListener(this);
            if (this.grr.reportSubtype == 12) {
                jPopupMenu.addSeparator();
                jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG4123L"));
                jMenuItem.setEnabled(bl2);
                jMenuItem.setActionCommand("STG4123L");
                jMenuItem.addActionListener(this);
            }
            jPopupMenu.show(component, n3, n4);
            jPopupMenu.requestFocus();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int[] nArray;
        String string = actionEvent.getActionCommand();
        if (string == "STG4122L") {
            nArray = new int[this.tableData.length];
            int n = nArray.length - 1;
            while (n >= 0) {
                nArray[n] = this.table.getDataRow(n);
                --n;
            }
        } else {
            nArray = this.table.getSelectedRows();
        }
        if (string != "STG4123L") {
            int[] nArray2 = this.getGraphID(string);
            this.grr.chartSubtype = (byte)nArray2[0];
            this.grapher.createChart(this.grr, this.tableData, nArray, this.adjuster, this.ddi, null);
        } else {
            GuiReportReq guiReportReq = this.grapher.createHistory(this.grr, this.tableData, nArray);
            this.ddi.addObject(this.grr, "org.eclipse.aperi.TStorm.gui.SpaceHistChart", guiReportReq, MessageLog.getMessageNoID("STG1279T"), MessageLog.getMessageNoID(guiReportReq.historyTitle), this);
        }
    }

    public void showJumpChart() {
        int[] nArray = new int[this.tableData.length];
        int n = nArray.length - 1;
        while (n >= 0) {
            nArray[n] = this.table.getDataRow(n);
            --n;
        }
        int[] nArray2 = this.getGraphID("STG4122L");
        this.grr.chartSubtype = (byte)nArray2[0];
        this.grapher.createChart(this.grr, this.tableData, nArray, this.adjuster, this.ddi, null);
    }

    public ComputerUpTimeTable(String string, String string2, String string3, String string4) {
    }

    public Object[] getChoices(int n, int n2) {
        Object[] objectArray = null;
        if (n2 == 12) {
            objectArray = new Object[3];
            String[] stringArray = new String[]{"STG4123L"};
            byte[] byArray = new byte[]{8};
            byte[] byArray2 = new byte[]{6};
            objectArray[0] = stringArray;
            objectArray[1] = byArray;
            objectArray[2] = byArray2;
        }
        return objectArray;
    }

    public Object[] getCharts(int n, int n2) {
        Object[] objectArray = new Object[2];
        String[] stringArray = new String[]{"STG7527L"};
        byte[] byArray = new byte[]{101};
        objectArray[0] = stringArray;
        objectArray[1] = byArray;
        return objectArray;
    }

    public int[] getGraphID(String string) {
        int[] nArray = new int[2];
        nArray[0] = string == "STG4121L" ? 101 : (string == "STG4122L" ? 102 : 6);
        return nArray;
    }

    private class UpTimeModel
    extends BaseTableModel {
        UpTimeModel() {
            this.columnNames = ((ComputerUpTimeTable)ComputerUpTimeTable.this).adjuster.colNames;
            this.rowCount = ComputerUpTimeTable.this.tableData.length;
            this.commonAdjuster = ComputerUpTimeTable.this.adjuster;
        }

        public Object getTableDataItem(int n, int n2) {
            return ComputerUpTimeTable.this.adjuster.getCellData(n, ComputerUpTimeTable.this.adjuster.translateColumn(n2));
        }
    }
}

