/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import javax.swing.JTabbedPane;
import org.eclipse.aperi.TStorm.common.AlertHeader;
import org.eclipse.aperi.TStorm.gui.AlertCreateOrEdit;
import org.eclipse.aperi.TStorm.gui.FSAlertEditor;
import org.eclipse.aperi.TStorm.gui.FSSelector;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.xmsg.MessageLog;

public class FSAlertCreateOrEdit
extends AlertCreateOrEdit {
    private FSSelector fsSelector;
    private static final int ALERT_TAB = 0;
    private static final int FILESYSTEM_TAB = 1;

    public FSAlertCreateOrEdit(CreateOrEditDDI createOrEditDDI) {
        super(createOrEditDDI);
    }

    protected void makeTabbedPane(AlertHeader alertHeader) {
        NameList[] nameListArray = new NameList[]{alertHeader.alertGroups2, alertHeader.alertElements2, alertHeader.alertGroups, alertHeader.alertElements, alertHeader.alertClusters};
        this.fsSelector = new FSSelector(nameListArray, alertHeader.allObjects, false, true);
        this.alertEditor = alertHeader.alert == null ? new FSAlertEditor() : new FSAlertEditor(alertHeader.alert);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setFont(BaseTree.boldFont);
        String string = MessageLog.getMessageNoID("STG4036L");
        this.tabbedPane.addTab(string, this.alertEditor.getComponent());
        string = MessageLog.getMessageNoID("STG1006L");
        this.tabbedPane.addTab(string, this.fsSelector.getComponent());
    }

    public CreateHeader getData() {
        AlertHeader alertHeader = (AlertHeader)super.getData();
        NameList[] nameListArray = this.fsSelector.getData();
        alertHeader.alertGroups2 = nameListArray[0];
        alertHeader.alertElements2 = nameListArray[1];
        alertHeader.alertGroups = nameListArray[2];
        alertHeader.alertElements = nameListArray[3];
        alertHeader.alertClusters = nameListArray[4];
        alertHeader.allObjects = this.fsSelector.allFSSelected;
        return alertHeader;
    }

    public void replace(CreateHeader createHeader) {
        super.replace(createHeader);
        AlertHeader alertHeader = (AlertHeader)createHeader;
        NameList[] nameListArray = new NameList[]{alertHeader.alertGroups2, alertHeader.alertElements2, alertHeader.alertGroups, alertHeader.alertElements, alertHeader.alertClusters};
        this.fsSelector.replace(nameListArray, alertHeader.allObjects);
    }

    public void changeOccurred(int n, NameList nameList) {
        if (n == 100) {
            this.fsSelector.invalidateGroups(nameList.nlInfo);
        }
        if (n != 1) {
            return;
        }
        if (nameList.nlInfo == 2) {
            this.fsSelector.addFSGroup(nameList);
        }
    }

    public String getHelpID(int n) {
        switch (n) {
            case 0: {
                return "alfile5";
            }
            case 1: {
                return "alfile10";
            }
        }
        return null;
    }
}

