/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.eclipse.aperi.TStorm.common.Chunk;
import org.eclipse.aperi.TStorm.common.ChunkCollection;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.gui.LogicalVolumeDDI;
import org.eclipse.aperi.TStorm.gui.ReportingObjectBuilder;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.charting.AperiCustomizableChart;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class LogicalVolumeData
extends JTabbedPane
implements ChangeListener,
ReportingObjectBuilder,
GuiRequestor {
    private static GridBagLayout gridBag = new GridBagLayout();
    private static GridBagConstraints gbcFill_1 = new GridBagConstraints();
    private static GridBagConstraints gbcFill_2 = new GridBagConstraints();
    private static GridBagConstraints gbcLabel = new GridBagConstraints();
    private static GridBagConstraints gbcLast = new GridBagConstraints();
    private static final Dimension DIM11 = new Dimension(1, 1);
    private static final String LOGICALVOLUME = "  " + MessageLog.getMessageNoID("STG1215T") + "  ";
    private static final String FILESYSTEM = "  " + MessageLog.getMessageNoID("STG1216T") + "  ";
    private static final String YES = MessageLog.getMessageNoID("GUI0121T");
    private static final String NO = MessageLog.getMessageNoID("GUI0122T");
    private static final String DISK = MessageLog.getMessageNoID("STG1240L");
    private static final String LUN = MessageLog.getMessageNoID("SAG0515L");
    private static final String NOT_MOUNTED = "                     " + MessageLog.getMessageNoID("STG1133T");
    private int lvID;
    private int fsID;
    private int computerID;
    private int tabToDisplay;
    private LogicalVolumeDDI ddi;
    private FilesystemSettable fsSettable;
    private JPanel lvPanel = new JPanel();
    private JScrollPane fsPanel = new JScrollPane();
    private DecimalFormat d0Fmt = new DecimalFormat();

    public LogicalVolumeData(int n, int n2, int n3, int n4, LogicalVolumeDDI logicalVolumeDDI) {
        this(n, n2, n3, n4, logicalVolumeDDI, null);
    }

    private LogicalVolumeData(int n, int n2, int n3, int n4, LogicalVolumeDDI logicalVolumeDDI, FilesystemSettable filesystemSettable) {
        this.lvID = n;
        this.fsID = n2;
        this.computerID = n3;
        this.tabToDisplay = n4;
        this.ddi = logicalVolumeDDI;
        this.fsSettable = filesystemSettable;
        this.getInfo();
        if (logicalVolumeDDI != null) {
            this.setPreferredSize(DIM11);
            this.addChangeListener(this);
        }
        LogicalVolumeData.gbcFill_1.gridheight = 40;
        LogicalVolumeData.gbcFill_1.weighty = 1.0;
        LogicalVolumeData.gbcFill_1.ipadx = 60;
        LogicalVolumeData.gbcFill_2.gridwidth = 4;
        LogicalVolumeData.gbcFill_2.weightx = 1.0;
        LogicalVolumeData.gbcLabel.anchor = 17;
        LogicalVolumeData.gbcLabel.ipadx = 30;
        LogicalVolumeData.gbcLast.anchor = 17;
        LogicalVolumeData.gbcLast.gridwidth = 0;
    }

    public LogicalVolumeData() {
    }

    public Component build(Object object) {
        Filesystem filesystem = (Filesystem)object;
        return LogicalVolumeData.getLvPanel(filesystem.fsLogicalDiskID, filesystem.fsComputerID);
    }

    public static JComponent getFsPanel(int n, FilesystemSettable filesystemSettable) {
        LogicalVolumeData logicalVolumeData = new LogicalVolumeData(-1, n, -1, 0, null, filesystemSettable);
        return logicalVolumeData.fsPanel;
    }

    public static JComponent getLvPanel(int n, int n2) {
        LogicalVolumeData logicalVolumeData = new LogicalVolumeData(n, -1, n2, 0, null, null);
        return logicalVolumeData.lvPanel;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.ddi.tabDisplayed = this.getSelectedIndex();
    }

    private void getInfo() {
        Request request = new Request();
        if (this.lvID > 0) {
            GuiRequest.logicalVolumeInfo(request, this.lvID, this.computerID);
        } else {
            GuiRequest.filesystemInfo(request, this.fsID);
        }
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        if (s <= 4) {
            if (this.lvID > 0) {
                Share share = (Share)response.responseData;
                LogicalDisk logicalDisk = (LogicalDisk)share.shResource;
                if (this.ddi != null) {
                    this.createFS(logicalDisk.ldFilesystem, share);
                }
                this.createLV(logicalDisk);
                if (this.ddi != null && logicalDisk.ldFilesystem != null) {
                    this.setSelectedIndex(this.tabToDisplay);
                }
            } else {
                Share share = (Share)response.responseData;
                this.createFS((Filesystem)share.shResource, share);
                if (this.fsSettable != null) {
                    this.fsSettable.setFilesystem((Filesystem)share.shResource);
                }
            }
        }
    }

    private void createFS(Filesystem filesystem, Share share) {
        if (filesystem == null) {
            return;
        }
        JPanel jPanel = new JPanel(gridBag);
        this.fsPanel.setViewportView(jPanel);
        if (this.ddi != null) {
            this.add(FILESYSTEM, this.fsPanel);
        }
        JLabel jLabel = new JLabel(MessageLog.getMessageNoID("STG1102L"));
        JLabel jLabel2 = new JLabel(MessageLog.getMessageNoID("STG1232L"));
        JLabel jLabel3 = new JLabel(MessageLog.getMessageNoID("STG1221L"));
        JLabel jLabel4 = new JLabel(MessageLog.getMessageNoID("STG1230L"));
        JLabel jLabel5 = new JLabel(MessageLog.getMessageNoID("STG1231L"));
        JLabel jLabel6 = new JLabel(MessageLog.getMessageNoID("STG1220L"));
        JLabel jLabel7 = new JLabel(MessageLog.getMessageNoID("STG1182L"));
        JLabel jLabel8 = new JLabel(MessageLog.getMessageNoID("STG1233L"));
        JLabel jLabel9 = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1134L")) + "    ");
        JLabel jLabel10 = new JLabel(MessageLog.getMessageNoID("STG1229L"));
        JLabel jLabel11 = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1234L")) + "    ");
        JLabel jLabel12 = new JLabel(MessageLog.getMessageNoID("STG1235L"));
        JLabel jLabel13 = new JLabel(MessageLog.getMessageNoID("STG1236L"));
        String string = MessageLog.getMessageNoID("STG1237L");
        String string2 = MessageLog.getMessageNoID("STG1184L");
        JLabel jLabel14 = new JLabel(string);
        JLabel jLabel15 = new JLabel(string2);
        JLabel jLabel16 = new JLabel();
        JLabel jLabel17 = new JLabel();
        JLabel jLabel18 = new JLabel();
        JLabel jLabel19 = new JLabel();
        JLabel jLabel20 = new JLabel();
        JLabel jLabel21 = new JLabel();
        JLabel jLabel22 = new JLabel();
        JLabel jLabel23 = new JLabel();
        JLabel jLabel24 = new JLabel();
        JLabel jLabel25 = new JLabel();
        JLabel jLabel26 = new JLabel();
        JLabel jLabel27 = new JLabel();
        JLabel jLabel28 = new JLabel();
        JLabel jLabel29 = new JLabel();
        JLabel jLabel30 = new JLabel();
        ChartOptions chartOptions = new ChartOptions();
        chartOptions.isTitleCustomizable = false;
        chartOptions.title = (this.ddi == null ? DataDisplayInfo.getCurrent() : this.ddi).getDescription();
        GuiReportReq guiReportReq = new GuiReportReq();
        guiReportReq.reportType = 2;
        AperiCustomizableChart aperiCustomizableChart = new AperiCustomizableChart(1, 7, new Number[][]{{new Double(filesystem.fsUsedSpace * 512L)}, {new Double(filesystem.fsFreeSpace * 512L)}}, new String[]{string, string2}, new String[]{""}, chartOptions, guiReportReq);
        jLabel16.setText(GuiUtil.getComputer((int)filesystem.fsComputerID).gcTSName);
        if (filesystem.fsType == -1) {
            jLabel17.setText(MessageLog.getMessageNoID("STG1020L"));
        } else {
            jLabel17.setText(Filesystem.TYPES[filesystem.fsType + 1]);
        }
        jLabel18.setText(this.numFormat(filesystem.fsUseCount));
        jLabel19.setText(String.valueOf(filesystem.fsMountPoint) + (this.lvID < 0 && this.ddi != null ? NOT_MOUNTED : " "));
        jLabel20.setText(Util.formatBytes(filesystem.fsPhysicalSize * 512L));
        jLabel21.setText(Util.formatBytes(filesystem.fsCapacity * 512L));
        jLabel22.setText(filesystem.fsScanTime < 86400000L ? " " : DateFormat.getDateTimeInstance().format(new Date(filesystem.fsScanTime)));
        jLabel23.setText(share.shScanTime < 86400000L ? " " : DateFormat.getDateTimeInstance().format(new Date(share.shScanTime)));
        jLabel24.setText(filesystem.fsDiscoveredTime < 86400000L ? " " : DateFormat.getDateTimeInstance().format(new Date(filesystem.fsDiscoveredTime)));
        jLabel25.setText(share.shRemovedTime < 86400000L ? " " : DateFormat.getDateTimeInstance().format(new Date(share.shRemovedTime)));
        if (Filesystem.TYPES[filesystem.fsType + 1].equalsIgnoreCase(Filesystem.TYPES[9])) {
            jLabel26.setText(MessageLog.getMessageNoID("STG0019T"));
            jLabel27.setText(MessageLog.getMessageNoID("STG0019T"));
            jLabel28.setText(MessageLog.getMessageNoID("STG0019T"));
        } else {
            jLabel26.setText(this.numFormat(filesystem.fsMaxFiles));
            jLabel27.setText(this.numFormat(filesystem.fsUsedInodes));
            jLabel28.setText(this.numFormat(filesystem.fsFreeInodes));
        }
        jLabel29.setText(Util.formatBytes(filesystem.fsUsedSpace * 512L));
        jLabel30.setText(Util.formatBytes(filesystem.fsFreeSpace * 512L));
        jPanel.add((Component)new JLabel(" "), gbcFill_1);
        jPanel.add((Component)new JLabel(" "), gbcFill_2);
        jPanel.add((Component)new JLabel("     "), gbcLast);
        jPanel.add((Component)jLabel, gbcLabel);
        jPanel.add((Component)jLabel16, gbcLast);
        jPanel.add((Component)jLabel2, gbcLabel);
        jPanel.add((Component)jLabel17, gbcLast);
        jPanel.add((Component)jLabel3, gbcLabel);
        jPanel.add((Component)jLabel18, gbcLast);
        jPanel.add((Component)jLabel4, gbcLabel);
        jPanel.add((Component)jLabel19, gbcLast);
        jPanel.add((Component)jLabel5, gbcLabel);
        jPanel.add((Component)jLabel20, gbcLast);
        jPanel.add((Component)jLabel6, gbcLabel);
        jPanel.add((Component)jLabel21, gbcLast);
        jPanel.add((Component)new JLabel(" "), gbcLast);
        jPanel.add((Component)jLabel7, gbcLabel);
        jPanel.add((Component)jLabel23, gbcLast);
        jPanel.add((Component)jLabel8, gbcLabel);
        jPanel.add((Component)jLabel22, gbcLast);
        jPanel.add((Component)jLabel9, gbcLabel);
        jPanel.add((Component)jLabel24, gbcLast);
        jPanel.add((Component)jLabel10, gbcLabel);
        jPanel.add((Component)jLabel25, gbcLast);
        jPanel.add((Component)jLabel11, gbcLabel);
        jPanel.add((Component)jLabel26, gbcLast);
        jPanel.add((Component)jLabel12, gbcLabel);
        jPanel.add((Component)jLabel27, gbcLast);
        jPanel.add((Component)jLabel13, gbcLabel);
        jPanel.add((Component)jLabel28, gbcLast);
        jPanel.add((Component)jLabel14, gbcLabel);
        jPanel.add((Component)jLabel29, gbcLast);
        jPanel.add((Component)jLabel15, gbcLabel);
        jPanel.add((Component)jLabel30, gbcLast);
        jPanel.add((Component)new JLabel(" "), gbcLast);
        jPanel.add((Component)new JLabel(" "), gbcLabel);
        jPanel.add((Component)aperiCustomizableChart, gbcLast);
    }

    private void createLV(LogicalDisk logicalDisk) {
        JPanel jPanel = GuiUtil.getBorderedPanel();
        BorderLayout borderLayout = new BorderLayout();
        short s = -1;
        this.lvPanel.setLayout(borderLayout);
        this.lvPanel.add((Component)jPanel, "North");
        if (this.ddi != null) {
            this.add(LOGICALVOLUME, this.lvPanel);
            s = this.ddi.getOSType();
        }
        JLabel jLabel = new JLabel(MessageLog.getMessageNoID("STG1219L"));
        JLabel jLabel2 = new JLabel(MessageLog.getMessageNoID("STG1220L"));
        JLabel jLabel3 = new JLabel(MessageLog.getMessageNoID("STG1221L"));
        JLabel jLabel4 = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1222L")) + "    ");
        JLabel jLabel5 = new JLabel(MessageLog.getMessageNoID("STG1223L"));
        JLabel jLabel6 = new JLabel(MessageLog.getMessageNoID("STG6054L"));
        JLabel jLabel7 = new JLabel();
        JLabel jLabel8 = new JLabel();
        JLabel jLabel9 = new JLabel();
        JLabel jLabel10 = new JLabel();
        JLabel jLabel11 = new JLabel();
        JLabel jLabel12 = new JLabel();
        jLabel7.setText(logicalDisk.ldPath);
        jLabel8.setText(Util.formatBytes(logicalDisk.ldCapacity * 512L));
        jLabel9.setText(this.numFormat(logicalDisk.ldUseCount));
        jLabel10.setText(LogicalDisk.TYPES[logicalDisk.ldType]);
        jLabel11.setText(logicalDisk.ldIsSwap ? YES : NO);
        jLabel12.setText(Util.formatBytes(logicalDisk.ldOverhead * 512L));
        jPanel.add((Component)new JLabel(" "), gbcFill_1);
        jPanel.add((Component)new JLabel(" "), gbcFill_2);
        jPanel.add((Component)new JLabel("     "), gbcLast);
        jPanel.add((Component)jLabel, gbcLabel);
        jPanel.add((Component)jLabel7, gbcLast);
        jPanel.add((Component)jLabel2, gbcLabel);
        jPanel.add((Component)jLabel8, gbcLast);
        jPanel.add((Component)jLabel3, gbcLabel);
        jPanel.add((Component)jLabel9, gbcLast);
        jPanel.add((Component)jLabel4, gbcLabel);
        jPanel.add((Component)jLabel10, gbcLast);
        jPanel.add((Component)jLabel5, gbcLabel);
        jPanel.add((Component)jLabel11, gbcLast);
        jPanel.add((Component)jLabel6, gbcLabel);
        jPanel.add((Component)jLabel12, gbcLast);
        jPanel.add((Component)new JLabel(" "), gbcLast);
        this.lvPanel.add((Component)LogicalVolumeData.getLvTree(logicalDisk, s), "Center");
    }

    public static JComponent getLvTree(LogicalDisk logicalDisk, short s) {
        JScrollPane jScrollPane = new JScrollPane();
        String string = logicalDisk.ldPath;
        if (s == 21) {
            int n = logicalDisk.ldPath.indexOf(":");
            if (n > 0) {
                string = logicalDisk.ldPath.substring(0, n);
            }
        } else if (s == 14) {
            string = logicalDisk.ldName;
        } else if (s == 25 || s == 27) {
            string = !Util.isEmpty(string) ? String.valueOf(string) + " (" + logicalDisk.ldDeviceId + ")" : "(" + logicalDisk.ldDeviceId + ")";
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        JTree jTree = new JTree(defaultMutableTreeNode, true);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        jTree.putClientProperty("JTree.lineStyle", "Angled");
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
        logicalDisk.unpack();
        while (logicalDisk != null) {
            if (defaultMutableTreeNode2 != defaultMutableTreeNode) {
                String string2 = s == 21 ? LogicalDisk.VDISK_TYPES[logicalDisk.ldType] : LogicalDisk.TYPES[logicalDisk.ldType];
                if (!Util.isEmpty(logicalDisk.ldPath)) {
                    string2 = logicalDisk.ldPath;
                }
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(string2);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
            ChunkCollection chunkCollection = logicalDisk.ldCollectionList;
            DefaultMutableTreeNode defaultMutableTreeNode3 = null;
            while (chunkCollection != null) {
                if (logicalDisk.ldType != 0) {
                    defaultMutableTreeNode3 = new DefaultMutableTreeNode(ChunkCollection.TYPES[chunkCollection.ccType]);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                }
                Chunk chunk = chunkCollection.ccChunkList;
                int n = -1;
                DefaultMutableTreeNode defaultMutableTreeNode4 = null;
                while (chunk != null) {
                    String string3;
                    String string4;
                    if (chunk.chkDiskID != n) {
                        String string5 = chunk.chkDisk.devType == 5 ? LUN : DISK;
                        defaultMutableTreeNode4 = new DefaultMutableTreeNode(String.valueOf(string5) + " -  " + chunk.chkDisk.devManufacturer);
                        if (logicalDisk.ldType != 0) {
                            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
                        } else {
                            defaultMutableTreeNode2.add(defaultMutableTreeNode4);
                        }
                        n = chunk.chkDiskID;
                    }
                    if (s == 21) {
                        string4 = Util.formatBytes(chunk.chkOffset * 0x100000L);
                        string3 = Util.formatBytes(chunk.chkSize * 0x100000L);
                    } else {
                        string4 = Util.formatBytes(chunk.chkOffset * (long)chunk.chkUnitSize);
                        string3 = Util.formatBytes(chunk.chkSize * (long)chunk.chkUnitSize);
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(MessageLog.getMessageNoID("STG1241L", new Object[]{string4, string3}));
                    defaultMutableTreeNode4.add(defaultMutableTreeNode5);
                    defaultMutableTreeNode5.setAllowsChildren(false);
                    chunk = chunk.chkNextInCollection;
                }
                chunkCollection = chunkCollection.ccNext;
            }
            logicalDisk = logicalDisk.ldNextMirror;
            defaultMutableTreeNode2 = null;
        }
        defaultTreeModel.nodeStructureChanged(defaultMutableTreeNode);
        TreeSelector.expandAll(jTree);
        jScrollPane.setViewportView(jTree);
        return jScrollPane;
    }

    private String numFormat(int n) {
        return this.numFormat((long)n);
    }

    private String numFormat(short s) {
        return this.numFormat((long)s);
    }

    private String numFormat(long l) {
        this.d0Fmt.setMaximumFractionDigits(2);
        return l < 0L ? MessageLog.getMessageNoID("STG0019T") : this.d0Fmt.format(l);
    }

    public static interface FilesystemSettable {
        public void setFilesystem(Filesystem var1);
    }
}

