/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.util.Enumeration;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportingFSGroupSelector
implements TreeExpansionListener,
GuiRequestor,
TreeSelector.Reparenter {
    private TreeSelector selector;
    private JTree selectedTree;
    private JTree sourceTree;
    private NameList[] selections;
    private NameList rootName;
    private TreeSelectorNode sourceFSGroupLabel;
    private TreeSelectorNode sourceCompGroupLabel;
    private TreeSelectorNode expansionNode;
    private DefaultTreeModel expansionModel;
    private boolean expandedComputer;
    private TreeSet fsSet = new TreeSet();
    private TreeSet excludeSet = new TreeSet();
    private JTree expansionTree;
    private boolean compsOnly;
    private String allObjectsLabel;
    public boolean allFSSelected;
    private boolean resourcesAvailable;
    private static final int ROOT_ID = -4;
    private static final int REPORTING_GROUP_ID = -2;
    private static final int FS_GROUP_ID = -3;
    private static final int FS_ID = -1;
    private static final int ALL_FS_ID = Integer.MAX_VALUE;
    private static final int N_INDICES = 4;
    private int excludeMe;
    private int returnedObjectType;
    private int parentId;
    private NameList computer;
    private boolean disbledFSObjects;
    private boolean initialLoad;
    private int savedID;
    private boolean showLeafFS = false;

    public ReportingFSGroupSelector() {
    }

    public ReportingFSGroupSelector(NameList[] nameListArray, int n, boolean bl, boolean bl2) {
        this.selections = nameListArray;
        this.excludeMe = n;
        this.allFSSelected = bl;
        this.compsOnly = bl2;
        this.initialLoad = true;
    }

    public ReportingFSGroupSelector(NameList[] nameListArray, int n, boolean bl) {
        this(nameListArray, n, bl, false);
    }

    public JPanel getComponent() {
        if (this.selector != null) {
            return this.selector;
        }
        this.buildSourceTree();
        this.buildSelectedTree();
        this.selector = new TreeSelector(this.sourceTree, this.selectedTree, this);
        return this.selector;
    }

    public NameList[] getData() {
        this.allFSSelected = false;
        NameList[] nameListArray = new NameList[4];
        NameList[] nameListArray2 = new NameList[4];
        short s = 0;
        NameList nameList = this.selector.getNameList();
        while (nameList != null) {
            s = nameList.nlInfo;
            if (s > 3) {
                if (s == 13) {
                    this.allFSSelected = true;
                }
                nameList = nameList.nlNext;
                continue;
            }
            NameList nameList2 = nameList;
            nameList = nameList2.nlNext;
            nameList2.nlNext = null;
            if (nameListArray2[s] == null) {
                nameListArray[s] = nameList2;
            } else {
                nameListArray2[s].nlNext = nameList2;
            }
            nameListArray2[s] = nameList2;
        }
        return nameListArray;
    }

    private void buildSourceTree() {
        TreeSelectorNode treeSelectorNode = this.newRoot();
        if (!this.compsOnly) {
            this.sourceFSGroupLabel = this.addFSGroupLabel(treeSelectorNode);
            this.addReportingGroupLabel(treeSelectorNode);
            this.addFSLabel(treeSelectorNode);
        }
        this.sourceTree = new JTree(treeSelectorNode, true);
        this.sourceTree.addTreeExpansionListener(this);
    }

    private TreeSelectorNode buildSelectedTreeStructure() {
        TreeSelectorNode treeSelectorNode = null;
        TreeSelectorNode treeSelectorNode2 = null;
        TreeSelectorNode treeSelectorNode3 = null;
        TreeSelectorNode treeSelectorNode4 = this.newRoot();
        NameList nameList = this.selections[2];
        while (nameList != null) {
            if (treeSelectorNode == null) {
                treeSelectorNode = this.addFSGroupLabel(treeSelectorNode4);
            }
            treeSelectorNode.add(new TreeSelectorNode(nameList, true, false, true, true, null));
            nameList = nameList.nlNext;
        }
        nameList = this.selections[4];
        while (nameList != null) {
            if (treeSelectorNode3 == null) {
                treeSelectorNode3 = this.addReportingGroupLabel(treeSelectorNode4);
            }
            treeSelectorNode3.add(new TreeSelectorNode(nameList, true, false, true, true, null, true, true));
            nameList = nameList.nlNext;
        }
        this.fillSets(this.selections[3], true, false);
        if (this.allFSSelected && !this.compsOnly || !this.fsSet.isEmpty()) {
            treeSelectorNode2 = this.addFSLabel(treeSelectorNode4);
            this.addTreeSet(treeSelectorNode2, this.fsSet);
        }
        this.fillSetsForReporting(this.selections[4], true, false);
        return treeSelectorNode4;
    }

    private void buildSelectedTree() {
        TreeSelectorNode treeSelectorNode = this.buildSelectedTreeStructure();
        this.selectedTree = new JTree(treeSelectorNode, true);
        this.selectedTree.addTreeExpansionListener(this);
    }

    public void replace(NameList[] nameListArray, boolean bl) {
        this.selections = nameListArray;
        this.allFSSelected = bl;
        this.fsSet.clear();
        this.excludeSet.clear();
        TreeSelectorNode treeSelectorNode = this.buildSelectedTreeStructure();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.selectedTree.getModel();
        defaultTreeModel.setRoot(treeSelectorNode);
        this.selector.setUpExcludes();
    }

    private void fillSets(NameList nameList, boolean bl, boolean bl2) {
        int n = -1;
        int n2 = -1;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        while (nameList != null) {
            Cloneable cloneable;
            TreeSet treeSet;
            int n3;
            if ((nameList.nlState & 1) != 0) {
                n3 = n2;
                treeSet = this.excludeSet;
                defaultMutableTreeNode3 = defaultMutableTreeNode2;
            } else {
                n3 = n;
                treeSet = this.fsSet;
                defaultMutableTreeNode3 = defaultMutableTreeNode;
            }
            if (nameList.nlID2 != n3) {
                GComputer gComputer = GuiUtil.getComputer(nameList.nlID2);
                short s = 1;
                if (Constants.isVirtualServer(gComputer.gcOsType)) {
                    s = gComputer.gcOsType;
                }
                cloneable = this.newNameList(gComputer.gcTSName, nameList.nlID2, s, 1, gComputer.gcClusterName, gComputer.gcHostedNodeName, gComputer.gcClusterID);
                defaultMutableTreeNode3 = new TreeSelectorNode((NameList)cloneable, false, false, true, false, null, true, true);
                ((TreeSelectorNode)defaultMutableTreeNode3).setButtonFlag(false);
                treeSet.add(defaultMutableTreeNode3);
                if ((nameList.nlState & 1) != 0) {
                    n2 = nameList.nlID2;
                    defaultMutableTreeNode2 = defaultMutableTreeNode3;
                } else {
                    n = nameList.nlID2;
                    defaultMutableTreeNode = defaultMutableTreeNode3;
                }
            }
            cloneable = new TreeSelectorNode(nameList, bl, false, false, false, null, true, true);
            if (this.disbledFSObjects) {
                cloneable.setButtonFlag(false);
            }
            if (this.initialLoad) {
                cloneable.setButtonFlag(true);
            }
            defaultMutableTreeNode3.add((MutableTreeNode)((Object)cloneable));
            nameList = nameList.nlNext;
        }
    }

    private void fillSetsForReporting(NameList nameList, boolean bl, boolean bl2) {
        TreeSelectorNode treeSelectorNode = null;
        while (nameList != null) {
            boolean bl3;
            boolean bl4;
            TreeSet treeSet;
            if ((nameList.nlState & 1) != 0) {
                treeSet = this.excludeSet;
                bl4 = false;
                bl3 = true;
            } else {
                treeSet = this.fsSet;
                bl4 = bl;
                bl3 = bl2;
            }
            treeSelectorNode = new TreeSelectorNode(nameList, bl4, bl3, false, false, null, true, true);
            treeSet.add(treeSelectorNode);
            nameList = nameList.nlNext;
        }
    }

    private void addTreeSet(TreeSelectorNode treeSelectorNode, TreeSet treeSet) {
        for (TreeSelectorNode treeSelectorNode2 : treeSet) {
            treeSelectorNode.add(treeSelectorNode2);
        }
    }

    public static void invalidateGroups(TreeSelector treeSelector, JTree jTree, short s) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        TreeSelectorNode treeSelectorNode = (TreeSelectorNode)defaultTreeModel.getRoot();
        Enumeration<TreeNode> enumeration = treeSelectorNode.breadthFirstEnumeration();
        boolean bl = true;
        while (bl && enumeration.hasMoreElements()) {
            treeSelectorNode = (TreeSelectorNode)enumeration.nextElement();
            int n = treeSelectorNode.getLevel();
            if (n != 2) {
                if (n <= 2) continue;
                bl = false;
                continue;
            }
            NameList nameList = treeSelectorNode.getNameList();
            if (nameList.nlInfo != s) continue;
            treeSelector.nodeUnselected(treeSelectorNode);
            MutableTreeNode mutableTreeNode = (MutableTreeNode)treeSelectorNode.getParent();
            int n2 = mutableTreeNode.getIndex(treeSelectorNode);
            defaultTreeModel.removeNodeFromParent(treeSelectorNode);
            treeSelectorNode = new TreeSelectorNode(nameList, true, false, true, true, null, true, true);
            defaultTreeModel.insertNodeInto(treeSelectorNode, mutableTreeNode, n2);
        }
    }

    public void invalidateGroups(short s) {
        ReportingFSGroupSelector.invalidateGroups(this.selector, this.selectedTree, s);
    }

    private void addGroup(TreeSelectorNode treeSelectorNode, NameList nameList) {
        if (!treeSelectorNode.childrenFetched) {
            return;
        }
        NameList nameList2 = (NameList)nameList.clone();
        TreeSelectorNode treeSelectorNode2 = new TreeSelectorNode(nameList2, true, false, true, true, null, true, true);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.sourceTree.getModel();
        this.selector.addChild(defaultTreeModel, treeSelectorNode, treeSelectorNode2);
    }

    public void addFSGroup(NameList nameList) {
        this.addGroup(this.sourceFSGroupLabel, nameList);
    }

    public void addComputerGroup(NameList nameList) {
        this.addGroup(this.sourceCompGroupLabel, nameList);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.initialLoad = false;
        TreePath treePath = treeExpansionEvent.getPath();
        this.expansionNode = (TreeSelectorNode)treePath.getLastPathComponent();
        if (this.expansionNode.childrenFetched) {
            return;
        }
        NameList nameList = this.expansionNode.getNameList();
        this.expansionTree = (JTree)treeExpansionEvent.getSource();
        this.expansionModel = (DefaultTreeModel)this.expansionTree.getModel();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        this.expandedComputer = false;
        if (this.expansionTree == this.sourceTree) {
            switch (nameList.nlID) {
                case -3: {
                    this.showLeafFS = false;
                    n = 2;
                    break;
                }
                case -1: {
                    this.showLeafFS = true;
                    n = 3;
                    this.disbledFSObjects = false;
                    break;
                }
                case -2: {
                    this.showLeafFS = false;
                    n = 90;
                    break;
                }
                default: {
                    if (nameList.nlInfo == 90) {
                        n = 90;
                        this.returnedObjectType = 1;
                        break;
                    }
                    if (nameList.nlInfo == 1 && nameList.nlID2 != 0) {
                        boolean bl = nameList.nlInfo == 1 && nameList.nlID2 != 0;
                        n = 1;
                        this.returnedObjectType = 2;
                        this.computer = this.newNameList(nameList.nlName, nameList.nlID, 0, nameList.nlID2, nameList.nlClusterName, nameList.nlHostName, nameList.nlClusterID);
                        break;
                    }
                    if (nameList.nlInfo == 2 || nameList.nlInfo == 0) {
                        this.disbledFSObjects = true;
                        n = nameList.nlInfo + 1;
                        n2 = nameList.nlID;
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (nameList.nlInfo == 2 || nameList.nlInfo == 0) {
            this.disbledFSObjects = true;
            n = nameList.nlInfo + 1;
            n2 = nameList.nlID;
        } else if (nameList.nlInfo == 1 && this.expansionNode.selectable) {
            n = 3;
            n3 = nameList.nlID;
            this.expandedComputer = true;
        } else if (nameList.nlInfo == 90) {
            n = 90;
            this.returnedObjectType = 1;
        } else if (nameList.nlInfo == 1 && nameList.nlID2 != 0) {
            n = 1;
            this.returnedObjectType = 2;
            this.computer = this.newNameList(nameList.nlName, nameList.nlID, 0, nameList.nlID2, nameList.nlClusterName, nameList.nlHostName, nameList.nlClusterID);
        } else if (nameList.nlInfo == 1 && nameList.nlID2 != 0) {
            n = 98;
            this.returnedObjectType = 1;
        } else if (nameList.nlInfo == 13) {
            n = this.compsOnly ? 1 : 3;
        }
        if (n >= 0 && this.returnedObjectType == 0) {
            GuiListReq guiListReq = new GuiListReq();
            guiListReq.listRequested = 10000 + n;
            guiListReq.groupID = n2;
            guiListReq.computerID = n3;
            Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", guiListReq);
            request.flags = (byte)5;
            GuiClient.doRequest(this, request);
        } else if (n == 90 && this.returnedObjectType == 1) {
            this.sendGroupListRequest((short)98, nameList.nlID);
            this.parentId = nameList.nlID;
        }
    }

    private GroupDefinition makeGroupListRequestData(short s, int n) {
        GroupDefinition groupDefinition = new GroupDefinition();
        groupDefinition.groupType = s;
        groupDefinition.ID = n;
        return groupDefinition;
    }

    private void sendGroupListRequest(short s, int n) {
        GroupDefinition groupDefinition = this.makeGroupListRequestData(s, n);
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", groupDefinition);
        GuiClient.doRequest(this, request);
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        if (this.returnedObjectType == 1 || this.returnedObjectType == 2) {
            this.processGroupList(response);
            this.returnedObjectType = 0;
        } else {
            this.processNameList(response);
        }
    }

    private void processGroupList(Response response) {
        Object object;
        if (response.responseData instanceof NameList) {
            this.processNameList(response);
            return;
        }
        GroupDefinition groupDefinition = (GroupDefinition)response.responseData;
        if (groupDefinition == null) {
            return;
        }
        NameList nameList = groupDefinition.members;
        NameList nameList2 = groupDefinition.maskList;
        if (nameList == null && nameList2 == null) {
            return;
        }
        this.expansionNode.childrenFetched = true;
        this.expansionNode.removeAllChildren();
        TreeSelectorNode treeSelectorNode = null;
        if (nameList != null) {
            while (nameList != null) {
                if (nameList.nlInfo == 2) {
                    object = Util.getString("STG4227L", Util.getTranslatedName(nameList.nlName));
                    nameList.nlName = object;
                    treeSelectorNode = new TreeSelectorNode(nameList, false, false, true, false, null);
                    treeSelectorNode.setButtonFlag(false);
                } else if (nameList.nlInfo == 3) {
                    object = this.newNameList(nameList.nlName, nameList.nlID, nameList.nlID2, 3, nameList.nlClusterName, nameList.nlHostName, nameList.nlClusterID);
                    treeSelectorNode = new TreeSelectorNode((NameList)object, false, false, false);
                    treeSelectorNode.setButtonFlag(false);
                } else if (nameList.nlInfo == 1) {
                    object = this.newNameList(nameList.nlName, nameList.nlID, this.parentId, 1, nameList.nlClusterName, nameList.nlHostName, nameList.nlClusterID);
                    treeSelectorNode = new TreeSelectorNode((NameList)object, false, false, true, false, null, true, true);
                    treeSelectorNode.setButtonFlag(false);
                } else if (nameList.nlInfo == 90) {
                    nameList.nlName = object = Util.getString("STG4228L", Util.getTranslatedName(nameList.nlName));
                    treeSelectorNode = new TreeSelectorNode(nameList, false, false, true, false, null);
                    treeSelectorNode.setButtonFlag(false);
                }
                if (treeSelectorNode != null) {
                    this.expansionNode.add(treeSelectorNode);
                }
                nameList = nameList.nlNext;
            }
        }
        if (nameList2 != null) {
            while (nameList2 != null) {
                object = "";
                TreeSelectorNode treeSelectorNode2 = null;
                object = Util.getString("STG4229L", Util.getTranslatedName(nameList2.nlName));
                nameList2.nlName = object;
                treeSelectorNode2 = new TreeSelectorNode(nameList2, false, false, false, false, null);
                treeSelectorNode2.setButtonFlag(false);
                if (treeSelectorNode2 != null) {
                    this.expansionNode.add(treeSelectorNode2);
                }
                nameList2 = nameList2.nlNext;
            }
        } else {
            boolean bl = this.expansionTree == this.sourceTree;
            boolean bl2 = !bl;
            this.fsSet.clear();
            this.fillSets(nameList, bl, bl2);
            this.addTreeSet(this.expansionNode, this.fsSet);
        }
        this.expansionModel.nodeStructureChanged(this.expansionNode);
        if (this.expansionTree == this.selectedTree) {
            this.selector.pruneExcluded(this.expansionNode);
        } else {
            this.selector.pruneSelected(this.expansionNode, this.expansionNode.hiOrderSortKey);
        }
    }

    public void processNameList(Response response) {
        if (response.responseData instanceof GroupDefinition) {
            this.processGroupList(response);
            return;
        }
        NameList nameList = (NameList)response.responseData;
        if (nameList == null) {
            this.resourcesAvailable = true;
            return;
        }
        this.expansionNode.childrenFetched = true;
        this.expansionNode.removeAllChildren();
        if (nameList.nlInfo == 2) {
            while (nameList != null) {
                TreeSelectorNode treeSelectorNode = new TreeSelectorNode(nameList, true, false, true, true, null);
                this.expansionNode.add(treeSelectorNode);
                nameList = nameList.nlNext;
            }
        } else if (nameList.nlInfo == 0) {
            while (nameList != null) {
                TreeSelectorNode treeSelectorNode = new TreeSelectorNode(nameList, false, false, false, true, null);
                this.expansionNode.add(treeSelectorNode);
                nameList = nameList.nlNext;
            }
        } else if (nameList.nlInfo == 90) {
            while (nameList != null) {
                TreeSelectorNode treeSelectorNode = null;
                if (nameList.nlID != this.excludeMe && nameList.nlID != this.savedID) {
                    treeSelectorNode = new TreeSelectorNode(nameList, true, false, true, true, null, true, true);
                    this.expansionNode.add(treeSelectorNode);
                }
                nameList = nameList.nlNext;
            }
        } else {
            boolean bl;
            boolean bl2 = this.expansionTree == this.sourceTree;
            boolean bl3 = bl = !bl2;
            if (nameList.nlInfo == 3) {
                if (this.expandedComputer) {
                    while (nameList != null) {
                        TreeSelectorNode treeSelectorNode = new TreeSelectorNode(nameList, bl2, bl, false, false, null, true, true);
                        this.expansionNode.add(treeSelectorNode);
                        nameList = nameList.nlNext;
                    }
                } else {
                    this.fsSet.clear();
                    if (this.expansionNode.getUserObject().toString().equals(Util.getString("STG1006L"))) {
                        this.fillSets(nameList, true, bl);
                    } else {
                        this.fillSets(nameList, false, bl);
                    }
                    this.addTreeSet(this.expansionNode, this.fsSet);
                }
            } else {
                boolean bl4 = bl2 && nameList.nlInfo == 1;
                while (nameList != null) {
                    TreeSelectorNode treeSelectorNode = new TreeSelectorNode(nameList, bl2, bl, false, bl4, null, true, true);
                    this.expansionNode.add(treeSelectorNode);
                    nameList = nameList.nlNext;
                }
            }
        }
        this.expansionModel.nodeStructureChanged(this.expansionNode);
        if (this.expansionTree == this.selectedTree) {
            this.selector.pruneExcluded(this.expansionNode);
        } else {
            this.selector.pruneSelected(this.expansionNode, this.expansionNode.hiOrderSortKey);
        }
        this.resourcesAvailable = true;
    }

    private TreeSelectorNode newRoot() {
        if (this.rootName == null) {
            this.rootName = this.newNameList("", -4, -1, 0, null, null, 0);
        }
        return new TreeSelectorNode(this.rootName, false, false, true);
    }

    private TreeSelectorNode addReportingGroupLabel(TreeSelectorNode treeSelectorNode) {
        return this.addLabelNode("STG4226L", -2, treeSelectorNode);
    }

    private TreeSelectorNode addFSGroupLabel(TreeSelectorNode treeSelectorNode) {
        return this.addLabelNode("STG4032L", -3, treeSelectorNode);
    }

    private TreeSelectorNode makeFSLabel() {
        return this.makeLabelNode("STG1006L", -1);
    }

    private TreeSelectorNode addFSLabel(TreeSelectorNode treeSelectorNode) {
        TreeSelectorNode treeSelectorNode2 = this.makeFSLabel();
        treeSelectorNode.add(treeSelectorNode2);
        return treeSelectorNode2;
    }

    private TreeSelectorNode makeLabelNode(String string, int n) {
        String string2 = MessageLog.getMessageNoID(string);
        NameList nameList = this.newNameList(string2, n, 0, -1, null, null, 0);
        TreeSelectorNode treeSelectorNode = new TreeSelectorNode(nameList, false, false, true);
        treeSelectorNode.setButtonFlag(false);
        treeSelectorNode.setSortKey(n);
        return treeSelectorNode;
    }

    private TreeSelectorNode addLabelNode(String string, int n, TreeSelectorNode treeSelectorNode) {
        TreeSelectorNode treeSelectorNode2 = this.makeLabelNode(string, n);
        treeSelectorNode.add(treeSelectorNode2);
        return treeSelectorNode2;
    }

    private void addAllFSNode(TreeSelectorNode treeSelectorNode, boolean bl) {
        NameList nameList = this.newNameList(this.allObjectsLabel, Integer.MAX_VALUE, 0, 13, null, null, 0);
        TreeSelectorNode treeSelectorNode2 = new TreeSelectorNode(nameList, true, false, bl, true, null);
        treeSelectorNode2.setSortKey(-1);
        treeSelectorNode.insert(treeSelectorNode2, 0);
    }

    private NameList newNameList(String string, int n, int n2, int n3, String string2, String string3, int n4) {
        NameList nameList = new NameList();
        nameList.nlName = string;
        nameList.nlID = n;
        nameList.nlID2 = n2;
        nameList.nlInfo = (short)n3;
        nameList.nlClusterName = string2;
        nameList.nlHostName = string3;
        nameList.nlClusterID = n4;
        return nameList;
    }

    public TreeSelectorNode reparent(TreeSelectorNode treeSelectorNode, NameList nameList, MutableInteger mutableInteger) {
        TreeSelectorNode treeSelectorNode2 = null;
        Enumeration<TreeNode> enumeration = treeSelectorNode.children();
        boolean bl = true;
        int n = 0;
        while (bl && enumeration.hasMoreElements()) {
            treeSelectorNode2 = (TreeSelectorNode)enumeration.nextElement();
        }
        if (bl) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.selectedTree.getModel();
            defaultTreeModel.insertNodeInto(treeSelectorNode2, treeSelectorNode, n);
        }
        return treeSelectorNode2;
    }

    public JTree getSourceTree() {
        return this.sourceTree;
    }

    public JTree getSelectedTree() {
        return this.selectedTree;
    }

    public TreeSelector getTreeSelector() {
        return this.selector;
    }

    public boolean getResourcesAvailable() {
        return this.resourcesAvailable;
    }

    public void hideSavedID(int n) {
        this.savedID = n;
    }
}

