/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.control;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.aperi.JobLogDeletionHandler;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.control.TokenHeartbeat;
import org.eclipse.aperi.control.data.ControlConstants;
import org.eclipse.aperi.control.data.JobInfo;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.control.interfaces.IControlEngine;
import org.eclipse.aperi.control.interfaces.InvalidTokenException;
import org.eclipse.aperi.control.interfaces.JobInProgressException;
import org.eclipse.aperi.disk.resources.DMJobMessages;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.interfaces.IController;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class ControlEngine
implements IControlEngine {
    private static ControlEngine instance = null;
    private Integer tokenTimeout = null;
    private ArrayList<Token> validTokens = new ArrayList();
    private Token internalToken = null;
    public Hashtable tokenTable = new Hashtable();
    private Hashtable subJobStatus = new Hashtable();
    private Hashtable jobsBelongingToTokens = new Hashtable();
    ILogger msgLogger = ControlConstants.msgLogger;
    ILogger traceLogger = ControlConstants.traceLogger;
    static final String className = ControlEngine.class.getName();

    public static synchronized ControlEngine getInstance() {
        if (instance == null) {
            instance = new ControlEngine();
        }
        return instance;
    }

    private ControlEngine() {
        String string = "ControlEngine";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        this.internalToken = new Token("internalToken", "XX", -1, "ControlEngine", 2, "");
        this.validTokens.add(this.internalToken);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
    }

    public synchronized String startJob(Token token, String string, boolean bl, boolean bl2) throws Exception {
        ArrayList<JobInfo> arrayList;
        JobInfo jobInfo;
        ILogger iLogger;
        String string2;
        String string3;
        String string4;
        block12: {
            TokenHeartbeat tokenHeartbeat;
            block11: {
                string4 = "startJob";
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string4);
                }
                this.checkToken(token);
                tokenHeartbeat = this.startTokenHeartbeat(token);
                string3 = new Integer(ServiceUtils.getJobIdentifier(bl2, 7)).toString();
                string2 = new Integer(ServiceUtils.getJobIdentifier(bl2, 2)).toString();
                iLogger = null;
                if (bl2) {
                    try {
                        iLogger = LogManagerFactory.getJobLogger("control", string3, string2);
                        iLogger.setMessageFile(DMJobMessages.class.getName());
                    }
                    catch (Exception exception) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, this, string4, exception);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block11;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string4, exception);
                    }
                }
            }
            jobInfo = new JobInfo(string3, string2, bl);
            jobInfo.setJobStatus(2);
            jobInfo.setToken(token);
            jobInfo.setHeartBeat(tokenHeartbeat);
            jobInfo.setJobLogger(iLogger);
            ServiceUtils.activeJobs.put(string3, jobInfo);
            if (bl2) {
                arrayList = "";
                if (iLogger != null) {
                    arrayList = LogManagerFactory.getLogFileName(iLogger);
                }
                ServiceUtils.createJobRecord(Integer.parseInt(string3), Integer.parseInt(string2), string, (String)((Object)arrayList));
                try {
                    JobLogDeletionHandler.purgeControlLogFiles();
                }
                catch (Exception exception) {
                    if (!this.traceLogger.isLogging()) break block12;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string4, exception);
                    this.traceLogger.text(IRecordType.TYPE_INFORMATION, className, string4, "Error during job log deletion : RUN ID=" + string3 + ", Job ID=" + string2);
                }
            }
        }
        this.subJobStatus.put(string3, new ArrayList());
        token.setJobId(string3);
        arrayList = (ArrayList)this.jobsBelongingToTokens.get(token);
        if (arrayList == null) {
            arrayList = new ArrayList<JobInfo>();
        }
        arrayList.add(jobInfo);
        this.jobsBelongingToTokens.put(token, arrayList);
        if (iLogger != null) {
            iLogger.message(IRecordType.TYPE_INFORMATION, (Object)className, string4, "ControlService_jobStarted", new String[]{string3, string2, string});
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string4);
        }
        return string3;
    }

    public synchronized int startSubJob(Token token, String string, boolean bl) throws Exception {
        String string2 = "startSubJob";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string2);
        }
        int n = -1;
        String string3 = token.getJobId();
        ArrayList arrayList = (ArrayList)this.subJobStatus.get(string3);
        if (arrayList != null) {
            Object object;
            int n2 = Integer.parseInt(string3);
            String string4 = null;
            ILogger iLogger = null;
            if (n2 >= 0) {
                string4 = new Integer(ServiceUtils.getJobIdentifier(bl, 2)).toString();
                if (bl) {
                    object = "";
                    JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(string3);
                    if (jobInfo != null && jobInfo.getJobLogger() != null) {
                        iLogger = jobInfo.getJobLogger();
                        object = LogManagerFactory.getLogFileName(iLogger);
                    }
                    ServiceUtils.createJobRecord(Integer.parseInt(string3), Integer.parseInt(string4), string, (String)object);
                }
            } else {
                string4 = new Integer(ServiceUtils.getJobIdentifier(false, 2)).toString();
            }
            object = new AsyncResult(0, 2);
            ((AsyncResult)object).setJobId(string4);
            n = arrayList.size();
            arrayList.add(n, object);
            if (iLogger != null) {
                iLogger.message(IRecordType.TYPE_INFORMATION, (Object)className, string2, "ControlService_childJobStarted", new String[]{string4, string});
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return n;
    }

    public synchronized boolean endJob(Token token, int n, int n2, SRMMessage sRMMessage, Exception exception, Object[] objectArray) throws Exception {
        String string = "endJob";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        boolean bl = false;
        String string2 = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(string2);
        if (jobInfo != null) {
            String string3 = jobInfo.getJobId();
            jobInfo.setJobStatus(n2);
            int n3 = Integer.parseInt(string2);
            if (n3 >= 0) {
                ServiceUtils.updateJobRecord(n3, Integer.parseInt(string3), n2, n);
            }
            if (n2 == 2) {
                ServiceUtils.activeJobs.put(string2, jobInfo);
            } else {
                Object object;
                TokenHeartbeat tokenHeartbeat = jobInfo.getHeartBeat();
                this.stopTokenHeartbeat(tokenHeartbeat);
                if (jobInfo.isAsyncJob()) {
                    object = new AsyncResult(n, n2, sRMMessage);
                    ((AsyncResult)object).setJobId(string2);
                    ((AsyncResult)object).setReturnException(exception);
                    ((Result)object).setResults(objectArray);
                    AsyncResult asyncResult = this.getActiveJobResults(string2);
                    if (asyncResult != null) {
                        ((AsyncResult)object).setSubJobResults(asyncResult.getSubJobResults());
                    }
                    ServiceUtils.completedJobResults.put(string2, object);
                }
                ServiceUtils.activeJobs.remove(string2);
                this.subJobStatus.remove(string2);
                object = jobInfo.getJobLogger();
                if (object != null) {
                    object.message(IRecordType.TYPE_INFORMATION, (Object)className, string, "ControlService_jobFinished", new String[]{jobInfo.getDeviceServerRunNumber(), jobInfo.getJobId(), new Integer(jobInfo.getJobStatus()).toString(), new Integer(n).toString()});
                    LogManagerFactory.returnJobLogger(jobInfo.getJobLogger());
                }
                bl = true;
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return bl;
    }

    public synchronized boolean endSubJob(Token token, int n, int n2, int n3, SRMMessage sRMMessage, Exception exception, Object[] objectArray) throws Exception {
        String string = "endSubJob";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        boolean bl = false;
        String string2 = token.getJobId();
        ArrayList arrayList = (ArrayList)this.subJobStatus.get(string2);
        if (arrayList != null && n >= 0) {
            AsyncResult asyncResult;
            ILogger iLogger;
            block11: {
                iLogger = null;
                asyncResult = null;
                try {
                    asyncResult = (AsyncResult)arrayList.get(n);
                }
                catch (Exception exception2) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, this, string, exception2);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block11;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception2);
                }
            }
            if (asyncResult != null) {
                String string3;
                block12: {
                    Object object;
                    string3 = asyncResult.getJobId();
                    int n4 = Integer.parseInt(string3);
                    if (n4 >= 0) {
                        ServiceUtils.updateJobRecord(Integer.parseInt(string2), n4, n3, n2);
                        object = (JobInfo)ServiceUtils.activeJobs.get(string2);
                        if (object != null) {
                            iLogger = ((JobInfo)object).getJobLogger();
                        }
                    }
                    object = new AsyncResult(n2, n3, sRMMessage);
                    ((AsyncResult)object).setJobId(string3);
                    ((AsyncResult)object).setReturnException(exception);
                    ((Result)object).setResults(objectArray);
                    try {
                        arrayList.set(n, object);
                        bl = true;
                    }
                    catch (Exception exception3) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, this, string, exception3);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block12;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception3);
                    }
                }
                if (iLogger != null) {
                    iLogger.message(IRecordType.TYPE_INFORMATION, (Object)className, string, "ControlService_childJobFinished", new String[]{string3, new Integer(n3).toString(), new Integer(n2).toString()});
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return bl;
    }

    public AsyncResult processReturnObj(Token token, Object object) {
        String string = "processReturnObj";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        AsyncResult asyncResult = new AsyncResult(0, 1);
        asyncResult.setJobId(token.getJobId());
        if (object != null) {
            if (object instanceof AsyncResult) {
                asyncResult = new AsyncResult(((AsyncResult)object).getRc(), ((AsyncResult)object).getStatus(), ((AsyncResult)object).getSRMMessage());
                asyncResult.setJobId(token.getJobId());
                asyncResult.setReturnException(((AsyncResult)object).getReturnException());
                asyncResult.setResults(((AsyncResult)object).getResults());
            } else if (object instanceof Result) {
                int n = ((Result)object).getRc();
                int n2 = 1;
                if (n != 0) {
                    n2 = 0;
                }
                asyncResult = new AsyncResult(n, n2, ((Result)object).getSRMMessage());
                asyncResult.setJobId(token.getJobId());
                asyncResult.setResults(((Result)object).getResults());
            } else if (object instanceof Integer) {
                int n = (Integer)object;
                asyncResult.setRc(n);
                if (n != 0) {
                    asyncResult.setStatus(0);
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return asyncResult;
    }

    public ILogger getJobLogger(Token token) {
        String string = "getJobLogger";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        ILogger iLogger = null;
        String string2 = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(string2);
        if (jobInfo != null) {
            iLogger = jobInfo.getJobLogger();
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return iLogger;
    }

    public synchronized void addAsyncThreadToJob(Token token, IController iController) {
        String string;
        JobInfo jobInfo;
        String string2 = "addAsyncThreadToJob";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string2);
        }
        if ((jobInfo = (JobInfo)ServiceUtils.activeJobs.get(string = token.getJobId())) != null) {
            jobInfo.setController(iController);
            ServiceUtils.activeJobs.put(string, jobInfo);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    public boolean isJobActive(String string) {
        String string2 = "isJobActive";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string2);
        }
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(string);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return jobInfo != null;
    }

    public void cancelJob(String string) {
        String string2;
        block6: {
            JobInfo jobInfo;
            string2 = "cancelJob";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string2);
            }
            if ((jobInfo = (JobInfo)ServiceUtils.activeJobs.get(string)) != null) {
                IController iController = jobInfo.getController();
                if (iController != null) {
                    iController.shutdown();
                }
                try {
                    this.endJob(jobInfo.getToken(), -47, 5, null, null, null);
                }
                catch (Exception exception) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, this, string2, exception);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block6;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    public AsyncResult getJobResults(String string) {
        String string2 = "getJobResults";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string2);
        }
        AsyncResult asyncResult = (AsyncResult)ServiceUtils.completedJobResults.get(string);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return asyncResult;
    }

    public AsyncResult getActiveJobResults(String string) {
        String string2 = "getActiveJobResults";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string2);
        }
        AsyncResult asyncResult = null;
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(string);
        if (jobInfo != null) {
            asyncResult = new AsyncResult(0, 2);
            asyncResult.setJobId(string);
            ArrayList arrayList = (ArrayList)this.subJobStatus.get(string);
            if (arrayList != null && arrayList.size() > 0) {
                AsyncResult[] asyncResultArray = arrayList.toArray(new AsyncResult[0]);
                asyncResult.setSubJobResults(asyncResultArray);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return asyncResult;
    }

    public int getJobStatus(String string) {
        String string2 = "getJobStatus";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string2);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return ServiceUtils.getJobStatus(string).getStatus();
    }

    public AsyncResult waitForJobToComplete(String string) {
        String string2 = "waitForJobToComplete";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string2);
        }
        while (this.isJobActive(string)) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return this.getJobResults(string);
    }

    public String[] getJobIds(Token token) {
        String string = "getJobIds";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        String[] stringArray = null;
        ArrayList arrayList = (ArrayList)this.jobsBelongingToTokens.get(token);
        if (arrayList != null) {
            JobInfo[] jobInfoArray = arrayList.toArray(new JobInfo[0]);
            stringArray = new String[jobInfoArray.length];
            int n = 0;
            while (n < jobInfoArray.length) {
                stringArray[n] = new String(jobInfoArray[n].getDeviceServerRunNumber());
                ++n;
            }
        } else {
            stringArray = new String[]{};
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return stringArray;
    }

    public void setTokenForProxyThread(Thread thread, Token token) {
        String string = "setTokenForProxyThread";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        this.tokenTable.put(thread, token);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
    }

    public Token getTokenForProxyThread(Thread thread) {
        String string = "getTokenForProxyThread";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return (Token)this.tokenTable.get(thread);
    }

    public void removeTokenForProxyThread(Thread thread) {
        String string = "getTokenForProxyThread";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        this.tokenTable.remove(thread);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
    }

    public long getTokenUpdateInterval() {
        int n;
        long l;
        String string = "getTokenUpdateInterval";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, className, string);
        }
        if ((l = (long)((n = this.getTokenTimeout()) - 60)) <= (long)(n / 2)) {
            l = n / 2;
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return l * 1000L;
    }

    private int getTokenTimeout() {
        String string = "getTokenTimeout";
        if (this.tokenTimeout == null) {
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_API, className, string);
            }
            try {
                IConfigService iConfigService = (IConfigService)Activator._serviceHelper.bindLocal("ConfigService");
                String string2 = iConfigService.getProperty("ZoneTokenTimeout", "user");
                if (string2 != null) {
                    this.tokenTimeout = Integer.parseInt(string2);
                } else {
                    iConfigService.setProperty("ZoneTokenTimeout", "user", String.valueOf(300));
                    this.tokenTimeout = 300;
                }
            }
            catch (Exception exception) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, this, string, exception);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                }
                this.tokenTimeout = 300;
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
            }
        }
        return this.tokenTimeout;
    }

    public Token getDBToken(String string, String string2, String string3, int n) {
        String string4 = "getDBToken";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string4);
        }
        Token token = null;
        if (n == 1) {
            DBConnection dBConnection = null;
            try {
                try {
                    dBConnection = ServiceUtils.getConnection();
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_ID"), string);
                    hashtable.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_TYPE"), string2);
                    org.eclipse.aperi.infrastructure.database.objects.Token token2 = org.eclipse.aperi.infrastructure.database.objects.Token.retrieve(dBConnection, hashtable);
                    if (token2 != null) {
                        token = new Token(token2.getResId(), token2.getResType(), token2.getTokenId(), string3, n, token2.getUserId(), token2.getInitialTstamp().getTime());
                    }
                }
                catch (Exception exception) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, this, string4, exception);
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string4, exception);
                    }
                }
            }
            finally {
                block18: {
                    if (dBConnection != null) {
                        try {
                            dBConnection.commit();
                            dBConnection.close();
                        }
                        catch (Exception exception) {
                            this.msgLogger.exception(IRecordType.TYPE_ERR, this, string4, exception);
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) break block18;
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string4, exception);
                        }
                    }
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string4);
        }
        return token;
    }

    /*
     * Unable to fully structure code
     */
    public Token createToken(String var1_1, String var2_2, String var3_3, int var4_4, String var5_5) {
        block21: {
            var6_6 = "createToken";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, ControlEngine.className, var6_6);
            }
            var7_7 = null;
            if (var4_4 == 1) {
                var8_8 = null;
                var9_11 = false;
                var10_12 = -1;
                try {
                    try {
                        var10_12 = AutoIdentifier.getIdentifier(8, 1);
                        var8_8 = ServiceUtils.getConnection();
                        var11_13 = CurrentTime.getTimestamp(var8_8);
                        var12_15 = new org.eclipse.aperi.infrastructure.database.objects.Token();
                        var12_15.setTstamp(var11_13);
                        var12_15.setResId(var1_1);
                        var12_15.setResType(var2_2);
                        var12_15.setTokenId(var10_12);
                        var12_15.setUserId(var5_5);
                        var12_15.setInitialTstamp(var11_13);
                        var12_15.insert(var8_8);
                        var9_11 = true;
                    }
                    catch (Exception var11_14) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, this, var6_6, var11_14);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) ** GOTO lbl52
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ControlEngine.className, var6_6, var11_14);
                    }
                }
                finally {
                    block20: {
                        if (var8_8 != null) {
                            try {
                                var8_8.commit();
                                var8_8.close();
                            }
                            catch (Exception var14_18) {
                                this.msgLogger.exception(IRecordType.TYPE_ERR, this, var6_6, var14_18);
                                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block20;
                                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ControlEngine.className, var6_6, var14_18);
                            }
                        }
                    }
                    if (var9_11) {
                        var7_7 = this.getDBToken(var1_1, var2_2, var3_3, var4_4);
                    }
                }
            } else {
                try {
                    var8_9 = AutoIdentifier.getIdentifier(8, 1);
                    var7_7 = new Token(var1_1, var2_2, var8_9, var3_3, var4_4, var5_5);
                }
                catch (Exception var8_10) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, this, var6_6, var8_10);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block21;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ControlEngine.className, var6_6, var8_10);
                }
            }
        }
        if (var7_7 != null) {
            this.validTokens.add(var7_7);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, ControlEngine.className, var6_6);
        }
        return var7_7;
    }

    public void removeToken(String string, String string2) {
        String string3 = "removeToken";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string3);
        }
        DBConnection dBConnection = null;
        try {
            try {
                dBConnection = ServiceUtils.getConnection();
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_ID"), string);
                hashtable.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_TYPE"), string2);
                org.eclipse.aperi.infrastructure.database.objects.Token.deletes(dBConnection, hashtable);
            }
            catch (Exception exception) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, this, string3, exception);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string3, exception);
                }
            }
        }
        finally {
            block16: {
                if (dBConnection != null) {
                    try {
                        dBConnection.commit();
                        dBConnection.close();
                    }
                    catch (Exception exception) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, this, string3, exception);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block16;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string3, exception);
                    }
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string3);
        }
    }

    private boolean isTokenValid(Token token) {
        String string = "isTokenValid";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        boolean bl = false;
        Timestamp timestamp = null;
        Timestamp timestamp2 = null;
        DBConnection dBConnection = null;
        try {
            try {
                dBConnection = ServiceUtils.getConnection();
                timestamp = CurrentTime.getTimestamp(dBConnection);
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("TOKEN_ID"), String.valueOf(token.getTokenId()));
                hashtable.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_ID"), token.getResource());
                hashtable.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_TYPE"), token.getResourceType());
                org.eclipse.aperi.infrastructure.database.objects.Token token2 = org.eclipse.aperi.infrastructure.database.objects.Token.retrieve(dBConnection, hashtable);
                if (token2 != null) {
                    long l;
                    timestamp2 = token2.getTstamp();
                    long l2 = timestamp.getTime() + (long)(timestamp.getNanos() / 1000000);
                    if (l2 - (l = timestamp2.getTime() + (long)(timestamp2.getNanos() / 1000000)) <= (long)(this.getTokenTimeout() * 1000)) {
                        bl = true;
                    }
                }
            }
            catch (Exception exception) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, this, string, exception);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                }
            }
        }
        finally {
            block18: {
                if (dBConnection != null) {
                    try {
                        dBConnection.commit();
                        dBConnection.close();
                    }
                    catch (Exception exception) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, this, string, exception);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block18;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                    }
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return bl;
    }

    public void checkToken(Token token) throws InvalidTokenException, JobInProgressException {
        String string = "checkToken";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        if (token == null) {
            throw new InvalidTokenException();
        }
        if (!this.validTokens.contains(token)) {
            token.setValid(false);
            throw new InvalidTokenException();
        }
        if (token.getAccessType() == 1) {
            Token token2 = this.getDBToken(token.getResource(), token.getResourceType(), token.getClient(), token.getAccessType());
            if (token2 != null) {
                if (token == null || !token.equals(token2) || !this.isTokenValid(token2)) {
                    token.setValid(false);
                    throw new InvalidTokenException();
                }
            } else {
                token.setValid(false);
                throw new InvalidTokenException();
            }
            String[] stringArray = this.getJobIds(token);
            int n = 0;
            while (n < stringArray.length) {
                if (this.isJobActive(stringArray[n])) {
                    throw new JobInProgressException();
                }
                ++n;
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
    }

    private TokenHeartbeat startTokenHeartbeat(Token token) {
        String string = "startTokenHeartbeat";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, className, string);
        }
        TokenHeartbeat tokenHeartbeat = null;
        if (token.getAccessType() == 1) {
            if (this.updateTokenTimestamp(token) != 1 && this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string, "Unable to update Token for SAN " + token.getResource() + " client " + token.getClient());
            }
            long l = this.getTokenUpdateInterval();
            tokenHeartbeat = new TokenHeartbeat(this, token, l);
            tokenHeartbeat.start();
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return tokenHeartbeat;
    }

    private void stopTokenHeartbeat(TokenHeartbeat tokenHeartbeat) {
        String string = "stopTokenHeartbeat";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, className, string);
        }
        if (tokenHeartbeat != null) {
            try {
                try {
                    if (tokenHeartbeat != null && !tokenHeartbeat.isDone()) {
                        tokenHeartbeat.shutdown();
                        tokenHeartbeat.join(30000L);
                    }
                }
                catch (Exception exception) {
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                    }
                }
            }
            finally {
                tokenHeartbeat = null;
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
    }

    public int updateTokenTimestamp(Token token) {
        String string = "updateTokenTimestamp";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, className, string);
        }
        if (token.getAccessType() != 1) {
            return 1;
        }
        Timestamp timestamp = null;
        DBConnection dBConnection = null;
        int n = 0;
        try {
            try {
                dBConnection = ServiceUtils.getConnection();
                timestamp = CurrentTime.getTimestamp(dBConnection);
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("TOKEN_ID"), String.valueOf(token.getTokenId()));
                hashtable.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_ID"), token.getResource());
                hashtable.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_TYPE"), token.getResourceType());
                Hashtable<ColumnInfo, Timestamp> hashtable2 = new Hashtable<ColumnInfo, Timestamp>();
                hashtable2.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("TSTAMP"), timestamp);
                n = org.eclipse.aperi.infrastructure.database.objects.Token.update(dBConnection, hashtable2, hashtable);
            }
            catch (Exception exception) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, this, string, exception);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                }
            }
        }
        finally {
            block17: {
                if (dBConnection != null) {
                    try {
                        dBConnection.commit();
                        dBConnection.close();
                    }
                    catch (Exception exception) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, this, string, exception);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block17;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                    }
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return n;
    }

    public synchronized void shutdown() {
        String string = "shutdown";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, className, string);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
    }

    public void removeTokenFromJobs(Token token) {
        this.jobsBelongingToTokens.remove(token);
    }

    public void removeTokenFromValidTokens(Token token) {
        this.validTokens.remove(token);
    }

    public Token getInternalToken() {
        return this.internalToken;
    }
}

