/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.aperi.common.dbaccess.ViewReportTablesUpdater;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.discovery.RemoveMissingUtils;
import org.eclipse.aperi.discovery.interfaces.IRemoveMissingProcessor;
import org.eclipse.aperi.disk.api.IDiskManagementService;
import org.eclipse.aperi.disk.api.IDiskManagerService;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.discovery.SubsystemDBHelper;
import org.eclipse.aperi.gui.tape.common.model.TapeLibraryDBHelper;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.Fabric;
import org.eclipse.aperi.infrastructure.database.objects.Fabric2switch;
import org.eclipse.aperi.infrastructure.database.objects.Hba;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.infrastructure.database.objects.Node;
import org.eclipse.aperi.infrastructure.database.objects.Node2hba;
import org.eclipse.aperi.infrastructure.database.objects.Pe2node;
import org.eclipse.aperi.infrastructure.database.objects.PhyPe;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.Port2port;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.database.objects.Switch2port;
import org.eclipse.aperi.infrastructure.database.objects.SwitchBlade;
import org.eclipse.aperi.infrastructure.database.objects.Zone;
import org.eclipse.aperi.infrastructure.database.objects.Zone2member;
import org.eclipse.aperi.infrastructure.database.objects.ZoneMember;
import org.eclipse.aperi.infrastructure.database.objects.Zset;
import org.eclipse.aperi.infrastructure.database.objects.Zset2zone;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.monitor.eventcorrelator.data.DeviceDeletedEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.SRMEvent;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class RemoveMissingProcessor
implements IRemoveMissingProcessor {
    private static final String className = RemoveMissingProcessor.class.getName();
    public static final String MESSAGE_NAME = "aperi.logger.message.RemoveMissing";
    public static final String TRACE_NAME = "aperi.logger.trace.RemoveMissing";
    public static String MSG_FILE = "org.eclipse.aperi.resources.RemoveMissingProcessorTMS";
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;
    private static HashMap classMap = new HashMap();
    HashSet entityGroups = null;
    private IDiskManagementService cMgmtOps = null;
    private TapeLibraryDBHelper cTapeDBHelper = null;
    private boolean isHostRemovable = true;
    private String mDeviceServerHost = null;
    private int mDeviceServerPort = -1;
    private static boolean TRACE = TraceLogger.enableTrace;

    public RemoveMissingProcessor() {
        this(null, -1);
    }

    public RemoveMissingProcessor(String string, int n) {
        msgLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
        this.mDeviceServerHost = string;
        this.mDeviceServerPort = n;
        this.cMgmtOps = (IDiskManagementService)ConnectorClient.getService((String)string, (int)n, IDiskManagerService.class, (String)"DiskManagerService");
        this.cTapeDBHelper = new TapeLibraryDBHelper();
        TRACE = TraceLogger.enableTrace;
    }

    public synchronized short performDeletionForSelectedMissingEntities(String[] stringArray) {
        Object object;
        boolean bl;
        String string;
        block17: {
            string = "performDeletionForSelectedMissingEntities";
            bl = false;
            DBConnection dBConnection = null;
            this.isHostRemovable = true;
            if (TRACE) {
                TraceLogger.entry(className, string, stringArray.toString());
                object = "";
                if (stringArray != null && stringArray.length > 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = 0;
                    while (n < stringArray.length) {
                        stringBuffer.append(stringArray[n]);
                        stringBuffer.append("||");
                        ++n;
                    }
                    object = String.valueOf(stringArray.length) + " missing entities: " + stringBuffer.toString() + " are selected.";
                    TraceLogger.traceMessage(1, className, string, (String)object);
                } else {
                    object = "No missing entity selected.";
                    TraceLogger.traceMessage(1, className, string, (String)object);
                }
            }
            try {
                try {
                    dBConnection = RemoveMissingUtils.getDBConnection();
                    object = this.determineSelectedMissingList(stringArray, dBConnection);
                    if (!((HashSet)object).isEmpty()) {
                        bl = this.processDeleteMissing((HashSet)object, dBConnection);
                        break block17;
                    }
                    bl = true;
                }
                catch (Exception exception) {
                    TraceLogger.exception(className, string, exception);
                }
            }
            finally {
                RemoveMissingUtils.closeConnection(dBConnection);
            }
        }
        if (!this.isHostRemovable) {
            if (bl) {
                if (TRACE) {
                    object = "Remove success except selected host is not removable.";
                    TraceLogger.traceMessage(1, className, string, (String)object);
                    TraceLogger.exit(className, string);
                }
                return 100;
            }
            if (TRACE) {
                object = "Remove failed and selected host is not removable.";
                TraceLogger.traceMessage(1, className, string, (String)object);
                TraceLogger.exit(className, string);
            }
            return 12;
        }
        if (bl) {
            if (TRACE) {
                object = "Remove success.";
                TraceLogger.traceMessage(1, className, string, (String)object);
                TraceLogger.exit(className, string);
            }
            return 0;
        }
        if (TRACE) {
            object = "Remove failed.";
            TraceLogger.traceMessage(1, className, string, (String)object);
            TraceLogger.exit(className, string);
        }
        return 12;
    }

    public synchronized short performScheduledDeletionForMissingEntity(String string, String string2) {
        HashSet<String> hashSet;
        String[] stringArray;
        short s;
        String string3;
        block31: {
            DBConnection dBConnection;
            DBResultSet dBResultSet;
            block30: {
                string3 = "performScheduledDeletionForMissingEntity";
                s = 0;
                stringArray = null;
                hashSet = new HashSet<String>();
                String string4 = null;
                dBResultSet = null;
                dBConnection = null;
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_ENTRY, className, string3);
                }
                if (string2 != null) {
                    stringArray = new String[]{String.valueOf(string) + ':' + string2};
                } else {
                    try {
                        try {
                            String string5;
                            dBConnection = RemoveMissingUtils.getDBConnection();
                            if (string.equals("switch")) {
                                dBResultSet = RemoveMissingUtils.getAllMissingSwitches(string4, dBConnection);
                                while (dBResultSet.next()) {
                                    string5 = "" + dBResultSet.getInt("switchId");
                                    hashSet.add("switch:" + string5);
                                }
                            } else if (string.equals("fabric")) {
                                dBResultSet = RemoveMissingUtils.getAllMissingFabrics(string4, dBConnection);
                                while (dBResultSet.next()) {
                                    string5 = "" + dBResultSet.getInt("fabricId");
                                    hashSet.add("fabric:" + string5);
                                }
                            } else if (string.equals("tapelibrary")) {
                                dBResultSet = RemoveMissingUtils.getAllMissingTapeLibraries(string4, dBConnection);
                                while (dBResultSet.next()) {
                                    string5 = "" + dBResultSet.getInt("libId");
                                    hashSet.add("tapelibrary:" + string5);
                                }
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            break block30;
                        }
                    }
                    catch (Throwable throwable) {
                        if (dBResultSet != null) {
                            try {
                                dBResultSet.getStatement().close();
                            }
                            catch (Exception exception) {}
                        }
                        RemoveMissingUtils.closeConnection(dBConnection);
                        throw throwable;
                    }
                    if (dBResultSet != null) {
                        try {
                            dBResultSet.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    RemoveMissingUtils.closeConnection(dBConnection);
                }
                break block31;
            }
            if (dBResultSet != null) {
                try {
                    dBResultSet.getStatement().close();
                }
                catch (Exception exception) {}
            }
            RemoveMissingUtils.closeConnection(dBConnection);
        }
        try {
            if (hashSet.size() > 0) {
                stringArray = hashSet.toArray(new String[0]);
            }
            if (stringArray != null) {
                s = this.performDeletionForSelectedMissingEntities(stringArray);
            }
        }
        catch (Exception exception) {
            traceLogger.exception(IRecordType.TYPE_ERROR, className, string3, exception);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string3);
        }
        return s;
    }

    public synchronized boolean performScheduledFabricDeletion() {
        String string = "performScheduledFabricDeletion";
        short s = 12;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        if (TRACE) {
            TraceLogger.entry(className, string, "");
        }
        String[] stringArray = this.getExpiredFabricEntities();
        DBConnection dBConnection = null;
        if (TRACE) {
            CharSequence charSequence;
            if (stringArray != null && stringArray.length > 0) {
                charSequence = new StringBuffer();
                int n = 0;
                while (n < stringArray.length) {
                    ((StringBuffer)charSequence).append(stringArray[n]);
                    ((StringBuffer)charSequence).append("||");
                    ++n;
                }
                String string2 = "Deleting " + stringArray.length + " required missing obects...";
                TraceLogger.traceMessage(1, className, string, string2);
            } else {
                charSequence = "No required missing entity found.";
                TraceLogger.traceMessage(1, className, string, (String)charSequence);
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            try {
                try {
                    dBConnection = RemoveMissingUtils.getDBConnection();
                    dBConnection.setAutoCommit(false);
                    int n = 0;
                    while (n < stringArray.length) {
                        int n2 = stringArray[n].indexOf(58);
                        String string3 = stringArray[n].substring(0, n2);
                        String string4 = stringArray[n].substring(n2 + 1);
                        this.deleteEntityWithRetry(string3, string4, dBConnection);
                        ++n;
                    }
                    dBConnection.commit();
                    s = 0;
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    try {
                        dBConnection.rollback();
                    }
                    catch (SQLException sQLException2) {
                        sQLException2.printStackTrace();
                    }
                }
            }
            finally {
                RemoveMissingUtils.closeConnection(dBConnection);
            }
        } else {
            s = 0;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string, s);
        }
        if (s == 0) {
            if (TRACE) {
                String string5 = "Success";
                TraceLogger.traceMessage(1, className, string, string5);
            }
            return true;
        }
        if (TRACE) {
            String string6 = "Failed.";
            TraceLogger.traceMessage(1, className, string, string6);
        }
        return false;
    }

    public synchronized boolean performScheduledTapeDeletion() {
        boolean bl;
        String string = "performScheduledTapeDeletion";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        short s = 12;
        if (TRACE) {
            TraceLogger.entry(className, string, "");
        }
        String[] stringArray = this.getExpiredTapeLibraries();
        if (TRACE) {
            CharSequence charSequence;
            if (stringArray != null && stringArray.length > 0) {
                charSequence = new StringBuffer();
                int n = 0;
                while (n < stringArray.length) {
                    ((StringBuffer)charSequence).append(stringArray[n]);
                    ((StringBuffer)charSequence).append("||");
                    ++n;
                }
                String string2 = "Deleting " + stringArray.length + " required missing obects...";
                TraceLogger.traceMessage(1, className, string, string2);
            } else {
                charSequence = "No required missing entity found.";
                TraceLogger.traceMessage(1, className, string, (String)charSequence);
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            try {
                int n = 0;
                while (n < stringArray.length) {
                    int n2 = stringArray[n].indexOf(58);
                    String string3 = stringArray[n].substring(0, n2);
                    String string4 = stringArray[n].substring(n2 + 1);
                    this.handleTape(string3, string4);
                    ++n;
                }
            }
            catch (Exception exception) {
                if (TRACE) {
                    TraceLogger.exception(className, string, exception);
                }
                s = 12;
            }
        }
        s = (bl = this.handleExpiredTapeSubentities()) ? (short)0 : 12;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string, s);
        }
        if (s == 0) {
            if (TRACE) {
                String string5 = "Success";
                TraceLogger.traceMessage(1, className, string, string5);
            }
            return true;
        }
        if (TRACE) {
            String string6 = "Failed.";
            TraceLogger.traceMessage(1, className, string, string6);
        }
        return false;
    }

    public synchronized boolean performScheduledSubsystemDeletion() {
        boolean bl;
        String string = "performScheduledSubsystemDeletion";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        short s = 12;
        if (TRACE) {
            TraceLogger.entry(className, string, "");
        }
        String[] stringArray = this.getExpiredSubsystems();
        if (TRACE) {
            CharSequence charSequence;
            if (stringArray != null && stringArray.length > 0) {
                charSequence = new StringBuffer();
                int n = 0;
                while (n < stringArray.length) {
                    ((StringBuffer)charSequence).append(stringArray[n]);
                    ((StringBuffer)charSequence).append("||");
                    ++n;
                }
                String string2 = "Deleting " + stringArray.length + " required missing obects...";
                TraceLogger.traceMessage(1, className, string, string2);
            } else {
                charSequence = "No required missing entity found.";
                TraceLogger.traceMessage(1, className, string, (String)charSequence);
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            try {
                int n = 0;
                while (n < stringArray.length) {
                    int n2 = stringArray[n].indexOf(58);
                    String string3 = stringArray[n].substring(0, n2);
                    String string4 = stringArray[n].substring(n2 + 1);
                    this.handleSubsystem(string3, string4);
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                s = 12;
            }
        }
        s = (bl = this.handleExpiredSubsystemSubentities()) ? (short)0 : 12;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string, s);
        }
        if (s == 0) {
            if (TRACE) {
                String string5 = "Success";
                TraceLogger.traceMessage(1, className, string, string5);
            }
            return true;
        }
        if (TRACE) {
            String string6 = "Failed.";
            TraceLogger.traceMessage(1, className, string, string6);
        }
        return false;
    }

    /*
     * Loose catch block
     */
    private String[] getExpiredFabricEntities() {
        block7: {
            DBConnection dBConnection;
            block6: {
                block5: {
                    String[] stringArray;
                    String string = "getExpiredFabricEntities";
                    ArrayList arrayList = new ArrayList();
                    dBConnection = RemoveMissingUtils.getDBConnection();
                    if (RemoveMissingUtils.isBadConnection(string, dBConnection)) {
                        return null;
                    }
                    try {
                        String[] stringArray2;
                        arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("fabric", dBConnection));
                        arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("fabric2switch", dBConnection));
                        arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("switch", dBConnection));
                        arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("blade", dBConnection));
                        arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("switch2port", dBConnection));
                        arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("host", dBConnection));
                        arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("hba", dBConnection));
                        arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("node2hba", dBConnection));
                        arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("pe", dBConnection));
                        arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("pe2node", dBConnection));
                        arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("node", dBConnection));
                        arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("port", dBConnection));
                        arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("port2port", dBConnection));
                        if (arrayList == null) break block5;
                        stringArray = stringArray2 = arrayList.toArray(new String[arrayList.size()]);
                    }
                    catch (Throwable throwable) {
                        RemoveMissingUtils.closeConnection(dBConnection);
                        throw throwable;
                    }
                    RemoveMissingUtils.closeConnection(dBConnection);
                    return stringArray;
                    {
                        catch (Exception exception) {
                            exception.printStackTrace();
                            break block6;
                        }
                    }
                }
                RemoveMissingUtils.closeConnection(dBConnection);
                break block7;
            }
            RemoveMissingUtils.closeConnection(dBConnection);
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private String[] getExpiredTapeLibraries() {
        block7: {
            DBConnection dBConnection;
            block6: {
                block5: {
                    String[] stringArray;
                    String string = "getExpiredFabricEntities";
                    ArrayList arrayList = null;
                    dBConnection = RemoveMissingUtils.getDBConnection();
                    if (RemoveMissingUtils.isBadConnection(string, dBConnection)) {
                        return null;
                    }
                    try {
                        String[] stringArray2;
                        arrayList = RemoveMissingUtils.getExpiredMissingEntities("tapelibrary", dBConnection);
                        if (arrayList == null) break block5;
                        stringArray = stringArray2 = arrayList.toArray(new String[arrayList.size()]);
                    }
                    catch (Throwable throwable) {
                        RemoveMissingUtils.closeConnection(dBConnection);
                        throw throwable;
                    }
                    RemoveMissingUtils.closeConnection(dBConnection);
                    return stringArray;
                    {
                        catch (Exception exception) {
                            exception.printStackTrace();
                            break block6;
                        }
                    }
                }
                RemoveMissingUtils.closeConnection(dBConnection);
                break block7;
            }
            RemoveMissingUtils.closeConnection(dBConnection);
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private String[] getExpiredSubsystems() {
        block7: {
            DBConnection dBConnection;
            block6: {
                block5: {
                    String[] stringArray;
                    String string = "getExpiredFabricEntities";
                    ArrayList arrayList = null;
                    dBConnection = RemoveMissingUtils.getDBConnection();
                    if (RemoveMissingUtils.isBadConnection(string, dBConnection)) {
                        return null;
                    }
                    try {
                        String[] stringArray2;
                        arrayList = RemoveMissingUtils.getExpiredMissingEntities("subsystem", dBConnection);
                        if (arrayList == null) break block5;
                        stringArray = stringArray2 = arrayList.toArray(new String[arrayList.size()]);
                    }
                    catch (Throwable throwable) {
                        RemoveMissingUtils.closeConnection(dBConnection);
                        throw throwable;
                    }
                    RemoveMissingUtils.closeConnection(dBConnection);
                    return stringArray;
                    {
                        catch (Exception exception) {
                            exception.printStackTrace();
                            break block6;
                        }
                    }
                }
                RemoveMissingUtils.closeConnection(dBConnection);
                break block7;
            }
            RemoveMissingUtils.closeConnection(dBConnection);
        }
        return null;
    }

    private boolean handleExpiredTapeSubentities() {
        String string = "handleExpiredTapesubentities";
        if (TRACE) {
            TraceLogger.entry(className, string, "");
        }
        boolean bl = false;
        boolean bl2 = false;
        ArrayList arrayList = null;
        Integer[] integerArray = null;
        int n = 0;
        DBConnection dBConnection = RemoveMissingUtils.getDBConnection();
        if (RemoveMissingUtils.isBadConnection(string, dBConnection)) {
            return false;
        }
        try {
            try {
                int n2;
                arrayList = RemoveMissingUtils.getExpiredMissingEntities("tapedrive", "tapelibrary", dBConnection);
                if (arrayList != null && arrayList.size() != 0) {
                    integerArray = arrayList.toArray(new Integer[arrayList.size()]);
                    bl = this.cTapeDBHelper.deleteTapeDrivesByID(RemoveMissingProcessor.getPrimitiveIntArray(integerArray));
                    if (TRACE) {
                        if (!bl) {
                            TraceLogger.traceMessage(1, className, string, "Error while deleting tape drives. some missing tape drives may not have been deleted.");
                        }
                        TraceLogger.traceMessage(1, className, string, "List of expired tape drives:");
                        n += integerArray.length;
                        n2 = 0;
                        while (n2 < integerArray.length) {
                            TraceLogger.traceMessage(1, className, string, "entity[" + n2 + "]=" + integerArray[n2]);
                            ++n2;
                        }
                    }
                }
                arrayList = null;
                integerArray = null;
                arrayList = RemoveMissingUtils.getExpiredMissingEntities("tapemediachanger", "tapelibrary", dBConnection);
                if (arrayList != null && arrayList.size() != 0) {
                    integerArray = arrayList.toArray(new Integer[arrayList.size()]);
                    bl2 = this.cTapeDBHelper.deleteTapeMediaChangersByID(RemoveMissingProcessor.getPrimitiveIntArray(integerArray));
                    if (TRACE) {
                        if (!bl2) {
                            TraceLogger.traceMessage(1, className, string, "Error while deleting tape media changers. some expired missing media changers may not have been deleted.");
                        }
                        TraceLogger.traceMessage(1, className, string, "List of expired tape media changers:");
                        n += integerArray.length;
                        n2 = 0;
                        while (n2 < integerArray.length) {
                            TraceLogger.traceMessage(1, className, string, "entity[" + n2 + "]=" + integerArray[n2]);
                            ++n2;
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (TRACE) {
                    TraceLogger.exception(className, string, exception);
                }
                RemoveMissingUtils.closeConnection(dBConnection);
                return false;
            }
        }
        finally {
            RemoveMissingUtils.closeConnection(dBConnection);
        }
        if (n == 0 && TRACE) {
            TraceLogger.traceMessage(1, className, string, "No expired subsystem subentities found.");
            TraceLogger.exit(className, string);
        }
        return bl2 && bl;
    }

    private boolean handleExpiredSubsystemSubentities() {
        String string = "handleExpiredSubsystemSubentities";
        if (TRACE) {
            TraceLogger.entry(className, string, "");
        }
        boolean bl = true;
        ArrayList arrayList = null;
        Integer[] integerArray = null;
        int n = 0;
        DBConnection dBConnection = RemoveMissingUtils.getDBConnection();
        if (RemoveMissingUtils.isBadConnection(string, dBConnection)) {
            return false;
        }
        try {
            try {
                int n2;
                arrayList = RemoveMissingUtils.getExpiredMissingEntities("storagevolume", "subsystem", dBConnection);
                if (arrayList != null && arrayList.size() != 0) {
                    integerArray = arrayList.toArray(new Integer[arrayList.size()]);
                    bl = SubsystemDBHelper.deleteStorageVolumes(RemoveMissingProcessor.getPrimitiveIntArray(integerArray));
                    if (TRACE) {
                        TraceLogger.traceMessage(1, className, string, "List of expired storage volumes:");
                    }
                    n += integerArray.length;
                    n2 = 0;
                    while (n2 < integerArray.length) {
                        if (TRACE) {
                            TraceLogger.traceMessage(1, className, string, "entity[" + n2 + "]=" + integerArray[n2]);
                        }
                        ++n2;
                    }
                }
                arrayList = null;
                integerArray = null;
                arrayList = RemoveMissingUtils.getExpiredMissingEntities("storagepool", "subsystem", dBConnection);
                if (arrayList != null && arrayList.size() != 0) {
                    integerArray = arrayList.toArray(new Integer[arrayList.size()]);
                    boolean bl2 = bl = bl && SubsystemDBHelper.deleteStoragePools(RemoveMissingProcessor.getPrimitiveIntArray(integerArray));
                    if (TRACE) {
                        TraceLogger.traceMessage(1, className, string, "List of expired storage pools:");
                    }
                    n += integerArray.length;
                    n2 = 0;
                    while (n2 < integerArray.length) {
                        if (TRACE) {
                            TraceLogger.traceMessage(1, className, string, "entity[" + n2 + "]=" + integerArray[n2]);
                        }
                        ++n2;
                    }
                }
                arrayList = null;
                integerArray = null;
                arrayList = RemoveMissingUtils.getExpiredMissingEntities("physicalvolume", "subsystem", dBConnection);
                if (arrayList != null && arrayList.size() != 0) {
                    integerArray = arrayList.toArray(new Integer[arrayList.size()]);
                    boolean bl3 = bl = bl && SubsystemDBHelper.deletePhysicalVolumes(RemoveMissingProcessor.getPrimitiveIntArray(integerArray));
                    if (TRACE) {
                        TraceLogger.traceMessage(1, className, string, "List of expired physical volumes:");
                    }
                    n += integerArray.length;
                    n2 = 0;
                    while (n2 < integerArray.length) {
                        if (TRACE) {
                            TraceLogger.traceMessage(1, className, string, "entity[" + n2 + "]=" + integerArray[n2]);
                        }
                        ++n2;
                    }
                }
                arrayList = null;
                integerArray = null;
                arrayList = RemoveMissingUtils.getExpiredMissingEntities("port", "subsystem", dBConnection);
                if (arrayList != null && arrayList.size() != 0) {
                    integerArray = arrayList.toArray(new Integer[arrayList.size()]);
                    boolean bl4 = bl = bl && SubsystemDBHelper.deletePorts(RemoveMissingProcessor.getPrimitiveIntArray(integerArray));
                    if (TRACE) {
                        TraceLogger.traceMessage(1, className, string, "List of expired subsystem ports:");
                    }
                    n += integerArray.length;
                    n2 = 0;
                    while (n2 < integerArray.length) {
                        if (TRACE) {
                            TraceLogger.traceMessage(1, className, string, "entity[" + n2 + "]=" + integerArray[n2]);
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                if (TRACE) {
                    TraceLogger.exception(className, string, exception);
                }
                RemoveMissingUtils.closeConnection(dBConnection);
                return false;
            }
        }
        finally {
            RemoveMissingUtils.closeConnection(dBConnection);
        }
        if (n == 0 && TRACE) {
            TraceLogger.traceMessage(1, className, string, "No expired subsystem subentities found.");
            TraceLogger.exit(className, string);
        }
        return bl;
    }

    private HashSet determineMissingEntitiesByDeviceTypes(String[] stringArray, String string, DBConnection dBConnection) {
        HashSet hashSet;
        String string2;
        block40: {
            DBResultSet dBResultSet;
            block38: {
                string2 = "detrmineMissingEntitiesByDeviceTypes";
                HashSet<String> hashSet2 = new HashSet<String>();
                hashSet = new HashSet();
                dBResultSet = null;
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, stringArray);
                }
                try {
                    try {
                        int n = 0;
                        while (n < stringArray.length) {
                            block39: {
                                block36: {
                                    String string3 = stringArray[n];
                                    try {
                                        try {
                                            String string4;
                                            if (string3.equals("switch")) {
                                                dBResultSet = RemoveMissingUtils.getAllMissingSwitches(string, dBConnection);
                                                while (dBResultSet.next()) {
                                                    string4 = "" + dBResultSet.getInt("switchId");
                                                    hashSet2.add("switch:" + string4);
                                                }
                                            } else if (string3.equals("fabric")) {
                                                dBResultSet = RemoveMissingUtils.getAllMissingFabrics(string, dBConnection);
                                                while (dBResultSet.next()) {
                                                    string4 = "" + dBResultSet.getInt("fabricId");
                                                    hashSet2.add("fabric:" + string4);
                                                }
                                            }
                                        }
                                        catch (Exception exception) {
                                            if (!traceLogger.isLogging()) break block36;
                                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                                            break block36;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        if (dBResultSet != null) {
                                            try {
                                                dBResultSet.getStatement().close();
                                            }
                                            catch (Exception exception) {}
                                        }
                                        throw throwable;
                                    }
                                    if (dBResultSet != null) {
                                        try {
                                            dBResultSet.getStatement().close();
                                        }
                                        catch (Exception exception) {}
                                    }
                                    break block39;
                                }
                                if (dBResultSet != null) {
                                    try {
                                        dBResultSet.getStatement().close();
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                            ++n;
                        }
                        if (hashSet2.size() > 0) {
                            String[] stringArray2 = (String[])hashSet2.toArray();
                            hashSet = this.determineSelectedMissingList(stringArray2, dBConnection);
                        }
                    }
                    catch (Exception exception) {
                        traceLogger.exception(IRecordType.TYPE_ERROR, className, string2, exception);
                        break block38;
                    }
                }
                catch (Throwable throwable) {
                    if (dBResultSet != null) {
                        try {
                            dBResultSet.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (dBResultSet != null) {
                    try {
                        dBResultSet.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                break block40;
            }
            if (dBResultSet != null) {
                try {
                    dBResultSet.getStatement().close();
                }
                catch (Exception exception) {}
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return hashSet;
    }

    private HashSet determineSelectedMissingList(String[] stringArray, DBConnection dBConnection) {
        String string = "determineSelectedMissingList";
        HashSet hashSet = new HashSet();
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string, stringArray);
        }
        if (stringArray == null) {
            String[] stringArray2 = new String[]{"fabric"};
            String string2 = "currenttime";
            hashSet = this.determineMissingEntitiesByDeviceTypes(stringArray2, string2, dBConnection);
        } else {
            int n = 0;
            while (n < stringArray.length) {
                AbstractCollection abstractCollection;
                Object object;
                int n2 = stringArray[n].indexOf(58);
                String string3 = stringArray[n].substring(0, n2);
                Object object2 = stringArray[n].substring(n2 + 1);
                if (string3.equals("host")) {
                    if (RemoveMissingUtils.isHostRemovable((String)object2)) {
                        object = new HashSet<String>();
                        ((HashSet)object).add(stringArray[n]);
                        ((AbstractCollection)object).addAll(this.determineMissingSubEntityCollection(string3, (String)object2, dBConnection));
                        hashSet.add(object);
                        if (TRACE) {
                            TraceLogger.traceMessage(1, className, string, String.valueOf(stringArray[n]) + " is removable");
                        }
                    } else {
                        traceLogger.text(IRecordType.TYPE_WARN, className, string, String.valueOf(stringArray[n]) + " is not removable");
                        if (TRACE) {
                            TraceLogger.traceMessage(1, className, string, String.valueOf(stringArray[n]) + " is not removable");
                        }
                        this.isHostRemovable = false;
                    }
                } else if (string3.equals("switch")) {
                    object = this.getFabricIdOnlyHasThisSwitch((String)object2);
                    if (object != null && !((String)object).equals("")) {
                        string3 = "fabric";
                        object2 = object;
                        abstractCollection = new HashSet();
                        ((HashSet)abstractCollection).add(String.valueOf(string3) + ':' + (String)object2);
                        abstractCollection.addAll(this.determineMissingSubEntityCollection(string3, (String)object2, dBConnection));
                        hashSet.add(abstractCollection);
                    } else {
                        abstractCollection = new HashSet<String>();
                        ((HashSet)abstractCollection).add(stringArray[n]);
                        abstractCollection.addAll(this.determineMissingSubEntityCollection(string3, (String)object2, dBConnection));
                        hashSet.add(abstractCollection);
                    }
                } else if (string3.equals("fabric")) {
                    object = new HashSet<String>();
                    ((HashSet)object).add(stringArray[n]);
                    ((AbstractCollection)object).addAll(this.determineMissingSubEntityCollection(string3, (String)object2, dBConnection));
                    hashSet.add(object);
                    if (RemoveMissingUtils.isPhysicalFabric((String)object2)) {
                        abstractCollection = this.getMissingVsansForFabric((String)object2, dBConnection);
                        Iterator iterator = ((ArrayList)abstractCollection).iterator();
                        while (iterator.hasNext()) {
                            object = new HashSet();
                            string3 = "fabric";
                            object2 = (String)iterator.next();
                            ((HashSet)object).add(String.valueOf(string3) + ':' + (String)object2);
                            ((AbstractCollection)object).addAll(this.determineMissingSubEntityCollection(string3, (String)object2, dBConnection));
                            hashSet.add(object);
                        }
                    }
                } else {
                    object = new HashSet();
                    ((HashSet)object).add(stringArray[n]);
                    ((AbstractCollection)object).addAll(this.determineMissingSubEntityCollection(string3, (String)object2, dBConnection));
                    hashSet.add(object);
                }
                ++n;
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return hashSet;
    }

    private HashSet getMissingSubEntitiesForSwitch(String string, DBConnection dBConnection) {
        HashSet<String> hashSet;
        String string2;
        block48: {
            DBResultSet dBResultSet;
            DBResultSet dBResultSet2;
            DBResultSet dBResultSet3;
            DBResultSet dBResultSet4;
            block47: {
                string2 = "getMissingSubEntitiesForSwitch";
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, className, string2);
                }
                hashSet = new HashSet<String>();
                dBResultSet4 = null;
                dBResultSet3 = null;
                dBResultSet2 = null;
                dBResultSet = null;
                try {
                    try {
                        int n;
                        String string3;
                        dBResultSet3 = RemoveMissingUtils.getFabric2SwitchForSwitch(string, dBConnection);
                        while (dBResultSet3.next()) {
                            string3 = "" + dBResultSet3.getInt("fabric2switchId");
                            n = dBResultSet3.getInt("state");
                            if (n != 0) continue;
                            hashSet.add("fabric2switch:" + string3);
                        }
                        dBResultSet2 = RemoveMissingUtils.getBladesForSwitch(string, dBConnection);
                        while (dBResultSet2.next()) {
                            string3 = "" + dBResultSet2.getInt("bladeId");
                            n = dBResultSet2.getInt("state");
                            if (n != 0) continue;
                            hashSet.add("blade:" + string3);
                        }
                        dBResultSet = RemoveMissingUtils.getSwitch2PortForSwitch(string, dBConnection);
                        while (dBResultSet.next()) {
                            string3 = "" + dBResultSet.getInt("switch2portId");
                            n = dBResultSet.getInt("state");
                            if (n != 0) continue;
                            hashSet.add("switch2port:" + string3);
                        }
                        dBResultSet4 = RemoveMissingUtils.getPortsForSwitch(string, dBConnection);
                        while (dBResultSet4.next()) {
                            string3 = "" + dBResultSet4.getInt("portId");
                            n = dBResultSet4.getInt("state");
                            if (n != 0) continue;
                            hashSet.add("port:" + string3);
                            hashSet.addAll(this.getMissingSubEntitiesForPort(string3, dBConnection));
                        }
                    }
                    catch (Exception exception) {
                        if (!traceLogger.isLogging()) break block47;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                        break block47;
                    }
                }
                catch (Throwable throwable) {
                    if (dBResultSet4 != null) {
                        try {
                            dBResultSet4.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    if (dBResultSet2 != null) {
                        try {
                            dBResultSet2.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    if (dBResultSet3 != null) {
                        try {
                            dBResultSet3.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    if (dBResultSet != null) {
                        try {
                            dBResultSet.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (dBResultSet4 != null) {
                    try {
                        dBResultSet4.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet2 != null) {
                    try {
                        dBResultSet2.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet3 != null) {
                    try {
                        dBResultSet3.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet != null) {
                    try {
                        dBResultSet.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                break block48;
            }
            if (dBResultSet4 != null) {
                try {
                    dBResultSet4.getStatement().close();
                }
                catch (Exception exception) {}
            }
            if (dBResultSet2 != null) {
                try {
                    dBResultSet2.getStatement().close();
                }
                catch (Exception exception) {}
            }
            if (dBResultSet3 != null) {
                try {
                    dBResultSet3.getStatement().close();
                }
                catch (Exception exception) {}
            }
            if (dBResultSet != null) {
                try {
                    dBResultSet.getStatement().close();
                }
                catch (Exception exception) {}
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return hashSet;
    }

    private HashSet getMissingSubEntitiesForPort(String string, DBConnection dBConnection) {
        HashSet<String> hashSet;
        String string2;
        block18: {
            DBResultSet dBResultSet;
            block17: {
                string2 = "getMissingSubEntitiesForPort";
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, string);
                }
                hashSet = new HashSet<String>();
                dBResultSet = null;
                try {
                    try {
                        dBResultSet = RemoveMissingUtils.getPort2portForPort(string, dBConnection);
                        while (dBResultSet.next()) {
                            int n = dBResultSet.getInt("state");
                            String string3 = "" + dBResultSet.getInt("port2portId");
                            if (n != 0) continue;
                            hashSet.add("port2port:" + string3);
                        }
                    }
                    catch (Exception exception) {
                        if (!traceLogger.isLogging()) break block17;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (dBResultSet != null) {
                        try {
                            dBResultSet.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (dBResultSet != null) {
                    try {
                        dBResultSet.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                break block18;
            }
            if (dBResultSet != null) {
                try {
                    dBResultSet.getStatement().close();
                }
                catch (Exception exception) {}
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return hashSet;
    }

    private HashSet getMissingSubEntitiesForNode(String string, DBConnection dBConnection) {
        HashSet<String> hashSet;
        String string2;
        block28: {
            DBResultSet dBResultSet;
            DBResultSet dBResultSet2;
            block27: {
                string2 = "getMissingSubEntitiesForNode";
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, string);
                }
                hashSet = new HashSet<String>();
                dBResultSet2 = null;
                dBResultSet = null;
                try {
                    try {
                        int n;
                        String string3;
                        dBResultSet2 = RemoveMissingUtils.getPortsForNode(string, dBConnection);
                        while (dBResultSet2.next()) {
                            string3 = "" + dBResultSet2.getInt("portId");
                            n = dBResultSet2.getInt("state");
                            if (n != 0) continue;
                            hashSet.add("port:" + string3);
                            hashSet.addAll(this.getMissingSubEntitiesForPort(string3, dBConnection));
                        }
                        dBResultSet = RemoveMissingUtils.getNode2HBAForNode(string, dBConnection);
                        while (dBResultSet.next()) {
                            string3 = "" + dBResultSet.getInt("node2hbaId");
                            n = dBResultSet.getInt("state");
                            if (n != 0) continue;
                            hashSet.add("node2hba:" + string3);
                        }
                    }
                    catch (Exception exception) {
                        if (!traceLogger.isLogging()) break block27;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    if (dBResultSet2 != null) {
                        try {
                            dBResultSet2.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    if (dBResultSet != null) {
                        try {
                            dBResultSet.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (dBResultSet2 != null) {
                    try {
                        dBResultSet2.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet != null) {
                    try {
                        dBResultSet.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                break block28;
            }
            if (dBResultSet2 != null) {
                try {
                    dBResultSet2.getStatement().close();
                }
                catch (Exception exception) {}
            }
            if (dBResultSet != null) {
                try {
                    dBResultSet.getStatement().close();
                }
                catch (Exception exception) {}
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return hashSet;
    }

    private HashSet getMissingSubEntitiesForFabric(String string, DBConnection dBConnection) {
        HashSet<String> hashSet;
        String string2;
        block77: {
            DBResultSet dBResultSet;
            DBResultSet dBResultSet2;
            DBResultSet dBResultSet3;
            DBResultSet dBResultSet4;
            DBResultSet dBResultSet5;
            DBResultSet dBResultSet6;
            DBResultSet dBResultSet7;
            block76: {
                string2 = "getMissingSubEntitiesForFabric";
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, string);
                }
                hashSet = new HashSet<String>();
                dBResultSet7 = null;
                dBResultSet6 = null;
                dBResultSet5 = null;
                dBResultSet4 = null;
                dBResultSet3 = null;
                dBResultSet2 = null;
                dBResultSet = null;
                try {
                    try {
                        int n;
                        String string3;
                        dBResultSet7 = RemoveMissingUtils.getSwitchesForFabric(string, dBConnection);
                        while (dBResultSet7.next()) {
                            string3 = "" + dBResultSet7.getInt("switchId");
                            n = dBResultSet7.getInt("state1");
                            int n2 = dBResultSet7.getInt("state2");
                            String string4 = "" + dBResultSet7.getInt("fabric2switchId");
                            if (n == 0) {
                                hashSet.add("switch:" + string3);
                                hashSet.addAll(this.getMissingSubEntitiesForSwitch(string3, dBConnection));
                            }
                            if (n2 != 0) continue;
                            hashSet.add("fabric2switch:" + string4);
                        }
                        dBResultSet6 = RemoveMissingUtils.getHostsForFabric(string, dBConnection);
                        while (dBResultSet6.next()) {
                            string3 = "" + dBResultSet6.getInt("hostId");
                            n = dBResultSet6.getInt("state");
                            if (n == 0 && RemoveMissingUtils.isHostRemovable(string3)) {
                                hashSet.add("host:" + string3);
                            }
                            hashSet.addAll(this.getMissingSubEntitiesForHost(string3, dBConnection));
                        }
                        dBResultSet5 = RemoveMissingUtils.getPEsForFabric(string, dBConnection);
                        while (dBResultSet5.next()) {
                            string3 = "" + dBResultSet5.getInt("peId");
                            n = dBResultSet5.getInt("state");
                            if (n != 0) continue;
                            hashSet.add("pe:" + string3);
                            hashSet.addAll(this.getMissingSubEntitiesForPE(string3, dBConnection));
                        }
                        dBResultSet4 = RemoveMissingUtils.getNodesForFabric(string, dBConnection);
                        while (dBResultSet4.next()) {
                            string3 = "" + dBResultSet4.getInt("nodeId");
                            n = dBResultSet4.getInt("state");
                            if (n != 0) continue;
                            hashSet.add("node:" + string3);
                            hashSet.addAll(this.getMissingSubEntitiesForNode(string3, dBConnection));
                        }
                    }
                    catch (Exception exception) {
                        if (!traceLogger.isLogging()) break block76;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                        break block76;
                    }
                }
                catch (Throwable throwable) {
                    if (dBResultSet7 != null) {
                        try {
                            dBResultSet7.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    if (dBResultSet6 != null) {
                        try {
                            dBResultSet6.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    if (dBResultSet5 != null) {
                        try {
                            dBResultSet5.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    if (dBResultSet4 != null) {
                        try {
                            dBResultSet4.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    if (dBResultSet3 != null) {
                        try {
                            dBResultSet3.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    if (dBResultSet2 != null) {
                        try {
                            dBResultSet2.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    if (dBResultSet != null) {
                        try {
                            dBResultSet.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (dBResultSet7 != null) {
                    try {
                        dBResultSet7.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet6 != null) {
                    try {
                        dBResultSet6.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet5 != null) {
                    try {
                        dBResultSet5.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet4 != null) {
                    try {
                        dBResultSet4.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet3 != null) {
                    try {
                        dBResultSet3.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet2 != null) {
                    try {
                        dBResultSet2.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet != null) {
                    try {
                        dBResultSet.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                break block77;
            }
            if (dBResultSet7 != null) {
                try {
                    dBResultSet7.getStatement().close();
                }
                catch (Exception exception) {}
            }
            if (dBResultSet6 != null) {
                try {
                    dBResultSet6.getStatement().close();
                }
                catch (Exception exception) {}
            }
            if (dBResultSet5 != null) {
                try {
                    dBResultSet5.getStatement().close();
                }
                catch (Exception exception) {}
            }
            if (dBResultSet4 != null) {
                try {
                    dBResultSet4.getStatement().close();
                }
                catch (Exception exception) {}
            }
            if (dBResultSet3 != null) {
                try {
                    dBResultSet3.getStatement().close();
                }
                catch (Exception exception) {}
            }
            if (dBResultSet2 != null) {
                try {
                    dBResultSet2.getStatement().close();
                }
                catch (Exception exception) {}
            }
            if (dBResultSet != null) {
                try {
                    dBResultSet.getStatement().close();
                }
                catch (Exception exception) {}
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return hashSet;
    }

    private HashSet getMissingSubEntitiesForZone(String string, DBConnection dBConnection) {
        HashSet<String> hashSet;
        String string2;
        block28: {
            DBResultSet dBResultSet;
            DBResultSet dBResultSet2;
            block27: {
                string2 = "getMissingSubEntitiesForZone";
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, string);
                }
                hashSet = new HashSet<String>();
                dBResultSet2 = null;
                dBResultSet = null;
                try {
                    try {
                        String string3;
                        boolean bl;
                        dBResultSet2 = RemoveMissingUtils.getZoneSet2ZonesForZone(string, dBConnection);
                        while (dBResultSet2.next()) {
                            bl = false;
                            string3 = "" + dBResultSet2.getInt("zset2zoneId");
                            if (bl) continue;
                            hashSet.add("zset2zone:" + string3);
                        }
                        dBResultSet = RemoveMissingUtils.getZone2MembersForZone(string, dBConnection);
                        while (dBResultSet.next()) {
                            bl = false;
                            string3 = "" + dBResultSet.getInt("zone2memberId");
                            if (bl) continue;
                            hashSet.add("zone2member:" + string3);
                        }
                    }
                    catch (Exception exception) {
                        if (!traceLogger.isLogging()) break block27;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    if (dBResultSet2 != null) {
                        try {
                            dBResultSet2.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    if (dBResultSet != null) {
                        try {
                            dBResultSet.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (dBResultSet2 != null) {
                    try {
                        dBResultSet2.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet != null) {
                    try {
                        dBResultSet.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                break block28;
            }
            if (dBResultSet2 != null) {
                try {
                    dBResultSet2.getStatement().close();
                }
                catch (Exception exception) {}
            }
            if (dBResultSet != null) {
                try {
                    dBResultSet.getStatement().close();
                }
                catch (Exception exception) {}
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return hashSet;
    }

    private HashSet getMissingSubEntitiesForZoneSet(String string, DBConnection dBConnection) {
        String string2 = "getMissingSubEntitiesForZoneSet";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, string);
        }
        HashSet hashSet = new HashSet();
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return hashSet;
    }

    private HashSet getMissingSubEntitiesForPE(String string, DBConnection dBConnection) {
        HashSet<String> hashSet;
        String string2;
        block19: {
            DBResultSet dBResultSet;
            block18: {
                string2 = "getMissingSubEntitiesForPE";
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, string);
                }
                hashSet = new HashSet<String>();
                dBResultSet = null;
                try {
                    try {
                        dBResultSet = RemoveMissingUtils.getNodesForPE(string, dBConnection);
                        while (dBResultSet.next()) {
                            String string3 = "" + dBResultSet.getInt("nodeId");
                            String string4 = "" + dBResultSet.getInt("pe2nodeId");
                            int n = dBResultSet.getInt("state1");
                            int n2 = dBResultSet.getInt("state2");
                            if (n == 0) {
                                hashSet.add("node:" + string3);
                                hashSet.addAll(this.getMissingSubEntitiesForNode(string3, dBConnection));
                            }
                            if (n2 != 0) continue;
                            hashSet.add("pe2node:" + string4);
                        }
                    }
                    catch (Exception exception) {
                        if (!traceLogger.isLogging()) break block18;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (dBResultSet != null) {
                        try {
                            dBResultSet.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (dBResultSet != null) {
                    try {
                        dBResultSet.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                break block19;
            }
            if (dBResultSet != null) {
                try {
                    dBResultSet.getStatement().close();
                }
                catch (Exception exception) {}
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return hashSet;
    }

    private HashSet getMissingSubEntitiesForHost(String string, DBConnection dBConnection) {
        HashSet<String> hashSet;
        String string2;
        block18: {
            DBResultSet dBResultSet;
            block17: {
                string2 = "getMissingSubEntitiesForHost";
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, string);
                }
                hashSet = new HashSet<String>();
                dBResultSet = null;
                try {
                    try {
                        dBResultSet = RemoveMissingUtils.getHBAsForHost(string, dBConnection);
                        while (dBResultSet.next()) {
                            String string3 = "" + dBResultSet.getInt("hbaId");
                            int n = dBResultSet.getInt("state");
                            if (n != 0) continue;
                            hashSet.add("hba:" + string3);
                            hashSet.addAll(this.getMissingSubEntitiesForHBA(string3, dBConnection));
                        }
                    }
                    catch (Exception exception) {
                        if (!traceLogger.isLogging()) break block17;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (dBResultSet != null) {
                        try {
                            dBResultSet.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (dBResultSet != null) {
                    try {
                        dBResultSet.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                break block18;
            }
            if (dBResultSet != null) {
                try {
                    dBResultSet.getStatement().close();
                }
                catch (Exception exception) {}
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return hashSet;
    }

    private HashSet getMissingSubEntitiesForHBA(String string, DBConnection dBConnection) {
        HashSet<String> hashSet;
        String string2;
        block19: {
            DBResultSet dBResultSet;
            block18: {
                string2 = "getMissingSubEntitiesForHBA";
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, string);
                }
                hashSet = new HashSet<String>();
                dBResultSet = null;
                try {
                    try {
                        dBResultSet = RemoveMissingUtils.getNodesForHBA(string, dBConnection);
                        while (dBResultSet.next()) {
                            String string3 = "" + dBResultSet.getInt("nodeId");
                            String string4 = "" + dBResultSet.getInt("node2hbaId");
                            int n = dBResultSet.getInt("state1");
                            int n2 = dBResultSet.getInt("state2");
                            if (n == 0) {
                                hashSet.add("node:" + string3);
                                hashSet.addAll(this.getMissingSubEntitiesForNode(string3, dBConnection));
                            }
                            if (n2 != 0) continue;
                            hashSet.add("node2hba:" + string4);
                        }
                    }
                    catch (Exception exception) {
                        if (!traceLogger.isLogging()) break block18;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (dBResultSet != null) {
                        try {
                            dBResultSet.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (dBResultSet != null) {
                    try {
                        dBResultSet.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                break block19;
            }
            if (dBResultSet != null) {
                try {
                    dBResultSet.getStatement().close();
                }
                catch (Exception exception) {}
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return hashSet;
    }

    private HashSet determineDeletionTypes(HashSet hashSet) {
        String string = "determineDeletionTypes";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, className, string);
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        for (HashSet hashSet3 : hashSet) {
            for (String string2 : hashSet3) {
                String string3 = string2.substring(0, 2);
                String string4 = (String)classMap.get(string3);
                if (string4 == null) continue;
                hashSet2.add(string4);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return hashSet2;
    }

    private String convertHashSetToString(HashSet hashSet) {
        String string = "convertHashSetToString";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, className, string);
        }
        String string2 = null;
        if (hashSet.size() != 0) {
            Iterator iterator = hashSet.iterator();
            int n = 0;
            String string3 = " ";
            String string4 = null;
            while (iterator.hasNext()) {
                string4 = (String)iterator.next();
                string2 = string2 == null ? String.valueOf(string4) + string3 : String.valueOf(string2) + string4 + string3;
                ++n;
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processDeleteMissing(HashSet hashSet, DBConnection dBConnection) {
        String string = "processDeleteMissing";
        boolean bl = false;
        IEventMonitorService iEventMonitorService = null;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string, hashSet);
        }
        Iterator iterator = hashSet.iterator();
        ViewReportTablesUpdater viewReportTablesUpdater = new ViewReportTablesUpdater();
        try {
            if (dBConnection == null) {
                return bl;
            }
            block6: while (iterator.hasNext()) {
                String string2 = null;
                String string3 = null;
                try {
                    dBConnection.setAutoCommit(false);
                    HashSet hashSet2 = (HashSet)iterator.next();
                    Iterator iterator2 = hashSet2.iterator();
                    while (true) {
                        if (!iterator2.hasNext()) {
                            dBConnection.commit();
                            bl = true;
                            continue block6;
                        }
                        String string4 = (String)iterator2.next();
                        int n = string4.indexOf(58);
                        string2 = string4.substring(0, n);
                        string3 = string4.substring(n + 1);
                        this.deleteEntity(dBConnection, string2, string3);
                        if (string2.equals("switch") || string2.equals("subsystem")) {
                            if (iEventMonitorService == null) {
                                iEventMonitorService = (IEventMonitorService)ConnectorClient.getService((String)this.mDeviceServerHost, (int)this.mDeviceServerPort, IEventMonitorService.class, (String)"SANEventCorrelatorFactory");
                            }
                            iEventMonitorService.publish((SRMEvent)new DeviceDeletedEvent(string2, string3));
                        }
                        viewReportTablesUpdater.deleteDependentViews(string2, string3);
                    }
                }
                catch (Exception exception) {
                    traceLogger.text(IRecordType.TYPE_WARN, className, string, String.valueOf(string2) + string3 + " is not deleted.");
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, string, exception);
                    if (dBConnection != null) {
                        try {
                            dBConnection.rollback();
                        }
                        catch (Exception exception2) {}
                    }
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            traceLogger.exception(IRecordType.TYPE_EXIT, className, string, exception);
            bl = false;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        viewReportTablesUpdater = null;
        return bl;
    }

    private void deleteEntity(DBConnection dBConnection, String string, String string2) throws SQLException {
        String string3 = "deleteMissingEntity";
        String string4 = "Deleted missing entity: " + string + string2;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3, new Object[]{string, string2});
        }
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        if (string.equals("port")) {
            hashtable.put(Port.getColumnInfo("PORT_ID"), string2);
            hashtable.put(Port.getColumnInfo("DETECTABLE"), "0");
            Port.deletes(dBConnection, hashtable);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("node")) {
            hashtable.put(Node.getColumnInfo("NODE_ID"), string2);
            hashtable.put(Node.getColumnInfo("DETECTABLE"), "0");
            Node.deletes(dBConnection, hashtable);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("hba")) {
            hashtable.put(Hba.getColumnInfo("HBA_ID"), string2);
            hashtable.put(Hba.getColumnInfo("DETECTABLE"), "0");
            Hba.deletes(dBConnection, hashtable);
            RemoveMissingUtils.markHBAPortAsNormalPort(string2, dBConnection);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("host")) {
            hashtable.put(Host.getColumnInfo("COMPUTER_ID"), string2);
            hashtable.put(Host.getColumnInfo("DETECTABLE"), "0");
            Host.deletes(dBConnection, hashtable);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("switch")) {
            String string5 = RemoveMissingUtils.getSwitchWWNById(string2);
            if (string5 != null) {
                RemoveMissingUtils.deleteAttributeSnapshot(string, string5, dBConnection);
            }
            hashtable.put(Switch.getColumnInfo("SWITCH_ID"), string2);
            hashtable.put(Switch.getColumnInfo("DETECTABLE"), "0");
            Switch.deletes(dBConnection, hashtable);
        } else if (string.equals("blade")) {
            hashtable.put(SwitchBlade.getColumnInfo("SWITCH_BLADE_ID"), string2);
            hashtable.put(SwitchBlade.getColumnInfo("DETECTABLE"), "0");
            SwitchBlade.deletes(dBConnection, hashtable);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("fabric")) {
            String string6;
            if (RemoveMissingUtils.isPhysicalFabric(string2)) {
                RemoveMissingUtils.markChildVsansAsRegular(string2, dBConnection);
            }
            if ((string6 = RemoveMissingUtils.getFabricWWNById(string2)) != null) {
                RemoveMissingUtils.deleteAttributeSnapshot(string, string6, dBConnection);
            }
            hashtable.put(Fabric.getColumnInfo("FABRIC_ID"), string2);
            hashtable.put(Fabric.getColumnInfo("DETECTABLE"), "0");
            Fabric.deletes(dBConnection, hashtable);
        } else if (string.equals("pe")) {
            hashtable.put(PhyPe.getColumnInfo("PHY_PE_ID"), string2);
            hashtable.put(PhyPe.getColumnInfo("DETECTABLE"), "0");
            PhyPe.deletes(dBConnection, hashtable);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("pe2node")) {
            hashtable.put(Pe2node.getColumnInfo("PE2NODE_ID"), string2);
            hashtable.put(Pe2node.getColumnInfo("DETECTABLE"), "0");
            Pe2node.deletes(dBConnection, hashtable);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("port2port")) {
            hashtable.put(Port2port.getColumnInfo("PORT2PORT_ID"), string2);
            hashtable.put(Port2port.getColumnInfo("DETECTABLE"), "0");
            Port2port.deletes(dBConnection, hashtable);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("node2hba")) {
            hashtable.put(Node2hba.getColumnInfo("NODE2HBA_ID"), string2);
            hashtable.put(Node2hba.getColumnInfo("DETECTABLE"), "0");
            Node2hba.deletes(dBConnection, hashtable);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("fabric2switch")) {
            hashtable.put(Fabric2switch.getColumnInfo("FABRIC2SWITCH_ID"), string2);
            hashtable.put(Fabric2switch.getColumnInfo("DETECTABLE"), "0");
            Fabric2switch.deletes(dBConnection, hashtable);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("switch2port")) {
            hashtable.put(Switch2port.getColumnInfo("SWITCH2PORT_ID"), string2);
            hashtable.put(Switch2port.getColumnInfo("DETECTABLE"), "0");
            Switch2port.deletes(dBConnection, hashtable);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("zone")) {
            hashtable.put(Zone.getColumnInfo("ZONE_ID"), string2);
            Zone.deletes(dBConnection, hashtable);
        } else if (string.equals("zset")) {
            hashtable.put(Zset.getColumnInfo("ZSET_ID"), string2);
            Zset.deletes(dBConnection, hashtable);
        } else if (string.equals("zonemember")) {
            hashtable.put(ZoneMember.getColumnInfo("ZONE_MEMBER_ID"), string2);
            ZoneMember.deletes(dBConnection, hashtable);
        } else if (string.equals("zone2member")) {
            hashtable.put(Zone2member.getColumnInfo("ZONE2MEMBER_ID"), string2);
            Zone2member.deletes(dBConnection, hashtable);
        } else if (string.equals("zset2zone")) {
            hashtable.put(Zset2zone.getColumnInfo("ZSET2ZONE_ID"), string2);
            Zset2zone.deletes(dBConnection, hashtable);
        } else if (string.equals("subsystem")) {
            this.handleSubsystem(string, string2);
        } else if (string.equals("tapelibrary")) {
            this.handleTape(string, string2);
        } else {
            string4 = String.valueOf(string) + string2 + "s not supported by RemovingMissing function.";
        }
        if (TRACE) {
            TraceLogger.traceMessage(1, className, string3, string4);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string3);
        }
    }

    private void handleSubsystem(String string, String string2) {
        DBConnection dBConnection = null;
        try {
            try {
                dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                StorageSubsystem.StorageSubsystemCursor storageSubsystemCursor = StorageSubsystem.getCursor(dBConnection, null, null);
                while (storageSubsystemCursor.next()) {
                    StorageSubsystem storageSubsystem = storageSubsystemCursor.getObject();
                    if (storageSubsystem.getSubsystemId() != new Integer(string2).intValue()) continue;
                    String[] stringArray = new String[]{(String)ExternalKeyConverter.getStorageSubsystemKey(storageSubsystem)};
                    this.cMgmtOps.deleteStorageSubsystems(stringArray);
                    break;
                }
            }
            catch (SQLException sQLException) {
                traceLogger.text(IRecordType.TYPE_ERROR_EXC, className, "handleSubsystem", String.valueOf(string) + string2 + sQLException.getStackTrace().toString());
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                    dBConnection.close();
                }
                catch (SQLException sQLException) {
                    traceLogger.text(IRecordType.TYPE_ERROR_EXC, className, "handleSubsystem", String.valueOf(string) + string2 + sQLException.getStackTrace().toString());
                }
            }
        }
    }

    private void handleTape(String string, String string2) {
        this.cTapeDBHelper.deleteLibraryByID(Integer.parseInt(string2));
    }

    private HashSet determineMissingSubEntityCollection(String string, String string2, DBConnection dBConnection) {
        String string3 = "determineMissingSubEntityCollection";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3, new Object[]{string, string2});
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (string.equals("port")) {
            hashSet = this.getMissingSubEntitiesForPort(string2, dBConnection);
        } else if (string.equals("node")) {
            hashSet = this.getMissingSubEntitiesForNode(string2, dBConnection);
        } else if (string.equals("switch")) {
            hashSet = this.getMissingSubEntitiesForSwitch(string2, dBConnection);
        } else if (string.equals("fabric")) {
            hashSet = this.getMissingSubEntitiesForFabric(string2, dBConnection);
        } else if (string.equals("pe")) {
            hashSet = this.getMissingSubEntitiesForPE(string2, dBConnection);
        } else if (string.equals("hba")) {
            hashSet = this.getMissingSubEntitiesForHBA(string2, dBConnection);
        } else if (string.equals("host")) {
            hashSet = this.getMissingSubEntitiesForHost(string2, dBConnection);
        } else if (string.equals("port2port")) {
            hashSet = new HashSet<String>();
            hashSet.add(String.valueOf(string) + ':' + string2);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3, hashSet);
        }
        return hashSet;
    }

    private boolean deleteEntityWithRetry(String string, String string2, DBConnection dBConnection) throws SQLException {
        String string3 = "deleteEntityWithRetry";
        boolean bl = false;
        boolean bl2 = false;
        int n = 3;
        do {
            try {
                this.deleteEntity(dBConnection, string, string2);
                bl2 = false;
                bl = true;
            }
            catch (SQLException sQLException) {
                bl2 = true;
                if (--n > 0) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (Exception exception) {}
                    if (!TRACE) continue;
                    TraceLogger.traceMessage(1, className, string3, "Unable to delete " + string + string2 + ". Retying...");
                    continue;
                }
                if (TRACE) {
                    TraceLogger.traceMessage(1, className, string3, "Unable to delete " + string + string2 + ". " + n + " retry attemped.");
                }
                throw sQLException;
            }
        } while (bl2 && n > 0);
        return bl;
    }

    private String getFabricIdOnlyHasThisSwitch(String string) {
        String string2;
        block32: {
            DBConnection dBConnection;
            DBResultSet dBResultSet;
            block31: {
                block28: {
                    String string3 = "getfabricIdOnlyHasThisSwitch";
                    string2 = null;
                    dBResultSet = null;
                    dBConnection = null;
                    try {
                        try {
                            DBResultSet dBResultSet2;
                            block30: {
                                dBConnection = RemoveMissingUtils.getDBConnection();
                                dBResultSet = RemoveMissingUtils.getFabricForSwitch(string, dBConnection);
                                if (!dBResultSet.next()) break block28;
                                String string4 = "" + dBResultSet.getInt("fabricId");
                                int n = dBResultSet.getInt("state");
                                if (n != 0) break block28;
                                boolean bl = true;
                                dBResultSet2 = null;
                                try {
                                    try {
                                        dBResultSet2 = RemoveMissingUtils.getSwitchesForFabric(string4, dBConnection);
                                        while (dBResultSet2.next()) {
                                            String string5 = "" + dBResultSet2.getInt("switchId");
                                            if (string5.equals(string)) continue;
                                            bl = false;
                                            break;
                                        }
                                        if (bl) {
                                            string2 = string4;
                                        }
                                    }
                                    catch (Exception exception) {
                                        if (!traceLogger.isLogging()) break block30;
                                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string3, exception);
                                        break block30;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (dBResultSet2 != null) {
                                        try {
                                            dBResultSet2.getStatement().close();
                                        }
                                        catch (Exception exception) {}
                                    }
                                    throw throwable;
                                }
                                if (dBResultSet2 != null) {
                                    try {
                                        dBResultSet2.getStatement().close();
                                    }
                                    catch (Exception exception) {}
                                }
                                break block28;
                            }
                            if (dBResultSet2 != null) {
                                try {
                                    dBResultSet2.getStatement().close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        catch (Exception exception) {
                            if (!traceLogger.isLogging()) break block31;
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string3, exception);
                            break block31;
                        }
                    }
                    catch (Throwable throwable) {
                        if (dBResultSet != null) {
                            try {
                                dBResultSet.getStatement().close();
                            }
                            catch (Exception exception) {}
                        }
                        RemoveMissingUtils.closeConnection(dBConnection);
                        throw throwable;
                    }
                }
                if (dBResultSet != null) {
                    try {
                        dBResultSet.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                RemoveMissingUtils.closeConnection(dBConnection);
                break block32;
            }
            if (dBResultSet != null) {
                try {
                    dBResultSet.getStatement().close();
                }
                catch (Exception exception) {}
            }
            RemoveMissingUtils.closeConnection(dBConnection);
        }
        return string2;
    }

    private ArrayList getMissingVsansForFabric(String string, DBConnection dBConnection) {
        ArrayList<String> arrayList;
        String string2;
        block18: {
            DBResultSet dBResultSet;
            block17: {
                string2 = "getMissingVsansForFabric";
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, className, string2);
                }
                new HashSet();
                dBResultSet = null;
                arrayList = new ArrayList<String>();
                try {
                    try {
                        dBResultSet = RemoveMissingUtils.getVsansForFabric(string, dBConnection);
                        while (dBResultSet.next()) {
                            String string3 = "" + dBResultSet.getInt("vsanId");
                            int n = dBResultSet.getInt("vsanState");
                            if (n != 0) continue;
                            arrayList.add(string3);
                        }
                    }
                    catch (Exception exception) {
                        if (!traceLogger.isLogging()) break block17;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (dBResultSet != null) {
                        try {
                            dBResultSet.getStatement().close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (dBResultSet != null) {
                    try {
                        dBResultSet.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                break block18;
            }
            if (dBResultSet != null) {
                try {
                    dBResultSet.getStatement().close();
                }
                catch (Exception exception) {}
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return arrayList;
    }

    public static int[] getPrimitiveIntArray(Integer[] integerArray) {
        int[] nArray = new int[integerArray.length];
        int n = 0;
        while (n < integerArray.length) {
            nArray[n] = integerArray[n];
            ++n;
        }
        return nArray;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0 || stringArray.length > 2) {
            return;
        }
        RemoveMissingProcessor removeMissingProcessor = new RemoveMissingProcessor();
        if (stringArray.length == 1) {
            String[] stringArray2 = new String[]{stringArray[0]};
            removeMissingProcessor.performDeletionForSelectedMissingEntities(stringArray2);
        } else if (stringArray.length == 2) {
            removeMissingProcessor.performScheduledDeletionForMissingEntity(stringArray[0], stringArray[1]);
        }
    }
}

