/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Random;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.objects.StormSettings;
import org.eclipse.aperi.infrastructure.database.objects.TapeDrive;
import org.eclipse.aperi.infrastructure.database.objects.TapeMediaChanger;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class RemoveMissingUtils {
    private static final String className = RemoveMissingUtils.class.getName();
    private static final long MILLIS_PER_DAY = 86400000L;
    public static StormSettings settings;
    public static final String MESSAGE_NAME = "aperi.logger.message.RemoveMissing";
    public static final String TRACE_NAME = "aperi.logger.trace.RemoveMissing";
    public static String MSG_FILE;
    private static ILogger msgLogger;
    private static ILogger traceLogger;
    public static final long MIN_RETRY_INTERVAL = 100L;
    public static final long MULT_RETRY_INTERVAL = 500L;
    public static final int ALLOWED_RETRIES = 3;

    static {
        MSG_FILE = "org.eclipse.aperi.resources.RemoveMissingProcessorTMS";
        msgLogger = null;
        traceLogger = null;
        msgLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }

    public static DBConnection getDBConnection() {
        DBConnection dBConnection = null;
        try {
            DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
            dBConnection = (DBConnection)dBConnPoolDataSource.getPooledConnection();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return dBConnection;
    }

    public static void closeConnection(DBConnection dBConnection) {
        if (dBConnection != null) {
            try {
                dBConnection.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            dBConnection = null;
        }
    }

    public static DBResultSet getPortsForSwitch(String string, DBConnection dBConnection) {
        String string2 = "getPortsForSwitch";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct port.port_id as portId, port.detectable as state from T_RES_PORT port, T_RES_SWITCH2PORT s2p, T_RES_SWITCH switch  where port.port_id = s2p.port_id  and s2p.switch_wwn = switch.switch_wwn  and switch.switch_id = " + string;
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getPortsForNode(String string, DBConnection dBConnection) {
        String string2 = "getPortsForNode";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct port.port_id as portId, port.detectable as state from t_res_node node, t_res_port port where node.node_id = port.node_id  and node.node_id = " + string;
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getBladesForNode(String string, DBConnection dBConnection) {
        String string2 = "getPortsBladesForNode";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct blade.switch_blade_id as bladeId, blade.detectable as state from t_res_node node, t_res_switch_blade blade where node.blade_id = blade.switch_blade_id  and node.node_id = " + string;
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static boolean isHostRemovable(String string) {
        String string2 = "getPortsForSwitch";
        DBResultSet dBResultSet = null;
        boolean bl = false;
        DBConnection dBConnection = RemoveMissingUtils.getDBConnection();
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return bl;
        }
        try {
            try {
                String string3 = " select distinct host.computer_id  from t_res_host host, t_res_device_agent deviceAgent, t_res_agent dataAgent where ( deviceAgent.host_id = host.computer_id  or dataAgent.computer_id = host.computer_id ) and host.computer_id = " + string;
                try {
                    dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
                    if (dBResultSet != null && dBResultSet.next()) {
                        bl = false;
                    } else {
                        if (TraceLogger.enableTrace) {
                            String string4 = "Host " + string + " has no agents installed and is removable.";
                            TraceLogger.traceMessage(1, className, string2, string4);
                        }
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBResultSet != null) {
                try {
                    dBResultSet.getStatement().close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    dBConnection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return bl;
    }

    public static DBResultSet getHBAsForHost(String string, DBConnection dBConnection) {
        String string2 = "getHBAsForHost";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct hba.hba_wwn as wwn, hba.hba_id as hbaId, hba.host_id as hostId, hba.detectable as state from t_res_hba hba, t_res_host host where hba.host_id = host.computer_id  and host.computer_id = " + string;
                try {
                    dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getNodesForHBA(String string, DBConnection dBConnection) {
        String string2 = "getNodesForHBA";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct node.node_id as nodeId, node.detectable as state1, h2n.node2hba_id as node2hbaId, h2n.detectable as state2  from  t_res_node node,  t_res_node2hba h2n,  t_res_hba hba where node.node_id = h2n.node_id  and h2n.hba_id = hba.hba_id  and hba.hba_id = " + string;
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getNode2HBAForNode(String string, DBConnection dBConnection) {
        String string2 = "getNode2HBAForNode";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct n2h.node2hba_id as node2hbaId, n2h.detectable as state from  t_res_node node,  t_res_node2hba n2h where node.node_id = n2h.node_id  and node.node_id = " + string;
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getPort2portForPort(String string, DBConnection dBConnection) throws SQLException {
        String string2 = "getPort2portForPort";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct p2p.port2port_id  as port2portId, p2p.detectable as state from  t_res_port2port p2p where p2p.port_id1 = " + string + " OR p2p.port_id2 = " + string;
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getZoneSet2ZonesForZone(String string, DBConnection dBConnection) {
        String string2 = "getZoeSet2ZoneForZone";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct zset2zone.zset2zone_id as zset2zoneId  from  t_res_zset2zone zset2zone,  t_res_zone zone where zset2zone.zone_id =  zone.zone_id  and zone.zone_id = " + string;
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getZone2MembersForZone(String string, DBConnection dBConnection) {
        String string2 = "getZone2MembersForZone";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct  zone2member.zone2member_id as zone2memberId  from  t_res_zone2member zone2member,  t_res_zone zone where zone2member.zone_id =  zone.zone_id  and zone.zone_id = " + Integer.parseInt(string);
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getFabricForSwitch(String string, DBConnection dBConnection) throws SQLException {
        String string2 = "getZone2MembersForZone";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct fabric.fabric_id as fabricId, fabric.detectable as state from  t_res_fabric fabric,  t_res_fabric2switch f2s,   t_res_switch switch where fabric.fabric_wwn = f2s.fabric_wwn  and f2s.switch_wwn = switch.switch_wwn  and switch.switch_id = " + string;
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getFabric2SwitchForSwitch(String string, DBConnection dBConnection) {
        String string2 = "getFabric2SwitchForSwitch";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct f2s.fabric2switch_id as fabric2switchId, f2s.detectable as state  from  t_res_fabric2switch f2s, t_res_switch switch  where  f2s.switch_wwn = switch.switch_wwn  and switch.switch_id = " + string;
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getSwitch2PortForSwitch(String string, DBConnection dBConnection) {
        String string2 = "getFabric2SwitchForSwitch";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct s2p.switch2port_id as switch2portId, s2p.detectable as state  from  t_res_switch2port s2p, t_res_switch switch  where  s2p.switch_wwn = switch.switch_wwn  and switch.switch_id = " + string;
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getAllZoneSetsForFabric(String string, DBConnection dBConnection) {
        String string2 = "getAllZoneSetsForFabric";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct  zset.zset_id  as zsetId  from  t_res_zset zset,  t_res_fabric fabric  where zset.fabric_wwn = fabric.fabric_wwn and fabric.fabric_wwn = " + string;
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getAllZonesForFabric(String string, DBConnection dBConnection) {
        String string2 = "getAllZoneSetsForFabric";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct  zone.zone_id  as zoneId  from  t_res_zone zone,  t_res_fabric fabric  where zone.fabric_wwn = fabric.fabric_wwn and fabric.fabric_wwn = " + string;
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getAllZoneMembersForFabric(String string, DBConnection dBConnection) {
        String string2 = "getAllZoneMembersForFabric";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct  zonemember.zone_member_id  as zonememberId  from   t_res_zone2member zone2member,  t_res_zone_member zonemember,  t_res_zone zone,  t_res_fabric fabric  where zone2member.zone_id = zone.zone_id  and zone2member.zone_member_id = zonemember.zone_member_id  and zone.fabric_wwn = fabric.fabric_wwn and fabric.fabric_id = " + string;
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getBladesForSwitch(String string, DBConnection dBConnection) {
        String string2 = "getBladesForSwitch";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct  blade.switch_blade_id as bladeId, blade.detectable as state from  t_res_switch_blade blade, t_res_switch switch  where blade.switch_wwn =  switch.switch_wwn and switch.switch_id = " + string;
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getSwitchesForFabric(String string, DBConnection dBConnection) {
        String string2 = "getBladesForSwitch";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct  switch.switch_id as switchId, switch.detectable as state1, f2s.fabric2switch_id as fabric2switchId,  f2s.detectable as state2  from  t_res_fabric fabric,  t_res_switch switch,  t_res_fabric2switch f2s where f2s.fabric_wwn = fabric.fabric_wwn and switch.switch_wwn = f2s.switch_wwn and fabric.fabric_id = " + string;
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getHostsForFabric(String string, DBConnection dBConnection) {
        String string2 = "getHostsForFabric";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct  host.computer_id as hostId, host.detectable as state  from  t_res_hba hba,  t_res_node2hba n2h,  t_res_node node,   t_res_port port1,  t_res_port port2,  t_res_port2port p2p,   t_res_switch switch,  t_res_switch2port s2p,   t_res_fabric2switch f2s,  t_res_fabric fabric, t_res_host host  where host.computer_id = hba.host_id  and hba.hba_id = n2h.hba_id  and n2h.node_id = node.node_id  and node.node_id = port1.node_id  and ( (port1.port_id = p2p.port_id1 and port2.port_id = p2p.port_id2)  OR (port1.port_id = p2p.port_id2 and port2.port_id = p2p.port_id1) ) and port2.port_id = s2p.port_id  and s2p.switch_wwn = switch.switch_wwn  and switch.switch_wwn = f2s.switch_wwn  and f2s.fabric_wwn = fabric.fabric_wwn  and fabric.fabric_id = " + string;
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getPEsForFabric(String string, DBConnection dBConnection) {
        String string2 = "getPEsForFabric";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct  pe.phy_pe_id as peId, pe.detectable as state  from  t_res_phy_pe pe,  t_res_pe2node p2n,  t_res_node node,   t_res_port port1,  t_res_port port2,  t_res_port2port p2p,   t_res_switch switch,  t_res_switch2port s2p,   t_res_fabric2switch f2s,  t_res_fabric fabric  where pe.phy_pe_id = p2n.phy_pe_id  and p2n.node_id = node.node_id  and node.node_id = port1.node_id  and ( (port1.port_id = p2p.port_id1 and port2.port_id = p2p.port_id2)  OR (port1.port_id = p2p.port_id2 and port2.port_id = p2p.port_id1) ) and port2.port_id = s2p.port_id  and s2p.switch_wwn = switch.switch_wwn  and switch.switch_wwn = f2s.switch_wwn  and f2s.fabric_wwn = fabric.fabric_wwn  and fabric.fabric_id = " + string;
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getNodesForFabric(String string, DBConnection dBConnection) {
        String string2 = "getNodesForFabric";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct  node.node_id as nodeId, node.detectable as state  from  t_res_node node,   t_res_port port1,  t_res_port port2,  t_res_port2port p2p,   t_res_switch2port s2p,  t_res_switch switch,   t_res_fabric2switch f2s,  t_res_fabric fabric  where node.node_id = port1.node_id  and ( (port1.port_id = p2p.port_id1 and port2.port_id = p2p.port_id2)  OR (port1.port_id = p2p.port_id2 and port2.port_id = p2p.port_id1) ) and port2.port_id = s2p.port_id  and s2p.switch_wwn = switch.switch_wwn  and switch.switch_wwn = f2s.switch_wwn  and f2s.fabric_wwn = fabric.fabric_wwn  and fabric.fabric_id = " + string;
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getNodesForPE(String string, DBConnection dBConnection) throws SQLException {
        String string2 = "getNodesForFabric";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct  node.node_id as nodeId, node.detectable state1,  p2n.pe2node_id as pe2nodeId, p2n.detectable as state2  from   t_res_node node,  t_res_phy_pe pe,  t_res_pe2node p2n where p2n.phy_pe_id = pe.phy_pe_id  and p2n.node_id = node.node_id  and pe.phy_pe_id = " + string;
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getAllMissingSwitches(String string, DBConnection dBConnection) {
        String string2 = "getNodesForFabric";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return dBResultSet;
        }
        try {
            try {
                String string3 = " select distinct  switch.switch_id as switchId  from  t_res_switch switch  where switch.detectable = 0";
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getAllMissingFabrics(String string, DBConnection dBConnection) {
        String string2 = "getAllMissinfFabrics";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return null;
        }
        try {
            try {
                String string3 = " select distinct  fabric.fabric_id as fabricId  from  t_res_fabric fabric  where fabric.detectable = 0";
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static DBResultSet getAllMissingTapeLibraries(String string, DBConnection dBConnection) {
        String string2 = "getAllMissingTapeLibraries";
        DBResultSet dBResultSet = null;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return null;
        }
        try {
            try {
                String string3 = " select distinct  lib.tape_library_id as libId  from  t_res_tape_library lib  where lib.detectable = 0";
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return dBResultSet;
    }

    public static ArrayList getExpiredMissingEntitiesOld(String string, DBConnection dBConnection) {
        String string2;
        String string3 = "getExpiredMissingEntities";
        ArrayList<String> arrayList = new ArrayList<String>();
        String string4 = null;
        String string5 = null;
        if (RemoveMissingUtils.isBadConnection(string3, dBConnection)) {
            return arrayList;
        }
        if (string.equals("fabric")) {
            string2 = "t_res_fabric";
            string4 = "fabric_id";
            string5 = "fabric";
        } else if (string.equals("switch")) {
            string2 = "t_res_switch";
            string4 = "switch_id";
            string5 = "fabric";
        } else if (string.equals("host")) {
            string2 = "t_res_host";
            string4 = "computer_id";
            string5 = "fabric";
        } else if (string.equals("pe")) {
            string2 = "t_res_phy_pe";
            string4 = "phy_pe_id";
            string5 = "fabric";
        } else if (string.equals("node")) {
            string2 = "t_res_node";
            string4 = "node_id";
            string5 = "fabric";
        } else if (string.equals("port")) {
            string2 = "t_res_port";
            string4 = "port_id";
            string5 = "fabric";
        } else if (string.equals("port2port")) {
            string2 = "t_res_port2port";
            string4 = "port2port_id";
            string5 = "fabric";
        } else if (string.equals("tapelibrary")) {
            string2 = "t_res_tape_library";
            string4 = "tape_library_id";
            string5 = "tapelibrary";
        } else if (string.equals("subsystem")) {
            string2 = "t_res_storage_subsystem";
            string4 = "subsystem_id";
            string5 = "subsystem";
        } else {
            if (TraceLogger.enableTrace) {
                String string6 = String.valueOf(string) + " is not supported as individual remove.";
                TraceLogger.traceMessage(1, className, string3, string6);
            }
            return arrayList;
        }
        long l = RemoveMissingUtils.getKeepRemovedSettings(string5);
        DBResultSet dBResultSet = null;
        try {
            try {
                dBConnection.getSchema();
                String string7 = "Select distinct state.ELEMENT_ID, state.UPDATE_TIMESTAMP from T_RES_ELEMENT_PROBE_STATUS state, " + string2 + " device " + " where device.DETECTABLE = 0 " + " and  device." + string4 + "=state.ELEMENT_ID";
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string7, null);
                new ArrayList();
                new ArrayList();
                long l2 = 0L;
                String string8 = null;
                while (dBResultSet.next()) {
                    long l3;
                    Timestamp timestamp = (Timestamp)dBResultSet.getObject(2);
                    string8 = dBResultSet.getString(1);
                    long l4 = CurrentTime.getTimestamp(dBConnection).getTime();
                    l2 = l4 - (l3 = timestamp.getTime());
                    if (l2 < l) continue;
                    arrayList.add(String.valueOf(string) + ':' + string8);
                    if (!TraceLogger.enableTrace) continue;
                    String string9 = String.valueOf(string) + string8 + " is missing for " + l2;
                    TraceLogger.traceMessage(1, className, string3, string9);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (dBResultSet != null) {
                try {
                    dBResultSet.getStatement().close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return arrayList;
    }

    private static long getKeepRemovedSettings(String string) {
        DBConnection dBConnection = RemoveMissingUtils.getDBConnection();
        dBConnection.getSchema();
        long l = 0L;
        new Hashtable();
        StormSettings.StormSettingsCursor stormSettingsCursor = null;
        try {
            try {
                stormSettingsCursor = StormSettings.getCursor(dBConnection, null, null);
                if (stormSettingsCursor.next()) {
                    StormSettings stormSettings = stormSettingsCursor.getObject();
                    if (string.equalsIgnoreCase("fabric")) {
                        l = (long)stormSettings.getKeepRemovedFabric() * 86400000L;
                    } else if (string.equalsIgnoreCase("tapelibrary")) {
                        l = (long)stormSettings.getKeepRemovedTape() * 86400000L;
                    } else if (string.equalsIgnoreCase("subsystem")) {
                        l = (long)stormSettings.getKeepRemovedSubsystems() * 86400000L;
                    }
                }
            }
            catch (Exception exception) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", exception);
                    traceLogger.text(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", "Exception while retrieving keepRemovedSettings for type " + string);
                }
            }
        }
        finally {
            block36: {
                block34: {
                    if (stormSettingsCursor != null) {
                        try {
                            stormSettingsCursor.close();
                        }
                        catch (Exception exception) {
                            if (!traceLogger.isLogging()) break block34;
                            traceLogger.exception(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", exception);
                            traceLogger.text(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", "Could not close TStormSettings cursor");
                        }
                    }
                }
                if (dBConnection != null) {
                    block35: {
                        try {
                            dBConnection.commit();
                        }
                        catch (Exception exception) {
                            if (!traceLogger.isLogging()) break block35;
                            traceLogger.exception(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", exception);
                            traceLogger.text(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", "Error committing connection");
                        }
                    }
                    try {
                        dBConnection.close();
                    }
                    catch (Exception exception) {
                        if (!traceLogger.isLogging()) break block36;
                        traceLogger.exception(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", exception);
                        traceLogger.text(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", "Could not close connection");
                    }
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, "getKeepRemovedSettings", "keepRemovedValue for type " + string + " is " + l);
        }
        return l;
    }

    public static ArrayList getExpiredMissingEntities(String string, DBConnection dBConnection) {
        return RemoveMissingUtils.getExpiredMissingEntities(string, null, dBConnection);
    }

    public static ArrayList getExpiredMissingEntities(String string, String string2, DBConnection dBConnection) {
        String string3;
        String string4 = "getExpiredMissingEntitiesINDB";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string4, string);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string5 = null;
        boolean bl = false;
        if (RemoveMissingUtils.isBadConnection(string4, dBConnection)) {
            return arrayList;
        }
        if (string.equals("fabric")) {
            string3 = "t_res_fabric";
            string5 = "fabric_id";
            string2 = "fabric";
        } else if (string.equals("fabric2switch")) {
            string3 = "t_res_fabric2switch";
            string5 = "fabric2switch_id";
            string2 = "fabric";
        } else if (string.equals("switch")) {
            string3 = "t_res_switch";
            string5 = "switch_id";
            string2 = "fabric";
        } else if (string.equals("blade")) {
            string3 = "t_res_switch_blade";
            string5 = "switch_blade_id";
            string2 = "fabric";
        } else if (string.equals("switch2port")) {
            string3 = "t_res_switch2port";
            string5 = "switch2port_id";
            string2 = "fabric";
        } else if (string.equals("host")) {
            string3 = "t_res_host";
            string5 = "computer_id";
            string2 = "fabric";
        } else if (string.equals("hba")) {
            string3 = "t_res_hba";
            string5 = "hba_id";
            string2 = "fabric";
        } else if (string.equals("node2hba")) {
            string3 = "t_res_node2hba";
            string5 = "node2hba_id";
            string2 = "fabric";
        } else if (string.equals("pe")) {
            string3 = "t_res_phy_pe";
            string5 = "phy_pe_id";
            string2 = "fabric";
        } else if (string.equals("pe2node")) {
            string3 = "t_res_pe2node";
            string5 = "pe2node_id";
            string2 = "fabric";
        } else if (string.equals("node")) {
            string3 = "t_res_node";
            string5 = "node_id";
            string2 = "fabric";
        } else if (string.equals("port")) {
            string3 = "t_res_port";
            string5 = "port_id";
            if (string2 == null) {
                string2 = "fabric";
            } else {
                bl = true;
            }
        } else if (string.equals("port2port")) {
            string3 = "t_res_port2port";
            string5 = "port2port_id";
            string2 = "fabric";
        } else if (string.equals("subsystem")) {
            string3 = "t_res_storage_subsystem";
            string5 = "subsystem_id";
            string2 = "subsystem";
        } else if (string.equals("storagevolume")) {
            string3 = StorageVolume.getTablename();
            string5 = "SVID";
            bl = true;
        } else if (string.equals("storagepool")) {
            string3 = StoragePool.getTablename();
            string5 = "POOL_ID";
            bl = true;
        } else if (string.equals("physicalvolume")) {
            string3 = PhysicalVolume.getTablename();
            string5 = "PHYSICAL_VOLUME_ID";
            bl = true;
        } else if (string.equals("tapelibrary")) {
            string3 = "t_res_tape_library";
            string5 = "tape_library_id";
            string2 = "tapelibrary";
        } else if (string.equals("tapedrive")) {
            string3 = TapeDrive.getTablename();
            string5 = "TAPE_DRIVE_ID";
            bl = true;
        } else if (string.equals("tapemediachanger")) {
            string3 = TapeMediaChanger.getTablename();
            string5 = "TAPE_MEDIA_CHANGER_ID";
            bl = true;
        } else {
            if (TraceLogger.enableTrace) {
                String string6 = String.valueOf(string) + " is not supported as individual remove.";
                TraceLogger.traceMessage(1, className, string4, string6);
            }
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, string4, String.valueOf(string) + " is not supported for individual removal.");
            }
            return arrayList;
        }
        long l = RemoveMissingUtils.getKeepRemovedSettings(string2);
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, string4, " retention for type " + string + " is keepDuration");
        }
        DBResultSet dBResultSet = null;
        try {
            try {
                dBConnection.getSchema();
                String string7 = " Select distinct  device." + string5 + ", device.UPDATE_TIMESTAMP " + " from " + string3 + " device " + " where device.DETECTABLE = 0 ";
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string7, null);
                new ArrayList();
                new ArrayList();
                long l2 = 0L;
                String string8 = null;
                int n = -1;
                while (dBResultSet.next()) {
                    long l3;
                    if (bl) {
                        n = dBResultSet.getInt(1);
                    } else {
                        string8 = dBResultSet.getString(1);
                    }
                    if (string.equals("host") && !RemoveMissingUtils.isHostRemovable(string8)) {
                        if (!traceLogger.isLogging()) continue;
                        traceLogger.text(IRecordType.TYPE_INFO, className, string4, " The host with device Id : " + string8 + " is not removable.");
                        continue;
                    }
                    Timestamp timestamp = (Timestamp)dBResultSet.getObject(2);
                    long l4 = CurrentTime.getTimestamp(dBConnection).getTime();
                    l2 = l4 - (l3 = timestamp.getTime());
                    if (l2 < l) continue;
                    if (bl) {
                        arrayList.add(new Integer(n));
                    } else {
                        arrayList.add(String.valueOf(string) + ':' + string8);
                    }
                    int n2 = Math.round(l2 / 86400000L);
                    if (TraceLogger.enableTrace) {
                        String string9 = String.valueOf(string) + string8 + " has missed for " + n2 + " days.";
                        TraceLogger.traceMessage(1, className, string4, string9);
                    }
                    if (!traceLogger.isLogging()) continue;
                    traceLogger.text(IRecordType.TYPE_INFO, className, string4, String.valueOf(string) + string8 + " has been missing for " + n2 + " days.");
                }
            }
            catch (Exception exception) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(className, string4, exception);
                }
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, string4, exception);
                    traceLogger.text(IRecordType.TYPE_ERR, className, string4, "Exception while getting expired missing entities");
                }
            }
        }
        finally {
            block80: {
                block79: {
                    if (dBResultSet != null) {
                        try {
                            dBResultSet.getStatement().close();
                        }
                        catch (Exception exception) {
                            if (TraceLogger.enableTrace) {
                                TraceLogger.exception(className, string4, exception);
                            }
                            if (!traceLogger.isLogging()) break block79;
                            traceLogger.exception(IRecordType.TYPE_ERROR, className, string4, exception);
                            traceLogger.text(IRecordType.TYPE_ERR, className, string4, "Exception while closing DBResultSet.");
                        }
                    }
                }
                if (dBConnection != null) {
                    try {
                        dBConnection.commit();
                    }
                    catch (Exception exception) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception(className, string4, exception);
                        }
                        if (!traceLogger.isLogging()) break block80;
                        traceLogger.exception(IRecordType.TYPE_ERROR, className, string4, exception);
                        traceLogger.text(IRecordType.TYPE_ERR, className, string4, "Exception while committing connection.");
                    }
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(className, string4, "Found " + arrayList.size() + " expired entities of type " + string);
        }
        return arrayList;
    }

    public static DBResultSet executeSqlQuery(DBConnection dBConnection, String string) throws Exception {
        String string2 = "executeSqlQuery";
        boolean bl = false;
        int n = 0;
        DBResultSet dBResultSet = null;
        do {
            try {
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, new Hashtable());
                bl = false;
            }
            catch (SQLException sQLException) {
                if (SQLExceptionHelper.isDeadlock(dBConnection, sQLException)) {
                    sQLException.printStackTrace();
                    dBConnection.rollback();
                    if (++n <= 3) {
                        Object object;
                        if (TraceLogger.enableTrace) {
                            object = " Retry " + n + "after deadlock";
                            TraceLogger.traceMessage(1, className, string2, (String)object);
                        }
                        bl = true;
                        object = new Random();
                        long l = (long)(500.0 * ((Random)object).nextDouble() * (double)n);
                        if (l < 100L) {
                            l = 100L;
                        }
                        Thread.sleep(l);
                        continue;
                    }
                    throw sQLException;
                }
                throw sQLException;
            }
            catch (Exception exception) {
                throw exception;
            }
        } while (bl);
        return dBResultSet;
    }

    public static boolean isBadConnection(String string, DBConnection dBConnection) {
        boolean bl = false;
        String string2 = "isBadConnection";
        if (dBConnection == null) {
            if (TraceLogger.enableTrace) {
                String string3 = "WARNING:" + string + " call has invalid DBConnection.";
                TraceLogger.traceMessage(1, className, string2, string3);
            }
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, className, string, "WARNING:" + string + " call has invalid DBConnection.");
            }
            bl = true;
        }
        return bl;
    }

    public static boolean isPhysicalFabric(String string) {
        boolean bl;
        String string2;
        block21: {
            string2 = "isPhysicalFabric";
            bl = false;
            DBConnection dBConnection = RemoveMissingUtils.getDBConnection();
            DBResultSet dBResultSet = null;
            String string3 = "select * from t_res_fabric fabric where fabric.fabric_id = " + string + " and fabric.is_Physical =1 and fabric.parent_fabric_wwn is null ";
            if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
                return bl;
            }
            try {
                try {
                    dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, null);
                    if (dBResultSet != null && dBResultSet.next()) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR, className, string2, exception);
                        traceLogger.text(IRecordType.TYPE_ERROR, className, string2, "Error determining whether the given fabric : " + string + " is a physical SAN or not. The DB Query failed");
                    }
                }
            }
            finally {
                block20: {
                    if (dBResultSet != null) {
                        try {
                            dBResultSet.getStatement().close();
                        }
                        catch (Exception exception) {
                            if (!traceLogger.isLogging()) break block20;
                            traceLogger.exception(IRecordType.TYPE_ERROR, className, string2, exception);
                            traceLogger.text(IRecordType.TYPE_ERROR, className, string2, "Error while closing DB ResultSet");
                        }
                    }
                }
            }
            if (dBConnection != null) {
                try {
                    dBConnection.close();
                }
                catch (Exception exception) {
                    if (!traceLogger.isLogging()) break block21;
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, string2, exception);
                    traceLogger.text(IRecordType.TYPE_ERROR, className, string2, "Error closing DB connection");
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, bl);
        }
        return bl;
    }

    public static DBResultSet getVsansForFabric(String string, DBConnection dBConnection) {
        DBResultSet dBResultSet;
        String string2;
        block6: {
            string2 = "getVsansForFabric";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, string);
            }
            dBResultSet = null;
            String string3 = "select fabric.fabric_WWN from t_res_fabric fabric where fabric.fabric_id = " + string;
            String string4 = " select distinct  fabric.fabric_id as vsanId, fabric.detectable as vsanState  from  t_res_fabric fabric  where fabric.parent_fabric_wwn = ";
            if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
                return dBResultSet;
            }
            try {
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, null);
                String string5 = null;
                while (dBResultSet.next()) {
                    string5 = dBResultSet.getString("fabric_WWN");
                }
                string4 = String.valueOf(string4) + "'" + string5 + "'";
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string4, new Hashtable());
            }
            catch (Exception exception) {
                if (!traceLogger.isLogging()) break block6;
                traceLogger.exception(IRecordType.TYPE_ERROR, className, string2, exception);
                traceLogger.text(IRecordType.TYPE_ERROR, className, string2, "Could not retrieve VSANs for physical SAN with fabric id: " + string);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return dBResultSet;
    }

    public static void markChildVsansAsRegular(String string, DBConnection dBConnection) {
        String string2 = "markChildVsansAsRegular";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, string);
        }
        int n = 0;
        DBResultSet dBResultSet = null;
        String string3 = "select fabric.fabric_WWN from t_res_fabric fabric where fabric.fabric_id = " + string;
        String string4 = " update  t_res_fabric fabric  set fabric.parent_fabric_wwn = '', fabric.is_physical = 1  where fabric.parent_fabric_wwn = ";
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return;
        }
        try {
            try {
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, null);
                String string5 = null;
                while (dBResultSet.next()) {
                    string5 = dBResultSet.getString("fabric_WWN");
                }
                string4 = String.valueOf(string4) + "'" + string5 + "'";
                n = ComplexQuery.sqlUpdate(dBConnection, string4, new Hashtable());
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_WARN, className, string2, "marked " + n + " vsans as regular SANs ");
                }
            }
            catch (Exception exception) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, string2, exception);
                    traceLogger.text(IRecordType.TYPE_ERROR, className, string2, "Could not mark VSANs as regular SANs during the physical infrastructure removal");
                }
            }
        }
        finally {
            block19: {
                if (dBConnection != null) {
                    try {
                        dBConnection.commit();
                    }
                    catch (Exception exception) {
                        if (!traceLogger.isLogging()) break block19;
                        traceLogger.exception(IRecordType.TYPE_ERROR, className, string2, exception);
                        traceLogger.text(IRecordType.TYPE_ERR, className, string2, "Error committing updated vsan records.");
                    }
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, n);
        }
    }

    public static void markHBAPortAsNormalPort(String string, DBConnection dBConnection) {
        String string2 = "markHBAPortAsNormalPort";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, string);
        }
        int n = 0;
        String string3 = " update  t_res_port port  set port.hba_id = null  where port.hba_id = " + string;
        if (RemoveMissingUtils.isBadConnection(string2, dBConnection)) {
            return;
        }
        try {
            try {
                n = ComplexQuery.sqlUpdate(dBConnection, string3, new Hashtable());
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, className, string2, "marked " + n + " HBAPORT as Normal PORT ");
                }
            }
            catch (Exception exception) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, string2, exception);
                    traceLogger.text(IRecordType.TYPE_ERROR, className, string2, "Could not mark hba port as normal port.");
                }
            }
        }
        finally {
            block18: {
                if (dBConnection != null) {
                    try {
                        dBConnection.commit();
                    }
                    catch (Exception exception) {
                        if (!traceLogger.isLogging()) break block18;
                        traceLogger.exception(IRecordType.TYPE_ERROR, className, string2, exception);
                        traceLogger.text(IRecordType.TYPE_ERR, className, string2, "Error committing updated ports records.");
                    }
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, n);
        }
    }

    public static void deleteAttributeSnapshot(String string, String string2, DBConnection dBConnection) {
        String string3;
        String string4 = "deleteAttributeSnapshot";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string4, String.valueOf(string) + string2);
        }
        String string5 = null;
        if (RemoveMissingUtils.isBadConnection(string4, dBConnection)) {
            return;
        }
        if (string.equals("fabric")) {
            string3 = "t_res_fabric_attribute_snapshot";
            string5 = "fabric_wwn";
            string2 = "'" + string2 + "'";
        } else if (string.equals("fabric2switch")) {
            string3 = "t_res_fabric2switch_attribute_snapshot";
            string5 = "fabric2switch_id";
        } else if (string.equals("switch")) {
            string3 = "t_res_switch_attribute_snapshot";
            string5 = "switch_wwn";
            string2 = "'" + string2 + "'";
        } else if (string.equals("blade")) {
            string3 = "t_res_switch_blade_attribute_snapshot";
            string5 = "switch_blade_id";
        } else if (string.equals("switch2port")) {
            string3 = "t_res_switch2port_attribute_snapshot";
            string5 = "switch2port_id";
        } else if (string.equals("host")) {
            string3 = "t_res_host_attribute_snapshot";
            string5 = "computer_id";
        } else if (string.equals("hba")) {
            string3 = "t_res_hba_attribute_snapshot";
            string5 = "hba_id";
        } else if (string.equals("node2hba")) {
            string3 = "t_view_node2computer_attribute_snapshot";
            string5 = "node2hba_id";
        } else if (string.equals("pe")) {
            string3 = "t_res_phy_pe_attribute_snapshot";
            string5 = "phy_pe_id";
        } else if (string.equals("pe2node")) {
            string3 = "t_res_pe2node_attribute_snapshot";
            string5 = "pe2node_id";
        } else if (string.equals("node")) {
            string3 = "t_res_node_attribute_snapshot";
            string5 = "node_id";
        } else if (string.equals("port")) {
            string3 = "t_view_port2parent_attribute_snapshot";
            string5 = "port_id";
        } else if (string.equals("port2port")) {
            string3 = "t_view_port2port2fabric_attribute_snapshot";
            string5 = "port2port_id";
        } else {
            if (TraceLogger.enableTrace) {
                String string6 = String.valueOf(string) + " is not supported as individual remove.";
                TraceLogger.traceMessage(1, className, string4, string6);
            }
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, string4, String.valueOf(string) + " is not supported for individual removal.");
            }
            return;
        }
        try {
            try {
                String string7 = " delete from " + string3 + " device " + " where device.detectable=0" + " and device." + string5 + "=" + string2;
                int n = ComplexQuery.sqlUpdate(dBConnection, string7, new Hashtable());
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, className, string4, "delete " + n + " from " + string3 + string2);
                }
            }
            catch (Exception exception) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, string4, exception);
                    traceLogger.text(IRecordType.TYPE_ERROR, className, string4, "Could not mark hba port as normal port.");
                }
            }
        }
        finally {
            block46: {
                if (dBConnection != null) {
                    try {
                        dBConnection.commit();
                    }
                    catch (Exception exception) {
                        if (!traceLogger.isLogging()) break block46;
                        traceLogger.exception(IRecordType.TYPE_ERROR, className, string4, exception);
                        traceLogger.text(IRecordType.TYPE_ERR, className, string4, "Error committing updated ports records.");
                    }
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string4);
        }
    }

    public static String getFabricWWNById(String string) {
        String string2;
        boolean bl;
        String string3;
        block21: {
            string3 = "getFabricWWNById";
            bl = false;
            string2 = null;
            DBConnection dBConnection = RemoveMissingUtils.getDBConnection();
            DBResultSet dBResultSet = null;
            String string4 = "select fabric_wwn from t_res_fabric fabric where fabric.fabric_id = " + string;
            if (RemoveMissingUtils.isBadConnection(string3, dBConnection)) {
                return null;
            }
            try {
                try {
                    dBResultSet = ComplexQuery.sqlQuery(dBConnection, string4, null);
                    if (dBResultSet != null && dBResultSet.next()) {
                        string2 = dBResultSet.getString("fabric_wwn");
                    }
                }
                catch (Exception exception) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR, className, string3, exception);
                    }
                }
            }
            finally {
                block20: {
                    if (dBResultSet != null) {
                        try {
                            dBResultSet.getStatement().close();
                        }
                        catch (Exception exception) {
                            if (!traceLogger.isLogging()) break block20;
                            traceLogger.exception(IRecordType.TYPE_ERROR, className, string3, exception);
                            traceLogger.text(IRecordType.TYPE_ERROR, className, string3, "Error while closing DB ResultSet");
                        }
                    }
                }
            }
            if (dBConnection != null) {
                try {
                    dBConnection.close();
                }
                catch (Exception exception) {
                    if (!traceLogger.isLogging()) break block21;
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, string3, exception);
                    traceLogger.text(IRecordType.TYPE_ERROR, className, string3, "Error closing DB connection");
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3, bl);
        }
        return string2;
    }

    public static String getSwitchWWNById(String string) {
        String string2;
        boolean bl;
        String string3;
        block21: {
            string3 = "getSwitchWWNById";
            bl = false;
            string2 = null;
            DBConnection dBConnection = RemoveMissingUtils.getDBConnection();
            DBResultSet dBResultSet = null;
            String string4 = "select switch_wwn from t_res_switch switch where switch.switch_id = " + string;
            if (RemoveMissingUtils.isBadConnection(string3, dBConnection)) {
                return null;
            }
            try {
                try {
                    dBResultSet = ComplexQuery.sqlQuery(dBConnection, string4, null);
                    if (dBResultSet != null && dBResultSet.next()) {
                        string2 = dBResultSet.getString("switch_wwn");
                    }
                }
                catch (Exception exception) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR, className, string3, exception);
                    }
                }
            }
            finally {
                block20: {
                    if (dBResultSet != null) {
                        try {
                            dBResultSet.getStatement().close();
                        }
                        catch (Exception exception) {
                            if (!traceLogger.isLogging()) break block20;
                            traceLogger.exception(IRecordType.TYPE_ERROR, className, string3, exception);
                            traceLogger.text(IRecordType.TYPE_ERROR, className, string3, "Error while closing DB ResultSet");
                        }
                    }
                }
            }
            if (dBConnection != null) {
                try {
                    dBConnection.close();
                }
                catch (Exception exception) {
                    if (!traceLogger.isLogging()) break block21;
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, string3, exception);
                    traceLogger.text(IRecordType.TYPE_ERROR, className, string3, "Error closing DB connection");
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3, bl);
        }
        return string2;
    }
}

