/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.interfaces;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Observable;
import org.eclipse.aperi.sanmgmt.logging.ILogger;

public class Request
extends Observable
implements Serializable {
    private static final long serialVersionUID = 453565471281024088L;
    public static final int WAITING = -2;
    public static final int SUBMITTED = -1;
    public static final int FAILED = 0;
    public static final int SUCCESSFUL = 1;
    public static final int RUNNING = 2;
    public static final int WARNING = 3;
    public static final int PARTIAL_FAILURE = 4;
    public static final int CANCELLED = 5;
    private String deviceServerRunNumber = "";
    private boolean running = true;
    private int status = 2;
    private boolean mainProcess = false;
    private HashSet requests = new HashSet();
    private Request parentRequest = null;
    private ILogger jobLogger = null;
    private boolean externalJobLogger = true;
    private boolean noJobManagement = false;
    private int id;
    private int rc = 0;
    private String scannerId = null;
    private int authoritativeReferenceType = -1;
    private int authoritativeReferenceId = -1;
    private String jobPrefix = null;

    public Request(int n, String string, Request request, ILogger iLogger, boolean bl, boolean bl2, boolean bl3, String string2, int n2, int n3, String string3) {
        this.id = n;
        this.mainProcess = bl3;
        this.deviceServerRunNumber = string;
        this.parentRequest = request;
        this.noJobManagement = bl2;
        this.jobLogger = iLogger;
        this.externalJobLogger = bl;
        if (request != null) {
            request.addChildRequest(this);
        }
        this.scannerId = string2;
        this.authoritativeReferenceType = n2;
        this.authoritativeReferenceId = n3;
        this.jobPrefix = string3;
    }

    public int getId() {
        return this.id;
    }

    public boolean isExternalJobLogger() {
        return this.externalJobLogger;
    }

    public boolean isNoJobManagement() {
        return this.noJobManagement;
    }

    public String getDeviceServerRunNumber() {
        return this.deviceServerRunNumber;
    }

    public void setDeviceServerRunNumber(String string) {
        this.deviceServerRunNumber = string;
    }

    public Request getParentRequest() {
        return this.parentRequest;
    }

    public void setParentRequest(Request request) {
        this.parentRequest = request;
    }

    public void addChildRequest(Request request) {
        this.requests.add(request);
    }

    public void removeChildRequest(Request request) {
        this.requests.remove(request);
    }

    public void setRunning(boolean bl) {
        this.running = bl;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isMainProcess() {
        return this.mainProcess;
    }

    public boolean hasRunningChildRequests() {
        return !this.requests.isEmpty();
    }

    public Request[] getChildRequests() {
        return this.requests.toArray(new Request[0]);
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public int getStatus() {
        return this.status;
    }

    public ILogger getJobLogger() {
        return this.jobLogger;
    }

    public void setReturnCode(int n) {
        this.rc = n;
    }

    public int getReturnCode() {
        return this.rc;
    }

    public String getScannerId() {
        return this.scannerId;
    }

    public int getAuthoritativeReferenceType() {
        return this.authoritativeReferenceType;
    }

    public int getAuthoritativeReferenceId() {
        return this.authoritativeReferenceId;
    }

    public String getJobPrefix() {
        return this.jobPrefix;
    }
}

