/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.CIM.CIMClientPool;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.MapableReusable;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerExecException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerRTException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.common.util.thread.DiskThreadManager;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMQualifierType;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.client.BatchHandle;
import org.sblim.wbem.client.BatchResult;
import org.sblim.wbem.client.CIMClient;
import org.sblim.wbem.client.PasswordCredential;
import org.sblim.wbem.client.UserPrincipal;
import org.sblim.wbem.client.indications.CIMListener;
import org.sblim.wbem.util.SessionProperties;

public class CIMClientWrapper
implements MapableReusable {
    private static final String SVC_NAME = "External CIM request";
    private static final long SVC_TIMEOUT_DEFAULT = 600000L;
    private long cTimeout = 600000L;
    private Map cMethodTimeouts = null;
    public CIMClient cCIMClnt = null;
    private static Map stCIMOMLocks = Collections.synchronizedMap(new HashMap());
    private static Boolean stSynchronizationEnabled = null;
    private static Boolean stSaxParsingEnabled = null;
    private String cServiceURL = null;
    private Object cLock = new Object();
    private String cKey = null;
    private boolean cIsInPool = false;
    private boolean useCimPool = true;
    public static final String TRACE_NAME = "aperi.logger.trace.CIMScanner";
    public static ILogger traceLogger = null;
    public static String className = CIMClientWrapper.class.getName();

    static {
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
    }

    public CIMClientWrapper(String string, String string2, String string3, String string4) throws CIMException {
        this(string, string2, string3, string4, false);
    }

    public CIMClientWrapper(CIMClient cIMClient) throws CIMException {
        this.cCIMClnt = cIMClient;
        this.cKey = cIMClient.toString();
        this.cMethodTimeouts = new HashMap();
        this.cTimeout = this.getCfgTimeout();
        this.getServiceURL();
        this.useCimPool = false;
    }

    protected CIMClientWrapper(String string, String string2, String string3, String string4, boolean bl) throws CIMException {
        UserPrincipal userPrincipal = new UserPrincipal(string);
        PasswordCredential passwordCredential = null;
        passwordCredential = string2 != null ? new PasswordCredential(string2.toCharArray()) : new PasswordCredential();
        CIMNameSpace cIMNameSpace = new CIMNameSpace(string3, string4);
        this.cCIMClnt = new CIMClient(cIMNameSpace, (Principal)userPrincipal, (Object)passwordCredential);
        this.cKey = CIMClientWrapper.generateKey(string, string2, string3, string4);
        this.cMethodTimeouts = new HashMap();
        this.cTimeout = this.getCfgTimeout();
        this.cServiceURL = string3;
        this.useCimPool = bl;
    }

    protected static String generateKey(String string, String string2, String string3, String string4) {
        return String.valueOf(string3) + string + string2 + string4;
    }

    public Object getMappingKey() {
        return this.cKey;
    }

    public void initializeInstance(String string, String string2, String string3, String string4) throws CIMException {
    }

    public void clearInstance() {
        this.cTimeout = this.getCfgTimeout();
    }

    public boolean isInPool() {
        return this.cIsInPool;
    }

    public void setIsInPool(boolean bl) {
        this.cIsInPool = bl;
    }

    public void releaseInstance() {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "releaseInstance", null);
        try {
            logTraceHelper.traceHigh("ObjectID: " + this.getAddress() + " ThreadName: " + Thread.currentThread().getName());
            if (!this.isInPool()) {
                this.clearInstance();
                this.cCIMClnt.close();
            }
        }
        finally {
            logTraceHelper.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object executeSvcCall(String var1_1, Class[] var2_2, Object[] var3_3, LogTraceHelper var4_4) throws DiskManagerTimeoutException, CIMException {
        var5_5 = "executeSvcCall";
        var6_6 = null;
        var7_7 = null;
        var8_8 = (Long)this.cMethodTimeouts.get(var1_1);
        try {
            if (var4_4 != null) {
                var4_4.traceSvcEntry("External CIM request", var3_3);
                var4_4.traceHigh("ObjectID: " + this.getAddress() + " ThreadName: " + Thread.currentThread().getName());
            } else {
                if (CIMClientWrapper.traceLogger.isLogging()) {
                    CIMClientWrapper.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)CIMClientWrapper.className, var5_5, var3_3);
                }
                CIMClientWrapper.traceLogger.text(IRecordType.TYPE_INFO, CIMClientWrapper.className, var5_5, "ObjectID: " + this.getAddress() + " ThreadName: " + Thread.currentThread().getName());
            }
            if (this.isSaxParsingNeeded()) {
                var9_9 /* !! */  = (SessionProperties)SessionProperties.getGlobalProperties().clone();
                var9_9 /* !! */ .setXmlParser(1);
                this.cCIMClnt.setSessionProperties(var9_9 /* !! */ );
                if (var4_4 != null) {
                    var4_4.traceHigh("Using SAX parser for " + this.getServiceURL());
                } else if (CIMClientWrapper.traceLogger.isLogging()) {
                    CIMClientWrapper.traceLogger.text(IRecordType.TYPE_ALL, CIMClientWrapper.className, var5_5, "Using SAX parser for " + this.getServiceURL() + " ThreadName: " + Thread.currentThread().getName());
                }
            }
            if (this.isSynchronisationNeeded()) {
                var10_12 /* !! */  = var9_9 /* !! */  = this.getLock();
                synchronized (var10_12 /* !! */ ) {
                    var6_6 = var2_2 != null ? DiskThreadManager.executeWithTimeLimit(this.cCIMClnt, var1_1, var2_2, var3_3, var8_8 == null ? this.cTimeout : var8_8, var4_4) : DiskThreadManager.executeWithTimeLimit(this.cCIMClnt, var1_1, var3_3, var8_8 == null ? this.cTimeout : var8_8, var4_4);
                }
            } else {
                var6_6 = var2_2 != null ? DiskThreadManager.executeWithTimeLimit(this.cCIMClnt, var1_1, var2_2, var3_3, var8_8 == null ? this.cTimeout : var8_8, var4_4) : DiskThreadManager.executeWithTimeLimit(this.cCIMClnt, var1_1, var3_3, var8_8 == null ? this.cTimeout : var8_8, var4_4);
            }
            var14_14 = var6_6;
            if (var6_6 == null) ** GOTO lbl80
            ** GOTO lbl67
        }
        catch (DiskManagerExecException var9_10) {
            try {
                block33: {
                    var7_7 = var9_10.getCause();
                    var10_13 = null;
                    if (var7_7 instanceof InvocationTargetException) {
                        var10_13 = ((InvocationTargetException)var7_7).getTargetException();
                    } else {
                        v1 = var10_13 = var7_7.getCause() != null ? var7_7.getCause() : var7_7;
                    }
                    if (var10_13 instanceof CIMException) {
                        var11_15 = new StringBuffer();
                        var11_15.append("CIMException at ");
                        var11_15.append(var1_1);
                        var11_15.append("(");
                        var12_16 = 0;
                        while (true) {
                            if (var12_16 >= var3_3.length) {
                                var12_17 = var11_15.toString();
                                if (var4_4 == null) break;
                                var4_4.traceError(String.valueOf(var12_17.substring(0, var12_17.length() - 1)) + ")", var10_13);
                                throw (CIMException)var10_13;
                            }
                            var11_15.append(DiskMessageHelper.toMsgString(var3_3[var12_16]));
                            var11_15.append(",");
                            ++var12_16;
                        }
                        if (CIMClientWrapper.traceLogger.isLogging() == false) throw (CIMException)var10_13;
                        CIMClientWrapper.traceLogger.exception(IRecordType.TYPE_ERROR, CIMClientWrapper.className, var5_5, var10_13);
                        throw (CIMException)var10_13;
                    }
                    break block33;
lbl67:
                    // 1 sources

                    if (var6_6 instanceof Enumeration) {
                        if (var4_4 != null) {
                            var4_4.traceSvcReturn("External CIM request", ((Enumeration)var6_6).hasMoreElements() != false ? "non-empty result" : "empty result");
                            return var14_14;
                        }
                        if (CIMClientWrapper.traceLogger.isLogging() == false) return var14_14;
                        CIMClientWrapper.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)CIMClientWrapper.className, var5_5, ((Enumeration)var6_6).hasMoreElements() != false ? "non-empty result" : "empty result");
                        return var14_14;
                    }
                    if (var4_4 != null) {
                        var4_4.traceSvcReturn("External CIM request", DiskMessageHelper.toMsgString(var6_6));
                        return var14_14;
                    }
                    if (CIMClientWrapper.traceLogger.isLogging() == false) return var14_14;
                    CIMClientWrapper.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)CIMClientWrapper.className, var5_5, DiskMessageHelper.toMsgString(var6_6));
                    return var14_14;
lbl80:
                    // 1 sources

                    if (var4_4 != null) {
                        var4_4.traceSvcReturn("External CIM request", var7_7 != null ? var7_7.toString() : null);
                        return var14_14;
                    }
                    if (CIMClientWrapper.traceLogger.isLogging() == false) return var14_14;
                    CIMClientWrapper.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)CIMClientWrapper.className, var5_5, var7_7 != null ? var7_7.toString() : null);
                    return var14_14;
                }
                if (var4_4 != null) {
                    var4_4.traceError("Internal error: DiskManagerExecException", var9_10);
                    throw new DiskManagerRTException(var9_10);
                }
                if (CIMClientWrapper.traceLogger.isLogging() == false) throw new DiskManagerRTException(var9_10);
                CIMClientWrapper.traceLogger.exception(IRecordType.TYPE_ERROR, CIMClientWrapper.className, var5_5, var9_10);
                throw new DiskManagerRTException(var9_10);
                catch (DiskManagerTimeoutException var9_11) {
                    if (var4_4 != null) {
                        var4_4.traceError("Timeout (" + var9_11.getMessage() + ") during CIM call " + var1_1 + "(" + DiskMessageHelper.toMsgString(var3_3) + ") to CIMOM " + this.getServiceURL(), var9_11);
                        throw var9_11;
                    }
                    if (CIMClientWrapper.traceLogger.isLogging() == false) throw var9_11;
                    CIMClientWrapper.traceLogger.text(IRecordType.TYPE_ERROR, CIMClientWrapper.className, var5_5, "Timeout (" + var9_11.getMessage() + ") during CIM call " + var1_1 + "(" + DiskMessageHelper.toMsgString(var3_3) + ") to CIMOM " + this.getServiceURL());
                    CIMClientWrapper.traceLogger.exception(IRecordType.TYPE_ERROR, CIMClientWrapper.className, var5_5, var9_11);
                    throw var9_11;
                }
            }
            catch (Throwable var13_18) {
                if (var6_6 != null) {
                    if (var6_6 instanceof Enumeration) {
                        if (var4_4 != null) {
                            var4_4.traceSvcReturn("External CIM request", ((Enumeration)var6_6).hasMoreElements() != false ? "non-empty result" : "empty result");
                            throw var13_18;
                        }
                        if (CIMClientWrapper.traceLogger.isLogging() == false) throw var13_18;
                        CIMClientWrapper.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)CIMClientWrapper.className, var5_5, ((Enumeration)var6_6).hasMoreElements() != false ? "non-empty result" : "empty result");
                        throw var13_18;
                    }
                    if (var4_4 != null) {
                        var4_4.traceSvcReturn("External CIM request", DiskMessageHelper.toMsgString(var6_6));
                        throw var13_18;
                    }
                    if (CIMClientWrapper.traceLogger.isLogging() == false) throw var13_18;
                    CIMClientWrapper.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)CIMClientWrapper.className, var5_5, DiskMessageHelper.toMsgString(var6_6));
                    throw var13_18;
                }
                if (var4_4 != null) {
                    var4_4.traceSvcReturn("External CIM request", var7_7 != null ? var7_7.toString() : null);
                    throw var13_18;
                }
                if (CIMClientWrapper.traceLogger.isLogging() == false) throw var13_18;
                CIMClientWrapper.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)CIMClientWrapper.className, var5_5, var7_7 != null ? var7_7.toString() : null);
                throw var13_18;
            }
        }
    }

    public Enumeration associatorNames(CIMObjectPath cIMObjectPath, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("associatorNames", new Class[]{CIMObjectPath.class}, new Object[]{cIMObjectPath}, logTraceHelper);
    }

    public Enumeration associatorNames(CIMObjectPath cIMObjectPath, String string, String string2, String string3, String string4) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("associatorNames", new Class[]{CIMObjectPath.class, String.class, String.class, String.class, String.class}, new Object[]{cIMObjectPath, string, string2, string3, string4}, null);
    }

    public Enumeration associatorNames(CIMObjectPath cIMObjectPath, String string, String string2, String string3, String string4, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("associatorNames", new Class[]{CIMObjectPath.class, String.class, String.class, String.class, String.class}, new Object[]{cIMObjectPath, string, string2, string3, string4}, logTraceHelper);
    }

    public Enumeration associators(CIMObjectPath cIMObjectPath, String string, String string2, String string3, String string4, boolean bl, boolean bl2, String[] stringArray) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("associators", new Class[]{CIMObjectPath.class, String.class, String.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE, String[].class}, new Object[]{cIMObjectPath, string, string2, string3, string4, new Boolean(bl), new Boolean(bl2), stringArray}, null);
    }

    public Enumeration associators(CIMObjectPath cIMObjectPath, String string, String string2, String string3, String string4, boolean bl, boolean bl2, String[] stringArray, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("associators", new Class[]{CIMObjectPath.class, String.class, String.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE, String[].class}, new Object[]{cIMObjectPath, string, string2, string3, string4, new Boolean(bl), new Boolean(bl2), stringArray}, logTraceHelper);
    }

    protected void closeConnection() throws CIMException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "closeConnection", null);
        try {
            logTraceHelper.traceHigh("ObjectID: " + this.getAddress() + " ThreadName: " + Thread.currentThread().getName());
            this.cCIMClnt.close();
        }
        finally {
            logTraceHelper.exit(null);
        }
    }

    public void close() throws CIMException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "close", null);
        try {
            logTraceHelper.traceHigh("ObjectID: " + this.getAddress() + " ThreadName: " + Thread.currentThread().getName());
            if (this.useCimPool) {
                CIMClientPool.returnClient(this);
            } else {
                this.closeConnection();
            }
        }
        finally {
            logTraceHelper.exit(null);
        }
    }

    protected boolean testConnection() {
        try {
            this.cCIMClnt.getClass(new CIMObjectPath("CIM_ManagedElement"));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public CIMObjectPath deleteInstance(CIMObjectPath cIMObjectPath, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (CIMObjectPath)this.executeSvcCall("deleteInstance", new Class[]{CIMObjectPath.class}, new Object[]{cIMObjectPath}, logTraceHelper);
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (CIMObjectPath)this.executeSvcCall("createInstance", new Class[]{CIMObjectPath.class, CIMInstance.class}, new Object[]{cIMObjectPath, cIMInstance}, logTraceHelper);
    }

    public Enumeration enumClass(CIMObjectPath cIMObjectPath, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumClass", new Class[]{CIMObjectPath.class}, new Object[]{cIMObjectPath}, logTraceHelper);
    }

    public Enumeration enumClass(CIMObjectPath cIMObjectPath, boolean bl, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumClass", new Class[]{CIMObjectPath.class, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl)}, logTraceHelper);
    }

    public Enumeration enumClass(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumClass", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl), new Boolean(bl2)}, logTraceHelper);
    }

    public Enumeration enumerateClasses(CIMObjectPath cIMObjectPath, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateClasses", new Class[]{CIMObjectPath.class}, new Object[]{cIMObjectPath}, logTraceHelper);
    }

    public Enumeration enumerateClasses(CIMObjectPath cIMObjectPath, boolean bl, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateClasses", new Class[]{CIMObjectPath.class, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl)}, logTraceHelper);
    }

    public Enumeration enumerateClasses(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateClasses", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl), new Boolean(bl2)}, logTraceHelper);
    }

    public Enumeration enumerateClasses(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateClasses", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl), new Boolean(bl2), new Boolean(bl3)}, logTraceHelper);
    }

    public Enumeration enumerateClasses(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateClasses", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl), new Boolean(bl2), new Boolean(bl3), new Boolean(bl4)}, null);
    }

    public Enumeration enumerateClasses(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, boolean bl4, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateClasses", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl), new Boolean(bl2), new Boolean(bl3), new Boolean(bl4)}, logTraceHelper);
    }

    public Enumeration enumerateClassNames(CIMObjectPath cIMObjectPath) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateClassNames", new Class[]{CIMObjectPath.class}, new Object[]{cIMObjectPath}, null);
    }

    public Enumeration enumerateClassNames(CIMObjectPath cIMObjectPath, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateClassNames", new Class[]{CIMObjectPath.class}, new Object[]{cIMObjectPath}, logTraceHelper);
    }

    public Enumeration enumerateClassNames(CIMObjectPath cIMObjectPath, boolean bl, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateClassNames", new Class[]{CIMObjectPath.class, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl)}, logTraceHelper);
    }

    public Enumeration enumerateInstanceNames(CIMObjectPath cIMObjectPath) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateInstanceNames", new Class[]{CIMObjectPath.class}, new Object[]{cIMObjectPath}, null);
    }

    public Enumeration enumerateInstanceNames(CIMObjectPath cIMObjectPath, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateInstanceNames", new Class[]{CIMObjectPath.class}, new Object[]{cIMObjectPath}, logTraceHelper);
    }

    public Enumeration enumerateInstances(CIMObjectPath cIMObjectPath) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateInstances", new Class[]{CIMObjectPath.class}, new Object[]{cIMObjectPath}, null);
    }

    public Enumeration enumerateInstances(CIMObjectPath cIMObjectPath, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateInstances", new Class[]{CIMObjectPath.class}, new Object[]{cIMObjectPath}, logTraceHelper);
    }

    public Enumeration enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateInstances", new Class[]{CIMObjectPath.class, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl)}, logTraceHelper);
    }

    public Enumeration enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateInstances", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl), new Boolean(bl2)}, null);
    }

    public Enumeration enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateInstances", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl), new Boolean(bl2)}, logTraceHelper);
    }

    public Enumeration enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateInstances", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl), new Boolean(bl2), new Boolean(bl3)}, logTraceHelper);
    }

    public Enumeration enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, boolean bl4, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateInstances", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl), new Boolean(bl2), new Boolean(bl3), new Boolean(bl4)}, logTraceHelper);
    }

    public Enumeration enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, boolean bl4, String[] stringArray, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateInstances", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, String[].class}, new Object[]{cIMObjectPath, new Boolean(bl), new Boolean(bl2), new Boolean(bl3), new Boolean(bl4), stringArray}, logTraceHelper);
    }

    public Enumeration enumInstances(CIMObjectPath cIMObjectPath, boolean bl, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumInstances", new Class[]{CIMObjectPath.class, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl)}, logTraceHelper);
    }

    public Enumeration enumInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumInstances", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl), new Boolean(bl2)}, logTraceHelper);
    }

    public Enumeration enumNameSpace(CIMObjectPath cIMObjectPath, boolean bl, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumNameSpace", new Class[]{CIMObjectPath.class, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl)}, logTraceHelper);
    }

    public Enumeration enumQualifierTypes(CIMObjectPath cIMObjectPath, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumQualifierTypes", new Class[]{CIMObjectPath.class}, new Object[]{cIMObjectPath}, logTraceHelper);
    }

    public boolean equals(Object object) {
        if (this.useCimPool) {
            return this.cCIMClnt.equals(object);
        }
        return super.equals(object);
    }

    public Enumeration execQuery(CIMObjectPath cIMObjectPath, String string, String string2, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("execQuery", new Class[]{CIMObjectPath.class, String.class, String.class}, new Object[]{cIMObjectPath, string2, string2}, logTraceHelper);
    }

    public CIMClass getClass(CIMObjectPath cIMObjectPath, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (CIMClass)this.executeSvcCall("getClass", new Class[]{CIMObjectPath.class}, new Object[]{cIMObjectPath}, logTraceHelper);
    }

    public CIMClass getClass(CIMObjectPath cIMObjectPath, boolean bl, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (CIMClass)this.executeSvcCall("getClass", new Class[]{CIMObjectPath.class, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl)}, logTraceHelper);
    }

    public CIMClass getClass(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (CIMClass)this.executeSvcCall("getClass", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl), new Boolean(bl2)}, logTraceHelper);
    }

    public CIMClass getClass(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (CIMClass)this.executeSvcCall("getClass", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl), new Boolean(bl2), new Boolean(bl3)}, logTraceHelper);
    }

    public CIMClass getClass(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (CIMClass)this.executeSvcCall("getClass", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, String[].class}, new Object[]{cIMObjectPath, new Boolean(bl), new Boolean(bl2), new Boolean(bl3), stringArray}, logTraceHelper);
    }

    public CIMInstance getIndicationHandler(CIMListener cIMListener, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (CIMInstance)this.executeSvcCall("getIndicationHandler", new Class[]{CIMListener.class}, new Object[]{cIMListener}, logTraceHelper);
    }

    public CIMInstance getIndicationListener(CIMListener cIMListener, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (CIMInstance)this.executeSvcCall("getIndicationListener", new Class[]{CIMListener.class}, new Object[]{cIMListener}, logTraceHelper);
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (CIMInstance)this.executeSvcCall("getInstance", new Class[]{CIMObjectPath.class}, new Object[]{cIMObjectPath}, logTraceHelper);
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl) throws CIMException, DiskManagerTimeoutException {
        return (CIMInstance)this.executeSvcCall("getInstance", new Class[]{CIMObjectPath.class, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl)}, null);
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (CIMInstance)this.executeSvcCall("getInstance", new Class[]{CIMObjectPath.class, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl)}, logTraceHelper);
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (CIMInstance)this.executeSvcCall("getInstance", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl), new Boolean(bl2)}, logTraceHelper);
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (CIMInstance)this.executeSvcCall("getInstance", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{cIMObjectPath, new Boolean(bl), new Boolean(bl2), new Boolean(bl3)}, logTraceHelper);
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (CIMInstance)this.executeSvcCall("getInstance", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, String[].class}, new Object[]{cIMObjectPath, new Boolean(bl), new Boolean(bl2), new Boolean(bl3), stringArray}, logTraceHelper);
    }

    public Locale getLocale() {
        return this.cCIMClnt.getLocale();
    }

    public CIMNameSpace getNameSpace() {
        return this.cCIMClnt.getNameSpace();
    }

    public CIMValue getProperty(CIMObjectPath cIMObjectPath, String string, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (CIMValue)this.executeSvcCall("getProperty", new Class[]{CIMObjectPath.class, String.class}, new Object[]{cIMObjectPath, string}, logTraceHelper);
    }

    public CIMQualifierType getQualifierType(CIMObjectPath cIMObjectPath, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (CIMQualifierType)this.executeSvcCall("getQualifierType", new Class[]{CIMObjectPath.class}, new Object[]{cIMObjectPath}, logTraceHelper);
    }

    public int hashCode() {
        if (this.useCimPool) {
            return this.cCIMClnt.hashCode();
        }
        return super.hashCode();
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (CIMValue)this.executeSvcCall("invokeMethod", new Class[]{CIMObjectPath.class, String.class, Vector.class, Vector.class}, new Object[]{cIMObjectPath, string, vector, vector2}, logTraceHelper);
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, CIMArgument[] cIMArgumentArray, CIMArgument[] cIMArgumentArray2, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (CIMValue)this.executeSvcCall("invokeMethod", new Class[]{CIMObjectPath.class, String.class, CIMArgument[].class, CIMArgument[].class}, new Object[]{cIMObjectPath, string, cIMArgumentArray, cIMArgumentArray2}, logTraceHelper);
    }

    public BatchResult performBatchOperations(BatchHandle batchHandle, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (BatchResult)this.executeSvcCall("performBatchOperations", new Class[]{BatchHandle.class}, new Object[]{batchHandle}, logTraceHelper);
    }

    public Enumeration referenceNames(CIMObjectPath cIMObjectPath) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("referenceNames", new Class[]{CIMObjectPath.class}, new Object[]{cIMObjectPath}, null);
    }

    public Enumeration referenceNames(CIMObjectPath cIMObjectPath, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("referenceNames", new Class[]{CIMObjectPath.class}, new Object[]{cIMObjectPath}, logTraceHelper);
    }

    public Enumeration referenceNames(CIMObjectPath cIMObjectPath, String string, String string2, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("referenceNames", new Class[]{CIMObjectPath.class, String.class, String.class}, new Object[]{cIMObjectPath, string, string2}, logTraceHelper);
    }

    public Enumeration references(CIMObjectPath cIMObjectPath, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("references", new Class[]{CIMObjectPath.class}, new Object[]{cIMObjectPath}, logTraceHelper);
    }

    public Enumeration references(CIMObjectPath cIMObjectPath, String string, String string2, boolean bl, boolean bl2, String[] stringArray) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("references", new Class[]{CIMObjectPath.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE, String[].class}, new Object[]{cIMObjectPath, string, string2, new Boolean(bl), new Boolean(bl2), stringArray}, null);
    }

    public Enumeration references(CIMObjectPath cIMObjectPath, String string, String string2, boolean bl, boolean bl2, String[] stringArray, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("references", new Class[]{CIMObjectPath.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE, String[].class}, new Object[]{cIMObjectPath, string, string2, new Boolean(bl), new Boolean(bl2), stringArray}, logTraceHelper);
    }

    public synchronized void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        this.executeSvcCall("setInstance", new Class[]{CIMObjectPath.class, CIMInstance.class}, new Object[]{cIMObjectPath, cIMInstance}, logTraceHelper);
    }

    public synchronized void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, boolean bl, String[] stringArray, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        this.executeSvcCall("setInstance", new Class[]{CIMObjectPath.class, CIMInstance.class, Boolean.TYPE, String[].class}, new Object[]{cIMObjectPath, cIMInstance, new Boolean(bl), stringArray}, logTraceHelper);
    }

    public void removeCIMListener(CIMListener cIMListener, LogTraceHelper logTraceHelper) throws CIMException, DiskManagerTimeoutException {
        this.executeSvcCall("removeCIMListener", new Class[]{CIMListener.class}, new Object[]{cIMListener}, logTraceHelper);
    }

    public String toString() {
        return this.getServiceURL();
    }

    public void useHttp11(boolean bl) {
        this.cCIMClnt.useHttp11(bl);
    }

    public void useMPost(boolean bl) {
        this.cCIMClnt.useMPost(bl);
    }

    public long getTimeout() {
        return this.cTimeout;
    }

    public void setTimeout(long l) {
        this.cTimeout = l;
    }

    public void setTimeout(String string, long l) {
        this.cMethodTimeouts.put(string, new Long(l));
    }

    private long getCfgTimeout() {
        return DiskManagerConfigSvc.getLongConfigValue("CIMClientWrapper.Timeout", 600000L);
    }

    public String getAddress() {
        return super.toString();
    }

    private final boolean isSynchronisationNeeded() {
        if (stSynchronizationEnabled == null) {
            stSynchronizationEnabled = new Boolean(DiskManagerConfigSvc.getBooleanConfigValue("CIMClientWrapper.ReqSync.Enabled", true));
        }
        if (!stSynchronizationEnabled.booleanValue()) {
            return false;
        }
        return !CIMOMManager.allowsConcurrentAccess(this.getServiceURL());
    }

    private final boolean isSaxParsingNeeded() {
        if (stSaxParsingEnabled == null) {
            stSaxParsingEnabled = new Boolean(DiskManagerConfigSvc.getBooleanConfigValue("CIMClientWrapper.SaxParsing.Enabled", true));
        }
        if (!stSaxParsingEnabled.booleanValue()) {
            return false;
        }
        return CIMOMManager.needsSaxParsing(this.getServiceURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object getLock() {
        Object object = stCIMOMLocks.get(this.getServiceURL());
        if (object == null) {
            Map map = stCIMOMLocks;
            synchronized (map) {
                object = stCIMOMLocks.get(this.getServiceURL());
                if (object == null) {
                    object = new Object();
                    stCIMOMLocks.put(this.getServiceURL(), object);
                }
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getServiceURL() {
        if (this.cServiceURL != null) {
            return this.cServiceURL;
        }
        Object object = this.cLock;
        synchronized (object) {
            if (this.cServiceURL == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.cCIMClnt.getNameSpace().getScheme()).append("://").append(this.cCIMClnt.getNameSpace().getHost());
                stringBuffer.append(":").append(this.cCIMClnt.getNameSpace().getPort());
                this.cServiceURL = stringBuffer.toString();
            }
        }
        return this.cServiceURL;
    }
}

