/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.common.api.CimomAndDeviceStatus;
import org.eclipse.aperi.common.api.DeviceStatus;
import org.eclipse.aperi.common.api.ICIMOMMgmtService;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.RemoteException;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.common.identifier.ConversionUtil;
import org.eclipse.aperi.common.identifier.SubsystemId;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.CIM.CIMClientPool;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.ParameterChecker;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerExecException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerRTException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.common.util.thread.DiskThreadManager;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyHost;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyPort;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySubsystem;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySwitch;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyTapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyVolume;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespace;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.SlpAttributes;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.database.objects.TapeFrame;
import org.eclipse.aperi.infrastructure.database.objects.Vendor;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyHostTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySwitchTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyTapeLibraryTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimom2namespaceTable;
import org.eclipse.aperi.infrastructure.database.tables.TResElementProbeStatusTable;
import org.eclipse.aperi.infrastructure.database.tables.TResRegisteredCimomTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResSwitchTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeLibraryTable;
import org.eclipse.aperi.infrastructure.history.detectability.ChangeDetection;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.util.SRMCrypto;
import org.sblim.wbem.cim.CIMAuthenticationException;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMSecurityException;
import org.sblim.wbem.cim.CIMTransportException;

public final class CIMOMManager
implements ICIMOMMgmtService {
    private static CIMOMManager cCimomMgr = new CIMOMManager();
    private static int cUniqueInt = 0;
    private static Map stSaxParsing = Collections.synchronizedMap(new HashMap());
    private static final Map stParsDevTypeDef = CIMOMManager.getDefinitionForSync("CIMClientWrapper.SaxParsing.SubsystemTypes");
    private static final Map stParsVendorDef = CIMOMManager.getDefinitionForSync("CIMClientWrapper.SaxParsing.Vendors");
    private static final Map stParsNSpcDef = CIMOMManager.getDefinitionForSync("CIMClientWrapper.SaxParsing.NameSpaces");
    private static Map stConcurrentAccess = Collections.synchronizedMap(new HashMap());
    private static final String DEVICE_TYPE_UNKNOWN = "type_unknown";
    private static final String VENDOR_UNKNOWN = "vendor_unknown";
    private static final Map stDevTypeDef = CIMOMManager.getDefinitionForSync("CIMClientWrapper.ReqSync.SubsystemTypes");
    private static final Map stVendorDef = CIMOMManager.getDefinitionForSync("CIMClientWrapper.ReqSync.Vendors");
    private static final Map stNSpcDef = CIMOMManager.getDefinitionForSync("CIMClientWrapper.ReqSync.NameSpaces");
    private static Map stUsedCIMOMs = Collections.synchronizedMap(new HashMap());
    private static Set stPendingCIMOMDeletions = Collections.synchronizedSet(new HashSet());
    private static final short UNIQUENUMBERLENGTHDEFAULT = 7;
    private static final String SLPDISCOVERYPROCESS_PARAMETER_DA = "DA";
    private static final String SLPDISCOVERYPROCESS_PARAMETER_DA_LOCAL = "local";
    private static final String SLPDISCOVERYPROCESS_PARAMETER_SCOPE = "SCOPE";
    private static final String SLPDISCOVERYPROCESS_PARAMETER_SCOPE_DEFAULT = "default";
    private static final String DBATTRIBUTEMAPPER = "DBAttributeMapper";
    private static final String DBATTRIBUTEMAPPER_SLP = "SLP";
    private static final String DBATTRIBUTEMAPPER_SLP_SCANID = "DummyScanID";
    private static final String TESTCONNECTIONTIMEOUT_NAME = "TESTCONNECTIONTIMEOUT";
    private static final int CIMOM_CHECK_OK = 0;
    private static final int CIMOM_CHECK_DUP = 1;
    private static final int CIMOM_CHECK_RES_ERR = 2;
    private static final int CIMOM_CHECK_URL_ERR = 3;
    private static final String PROCESSID_PREFIX = "S";
    public static final int DEVICE_UNKNOWN_UNCONFIGURED = -1;

    private CIMOMManager() {
    }

    public static CIMOMManager getCIMOMManager() {
        return cCimomMgr;
    }

    public AsyncResult discoverCIMOMs(String[] stringArray, Boolean bl) throws ServerException {
        return this.discoverCIMOMs(stringArray, (boolean)bl);
    }

    public AsyncResult discoverCIMOMs(String[] stringArray, boolean bl) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "discoverCIMOMs", new Object[]{stringArray, new Boolean(bl)});
        AsyncResult asyncResult = new AsyncResult(-1);
        try {
            Object object;
            Object object2;
            if (!bl) {
                try {
                    ParameterChecker.assertMandatoryParameter(1, "pDAs", stringArray, logTraceHelper);
                }
                catch (MissingParameterException missingParameterException) {
                    throw DiskMessageHelper.getServerException("HWN020002E", (Object)missingParameterException.getMessage(), missingParameterException, logTraceHelper);
                }
            }
            if ((object2 = Activator._serviceHelper.bindLocal("DiscoverService")) == null) {
                throw DiskMessageHelper.getServerException("HWN021807E", null, logTraceHelper);
            }
            IDiscover iDiscover = (IDiscover)object2;
            Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
            hashtable.put(SLPDISCOVERYPROCESS_PARAMETER_SCOPE, new String[]{SLPDISCOVERYPROCESS_PARAMETER_SCOPE_DEFAULT});
            if (!bl) {
                hashtable.put(SLPDISCOVERYPROCESS_PARAMETER_DA, stringArray);
            } else {
                logTraceHelper.traceInfo("local discovery was requested, add 'local' to DA array");
                object = null;
                int n = 0;
                if (stringArray != null) {
                    n = stringArray.length;
                    object = new String[n + 1];
                    int n2 = 0;
                    while (n2 < n) {
                        object[n2] = stringArray[n2];
                        ++n2;
                    }
                } else {
                    n = 0;
                    object = new String[n + 1];
                }
                object[n] = SLPDISCOVERYPROCESS_PARAMETER_DA_LOCAL;
                hashtable.put(SLPDISCOVERYPROCESS_PARAMETER_DA, (String[])object);
            }
            logTraceHelper.traceSvcEntry("Discover.slpDiscover", new Object[]{hashtable});
            object = iDiscover.discover("SLPDiscover", hashtable);
            asyncResult = iDiscover.getJobStatus((String)object);
            logTraceHelper.traceSvcReturn("Discover.slpDiscover jobid=" + (String)object, asyncResult.toString());
        }
        finally {
            logTraceHelper.exit(asyncResult);
        }
        return asyncResult;
    }

    public CIMOM[] getCIMOMs() throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "getCIMOMs", null);
        CIMOM[] cIMOMArray = null;
        try {
            cIMOMArray = this.getCIMOMs(null);
        }
        finally {
            logTraceHelper.exit(cIMOMArray);
        }
        return cIMOMArray;
    }

    public CIMOM[] getCIMOMsWithoutPW() throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "getCIMOMsWithoutPW", null);
        CIMOM[] cIMOMArray = null;
        try {
            cIMOMArray = this.getCIMOMs(null);
            int n = 0;
            while (n < cIMOMArray.length) {
                cIMOMArray[n].setPassword(null);
                ++n;
            }
        }
        finally {
            logTraceHelper.exit(cIMOMArray);
        }
        return cIMOMArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMOM[] getCIMOMs(String[] stringArray) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "getCIMOMs", stringArray);
        Object[] objectArray = new CIMOM[]{};
        try {
            DBConnection dBConnection = ServiceUtils.getConnection();
            if (dBConnection == null) {
                throw DiskMessageHelper.getServerException("HWN021800E", null, logTraceHelper);
            }
            RegisteredCimom.RegisteredCimomCursor registeredCimomCursor = null;
            Vector<String> vector = new Vector<String>();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    vector.add(stringArray[n]);
                    ++n;
                }
            }
            Vector<CIMOM> vector2 = new Vector<CIMOM>();
            try {
                try {
                    registeredCimomCursor = RegisteredCimom.getCursor(dBConnection, null, null);
                    if (registeredCimomCursor == null) {
                        throw DiskMessageHelper.getServerException("HWN021801E", null, logTraceHelper);
                    }
                    while (registeredCimomCursor.next()) {
                        RegisteredCimom registeredCimom = registeredCimomCursor.getObject();
                        if (registeredCimom == null) {
                            throw DiskMessageHelper.getServerException("HWN021801E", null, logTraceHelper);
                        }
                        String string = registeredCimom.getServiceUrl();
                        if (vector.size() != 0 && !vector.contains(string) || registeredCimom.getStatus() == CIMOMConnectionStatus.PENDING_DELETION.toID()) continue;
                        CIMOM cIMOM = this.createCIMOMObject(registeredCimom, dBConnection, logTraceHelper);
                        vector2.add(cIMOM);
                    }
                }
                catch (SQLException sQLException) {
                    logTraceHelper.traceError("Getting CIMOMs failed due to " + sQLException.getMessage(), sQLException);
                    throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
                }
            }
            finally {
                try {
                    if (registeredCimomCursor != null) {
                        registeredCimomCursor.close();
                    }
                    dBConnection.close();
                }
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
                }
            }
            objectArray = new CIMOM[vector2.size()];
            vector2.copyInto(objectArray);
            return objectArray;
        }
        finally {
            logTraceHelper.exit(objectArray);
        }
    }

    public CIMOM getCIMMOMByDBKey(int n) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "getCIMMOMByDBKey", new Object[]{String.valueOf(n)});
        CIMOM cIMOM = null;
        try {
            DBConnection dBConnection = ServiceUtils.getConnection();
            DBCursor dBCursor = null;
            if (dBConnection == null) {
                throw DiskMessageHelper.getServerException("HWN021800E", null, logTraceHelper);
            }
            try {
                try {
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(TResRegisteredCimomTable.getColumnInfo("REG_CIMOM_ID"), Integer.toString(n));
                    dBCursor = RegisteredCimom.getCursor(dBConnection, hashtable, null);
                    if (dBCursor == null) {
                        throw DiskMessageHelper.getServerException("HWN021801E", null, logTraceHelper);
                    }
                    if (dBCursor.next()) {
                        RegisteredCimom registeredCimom = ((RegisteredCimom.RegisteredCimomCursor)dBCursor).getObject();
                        if (registeredCimom == null || registeredCimom.getStatus() == CIMOMConnectionStatus.PENDING_DELETION.toID()) {
                            throw DiskMessageHelper.getServerException("HWN021801E", null, logTraceHelper);
                        }
                        cIMOM = this.createCIMOMObject(registeredCimom, dBConnection, logTraceHelper);
                    }
                }
                catch (SQLException sQLException) {
                    logTraceHelper.traceError("Getting CIMOMs failed due to " + sQLException.getMessage(), sQLException);
                    throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
                }
            }
            finally {
                try {
                    if (dBCursor != null) {
                        dBCursor.close();
                    }
                    dBConnection.close();
                }
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
                }
            }
        }
        finally {
            logTraceHelper.exit(null);
        }
        return cIMOM;
    }

    private CIMOM createCIMOMObject(RegisteredCimom registeredCimom, DBConnection dBConnection, LogTraceHelper logTraceHelper) throws SQLException, ServerException {
        Object object;
        SlpAttributes.SlpAttributesCursor slpAttributesCursor = null;
        String string = registeredCimom.getServiceUrl();
        CIMOM cIMOM = new CIMOM();
        cIMOM.setServiceUrl(string);
        cIMOM.setHiName(registeredCimom.getHiName());
        cIMOM.setDescription(registeredCimom.getDescription());
        cIMOM.setSoftwareLevel(registeredCimom.getSoftwareLevel());
        cIMOM.setProtocolVersion(registeredCimom.getProtocolVersion());
        cIMOM.setAuthenticationMechanism(registeredCimom.getAuthenticationMechanism());
        cIMOM.setUserId(registeredCimom.getUserId());
        cIMOM.setServiceId(String.valueOf(registeredCimom.getRegCimomId()));
        String string2 = registeredCimom.getPassword();
        if (string2 != null) {
            try {
                cIMOM.setPassword(SRMCrypto.decrypt(string2));
            }
            catch (Exception exception) {
                logTraceHelper.traceError("Failed to decrypt password " + string2 + " for CIMOM " + string + "due to " + exception.getMessage(), exception);
            }
        }
        cIMOM.setTrustStoreLocation(registeredCimom.getTrustStoreLocation());
        cIMOM.setTrustStorePassphrase(registeredCimom.getTrustStorePassphrase());
        cIMOM.setInteropSchemaNamespace(registeredCimom.getInteropSchemaNamespace());
        cIMOM.setProtocol(registeredCimom.getProtocol());
        cIMOM.setDisplayName(registeredCimom.getDisplayName());
        cIMOM.setStatus(CIMOMConnectionStatus.getStatus(registeredCimom.getStatus()));
        Timestamp timestamp = registeredCimom.getStatusTimestamp();
        if (timestamp != null) {
            object = Calendar.getInstance();
            ((Calendar)object).setTime(timestamp);
            cIMOM.setStatusTimestamp((Calendar)object);
        }
        try {
            try {
                slpAttributesCursor = SlpAttributes.getCursor(dBConnection, null, null);
                if (slpAttributesCursor == null) {
                    throw DiskMessageHelper.getServerException("HWN021804E", string, logTraceHelper);
                }
                object = new String();
                while (slpAttributesCursor.next()) {
                    SlpAttributes slpAttributes = slpAttributesCursor.getObject();
                    if (slpAttributes == null) {
                        throw DiskMessageHelper.getServerException("HWN021804E", string, logTraceHelper);
                    }
                    if (slpAttributes.getRegCimomId() != registeredCimom.getRegCimomId()) continue;
                    object = String.valueOf(object) + slpAttributes.getAttributeName() + ":" + slpAttributes.getValue();
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Getting CIMOMs failed due to " + sQLException.getMessage(), sQLException);
                throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
            }
        }
        finally {
            try {
                if (slpAttributesCursor != null) {
                    slpAttributesCursor.close();
                }
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
            }
        }
        return cIMOM;
    }

    public void modifyCIMOMs(CIMOM[] cIMOMArray) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "modifyCIMOMs", new Object[]{cIMOMArray});
        String[] stringArray = null;
        try {
            stringArray = this.persistCIMOMs(cIMOMArray, true, logTraceHelper);
        }
        finally {
            logTraceHelper.exit(stringArray);
        }
    }

    public String[] addCIMOMs(CIMOM[] cIMOMArray) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "addCIMOMs", new Object[]{cIMOMArray});
        String[] stringArray = null;
        try {
            stringArray = this.persistCIMOMs(cIMOMArray, false, logTraceHelper);
        }
        finally {
            logTraceHelper.exit(stringArray);
        }
        return stringArray;
    }

    /*
     * Unable to fully structure code
     */
    private String[] persistCIMOMs(CIMOM[] var1_1, boolean var2_2, LogTraceHelper var3_3) throws ServerException {
        try {
            ParameterChecker.assertMandatoryParameter(1, "pCimoms", var1_1, var3_3);
        }
        catch (MissingParameterException var4_4) {
            throw DiskMessageHelper.getServerException("HWN020002E", var4_4.getMessage(), var3_3);
        }
        var4_5 = ServiceUtils.getConnection();
        if (var4_5 == null) {
            throw DiskMessageHelper.getServerException("HWN021800E", null, var3_3);
        }
        var5_6 = var2_2 != false ? null : this.checkForDuplicateCIMOMs(var1_1, var4_5);
        var6_7 = var1_1.length;
        var7_8 = new String[var6_7];
        var8_9 = new Hashtable[var6_7];
        var9_10 = 0;
        while (var9_10 < var6_7) {
            var8_9[var9_10] = this.extractAttributes(var1_1[var9_10]);
            ++var9_10;
        }
        var9_10 = 0;
        try {
            try {
                var9_10 = 0;
                while (var9_10 < var6_7) {
                    if (var2_2) ** GOTO lbl31
                    if (var5_6[var9_10] == 1) {
                        var7_8[var9_10] = var1_1[var9_10].getServiceUrl();
                    } else {
                        if (var5_6[var9_10] == 2) {
                            var4_5.rollback();
                            var7_8[var9_10] = null;
                            throw DiskMessageHelper.getServerException("HWN021809E", var1_1[var9_10].getServiceUrl(), var3_3);
                        }
lbl31:
                        // 3 sources

                        if ((var10_11 = MapperRouter.getMapperRouter().findMapper("SLP", null, null, null)) == null) {
                            throw DiskMessageHelper.getServerException("HWN021805E", "DBAttributeMapper", var3_3);
                        }
                        var11_13 = null;
                        var11_13 = var10_11.persist(var4_5, var8_9[var9_10], "DummyScanID");
                        if (var11_13 != null) {
                            var7_8[var9_10] = var1_1[var9_10].getServiceUrl();
                            var3_3.traceInfo("Database entity for " + var1_1[var9_10].getServiceUrl() + " was added");
                            var4_5.commit();
                            var12_15 = RegisteredCimom.getColumnInfo("REG_CIMOM_ID");
                            v0 = var13_16 = var2_2 != false ? (Hashtable)var11_13.getUpdatedRows().get(RegisteredCimom.getTablename()) : (Hashtable)var11_13.getInsertedRows().get(RegisteredCimom.getTablename());
                            if (var13_16 != null) {
                                var14_17 = (String)var13_16.get(var12_15);
                                if (var2_2) {
                                    ServiceUtils.getEventMonitorProxy().handleDevicePropertyChange("S" + CIMOMManager.getUniqueNumberString(), RegisteredCimom.getTablename(), var14_17, null, null);
                                } else {
                                    ServiceUtils.getEventMonitorProxy().handleNewDevice("S" + CIMOMManager.getUniqueNumberString(), RegisteredCimom.getTablename(), var14_17);
                                }
                            }
                        } else {
                            var4_5.rollback();
                            var7_8[var9_10] = null;
                            throw DiskMessageHelper.getServerException("HWN021806E", "DBAttributeMapper", var3_3);
                        }
                    }
                    ++var9_10;
                }
            }
            catch (SQLException var10_12) {
                var7_8[var9_10] = null;
                var3_3.traceError("Database entity for " + var1_1[var9_10].getServiceUrl() + " was not added because of " + var10_12.getMessage(), var10_12);
                try {
                    var4_5.rollback();
                    throw DiskMessageHelper.getServerException("HWN021802E", (Object)var10_12.getMessage(), var10_12, var3_3);
                }
                catch (SQLException var11_14) {
                    throw DiskMessageHelper.getServerException("HWN021802E", (Object)var11_14.getMessage(), var11_14, var3_3);
                }
            }
        }
        finally {
            try {
                var4_5.close();
            }
            catch (SQLException var16_20) {
                throw DiskMessageHelper.getServerException("HWN021802E", (Object)var16_20.getMessage(), var16_20, var3_3);
            }
        }
        return var7_8;
    }

    private Hashtable extractAttributes(CIMOM cIMOM) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "extractAttributes", new Object[]{cIMOM});
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            if (cIMOM.getServiceUrl() != null) {
                hashtable.put("template-url-syntax", cIMOM.getServiceUrl());
            }
            if (cIMOM.getHiName() != null) {
                hashtable.put("service-hi-name", cIMOM.getHiName());
            }
            if (cIMOM.getDescription() != null) {
                hashtable.put("service-hi-description", cIMOM.getDescription());
            }
            if (cIMOM.getProtocolVersion() != null) {
                hashtable.put("protocolversion", cIMOM.getProtocolVersion());
            }
            if (cIMOM.getInteropSchemaNamespace() != null) {
                hashtable.put("interopschemanamespace", cIMOM.getInteropSchemaNamespace());
            }
            if (cIMOM.getSoftwareLevel() != null) {
                hashtable.put("software_level", cIMOM.getSoftwareLevel());
            }
            if (cIMOM.getAuthenticationMechanism() != null) {
                hashtable.put("authentication_mechanism", cIMOM.getAuthenticationMechanism());
            }
            if (cIMOM.getUserId() != null) {
                hashtable.put("user_id", cIMOM.getUserId());
            }
            if (cIMOM.getPassword() != null) {
                try {
                    String string = SRMCrypto.encrypt(cIMOM.getPassword());
                    hashtable.put("password", string);
                }
                catch (Exception exception) {
                    logTraceHelper.traceError("Failed to encrypt password due to " + exception.getMessage(), exception);
                }
            }
            if (cIMOM.getTrustStoreLocation() != null) {
                hashtable.put("trust_store_location", cIMOM.getTrustStoreLocation());
            }
            if (cIMOM.getTrustStorePassphrase() != null) {
                hashtable.put("trust_store_passphrase", cIMOM.getTrustStorePassphrase());
            }
            if (cIMOM.getDisplayName() != null) {
                hashtable.put("display_name", cIMOM.getDisplayName());
            }
            if (cIMOM.getSlpAttributes() != null) {
                hashtable.put("slp_attributes", cIMOM.getSlpAttributes());
            }
            if (cIMOM.getProtocol() != null) {
                hashtable.put("protocol", cIMOM.getProtocol());
            }
            if (cIMOM.getStatus() != null) {
                hashtable.put("status", Short.toString(cIMOM.getStatus().toID()));
            }
        }
        finally {
            logTraceHelper.exit(hashtable);
        }
        return hashtable;
    }

    private Boolean persistCIMOMStatus(CIMOM cIMOM) throws ServerException {
        Boolean bl;
        block24: {
            LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "persistCIMOMStatus", new Object[]{cIMOM});
            bl = Boolean.FALSE;
            try {
                try {
                    ParameterChecker.assertMandatoryParameter(1, "pCimom", cIMOM, logTraceHelper);
                }
                catch (MissingParameterException missingParameterException) {
                    throw DiskMessageHelper.getServerException("HWN020002E", (Object)missingParameterException.getMessage(), missingParameterException, logTraceHelper);
                }
                DBConnection dBConnection = ServiceUtils.getConnection();
                if (dBConnection == null) {
                    throw DiskMessageHelper.getServerException("HWN021800E", null, logTraceHelper);
                }
                CIMOMConnectionStatus cIMOMConnectionStatus = cIMOM.getStatus();
                String string = cIMOM.getServiceUrl();
                if (cIMOMConnectionStatus == null || string == null) break block24;
                short s = this.getCIMOMStatusInDB(string);
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("template-url-syntax", string);
                hashtable.put("status", Short.toString(cIMOMConnectionStatus.toID()));
                IDBAttributeMapper iDBAttributeMapper = MapperRouter.getMapperRouter().findMapper(DBATTRIBUTEMAPPER_SLP, null, null, null);
                if (iDBAttributeMapper == null) {
                    throw DiskMessageHelper.getServerException("HWN021805E", DBATTRIBUTEMAPPER, logTraceHelper);
                }
                try {
                    try {
                        MapperResult mapperResult = iDBAttributeMapper.persist(dBConnection, hashtable, DBATTRIBUTEMAPPER_SLP_SCANID);
                        if (mapperResult != null) {
                            bl = Boolean.TRUE;
                            logTraceHelper.traceInfo("Status for " + cIMOM.getServiceUrl() + " was updated");
                            dBConnection.commit();
                            ColumnInfo columnInfo = RegisteredCimom.getColumnInfo("REG_CIMOM_ID");
                            Hashtable hashtable2 = (Hashtable)mapperResult.getUpdatedRows().get(RegisteredCimom.getTablename());
                            if (hashtable2 != null && cIMOMConnectionStatus != CIMOMConnectionStatus.TIMEOUT && s != cIMOMConnectionStatus.toID()) {
                                int n;
                                int n2;
                                String string2 = (String)hashtable2.get(columnInfo);
                                if (cIMOMConnectionStatus == CIMOMConnectionStatus.SUCCESS) {
                                    n2 = 0;
                                    n = 1;
                                } else {
                                    n2 = 1;
                                    n = 0;
                                }
                                ServiceUtils.getEventMonitorProxy().handleDeviceStateChange(PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString(), RegisteredCimom.getTablename(), string2, n2, n);
                            }
                            break block24;
                        }
                        bl = Boolean.FALSE;
                        logTraceHelper.traceError("Status for " + cIMOM.getServiceUrl() + " was not updated (no mapper result retrieved)", null);
                        dBConnection.rollback();
                        throw DiskMessageHelper.getServerException("HWN021806E", DBATTRIBUTEMAPPER, logTraceHelper);
                    }
                    catch (SQLException sQLException) {
                        bl = Boolean.FALSE;
                        logTraceHelper.traceError("Status for " + cIMOM.getServiceUrl() + " was not updated due to " + sQLException.getMessage(), sQLException);
                        try {
                            dBConnection.rollback();
                        }
                        catch (SQLException sQLException2) {
                            throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException2.getMessage(), sQLException2, logTraceHelper);
                        }
                    }
                }
                finally {
                    try {
                        dBConnection.close();
                    }
                    catch (SQLException sQLException) {
                        throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
                    }
                }
            }
            finally {
                logTraceHelper.exit(bl);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCIMOMs(String[] stringArray) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "deleteCIMOMs", new Object[]{stringArray});
        try {
            try {
                ParameterChecker.assertMandatoryParameter(1, "pCimomURLs", stringArray, logTraceHelper);
            }
            catch (MissingParameterException missingParameterException) {
                throw DiskMessageHelper.getServerException("HWN020002E", (Object)missingParameterException.getMessage(), missingParameterException, logTraceHelper);
            }
            new HashSet();
            int n = 0;
            while (n < stringArray.length) {
                try {
                    boolean bl = false;
                    Map map = stUsedCIMOMs;
                    synchronized (map) {
                        if (!stUsedCIMOMs.containsKey(stringArray[n])) {
                            try {
                                this.processPendingCIMOMDeletion(stringArray[n]);
                            }
                            catch (Throwable throwable) {
                                bl = true;
                                stPendingCIMOMDeletions.add(stringArray[n]);
                            }
                        } else {
                            bl = true;
                            stPendingCIMOMDeletions.add(stringArray[n]);
                        }
                    }
                    if (bl) {
                        this.flagPendingCIMOMDeletion(stringArray[n]);
                    }
                }
                catch (Throwable throwable) {
                    logTraceHelper.traceError("Not able to delete CIMOM " + stringArray[n] + "because of :" + throwable.getMessage(), throwable);
                }
                ++n;
            }
            this.cleanupPendingCIMOMDeletions();
        }
        finally {
            logTraceHelper.exit("null");
        }
    }

    private short getCIMOMStatusInDB(String string) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "getDBCIMOMStatus", new Object[]{string});
        short s = CIMOMConnectionStatus.UNKNOWN.toID();
        DBConnection dBConnection = null;
        try {
            try {
                dBConnection = ServiceUtils.getConnection();
                if (dBConnection == null) {
                    throw DiskMessageHelper.getServerException("HWN021800E", null, logTraceHelper);
                }
                RegisteredCimom registeredCimom = new RegisteredCimom();
                registeredCimom.setServiceUrl(string);
                if (registeredCimom.retrieve(dBConnection)) {
                    s = registeredCimom.getStatus();
                    logTraceHelper.traceInfo("CIMOM " + string + " has persisted status with value of " + s);
                } else {
                    logTraceHelper.traceInfo("No Database entity for CIMOM " + string + ". Nothing to do.");
                }
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            if (dBConnection != null) {
                try {
                    dBConnection.close();
                }
                catch (Exception exception) {}
            }
            logTraceHelper.exit(new Short(s));
            throw throwable;
        }
        if (dBConnection != null) {
            try {
                dBConnection.close();
            }
            catch (Exception exception) {}
        }
        logTraceHelper.exit(new Short(s));
        return s;
    }

    private void flagPendingCIMOMDeletion(String string) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "flagPendingCIMOMDeletion", new Object[]{string});
        DBConnection dBConnection = null;
        try {
            try {
                stPendingCIMOMDeletions.add(string);
                dBConnection = ServiceUtils.getConnection();
                if (dBConnection == null) {
                    throw DiskMessageHelper.getServerException("HWN021800E", null, logTraceHelper);
                }
                RegisteredCimom registeredCimom = new RegisteredCimom();
                registeredCimom.setServiceUrl(string);
                if (registeredCimom.retrieve(dBConnection)) {
                    registeredCimom = new RegisteredCimom();
                    registeredCimom.setServiceUrl(string);
                    registeredCimom.setStatus(CIMOMConnectionStatus.PENDING_DELETION.toID());
                    registeredCimom.setStatusTimestamp(new Timestamp(System.currentTimeMillis()));
                    registeredCimom.update(dBConnection);
                    dBConnection.commit();
                    logTraceHelper.traceInfo("CIMOM " + string + " are set to PENDING_DELETION");
                } else {
                    logTraceHelper.traceInfo("No Database entity for CIMOM " + string + ". Nothing to do.");
                }
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            if (dBConnection != null) {
                try {
                    dBConnection.close();
                }
                catch (Exception exception) {}
            }
            logTraceHelper.exit("null");
            throw throwable;
        }
        if (dBConnection != null) {
            try {
                dBConnection.close();
            }
            catch (Exception exception) {}
        }
        logTraceHelper.exit("null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupPendingCIMOMDeletions() {
        block37: {
            DBCursor dBCursor;
            DBConnection dBConnection;
            LogTraceHelper logTraceHelper;
            block34: {
                block35: {
                    logTraceHelper = LogTraceHelper.entry(this, "processPendingCIMOMDeletion", null);
                    dBConnection = null;
                    dBCursor = null;
                    dBConnection = ServiceUtils.getConnection();
                    if (dBConnection != null) break block34;
                    if (dBCursor == null) break block35;
                    try {
                        dBCursor.close();
                    }
                    catch (Exception exception) {}
                }
                if (dBConnection != null) {
                    try {
                        dBConnection.close();
                    }
                    catch (Exception exception) {}
                }
                logTraceHelper.exit("null");
                return;
            }
            try {
                try {
                    Object object;
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(TResRegisteredCimomTable.getColumnInfo("STATUS"), Short.toString(CIMOMConnectionStatus.PENDING_DELETION.toID()));
                    dBCursor = RegisteredCimom.getCursor(dBConnection, hashtable, null);
                    while (dBCursor.next()) {
                        object = ((RegisteredCimom.RegisteredCimomCursor)dBCursor).getObject().getServiceUrl();
                        stPendingCIMOMDeletions.add(object);
                    }
                    dBCursor.close();
                    dBCursor = null;
                    dBConnection.commit();
                    object = new HashSet(stPendingCIMOMDeletions);
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        Map map = stUsedCIMOMs;
                        synchronized (map) {
                            if (!stUsedCIMOMs.containsKey(string)) {
                                this.processPendingCIMOMDeletion(string);
                            }
                        }
                    }
                }
                catch (SQLException sQLException) {
                    logTraceHelper.traceError(sQLException.getMessage(), sQLException);
                }
            }
            catch (Throwable throwable) {
                if (dBCursor != null) {
                    try {
                        dBCursor.close();
                    }
                    catch (Exception exception) {}
                }
                if (dBConnection != null) {
                    try {
                        dBConnection.close();
                    }
                    catch (Exception exception) {}
                }
                logTraceHelper.exit("null");
                throw throwable;
            }
            if (dBCursor != null) {
                try {
                    dBCursor.close();
                }
                catch (Exception exception) {}
            }
            if (dBConnection != null) {
                try {
                    dBConnection.close();
                }
                catch (Exception exception) {}
            }
            logTraceHelper.exit("null");
            break block37;
            if (dBCursor != null) {
                try {
                    dBCursor.close();
                }
                catch (Exception exception) {}
            }
            if (dBConnection != null) {
                try {
                    dBConnection.close();
                }
                catch (Exception exception) {}
            }
            logTraceHelper.exit("null");
        }
    }

    private void processPendingCIMOMDeletion(String string) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "processPendingCIMOMDeletion", new Object[]{string});
        try {
            try {
                ParameterChecker.assertMandatoryParameter(1, "pCimomURLs", string, logTraceHelper);
            }
            catch (MissingParameterException missingParameterException) {
                throw DiskMessageHelper.getServerException("HWN020002E", (Object)missingParameterException.getMessage(), missingParameterException, logTraceHelper);
            }
            try {
                DBConnection dBConnection = ServiceUtils.getConnection();
                if (dBConnection == null) {
                    throw DiskMessageHelper.getServerException("HWN021800E", null, logTraceHelper);
                }
                try {
                    try {
                        RegisteredCimom registeredCimom = new RegisteredCimom();
                        registeredCimom.setServiceUrl(string);
                        if (registeredCimom.retrieve(dBConnection)) {
                            ServiceUtils.getEventMonitorProxy().handleDeviceStateChange(PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString(), RegisteredCimom.getTablename(), new Integer(registeredCimom.getRegCimomId()).toString(), 1, 0);
                            int n = this.deleteNamespacesOfCimom(dBConnection, Integer.toString(registeredCimom.getRegCimomId()));
                            logTraceHelper.traceInfo("Related entities (namespaces and cimkeys) for CIMOM " + string + " deleted (" + Integer.toString(n) + " rows).");
                            if (registeredCimom.delete(dBConnection) > 0) {
                                logTraceHelper.traceInfo("Database entity for CIMOM " + string + " deleted");
                            } else {
                                logTraceHelper.traceWarning("Logic error. CIMOM entity was found on retrieve but not on delete.");
                            }
                            int[] nArray = this.markDevicesAsMissing(dBConnection);
                            logTraceHelper.traceInfo("Marked " + Integer.toString(nArray[0]) + " subsystems, " + Integer.toString(nArray[1]) + " tape libraries and " + Integer.toString(nArray[2]) + " switches as missing.");
                        } else {
                            logTraceHelper.traceInfo("No Database entity for CIMOM " + string + ". Nothing to do.");
                        }
                        dBConnection.commit();
                        stPendingCIMOMDeletions.remove(string);
                        stConcurrentAccess.remove(string);
                        logTraceHelper.traceInfo("CIMOM " + string + " deleted.");
                    }
                    catch (Exception exception) {
                        logTraceHelper.traceError("Failed to delete database entity for CIMOM" + string + ".Rolling back", exception);
                        dBConnection.rollback();
                        throw exception;
                    }
                }
                finally {
                    dBConnection.close();
                }
            }
            catch (Exception exception) {
                throw DiskMessageHelper.getServerException("HWN021802E", (Object)exception.getMessage(), exception, logTraceHelper);
            }
        }
        finally {
            logTraceHelper.exit(null);
        }
    }

    private int deleteNamespacesOfCimom(DBConnection dBConnection, String string) throws SQLException {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>(2);
        hashtable.put(TResCimom2namespaceTable.getColumnInfo("CIMOM_ID"), string);
        Cimom2namespace.Cimom2namespaceCursor cimom2namespaceCursor = Cimom2namespace.getCursor(dBConnection, hashtable, null);
        int n = 0;
        try {
            while (cimom2namespaceCursor.next()) {
                Cimom2namespace cimom2namespace = cimom2namespaceCursor.getObject();
                String string2 = Integer.toString(cimom2namespace.getCimNamespaceId());
                n += this.deleteCimKeysOfNamespace(dBConnection, string2);
                n += cimom2namespace.delete(dBConnection);
            }
        }
        finally {
            cimom2namespaceCursor.close();
        }
        return n;
    }

    private int[] markDevicesAsMissing(DBConnection dBConnection) throws SQLException {
        Object object;
        String string;
        Object object2;
        Object object3;
        Hashtable hashtable = new Hashtable(2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int[] nArray = new int[3];
        LinkedList linkedList = this.getMissingSubsystemIDs(dBConnection);
        if (!linkedList.isEmpty()) {
            object3 = this.convertLinkedListToCommaSeparatedString(linkedList);
            object2 = "UPDATE " + TResStorageSubsystemTable.getTablename() + " SET " + "DETECTABLE" + "=0 WHERE " + "SUBSYSTEM_ID" + " IN (" + (String)object3 + ")";
            nArray[0] = ComplexQuery.sqlUpdate(dBConnection, (String)object2, hashtable);
            hashMap.put(TResStorageSubsystemTable.getTablename(), linkedList);
        } else {
            nArray[0] = 0;
        }
        object3 = this.getMissingTapeLibraries(dBConnection);
        if (!((AbstractCollection)object3).isEmpty()) {
            object2 = this.convertLinkedListToCommaSeparatedString((LinkedList)object3);
            string = "UPDATE " + TResTapeLibraryTable.getTablename() + " SET " + "DETECTABLE" + "=0 WHERE " + "TAPE_LIBRARY_ID" + " IN (" + (String)object2 + ")";
            nArray[1] = ComplexQuery.sqlUpdate(dBConnection, string, hashtable);
            hashMap.put(TResTapeLibraryTable.getTablename(), object3);
        } else {
            nArray[1] = 0;
        }
        object2 = this.getMissingSwitches(dBConnection);
        if (!((AbstractCollection)object2).isEmpty()) {
            string = this.convertLinkedListToCommaSeparatedString((LinkedList)object2);
            object = "UPDATE " + TResSwitchTable.getTablename() + " SET " + "DETECTABLE" + "=0 WHERE " + "SWITCH_ID" + " IN (" + string + ")";
            nArray[2] = ComplexQuery.sqlUpdate(dBConnection, (String)object, hashtable);
            hashMap.put(TResSwitchTable.getTablename(), object2);
        } else {
            nArray[2] = 0;
        }
        if (!hashMap.isEmpty()) {
            string = PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString();
            object = new ChangeDetection(dBConnection);
            dBConnection.commit();
            ((ChangeDetection)object).complete(dBConnection, hashMap, string);
            ServiceUtils.getEventMonitorProxy().handleModelUpdate(string);
        }
        if (!dBConnection.getAutoCommit()) {
            dBConnection.commit();
        }
        return nArray;
    }

    private LinkedList getMissingTapeLibraries(DBConnection dBConnection) throws SQLException {
        String string = "SELECT TAPE_LIBRARY_ID FROM " + TResTapeLibraryTable.getTablename() + " WHERE (SELECT COUNT(*) FROM " + TResCimkeyTapeLibraryTable.getTablename() + " WHERE " + "TAPE_LIBRARY_ID" + "=" + TResTapeLibraryTable.getTablename() + "." + "TAPE_LIBRARY_ID" + ")=0";
        DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, null);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (dBResultSet.next()) {
            linkedList.add(dBResultSet.getString(1));
        }
        dBResultSet.close();
        return linkedList;
    }

    private LinkedList getMissingSwitches(DBConnection dBConnection) throws SQLException {
        String string = "SELECT ELEMENT_ID FROM " + TResElementProbeStatusTable.getTablename() + " WHERE " + "PROBE_FOUND" + "!=1 AND " + "ELEMENT_ID" + " IN (SELECT " + "SWITCH_ID" + " FROM " + TResSwitchTable.getTablename() + " WHERE (SELECT COUNT(*) FROM " + TResCimkeySwitchTable.getTablename() + " WHERE " + "SWITCH_WWN" + "=" + TResSwitchTable.getTablename() + "." + "SWITCH_WWN" + ")=0 )";
        DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, null);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (dBResultSet.next()) {
            linkedList.add(dBResultSet.getString(1));
        }
        dBResultSet.close();
        return linkedList;
    }

    private String convertLinkedListToCommaSeparatedString(LinkedList linkedList) {
        String string = "";
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            string = String.valueOf(string) + (String)iterator.next();
            string = String.valueOf(string) + ",";
        }
        if (string.indexOf(",") >= 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private LinkedList getMissingSubsystemIDs(DBConnection dBConnection) throws SQLException {
        String string = "SELECT SUBSYSTEM_ID FROM " + TResStorageSubsystemTable.getTablename() + " WHERE (SELECT COUNT(*) FROM " + TResCimkeySubsystemTable.getTablename() + " WHERE " + "SUBSYSTEM_ID" + "=" + TResStorageSubsystemTable.getTablename() + "." + "SUBSYSTEM_ID" + ")=0";
        DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, null);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (dBResultSet.next()) {
            linkedList.add(dBResultSet.getString(1));
        }
        dBResultSet.close();
        return linkedList;
    }

    private int deleteCimKeysOfNamespace(DBConnection dBConnection, String string) throws SQLException {
        int n = 0;
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>(2);
        hashtable.put(TResCimkeyHostTable.getColumnInfo("CIM_NAMESPACE_ID"), string);
        n += CimkeyHost.deletes(dBConnection, hashtable);
        hashtable.clear();
        hashtable.put(TResCimkeyPortTable.getColumnInfo("CIM_NAMESPACE_ID"), string);
        n += CimkeyPort.deletes(dBConnection, hashtable);
        hashtable.clear();
        hashtable.put(TResCimkeySwitchTable.getColumnInfo("CIM_NAMESPACE_ID"), string);
        n += CimkeySwitch.deletes(dBConnection, hashtable);
        hashtable.clear();
        hashtable.put(TResCimkeyTapeLibraryTable.getColumnInfo("CIM_NAMESPACE_ID"), string);
        n += CimkeyTapeLibrary.deletes(dBConnection, hashtable);
        hashtable.clear();
        hashtable.put(TResCimkeyVolumeTable.getColumnInfo("CIM_NAMESPACE_ID"), string);
        n += CimkeyVolume.deletes(dBConnection, hashtable);
        hashtable.clear();
        hashtable.put(TResCimkeySubsystemTable.getColumnInfo("CIM_NAMESPACE_ID"), string);
        CimkeySubsystem.CimkeySubsystemCursor cimkeySubsystemCursor = CimkeySubsystem.getCursor(dBConnection, hashtable, null);
        try {
            while (cimkeySubsystemCursor.next()) {
                CimkeySubsystem cimkeySubsystem = cimkeySubsystemCursor.getObject();
                CapabilityData capabilityData = new CapabilityData();
                capabilityData.setCapabilityDataId(cimkeySubsystem.getCapabilityDataId());
                if (capabilityData.retrieve(dBConnection)) {
                    n += capabilityData.delete(dBConnection);
                }
                n += cimkeySubsystem.delete(dBConnection);
            }
        }
        finally {
            cimkeySubsystemCursor.close();
        }
        return n;
    }

    public CIMOMConnectionStatus[] testCIMOMConnection(CIMOM[] cIMOMArray) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "testCIMOMConnection", cIMOMArray);
        CIMOMConnectionStatus[] cIMOMConnectionStatusArray = null;
        try {
            cIMOMConnectionStatusArray = this.testCIMOMConnection(cIMOMArray, null).getCimomStatus();
        }
        finally {
            logTraceHelper.exit(cIMOMConnectionStatusArray);
        }
        return cIMOMConnectionStatusArray;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public CimomAndDeviceStatus testCIMOMConnection(CIMOM[] var1_1, CIMObjectPath var2_2) throws ServerException {
        var3_3 = LogTraceHelper.entry(this, "testCIMOMConnection", var1_1);
        var4_4 = null;
        try {
            block43: {
                try {
                    ParameterChecker.assertMandatoryParameter(1, "pCimoms", var1_1, var3_3);
                }
                catch (MissingParameterException var5_5) {
                    throw DiskMessageHelper.getServerException("HWN020002E", (Object)var5_5.getMessage(), var5_5, var3_3);
                }
                var5_6 = var1_1.length;
                var6_7 = new CIMOMConnectionStatus[var5_6];
                var7_8 = new DeviceStatus[var5_6];
                var8_9 = 0;
                while (var8_9 < var5_6) {
                    var6_7[var8_9] = CIMOMConnectionStatus.UNCONFIGURED;
                    var7_8[var8_9] = DeviceStatus.INVALID;
                    ++var8_9;
                }
                var8_10 = DiskManagerConfigSvc.getLongConfigValue("CIMOMManager.TestConnectionTimeout", 45000L);
                var10_11 = DiskThreadManager.getExecutionGroup();
                var11_12 = new Long[var5_6];
                try {
                    try {
                        var12_13 = 0;
                        while (var12_13 < var5_6) {
                            var13_18 /* !! */  = null;
                            if (var2_2 == null) {
                                var13_18 /* !! */  = new Object[]{var1_1[var12_13]};
                                var11_12[var12_13] = var10_11.execute(this, "testOneCIMOMConnection", var13_18 /* !! */ , var3_3);
                            } else {
                                var13_18 /* !! */  = new Object[]{var1_1[var12_13], var2_2};
                                var11_12[var12_13] = var10_11.execute(this, "testOneDeviceConnection", var13_18 /* !! */ , var3_3);
                            }
                            ++var12_13;
                        }
                        var10_11.waitForCompletion(var8_10);
                        var12_13 = 0;
                        while (var12_13 < var5_6) {
                            var13_18 /* !! */  = var10_11.getExecutionError(var11_12[var12_13]);
                            if (var13_18 /* !! */  == null) {
                                var14_22 = var10_11.getExecutionResult(var11_12[var12_13]);
                                if (var14_22 instanceof CIMOMConnectionStatus) {
                                    var15_23 = (CIMOMConnectionStatus)var14_22;
                                    var3_3.traceInfo("test CIMOM connection thread " + var11_12[var12_13] + " returned CIMOMConnectionStatus " + var15_23.toString());
                                    var6_7[var12_13] = var15_23;
                                } else if (var14_22 instanceof DeviceStatus) {
                                    var15_23 = (DeviceStatus)var14_22;
                                    var3_3.traceInfo("test CIMOM connection thread " + var11_12[var12_13] + " returned device connection status " + var15_23.toString());
                                    var6_7[var12_13] = CIMOMConnectionStatus.SUCCESS;
                                    var7_8[var12_13] = var15_23;
                                }
                            } else if (var13_18 /* !! */  instanceof CIMException) {
                                var14_22 = (CIMException)var13_18 /* !! */ ;
                                var15_23 = var13_18 /* !! */ .getCause();
                                if (var15_23 instanceof SSLHandshakeException || var15_23 instanceof SSLProtocolException) {
                                    var3_3.traceError(String.valueOf(var1_1[var12_13].getServiceUrl()) + " not accessible due to SSLHandshakeException or SSLProtocolException. " + "This exception might be due to an invalid SLP registration, e.g. \"http\" instead of \"https\".", (Throwable)var15_23);
                                    var6_7[var12_13] = CIMOMConnectionStatus.SSL_HANDSHAKE_ERROR;
                                } else {
                                    var3_3.traceError(String.valueOf(var1_1[var12_13].getServiceUrl()) + " not accessible due to a non-SSLCIM Exception", (Throwable)var15_23);
                                    var16_24 = var14_22.getParams();
                                    var17_25 = var14_22.getID();
                                    if (var17_25 != null && var17_25.equals("CIM_ERR_ACCESS_DENIED")) {
                                        var3_3.traceInfo(String.valueOf(var1_1[var12_13].getServiceUrl()) + " not accessible due to an invalid username or password.");
                                        var6_7[var12_13] = CIMOMConnectionStatus.LOGIN_FAILED;
                                    } else if (var17_25 != null && var17_25.indexOf("CMMOM0104E") != -1) {
                                        var3_3.traceInfo(String.valueOf(var1_1[var12_13].getServiceUrl()) + " not accessible for one of the following reasons: " + "The SLP registration is invalid (port or IP is wrong), " + "The machine where the CIMOM is running is down, " + "The CIMOM service is not running, " + "The firewall is misconfigured.");
                                        var6_7[var12_13] = CIMOMConnectionStatus.TIMEOUT;
                                    } else if (var16_24 != null && var16_24.length != 0) {
                                        var18_26 = 0;
                                        while (var18_26 < var16_24.length) {
                                            var19_27 = var16_24[var18_26];
                                            if (var19_27.toString().indexOf("CMMOM0026E") != -1) {
                                                var3_3.traceInfo(String.valueOf(var1_1[var12_13].getServiceUrl()) + " not accessible due to an invalid SLP registration. " + "In this case the SLP attribute identifying the CIM namespace seems to be wrong. " + "The namespace that was reported via SLP oder set via cmd line options is: " + var1_1[var12_13].getInteropSchemaNamespace());
                                                var6_7[var12_13] = CIMOMConnectionStatus.SSL_REGISTRATION_INVALID;
                                            } else {
                                                var3_3.traceError(String.valueOf(var1_1[var12_13].getServiceUrl()) + " unexpected error case parameter " + var19_27.toString(), (Throwable)var15_23);
                                            }
                                            ++var18_26;
                                        }
                                    }
                                    var3_3.traceError(String.valueOf(var1_1[var12_13].getServiceUrl()) + " unexpected error case ", (Throwable)var15_23);
                                }
                            } else if (var13_18 /* !! */  instanceof DiskManagerTimeoutException) {
                                if (var2_2 == null) {
                                    var3_3.traceError(String.valueOf(var1_1[var12_13].getServiceUrl()) + " EnumInstances call on CIM client timed out: " + var13_18 /* !! */ .toString(), (Throwable)var13_18 /* !! */ );
                                } else {
                                    var3_3.traceError(String.valueOf(var1_1[var12_13].getServiceUrl()) + " EnumerateInstanceNames call on CIM client timed out: " + var13_18 /* !! */ .toString(), (Throwable)var13_18 /* !! */ );
                                }
                                var6_7[var12_13] = CIMOMConnectionStatus.TIMEOUT;
                            } else {
                                var3_3.traceError(String.valueOf(var1_1[var12_13].getServiceUrl()) + " Internal error: " + var13_18 /* !! */ .toString(), (Throwable)var13_18 /* !! */ );
                                var6_7[var12_13] = CIMOMConnectionStatus.UNKNOWN;
                            }
                            ++var12_13;
                        }
                        break block43;
                    }
                    catch (DiskManagerTimeoutException var12_14) {
                        var3_3.traceError("Internal error: DiskManagerTimeoutException, whole ExecutionGroup timed out", var12_14);
                        var13_19 = 0;
                        ** while (var13_19 < var5_6)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var6_7[var13_19] = CIMOMConnectionStatus.TIMEOUT;
                        ++var13_19;
                        continue;
lbl101:
                        // 1 sources

                        break block43;
                    }
                    catch (DiskManagerExecException var12_15) {
                        var3_3.traceError("Internal error: DiskManagerExecException in ExecutionGroupFramework", var12_15);
                        var13_19 = 0;
                        ** while (var13_19 < var5_6)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var6_7[var13_19] = CIMOMConnectionStatus.UNKNOWN;
                        ++var13_19;
                        continue;
lbl109:
                        // 1 sources

                    }
                }
                finally {
                    var10_11.clear();
                }
            }
            var4_4 = new CimomAndDeviceStatus(var6_7, var7_8);
            var12_17 = 0;
            while (var12_17 < var5_6) {
                var13_21 = this.getCIMOMs(new String[]{var1_1[var12_17].getServiceUrl()});
                if (var13_21.length != 0) {
                    if (var13_21[0].matches(var1_1[var12_17])) {
                        var1_1[var12_17].setStatus(var6_7[var12_17]);
                        if (!this.persistCIMOMStatus(var1_1[var12_17]).booleanValue()) {
                            var3_3.traceError("Failed to update cimom status in database entity", null);
                        }
                    } else {
                        var3_3.traceInfo("Skipped to update cimom status due to attribute mismatch for " + var1_1[var12_17].getServiceUrl());
                    }
                }
                ++var12_17;
            }
        }
        catch (Throwable var21_29) {
            var3_3.exit(var4_4);
            throw var21_29;
        }
        var3_3.exit(var4_4);
        return var4_4;
    }

    public CIMOMConnectionStatus testOneCIMOMConnection(CIMOM cIMOM) throws CIMException, DiskManagerTimeoutException {
        CIMOMConnectionStatus cIMOMConnectionStatus;
        block33: {
            cIMOMConnectionStatus = CIMOMConnectionStatus.UNCONFIGURED;
            LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "testOneCIMOMConnection", new Object[]{cIMOM});
            try {
                String string = cIMOM.getServiceUrl();
                String string2 = cIMOM.getInteropSchemaNamespace();
                logTraceHelper.traceInfo("Getting CIM client");
                CIMClientWrapper cIMClientWrapper = CIMClientPool.getClient(cIMOM.getUserId(), cIMOM.getPassword(), cIMOM.getServiceUrl(), string2);
                try {
                    try {
                        cIMClientWrapper.enumerateClassNames(new CIMObjectPath("CIM_RegisteredProfile"), logTraceHelper);
                        cIMOMConnectionStatus = CIMOMConnectionStatus.SUCCESS;
                    }
                    catch (CIMSecurityException cIMSecurityException) {
                        logTraceHelper.traceError("Exception received while trying to connect to " + string + " due to " + cIMSecurityException.getMessage(), cIMSecurityException);
                        cIMOMConnectionStatus = CIMOMConnectionStatus.SSL_REGISTRATION_INVALID;
                    }
                    catch (CIMTransportException cIMTransportException) {
                        logTraceHelper.traceError("Exception received while trying to connect to " + string + " due to " + cIMTransportException.getMessage(), cIMTransportException);
                        if (cIMTransportException.getDescription().indexOf("Unauthorized") != -1) {
                            cIMOMConnectionStatus = CIMOMConnectionStatus.LOGIN_FAILED;
                            break block33;
                        }
                        cIMOMConnectionStatus = CIMOMConnectionStatus.REFUSED;
                    }
                    catch (CIMAuthenticationException cIMAuthenticationException) {
                        logTraceHelper.traceError("Exception received while trying to connect to " + string + " due to " + cIMAuthenticationException.getMessage(), cIMAuthenticationException);
                        cIMOMConnectionStatus = CIMOMConnectionStatus.LOGIN_FAILED;
                    }
                    catch (DiskManagerRTException diskManagerRTException) {
                        logTraceHelper.traceError("Exception received while trying to connect to " + string + " due to " + diskManagerRTException.getMessage(), diskManagerRTException);
                        if (diskManagerRTException.getMessage().indexOf("InvocationTargetException") != -1) {
                            try {
                                cIMClientWrapper.enumerateInstanceNames(new CIMObjectPath("CIM_ComputerSystem"), logTraceHelper);
                                cIMOMConnectionStatus = CIMOMConnectionStatus.SUCCESS;
                            }
                            catch (Exception exception) {
                                logTraceHelper.traceError("Did not find CIM_ComputerSystem in namespace " + string2 + " for CIMOM " + string + " because of " + diskManagerRTException.getMessage(), exception);
                                cIMOMConnectionStatus = CIMOMConnectionStatus.UNKNOWN;
                            }
                            break block33;
                        }
                        if (diskManagerRTException.getMessage().indexOf("EXT_ERR_UNABLE_TO_CONNECT") != -1) {
                            cIMOMConnectionStatus = CIMOMConnectionStatus.REFUSED;
                            break block33;
                        }
                        if (diskManagerRTException.getMessage().indexOf("EXT_ERR_TIME_OUT") != -1) {
                            cIMOMConnectionStatus = CIMOMConnectionStatus.TIMEOUT;
                            break block33;
                        }
                        if (diskManagerRTException.getMessage().indexOf("EXT_ERR_NO_CIMOM") != -1 || diskManagerRTException.getMessage().indexOf("EXT_ERR_UNKNOWN_SERVER") != -1) {
                            cIMOMConnectionStatus = CIMOMConnectionStatus.UNCONFIGURED;
                            break block33;
                        }
                        cIMOMConnectionStatus = CIMOMConnectionStatus.UNKNOWN;
                    }
                    catch (CIMException cIMException) {
                        logTraceHelper.traceError("Did not find CIM_RegisteredProfile in namespace " + string2 + " for CIMOM " + string + " because of " + cIMException.getMessage() + " - now testing for computer system", cIMException);
                        if (cIMException.getID().indexOf("CIM_ERR_NOT_FOUND") != -1 || cIMException.getID().indexOf("CIM_ERR_INVALID_CLASS") != -1) {
                            try {
                                cIMClientWrapper.enumerateClassNames(new CIMObjectPath("CIM_ComputerSystem"), logTraceHelper);
                                cIMOMConnectionStatus = CIMOMConnectionStatus.SUCCESS;
                            }
                            catch (CIMException cIMException2) {
                                logTraceHelper.traceError("Did not find CIM_ComputerSystem in namespace " + string2 + " for CIMOM " + string + " because of " + cIMException.getMessage(), cIMException2);
                                cIMOMConnectionStatus = CIMOMConnectionStatus.UNKNOWN;
                            }
                            break block33;
                        }
                        if (cIMException.toString().indexOf("CIM_ERR_NAMESPACE_NOT_IN_MANAGER") != -1 || cIMException.toString().indexOf("CIM_ERR_INVALID_NAMESPACE") != -1) {
                            cIMOMConnectionStatus = CIMOMConnectionStatus.INVALID_NAMESPACE;
                            break block33;
                        }
                        if (cIMException.toString().indexOf("challenge") != -1) {
                            cIMOMConnectionStatus = CIMOMConnectionStatus.LOGIN_FAILED;
                            break block33;
                        }
                        if (cIMException.toString().indexOf("TIME_OUT") != -1) {
                            cIMOMConnectionStatus = CIMOMConnectionStatus.TIMEOUT;
                            break block33;
                        }
                        cIMOMConnectionStatus = CIMOMConnectionStatus.UNKNOWN;
                    }
                    catch (Exception exception) {
                        logTraceHelper.traceError("Exception received while trying to connect to " + string + " due to " + exception.getMessage(), exception);
                        cIMOMConnectionStatus = CIMOMConnectionStatus.UNKNOWN;
                    }
                }
                finally {
                    if (cIMClientWrapper != null) {
                        try {
                            CIMClientPool.returnClient(cIMClientWrapper);
                        }
                        catch (CIMException cIMException) {
                            logTraceHelper.traceError("Failed to close CIMClientWrapper in testOneCIMOMConnection due to " + cIMException.getMessage(), cIMException);
                        }
                    }
                }
            }
            finally {
                logTraceHelper.exit(cIMOMConnectionStatus);
            }
        }
        return cIMOMConnectionStatus;
    }

    public DeviceStatus testOneDeviceConnection(CIMOM cIMOM, CIMObjectPath cIMObjectPath) throws CIMException, DiskManagerTimeoutException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "testOneDeviceConnection", new Object[]{cIMOM, cIMObjectPath});
        CIMClientWrapper cIMClientWrapper = null;
        DeviceStatus deviceStatus = null;
        try {
            deviceStatus = DeviceStatus.INVALID;
            String string = cIMOM.getServiceUrl();
            String string2 = cIMObjectPath.getNameSpace();
            if (string2 == null || string2.trim().length() == 0) {
                string2 = cIMOM.getInteropSchemaNamespace();
            }
            logTraceHelper.traceInfo("Testing device status for CIMOM " + string + " in namespace " + string2);
            logTraceHelper.traceInfo("Getting CIM client");
            cIMClientWrapper = CIMClientPool.getClient(cIMOM.getUserId(), cIMOM.getPassword(), string, string2);
            logTraceHelper.traceInfo("Get instance for COP: " + cIMObjectPath);
            CIMInstance cIMInstance = cIMClientWrapper.getInstance(cIMObjectPath, false, true, false, logTraceHelper);
            if (cIMInstance != null) {
                logTraceHelper.traceInfo("Getting OperationalStatus property for " + cIMObjectPath);
                CIMProperty cIMProperty = cIMInstance.getProperty("OperationalStatus");
                if (cIMProperty != null) {
                    logTraceHelper.traceInfo("Getting value of OperationalStatus property for " + cIMObjectPath);
                    deviceStatus = new DeviceStatus(cIMProperty);
                }
            }
        }
        catch (Throwable throwable) {
            if (cIMClientWrapper != null) {
                try {
                    CIMClientPool.returnClient(cIMClientWrapper);
                }
                catch (CIMException cIMException) {
                    logTraceHelper.traceError("Failed to close CIMClientWrapper in testOneCIMOMConnection due to " + cIMException.getMessage(), cIMException);
                }
            }
            logTraceHelper.exit(deviceStatus);
            throw throwable;
        }
        if (cIMClientWrapper != null) {
            try {
                CIMClientPool.returnClient(cIMClientWrapper);
            }
            catch (CIMException cIMException) {
                logTraceHelper.traceError("Failed to close CIMClientWrapper in testOneCIMOMConnection due to " + cIMException.getMessage(), cIMException);
            }
        }
        logTraceHelper.exit(deviceStatus);
        return deviceStatus;
    }

    /*
     * Exception decompiling
     */
    public Result testDeviceStatus(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.TryRewriter.extendTryBlock(TryRewriter.java:34)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.TryRewriter.extendTryBlocks(TryRewriter.java:147)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.extendTryBlocks(Op03Rewriters.java:48)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:557)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Vector getNamespacesForServiceUrl(LogTraceHelper logTraceHelper, String string) {
        Vector<String> vector = new Vector<String>();
        DBConnection dBConnection = ServiceUtils.getConnection();
        if (dBConnection == null) {
            throw DiskMessageHelper.getServerException("HWN021800E", null, logTraceHelper);
        }
        String string2 = "select C2N.NAMESPACE from T_RES_CIMOM2NAMESPACE as C2N where C2N.CIMOM_ID IN (select RC.REG_CIMOM_ID from T_RES_REGISTERED_CIMOM as RC where RC.SERVICE_URL = '" + string + "'" + ")";
        DBResultSet dBResultSet = null;
        try {
            try {
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string2, new Hashtable());
                while (dBResultSet.next()) {
                    vector.add(dBResultSet.getString(1));
                }
                dBConnection.commit();
            }
            catch (Exception exception) {
                logTraceHelper.traceError("Unable to retrieve namespaces for CIMOM" + string + " due to " + exception.getMessage(), exception);
                throw DiskMessageHelper.getServerException("HWN021802E", (Object)exception.getMessage(), exception, logTraceHelper);
            }
        }
        finally {
            try {
                dBConnection.close();
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Unable to close database connection due to " + sQLException.getMessage(), sQLException);
            }
        }
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getCIMOMIDs() throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "getCIMOMIDs", null);
        Object[] objectArray = null;
        try {
            DBConnection dBConnection = ServiceUtils.getConnection();
            if (dBConnection == null) {
                throw DiskMessageHelper.getServerException("HWN021800E", null, logTraceHelper);
            }
            Vector<String> vector = new Vector<String>();
            RegisteredCimom.RegisteredCimomCursor registeredCimomCursor = null;
            try {
                try {
                    registeredCimomCursor = RegisteredCimom.getCursor(dBConnection, null, null);
                    if (registeredCimomCursor == null) {
                        throw DiskMessageHelper.getServerException("HWN021801E", null, logTraceHelper);
                    }
                    while (registeredCimomCursor.next()) {
                        RegisteredCimom registeredCimom = registeredCimomCursor.getObject();
                        if (registeredCimom == null) {
                            throw DiskMessageHelper.getServerException("HWN021801E", null, logTraceHelper);
                        }
                        if (registeredCimom.getStatus() != CIMOMConnectionStatus.PENDING_DELETION.toID()) {
                            vector.add(registeredCimom.getServiceUrl());
                            logTraceHelper.traceInfo("CIMOM ID " + registeredCimom.getServiceUrl() + " was retrieved");
                            continue;
                        }
                        logTraceHelper.traceInfo("CIMOM ID " + registeredCimom.getServiceUrl() + " was skipped because of deletion pending");
                    }
                }
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
                }
            }
            finally {
                try {
                    if (registeredCimomCursor != null) {
                        registeredCimomCursor.close();
                    }
                    dBConnection.close();
                }
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
                }
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        finally {
            logTraceHelper.exit(objectArray);
        }
    }

    public CIMOM[] findCIMOMsByNetAddress(InetAddress inetAddress) {
        try {
            CIMOM[] cIMOMArray = this.searchCimomInDb(inetAddress.getHostAddress());
            if (cIMOMArray.length == 0) {
                cIMOMArray = this.searchCimomInDb(inetAddress.getCanonicalHostName());
            }
            return cIMOMArray;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    private CIMOM[] searchCimomInDb(String string) throws SQLException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "searchCimomInDb", new Object[]{string});
        DBResultSet dBResultSet = null;
        CIMOM[] cIMOMArray = null;
        DBConnection dBConnection = null;
        try {
            dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            hashtable.put(TResRegisteredCimomTable.getColumnInfo("SERVICE_URL"), "%//" + string + ":%");
            String string2 = "SELECT REG_CIMOM_ID,SERVICE_URL FROM " + TResRegisteredCimomTable.getTablename() + " WHERE " + "SERVICE_URL" + " LIKE (?)";
            dBResultSet = ComplexQuery.sqlQuery(dBConnection, string2, hashtable);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (dBResultSet.next()) {
                arrayList.add(dBResultSet.getString("SERVICE_URL"));
            }
            CIMOM[] cIMOMArray2 = cIMOMArray = this.getCIMOMs(arrayList.toArray(new String[arrayList.size()]));
            return cIMOMArray2;
        }
        finally {
            try {
                if (dBResultSet != null) {
                    dBResultSet.closeAll();
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Unable to close database result set due to " + sQLException.getMessage(), sQLException);
            }
            try {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Unable to close database connection due to " + sQLException.getMessage(), sQLException);
            }
            logTraceHelper.exit(cIMOMArray);
        }
    }

    public int getCIMOMIDforURL(String string) throws SQLException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "getCIMOMIDforURL", new Object[]{string});
        DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
        DBResultSet dBResultSet = null;
        int n = 0;
        try {
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            hashtable.put(TResRegisteredCimomTable.getColumnInfo("SERVICE_URL"), string);
            String string2 = "SELECT REG_CIMOM_ID,SERVICE_URL FROM " + TResRegisteredCimomTable.getTablename() + " WHERE " + "SERVICE_URL" + " = ?";
            dBResultSet = ComplexQuery.sqlQuery(dBConnection, string2, hashtable);
            if (dBResultSet.next()) {
                n = dBResultSet.getInt(1);
            }
        }
        finally {
            try {
                if (dBResultSet != null) {
                    dBResultSet.closeAll();
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Unable to close database result set due to " + sQLException.getMessage(), sQLException);
            }
            try {
                dBConnection.close();
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Unable to close database connection due to " + sQLException.getMessage(), sQLException);
            }
            logTraceHelper.exit(Integer.toString(n));
        }
        return n;
    }

    public AsyncResult discoverDevicesFromCIMOM(String[] stringArray) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "discoverDevicesFromCIMOM", new Object[]{stringArray});
        Object var3_3 = null;
        try {
            Object object = Activator._serviceHelper.bindLocal("DiscoverService");
            if (object == null) {
                throw DiskMessageHelper.getServerException("HWN021807E", null, logTraceHelper);
            }
            IDiscover iDiscover = (IDiscover)object;
            ParameterChecker.assertMandatoryParameter(1, "CimomIDs", stringArray, logTraceHelper);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            AsyncResult asyncResult = new AsyncResult(0, -1);
            hashtable.put("CIMOMID_PARAM", stringArray);
            hashtable.put("Type", "ToplevelALL");
            logTraceHelper.traceSvcEntry("DiscoverServise.discover", new Object[]{hashtable});
            String string = iDiscover.discover("dispatchDiscoveryProcess", hashtable);
            logTraceHelper.traceSvcReturn("DiscoverServise.discover", string);
            AsyncResult asyncResult2 = asyncResult = iDiscover.getJobStatus(string);
            return asyncResult2;
        }
        finally {
            logTraceHelper.exit(var3_3);
        }
    }

    private int[] checkForDuplicateCIMOMs(CIMOM[] cIMOMArray, DBConnection dBConnection) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "checkForDuplicateCIMOMs", new Object[]{cIMOMArray, dBConnection});
        int[] nArray = new int[cIMOMArray.length];
        try {
            CIMOM[] cIMOMArray2 = this.getCIMOMs();
            String string = null;
            String string2 = null;
            int n = 0;
            while (n < cIMOMArray.length) {
                try {
                    string = cIMOMArray[n].getServiceUrl();
                    string2 = String.valueOf(this.parseHost(string)) + ":" + this.parsePort(string);
                    if (string2.indexOf("null") > -1) {
                        nArray[n] = 2;
                    } else {
                        int n2 = 0;
                        while (n2 < cIMOMArray2.length) {
                            if (cIMOMArray2[n2].getServiceUrl().indexOf(string2) > -1) {
                                nArray[n] = 1;
                                break;
                            }
                            ++n2;
                        }
                        cIMOMArray[n].setServiceUrl(this.replaceHost(string, string2));
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    logTraceHelper.traceError(unknownHostException.getMessage(), unknownHostException);
                    nArray[n] = 2;
                }
                ++n;
            }
            int[] nArray2 = nArray;
            return nArray2;
        }
        finally {
            logTraceHelper.exit(nArray);
        }
    }

    private String parsePort(String string) {
        int n = string.indexOf("://");
        int n2 = string.indexOf(58, n + 1);
        if (n2 == -1 || n2 == string.length() - 1) {
            return null;
        }
        return string.substring(n2 + 1);
    }

    private String parseHost(String string) throws UnknownHostException {
        int n = string.indexOf("://");
        int n2 = string.indexOf(58, n + 1);
        if (n == -1 || n2 == -1 || n2 == string.length() - 1) {
            return null;
        }
        String string2 = string.substring(n + 3, n2);
        return InetAddress.getByName(string2).getHostAddress();
    }

    private String replaceHost(String string, String string2) {
        int n = string.indexOf("://");
        int n2 = string.indexOf(58, n + 1);
        if (n == -1 || n2 == -1 || n2 == string.length() - 1) {
            return null;
        }
        return String.valueOf(string.substring(0, n)) + "://" + string2;
    }

    public static String getUniqueNumberString() {
        int n;
        String string;
        int n2 = 7;
        if ((string = Integer.toString(n = cUniqueInt++)).length() > n2) {
            return string.substring(string.length() - n2);
        }
        if (string.length() < n2) {
            return String.valueOf("000000000000000000000000000".substring(0, n2 - string.length())) + string;
        }
        return string;
    }

    public static final boolean needsSaxParsing(String string) {
        LogTraceHelper logTraceHelper = null;
        Boolean bl = null;
        try {
            bl = (Boolean)stSaxParsing.get(string);
            if (bl == null) {
                logTraceHelper = LogTraceHelper.entry(CIMOMManager.class.getName(), "needsSaxParsing", new Object[]{string});
                String string2 = "subsystem type";
                bl = CIMOMManager.checkForSubsystemCIMOMParsing(string);
                if (bl == null) {
                    string2 = "switch vendor";
                    bl = CIMOMManager.checkForVendorParsing(string, CIMOMManager.getSwitchVendorForCIMOM(string));
                    if (bl == null) {
                        string2 = "tape library vendor";
                        bl = CIMOMManager.checkForVendorParsing(string, CIMOMManager.getLibraryVendorForCIMOM(string));
                        if (bl == null) {
                            string2 = "namespace";
                            bl = CIMOMManager.checkForNamespaceofCIMOMParsing(string);
                            if (bl == null) {
                                bl = Boolean.FALSE;
                                return false;
                            }
                        }
                    }
                }
                logTraceHelper.traceWarning("Caching 'SAX parsing needed = " + bl.toString() + "' for CIMOM " + string + " (Reason: " + string2 + ")");
                stSaxParsing.put(string, bl);
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (logTraceHelper != null) {
                logTraceHelper.exit(bl);
            }
        }
    }

    private static final Boolean checkForNamespaceofCIMOMParsing(String string) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(CIMOMManager.class.getName(), "checkForNamespaceofCIMOMParsing", new Object[]{string});
        Boolean bl = null;
        try {
            List list = CIMOMManager.getNamespacesForCIMOM(string);
            Iterator iterator = list.iterator();
            String string2 = null;
            String string3 = null;
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                string3 = (String)stParsNSpcDef.get(string2);
                if (string3 == null) continue;
                bl = Boolean.TRUE;
            }
            Boolean bl2 = bl;
            return bl2;
        }
        finally {
            logTraceHelper.exit(bl);
        }
    }

    private static final Boolean checkForVendorParsing(String string, String string2) {
        Boolean bl;
        LogTraceHelper logTraceHelper;
        block3: {
            logTraceHelper = LogTraceHelper.entry(CIMOMManager.class.getName(), "checkForVendorParsing", new Object[]{string, string2});
            bl = null;
            try {
                if (!VENDOR_UNKNOWN.equals(string2)) break block3;
                logTraceHelper.exit(bl);
                return null;
            }
            catch (Throwable throwable) {
                logTraceHelper.exit(bl);
                throw throwable;
            }
        }
        String string3 = (String)stParsVendorDef.get(string2);
        bl = string3 == null ? Boolean.FALSE : Boolean.TRUE;
        Boolean bl2 = bl;
        logTraceHelper.exit(bl);
        return bl2;
    }

    private static final Boolean checkForSubsystemCIMOMParsing(String string) {
        String string2;
        Boolean bl;
        LogTraceHelper logTraceHelper;
        block3: {
            logTraceHelper = LogTraceHelper.entry(CIMOMManager.class.getName(), "checkForSubsystemCIMOMParsing", new Object[]{string});
            bl = null;
            try {
                string2 = CIMOMManager.getSubsystemTypeForCIMOM(string);
                if (!DEVICE_TYPE_UNKNOWN.equals(string2) && !"Unknown".equals(string2)) break block3;
                logTraceHelper.exit(bl);
                return null;
            }
            catch (Throwable throwable) {
                logTraceHelper.exit(bl);
                throw throwable;
            }
        }
        String string3 = (String)stParsDevTypeDef.get(string2);
        bl = string3 == null ? Boolean.FALSE : Boolean.TRUE;
        Boolean bl2 = bl;
        logTraceHelper.exit(bl);
        return bl2;
    }

    public static final boolean allowsConcurrentAccess(String string) {
        LogTraceHelper logTraceHelper = null;
        Boolean bl = null;
        try {
            bl = (Boolean)stConcurrentAccess.get(string);
            if (bl == null) {
                logTraceHelper = LogTraceHelper.entry(CIMOMManager.class.getName(), "allowsConcurrentAccess", new Object[]{string});
                String string2 = "subsystem type";
                bl = CIMOMManager.checkForSubsystemCIMOM(string);
                if (bl == null) {
                    string2 = "switch vendor";
                    bl = CIMOMManager.checkForVendor(string, CIMOMManager.getSwitchVendorForCIMOM(string));
                    if (bl == null) {
                        string2 = "tape library vendor";
                        bl = CIMOMManager.checkForVendor(string, CIMOMManager.getLibraryVendorForCIMOM(string));
                        if (bl == null) {
                            string2 = "namespace";
                            bl = CIMOMManager.checkForNamespaceofCIMOM(string);
                            if (bl == null) {
                                bl = Boolean.TRUE;
                                return true;
                            }
                        }
                    }
                }
                logTraceHelper.traceWarning("Caching 'concurrent access = " + bl.toString() + "' for CIMOM " + string + " (Reason: " + string2 + ")");
                stConcurrentAccess.put(string, bl);
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (logTraceHelper != null) {
                logTraceHelper.exit(bl);
            }
        }
    }

    private static final Boolean checkForSubsystemCIMOM(String string) {
        String string2;
        Boolean bl;
        LogTraceHelper logTraceHelper;
        block3: {
            logTraceHelper = LogTraceHelper.entry(CIMOMManager.class.getName(), "checkForSubsystemCIMOM", new Object[]{string});
            bl = null;
            try {
                string2 = CIMOMManager.getSubsystemTypeForCIMOM(string);
                if (!DEVICE_TYPE_UNKNOWN.equals(string2) && !"Unknown".equals(string2)) break block3;
                logTraceHelper.exit(bl);
                return null;
            }
            catch (Throwable throwable) {
                logTraceHelper.exit(bl);
                throw throwable;
            }
        }
        String string3 = (String)stDevTypeDef.get(string2);
        bl = string3 == null ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl2 = bl;
        logTraceHelper.exit(bl);
        return bl2;
    }

    private static final Boolean checkForNamespaceofCIMOM(String string) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(CIMOMManager.class.getName(), "checkForNamespaceofCIMOM", new Object[]{string});
        Boolean bl = null;
        try {
            List list = CIMOMManager.getNamespacesForCIMOM(string);
            Iterator iterator = list.iterator();
            String string2 = null;
            String string3 = null;
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                string3 = (String)stNSpcDef.get(string2);
                if (string3 == null) continue;
                bl = Boolean.FALSE;
            }
            Boolean bl2 = bl;
            return bl2;
        }
        finally {
            logTraceHelper.exit(bl);
        }
    }

    private static final Boolean checkForVendor(String string, String string2) {
        Boolean bl;
        LogTraceHelper logTraceHelper;
        block3: {
            logTraceHelper = LogTraceHelper.entry(CIMOMManager.class.getName(), "checkForVendor", new Object[]{string, string2});
            bl = null;
            try {
                if (!VENDOR_UNKNOWN.equals(string2)) break block3;
                logTraceHelper.exit(bl);
                return null;
            }
            catch (Throwable throwable) {
                logTraceHelper.exit(bl);
                throw throwable;
            }
        }
        String string3 = (String)stVendorDef.get(string2);
        bl = string3 == null ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl2 = bl;
        logTraceHelper.exit(bl);
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getSubsystemTypeForCIMOM(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ss.").append("TYPE").append(" from ");
        stringBuffer.append(StorageSubsystem.getTablename()).append(" as ss where ss.");
        stringBuffer.append("SUBSYSTEM_ID").append(" in (select ck.");
        stringBuffer.append("SUBSYSTEM_ID").append(" from ").append(CimkeySubsystem.getTablename());
        stringBuffer.append(" as ck where ck.").append("CIM_NAMESPACE_ID").append(" in (select c2n.");
        stringBuffer.append("CIM_NAMESPACE_ID").append(" from ").append(Cimom2namespace.getTablename());
        stringBuffer.append(" as c2n where c2n.").append("CIMOM_ID").append(" in (select rc.");
        stringBuffer.append("REG_CIMOM_ID").append(" from ").append(RegisteredCimom.getTablename());
        stringBuffer.append(" as rc where rc.").append("SERVICE_URL").append("=?)))");
        DBConnection dBConnection = null;
        DBPreparedStatement dBPreparedStatement = null;
        DBResultSet dBResultSet = null;
        try {
            dBConnection = ServiceUtils.getConnection();
            dBPreparedStatement = dBConnection.prepareStatement(stringBuffer.toString());
            dBPreparedStatement.clearParameters();
            dBPreparedStatement.setString(1, string);
            dBResultSet = dBPreparedStatement.executeQuery();
            if (dBResultSet.next()) {
                String string2 = dBResultSet.getString(1);
                return string2;
            }
            return DEVICE_TYPE_UNKNOWN;
        }
        catch (Exception exception) {
            return DEVICE_TYPE_UNKNOWN;
        }
        finally {
            try {
                if (dBResultSet != null) {
                    dBResultSet.close();
                }
                if (dBPreparedStatement != null) {
                    dBPreparedStatement.close();
                }
                if (dBConnection != null) {
                    dBConnection.commit();
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getSwitchVendorForCIMOM(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select v.").append("VENDOR_NAME").append(" from ");
        stringBuffer.append(Vendor.getTablename()).append(" as v where v.").append("VENDOR_ID").append(" in (");
        stringBuffer.append("select sw.").append("VENDOR_ID").append(" from ");
        stringBuffer.append(Switch.getTablename()).append(" as sw where sw.");
        stringBuffer.append("SWITCH_WWN").append(" in (select ck.");
        stringBuffer.append("SWITCH_WWN").append(" from ").append(CimkeySwitch.getTablename());
        stringBuffer.append(" as ck where ck.").append("CIM_NAMESPACE_ID").append(" in (select c2n.");
        stringBuffer.append("CIM_NAMESPACE_ID").append(" from ").append(Cimom2namespace.getTablename());
        stringBuffer.append(" as c2n where c2n.").append("CIMOM_ID").append(" in (select rc.");
        stringBuffer.append("REG_CIMOM_ID").append(" from ").append(RegisteredCimom.getTablename());
        stringBuffer.append(" as rc where rc.").append("SERVICE_URL").append("=?))))");
        DBConnection dBConnection = null;
        DBPreparedStatement dBPreparedStatement = null;
        DBResultSet dBResultSet = null;
        try {
            dBConnection = ServiceUtils.getConnection();
            dBPreparedStatement = dBConnection.prepareStatement(stringBuffer.toString());
            dBPreparedStatement.clearParameters();
            dBPreparedStatement.setString(1, string);
            dBResultSet = dBPreparedStatement.executeQuery();
            if (dBResultSet.next()) {
                String string2 = dBResultSet.getString(1);
                return string2;
            }
            return VENDOR_UNKNOWN;
        }
        catch (Exception exception) {
            return VENDOR_UNKNOWN;
        }
        finally {
            try {
                if (dBResultSet != null) {
                    dBResultSet.close();
                }
                if (dBPreparedStatement != null) {
                    dBPreparedStatement.close();
                }
                if (dBConnection != null) {
                    dBConnection.commit();
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getLibraryVendorForCIMOM(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select v.").append("VENDOR_NAME").append(" from ");
        stringBuffer.append(Vendor.getTablename()).append(" as v where v.").append("VENDOR_ID").append(" in (");
        stringBuffer.append("select tf.").append("VENDOR_ID").append(" from ");
        stringBuffer.append(TapeFrame.getTablename()).append(" as tf where tf.");
        stringBuffer.append("TAPE_LIBRARY_ID").append(" in (select ck.");
        stringBuffer.append("TAPE_LIBRARY_ID").append(" from ").append(CimkeyTapeLibrary.getTablename());
        stringBuffer.append(" as ck where ck.").append("CIM_NAMESPACE_ID").append(" in (select c2n.");
        stringBuffer.append("CIM_NAMESPACE_ID").append(" from ").append(Cimom2namespace.getTablename());
        stringBuffer.append(" as c2n where c2n.").append("CIMOM_ID").append(" in (select rc.");
        stringBuffer.append("REG_CIMOM_ID").append(" from ").append(RegisteredCimom.getTablename());
        stringBuffer.append(" as rc where rc.").append("SERVICE_URL").append("=?))))");
        DBConnection dBConnection = null;
        DBPreparedStatement dBPreparedStatement = null;
        DBResultSet dBResultSet = null;
        try {
            dBConnection = ServiceUtils.getConnection();
            dBPreparedStatement = dBConnection.prepareStatement(stringBuffer.toString());
            dBPreparedStatement.clearParameters();
            dBPreparedStatement.setString(1, string);
            dBResultSet = dBPreparedStatement.executeQuery();
            if (dBResultSet.next()) {
                String string2 = dBResultSet.getString(1);
                return string2;
            }
            return VENDOR_UNKNOWN;
        }
        catch (Exception exception) {
            return VENDOR_UNKNOWN;
        }
        finally {
            try {
                if (dBResultSet != null) {
                    dBResultSet.close();
                }
                if (dBPreparedStatement != null) {
                    dBPreparedStatement.close();
                }
                if (dBConnection != null) {
                    dBConnection.commit();
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    private static final List getNamespacesForCIMOM(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select c2n.").append("NAMESPACE").append(" from ").append(Cimom2namespace.getTablename());
        stringBuffer.append(" as c2n where c2n.").append("CIMOM_ID").append(" in (select rc.");
        stringBuffer.append("REG_CIMOM_ID").append(" from ").append(RegisteredCimom.getTablename());
        stringBuffer.append(" as rc where rc.").append("SERVICE_URL").append("=?)");
        DBConnection dBConnection = null;
        DBPreparedStatement dBPreparedStatement = null;
        DBResultSet dBResultSet = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            dBConnection = ServiceUtils.getConnection();
            dBPreparedStatement = dBConnection.prepareStatement(stringBuffer.toString());
            dBPreparedStatement.clearParameters();
            dBPreparedStatement.setString(1, string);
            dBResultSet = dBPreparedStatement.executeQuery();
            while (dBResultSet.next()) {
                arrayList.add(dBResultSet.getString(1));
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            ArrayList arrayList3 = new ArrayList();
            return arrayList3;
        }
        finally {
            try {
                if (dBResultSet != null) {
                    dBResultSet.close();
                }
                if (dBPreparedStatement != null) {
                    dBPreparedStatement.close();
                }
                if (dBConnection != null) {
                    dBConnection.commit();
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    private static final Map getDefinitionForSync(String string) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(CIMOMManager.class.getName(), "getDefinitionForSync", new Object[]{string});
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String string2 = DiskManagerConfigSvc.getConfigValue(string, null);
            if (string2 != null && string2.trim().length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "]");
                String string3 = null;
                String[] stringArray = null;
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken().substring(1);
                    stringArray = string3.split(";");
                    logTraceHelper.traceWarning("Using synchronized access for device type " + string3);
                    if (stringArray.length > 1) {
                        hashMap.put(stringArray[0], stringArray[1]);
                        continue;
                    }
                    hashMap.put(stringArray[0], "*");
                }
            }
            HashMap<String, String> hashMap2 = hashMap;
            return hashMap2;
        }
        finally {
            logTraceHelper.exit(hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCIMOMUsage(String string) {
        LogTraceHelper logTraceHelper;
        block11: {
            logTraceHelper = LogTraceHelper.entry(this, "registerCIMOMUsage", new Object[]{string});
            if (string != null && string.length() != 0) break block11;
            logTraceHelper.exit("null");
            return;
        }
        try {
            try {
                Map map = stUsedCIMOMs;
                synchronized (map) {
                    Integer n = (Integer)stUsedCIMOMs.get(string);
                    if (n == null) {
                        stUsedCIMOMs.put(string, new Integer(1));
                    } else {
                        n = new Integer(n + 1);
                        stUsedCIMOMs.put(string, n);
                    }
                }
            }
            catch (Throwable throwable) {
                logTraceHelper.traceError("Exception with CIMOM " + string + ": " + throwable.getMessage(), throwable);
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            logTraceHelper.exit("null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deRegisterCIMOMUsage(String string) {
        LogTraceHelper logTraceHelper;
        block14: {
            logTraceHelper = LogTraceHelper.entry(this, "registerCIMOMUsage", new Object[]{string});
            if (string != null && string.length() != 0) break block14;
            logTraceHelper.exit("null");
            return;
        }
        try {
            try {
                int n;
                Map map = stUsedCIMOMs;
                synchronized (map) {
                    Integer n2 = (Integer)stUsedCIMOMs.get(string);
                    if (n2 != null) {
                        n = n2 - 1;
                        if (n == 0) {
                            stUsedCIMOMs.remove(string);
                        } else {
                            stUsedCIMOMs.put(string, new Integer(n));
                        }
                    } else {
                        throw new Exception("Usage Count for CIMOM " + string + " not found!");
                    }
                }
                if (n == 0 && stPendingCIMOMDeletions.contains(string)) {
                    this.processPendingCIMOMDeletion(string);
                }
            }
            catch (Throwable throwable) {
                logTraceHelper.traceError("Exception with CIMOM " + string + ": " + throwable.getMessage(), throwable);
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            logTraceHelper.exit("null");
        }
    }

    public ArrayList getCIMOMtoDevices(String string) throws RemoteException, ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "getCIMOMtoDevices", new Object[]{string});
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        DBConnection dBConnection = null;
        try {
            try {
                ParameterChecker.assertMandatoryParameter(1, "pCimomURLs", string, logTraceHelper);
                dBConnection = ServiceUtils.getConnection();
                if (dBConnection == null) {
                    throw DiskMessageHelper.getServerException("HWN021800E", null, logTraceHelper);
                }
                int n = ExternalKeyManager.getCIMOM(string, dBConnection).getRegCimomId();
                Cimom2namespace[] cimom2namespaceArray = ExternalKeyManager.getCimom2namespace(n, dBConnection);
                SubsystemId subsystemId = null;
                ArrayList arrayList2 = new ArrayList();
                int n2 = 0;
                while (n2 < cimom2namespaceArray.length) {
                    arrayList2.addAll(ExternalKeyManager.getCimKeySubsystem(cimom2namespaceArray[n2].getCimNamespaceId(), dBConnection));
                    ++n2;
                }
                String[] stringArray = new String[arrayList2.size()];
                int n3 = 0;
                while (n3 < arrayList2.size()) {
                    subsystemId = new SubsystemId(((CimkeySubsystem)arrayList2.get(n3)).getName(), ((CimkeySubsystem)arrayList2.get(n3)).getNameFormat());
                    stringArray[n3] = ConversionUtil.convertSubsystemIdToString(subsystemId);
                    ++n3;
                }
                ArrayList arrayList3 = new ArrayList();
                int n4 = 0;
                while (n4 < cimom2namespaceArray.length) {
                    arrayList3.addAll(ExternalKeyManager.getCimkeyTapeLibrary(cimom2namespaceArray[n4].getCimNamespaceId(), dBConnection));
                    ++n4;
                }
                String[] stringArray2 = new String[arrayList3.size()];
                int n5 = 0;
                while (n5 < arrayList3.size()) {
                    subsystemId = new SubsystemId(((CimkeyTapeLibrary)arrayList3.get(n5)).getName(), ((CimkeyTapeLibrary)arrayList3.get(n5)).getNameFormat());
                    stringArray2[n5] = ConversionUtil.convertSubsystemIdToString(subsystemId);
                    ++n5;
                }
                ArrayList arrayList4 = new ArrayList();
                int n6 = 0;
                while (n6 < cimom2namespaceArray.length) {
                    arrayList4.addAll(ExternalKeyManager.getCimkeySwitch(cimom2namespaceArray[n6].getCimNamespaceId(), dBConnection));
                    ++n6;
                }
                String[] stringArray3 = new String[arrayList4.size()];
                int n7 = 0;
                while (n7 < arrayList4.size()) {
                    stringArray3[n7] = ((CimkeySwitch)arrayList4.get(n7)).getSwitchWwn();
                    ++n7;
                }
                n7 = 0;
                while (n7 < stringArray.length) {
                    arrayList.add(new String[]{"Subsystem", stringArray[n7]});
                    ++n7;
                }
                n7 = 0;
                while (n7 < stringArray2.length) {
                    arrayList.add(new String[]{"TapeLibrary", stringArray2[n7]});
                    ++n7;
                }
                n7 = 0;
                while (n7 < stringArray3.length) {
                    arrayList.add(new String[]{"Switch", stringArray3[n7]});
                    ++n7;
                }
            }
            catch (MissingParameterException missingParameterException) {
                throw DiskMessageHelper.getServerException("HWN020002E", (Object)missingParameterException.getMessage(), missingParameterException, logTraceHelper);
            }
            catch (EntityNotFoundException entityNotFoundException) {
                throw DiskMessageHelper.getServerException("HWN021504E", entityNotFoundException.getID(), logTraceHelper);
            }
        }
        finally {
            try {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException("HWN021503E", sQLException.getMessage(), logTraceHelper);
            }
            logTraceHelper.exit(arrayList);
        }
        return arrayList;
    }
}

