/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySubsystem;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySwitch;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyTapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.TapeFrame;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySwitchTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyTapeLibraryTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimom2namespaceTable;
import org.eclipse.aperi.infrastructure.database.tables.TResElementProbeStatusTable;
import org.eclipse.aperi.infrastructure.database.tables.TResRegisteredCimomTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResSwitchTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeFrameTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeLibraryTable;
import org.eclipse.aperi.infrastructure.history.detectability.ChangeDetection;

public class CIMOMSelectorDbHelper {
    private static final short NOT_DETECTABLE = 0;
    private static final short DETECTABLE = 1;

    public static CIMOM getCimom(int n) {
        CIMOM cIMOM = CIMOMManager.getCIMOMManager().getCIMMOMByDBKey(n);
        return cIMOM;
    }

    public static short getCreationClassNameId(String string) throws SQLException {
        DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
        try {
            short s = Normalizer.CreationClassNameGetID(dBConnection, string);
            return s;
        }
        finally {
            if (dBConnection != null) {
                dBConnection.close();
            }
        }
    }

    public static CapabilityData getCapabilityData(int n) throws SQLException {
        DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
        try {
            CapabilityData capabilityData = new CapabilityData();
            capabilityData.setCapabilityDataId(n);
            CapabilityData capabilityData2 = capabilityData.retrieve(dBConnection) ? capabilityData : null;
            return capabilityData2;
        }
        finally {
            if (dBConnection != null) {
                dBConnection.close();
            }
        }
    }

    public static class CIMOMInformation
    implements Comparable {
        private int cId;
        private String cNamespace;
        private int cNamespaceId;
        private short cPriority;

        public CIMOMInformation(int n, int n2, String string, short s) {
            this.cId = n;
            this.cNamespace = string;
            this.cNamespaceId = n2;
            this.cPriority = s;
        }

        public int getId() {
            return this.cId;
        }

        public String getNamespace() {
            return this.cNamespace;
        }

        public int getNamespaceId() {
            return this.cNamespaceId;
        }

        public short getPriority() {
            return this.cPriority;
        }

        public int compareTo(Object object) {
            return this.cPriority - ((CIMOMInformation)object).cPriority;
        }

        public String toString() {
            return "{CimomInfo id=" + Integer.toString(this.cId) + ",ns=" + this.cNamespace + ",ns_id=" + Integer.toString(this.cNamespaceId) + ",prio=" + Short.toString(this.cPriority) + "}";
        }
    }

    public static class Subsystem {
        public static CIMOMInformation[] getCimomInformation(int n) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(TResCimkeySubsystemTable.getColumnInfo("SUBSYSTEM_ID"), Integer.toString(n));
                String string = "SELECT C2N.CIMOM_ID, C2N.NAMESPACE, CKS.CIM_NAMESPACE_ID, CKS.ACTIVE FROM " + TResCimom2namespaceTable.getTablename() + " AS C2N, " + TResCimkeySubsystemTable.getTablename() + " AS CKS, " + TResRegisteredCimomTable.getTablename() + " AS REGCIM WHERE (C2N." + "CIM_NAMESPACE_ID" + "=CKS." + "CIM_NAMESPACE_ID" + " AND CKS." + "SUBSYSTEM_ID" + "=(?) AND CKS." + "ACTIVE" + " IS NOT NULL" + " AND (" + "C2N." + "CIMOM_ID" + " = REGCIM." + "REG_CIMOM_ID" + " AND REGCIM." + "STATUS" + " != " + CIMOMConnectionStatus.PENDING_DELETION.toID() + "))";
                DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, hashtable);
                ArrayList<CIMOMInformation> arrayList = new ArrayList<CIMOMInformation>();
                while (dBResultSet.next()) {
                    CIMOMInformation cIMOMInformation = new CIMOMInformation(dBResultSet.getInt(1), dBResultSet.getInt(3), dBResultSet.getString(2), dBResultSet.getShort(4));
                    arrayList.add(cIMOMInformation);
                }
                dBResultSet.closeAll();
                CIMOMInformation[] cIMOMInformationArray = arrayList.toArray(new CIMOMInformation[arrayList.size()]);
                return cIMOMInformationArray;
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean degradeCimomPriority(int n, int n2) throws SQLException {
            Class<Subsystem> clazz = Subsystem.class;
            synchronized (Subsystem.class) {
                short s = Subsystem.getLowestPriority(n2);
                if (s == Short.MAX_VALUE) {
                    s = Subsystem.resetPriorities(n2);
                }
                s = (short)(s + 1);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Subsystem.setCimomPriority(n, n2, s);
            }
        }

        private static short resetPriorities(int n) throws SQLException {
            Object[] objectArray = Subsystem.getCimomInformation(n);
            Arrays.sort(objectArray);
            int n2 = 0;
            while (n2 < objectArray.length) {
                int n3 = ((CIMOMInformation)objectArray[n2]).getNamespaceId();
                short s = (short)(n2 + 1);
                n2 = s;
                Subsystem.setCimomPriority(n3, n, s);
            }
            return (short)objectArray.length;
        }

        private static boolean setCimomPriority(int n, int n2, short s) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(TResCimkeySubsystemTable.getColumnInfo("ACTIVE"), Short.toString(s));
                hashtable.put(TResCimkeySubsystemTable.getColumnInfo("CIM_NAMESPACE_ID"), Integer.toString(n));
                hashtable.put(TResCimkeySubsystemTable.getColumnInfo("SUBSYSTEM_ID"), Integer.toString(n2));
                String string = "UPDATE " + TResCimkeySubsystemTable.getTablename() + " SET " + "ACTIVE" + "=(?) WHERE (" + "CIM_NAMESPACE_ID" + "=(?) AND " + "SUBSYSTEM_ID" + "=(?))";
                int n3 = ComplexQuery.sqlUpdate(dBConnection, string, hashtable);
                if (!dBConnection.getAutoCommit()) {
                    dBConnection.commit();
                }
                boolean bl = n3 == 1;
                return bl;
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }

        private static short getLowestPriority(int n) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(TResCimkeySubsystemTable.getColumnInfo("SUBSYSTEM_ID"), Integer.toString(n));
                String string = "SELECT COUNT(*), MAX(ACTIVE) FROM " + TResCimkeySubsystemTable.getTablename() + " WHERE (" + "SUBSYSTEM_ID" + "=(?) AND " + "ACTIVE" + " IS NOT NULL)";
                DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, hashtable);
                short s = dBResultSet.next() && dBResultSet.getInt(1) > 0 ? dBResultSet.getShort(2) : (short)0;
                dBResultSet.closeAll();
                short s2 = s;
                return s2;
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }

        public static CimkeySubsystem getCimNamespaceMapping(int n, int n2) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                CimkeySubsystem cimkeySubsystem = new CimkeySubsystem();
                cimkeySubsystem.setSubsystemId(n);
                cimkeySubsystem.setCimNamespaceId(n2);
                CimkeySubsystem cimkeySubsystem2 = cimkeySubsystem.retrieve(dBConnection) ? cimkeySubsystem : null;
                return cimkeySubsystem2;
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }

        public static int getCorrespondingCapabilityDataId(int n, int n2) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(TResCimkeySubsystemTable.getColumnInfo("SUBSYSTEM_ID"), Integer.toString(n2));
                hashtable.put(TResCimkeySubsystemTable.getColumnInfo("CIM_NAMESPACE_ID"), Integer.toString(n));
                String string = "SELECT CAPABILITY_DATA_ID FROM " + TResCimkeySubsystemTable.getTablename() + " WHERE (" + "CIM_NAMESPACE_ID" + "=(?) AND " + "SUBSYSTEM_ID" + "=(?))";
                DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, hashtable);
                try {
                    if (dBResultSet.next() && dBResultSet.getInt(1) != 0) {
                        int n3 = dBResultSet.getInt(1);
                        return n3;
                    }
                    throw new IllegalArgumentException("No record existing in " + TResCimkeySubsystemTable.getTablename() + " for this namespace-subsystem combination.");
                }
                finally {
                    dBResultSet.closeAll();
                }
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }

        public static StorageSubsystem getSubsystem(int n) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                DBResultSet dBResultSet;
                block8: {
                    StorageSubsystemWrapper storageSubsystemWrapper;
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(TResStorageSubsystemTable.getColumnInfo("SUBSYSTEM_ID"), Integer.toString(n));
                    dBResultSet = DBQueryAssistant.performRetrieve(TResStorageSubsystemTable.getTablename(), dBConnection, hashtable, null);
                    try {
                        if (!dBResultSet.next()) break block8;
                        StorageSubsystemWrapper storageSubsystemWrapper2 = new StorageSubsystemWrapper();
                        storageSubsystemWrapper2.setFieldsFromDbRow(dBConnection, dBResultSet);
                        storageSubsystemWrapper = storageSubsystemWrapper2;
                    }
                    catch (Throwable throwable) {
                        dBResultSet.closeAll();
                        throw throwable;
                    }
                    dBResultSet.closeAll();
                    return storageSubsystemWrapper;
                }
                dBResultSet.closeAll();
                return null;
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }

        public static void setMissing(int n) throws SQLException {
            StorageSubsystem storageSubsystem = Subsystem.getSubsystem(n);
            if (storageSubsystem.getDetectable() != 0) {
                Subsystem.updateDetectable(storageSubsystem.getName(), storageSubsystem.getNameFormat(), (short)0);
            }
        }

        public static void setVisible(int n) throws SQLException {
            StorageSubsystem storageSubsystem = Subsystem.getSubsystem(n);
            if (storageSubsystem.getDetectable() != 1) {
                Subsystem.updateDetectable(storageSubsystem.getName(), storageSubsystem.getNameFormat(), (short)1);
            }
        }

        private static void updateDetectable(String string, short s, short s2) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                StorageSubsystem storageSubsystem = new StorageSubsystem();
                storageSubsystem.setName(string);
                storageSubsystem.setNameFormat(s);
                storageSubsystem.setDetectable(s2);
                storageSubsystem.setChangedTimestamp(new Timestamp(new Date().getTime()));
                storageSubsystem.update(dBConnection);
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }
    }

    public static class Switch {
        public static CIMOMInformation[] getCimomInformation(String string) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(TResCimkeySwitchTable.getColumnInfo("SWITCH_WWN"), string);
                String string2 = "SELECT C2N.CIMOM_ID, C2N.NAMESPACE, CKS.CIM_NAMESPACE_ID, CKS.ACTIVE FROM " + TResCimom2namespaceTable.getTablename() + " AS C2N, " + TResCimkeySwitchTable.getTablename() + " AS CKS WHERE (C2N." + "CIM_NAMESPACE_ID" + "=CKS." + "CIM_NAMESPACE_ID" + " AND CKS." + "SWITCH_WWN" + "=(?) AND CKS." + "ACTIVE" + " IS NOT NULL)";
                DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string2, hashtable);
                ArrayList<CIMOMInformation> arrayList = new ArrayList<CIMOMInformation>();
                while (dBResultSet.next()) {
                    CIMOMInformation cIMOMInformation = new CIMOMInformation(dBResultSet.getInt(1), dBResultSet.getInt(3), dBResultSet.getString(2), dBResultSet.getShort(4));
                    arrayList.add(cIMOMInformation);
                }
                dBResultSet.closeAll();
                CIMOMInformation[] cIMOMInformationArray = arrayList.toArray(new CIMOMInformation[arrayList.size()]);
                return cIMOMInformationArray;
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }

        public static CimkeySwitch getCimNamespaceMapping(String string, int n) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                CimkeySwitch cimkeySwitch = new CimkeySwitch();
                cimkeySwitch.setSwitchWwn(string);
                cimkeySwitch.setCimNamespaceId(n);
                CimkeySwitch cimkeySwitch2 = cimkeySwitch.retrieve(dBConnection) ? cimkeySwitch : null;
                return cimkeySwitch2;
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean degradeCimomPriority(int n, String string) throws SQLException {
            Class<Switch> clazz = Switch.class;
            synchronized (Switch.class) {
                short s = Switch.getLowestPriority(string);
                if (s == Short.MAX_VALUE) {
                    s = Switch.resetPriorities(string);
                }
                s = (short)(s + 1);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Switch.setCimomPriority(n, string, s);
            }
        }

        private static short resetPriorities(String string) throws SQLException {
            Object[] objectArray = Switch.getCimomInformation(string);
            Arrays.sort(objectArray);
            int n = 0;
            while (n < objectArray.length) {
                int n2 = ((CIMOMInformation)objectArray[n]).getNamespaceId();
                short s = (short)(n + 1);
                n = s;
                Switch.setCimomPriority(n2, string, s);
            }
            return (short)objectArray.length;
        }

        private static boolean setCimomPriority(int n, String string, short s) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(TResCimkeySwitchTable.getColumnInfo("ACTIVE"), Short.toString(s));
                hashtable.put(TResCimkeySwitchTable.getColumnInfo("CIM_NAMESPACE_ID"), Integer.toString(n));
                hashtable.put(TResCimkeySwitchTable.getColumnInfo("SWITCH_WWN"), string);
                String string2 = "UPDATE " + TResCimkeySwitchTable.getTablename() + " SET " + "ACTIVE" + "=(?) WHERE (" + "CIM_NAMESPACE_ID" + "=(?) AND " + "SWITCH_WWN" + "=(?))";
                int n2 = ComplexQuery.sqlUpdate(dBConnection, string2, hashtable);
                if (!dBConnection.getAutoCommit()) {
                    dBConnection.commit();
                }
                boolean bl = n2 == 1;
                return bl;
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }

        private static short getLowestPriority(String string) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(TResCimkeySwitchTable.getColumnInfo("SWITCH_WWN"), string);
                String string2 = "SELECT COUNT(*), MAX(ACTIVE) FROM " + TResCimkeySwitchTable.getTablename() + " WHERE (" + "SWITCH_WWN" + "=(?) AND " + "ACTIVE" + " IS NOT NULL)";
                DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string2, hashtable);
                short s = dBResultSet.next() && dBResultSet.getInt(1) > 0 ? dBResultSet.getShort(2) : (short)0;
                dBResultSet.closeAll();
                short s2 = s;
                return s2;
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }

        public static org.eclipse.aperi.infrastructure.database.objects.Switch getSwitch(String string) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                org.eclipse.aperi.infrastructure.database.objects.Switch switch_ = new org.eclipse.aperi.infrastructure.database.objects.Switch();
                switch_.setSwitchWwn(string);
                org.eclipse.aperi.infrastructure.database.objects.Switch switch_2 = switch_.retrieve(dBConnection) ? switch_ : null;
                return switch_2;
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }

        private static LinkedList getMissingSwitches(DBConnection dBConnection, String string) throws SQLException {
            String string2 = "SELECT ELEMENT_ID FROM " + TResElementProbeStatusTable.getTablename() + " WHERE " + "PROBE_FOUND" + "=1 AND " + "ELEMENT_ID" + " IN (SELECT " + "SWITCH_ID" + " FROM " + TResSwitchTable.getTablename() + " , " + TResCimkeySwitchTable.getTablename() + " WHERE " + TResCimkeySwitchTable.getTablename() + "." + "SWITCH_WWN" + "=" + TResSwitchTable.getTablename() + "." + "SWITCH_WWN" + " AND " + TResCimkeySwitchTable.getTablename() + "." + "SWITCH_WWN" + " = (?) " + ")";
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            hashtable.put(TResCimkeySwitchTable.getColumnInfo("SWITCH_WWN"), string);
            DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string2, hashtable);
            if (dBResultSet.next()) {
                dBResultSet.close();
                return new LinkedList();
            }
            String string3 = "SELECT ELEMENT_ID FROM " + TResElementProbeStatusTable.getTablename() + " WHERE " + "PROBE_FOUND" + "!=1 AND " + "ELEMENT_ID" + " IN (SELECT " + "SWITCH_ID" + " FROM " + TResSwitchTable.getTablename() + " , " + TResCimkeySwitchTable.getTablename() + " WHERE " + TResCimkeySwitchTable.getTablename() + "." + "SWITCH_WWN" + "=" + TResSwitchTable.getTablename() + "." + "SWITCH_WWN" + " AND " + TResCimkeySwitchTable.getTablename() + "." + "SWITCH_WWN" + " = (?) " + ")";
            Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
            hashtable2.put(TResCimkeySwitchTable.getColumnInfo("SWITCH_WWN"), string);
            DBResultSet dBResultSet2 = ComplexQuery.sqlQuery(dBConnection, string3, hashtable2);
            LinkedList<String> linkedList = new LinkedList<String>();
            while (dBResultSet2.next()) {
                linkedList.add(dBResultSet2.getString(1));
            }
            dBResultSet2.close();
            return linkedList;
        }

        private static String convertLinkedListToCommaSeparatedString(LinkedList linkedList) {
            String string = "";
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                string = String.valueOf(string) + (String)iterator.next();
                string = String.valueOf(string) + ",";
            }
            if (string.indexOf(",") >= 0) {
                string = string.substring(0, string.length() - 1);
            }
            return string;
        }

        public static void setMissing(String string) throws SQLException {
            LogTraceHelper logTraceHelper = LogTraceHelper.entry(Switch.class, "setMissing", new Object[]{string});
            HashMap<String, LinkedList> hashMap = new HashMap<String, LinkedList>();
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                try {
                    LinkedList linkedList = Switch.getMissingSwitches(dBConnection, string);
                    if (!linkedList.isEmpty()) {
                        String string2 = Switch.convertLinkedListToCommaSeparatedString(linkedList);
                        String string3 = "UPDATE " + TResSwitchTable.getTablename() + " SET " + "DETECTABLE" + "=0 WHERE " + "SWITCH_ID" + " IN (" + string2 + ")";
                        ComplexQuery.sqlUpdate(dBConnection, string3, null);
                        hashMap.put(TResSwitchTable.getTablename(), linkedList);
                        if (!hashMap.isEmpty()) {
                            String string4 = "S" + CIMOMManager.getUniqueNumberString();
                            ChangeDetection changeDetection = new ChangeDetection(dBConnection);
                            changeDetection.complete(dBConnection, hashMap, string4);
                            ServiceUtils.getEventMonitorProxy().handleModelUpdate(string4);
                        }
                        if (!dBConnection.getAutoCommit()) {
                            dBConnection.commit();
                        }
                    }
                }
                catch (Exception exception) {
                    logTraceHelper.traceError("Failed to set Switch Missing for Switch" + string + ".Rolling back", exception);
                    dBConnection.rollback();
                }
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }

        public static void setVisible(String string) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                org.eclipse.aperi.infrastructure.database.objects.Switch switch_ = new org.eclipse.aperi.infrastructure.database.objects.Switch();
                switch_.setSwitchWwn(string);
                switch_.setDetectable((short)1);
                switch_.update(dBConnection);
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }
    }

    public static class Tape {
        public static CIMOMInformation[] getCimomInformation(int n) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(TResCimkeyTapeLibraryTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(n));
                String string = "SELECT C2N.CIMOM_ID, C2N.NAMESPACE, CKS.CIM_NAMESPACE_ID, CKS.ACTIVE FROM " + TResCimom2namespaceTable.getTablename() + " AS C2N, " + TResCimkeyTapeLibraryTable.getTablename() + " AS CKS WHERE (C2N." + "CIM_NAMESPACE_ID" + "=CKS." + "CIM_NAMESPACE_ID" + " AND CKS." + "TAPE_LIBRARY_ID" + "=(?) AND CKS." + "ACTIVE" + " IS NOT NULL)";
                DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, hashtable);
                ArrayList<CIMOMInformation> arrayList = new ArrayList<CIMOMInformation>();
                while (dBResultSet.next()) {
                    CIMOMInformation cIMOMInformation = new CIMOMInformation(dBResultSet.getInt(1), dBResultSet.getInt(3), dBResultSet.getString(2), dBResultSet.getShort(4));
                    arrayList.add(cIMOMInformation);
                }
                dBResultSet.closeAll();
                CIMOMInformation[] cIMOMInformationArray = arrayList.toArray(new CIMOMInformation[arrayList.size()]);
                return cIMOMInformationArray;
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean degradeCimomPriority(int n, int n2) throws SQLException {
            Class<Tape> clazz = Tape.class;
            synchronized (Tape.class) {
                short s = Tape.getLowestPriority(n2);
                if (s == Short.MAX_VALUE) {
                    s = Tape.resetPriorities(n2);
                }
                s = (short)(s + 1);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Tape.setCimomPriority(n, n2, s);
            }
        }

        private static short resetPriorities(int n) throws SQLException {
            Object[] objectArray = Tape.getCimomInformation(n);
            Arrays.sort(objectArray);
            int n2 = 0;
            while (n2 < objectArray.length) {
                int n3 = ((CIMOMInformation)objectArray[n2]).getNamespaceId();
                short s = (short)(n2 + 1);
                n2 = s;
                Tape.setCimomPriority(n3, n, s);
            }
            return (short)objectArray.length;
        }

        private static boolean setCimomPriority(int n, int n2, short s) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(TResCimkeyTapeLibraryTable.getColumnInfo("ACTIVE"), Short.toString(s));
                hashtable.put(TResCimkeyTapeLibraryTable.getColumnInfo("CIM_NAMESPACE_ID"), Integer.toString(n));
                hashtable.put(TResCimkeyTapeLibraryTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(n2));
                String string = "UPDATE " + TResCimkeyTapeLibraryTable.getTablename() + " SET " + "ACTIVE" + "=(?) WHERE (" + "CIM_NAMESPACE_ID" + "=(?) AND " + "TAPE_LIBRARY_ID" + "=(?))";
                int n3 = ComplexQuery.sqlUpdate(dBConnection, string, hashtable);
                if (!dBConnection.getAutoCommit()) {
                    dBConnection.commit();
                }
                boolean bl = n3 == 1;
                return bl;
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }

        private static short getLowestPriority(int n) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(TResCimkeyTapeLibraryTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(n));
                String string = "SELECT COUNT(*), MAX(ACTIVE) FROM " + TResCimkeyTapeLibraryTable.getTablename() + " WHERE (" + "TAPE_LIBRARY_ID" + "=(?) AND " + "ACTIVE" + " IS NOT NULL)";
                DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, hashtable);
                short s = dBResultSet.next() && dBResultSet.getInt(1) > 0 ? dBResultSet.getShort(2) : (short)0;
                dBResultSet.closeAll();
                short s2 = s;
                return s2;
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }

        public static CimkeyTapeLibrary getCimNamespaceMapping(int n, int n2) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                CimkeyTapeLibrary cimkeyTapeLibrary = new CimkeyTapeLibrary();
                cimkeyTapeLibrary.setTapeLibraryId(n);
                cimkeyTapeLibrary.setCimNamespaceId(n2);
                CimkeyTapeLibrary cimkeyTapeLibrary2 = cimkeyTapeLibrary.retrieve(dBConnection) ? cimkeyTapeLibrary : null;
                return cimkeyTapeLibrary2;
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }

        public static int getCorrespondingCapabilityDataId(int n, int n2) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(TResCimkeyTapeLibraryTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(n2));
                hashtable.put(TResCimkeyTapeLibraryTable.getColumnInfo("CIM_NAMESPACE_ID"), Integer.toString(n));
                String string = "SELECT CAPABILITY_DATA_ID FROM " + TResCimkeyTapeLibraryTable.getTablename() + " WHERE (" + "CIM_NAMESPACE_ID" + "=(?) AND " + "TAPE_LIBRARY_ID" + "=(?))";
                DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, hashtable);
                try {
                    if (dBResultSet.next() && dBResultSet.getInt(1) != 0) {
                        int n3 = dBResultSet.getInt(1);
                        return n3;
                    }
                    throw new IllegalArgumentException("No record existing in " + TResCimkeyTapeLibraryTable.getTablename() + " for this namespace-subsystem combination.");
                }
                finally {
                    dBResultSet.closeAll();
                }
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }

        public static TapeLibrary getTapeLibrary(int n) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                DBResultSet dBResultSet;
                block8: {
                    TapeLibraryWrapper tapeLibraryWrapper;
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(TResTapeLibraryTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(n));
                    dBResultSet = DBQueryAssistant.performRetrieve(TResTapeLibraryTable.getTablename(), dBConnection, hashtable, null);
                    try {
                        if (!dBResultSet.next()) break block8;
                        TapeLibraryWrapper tapeLibraryWrapper2 = new TapeLibraryWrapper();
                        tapeLibraryWrapper2.setFieldsFromDbRow(dBConnection, dBResultSet);
                        tapeLibraryWrapper = tapeLibraryWrapper2;
                    }
                    catch (Throwable throwable) {
                        dBResultSet.closeAll();
                        throw throwable;
                    }
                    dBResultSet.closeAll();
                    return tapeLibraryWrapper;
                }
                dBResultSet.closeAll();
                return null;
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }

        public static TapeFrame getTapeFrame(int n) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                DBResultSet dBResultSet;
                block8: {
                    TapeFrameWrapper tapeFrameWrapper;
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(TResTapeFrameTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(n));
                    dBResultSet = DBQueryAssistant.performRetrieve(TResTapeFrameTable.getTablename(), dBConnection, hashtable, null);
                    try {
                        if (!dBResultSet.next()) break block8;
                        TapeFrameWrapper tapeFrameWrapper2 = new TapeFrameWrapper();
                        tapeFrameWrapper2.setFieldsFromDbRow(dBConnection, dBResultSet);
                        tapeFrameWrapper = tapeFrameWrapper2;
                    }
                    catch (Throwable throwable) {
                        dBResultSet.closeAll();
                        throw throwable;
                    }
                    dBResultSet.closeAll();
                    return tapeFrameWrapper;
                }
                dBResultSet.closeAll();
                return null;
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }

        public static void setMissing(int n) throws SQLException {
            TapeLibrary tapeLibrary = Tape.getTapeLibrary(n);
            if (tapeLibrary.getDetectable() != 0) {
                Tape.updateDetectable(tapeLibrary.getName(), tapeLibrary.getNameFormat(), (short)0);
            }
        }

        public static void setVisible(int n) throws SQLException {
            TapeLibrary tapeLibrary = Tape.getTapeLibrary(n);
            if (tapeLibrary.getDetectable() != 1) {
                Tape.updateDetectable(tapeLibrary.getName(), tapeLibrary.getNameFormat(), (short)1);
            }
        }

        private static void updateDetectable(String string, short s, short s2) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                TapeLibrary tapeLibrary = new TapeLibrary();
                tapeLibrary.setName(string);
                tapeLibrary.setNameFormat(s);
                tapeLibrary.setDetectable(s2);
                tapeLibrary.setChangedTimestamp(new Timestamp(new Date().getTime()));
                tapeLibrary.update(dBConnection);
            }
            finally {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
        }
    }

    public static class StorageSubsystemWrapper
    extends StorageSubsystem {
        public void setFieldsFromDbRow(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
            this.setFields(dBConnection, dBResultSet);
        }
    }

    public static class TapeLibraryWrapper
    extends TapeLibrary {
        public void setFieldsFromDbRow(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
            this.setFields(dBConnection, dBResultSet);
        }
    }

    public static class TapeFrameWrapper
    extends TapeFrame {
        public void setFieldsFromDbRow(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
            this.setFields(dBConnection, dBResultSet);
        }
    }
}

