/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.log;

import com.ibm.log.Level;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.control.data.JobInfo;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.common.log.LogTraceHelperFactory;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.Reusable;
import org.eclipse.aperi.disk.resources.DMJobMessages;
import org.eclipse.aperi.sanmgmt.logging.ILogger;

public class LogTraceHelper
implements Reusable {
    private String cJobID = null;
    private long[] cReqID = new long[]{Long.MIN_VALUE, Long.MIN_VALUE};
    private long cExecID = Long.MIN_VALUE;
    private String cCtxtID = null;
    private Request cDiscoverRequest = null;
    private Token cCtrlToken = null;
    private String cClass = null;
    private String cMethodName = null;
    private long cStartTS = -1L;
    private long cEndTS = -1L;
    private boolean cInPool = false;
    private ILogger cJobLogger = null;
    private String cInvokationParms = null;

    protected LogTraceHelper(String string, Object object, String string2, Request request, Token token, long[] lArray) {
        this.initializeInstance(string, object, string2, request, token, lArray);
    }

    public final void initializeInstance(String string, Object object, String string2, Request request, Token token, long[] lArray) {
        if (string != null) {
            this.cJobID = string;
        }
        if (request != null) {
            this.cDiscoverRequest = request;
            this.cJobID = Integer.toString(this.cDiscoverRequest.getId());
            this.cJobLogger = request.getJobLogger();
            if (this.cJobLogger != null) {
                this.cJobLogger.setMessageFile(DMJobMessages.class.getName());
            }
        } else if (token != null) {
            this.cCtrlToken = token;
            this.cJobID = this.cCtrlToken.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(this.cJobID);
            if (jobInfo != null) {
                this.cJobLogger = jobInfo.getJobLogger();
                if (this.cJobLogger != null) {
                    this.cJobLogger.setMessageFile(DMJobMessages.class.getName());
                }
            }
        }
        this.cClass = object instanceof String ? (String)object : object.getClass().getName();
        this.cMethodName = string2;
        if (this.cJobID == null) {
            this.cJobID = "" + LogTraceHelperFactory.getInternalRequestID();
        }
        this.cReqID = lArray;
        this.cExecID = LogTraceHelperFactory.getInternalExecID();
        this.cStartTS = System.currentTimeMillis();
    }

    public void clearInstance() {
        this.cJobID = null;
        this.cClass = String.valueOf(this.cClass) + "(pooled)";
        this.cMethodName = String.valueOf(this.cMethodName) + "(pooled)";
        this.cDiscoverRequest = null;
        this.cCtrlToken = null;
        this.cJobLogger = null;
        this.cStartTS = -1L;
        this.cEndTS = -1L;
        this.cReqID = null;
        this.cExecID = Long.MIN_VALUE;
        this.cCtxtID = null;
    }

    public void releaseInstance() {
    }

    public boolean isInPool() {
        return this.cInPool;
    }

    public void setIsInPool(boolean bl) {
        this.cInPool = bl;
    }

    public static final LogTraceHelper entry(String string, Object object, String string2, Object[] objectArray) {
        LogTraceHelper logTraceHelper = LogTraceHelperFactory.getLTHelper(string, object, string2, null, null);
        logTraceHelper.logEntry(objectArray);
        return logTraceHelper;
    }

    public static LogTraceHelper entry(Object object, String string, Object[] objectArray) {
        return LogTraceHelper.entry(null, object, string, objectArray);
    }

    public static final LogTraceHelper entry(Token token, Object object, String string, Object[] objectArray) {
        if (token == null) {
            return LogTraceHelper.entry(object, string, objectArray);
        }
        LogTraceHelper logTraceHelper = LogTraceHelperFactory.getLTHelper(null, object, string, null, token);
        logTraceHelper.logEntry(objectArray);
        return logTraceHelper;
    }

    public static final LogTraceHelper entry(Request request, Object object, String string, Object[] objectArray) {
        LogTraceHelper logTraceHelper = LogTraceHelperFactory.getLTHelper(null, object, string, request, null);
        logTraceHelper.logEntry(objectArray);
        return logTraceHelper;
    }

    private final void logEntry(Object[] objectArray) {
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        LogTraceHelperFactory.getDMTrcLogger().text(Level.DEBUG_MAX, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099995I", new Object[]{this.cClass, this.cMethodName, DiskMessageHelper.toMsgString(objectArray), this.getContextInfo()}));
    }

    public void exit(Object object) {
        this.cEndTS = System.currentTimeMillis();
        if (LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            LogTraceHelperFactory.getDMTrcLogger().text(Level.DEBUG_MAX, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099996I", new Object[]{this.cClass, this.cMethodName, DiskMessageHelper.toMsgString(object), new Long(this.cEndTS - this.cStartTS), this.getContextInfo()}));
        }
        if (!this.isInPool()) {
            LogTraceHelperFactory.returnInstance(this);
        }
    }

    public void logMsg(String string, Object[] objectArray) {
        LogTraceHelperFactory.getDMTrcLogger().text(Level.OFF, this.cClass, this.cMethodName, String.valueOf(LogTraceHelperFactory.resolveAPIMessage(string, objectArray)) + " @(" + this.getContextInfo() + ")");
        if (this.cJobLogger != null) {
            this.cJobLogger.message(LogTraceHelper.extractLevel(string), (Object)this.cClass, this.cMethodName, string, objectArray);
        } else {
            this.logDMMsgRecord(string, objectArray);
        }
    }

    public void traceInfo(String string) {
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        LogTraceHelperFactory.getDMTrcLogger().text(Level.INFO, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099991I", new Object[]{string, this.getContextInfo()}));
    }

    public void traceAlways(String string) {
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            System.out.println("DiskManagerTrace: " + LogTraceHelperFactory.resolveMessage("HWN099991I", new Object[]{string, this.getContextInfo()}) + " " + this.cClass + " " + this.cMethodName);
        }
        LogTraceHelperFactory.getDMTrcLogger().text(Level.OFF, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099991I", new Object[]{string, this.getContextInfo()}));
    }

    public void traceHigh(String string) {
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        LogTraceHelperFactory.getDMTrcLogger().text(Level.DEBUG_MAX, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099991I", new Object[]{string, this.getContextInfo()}));
    }

    public void traceWarning(String string) {
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        LogTraceHelperFactory.getDMTrcLogger().text(Level.WARN, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099992W", new Object[]{string, this.getContextInfo()}));
    }

    public void traceSvcEntry(String string, Object[] objectArray) {
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        LogTraceHelperFactory.getDMTrcLogger().text(Level.DEBUG_MIN, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099997I", new Object[]{string, DiskMessageHelper.toMsgString(objectArray), this.getContextInfo()}));
    }

    public void traceSvcReturn(String string, Object object) {
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        LogTraceHelperFactory.getDMTrcLogger().text(Level.DEBUG_MIN, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099998I", new Object[]{string, DiskMessageHelper.toMsgString(object), this.getContextInfo()}));
    }

    public void objectCreation(String string) {
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        LogTraceHelperFactory.getDMTrcLogger().text(Level.DEBUG_MAX, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099994I", new Object[]{string, this.getContextInfo()}));
    }

    public void traceError(String string, Throwable throwable) {
        if (throwable != null) {
            LogTraceHelperFactory.getDMTrcLogger().exception(Level.ERROR, this.cClass, this.cMethodName, throwable, LogTraceHelperFactory.resolveMessage("HWN099993E", new Object[]{string, this.getContextInfo()}));
        } else {
            LogTraceHelperFactory.getDMTrcLogger().text(Level.ERROR, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099993E", new Object[]{string, this.getContextInfo()}));
        }
    }

    private final void logDMMsgRecord(String string, Object[] objectArray) {
        if (!LogTraceHelperFactory.getDMMsgLogger().isLogging()) {
            return;
        }
        LogTraceHelperFactory.getDMMsgLogger().message(LogTraceHelper.extractLevel(string), (Object)this.cClass, this.cMethodName, string, objectArray);
    }

    private static final Level extractLevel(String string) {
        if (string == null || string.length() != 10) {
            throw new IllegalArgumentException("Not a valid message ID: " + string);
        }
        char c = string.charAt(9);
        switch (Character.getNumericValue(c)) {
            case 14: {
                return Level.ERROR;
            }
            case 32: {
                return Level.WARN;
            }
            case 18: {
                return Level.INFO;
            }
        }
        throw new IllegalArgumentException("Not a valid message ID: " + string);
    }

    public final boolean isTraceHighEnabled() {
        return LogTraceHelperFactory.getDMTrcLogger().isLoggable(Level.DEBUG_MAX);
    }

    public void traceDMInvokation(Object[] objectArray) {
        this.cInvokationParms = DiskMessageHelper.toMsgString(objectArray);
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        LogTraceHelperFactory.getDMTrcLogger().text(Level.OFF, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099999I", new Object[]{this.cMethodName, DiskMessageHelper.toMsgString(objectArray), this.getContextInfo()}));
    }

    public void traceDMReturn(Object object) {
        this.logAuditMsg(this.cInvokationParms, object);
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        LogTraceHelperFactory.getDMTrcLogger().text(Level.OFF, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099990I", new Object[]{this.cMethodName, DiskMessageHelper.toMsgString(object), this.getContextInfo()}));
    }

    private final String getContextInfo() {
        if (this.cCtxtID == null) {
            if (this.cReqID == null) {
                this.cCtxtID = "Invalid usage of LogTraceHelper. exit() called before calling trace function.";
            } else {
                StringBuffer stringBuffer = new StringBuffer(50);
                stringBuffer.append(this.cExecID).append(';');
                stringBuffer.append('[').append(this.cReqID[0]).append(',').append(this.cReqID[1]).append(',').append(this.cReqID[2]).append(']');
                stringBuffer.append(';').append(this.cJobID).append(';');
                stringBuffer.append(Thread.currentThread().getName());
                this.cCtxtID = stringBuffer.toString();
            }
        }
        return this.cCtxtID;
    }

    private final void logAuditMsg(String string, Object object) {
        if (object instanceof AsyncResult) {
            ServiceUtils.recordInAuditLog("DiskManagerService", this.cMethodName, string, (AsyncResult)object);
        } else {
            ServiceUtils.recordInAuditLog("DiskManagerService", this.cMethodName, string, DiskMessageHelper.toMsgString(object));
        }
    }

    public void traceARMPoint(String string) {
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        long l = System.currentTimeMillis() - this.cStartTS;
        LogTraceHelperFactory.getDMTrcLogger().text(Level.DEBUG_MAX, this.cClass, this.cMethodName, "HWN100000I ARM point " + string + " reached. (" + l + ") @(" + this.getContextInfo() + ")");
    }

    public void traceCallStack() {
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        Exception exception = new Exception();
        exception.fillInStackTrace();
        LogTraceHelperFactory.getDMTrcLogger().text(Level.DEBUG_MAX, this.cClass, this.cMethodName, "HWN100001I CallStack @(" + this.getContextInfo() + ")\n" + DiskMessageHelper.toMsgString(exception.getStackTrace()));
    }
}

