/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.log;

import com.ibm.log.Level;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.InstancePool;
import org.eclipse.aperi.disk.resources.APIMessages;
import org.eclipse.aperi.disk.resources.DMTraceMessages;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public final class LogTraceHelperFactory
extends InstancePool {
    private static LogTraceHelperFactory stSingletonInstance = null;
    private ILogger cMsgLogger = null;
    private ILogger cTrcLogger = null;
    private ResourceBundle cTraceMsgBundle = null;
    private ResourceBundle cAPIMsgBundle = null;
    private ThreadLocal cReqID = null;
    private long cReqCounter = Long.MIN_VALUE;
    private long cExecCounter = Long.MIN_VALUE;

    static {
        stSingletonInstance = new LogTraceHelperFactory();
    }

    private LogTraceHelperFactory() {
        super(DiskManagerConfigSvc.getIntConfigValue("LogTraceHelper.PoolSize", 250));
        this.cTraceMsgBundle = ResourceBundle.getBundle(DMTraceMessages.class.getName(), Locale.getDefault());
        this.cAPIMsgBundle = ResourceBundle.getBundle(APIMessages.class.getName(), Locale.US);
        this.setupLogging();
        this.cReqID = new ThreadLocal();
    }

    private static LogTraceHelperFactory get() {
        return stSingletonInstance;
    }

    private void setupLogging() {
        this.cMsgLogger = LogManagerFactory.getMessageLogger("aperi.logger.message.DiskManager");
        this.cMsgLogger.setMessageFile(APIMessages.class.getName());
        this.cTrcLogger = LogManagerFactory.getMessageLogger("aperi.logger.trace.DiskManager");
    }

    public static LogTraceHelper getLTHelper(String string, Object object, String string2, Request request, Token token) {
        LogTraceHelper logTraceHelper = (LogTraceHelper)LogTraceHelperFactory.get().getClearInstance();
        long[] lArray = (long[])LogTraceHelperFactory.get().cReqID.get();
        if (lArray == null) {
            long[] lArray2 = new long[3];
            lArray2[0] = LogTraceHelperFactory.getInternalRequestID();
            lArray = lArray2;
        } else {
            lArray[2] = lArray[2] + 1L;
        }
        LogTraceHelperFactory.registerReqCtxt(lArray);
        if (logTraceHelper != null) {
            if (logTraceHelper.isInPool()) {
                logTraceHelper.traceWarning("Using pooled instance of LogTraceHelper");
            }
            logTraceHelper.initializeInstance(string, object, string2, request, token, lArray);
            return logTraceHelper;
        }
        return new LogTraceHelper(string, object, string2, request, token, lArray);
    }

    public static void returnInstance(LogTraceHelper logTraceHelper) {
        LogTraceHelperFactory.deregisterReqCtxt();
        LogTraceHelperFactory.get().returnInst(logTraceHelper);
    }

    protected static ILogger getDMMsgLogger() {
        return LogTraceHelperFactory.get().cMsgLogger;
    }

    protected static ILogger getDMTrcLogger() {
        return LogTraceHelperFactory.get().cTrcLogger;
    }

    public static String resolveMessage(String string, Object[] objectArray) {
        String string2 = LogTraceHelperFactory.get().cTraceMsgBundle.getString(string);
        if (string2 == null) {
            return String.valueOf(string) + "(not resolvable): " + DiskMessageHelper.toMsgString(objectArray);
        }
        return MessageFormat.format(string2, objectArray);
    }

    public static String resolveAPIMessage(String string, Object[] objectArray) {
        String string2 = LogTraceHelperFactory.get().cAPIMsgBundle.getString(string);
        if (string2 == null) {
            return String.valueOf(string) + "(not resolvable): " + DiskMessageHelper.toMsgString(objectArray);
        }
        return "Msg: " + MessageFormat.format(string2, objectArray);
    }

    protected static long getInternalRequestID() {
        return ++LogTraceHelperFactory.get().cReqCounter;
    }

    protected static long getInternalExecID() {
        return ++LogTraceHelperFactory.get().cExecCounter;
    }

    private static void registerReqCtxt(long[] lArray) {
        LogTraceHelperFactory.get().cReqID.set(lArray);
    }

    private static void deregisterReqCtxt() {
        try {
            long[] lArray = (long[])LogTraceHelperFactory.get().cReqID.get();
            if (lArray != null) {
                if (lArray[2] > 0L) {
                    lArray[2] = lArray[2] - 1L;
                    LogTraceHelperFactory.get().cReqID.set(lArray);
                } else {
                    LogTraceHelperFactory.get().cReqID.set(null);
                }
            } else {
                ILogger iLogger = LogTraceHelperFactory.getDMTrcLogger();
                if (iLogger != null && iLogger.isLogging()) {
                    iLogger.text(Level.WARN, "LogTraceHelperFactory", "deregisterReqCtxt", LogTraceHelperFactory.resolveMessage("HWN099992W", new Object[]{"Request context was already deregistered", "0;[0,0,0];0;" + Thread.currentThread().getName()}));
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Error during LogTraceHelperFactory.deregisterReqCtxt()");
            exception.printStackTrace();
        }
    }
}

