/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.lang.reflect.Array;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;

public class ParameterChecker {
    public static void assertMandatoryParameter(int n, String string, Object object, LogTraceHelper logTraceHelper) throws MissingParameterException {
        if (object == null) {
            throw DiskMessageHelper.getMissingParameterException(n, "HWN020002E", string, logTraceHelper);
        }
        if (object.getClass().isArray() && Array.getLength(object) == 0) {
            throw DiskMessageHelper.getMissingParameterException(n, "HWN020002E", string, logTraceHelper);
        }
    }

    public static void assertValidPrimitiveParameterArray(int n, String string, Object object, LogTraceHelper logTraceHelper) throws InvalidParameterException {
        if (object.getClass().isArray() && Array.getLength(object) > 0 && object instanceof long[]) {
            long[] lArray = (long[])object;
            int n2 = 0;
            while (n2 < lArray.length) {
                ParameterChecker.assertValidPrimitiveParameterLong(n, string, lArray[n2], logTraceHelper);
                ++n2;
            }
        }
    }

    public static void assertValidPrimitiveParameterLong(int n, String string, long l, LogTraceHelper logTraceHelper) throws InvalidParameterException {
        if (l < 0L) {
            throw DiskMessageHelper.getInvalidParameterException(n, "HWN020003E", string, logTraceHelper);
        }
    }

    public static void assertValidPrimitiveParameterInt_BitMask(int n, String string, int n2, int n3, LogTraceHelper logTraceHelper) throws InvalidParameterException {
        if (n2 < 0) {
            throw DiskMessageHelper.getMissingParameterException(n, "HWN020003E", string, logTraceHelper);
        }
    }

    public static void assertMandatoryParameterInRange(int n, String string, int n2, int n3, int n4, LogTraceHelper logTraceHelper) throws InvalidParameterException {
        if (n2 < n3 || n2 > n4) {
            throw DiskMessageHelper.getInvalidParameterException(n, "HWN020003E", string, logTraceHelper);
        }
    }

    public static void assertOptionalParameterInRange(int n, String string, int n2, int n3, int n4, LogTraceHelper logTraceHelper) throws InvalidParameterException {
        if (n2 != -1) {
            ParameterChecker.assertMandatoryParameterInRange(n, string, n2, n3, n4, logTraceHelper);
        }
    }

    public static void assertExclusiveMandatoryParameter(int n, String string, Object object, Object object2, String string2, String string3, LogTraceHelper logTraceHelper) throws MissingParameterException {
        if (object == null && object2 == null) {
            throw DiskMessageHelper.getMissingParameterException(n, "HWN020002E", string, logTraceHelper);
        }
        if (object != null && object.getClass().isArray() && Array.getLength(object) == 0) {
            throw DiskMessageHelper.getMissingParameterException(n, "HWN020002E", string2, logTraceHelper);
        }
        if (object2 != null && object2.getClass().isArray() && Array.getLength(object2) == 0) {
            throw DiskMessageHelper.getMissingParameterException(n, "HWN020002E", string3, logTraceHelper);
        }
    }

    public static void assertMandatoryParameterArraySizes(int n, String string, Object object, Object object2, LogTraceHelper logTraceHelper) throws InvalidParameterException {
        if (object.getClass().isArray() && object.getClass().isArray() && Array.getLength(object) != Array.getLength(object2)) {
            throw DiskMessageHelper.getInvalidParameterException(n, "HWN021524E", string, logTraceHelper);
        }
    }

    public static void assertOptionalParameterArraySizes(int n, String string, Object object, Object object2, LogTraceHelper logTraceHelper) throws InvalidParameterException {
        if (object2 != null && object.getClass().isArray() && object2.getClass().isArray() && Array.getLength(object) != Array.getLength(object2)) {
            throw DiskMessageHelper.getInvalidParameterException(n, "HWN021524E", string, logTraceHelper);
        }
    }

    public static void assertVitualizationType(int n, String string, int n2, LogTraceHelper logTraceHelper) throws InvalidParameterException {
        if (n2 < 0 || n2 > 2) {
            throw DiskMessageHelper.getInvalidParameterException(n, "HWN020003E", string, logTraceHelper);
        }
    }

    public static void assertMDisksForVitualizationType(int n, int n2, String[] stringArray, String[] stringArray2, LogTraceHelper logTraceHelper) {
        if (n2 != 0) {
            ParameterChecker.assertMandatoryParameter(n, "SVCMDiskIDs", stringArray, logTraceHelper);
            if (stringArray.length != 1) {
                ParameterChecker.assertMandatoryParameterArraySizes(n, "SVCMDiskGroupIDs, SVCMDiskIDs", stringArray2, stringArray, logTraceHelper);
            }
        }
    }
}

