/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import org.eclipse.aperi.San.gui.DiskArrayAlertLogTableData;
import org.eclipse.aperi.TStorm.gui.DiskAlertLogTableData;
import org.eclipse.aperi.TStorm.gui.EndpointAlertLogTableData;
import org.eclipse.aperi.TStorm.gui.ExternalAlertLogTableData;
import org.eclipse.aperi.TStorm.gui.FabricAlertLogTableData;
import org.eclipse.aperi.TStorm.gui.OSAlertLogTableData;
import org.eclipse.aperi.TStorm.gui.SwitchAlertLogTableData;
import org.eclipse.aperi.TStorm.gui.TapeLibraryAlertLogTableData;
import org.eclipse.aperi.common.MutableByte;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.AlertConditionManager;
import org.eclipse.aperi.constants.metadata.AlertEditorManager;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.AlertLogDDI;
import org.eclipse.aperi.gui.AlertLogDetailDDI;
import org.eclipse.aperi.gui.AlertManager;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.IntToString;
import org.eclipse.aperi.gui.LogViewer;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.ExtAlertLog;
import org.eclipse.aperi.xmsg.MessageLog;

public class AlertLogTable
implements TJCTableMouseInterface,
ActionListener,
GuiRequestor {
    private static DefaultTableCellRenderer stateRenderer = new StateRenderer();
    private static final String CLEAR = "c";
    private static final String DELETE = "d";
    private static final String CLEAR_ALL = "C";
    private static final String DELETE_ALL = "D";
    private static final String REFRESH = "R";
    private static final String VIEW_DETAIL = "V";
    private static final String VIEW_SCRIPT_LOG = "SL";
    private static final String VIEW_JOB_LOG = "JL";
    private static final String EDIT = "E";
    private static final IntToString[] productSelections;
    private static final int[] productToLicenseKey;
    private AlertLogDDI DDI;
    private MegaTable table;
    private BaseTableModel tableData;
    private AlertLogTableAdjuster tableAdjuster;
    private JPanel panel;
    private JComponent bottomHalf;
    private JLabel noDataLabel;
    private JButton clearButton;
    private JButton deleteButton;
    private JButton clearAllButton;
    private JButton deleteAllButton;
    private ExtAlertLog[][] productArray;
    private ExtAlertLog[] array;
    private ExtAlertLog recordsRemaining;
    private boolean requestWasDelete;
    private boolean clearedAll;
    private JPopupMenu menu;
    private JMenuItem viewScriptLogItem;
    private JMenuItem viewJobLogItem;
    private int popupRow;
    private IntToString[] installedProductList;
    private boolean isProperAdmin = false;

    static {
        IntToString[] intToStringArray = new IntToString[4];
        intToStringArray[0] = new IntToString(0, MessageLog.getMessageNoID("STG4175L"));
        intToStringArray[3] = new IntToString(3, MessageLog.getMessageNoID("SAG0005L"));
        productSelections = intToStringArray;
        int[] nArray = new int[4];
        nArray[1] = -1;
        nArray[2] = -1;
        nArray[3] = 9;
        productToLicenseKey = nArray;
    }

    private JMenuItem addMenuItem(String string, String string2) {
        String string3 = MessageLog.getMessageNoID(string);
        JMenuItem jMenuItem = new JMenuItem(string3);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(this);
        this.menu.add(jMenuItem);
        return jMenuItem;
    }

    private static boolean productInstalled(boolean[] blArray, int n) {
        boolean bl = false;
        if (!blArray[n]) {
            return bl;
        }
        int n2 = productToLicenseKey[n];
        switch (n2) {
            case 0: 
            case 1: {
                bl = true;
                break;
            }
            case 9: {
                bl = true;
            }
        }
        return bl;
    }

    public AlertLogTable(AlertLogDDI alertLogDDI) {
        Object object;
        this.DDI = alertLogDDI;
        this.recordsRemaining = null;
        this.noDataLabel = new JLabel(MessageLog.getMessageNoID("STG0020M"));
        this.noDataLabel.setFont(BaseTree.boldFont);
        this.noDataLabel.setForeground(Color.black);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.left = 17;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 10;
        if (this.DDI.requestData.productCode == -1) {
            if (this.DDI.productMask == null) {
                object = new boolean[productToLicenseKey.length];
                Arrays.fill((boolean[])object, true);
            } else if (this.DDI.productMask.length >= productToLicenseKey.length) {
                object = this.DDI.productMask;
            } else {
                object = new boolean[productToLicenseKey.length];
                System.arraycopy(this.DDI.productMask, 0, object, 0, this.DDI.productMask.length);
            }
            int n = 0;
            int n2 = 0;
            while (n2 < productToLicenseKey.length) {
                if (AlertLogTable.productInstalled((boolean[])object, n2)) {
                    ++n;
                }
                ++n2;
            }
            if (n > 1) {
                this.installedProductList = new IntToString[n];
                n = 0;
                n2 = 0;
                while (n2 < productToLicenseKey.length) {
                    if (AlertLogTable.productInstalled((boolean[])object, n2)) {
                        this.installedProductList[n++] = productSelections[n2];
                    }
                    ++n2;
                }
                gridBagConstraints.insets.top = 5;
                gridBagConstraints.insets.bottom = 10;
                gridBagConstraints.gridwidth = 1;
                jPanel.add(Box.createHorizontalStrut(10), gridBagConstraints);
            }
        }
        this.clearButton = new JButton(MessageLog.getMessageNoID("GUI0060L"));
        this.clearButton.setActionCommand(CLEAR);
        this.clearButton.addActionListener(this);
        GuiUtil.setAccessible(this.clearButton, this.clearButton.getText(), this.clearButton.getText());
        jPanel.add((Component)this.clearButton, gridBagConstraints);
        this.deleteButton = new JButton(MessageLog.getMessageNoID("GUI0106L"));
        this.deleteButton.setActionCommand(DELETE);
        this.deleteButton.addActionListener(this);
        GuiUtil.setAccessible(this.deleteButton, this.deleteButton.getText(), this.deleteButton.getText());
        gridBagConstraints.insets.left = 10;
        jPanel.add((Component)this.deleteButton, gridBagConstraints);
        this.clearAllButton = new JButton(MessageLog.getMessageNoID("GUI0061L"));
        this.clearAllButton.setActionCommand(CLEAR_ALL);
        this.clearAllButton.addActionListener(this);
        GuiUtil.setAccessible(this.clearAllButton, this.clearAllButton.getText(), this.clearAllButton.getText());
        jPanel.add((Component)this.clearAllButton, gridBagConstraints);
        this.deleteAllButton = new JButton(MessageLog.getMessageNoID("GUI0062L"));
        this.deleteAllButton.setActionCommand(DELETE_ALL);
        this.deleteAllButton.addActionListener(this);
        GuiUtil.setAccessible(this.deleteAllButton, this.deleteAllButton.getText(), this.deleteAllButton.getText());
        jPanel.add((Component)this.deleteAllButton, gridBagConstraints);
        object = new JButton(MessageLog.getMessageNoID("STG0003L"));
        ((AbstractButton)object).setActionCommand(REFRESH);
        ((AbstractButton)object).addActionListener(this);
        GuiUtil.setAccessible((Component)object, ((AbstractButton)object).getText(), ((AbstractButton)object).getText());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)object, gridBagConstraints);
        this.panel = new JPanel(new GridBagLayout());
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)jPanel, gridBagConstraints);
        this.menu = new JPopupMenu();
        this.addMenuItem("GUI2036L", VIEW_DETAIL);
        this.viewScriptLogItem = this.addMenuItem("GUI0268L", VIEW_SCRIPT_LOG);
        this.viewJobLogItem = this.addMenuItem("GUI0269L", VIEW_JOB_LOG);
        this.bottomHalf = null;
    }

    private void setBottomHalf(JComponent jComponent) {
        if (jComponent == this.bottomHalf) {
            return;
        }
        if (this.bottomHalf != null) {
            this.panel.remove(this.bottomHalf);
        }
        this.bottomHalf = jComponent;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weighty = 1.0;
        if (this.bottomHalf == this.table) {
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
        }
        gridBagConstraints.anchor = 10;
        this.panel.add((Component)this.bottomHalf, gridBagConstraints);
        if (this.DDI.panel != null) {
            this.DDI.show();
        }
    }

    private void rebuild(ExtAlertLog[] extAlertLogArray, boolean bl) {
        JComponent jComponent;
        boolean bl2;
        IGuiMain iGuiMain = GuiManager.getGuiManager().getGuiMain();
        Capabilities capabilities = iGuiMain.getCapabilities();
        this.array = extAlertLogArray;
        this.isProperAdmin = capabilities.isAnyAdmin();
        boolean bl3 = bl2 = this.array != null && this.array.length > 0;
        if (!bl2) {
            jComponent = this.noDataLabel;
        } else {
            switch (this.DDI.requestData.objectType) {
                case 10: {
                    this.tableAdjuster = new DiskAlertLogTableData(this, this.array);
                    break;
                }
                case 78: {
                    this.tableAdjuster = new DiskArrayAlertLogTableData(this, this.array);
                    break;
                }
                case 121: {
                    this.tableAdjuster = new SwitchAlertLogTableData(this, this.array, this.DDI.requestData);
                    break;
                }
                case 114: {
                    this.tableAdjuster = new FabricAlertLogTableData(this, this.array, this.DDI.requestData);
                    break;
                }
                case 129: {
                    this.tableAdjuster = new EndpointAlertLogTableData(this, this.array, this.DDI.requestData);
                    break;
                }
                case 128: {
                    this.tableAdjuster = new ExternalAlertLogTableData(this, this.array, this.DDI.requestData);
                    break;
                }
                case 134: {
                    this.tableAdjuster = new TapeLibraryAlertLogTableData(this, this.array, this.DDI.requestData);
                    break;
                }
                default: {
                    this.tableAdjuster = new OSAlertLogTableData(this, this.array, this.DDI.requestData);
                }
            }
            this.table = new MegaTable();
            this.tableData = (BaseTableModel)((Object)this.tableAdjuster);
            this.table.setRowIcon(10, true);
            this.table.setBaseTableModel(this.tableData);
            this.table.setMouseListener(this);
            this.table.setCellRenderer(MutableByte.class, stateRenderer);
            this.table.setCellRenderer(Date.class, TableCellRenderers.date);
            jComponent = this.table;
        }
        this.clearButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.clearAllButton.setEnabled(bl2 && this.isProperAdmin);
        this.deleteAllButton.setEnabled(bl2 && this.isProperAdmin);
        this.setBottomHalf(jComponent);
    }

    public Component getComponent(ExtAlertLog[][] extAlertLogArray) {
        int n = 0;
        this.productArray = extAlertLogArray;
        int n2 = 0;
        while (n2 < extAlertLogArray.length) {
            n += extAlertLogArray[n2].length;
            ++n2;
        }
        this.array = new ExtAlertLog[n];
        n2 = 0;
        int n3 = 0;
        while (n3 < extAlertLogArray.length) {
            System.arraycopy(extAlertLogArray[n3], 0, this.array, n2, extAlertLogArray[n3].length);
            n2 += extAlertLogArray[n3].length;
            ++n3;
        }
        this.rebuild(this.array, true);
        return this.panel;
    }

    private void submitRequest(ExtAlertLog extAlertLog, String string) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = string;
        request.flags = (byte)4;
        request.requestData = ExtAlertLog.pack(extAlertLog);
        GuiClient.doRequest(this, request);
    }

    private void delete(boolean bl) {
        this.recordsRemaining = null;
        ExtAlertLog extAlertLog = null;
        ExtAlertLog extAlertLog2 = null;
        int n = 0;
        while (n < this.array.length) {
            boolean bl2 = bl || this.table.isRowSelected(n);
            ExtAlertLog extAlertLog3 = this.array[this.table.getDataRow(n)].clone(bl2);
            if (bl2) {
                extAlertLog3.alnExt = extAlertLog;
                extAlertLog = extAlertLog3;
            } else {
                if (extAlertLog2 == null) {
                    this.recordsRemaining = extAlertLog3;
                } else {
                    extAlertLog2.alnExt = extAlertLog3;
                }
                extAlertLog2 = extAlertLog3;
            }
            ++n;
        }
        if (extAlertLog != null) {
            this.clearedAll = bl;
            this.requestWasDelete = true;
            this.submitRequest(extAlertLog, "org.eclipse.aperi.server.handler.server.AlertLogIDHndlr.Delete");
        }
    }

    private void clear(boolean bl) {
        ExtAlertLog extAlertLog = null;
        int n = 0;
        while (n < this.array.length) {
            ExtAlertLog extAlertLog2 = this.array[this.table.getDataRow(n)];
            if (extAlertLog2.alState == 0 && (bl || this.table.isRowSelected(n))) {
                extAlertLog2 = extAlertLog2.clone(true);
                extAlertLog2.alnExt = extAlertLog;
                extAlertLog = extAlertLog2;
            }
            ++n;
        }
        if (extAlertLog != null) {
            this.clearedAll = bl;
            this.requestWasDelete = false;
            this.submitRequest(extAlertLog, "org.eclipse.aperi.server.handler.server.AlertLogIDHndlr.Clear");
        }
    }

    private void recordsCleared() {
        int n = 0;
        while (n < this.array.length) {
            if (this.clearedAll || this.table.isRowSelected(n)) {
                ExtAlertLog extAlertLog = this.array[this.table.getDataRow(n)];
                if (extAlertLog.alState == 0) {
                    AlertManager.alertCleared(extAlertLog);
                    extAlertLog.alState = 1;
                }
            }
            ++n;
        }
    }

    private void invokeEditor() {
        ExtAlertLog extAlertLog = this.array[this.popupRow];
        short s = AlertConditionManager.getClassId(extAlertLog.alAlertCondition);
        if (s < 0) {
            Object[] objectArray = new Object[]{new Integer(extAlertLog.alAlertCondition)};
            String string = MessageLog.getMessageNoTS("GUI2038M", objectArray);
            GuiUtil.displayErrorMessage(string);
            return;
        }
        if (s == 26 && extAlertLog.alProductID == 3) {
            s = 20;
        }
        short s2 = AlertEditorManager.getResourceType(s);
        String string = String.valueOf(extAlertLog.alCreator) + '.' + extAlertLog.getAlName();
        short s3 = 0;
        short s4 = 0;
        CreateOrEditDDI.showEditor(AlertEditorManager.getClass(s), string, extAlertLog.alAlertID, s2, s3, s4, null);
    }

    private void viewLog(String string) {
        ExtAlertLog extAlertLog = this.array[this.popupRow];
        if (string == VIEW_SCRIPT_LOG) {
            new LogViewer(extAlertLog.alScriptComputerID, null, extAlertLog.alScriptLogFile);
        } else {
            new LogViewer(extAlertLog.alComputerID, null, extAlertLog.alJobLogFile);
        }
    }

    public void handleResponse(short s, Response response) {
        if (s <= 4) {
            this.recordsCleared();
            if (this.requestWasDelete) {
                this.rebuild(ExtAlertLog.pack(this.recordsRemaining), false);
            } else {
                if (this.tableData == null) {
                    this.tableData = (BaseTableModel)((Object)this.tableAdjuster);
                }
                this.tableData.fireTableChanged(new TableModelEvent(this.tableData));
                this.clearButton.setEnabled(false);
            }
        }
        this.recordsRemaining = null;
        this.requestWasDelete = false;
        this.clearedAll = false;
        this.table.repaint();
    }

    public boolean select(int n, int n2) {
        return true;
    }

    public void selectionChanged(boolean bl) {
        int[] nArray = this.table.getSelectedRows();
        this.deleteButton.setEnabled(nArray.length > 0 && bl && this.isProperAdmin);
        if (!bl || !this.isProperAdmin) {
            this.clearButton.setEnabled(false);
        } else {
            boolean bl2 = false;
            int n = 0;
            while (!bl2 && n < nArray.length) {
                int n2 = nArray[n++];
                if (this.array[n2].alState != 0) continue;
                bl2 = true;
            }
            this.clearButton.setEnabled(bl2);
        }
    }

    public void doubleClick(int n, int n2) {
        ExtAlertLog extAlertLog = this.array[n];
        AlertLogDetailDDI alertLogDetailDDI = new AlertLogDetailDDI(extAlertLog);
        ((DataDisplayInfo)alertLogDetailDDI).reDisplay();
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
        this.popupRow = n;
        ExtAlertLog extAlertLog = this.array[this.popupRow];
        boolean bl = extAlertLog.alScriptComputerID > 0 && !Util.isEmpty(extAlertLog.alScriptLogFile);
        this.viewScriptLogItem.setEnabled(bl);
        this.viewJobLogItem.setEnabled(!Util.isEmpty(extAlertLog.alJobLogFile));
        this.menu.show(component, n3, n4);
        this.menu.requestFocus();
    }

    public void showDefaultChart(int n) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == REFRESH) {
            this.DDI.submitRequest();
        } else if (string == DELETE) {
            this.delete(false);
        } else if (string == DELETE_ALL) {
            if (GuiUtil.confirmDelete(null)) {
                this.delete(true);
            }
        } else if (string == CLEAR) {
            this.clear(false);
        } else if (string == CLEAR_ALL) {
            this.clear(true);
        } else if (string == VIEW_DETAIL) {
            this.doubleClick(this.popupRow, 0);
        } else if (string == VIEW_SCRIPT_LOG) {
            this.viewLog(string);
        } else if (string == VIEW_JOB_LOG) {
            this.viewLog(string);
        } else if (string == EDIT) {
            this.invokeEditor();
        }
    }

    public void nullReferences() {
        this.productArray = null;
        this.array = null;
        this.tableAdjuster = null;
        if (this.table != null) {
            this.table.nullReferences();
        }
        this.tableData = null;
        if (this.panel != null) {
            this.panel.removeAll();
        }
        this.panel = null;
        this.bottomHalf = null;
        this.table = null;
    }

    private static class StateRenderer
    extends DefaultTableCellRenderer {
        private static Icon exclam;
        private static Icon checked;
        private static Icon blank;

        static {
            URL uRL = StateRenderer.class.getResource("images/exclam.gif");
            exclam = new ImageIcon(uRL);
            uRL = StateRenderer.class.getResource("images/checked.gif");
            checked = new ImageIcon(uRL);
            blank = IconFactory.getBlankIcon(16);
        }

        private StateRenderer() {
        }

        public void setValue(Object object) {
            Icon icon = blank;
            if (object instanceof MutableByte) {
                MutableByte mutableByte = (MutableByte)object;
                switch (mutableByte.value) {
                    case 0: {
                        icon = exclam;
                        break;
                    }
                    case 1: {
                        icon = checked;
                    }
                }
            }
            this.setText(null);
            this.setVerticalAlignment(1);
            this.setHorizontalAlignment(11);
            this.setIcon(icon);
        }
    }

    public static interface AlertLogTableAdjuster {
        public void hideColumns(MegaTable var1);

        public String[] getLabels();

        public int getNumberRows();

        public int getNumberColumns();

        public int[] getRenderers();

        public int[] getHiddenColumns();

        public Object getTableDataItem(int var1, int var2);
    }
}

