/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.AlertProduct;
import org.eclipse.aperi.constants.metadata.AlertConditionManager;
import org.eclipse.aperi.constants.metadata.AlertProductManager;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.Alertable;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.AlertLog;
import org.eclipse.aperi.server.guireq.AlertNameList;
import org.eclipse.aperi.server.guireq.ExtAlertLog;
import org.eclipse.aperi.server.guireq.UserPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlertManager
implements GuiRequestor {
    private static Map<Integer, Integer> firstSubProducts = new HashMap<Integer, Integer>();
    private static Map idMap;
    private static Map<Integer, Map<Integer, Anchor>> historyNodes;
    private static Map<Integer, Anchor> productNodes;
    private static Map<Integer, Anchor> myAlertsNodes;
    private static IGuiMain guiMain;

    static {
        SortedSet<Short> sortedSet = AlertProduct.getValues();
        int n = Collections.max(sortedSet).intValue() + 1;
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            short s = (Short)iterator.next();
            firstSubProducts.put(Integer.valueOf(s), n);
            n += AlertProductManager.getSubproductCount(s);
        }
        idMap = null;
        historyNodes = null;
        productNodes = null;
        myAlertsNodes = null;
        guiMain = GuiManager.getGuiManager().getGuiMain();
    }

    private static void classifyAlert(NameList nameList) {
        nameList.nlState = AlertConditionManager.getFlags(nameList.nlInfo);
        nameList.nlInfo = AlertConditionManager.getResourceType(nameList.nlInfo);
    }

    private static void incrementCounts(Anchor anchor, NameList nameList) {
        if ((nameList.nlState & 1) != 0) {
            ++anchor.nNotBad;
        } else {
            ++anchor.nBad;
        }
    }

    private static void addToIDMap(NameList nameList, MutableInteger mutableInteger) {
        mutableInteger.value = nameList.nlID;
        Anchor anchor = (Anchor)idMap.get(mutableInteger);
        if (anchor == null) {
            mutableInteger = new MutableInteger(mutableInteger.value);
            anchor = new Anchor();
            anchor.ID = mutableInteger.value;
            idMap.put(mutableInteger, anchor);
        }
        AlertManager.incrementCounts(anchor, nameList);
    }

    private static Anchor anchorInArray(Map<Integer, Anchor> map, int n) {
        Anchor anchor = map.get(n);
        if (anchor == null) {
            anchor = new Anchor();
            map.put(n, anchor);
        }
        return anchor;
    }

    private static int subProductIndex(short s, byte by) {
        int n = firstSubProducts.get(s);
        if (n >= 0) {
            n = AlertProductManager.isValidSubproduct(by) ? (n += by) : -1;
        }
        return n;
    }

    private static int subProductIndex(AlertNameList alertNameList) {
        return AlertManager.subProductIndex(alertNameList.nlProductID, alertNameList.nlSubProductID);
    }

    private static void addToHistoryNodes(AlertNameList alertNameList) {
        Anchor anchor = AlertManager.anchorInArray(AlertManager.getNestedAnchorMap(historyNodes, alertNameList.nlProductID), alertNameList.nlInfo);
        AlertManager.incrementCounts(anchor, alertNameList);
        int n = AlertManager.subProductIndex(alertNameList);
        if (n >= 0) {
            anchor = AlertManager.anchorInArray(AlertManager.getNestedAnchorMap(historyNodes, n), alertNameList.nlInfo);
            AlertManager.incrementCounts(anchor, alertNameList);
        }
    }

    private static Map<Integer, Anchor> getNestedAnchorMap(Map<Integer, Map<Integer, Anchor>> map, int n) {
        Map<Integer, Anchor> map2 = map.get(n);
        if (map2 == null) {
            map2 = new HashMap<Integer, Anchor>();
            map.put(n, map2);
        }
        return map2;
    }

    private static void addToProductArray(Map<Integer, Anchor> map, AlertNameList alertNameList) {
        Anchor anchor = AlertManager.anchorInArray(map, alertNameList.nlProductID);
        AlertManager.incrementCounts(anchor, alertNameList);
        int n = AlertManager.subProductIndex(alertNameList);
        if (n >= 0) {
            anchor = AlertManager.anchorInArray(map, n);
            AlertManager.incrementCounts(anchor, alertNameList);
        }
    }

    private static void refreshAnchorArrayMap(Map<Integer, Map<Integer, Anchor>> map, Map<Integer, Map<Integer, Anchor>> map2, Map map3) {
        for (Integer n : map2.keySet()) {
            AlertManager.refreshAnchorArray(AlertManager.getNestedAnchorMap(map, n), map2.get(n), map3);
        }
    }

    private static void refreshAnchorArray(Map<Integer, Anchor> map, Map<Integer, Anchor> map2, Map map3) {
        for (Integer n : map2.keySet()) {
            Anchor anchor = map2.get(n);
            if (anchor == null || anchor.nodeList.isEmpty()) continue;
            Iterator iterator = anchor.nodeList.iterator();
            anchor = map.get(n);
            if (anchor == null) {
                anchor = new Anchor();
                map.put(n, anchor);
            }
            AlertManager.setStates(anchor, iterator, map3);
        }
    }

    private static void setStates(Anchor anchor, Iterator iterator, Map map) {
        while (iterator.hasNext()) {
            Alertable alertable = (Alertable)iterator.next();
            if (map.get(alertable) != null) {
                alertable.reset();
                map.put(alertable, alertable);
            }
            AlertManager.setState(anchor, alertable);
        }
    }

    private static void setState(Anchor anchor, Alertable alertable) {
        alertable.change(anchor.nBad, anchor.nNotBad);
        anchor.nodeList.add(alertable);
    }

    public static void refresh(NameList nameList) {
        Cloneable cloneable;
        MutableInteger mutableInteger = new MutableInteger();
        Map<Integer, Map<Integer, Anchor>> map = historyNodes;
        Map<Integer, Anchor> map2 = productNodes;
        Map<Integer, Anchor> map3 = myAlertsNodes;
        Map map4 = idMap;
        historyNodes = new HashMap<Integer, Map<Integer, Anchor>>();
        myAlertsNodes = new HashMap<Integer, Anchor>();
        productNodes = new HashMap<Integer, Anchor>();
        idMap = new HashMap();
        NameList nameList2 = new NameList();
        nameList2.nlInfo = 1;
        while (nameList != null) {
            AlertManager.classifyAlert(nameList);
            if ((nameList.nlState & 4) != 0) {
                AlertManager.addToIDMap(nameList, mutableInteger);
            }
            if ((nameList.nlState & 2) != 0) {
                nameList2.nlID = nameList.nlID2;
                nameList2.nlState = nameList.nlState;
                AlertManager.addToIDMap(nameList2, mutableInteger);
            }
            if (nameList.nlInfo >= 0) {
                nameList.nlInfo = (short)(nameList.nlInfo + 1);
                AlertManager.addToHistoryNodes((AlertNameList)nameList);
                nameList.nlInfo = 0;
                AlertManager.addToProductArray(productNodes, (AlertNameList)nameList);
            }
            if (nameList.nlName != null) {
                cloneable = (AlertNameList)nameList;
                Anchor anchor = AlertManager.anchorInArray(myAlertsNodes, ((AlertNameList)cloneable).nlProductID);
                AlertManager.incrementCounts(anchor, cloneable);
            }
            nameList = nameList.nlNext;
        }
        if (map4 == null) {
            return;
        }
        cloneable = new HashMap();
        for (Anchor anchor : map4.values()) {
            if (anchor.nodeList.isEmpty()) continue;
            Iterator iterator = anchor.nodeList.iterator();
            mutableInteger.value = anchor.ID;
            anchor = (Anchor)idMap.get(mutableInteger);
            if (anchor == null) {
                anchor = new Anchor();
                anchor.ID = mutableInteger.value;
                idMap.put(mutableInteger, anchor);
                mutableInteger = new MutableInteger();
            }
            AlertManager.setStates(anchor, iterator, cloneable);
        }
        AlertManager.refreshAnchorArrayMap(historyNodes, map, cloneable);
        AlertManager.refreshAnchorArray(productNodes, map2, cloneable);
        AlertManager.refreshAnchorArray(myAlertsNodes, map3, cloneable);
    }

    public static void register(int n, Alertable alertable) {
        MutableInteger mutableInteger = new MutableInteger(n);
        Anchor anchor = (Anchor)idMap.get(mutableInteger);
        if (anchor == null) {
            anchor = new Anchor();
            anchor.ID = mutableInteger.value;
            idMap.put(mutableInteger, anchor);
        }
        AlertManager.setState(anchor, alertable);
    }

    public static void register(short s, short s2, byte by, Alertable alertable) {
        Map<Integer, Anchor> map;
        int n = AlertManager.subProductIndex(s, by);
        if (n >= 0) {
            s = (short)n;
        }
        if (s2 < 0) {
            map = productNodes;
            n = s;
        } else {
            map = AlertManager.getNestedAnchorMap(historyNodes, s);
            n = s2 + 1;
        }
        Anchor anchor = AlertManager.anchorInArray(map, n);
        AlertManager.setState(anchor, alertable);
    }

    public static void register(short s, Alertable alertable) {
        Anchor anchor = AlertManager.anchorInArray(myAlertsNodes, s);
        AlertManager.setState(anchor, alertable);
    }

    private static void clearAlert(Anchor anchor, NameList nameList) {
        int n;
        int n2;
        if ((nameList.nlState & 1) != 0) {
            n2 = 0;
            n = -1;
            if (anchor.nNotBad > 0) {
                --anchor.nNotBad;
            }
        } else {
            n2 = -1;
            n = 0;
            if (anchor.nBad > 0) {
                --anchor.nBad;
            }
        }
        if (!anchor.nodeList.isEmpty()) {
            for (Alertable alertable : anchor.nodeList) {
                alertable.change(n2, n);
            }
        }
    }

    private static void clearMapAlert(MutableInteger mutableInteger, NameList nameList) {
        Anchor anchor = (Anchor)idMap.get(mutableInteger);
        if (anchor != null) {
            AlertManager.clearAlert(anchor, nameList);
        }
    }

    private static void clearArrayAlert(Map<Integer, Anchor> map, int n, NameList nameList) {
        Anchor anchor = map.get(n);
        if (anchor != null) {
            AlertManager.clearAlert(anchor, nameList);
        }
    }

    private static void clearArrayAlertMap(Map<Integer, Map<Integer, Anchor>> map, AlertNameList alertNameList) {
        int n = alertNameList.nlInfo + 1;
        int n2 = AlertManager.subProductIndex(alertNameList.nlProductID, alertNameList.nlSubProductID);
        if (n2 >= 0) {
            AlertManager.clearArrayAlert(AlertManager.getNestedAnchorMap(map, n2), 0, alertNameList);
            if (n > 0) {
                AlertManager.clearArrayAlert(AlertManager.getNestedAnchorMap(map, n2), n, alertNameList);
            }
        }
        AlertManager.clearArrayAlert(AlertManager.getNestedAnchorMap(map, alertNameList.nlProductID), 0, alertNameList);
        if (n > 0) {
            AlertManager.clearArrayAlert(AlertManager.getNestedAnchorMap(map, alertNameList.nlProductID), n, alertNameList);
        }
    }

    public static void alertCleared(AlertLog alertLog) {
        AlertNameList alertNameList = new AlertNameList();
        alertNameList.nlID = alertLog.alResourceID;
        alertNameList.nlID2 = alertLog.alComputerID;
        alertNameList.nlInfo = alertLog.alAlertCondition;
        alertNameList.nlProductID = (short)alertLog.alProductID;
        alertNameList.nlSubProductID = alertLog.alDbmsType;
        AlertManager.classifyAlert(alertNameList);
        if (alertNameList.nlInfo < 0) {
            return;
        }
        MutableInteger mutableInteger = new MutableInteger();
        if ((alertNameList.nlState & 4) != 0) {
            mutableInteger.value = alertNameList.nlID;
            AlertManager.clearMapAlert(mutableInteger, alertNameList);
        }
        if ((alertNameList.nlState & 2) != 0) {
            mutableInteger.value = alertNameList.nlID2;
            AlertManager.clearMapAlert(mutableInteger, alertNameList);
        }
        AlertManager.clearArrayAlertMap(historyNodes, alertNameList);
        AlertManager.clearArrayAlert(productNodes, alertLog.alProductID, alertNameList);
        if (alertLog instanceof ExtAlertLog && ((ExtAlertLog)alertLog).alDbInstance != null) {
            int n = AlertManager.subProductIndex(alertNameList.nlProductID, alertNameList.nlSubProductID);
            AlertManager.clearArrayAlert(productNodes, n, alertNameList);
        }
        if (alertLog.alNotifyUser != null) {
            AlertManager.clearArrayAlert(myAlertsNodes, alertLog.alProductID, alertNameList);
        }
    }

    private static boolean anyToDisplay(Map<Integer, Anchor> map) {
        Iterator<Anchor> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            if (Anchor.getState(iterator.next()) == 0) continue;
            return true;
        }
        return false;
    }

    public static boolean anyToDisplayAtLogin() {
        UserPreferences userPreferences = guiMain.getUserPrefs();
        byte by = userPreferences.showLoginAlerts;
        if (by == 0) {
            return false;
        }
        return by == 2 ? AlertManager.anyToDisplay(productNodes) : AlertManager.anyToDisplay(myAlertsNodes);
    }

    private AlertManager() {
    }

    public static void refreshAlerts() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.server.RefreshAlertsHndlr";
        request.flags = (byte)4;
        AlertManager alertManager = new AlertManager();
        GuiClient.doRequest(alertManager, request);
    }

    @Override
    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        NameList nameList = (NameList)response.responseData;
        AlertManager.refresh(nameList);
    }

    private static class Anchor {
        public int ID;
        public short productCode;
        public int nNotBad;
        public int nBad;
        public List nodeList = new LinkedList();

        private short getObjState() {
            if (this.nBad > 0) {
                return -1;
            }
            if (this.nNotBad > 0) {
                return 1;
            }
            return 0;
        }

        public static short getState(Anchor anchor) {
            if (anchor == null) {
                return 0;
            }
            return anchor.getObjState();
        }
    }
}

