/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.xmsg.MessageLog;

public class BaseTreeNode
extends DefaultMutableTreeNode
implements PopupMenuListener {
    public boolean expandBranchMenu = false;
    public boolean collapseBranchMenu = false;
    public int expandBranch = 0;
    public boolean selectable = true;
    public int batchSortNumber = 777;
    public Color nodeColor = Color.black;
    public DataDisplayInfo ddi;
    private static JPopupMenu popup = null;
    private static JMenuItem collapseAll = new JMenuItem(MessageLog.getMessageNoID("GUI0040L"));
    private static JMenuItem expandAll = new JMenuItem(MessageLog.getMessageNoID("GUI0064L"));
    private static JMenuItem printSubtree = new JMenuItem(MessageLog.getMessageNoID("GUI5101L"));
    private static BaseTreeNode popupNode;
    private static TreePath popupPath;
    protected static IGuiMain guiMain;
    protected Capabilities capabilities = guiMain.getCapabilities();

    static {
        guiMain = GuiManager.getGuiManager().getGuiMain();
        collapseAll.setToolTipText(MessageLog.getMessageNoID("GUI0041T"));
        expandAll.setToolTipText(MessageLog.getMessageNoID("GUI0065T"));
        printSubtree.setToolTipText(MessageLog.getMessageNoID("GUI5102T"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == collapseAll) {
                    guiMain.getBaseTree();
                    BaseTree.pBaseTree.collapseBranch(BaseTree.popupNode);
                } else if (actionEvent.getSource() == expandAll) {
                    guiMain.getBaseTree();
                    BaseTree.popupNode.expandBranch(1);
                } else if (actionEvent.getSource() == printSubtree) {
                    guiMain.getBaseTree();
                    guiMain.printTree(BaseTree.popupNode);
                }
            }
        };
        collapseAll.addActionListener(actionListener);
        expandAll.addActionListener(actionListener);
        printSubtree.addActionListener(actionListener);
    }

    public BaseTreeNode() {
    }

    public BaseTreeNode(Object object) {
        super(object);
    }

    public BaseTreeNode(Object object, boolean bl) {
        super(object, bl);
    }

    public void render(DefaultTreeCellRenderer defaultTreeCellRenderer, BaseTree baseTree, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        defaultTreeCellRenderer.setFont(BaseTree.boldFont);
    }

    public void expand(TreeExpansionEvent treeExpansionEvent) {
    }

    public void collapse(TreeExpansionEvent treeExpansionEvent) {
    }

    void expandBranch(int n) {
        this.expand(null);
        BaseTree.pBaseTree.expandPath(new TreePath(this.getPath()));
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            BaseTreeNode baseTreeNode = (BaseTreeNode)enumeration.nextElement();
            if (n > baseTreeNode.expandBranch) continue;
            baseTreeNode.expandBranch(n + 1);
        }
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        this.showPopupMenu(this.getPopupMenu(), mouseEvent);
    }

    public void showPopupMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
        boolean bl = false;
        if (jPopupMenu.getComponentCount() > 0) {
            bl = true;
        }
        if (this.collapseBranchMenu) {
            if (bl) {
                jPopupMenu.addSeparator();
                bl = false;
            }
            jPopupMenu.add(collapseAll);
        }
        if (this.expandBranchMenu) {
            if (bl) {
                jPopupMenu.addSeparator();
                bl = false;
            }
            jPopupMenu.add(expandAll);
        }
        if (bl) {
            jPopupMenu.addSeparator();
        }
        jPopupMenu.add(printSubtree);
        if (mouseEvent != null && jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            if (!mouseEvent.isPopupTrigger()) {
                jPopupMenu.requestFocus();
            }
        }
    }

    public JPopupMenu getPopupMenu() {
        popup = new JPopupMenu();
        popup.addPopupMenuListener(this);
        return popup;
    }

    public void select(TreeSelectionEvent treeSelectionEvent) {
        this.selectable = true;
    }

    public void addSorted(BaseTreeNode baseTreeNode) {
        String string = baseTreeNode.getUserObject().toString();
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            BaseTreeNode baseTreeNode2 = (BaseTreeNode)this.getChildAt(n2);
            if (string.compareTo(baseTreeNode2.getUserObject().toString()) < 0) break;
            ++n2;
        }
        BaseTree.MyTree.insertNodeInto(baseTreeNode, this, n2);
    }

    public JPopupMenu getPopupMenuForButtons() {
        return new JPopupMenu();
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        BaseTree.pBaseTree.setSelectionPath(BaseTree.selectedPath);
        BaseTree.pBaseTree.requestFocus();
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        BaseTree.pBaseTree.setSelectionPath(BaseTree.selectedPath);
        BaseTree.pBaseTree.requestFocus();
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }
}

